<?xml version="1.0"  encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sx="http://memtext.de">
<xsl:template name="tableJavascript">
<script language="Javascript" type="text/javascript" src="/superx/xml/js/jquery-2.1.1.min.js" />
<script language="JavaScript" type="text/javascript">
    function getTid(){
<xsl:choose>
<xsl:when test="/ergebnisse/@isMakro='true'">
<xsl:text>tid=</xsl:text><xsl:value-of select="/ergebnisse/makro/@id" /><xsl:text>;
</xsl:text>
</xsl:when>
<xsl:otherwise> 
<xsl:text>tid=</xsl:text><xsl:value-of select="/ergebnisse/ergebnis/maskenname/@id" /><xsl:text>;
</xsl:text>
</xsl:otherwise>
</xsl:choose>
return tid;
}

<xsl:call-template name="jsHis1Pinger" />

function jsDisableInput(datei) {
 var dateiendungArray = datei.split(".");
 var dateiendung = dateiendungArray[dateiendungArray.length - 1];
 if(dateiendung=="jrxml") {
  document.Weiterverarbeitung.jr_contenttype.disabled=false;
 }
 else {
  document.Weiterverarbeitung.jr_contenttype.disabled=true;
 }
}

</script>
<script language="JavaScript" type="text/javascript" src="/superx/xml/js/memtext/sx_functions.js"></script>
 <script language="JavaScript" type="text/javascript">
			var isTreeTable=false;
			<xsl:if test="/ergebnisse/@isMakro!='true' and /ergebnisse/ergebnis/ergebniselement/sqlerg/@istreetable='true'">
			isTreeTable=true;
			</xsl:if>
</script>


<!-- start normale Abfragen - nicht makros dojo/ggfs. Treetable-->
<xsl:if test="/ergebnisse/@isMakro!='true'"> 
 <script language="JavaScript" type="text/javascript">
 djConfig = { 
				bindEncoding: "UTF-8",
				isDebug: false,
				debugAtAllCosts:false,
				debugContainerId:"dojoDebug"
			};
			</script>
<script language="JavaScript" type="text/javascript" src="/superx/xml/js/dojo/dojo.js"></script>
 

 <script language="JavaScript" type="text/javascript">
           dojo.require("dojo.widget.Dialog");
            dojo.require("dojo.widget.Button");
	    dojo.require("dojo.event.*");
			dojo.require("dojo.io.*");
			dojo.require("dojo.widget.*");
			dojo.require("dojo.html.selection");
			dojo.require("dojo.widget.ContentPane");
			dojo.require("dojo.widget.TreeV3");
			dojo.require("dojo.widget.TreeNodeV3");
			dojo.require("dojo.widget.TreeBasicController");
			dojo.require("dojo.widget.TreeSelectorV3");
			dojo.require("dojo.widget.TreeEmphasizeOnSelect");
			dojo.require("dojo.widget.Tooltip");
			dojo.require("dojo.widget.DropdownDatePicker");
			dojo.registerModulePath("memtext", "../memtext");
			dojo.require("memtext.widget.MemTree");
			dojo.require("memtext.widget.TreeLoadingControllerSx");
			
			dojo.hostenv.writeIncludes();
			dojo.hostenv.writeIncludes();
			var configdlg;
			var spaltenliste,spaltentrash;
			

</script>
<!-- javascript array mit Feldern - bei Makros ist Feld-XML noch nicht drin-->
 <xsl:text disable-output-escaping="yes"><![CDATA[<script type="text/javascript">

 // für Druck ohne Menü
function printDiv(divName) {
 var printContents = document.getElementById(divName).innerHTML;
 w=window.open();
 w.document.write(printContents);
 w.print();
 w.close();
}
 
       var felder = new Array();]]></xsl:text>
       <xsl:for-each select="/ergebnisse/ergebnis/felder/feld">
       <xsl:text>felder[</xsl:text><xsl:value-of select="position()" /><xsl:text>]= new Object();
       felder[</xsl:text><xsl:value-of select="position()" /><xsl:text>]["htmlname"]='</xsl:text><xsl:value-of select="@varname"/><xsl:text>';
       felder[</xsl:text><xsl:value-of select="position()" /><xsl:text>]["name"]='</xsl:text><xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="@varname"/></xsl:with-param></xsl:call-template><xsl:text>';
   	felder[</xsl:text><xsl:value-of select="position()" /><xsl:text>]["cb_name"]='</xsl:text><xsl:call-template name="umlaut_urlencode"><xsl:with-param name="s1"><xsl:value-of select="@varname"/></xsl:with-param></xsl:call-template><xsl:text>';
	</xsl:text>
	<!-- in sql-variablen könnte auch " vorkommen als %22 codieren-->
	<xsl:variable name="quot">"</xsl:variable>
       <xsl:variable name="r"><xsl:value-of disable-output-escaping="yes" select="value"/></xsl:variable>
	<xsl:text>felder[</xsl:text><xsl:value-of select="position()" /><xsl:text>]["value"]="</xsl:text>
       <xsl:call-template name="search_replace">
	<xsl:with-param name="string" select="$r"/>
	<xsl:with-param name="search" select="$quot" />
	<xsl:with-param name="replace" select="'%22'" />
</xsl:call-template><xsl:text>";       
       </xsl:text>
      </xsl:for-each>
      var stylesheetcontenttype = new Array();
       <xsl:for-each select="/ergebnisse/stylesheets/stylesheet">
      stylesheetcontenttype['<xsl:value-of select="filename"/>'] = '<xsl:value-of select="contenttype"/>';
      </xsl:for-each>
 <xsl:text disable-output-escaping="yes"><![CDATA[</script>]]></xsl:text>




<!-- start xy-->
 <script language="JavaScript" type="text/javascript">
 <xsl:text>headers=eval("([</xsl:text>
<xsl:for-each select="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/header[not (starts-with(f_name,'hidden'))]">
<xsl:text>{key:'</xsl:text><xsl:value-of select="f_name"/><xsl:text>',name:'</xsl:text>
    <xsl:call-template name='json_adapt'>
    <xsl:with-param name="string" select="wert" />
    </xsl:call-template><xsl:text>'}</xsl:text>
 <xsl:if test="position() != last()"><xsl:text>,</xsl:text></xsl:if>
</xsl:for-each>
<xsl:text>])");
var count=1; 
<![CDATA[for (var i=0;i<headers.length;i++) if (headers[i].name.replace(/\s+$/,"")=='') {headers[i].name='Leerspalte '+count;count++;}]]> 
</xsl:text>
<xsl:text>complete_headers=eval("([</xsl:text>
<!--MB 04/2010 versteckte Spalten nicht -->
<xsl:for-each select="/ergebnisse/ergebnis/ergebniselement/sqlerg/complete_headers/header[not (starts-with(f_name,'hidden'))]">
<xsl:text>{key:'</xsl:text><xsl:value-of select="f_name"/><xsl:text>',name:'</xsl:text>
       <xsl:call-template name='json_adapt'>
    <xsl:with-param name="string" select="wert" />
    </xsl:call-template><xsl:text>'}</xsl:text>
 <xsl:if test="position() != last()"><xsl:text>,</xsl:text></xsl:if>
</xsl:for-each>
<xsl:text>])");</xsl:text>
 var count=1; 
<![CDATA[for (var i=0;i<complete_headers.length;i++) if (complete_headers[i].name.replace(/\s+$/,"")=='') {complete_headers[i].name='Leerspalte '+count;count++;}]]> 

function init(e) {
configdlg = dojo.widget.byId("configdlg");
spaltenliste=document.getElementById('spaltenliste');
//spaltentrash=document.getElementById('spaltentrash');
new dojo.dnd.HtmlDropTarget(spaltenliste, ["spaltenobjekt"]);
//new dojo.dnd.HtmlDropTarget(document.getElementById('spaltentrash'), ["spaltenobjekt"]);

document.getElementById('progressbar').style.display="none";
}
dojo.addOnLoad(init);

<!-- start showConfig -->
function showConfig()
{
<xsl:choose>
<xsl:when test="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/@hasAggregationHeaders='true'">
alert("Konfiguration bei diesem komplexen Layout nicht moeglich");
</xsl:when>
<xsl:otherwise>
//Spaltenreihenfolge
while (spaltenliste.hasChildNodes())
spaltenliste.removeChild(spaltenliste.childNodes[0]);
//while (spaltentrash.hasChildNodes()) spaltentrash.removeChild(spaltentrash.childNodes[0]);
//var newLI = document.createElement("li"); newLI.appendChild(document.createTextNode("nicht dargestellte Spalten")); spaltentrash.appendChild(newLI);
<![CDATA[
for (var i=0;i<complete_headers.length;i++)
{
var newLI = document.createElement("li");
newLI.setAttribute("key",complete_headers[i].key);
 spaltenliste.appendChild(newLI);

 var newLIText = document.createTextNode(complete_headers[i].name+"  ");
  var b = document.createElement ("b");
  b.setAttribute("style","cursor:pointer;");
  var sp= document.createElement("span");
  b.appendChild(sp);
  sp.appendChild(newLIText);
 newLI.appendChild(b);
var cb = document.createElement("input");
cb.type = "checkbox";
cb.name = "checkboxHeader"+i;
cb.id=  "checkboxHeader"+i;
var vis=false; 
for (var i2=0;i2<headers.length;i2++)
{
 if (complete_headers[i].key==headers[i2].key) vis=true;
}
cb.checked = cb.defaultChecked=vis;
 newLI.appendChild(cb);
 newLI.appendChild(document.createTextNode("anzeigen"));
 }
var lis = document.getElementById('spaltenliste').getElementsByTagName("li");
for(var x=0; x<lis.length; x++){
new dojo.dnd.HtmlDragSource(lis[x], "spaltenobjekt");
}
]]>
//Spaltensortierung
var sortierspalten=document.getElementById('sortierspalten');
while (sortierspalten.hasChildNodes()) sortierspalten.removeChild(sortierspalten.childNodes[0]);
<![CDATA[
if (!isTreeTable){
for (var i=0;i<complete_headers.length&&i<5;i++)
{
var lbl=document.createElement("label");
lbl.innerHTML=(i+1)+".";
sortierspalten.appendChild(lbl);
var newSelect = document.createElement("select");
newSelect.id="sortcol"+i;
newSelect.options[0]=new Option("","nocol_selected");
for (var i2=0;i2<complete_headers.length;i2++)
 {newSelect.options[i2+1]=new Option(complete_headers[i2].name,complete_headers[i2].key);}
sortierspalten.appendChild(newSelect);
var asc=document.createElement("select");
asc.id = "sortcol"+i+"-asc"; 
asc.options[0]=new Option("aufsteigend","-A");
asc.options[1]=new Option("absteigend","-D");
sortierspalten.appendChild(asc);
sortierspalten.appendChild(document.createElement("br"));
 }
 }
]]>

configdlg.show();
</xsl:otherwise>
</xsl:choose>
}
<!-- end show config-->
<!-- start tableReload-->
function tableReload(colsetParam,colsortParam)
{
document.getElementById('progressbar').style.display="";
 <xsl:text>var callurl="/superx/servlet/SuperXmlTabelle</xsl:text>
 <!--<xsl:if test="/ergebnisse/@jsessionid!=''">;jsessionid=<xsl:value-of select="/ergebnisse/@jsessionid"/></xsl:if>-->
 <xsl:text>?tid=</xsl:text><xsl:value-of select="/ergebnisse/ergebnis/ergebniselement/@id"/>
 <xsl:text><![CDATA[&navi=true&stylesheet=tabelle_html.xsl&reuseresult=true&colset=";]]></xsl:text>
  <![CDATA[
   if (colsetParam=='restore')
 callurl+='restore';
 else
 {
 var lis = document.getElementById('spaltenliste').getElementsByTagName("li");

for(var x=0; x<lis.length; x++){
 if (lis[x].getElementsByTagName('input')[0].checked)
 {
  for (var i=0;i<complete_headers.length;i++)
   if (complete_headers[i].key==lis[x].getAttribute("key")) callurl+=escape(complete_headers[i].key);
     if (x<(lis.length-1)){ callurl+="%7C";}
  }
 }

}
if (!isTreeTable)
{
callurl+='&colsort=';
 if (colsortParam=='restore')
 callurl+='restore';
 else
 {

 for (var i=0;i<complete_headers.length&&i<5;i++)
 {
 
 var sortcol=document.getElementById('sortcol'+i);
 var sortcolasc=document.getElementById('sortcol'+i+'-asc');
 var sel=sortcol.options[sortcol.selectedIndex].value;
 if (i==0&&sel!='nocol_selected') callurl+=sel+sortcolasc.options[sortcolasc.selectedIndex].value;
 if (i>0&&sel!='nocol_selected') callurl+="%7C"+sel+sortcolasc.options[sortcolasc.selectedIndex].value;
 }
 }
 }
 ]]>
 ;
self.location=callurl;
}
<!-- end table reload -->

	</script>
	

	<!-- end dojo-->
<!-- start treetable -->
<xsl:if test="/ergebnisse/ergebnis/ergebniselement/sqlerg/@istreetable='true'">
<script type="text/javascript" src="/superx/xml/js/treetable.js"></script>
 <script type="text/javascript">
    treetable_callbacks['eventRowStateChanged'] = 'treetable_eventRowChanged';
    
    function treetable_eventRowChanged(rowId, state) {
    try{
    //normalerweise ist Grafik in erster Spalte, kann aber auch 2. sein
    //var row=document.getElementById(rowId); //macht im FF plötzlich Ärger
    //dojo.debug("rowid:"+rowId);
    var row=document.getElementById(rowId);
    //dojo.debug("row"+row);
    var tds= row.getElementsByTagName('td');
    //dojo.debug("tds:"+tds);
    //todo komisch hier läuft was schief??!
    //dojo.debug("tds length"+tds.length);
    var td0=tds[0]
     var td0img=  td0.getElementsByTagName('img');
     if (td0img.length>0) img=td0img[0];
     else
   { 
   tds=row.getElementsByTagName('td');
   //dojo.debug("tds :"+tds);
    //dojo.debug("tds length"+tds.length);
    var td1=tds[1];
    var td1img=  td1.getElementsByTagName('img');
    
   if (td1img.length>0) img = td1img[0];
   }
    
      if (state == 1) {
        img.src = '/superx/xml/tree_minus_rect.svg';
      } else {
        img.src = '/superx/xml/tree_plus_rect.svg';
      }
      }
      catch (e) {
      }
      return (true);
    }  
  </script>
<script type="text/javascript">
         		function ajaxNodeToggle(nodeid, internalrowno)
			{
			
			//if children already loaded, no ajax request necessary
			//dojo.debug(document.getElementById(nodeid+"_0"));
			if (!document.getElementById(nodeid+"_0"))
			{
			document.getElementById('progressbar').style.display="";
			<xsl:text>var callurl="/superx/servlet/SuperXmlTabelle</xsl:text>
<!-- <xsl:if test="/ergebnisse/@jsessionid!=''">;jsessionid=<xsl:value-of select="/ergebnisse/@jsessionid"/></xsl:if>-->
 <xsl:text>?tid=</xsl:text><xsl:value-of select="/ergebnisse/ergebnis/ergebniselement/@id"/><xsl:text>";
 </xsl:text>
			<![CDATA[
			callurl+="&treetableid="+nodeid+"&getKidRows="+internalrowno;
			]]>
			 dojo.io.bind({url:callurl,encoding: "ISO-8859-1",method: "get",
			       handler: function(type,data,evt)
			       {
			      // dojo.debug(data);
			           document.getElementById('progressbar').style.display="none";
			     if (type=='error') {
			     msg='Fehler beim Lesen der Daten!\n';
			     if (data.message) msg+=data.message;
			     else msg+=data.error;
					       alert(msg);
					       //dojo.debugDeep(data);
			       }
				       else
				      {
				      
			var help=document.createElement("div");
			help.innerHTML=data;
			  var pos=document.getElementById(nodeid).sectionRowIndex;
			  //dojo.debug("pos: "+pos);
			 var newrows=help.getElementsByTagName("tr");
			   <![CDATA[
			for (i=0;i<newrows.length;i++)
			{
			
			var newrow=document.getElementById("table1").tBodies[0].insertRow(pos+i+1);
			newrow.id=nodeid+"_"+i;
			//IE kann nicht in TR-innerHTML schreiben
			//newrow.innerHTML=newrows[i].innerHTML;
			for (i2=0;i2<newrows[i].attributes.length;i2++)
			{
			  newrow.setAttribute(newrows[i].attributes[i2].name,newrows[i].getAttribute(newrows[i].attributes[i2].name));
			}
			//fuck IE
			newrow.setAttribute("className", newrows[i].getAttribute("className"));
			   for (i2=0;i2<newrows[i].cells.length;i2++)
			   {
			    newcell=newrow.insertCell(i2);
			    newcell.innerHTML=newrows[i].cells[i2].innerHTML;
			    //Attribut wie class wird nicht durch innerHTML übernommen
			    for (i3=0;i3<newrows[i].cells[i2].attributes.length;i3++)
			    {
			    newcell.setAttribute(newrows[i].cells[i2].attributes[i3].name,newrows[i].cells[i2].getAttribute(newrows[i].cells[i2].attributes[i3].name));
			    }
			    //fuck IE
			    newcell.setAttribute("className", newrows[i].cells[i2].getAttribute("className"));
			   }
			}
			treetable_toggleRow(nodeid,1,1);
			treetable_eventRowChanged(nodeid, 1);
			if (window.xthf) window.xthf.init();
			 document.getElementById('progressbar').style.display="none";
				 ]]>			
			          <xsl:if test="/ergebnisse/@hisinone_active!='true'">tableRowHeaderSticky(<xsl:value-of select="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/@fixed_column_count"/>);</xsl:if>
	            }
	          }
	          }
			       );
			
			       }
			       else //kein Nachladen per Dojo nötig
			       {
			          treetable_toggleRow(nodeid);
			          <xsl:if test="/ergebnisse/@hisinone_active!='true'">tableRowHeaderSticky(<xsl:value-of select="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/@fixed_column_count"/>);</xsl:if>
				 //  treetable_zuklappen(nodeid);
				//   var starttime=(new Date).getTime();
				 //   while (starttime+400>(new Date).getTime()){};
				 //   treetable_toggleRow(nodeid,-1,-1);
				   }
	  if (window.xthf) window.xthf.init();
	 //dojo.debugDeep(window.xthf);
	
			       }
			      
			       </script>
			
 
</xsl:if>
<!-- end treetable-->

 <!-- start Lesezeichen/applyMerkmale-->
	<script language="JavaScript" type="text/javascript">

<!-- von Lesezeichen oder template Merkmale eintragen 
geht nur für normale Masken da Javascript-array für Felder korrekt gefüllt sein muss
anders definiert als in maske_html, muss genauso heißen, damit allgemeine Vorlage sowohl masken als auch bei Tabellen greifen 
   -->	
function applyMerkmale(merkmale)
{
<xsl:text><![CDATA[url=location.protocol+'//'+location.host+"/superx/servlet/SuperXmlTabelle";]]>
</xsl:text>
<!-- <xsl:if test="/ergebnisse/@jsessionid!=''"><xsl:text>url+=';jsessionid=</xsl:text><xsl:value-of select="/maske/@jsessionid"/><xsl:text>';
</xsl:text></xsl:if>-->
<xsl:text>url+="?tid="+getTid();</xsl:text>
<xsl:if test="/ergebnisse/@MandantenID!='default'">
<xsl:text><![CDATA[url+="&MandantenID=]]></xsl:text><xsl:value-of select="/ergebnisse/@MandantenID"/><xsl:text>";</xsl:text>
</xsl:if>
var merkmale2=merkmale.replace(/n:'/g,'n:"');
var merkmale3=merkmale2.replace(/',k:'/g,'",k:"');
var merkmale4=merkmale3.replace(/'}/g,'"}');
var merkmale5=merkmale4.replace(/',sichtparam:'/g,'",sichtparam:"');
var merkmale6=merkmale5.replace(/',standparam:'/g,'",standparam:"');
var m=purgeval(merkmale6);
<![CDATA[
for (i=0;i<m.length;i++)
{
url+="&"+getEncoded(m[i].n)+"="+getEncoded(m[i].k);
if (m[i].sichtparam) url+="&"+getEncoded(m[i].n)+"-Sicht="+getEncoded(m[i].sichtparam);
if (m[i].standparam) url+="&"+getEncoded(m[i].n)+"-Stand="+m[i].standparam;
}
]]>
<!--falls ein Feld nicht als Merkmal belegt ist und es für ein Feld auf der Maske eine Auswahl gibt, diese übernehmen-->
<![CDATA[
for(var i1=1;i1<= felder.length-1; i1++)
{
var merkmalvorhanden=false;
for (i=0;i<m.length;i++)
{
if (getEncoded(m[i].n)==getEncoded(felder[i1]["htmlname"])) merkmalvorhanden=true;
}
if (!merkmalvorhanden) 
  { 
   var val=felder[i1]["value"];
   url+="&"+getEncoded(felder[i1]["htmlname"])+"="+getEncoded(val);
 }
}
]]>
<xsl:if test="/ergebnisse/@isMakro!='true'">
<xsl:if test="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/@colset!=''">
<xsl:text><![CDATA[url+="&colset=]]></xsl:text><xsl:value-of select="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/@colset"/><xsl:text>";
</xsl:text>
</xsl:if>
<xsl:if test="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/@colsort!=''">
<xsl:text><![CDATA[url+="&colsort=]]></xsl:text><xsl:value-of select="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/@colsort"/><xsl:text>";
</xsl:text>
</xsl:if>
</xsl:if>
//dojo.debug(url);
document.getElementById('progressbar').style.display="";
location.href=url;
}
<!-- für Zurück-Button bei normalen Abfragen und Lesezeichen
-->

function getParams(method) <!--direkt für Zurückbutton, ohne Speicherung als Bookmarklet-->
{
// check for fieldsep argument
var fieldsep = '&amp;'; // default
var params="";
//alert("getparams - method: " + method);
if (method!='direkt') params+="p=[";

<xsl:for-each select="/ergebnisse/ergebnis/felder/feld">
    <xsl:if test="@varname!='##line##'">
    <xsl:if test="value!='' and value!='null' and @art!='8' and @art!='13'"> <!-- bei Duisburger Sichten vorgekommen-->
    if (method!='direkt') 
     <xsl:text>params+="{\"n\":\"</xsl:text><xsl:value-of select="@varname"/><xsl:text>\",\"k\":\"</xsl:text>
     <xsl:value-of select="value"/><xsl:text>\"},";
       </xsl:text>
     else
       <xsl:text><![CDATA[params+=fieldsep+getEncoded("]]></xsl:text><xsl:value-of select="@varname"/><xsl:text>")+"="+getEncoded("</xsl:text><xsl:value-of select="value"/><xsl:text>");
   </xsl:text>

   

   <!-- Probleme im IE wenn kleiner als, Prozent oder sowas vorkommt 
   title+=" </xsl:text>
   <xsl:choose>	<xsl:when test="caption_short!= '' and caption_short != 'null'"><![CDATA[]]><xsl:value-of select="caption_short" /><![CDATA[]]>
	</xsl:when>
	<xsl:otherwise>	<xsl:value-of select="@varname" />	</xsl:otherwise>	</xsl:choose><xsl:text>: </xsl:text><xsl:value-of select="value"/><xsl:text>";
    </xsl:text>
   -->
      </xsl:if>
<!-- MB Stand und Sicht in Lesezeichen -->
  <xsl:if test="@stand!=''">
  <xsl:text>var stand="</xsl:text><xsl:value-of select="@stand"/><xsl:text>";
  </xsl:text>

  if (<![CDATA[stand&&isDate(stand)&&!isToday(stand)]]>) <!-- wenn Stand today ist, braucht er nicht in bookmarklet noch in zurückbutton-->
  {
  if (method!='direkt')
    <xsl:text>params+="{\"n\":\"</xsl:text><xsl:value-of select="@varname"/><xsl:text>-Stand\",\"k\":\"</xsl:text><xsl:value-of select="@stand"/><xsl:text>\"},";
    </xsl:text>
    else
       <xsl:text><![CDATA[params+=fieldsep+"]]></xsl:text><xsl:value-of select="@varname"/><xsl:text>"+"-Stand=</xsl:text><xsl:value-of select="@stand"/><xsl:text>";
   </xsl:text> 
   }
  </xsl:if>
  <xsl:if test="sicht/@name_intern!=''">
    if (method!='direkt')
   <xsl:text>params+="{\"n\":\"</xsl:text><xsl:value-of select="@varname"/><xsl:text>-Sicht\",\"k\":\"</xsl:text><xsl:value-of select="sicht/@name_intern"/><xsl:text>\"},";
   </xsl:text>
   else
    <xsl:text><![CDATA[params+=fieldsep+"]]></xsl:text><xsl:value-of select="@varname"/><xsl:text>"+"-Sicht="+"</xsl:text><xsl:value-of select="sicht/@name_intern"/><xsl:text>";
   </xsl:text> 
  </xsl:if>
    </xsl:if>
 </xsl:for-each>
 <!-- bei Methode direkt auch -leer- uebergeben -->
 <xsl:for-each select="/ergebnisse/ergebnis/completefields/feld"> 
 <xsl:if test="(value='' or value='null') and @art!='8' and @art!='13'">
        <xsl:text><![CDATA[ if (method=='direkt') params+="&"+getEncoded("]]></xsl:text><xsl:value-of select="@varname"/><xsl:text>")+"=--leer--";</xsl:text>
      </xsl:if>
 </xsl:for-each>
 
if (method!='direkt') params=params.substring(0,params.length-1)+"]";//letztes Komma überschreiben
//alert(params);

return params;
}

<!-- Tabelle_esezeichen erstellen - bei Makros ist dojo zu aufwändig-->
function lesezeichen_erstellen()
{
params=getParams();
<xsl:choose>
<xsl:when test="/ergebnisse/@isMakro='true'">
title='Tab <xsl:value-of select="/ergebnisse/makro/name" />';
</xsl:when>
<xsl:otherwise>
title='Tab <xsl:value-of select="/ergebnisse/ergebnis/maskenname"/>';
<xsl:if test="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/@colset!=''">
<xsl:text><![CDATA[params+=";p[p.length]={\"n\":\"colset\",\"k\":\"]]></xsl:text><xsl:value-of select="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/@colset"/><xsl:text>\"}";
</xsl:text>
</xsl:if>
<xsl:if test="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/@colsort!=''">
<xsl:text><![CDATA[params+=";p[p.length]={\"n\":\"colsort\",\"k\":\"]]></xsl:text><xsl:value-of select="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/@colsort"/><xsl:text>\"}";
</xsl:text>
</xsl:if>
</xsl:otherwise>
</xsl:choose>

//dojo.debug(params);
//lesezeichen funktion setzt nur noch Titel, Params hier obsolet
<xsl:text>lesezeichen('/superx/servlet/SuperXmlTabelle',getTid(),'</xsl:text><xsl:value-of select="/ergebnisse/@MandantenID"/><xsl:text>',params,title);
createLinkForTable('</xsl:text><xsl:value-of select="/ergebnisse/@hisinone_refapp" /><xsl:text>','</xsl:text><xsl:value-of select="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/@colset"/><xsl:text>','</xsl:text><xsl:value-of select="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/@colsort"/><xsl:text>');</xsl:text>
dojo.widget.byId("lesezeichendlg").show();

}

function deeplink_dialog()
{
	dojo.widget.byId("deeplinkdlg").show();
}

</script>
<!-- end lesezeichen -->
	</xsl:if>
<!-- end normale Abfragen - nicht makros-->
</xsl:template>
<xsl:template name="tableCenter">
<form name="Weiterverarbeitung"  method="post" target="_self" charset="UTF-8">
<xsl:attribute name="action">
<!-- MB 9/14 encode URL ignoriert jsession id  -->
<xsl:value-of select="'SuperXmlTabelle'" /></xsl:attribute>
<!-- start Kopf-->
<xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'table_inform'"></xsl:with-param></xsl:call-template>
<xsl:call-template name="tablecustomize"><xsl:with-param name="position" select="'table_inform'"></xsl:with-param></xsl:call-template>
<input name="navi" type="hidden" value="{/ergebnisse/@showNavigation}" />
<input type="hidden" name="tid">
<xsl:choose>
<xsl:when test="/ergebnisse/@isMakro='true'">
<xsl:attribute name="value"><xsl:value-of select="/ergebnisse/makro/@id" /></xsl:attribute>
</xsl:when>
<xsl:otherwise> 
<xsl:attribute name="value"><xsl:value-of select="/ergebnisse/ergebnis/maskenname/@id" /></xsl:attribute>
</xsl:otherwise>
</xsl:choose>
</input>
<input type="hidden" name="UserID"><xsl:attribute name="value"><xsl:value-of select="/ergebnisse/userID" /></xsl:attribute></input>
<input type="hidden" name="reuseresult" value="true"/> <!--  gecachte Ergebnis benutzen-->
<input type="hidden" name="maxoffset" value=""/> <!--im Normalfall wird Servleteinstellung genutzt - nur Druckversion übergibt Wert-->
<input type="hidden" name="stylesheet" value="" />
<input type="hidden" name="contenttype" value="text/xsl" />
  <!-- MB 5/2011 fuer Export nur sichtbarer Tabellenzeilen nach Excel/PDF -->
<input type="hidden" name="irowno" value="" />
<xsl:for-each-group select="/*/*/felder/feld[@art !='1']" group-by=".">
<!--<xsl:for-each select="distinct-values(//ergebnisse/ergebnis/felder/feld [@varname !='Lehreinheit' and @varname != 'Fakultät' and @varname != 'Studiengang'])">-->
          <!--  #198418 Problem bei Feldart 1 Typ SQL Beispiel Zeitraum in COB Maske Kosten und Erlöse (Primär und Sekundär) Attribut value aus default/wert key wird nicht richtig escaped 
       vergl.        https://stackoverflow.com/questions/8944513/disable-output-escaping-yes-no-not-working-amp-outputted-twice-in-sharepoint- 
       Versuche mit <option value="{key}"> sind auch fehlgeschlagen, vermutlich weil XSTL bei Attributen keine Änderung des Escapings vorsieht
      https://stackoverflow.com/questions/7887016/disable-output-escaping-not-working-for-attribute-in-xslt
    alter Code:
     <input type="hidden">
   <xsl:attribute name="name"><xsl:value-of select="@varname" /></xsl:attribute>
   <xsl:attribute name="value"><xsl:value-of select="value" /></xsl:attribute>
  </input>
    
    
     neuer Code: -->
            <xsl:text disable-output-escaping="yes"><![CDATA[<input type="hidden" name="]]></xsl:text><xsl:value-of disable-output-escaping="no" select="@varname"/><xsl:text>" value="</xsl:text>
          <xsl:value-of disable-output-escaping="no" select="value"/><xsl:text>"</xsl:text>
            <xsl:text disable-output-escaping="yes"><![CDATA[</input>
	    ]]></xsl:text> 
       
</xsl:for-each-group>
<!--</xsl:for-each>-->

<xsl:call-template name="tablePrintsaveexport"/>

<xsl:call-template name="tablepretitle"/> <!--defined in pageComponents-->

<xsl:if test="/ergebnisse/@isMakro='true'">
<h1><xsl:value-of select="/ergebnisse/makro/name" /></h1>
</xsl:if>
<p></p>


<xsl:for-each select="ergebnisse/ergebnis/ergebniselement">
<xsl:variable name="ergebniselement_ordnr" select="@ordnr" />
<!-- end Kopf-->
<!-- start tabelle-->
<xsl:choose>
<xsl:when test="@typ='image'">
  <img><xsl:attribute name="src"><xsl:value-of select="@url" /></xsl:attribute></img><hr/>
  <xsl:text>
  </xsl:text>
</xsl:when>
<xsl:when test="@typ='tabelle'">
   <xsl:call-template name="tableSingletable"/>
</xsl:when>
<xsl:otherwise>
    <xsl:text> Nicht unterstützter Ergebnistyp </xsl:text><xsl:value-of select="@type" />
</xsl:otherwise>
</xsl:choose>
<!-- end tabelle-->
<!-- start fuß-->
<xsl:choose>
<xsl:when test="/ergebnisse/@isMakro!='true' and /ergebnisse/ergebnis/ergebniselement/sqlerg/@istreetable!='true'">
<xsl:call-template name="navigationsfuss" />
</xsl:when>
<xsl:otherwise> <!-- input für offset ist wichtig für Exporte, normalerweise im Navigationsfuß definiert -->
<input type="hidden" name="offset">
<xsl:attribute name="value"><xsl:value-of select="sqlerg/@offset" /></xsl:attribute> 
</input>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'table_pre_explanation'"></xsl:with-param></xsl:call-template>
<xsl:call-template name="tablecustomize"><xsl:with-param name="position" select="'table_pre_explanation'"></xsl:with-param></xsl:call-template>

<xsl:choose>
<xsl:when test="/*/@hisinone_active='true'">
<script language="Javascript">
var platform='his1';
</script>
</xsl:when>
<xsl:otherwise>
<script language="Javascript">
var platform='superx';
</script>
</xsl:otherwise>
</xsl:choose>

<xsl:if test="count(sqlerg/headers/header/caption_long) &gt; 0"><xsl:call-template name="explanation" /></xsl:if>
<xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'table_post_explanation'"></xsl:with-param></xsl:call-template>
<xsl:call-template name="tablecustomize"><xsl:with-param name="position" select="'table_post_explanation'"></xsl:with-param></xsl:call-template>

</xsl:for-each>

<!--Ende Gesamt-DIV für Makro-Tabellen-->
<input type="hidden" name="_csrf.parameterName" value="_csrf.token"/>
</form>
<!-- end fuß-->
</xsl:template>
<xsl:template name="tabellenFeldCombo">
<xsl:param name="maskeninfo_id" />
<xsl:param name="Feldname" />
<xsl:param name="FeldnameEscaped" />
<xsl:variable name="jsCall"><xsl:text>tabelleComboLaden(</xsl:text>
			   <xsl:value-of select="$maskeninfo_id" />
			   <xsl:text>,'</xsl:text>
			   <xsl:value-of select="$Feldname"/>
			   <xsl:text>','</xsl:text>
			   <xsl:value-of select="$Feldname"/>
			   <xsl:text>','</xsl:text>
			   <xsl:value-of select="$FeldnameEscaped"/>
			   <xsl:text>');</xsl:text>
</xsl:variable>			  
<div class="field is-grouped">
		  <div class="label-container">
		   <p class="button-label">
			   <a class="button is-link is-outlined is-small is-fullwidth"> 
			   <xsl:attribute name="onclick"><xsl:value-of select="$jsCall"/>
			   </xsl:attribute>
			   <xsl:value-of select="$Feldname"/></a>
		   </p>
		  </div>
		  <span class="separator">&#160;</span>
		  <span class="separator">&#160;</span>
		  
		  <div class="field-body">
			<p class="control-new ">
			<input class="schluesselfeld" type="text" size="15" style="display:none"  id="{$FeldnameEscaped}" name="{$Feldname}" tabindex="511">
				<xsl:attribute name="value"><xsl:value-of select="*/*/felder/feld [@varname = $Feldname]/value"/></xsl:attribute>
			</input>
						
			<input class="input is-small is-fullwidth" type="label" readonly="true" name="{concat('label_',$FeldnameEscaped)}" id="{concat('label_',$FeldnameEscaped)}">
<xsl:attribute name="onclick"><xsl:value-of select="$jsCall"/>
			   </xsl:attribute>
			   <xsl:attribute name="value"><xsl:value-of select="/*/*/felder/feld [@varname = $Feldname]/value_caption"/></xsl:attribute>
			   </input>
			
			</p>
			<span class="separator">&#160;</span>
			<span class="separator">&#160;</span>
			<span class="separator">&#160;</span>
			<span class="separator">&#160;</span>
			
			<!--<span class="info" onclick="window.open('https://super-ics.de/superx/doku/kern_modul/admin/f_Patcheinspielen.htm','_blank','directories=no,location=no,menubar=no,scrollbars=yes,resizable=yes,toolbar=no,width=800,height=660'); ">
			<figure class="image is-24x24">
				<img src="../images/information_grey_liberation.svg" />
			</figure>
			</span>-->
		  </div>
		</div>
</xsl:template>
<xsl:template name="createBarMiniatureJS">
<xsl:param name="ergebniselement_ordnr" select="0" />
<xsl:param name="xcolname"  />
<xsl:param name="xcolcaption"  />
<xsl:param name="ycolnr" />
<xsl:param name="ycolname"  />
<xsl:param name="ycolcaption"  />
<xsl:text>
{"version":"0.2b",
"id":1,
"name":"",
"renderer":"plot",
"dataSources":[{"value":"0",
"nr":1,
"name":"Tab. 1",
"isDefault":true},
{"value":"1",
"nr":2,
"name":"Tab. 2",
"isDefault":false},
{"value":"2",
"nr":3,
"name":"Tab. 3",
"isDefault":false}],
"targetDiv":"",
"chartElements":[{"nr":0,
"vizTypeUniquename":"bar_y",
"caption":"bar_y",
"datasource":"</xsl:text>
<xsl:value-of select="$ergebniselement_ordnr" /> 
<xsl:text>",
"elementTypeProperties":[{"nr":0,
"vizTypePropertyUniquename":"x",
"caption":"X-Achse",
"propertyValue":"</xsl:text><xsl:value-of select="$xcolname" />
<xsl:text>"},
{"nr":0,
"vizTypePropertyUniquename":"y",
"caption":"Y-Achse",
"propertyValue":"</xsl:text><xsl:value-of select="$ycolname" />
<xsl:text>"}]}],
"chartPropertiesUsed":[{"name":"caption",
"vizPropertyVariablename":"caption",
"propertyValue":" "},
{"name":"height",
"vizPropertyVariablename":"height",
"propertyValue":"100",
"propUnit":""},
{"name":"width",
"vizPropertyVariablename":"width",
"propertyValue":"100",
"propUnit":""},
{"name":"marginLeft",
"vizPropertyVariablename":"marginLeft",
"propertyValue":"0",
"propUnit":""},
{"name":"marginRight",
"vizPropertyVariablename":"marginRight",
"propertyValue":"0",
"propUnit":""},
{"name":"marginBottom",
"vizPropertyVariablename":"marginBottom",
"propertyValue":"0",
"propUnit":""},
{"name":"backgroundColor",
"vizPropertyVariablename":"backgroundColor",
"propertyValue":"#D9EDFF",
"propUnit":""},
{"name":"color",
"vizPropertyVariablename":"color",
"propertyValue":"#000000",
"propUnit":""},
{"name":"fill_static",
"vizPropertyVariablename":"fill",
"propertyValue":"#004c93",
"propUnit":""},
{"name":"label_y",
"vizPropertyVariablename":"label",
"propertyValue":" ",
"propUnit":""},
{"name":"line_y",
"vizPropertyVariablename":"line",
"propertyValue":"false",
"propUnit":""},
{"name":"line_x",
"vizPropertyVariablename":"line",
"propertyValue":"false",
"propUnit":""}],
"dataTransformation":[]}
</xsl:text>
</xsl:template>
<xsl:template name="createBarJS">
<xsl:param name="ergebniselement_ordnr" select="0" />
<xsl:param name="xcolname"  />
<xsl:param name="xcolcaption"  />
<xsl:param name="ycolnr" />
<xsl:param name="ycolname"  />
<xsl:param name="ycolcaption"  />
<xsl:variable name="xcolcaptionEscaped"><xsl:call-template name="removeBackslash000">
<xsl:with-param name="string"><xsl:call-template name="removeBackslashN">
<xsl:with-param name="derwert" select="$xcolcaption" />
<xsl:with-param name="format" select="'xml'" />
</xsl:call-template>
</xsl:with-param>
</xsl:call-template>
</xsl:variable>
<xsl:variable name="ycolcaptionEscaped"><xsl:call-template name="removeBackslash000">
<xsl:with-param name="string">
<xsl:call-template name="removeBackslashN">
<xsl:with-param name="derwert" select="$ycolcaption" />
<xsl:with-param name="format" select="'xml'" />
</xsl:call-template>
</xsl:with-param>
</xsl:call-template>
</xsl:variable>

<xsl:text>
{"version":"0.2b",
"id":1,
"name":"",
"renderer":"plot",
"dataSources":[{"value":"0",
"nr":1,
"name":"Tab. 1",
"isDefault":true},
{"value":"1",
"nr":2,
"name":"Tab. 2",
"isDefault":false},
{"value":"2",
"nr":3,
"name":"Tab. 3",
"isDefault":false}],
"targetDiv":"",
"chartElements":[{"nr":0,
"vizTypeUniquename":"bar_y",
"caption":"bar_y",
"datasource":"</xsl:text>
<xsl:value-of select="$ergebniselement_ordnr" /> 
<xsl:text>",
"elementTypeProperties":[{"nr":0,
"vizTypePropertyUniquename":"x",
"caption":"X-Achse",
"propertyValue":"</xsl:text><xsl:value-of select="$xcolname" />
<xsl:text>"},
{"nr":0,
"vizTypePropertyUniquename":"y",
"caption":"Y-Achse",
"propertyValue":"</xsl:text><xsl:value-of select="$ycolname" />
<xsl:text>"}]}],
"chartPropertiesUsed":[{"name":"caption",
"vizPropertyVariablename":"caption",
"propertyValue":"</xsl:text><xsl:value-of select="$ycolcaptionEscaped" />
<xsl:text>"},
{"name":"height",
"vizPropertyVariablename":"height",
"propertyValue":"600",
"propUnit":""},
{"name":"width",
"vizPropertyVariablename":"width",
"propertyValue":"800",
"propUnit":""},
{"name":"marginLeft",
"vizPropertyVariablename":"marginLeft",
"propertyValue":"50",
"propUnit":""},
{"name":"marginRight",
"vizPropertyVariablename":"marginRight",
"propertyValue":"0",
"propUnit":""},
{"name":"marginTop",
"vizPropertyVariablename":"marginTop",
"propertyValue":"80",
"propUnit":""},
{"name":"marginBottom",
"vizPropertyVariablename":"marginBottom",
"propertyValue":"200",
"propUnit":""},
{"name":"backgroundColor",
"vizPropertyVariablename":"backgroundColor",
"propertyValue":"#D9EDFF",
"propUnit":""},
{"name":"color",
"vizPropertyVariablename":"color",
"propertyValue":"#000000",
"propUnit":""},
{"name":"fontFamily",
"vizPropertyVariablename":"fontFamily",
"propertyValue":"sans-serif",
"propUnit":""},
{"name":"fontSize",
"vizPropertyVariablename":"fontSize",
"propertyValue":"15",
"propUnit":"px"},
{"name":"fill_static",
"vizPropertyVariablename":"fill",
"propertyValue":"#004c93",
"propUnit":""},
{"name":"label_y",
"vizPropertyVariablename":"label",
"propertyValue":"</xsl:text><xsl:value-of select="$ycolcaptionEscaped" />
<xsl:text>",
"propUnit":""},
{"name":"line_y",
"vizPropertyVariablename":"line",
"propertyValue":"true",
"propUnit":""},
{"name":"label_x",
"vizPropertyVariablename":"label",
"propertyValue":"</xsl:text><xsl:value-of select="$xcolcaptionEscaped" />
<xsl:text>",
"propUnit":""},
{"name":"line_x",
"vizPropertyVariablename":"line",
"propertyValue":"true",
"propUnit":""},
{"name":"tickRotate_x",
"vizPropertyVariablename":"tickRotate",
"propertyValue":"-45",
"propUnit":""}],
"dataTransformation":[]}
</xsl:text>
</xsl:template>
<xsl:template name="createLineMiniatureJS">
<xsl:param name="ergebniselement_ordnr" select="0" />
<xsl:param name="xcolname"  />
<xsl:param name="xcolcaption"  />
<xsl:param name="ycolnr" />
<xsl:param name="ycolname"  />
<xsl:param name="ycolcaption"  />
<xsl:text>
{"version":"0.2b",
"id":1,
"name":"",
"renderer":"plot",
"dataSources":[{"value":"0",
"nr":1,
"name":"Tab. 1",
"isDefault":true},
{"value":"1",
"nr":2,
"name":"Tab. 2",
"isDefault":false},
{"value":"2",
"nr":3,
"name":"Tab. 3",
"isDefault":false}],
"targetDiv":"",
"chartElements":[{"nr":0,
"vizTypeUniquename":"line",
"caption":"line",
"datasource":"</xsl:text>
<xsl:value-of select="$ergebniselement_ordnr" /> 
<xsl:text>",
"elementTypeProperties":[{"nr":0,
"vizTypePropertyUniquename":"x",
"caption":"X-Achse",
"propertyValue":"</xsl:text><xsl:value-of select="$xcolname" />
<xsl:text>"},
{"nr":0,
"vizTypePropertyUniquename":"y",
"caption":"Y-Achse",
"propertyValue":"</xsl:text><xsl:value-of select="$ycolname" />
<xsl:text>"}]},
{"nr":0,
"vizTypeUniquename":"dot",
"caption":"dot",
"datasource":"</xsl:text>
<xsl:value-of select="$ergebniselement_ordnr" /> 
<xsl:text>",
"elementTypeProperties":[{"nr":0,
"vizTypePropertyUniquename":"x",
"caption":"X-Achse",
"propertyValue":"</xsl:text><xsl:value-of select="$xcolname" />
<xsl:text>"},
{"nr":0,
"vizTypePropertyUniquename":"y",
"caption":"Y-Achse",
"propertyValue":"</xsl:text><xsl:value-of select="$ycolname" />
<xsl:text>"},
{"nr":0,
"vizTypePropertyUniquename":"marginLeft",
"caption":"Außenrand links",
"propertyValue":"100"},
{"nr":0,
"vizTypePropertyUniquename":"backgroundColor",
"caption":"Hintergrundfarbe",
"propertyValue":"#ffffff"},
{"nr":0,
"vizTypePropertyUniquename":"color",
"caption":"Schriftfarbe",
"propertyValue":"#000000"},
{"nr":0,
"vizTypePropertyUniquename":"fill_static",
"caption":"Flächenfarbe",
"propertyValue":"#000000"},
{"nr":0,
"vizTypePropertyUniquename":"line_x",
"caption":"X: Linie",
"propertyValue":"true"},
{"nr":0,
"vizTypePropertyUniquename":"line_y",
"caption":"Y: Linie",
"propertyValue":"true"}]}],
"chartPropertiesUsed":[{"name":"caption",
"vizPropertyVariablename":"caption",
"propertyValue":" "},
{"name":"height",
"vizPropertyVariablename":"height",
"propertyValue":"100",
"propUnit":""},
{"name":"width",
"vizPropertyVariablename":"width",
"propertyValue":"100",
"propUnit":""},
{"name":"marginLeft",
"vizPropertyVariablename":"marginLeft",
"propertyValue":"0",
"propUnit":""},
{"name":"marginRight",
"vizPropertyVariablename":"marginRight",
"propertyValue":"0",
"propUnit":""},
{"name":"marginTop",
"vizPropertyVariablename":"marginTop",
"propertyValue":"0",
"propUnit":""},
{"name":"marginBottom",
"vizPropertyVariablename":"marginBottom",
"propertyValue":"0",
"propUnit":""},
{"name":"backgroundColor",
"vizPropertyVariablename":"backgroundColor",
"propertyValue":"#D9EDFF",
"propUnit":""},
{"name":"color",
"vizPropertyVariablename":"color",
"propertyValue":"#004c93",
"propUnit":""},
{"name":"fontFamily",
"vizPropertyVariablename":"fontFamily",
"propertyValue":"sans-serif",
"propUnit":""},
{"name":"fontSize",
"vizPropertyVariablename":"fontSize",
"propertyValue":"14",
"propUnit":"px"},
{"name":"fill_static",
"vizPropertyVariablename":"fill",
"propertyValue":"#004c93",
"propUnit":""},
{"name":"label_y",
"vizPropertyVariablename":"label",
"propertyValue":" ",
"propUnit":""},
{"name":"line_y",
"vizPropertyVariablename":"line",
"propertyValue":"false",
"propUnit":""},
{"name":"label_x",
"vizPropertyVariablename":"label",
"propertyValue":" ",
"propUnit":""},
{"name":"line_x",
"vizPropertyVariablename":"line",
"propertyValue":"false",
"propUnit":""},
{"name":"tickRotate_x",
"vizPropertyVariablename":"tickRotate",
"propertyValue":"-45",
"propUnit":""}],
"dataTransformation":[]}
</xsl:text>
</xsl:template>
<xsl:template name="createLineJS">
<xsl:param name="ergebniselement_ordnr" select="0" />
<xsl:param name="xcolname"  />
<xsl:param name="xcolcaption"  />
<xsl:param name="ycolnr" />
<xsl:param name="ycolname"  />
<xsl:param name="ycolcaption"  />
<xsl:variable name="xcolcaptionEscaped"><xsl:call-template name="removeBackslash000">
<xsl:with-param name="string">
<xsl:call-template name="removeBackslashN">
<xsl:with-param name="derwert" select="$xcolcaption" />
<xsl:with-param name="format" select="'xml'" />
</xsl:call-template>
</xsl:with-param>
</xsl:call-template>
</xsl:variable>
<xsl:variable name="ycolcaptionEscaped"><xsl:call-template name="removeBackslash000">
<xsl:with-param name="string"><xsl:call-template name="removeBackslashN">
<xsl:with-param name="derwert" select="$ycolcaption" />
<xsl:with-param name="format" select="'xml'" />
</xsl:call-template>
</xsl:with-param>
</xsl:call-template>
</xsl:variable>

<xsl:text>
{"version":"0.2b",
"id":1,
"name":"",
"renderer":"plot",
"dataSources":[{"value":"0",
"nr":1,
"name":"Tab. 1",
"isDefault":true},
{"value":"1",
"nr":2,
"name":"Tab. 2",
"isDefault":false},
{"value":"2",
"nr":3,
"name":"Tab. 3",
"isDefault":false}],
"targetDiv":"",
"chartElements":[{"nr":0,
"vizTypeUniquename":"line",
"caption":"line",
"datasource":"</xsl:text>
<xsl:value-of select="$ergebniselement_ordnr" /> 
<xsl:text>",
"elementTypeProperties":[{"nr":0,
"vizTypePropertyUniquename":"x",
"caption":"X-Achse",
"propertyValue":"</xsl:text><xsl:value-of select="$xcolname" />
<xsl:text>"},
{"nr":0,
"vizTypePropertyUniquename":"y",
"caption":"Y-Achse",
"propertyValue":"</xsl:text><xsl:value-of select="$ycolname" />
<xsl:text>"}]},
{"nr":0,
"vizTypeUniquename":"dot",
"caption":"dot",
"datasource":"</xsl:text>
<xsl:value-of select="$ergebniselement_ordnr" /> 
<xsl:text>",
"elementTypeProperties":[{"nr":0,
"vizTypePropertyUniquename":"x",
"caption":"X-Achse",
"propertyValue":"</xsl:text><xsl:value-of select="$xcolname" />
<xsl:text>"},
{"nr":0,
"vizTypePropertyUniquename":"y",
"caption":"Y-Achse",
"propertyValue":"</xsl:text><xsl:value-of select="$ycolname" />
<xsl:text>"},
{"nr":0,
"vizTypePropertyUniquename":"marginLeft",
"caption":"Außenrand links",
"propertyValue":"100"},
{"nr":0,
"vizTypePropertyUniquename":"backgroundColor",
"caption":"Hintergrundfarbe",
"propertyValue":"#ffffff"},
{"nr":0,
"vizTypePropertyUniquename":"color",
"caption":"Schriftfarbe",
"propertyValue":"#000000"},
{"nr":0,
"vizTypePropertyUniquename":"fill_static",
"caption":"Flächenfarbe",
"propertyValue":"#000000"},
{"nr":0,
"vizTypePropertyUniquename":"line_x",
"caption":"X: Linie",
"propertyValue":"true"},
{"nr":0,
"vizTypePropertyUniquename":"line_y",
"caption":"Y: Linie",
"propertyValue":"true"}]}],
"chartPropertiesUsed":[{"name":"caption",
"vizPropertyVariablename":"caption",
"propertyValue":"
</xsl:text><xsl:value-of select="$ycolcaptionEscaped" />
<xsl:text>"},
{"name":"height",
"vizPropertyVariablename":"height",
"propertyValue":"700",
"propUnit":""},
{"name":"width",
"vizPropertyVariablename":"width",
"propertyValue":"800",
"propUnit":""},
{"name":"marginLeft",
"vizPropertyVariablename":"marginLeft",
"propertyValue":"150",
"propUnit":""},
{"name":"marginTop",
"vizPropertyVariablename":"marginTop",
"propertyValue":"50",
"propUnit":""},
{"name":"marginBottom",
"vizPropertyVariablename":"marginBottom",
"propertyValue":"200",
"propUnit":""},
{"name":"backgroundColor",
"vizPropertyVariablename":"backgroundColor",
"propertyValue":"#D9EDFF",
"propUnit":""},
{"name":"color",
"vizPropertyVariablename":"color",
"propertyValue":"#004c93",
"propUnit":""},
{"name":"fontFamily",
"vizPropertyVariablename":"fontFamily",
"propertyValue":"sans-serif",
"propUnit":""},
{"name":"fontSize",
"vizPropertyVariablename":"fontSize",
"propertyValue":"14",
"propUnit":"px"},
{"name":"fill_static",
"vizPropertyVariablename":"fill",
"propertyValue":"#004c93",
"propUnit":""},
{"name":"label_y",
"vizPropertyVariablename":"label",
"propertyValue":"</xsl:text><xsl:value-of select="$ycolcaptionEscaped" />
<xsl:text>",
"propUnit":""},
{"name":"line_y",
"vizPropertyVariablename":"line",
"propertyValue":"true",
"propUnit":""},
{"name":"label_x",
"vizPropertyVariablename":"label",
"propertyValue":"</xsl:text><xsl:value-of select="$xcolcaptionEscaped" />
<xsl:text>",
"propUnit":""},
{"name":"line_x",
"vizPropertyVariablename":"line",
"propertyValue":"true",
"propUnit":""},
{"name":"tickRotate_x",
"vizPropertyVariablename":"tickRotate",
"propertyValue":"-45",
"propUnit":""}],
"dataTransformation":[]}
</xsl:text>
</xsl:template>
<xsl:template name="removeBackslash000">
<xsl:param name="string" />
<xsl:call-template name="search_replace">
	<xsl:with-param name="string" select="normalize-space($string)" />
	<xsl:with-param name="search"  select="'\000'" />
	<xsl:with-param name="replace" select="' '"/>
</xsl:call-template>
</xsl:template>
</xsl:stylesheet>
