<?xml version="1.0"  encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:HtmlUtils="de.superx.util.HtmlUtils">
<xsl:import href="resultset_html.xsl" />
<xsl:import href="interLinks_html.xsl" />
<xsl:import href="nd_templates.xsl" />
<xsl:import href="pageComponents_html.xsl" />
<xsl:import href="viz_components.xsl" />
<!--In diesem Stylesheet können Sie individuelle templates unterbringen,
  die in ihrer Präzedenz das normale Stylesheet 
  pageComponents_html.xsl überragt. --> 
<xsl:import href="pageComponents_html_final.xsl" />

<xsl:decimal-format name="German" grouping-separator="." NaN="" zero-digit ="0" decimal-separator="," />

                                                      <!-- wichtig für DOJO!-->
<xsl:output method="xml"    media-type="text/html" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
   doctype-system="DTD/xhtml1-strict.dtd"    cdata-section-elements="script style"    indent="yes" encoding="UTF-8"/>

<xsl:variable name="colon"><xsl:text>'</xsl:text></xsl:variable>
<xsl:variable name="quote"><xsl:text>"</xsl:text></xsl:variable>

<!--<xsl:variable name="defaultRenderer" select="'echarts'" />
<xsl:variable name="availableRendererPlot" select="'true'" />
<xsl:variable name="availableRendererD3" select="'true'" />
-->
<xsl:template match="/">
<xsl:variable name="maskenname">
<xsl:choose>
<xsl:when test="/ergebnisse/@isMakro='true'">
<xsl:value-of select="/ergebnisse/makro/name" />
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="/ergebnisse/ergebnis/maskenname" />
</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<html>
<head>
    <xsl:call-template name="nd_htmlhead">
    <xsl:with-param name="title" select="concat('Tabelle ',$maskenname)" />
    </xsl:call-template> 

    <link rel="stylesheet" href="../style/sx_tabelle.css" />
    <!--<link rel="stylesheet" href="../style/superx.css" />-->
    
</head>
<xsl:call-template name="nd_htmlscript" />
<xsl:call-template name="nd_tableJavascript" />
<xsl:call-template name="nd_tableCSS" />
<xsl:call-template name="importVizViewer"></xsl:call-template> 

<body  class="has-navbar-fixed-top" onload="document.getElementById('progressbar').style.display='none';initPage();"> 
<!--#Template Beginn Top-Navigation-->
<xsl:call-template name="viz_navi_top" />
<!--<xsl:call-template name="ude_header_dashboard" />-->


<!--#Template Ende Top-Navigation-->

<div class="columns">

<!--#Template Beginn Navigations-Panel Auswertungen-->
<xsl:if test="/ergebnisse/@showNavigation='true' and 1=0"><!-- erstmal kein Panel,weil der Asssistent schon recht breit ist -->
<xsl:for-each select="/ergebnisse">
<xsl:call-template name="nd_navi_panel" />
</xsl:for-each>
</xsl:if>
<!--#Template Ende Navigations-Panel Auswertungen-->

<!--Beginn Seitentitel, Krümelpfad, Knopfleiste, Legende, Erläuterung-->
<section class="hero-body">
<div class="container"> 
<div class="columns is-mobile is-left">
<div class="column is-full">
<div class="card "> 
<div class="card-content">

<xsl:call-template name="nd_progressbar" /> 

<xsl:call-template name="viz_viewer_columnwise"/>
<xsl:call-template name="bottombar" />
 <xsl:comment>customfooter</xsl:comment>
 </div> <!--Ende content -->
</div> <!--Ende card-content-->
</div> <!--Ende card-background -->
</div> <!--Ende column-->
</div> <!--Ende hero-columns-->

</section> <!--Ende hero = Berichts-Card-->
</div> <!--Ende site-columns-->
<xsl:call-template name="modalCards" />
</body>
<!-- end body -->
</html>
</xsl:template>
<!-- end main -->






<xsl:template name="viz_viewer_columnwise">
<xsl:if test="/ergebnisse/@isMakro='true'">
<p class="cockpit_title"><xsl:value-of select="/ergebnisse/makro/name" /></p>
</xsl:if>
<p></p>
<xsl:call-template name="buildVizMetadata" />

<!-- end Kopf-->
<!-- start Grafiken-->

<span class="separator">&#160;</span>
<!--Beginn Selektions-Card-->
<!--Beginn Berichtstitel, Pfad, Knopfleiste-->
<section class="hero-body">
<section class="container"> <!--Beginn Kartenreihe -->
<div class="columns features is-mobile is-left"> <!--Beginn columns Kartenreihe -->
<div class="column is-two-thirds">

<xsl:for-each select="ergebnisse/ergebnis[felder/feld[@varname='Grafik']/value!='']/ergebniselement">
<xsl:variable name="ergebniselement_counter" select="position()" />
<xsl:variable name="chart_uniquename"><xsl:value-of select="../felder/feld[@varname='Grafik']/value" /></xsl:variable>
<xsl:variable name="ergebniselement_ordnr"><xsl:value-of select="@ordnr" /></xsl:variable>


<!--<p><xsl:value-of select="concat('Zähler: ',$ergebniselement_counter)"/></p>-->
<xsl:call-template name="viewer_kachel">
<xsl:with-param name="caption" select="viz_charts/viz_chart[@uniquename=$chart_uniquename]/@caption"/>
<xsl:with-param name="ergebniselement_ordnr" select="$ergebniselement_ordnr" />
<xsl:with-param name="kachelbreite" select="viz_charts/viz_chart[@uniquename=$chart_uniquename]/@chart_width"/>
<xsl:with-param name="kachelhoehe" select="viz_charts/viz_chart[@uniquename=$chart_uniquename]/@chart_height"/>
<xsl:with-param name="chart_tid" select="viz_charts/viz_chart[@uniquename=$chart_uniquename]/@tid"/>
<xsl:with-param name="showEdit" select="/ergebnisse/user/@admin" />
</xsl:call-template>
<!--<p><xsl:value-of select="concat($spalten_anz,'-',$ergebniselement_counter,':',$ergebniselement_counter mod $spalten_anz)"/></p>-->

</xsl:for-each>
</div>

<xsl:call-template name="vizSidebar" />

</div> <!--Ende hero-columns-->


</section>
</section><!-- des Portals -->
</xsl:template>	


<xsl:template name="ude_header_dashboard_alt">
<header>
<div class="hs_header">
	
               <div class="hs_header_box1"></div>
                     <div class="hs_header_box2">
		     	
                     	<a class="button is-link is-outlined is-small" onclick="alert('todo');">Studienanfänger*innen</a>   
			<a class="button is-link is-outlined is-small" onclick="alert('todo');">Studierende</a>   
			<a class="button is-link is-outlined is-small" onclick="alert('todo');">Absolvent*innen</a>   
			<a class="button is-link is-outlined is-small" onclick="alert('todo');">Doktorand*innen</a>   
			
			<!--<p class="cockpit_title">Universität Duisburg-Essen</p>-->
			<div class="field"><span class="buttonlist">	     
			    <a onmouseover="window.status='Export starten';return true" onfocus="window.status='Download starten';return true" onmouseout="window.status='Download starten';return true" href="javascript:exportBooklet('application/pdf')">
		 <img title="Ausgabe im PDF-Querformat" alt="Ausgabe im PDF-Querformat" src="../images/icons/into_pdf.svg" class="svg_icon" border="0" /></a>
		 <span class="separator">&#160;</span>
	     <a onmouseover="window.status='Export starten';return true" onfocus="window.status='Download starten';return true" onmouseout="window.status='Download starten';return true" href="javascript:exportBooklet('application/vnd.openxmlformats-officedocument.spreadsheetml.sheet')">
	     	<img title="Ausgabe in Excel" alt="Ausgabe in Excel" src="../images/icons/into_excel_normal.svg" class="svg_icon" border="0" /></a>
		<span class="separator">&#160;</span>
	     <a onmouseover="window.status='Export starten';return true" onfocus="window.status='Download starten';return true" onmouseout="window.status='Download starten';return true" href="javascript:exportBooklet('application/vnd.openxmlformats-officedocument.wordprocessingml.document')">
	     	<img title="Ausgabe in Word" alt="Ausgabe in Word" width="25px" height="25px" src="../images/icons/into_word.svg" class="svg_icon" border="0" /></a>
	 
	 </span>
		  
	</div>
			<a href="https://www.uni-due.de/verwaltung/dtac/akademisches_controlling.php">
                           <figure class="image is-64x64"><img src="../images/signet_ude_rgb.svg" title="UDE. Akademisches Controlling" /></figure></a>
		     </div>


	       <div class="hs_header_box1"></div>
       
</div>
</header>
</xsl:template>

<xsl:template name="buildVizMetadata">
<xsl:variable name="vizInitialName">
<xsl:choose>
<xsl:when test="/ergebnisse/@isMakro='true'">
<xsl:value-of select="/ergebnisse/makro/name"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="/ergebnisse/ergebnis/maskenname" />
</xsl:otherwise>
</xsl:choose>
</xsl:variable>
  <!--<xsl:call-template name="navigationsmenue" />-->
<script language="Javascript">

<xsl:text>

var vizInitialName='</xsl:text><xsl:value-of select="$vizInitialName"/><xsl:text>';


function dataRowMetaData(tableId,nr,colname,colcaption,coltype,colfunction)
    {
    this.tableId=tableId;
    this.nr=nr;
this.colname=colname;
this.colcaption=colcaption;
this.coltype=coltype;
this.colfunction=colfunction;
}


function tableMetaData(nr,value,name,isDefault)
{
    this.value=value;
    this.nr=nr;
    this.name=name
    this.isDefault=isDefault;

}

var rsTableMetaData=new Array();
var rsColumnMetaData=new Array();
var rs=new Array();

</xsl:text>



</script>


<xsl:for-each select="/ergebnisse/ergebnis/ergebniselement">
<xsl:call-template name="buildVizData" >
<xsl:with-param name="tableId" select="@ordnr" />
</xsl:call-template>
</xsl:for-each>

</xsl:template>
<xsl:template name="buildVizData">
<xsl:param name="tableId" />

<script language="Javascript">

<xsl:text>

rsTableMetaData.push(new tableMetaData(
</xsl:text>
<xsl:value-of select="position()"/>
<xsl:text>,'</xsl:text>
<xsl:value-of select="$tableId"/>
<xsl:text>','</xsl:text>
<xsl:value-of select="concat('Tab. ',$tableId+1)"/>
<xsl:text>',
</xsl:text>
<xsl:choose>
<xsl:when test="position()=1">
<xsl:text>true</xsl:text>
</xsl:when>
<xsl:otherwise>
<xsl:text>false</xsl:text>
</xsl:otherwise>
</xsl:choose>
<xsl:text>
));
rs[</xsl:text><xsl:value-of select="$tableId"/><xsl:text>]=new Array();

//var myChartModel=new chartModel(1,"","",rsTableMetaData);

function dataRow_</xsl:text><xsl:value-of select="$tableId"/><xsl:text>(rownr</xsl:text>
<xsl:for-each select="sqlerg/complete_headers/header">
<xsl:text>,</xsl:text>
<xsl:call-template name="getColumnNameJS">
<xsl:with-param name="columnNameFromDB" select="f_name"/>
</xsl:call-template>
</xsl:for-each>
<xsl:text>
)
    {
    this.rownr=rownr;
    </xsl:text>
<xsl:for-each select="sqlerg/complete_headers/header">
<xsl:text>this.</xsl:text><xsl:call-template name="getColumnNameJS">
<xsl:with-param name="columnNameFromDB" select="f_name"/>
</xsl:call-template><xsl:text>=</xsl:text>
<xsl:call-template name="getColumnNameJS">
<xsl:with-param name="columnNameFromDB" select="f_name"/>
</xsl:call-template><xsl:text>;
</xsl:text>
</xsl:for-each><xsl:text>
}

rsColumnMetaData[</xsl:text><xsl:value-of select="$tableId"/><xsl:text>]=new Array();

rsColumnMetaData[</xsl:text><xsl:value-of select="$tableId"/><xsl:text>].push(new dataRowMetaData('</xsl:text>
<xsl:value-of select="$tableId"/><xsl:text>',</xsl:text>
<xsl:value-of select="0"/>
<xsl:text>,'rownr','Zeilennr.',0,4));
</xsl:text>


<xsl:for-each select="sqlerg/complete_headers/header">
<xsl:variable name="rownr">
<xsl:value-of select="position()"/>
</xsl:variable>
<xsl:text>
rsColumnMetaData[</xsl:text><xsl:value-of select="$tableId"/><xsl:text>].push(new dataRowMetaData('</xsl:text>
<xsl:value-of select="$tableId"/><xsl:text>',</xsl:text>
<xsl:value-of select="$rownr"/>
<xsl:text>,'</xsl:text>
<xsl:call-template name="getColumnNameJS">
<xsl:with-param name="columnNameFromDB" select="f_name"/>
</xsl:call-template>
<xsl:text>','</xsl:text>
<xsl:call-template name="remove_linebreaksAndQuot">
<xsl:with-param name="volltext" select="wert" />
</xsl:call-template>
<xsl:text>',0,null));</xsl:text> <!--coltype noch unbekannt, colfunction unnötig-->
</xsl:for-each>


<xsl:for-each select="sqlerg/row">
<xsl:variable name="rownr">
<xsl:value-of select="position()"/>
</xsl:variable>
<xsl:if test="$rownr=1">
<!-- first metadata -->
<xsl:for-each select="col">
<xsl:variable name="colnr">
<xsl:value-of select="position()"/>
</xsl:variable>
<xsl:text>
rsColumnMetaData[</xsl:text><xsl:value-of select="$tableId"/><xsl:text>][</xsl:text><xsl:value-of select="number($colnr)"/><xsl:text>].coltype=</xsl:text><xsl:value-of select="@typ"/>
<xsl:text>;
</xsl:text>
</xsl:for-each>

</xsl:if>
<!--now resultset-->
<xsl:text>
//rs[</xsl:text><xsl:value-of select="$tableId"/><xsl:text>]= new Array();
rs[</xsl:text><xsl:value-of select="$tableId"/><xsl:text>].push(new dataRow_</xsl:text><xsl:value-of select="$tableId"/><xsl:text>(</xsl:text><xsl:value-of select="$rownr"/>
<xsl:for-each select="col">
<xsl:text>,</xsl:text>
<xsl:choose>
<xsl:when test="@typ='1'"><xsl:text>'</xsl:text>
<xsl:call-template name="remove_linebreaksAndQuot">
<xsl:with-param name="volltext" select="wert" />
</xsl:call-template>
<xsl:text>'</xsl:text></xsl:when>
<!--todo:Typ Datum --> 
<xsl:when test="string-length(wert)=0"><xsl:text>null</xsl:text>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="wert"/>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
<xsl:text>));
</xsl:text>
</xsl:for-each>


</script>
</xsl:template>
</xsl:stylesheet>
