<?xml version="1.0"  encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:HtmlUtils="de.superx.util.HtmlUtils">
<xsl:import href="resultset_html.xsl" />
<xsl:import href="interLinks_html.xsl" />
<xsl:import href="nd_templates.xsl" />
<xsl:import href="pageComponents_html.xsl" />
<xsl:import href="viz_components.xsl" />
<!--In diesem Stylesheet können Sie individuelle templates unterbringen,
  die in ihrer Präzedenz das normale Stylesheet 
  pageComponents_html.xsl überragt. --> 
<xsl:import href="pageComponents_html_final.xsl" />

<xsl:decimal-format name="German" grouping-separator="." NaN="" zero-digit ="0" decimal-separator="," />

                                                      <!-- wichtig für DOJO!-->
<xsl:output method="xml"    media-type="text/html" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
   doctype-system="DTD/xhtml1-strict.dtd"    cdata-section-elements="script style"    indent="yes" encoding="UTF-8"/>

<xsl:variable name="colon"><xsl:text>'</xsl:text></xsl:variable>
<xsl:variable name="quote"><xsl:text>"</xsl:text></xsl:variable>

<!--<xsl:variable name="defaultRenderer" select="'echarts'" />
<xsl:variable name="availableRendererPlot" select="'true'" />
<xsl:variable name="availableRendererD3" select="'true'" />
-->
<xsl:template match="/">
<xsl:variable name="maskenname">
<xsl:choose>
<xsl:when test="/ergebnisse/@isMakro='true'">
<xsl:value-of select="/ergebnisse/makro/name" />
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="/ergebnisse/ergebnis/maskenname" />
</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<html>
<head>
    <xsl:call-template name="nd_htmlhead">
    <xsl:with-param name="title" select="concat('Tabelle ',$maskenname)" />
    </xsl:call-template> 

    <link rel="stylesheet" href="../style/sx_tabelle.css" />
    <!--<link rel="stylesheet" href="../style/superx.css" />-->
    
</head>
<xsl:call-template name="nd_htmlscript" />
<xsl:call-template name="nd_tableJavascript" />
<xsl:call-template name="nd_tableCSS" />
<xsl:call-template name="vizTableCSS" />
<xsl:call-template name="importVizViewer"></xsl:call-template> 

<body  class="has-navbar-fixed-top" onload="document.getElementById('progressbar').style.display='none';initPage();"> 
<!--#Template Beginn Top-Navigation-->
<xsl:call-template name="viz_navi_top" />

<xsl:call-template name="viz_header_dashboard" />


<!--#Template Ende Top-Navigation-->

<!--#Template Beginn Navigations-Panel Auswertungen-->
<xsl:if test="/ergebnisse/@showNavigation='true' and 1=0"><!-- erstmal kein Panel,weil der Asssistent schon recht breit ist -->
<xsl:for-each select="/ergebnisse">
<xsl:call-template name="nd_navi_panel" />
</xsl:for-each>
</xsl:if>
<!--#Template Ende Navigations-Panel Auswertungen-->

<!--Beginn Seitentitel, Krümelpfad, Knopfleiste, Legende, Erläuterung-->

<xsl:call-template name="nd_progressbar" /> 

<div id="content" style="padding-left:1rem;padding-top:6rem">
<!--#Template Beginn Seitentitel-->
<xsl:variable name="masken_tid"><xsl:value-of select="/ergebnisse/ergebnis[@ordnr='0']/maskenname/@id"/></xsl:variable> 
<xsl:call-template name="vizGridTitle" >
<xsl:with-param name="icon_classname" select="/ergebnisse/menue/eintraege/eintrag[@isMaske='true' and tid=$masken_tid]/css_class" />
</xsl:call-template>

<!--#Template Krümelpfad-->
<!--<xsl:call-template name="nd_breadcrumb" />-->        	
<!--#Template Ende Krümelpfad-->
<xsl:call-template name="buildVizMetadata" />


<div class="columns is-mobile is-left">
<div class="column">
<xsl:call-template name="viz_viewer_grid" >
<xsl:with-param name="openModalCardDetail" select="'false'" />
</xsl:call-template>
</div>
<xsl:call-template name="vizSidebar" >
<xsl:with-param name="stylesheet" select="'viz_html_chart_viewer_grid.xsl'" />
<xsl:with-param name="collapsible" select="'true'" />

 </xsl:call-template>

<!-- ohne collapsible zerschießt das Layout:
<xsl:if test="/ergebnisse/ergebnis[@ordnr='0']/felder/feld[@varname='Spaltenanzahl']/value!=0"> 
<xsl:call-template name="vizSidebar" >
<xsl:with-param name="stylesheet" select="'viz_html_chart_viewer_grid.xsl'" />
</xsl:call-template>
</xsl:if>-->
</div>
</div><!--content-->


<xsl:call-template name="bottombar" />
 <xsl:comment>customfooter</xsl:comment>

<xsl:call-template name="modalCards" />
</body>
<!-- end body -->
</html>
</xsl:template>
<!-- end main -->









<xsl:template name="ude_header_dashboard_alt">
<header>
<div class="hs_header">
	
               <div class="hs_header_box1"></div>
                     <div class="hs_header_box2">
		     	
                     	<a class="button is-link is-outlined is-small" onclick="alert('todo');">Studienanfänger*innen</a>   
			<a class="button is-link is-outlined is-small" onclick="alert('todo');">Studierende</a>   
			<a class="button is-link is-outlined is-small" onclick="alert('todo');">Absolvent*innen</a>   
			<a class="button is-link is-outlined is-small" onclick="alert('todo');">Doktorand*innen</a>   
			
			<!--<p class="cockpit_title">Universität Duisburg-Essen</p>-->
			<div class="field"><span class="buttonlist">	     
			    <a onmouseover="window.status='Export starten';return true" onfocus="window.status='Download starten';return true" onmouseout="window.status='Download starten';return true" href="javascript:exportBooklet('application/pdf')">
		 <img title="Ausgabe im PDF-Querformat" alt="Ausgabe im PDF-Querformat" src="../images/icons/into_pdf.svg" class="svg_icon" border="0" /></a>
		 
	     <a onmouseover="window.status='Export starten';return true" onfocus="window.status='Download starten';return true" onmouseout="window.status='Download starten';return true" href="javascript:exportBooklet('application/vnd.openxmlformats-officedocument.spreadsheetml.sheet')">
	     	<img title="Ausgabe in Excel" alt="Ausgabe in Excel" src="../images/icons/into_excel_normal.svg" class="svg_icon" border="0" /></a>
		
	     <a onmouseover="window.status='Export starten';return true" onfocus="window.status='Download starten';return true" onmouseout="window.status='Download starten';return true" href="javascript:exportBooklet('application/vnd.openxmlformats-officedocument.wordprocessingml.document')">
	     	<img title="Ausgabe in Word" alt="Ausgabe in Word" src="../images/icons/into_word.svg" class="svg_icon" border="0" /></a>
	 
	 </span>
		  
	</div>
			<a href="https://www.uni-due.de/verwaltung/dtac/akademisches_controlling.php">
                           <figure class="image is-64x64"><img src="../images/signet_ude_rgb.svg" title="UDE. Akademisches Controlling" /></figure></a>
		     </div>


	       <div class="hs_header_box1"></div>
       
</div>
</header>
</xsl:template>

<xsl:template name="buildVizMetadata">
<xsl:variable name="vizInitialName">
<xsl:choose>
<xsl:when test="/ergebnisse/@isMakro='true'">
<xsl:value-of select="/ergebnisse/makro/name"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="/ergebnisse/ergebnis/maskenname" />
</xsl:otherwise>
</xsl:choose>
</xsl:variable>
  <!--<xsl:call-template name="navigationsmenue" />-->
<script language="Javascript">

<xsl:text>

var vizInitialName='</xsl:text><xsl:value-of select="$vizInitialName"/><xsl:text>';


function dataRowMetaData(tableId,nr,colname,colcaption,coltype,colfunction)
    {
    this.tableId=tableId;
    this.nr=nr;
this.colname=colname;
this.colcaption=colcaption;
this.coltype=coltype;
this.colfunction=colfunction;
}


function tableMetaData(nr,value,name,isDefault)
{
    this.value=value;
    this.nr=nr;
    this.name=name
    this.isDefault=isDefault;

}

var rsTableMetaData=new Array();
var rsColumnMetaData=new Array();
var rs=new Array();

</xsl:text>



</script>


<xsl:for-each select="/ergebnisse/ergebnis/ergebniselement">
<xsl:call-template name="buildVizData" >
<xsl:with-param name="tableId" select="@ordnr" />
</xsl:call-template>
</xsl:for-each>

</xsl:template>
<xsl:template name="buildVizData">
<xsl:param name="tableId" />

<script language="Javascript">

<xsl:text>

rsTableMetaData.push(new tableMetaData(
</xsl:text>
<xsl:value-of select="position()"/>
<xsl:text>,'</xsl:text>
<xsl:value-of select="$tableId"/>
<xsl:text>','</xsl:text>
<xsl:value-of select="concat('Tab. ',$tableId+1)"/>
<xsl:text>',
</xsl:text>
<xsl:choose>
<xsl:when test="position()=1">
<xsl:text>true</xsl:text>
</xsl:when>
<xsl:otherwise>
<xsl:text>false</xsl:text>
</xsl:otherwise>
</xsl:choose>
<xsl:text>
));
rs[</xsl:text><xsl:value-of select="$tableId"/><xsl:text>]=new Array();

//var myChartModel=new chartModel(1,"","",rsTableMetaData);

function dataRow_</xsl:text><xsl:value-of select="$tableId"/><xsl:text>(rownr</xsl:text>
<xsl:for-each select="sqlerg/complete_headers/header">
<xsl:text>,</xsl:text>
<xsl:call-template name="getColumnNameJS">
<xsl:with-param name="columnNameFromDB" select="f_name"/>
</xsl:call-template>
</xsl:for-each>
<xsl:text>
)
    {
    this.rownr=rownr;
    </xsl:text>
<xsl:for-each select="sqlerg/complete_headers/header">
<xsl:text>this.</xsl:text><xsl:call-template name="getColumnNameJS">
<xsl:with-param name="columnNameFromDB" select="f_name"/>
</xsl:call-template><xsl:text>=</xsl:text>
<xsl:call-template name="getColumnNameJS">
<xsl:with-param name="columnNameFromDB" select="f_name"/>
</xsl:call-template><xsl:text>;
</xsl:text>
</xsl:for-each><xsl:text>
}

rsColumnMetaData[</xsl:text><xsl:value-of select="$tableId"/><xsl:text>]=new Array();

rsColumnMetaData[</xsl:text><xsl:value-of select="$tableId"/><xsl:text>].push(new dataRowMetaData('</xsl:text>
<xsl:value-of select="$tableId"/><xsl:text>',</xsl:text>
<xsl:value-of select="0"/>
<xsl:text>,'rownr','Zeilennr.',0,4));
</xsl:text>


<xsl:for-each select="sqlerg/complete_headers/header">
<xsl:variable name="rownr">
<xsl:value-of select="position()"/>
</xsl:variable>
<xsl:text>
rsColumnMetaData[</xsl:text><xsl:value-of select="$tableId"/><xsl:text>].push(new dataRowMetaData('</xsl:text>
<xsl:value-of select="$tableId"/><xsl:text>',</xsl:text>
<xsl:value-of select="$rownr"/>
<xsl:text>,'</xsl:text>
<xsl:call-template name="getColumnNameJS">
<xsl:with-param name="columnNameFromDB" select="f_name"/>
</xsl:call-template>
<xsl:text>','</xsl:text>
<xsl:call-template name="remove_linebreaksAndQuot">
<xsl:with-param name="volltext" select="wert" />
</xsl:call-template>
<xsl:text>',0,null));</xsl:text> <!--coltype noch unbekannt, colfunction unnötig-->
</xsl:for-each>


<xsl:for-each select="sqlerg/row">
<xsl:variable name="rownr">
<xsl:value-of select="position()"/>
</xsl:variable>
<xsl:if test="$rownr=1">
<!-- first metadata -->
<xsl:for-each select="col">
<xsl:variable name="colnr">
<xsl:value-of select="position()"/>
</xsl:variable>
<xsl:text>
rsColumnMetaData[</xsl:text><xsl:value-of select="$tableId"/><xsl:text>][</xsl:text><xsl:value-of select="number($colnr)"/><xsl:text>].coltype=</xsl:text><xsl:value-of select="@typ"/>
<xsl:text>;
</xsl:text>
</xsl:for-each>

</xsl:if>
<!--now resultset-->
<xsl:text>
//rs[</xsl:text><xsl:value-of select="$tableId"/><xsl:text>]= new Array();
rs[</xsl:text><xsl:value-of select="$tableId"/><xsl:text>].push(new dataRow_</xsl:text><xsl:value-of select="$tableId"/><xsl:text>(</xsl:text><xsl:value-of select="$rownr"/>
<xsl:for-each select="col">
<xsl:text>,</xsl:text>
<xsl:choose>
<xsl:when test="@typ='1'"><xsl:text>'</xsl:text>
<xsl:call-template name="remove_linebreaksAndQuot">
<xsl:with-param name="volltext" select="wert" />
</xsl:call-template>
<xsl:text>'</xsl:text></xsl:when>
<!--todo:Typ Datum --> 
<xsl:when test="string-length(wert)=0"><xsl:text>null</xsl:text>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="wert"/>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
<xsl:text>));
</xsl:text>
</xsl:for-each>


</script>
</xsl:template>
</xsl:stylesheet>
