<?xml version="1.0"  encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:HtmlUtils="de.superx.util.HtmlUtils">
<xsl:import href="resultset_html.xsl" />
<xsl:import href="interLinks_html.xsl" />
<xsl:import href="nd_templates.xsl" />
<xsl:import href="pageComponents_html.xsl" />
<xsl:import href="viz_components.xsl" />
<!--In diesem Stylesheet können Sie individuelle templates unterbringen,
  die in ihrer Präzedenz das normale Stylesheet 
  pageComponents_html.xsl überragt. --> 
<xsl:import href="pageComponents_html_final.xsl" />

<xsl:decimal-format name="German" grouping-separator="." NaN="" zero-digit ="0" decimal-separator="," />

                                                      <!-- wichtig für DOJO!-->
<xsl:output method="xml"    media-type="text/html" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
   doctype-system="DTD/xhtml1-strict.dtd"    cdata-section-elements="script style"    indent="yes" encoding="UTF-8"/>

<xsl:variable name="colon"><xsl:text>'</xsl:text></xsl:variable>
<xsl:variable name="defaultRenderer" select="'plot'" />
<xsl:variable name="availableRendererPlot" select="'true'" />
<xsl:variable name="availableRendererD3" select="'true'" />

<xsl:template match="/">
<xsl:variable name="maskenname">
<xsl:choose>
<xsl:when test="/ergebnisse/@isMakro='true'">
<xsl:value-of select="/ergebnisse/makro/name" />
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="/ergebnisse/ergebnis/maskenname" />
</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<html>
<head>
    <xsl:call-template name="nd_htmlhead">
    <xsl:with-param name="title" select="concat('Tabelle ',$maskenname)" />
    </xsl:call-template> 

    <link rel="stylesheet" href="../style/sx_tabelle.css" />
    <link rel="stylesheet" href="../style/sx_treeform.css" />
    <!--<link rel="stylesheet" href="../style/superx.css" />-->
    
</head>
<xsl:call-template name="nd_htmlscript" />
<xsl:call-template name="nd_tableJavascript" />
<xsl:call-template name="nd_tableCSS" />
<xsl:call-template name="importd3jsLibs" />
<xsl:call-template name="importEchartsLibs" />
<xsl:call-template name="importPlotLibs" />
<xsl:call-template name="vizAssistentCSS" />

<xsl:call-template name="importVizViewer"></xsl:call-template>
<script language="Javascript" type="text/javascript" src="../xml/js/viz/viz_assistent.js" />

<body  class="has-navbar-fixed-top" onload="document.getElementById('progressbar').style.display='none';tableonload();"> <!--initThemenbaumJs();-->
<!--#Template Beginn Top-Navigation-->
<xsl:call-template name="nd_navi_top" /> 
<!--#Template Ende Top-Navigation-->

<!--<div class="columns">-->

<!--#Template Beginn Navigations-Panel Auswertungen-->
<xsl:if test="/ergebnisse/@showNavigation='true' and 1=0"><!-- erstmal kein Panel,weil der Asssistent schon recht breit ist -->
<xsl:for-each select="/ergebnisse">
<xsl:call-template name="nd_navi_panel" />
</xsl:for-each>
</xsl:if>
<!--#Template Ende Navigations-Panel Auswertungen-->

<!--Beginn Seitentitel, Krümelpfad, Knopfleiste, Legende, Erläuterung-->
<!--<section class="hero-body">
<div class="container"> 
<div class="columns is-mobile is-left">
<div class="column is-full">-->
<div class="card "> 
<div class="card-content">

<xsl:call-template name="nd_progressbar" /> 

<xsl:call-template name="viz_canvas"/>
<xsl:call-template name="bottombar" />
 <xsl:comment>customfooter</xsl:comment>
 </div> <!--Ende content -->
</div> <!--Ende card-content-->
<!--
</div> 
</div> 
</div>

</section>
</div>--> 
</body>
<!-- end body -->
</html>
</xsl:template>
<!-- end main -->




<xsl:template name="viz_canvas">
<xsl:if test="/ergebnisse/@isMakro='true'">
<h1><xsl:value-of select="/ergebnisse/makro/name" /></h1>
</xsl:if>
<p></p>
<div class="vizTooltip" style="opacity:0;"></div>
<xsl:call-template name="buildVizMetadata" />

<!-- end Kopf-->
<!-- start Grafik-->
<xsl:for-each select="ergebnisse">

<!--Beginn Selektions-Card-->
<!--Beginn Berichtstitel, Pfad, Knopfleiste-->
<section class="hero-body has-background-light">
<!--<div class="columns is-mobile is-left">
<div class="card has-background-light">
<div class="card-content">-->
<p class="title is-4">Konfigurationsassistent Datenvisualisierung</p>

<!--Beginn NavTabs--> 
<div class="tabs is-left is-small" id="viznav"> 
	<ul>
	    <li data-target="viznav-tab1" id="1">
	   	<a onclick="showVizNavTab(1);"><span>Grafikdaten</span></a>
	    </li>
	    <li data-target="viznav-tab2" id="2">
		<a onclick="updateChartModel();renderChart('chartDiv',myChartModel);showVizNavTab(2);"><span>Grafiklayout</span></a>
	    </li>
	    <li data-target="viznav-tab3" id="3">
		<a onclick="showVizNavTab(3);"><span>Grafiknutzung</span></a>
	    </li>
	 </ul>
</div>

<div class="tab-content">
<!-- tab-1-->
<div class="viznav-tab1" id="tab-1" style="display:block"> <!--Diagramm-Daten-->
<xsl:call-template name="grafikdaten" />

</div>
<div class="viznav-tab2" id="tab-2" style="display:none"> <!--Diagramm-Layout-->
<xsl:call-template name="grafiklayout" />


</div>
<div class="viznav-tab3" id="tab-3" style="display:none"> <!--Diagramm-Nutzung-->
<xsl:call-template name="grafiknutzung" />


</div>



</div><!--tab-content -->

</section>
</xsl:for-each>
</xsl:template>


	<xsl:template name="topbar_menue_hisinone">
	<div class="header_hisinone">
		<div class="logo">
    <a href="/_HISINONE_/pages/cs/sys/portal/hisinoneStartPage.faces" target="_parent" style="float:left;">
     <img src="../xml/his1/images/logos/hisinone_schriftzug_portal.svg" alt="Zur HISinOne Startseite" class="logoPortal" title="Zur HISinOne Startseite" border="0" />
    </a>
    <div class="browserback_tooltip">
    <span class="browserback_tooltiptext">Browser Zurück ist deaktiviert. Bitte das Menü zur Navigation benutzen!</span>
    </div>
       <ul class="nav" style="float:left;">
             <!-- <li class="topMenuList">
                    <a  class="topMenuLink"  href="/qisserver/pages/cs/sys/portal/hisinoneStartPage.faces" target="_parent">Startseite</a>
             </li>-->
             
             <li class="open-menu">
                    <a class="topMenuLink" href="#leftpanel3">Navigation ein/aus</a>
             </li>
             <li class="close-menu">
                    <a class="topMenuLink" href="#">Navigation ein/aus</a>
             </li>
             <!-- 
             <li class="topMenuList">
                    <a  class="topMenuLink"  href="javascript:lesezeichen_erstellen();" id="btnBookmark" target="_parent">Lesezeichen</a>
                   
             </li>
              -->
       </ul>
   </div><h1 style="padding-top:25px">Business Intelligence</h1>
    <div style="float:right;">
       <img src="../images/icons/arrow_left_fat.svg" width="10" height="10" alt=" " title=" " border="0" style="vertical-align:bottom;"/>
        <a tabindex="30" href="/superx/servlet/SuperXmlAbmeldung" target="_parent" style="cursor:pointer; font-weight: bold;">Abmelden von Standardberichte</a>
    </div>
   <div class="services">
    <ol> 
     <li> 
            
     </li>
    </ol>
   </div>
   <!-- <div style="clear: both;"></div> -->
   </div>
	</xsl:template>
	
<xsl:template name="grafikdaten">

<xsl:for-each select="ergebnis/ergebniselement">
<p class="title is-5"><xsl:value-of select="../maskenname" /></p>
<xsl:call-template name="legende" />
<!--<xsl:if test="/ergebnisse/@isMakro!='true' and /ergebnisse/ergebnis/ergebniselement/sqlerg/@istreetable!='true' and /ergebnisse/ergebnis/ergebniselement/sqlerg/@max &gt; 19">
  <xsl:call-template name="navigationsmenue" />
</xsl:if>-->
</xsl:for-each>
<span class="separator">&#160;</span>

<!--Aufruf/Anzeige Diagrammdaten-->
<xsl:for-each select="ergebnis/ergebniselement">
<xsl:variable name="tableId"><xsl:value-of select="@ordnr"/></xsl:variable>
<div class="field is-grouped">
  <div class="label-container">
             <label class="label is-required is-small"><strong>Datentabelle</strong></label>

  </div> 
  <!--<a onClick="exportDataTable(rs[0],rsColumnMetaData[0])">EXPORT</a>-->
  <span class="separator">&#160;</span>
  <span class="separator">&#160;</span>
 
  <a>
  <xsl:attribute name="onClick">
  <xsl:text>showDataTable('dataDivTable</xsl:text>
  <xsl:value-of select="$tableId"/>
  <xsl:text>',</xsl:text>
    <xsl:value-of select="$tableId"/>
    <xsl:text>,rs[</xsl:text><xsl:value-of select="$tableId"/><xsl:text>],rsColumnMetaData[</xsl:text><xsl:value-of select="$tableId"/><xsl:text>],10);</xsl:text>
  </xsl:attribute>
	<span class="icon">
		<img src="../images/icons/more.svg" title="Laden" /> 
	</span>
  </a>

</div>

<div id="dataDiv"> <!--class="section">-->
  <div id="{concat('dataDivTable',$tableId)}"> <!--style="border:thin solid black">-->
  </div>
</div>

<span class="separator">&#160;</span>

</xsl:for-each>

<!--Aufruf/Anzeige Formular Datenauswahl

<div class="field is-grouped">
  <div class="label-container">
     <label class="label is-required is-small"><strong>Daten-Transformation</strong></label>
  </div> 
  
  <span class="separator">&#160;</span>
  <span class="separator">&#160;</span>
     
 
  <a  
  onClick="fillDataTransformationForm('dataSelectionFormDiv',0);">					
	<span class="icon">
		<img src="../images/icons/more.svg" title="Laden" /> 
	</span>
  </a>
 
</div>

<div id="dataSelectionDiv"> 
 <form name="dataSelectionForm" id="dataSelectionForm">
     
     <div id="dataSelectionFormDiv" style="display:none">
	
     

  </div>
 </form>
</div>
-->
<!--Ende Formular Datenauswahl-->

<span class="separator">&#160;</span>
<span class="separator">&#160;</span>

<!--Aufruf/Anzeige Daten-Vorschau-->
<!--<div class="field is-grouped">
  <div class="label-container">
     <label class="label is-required is-small"><strong>Daten-Vorschau</strong></label>
  </div> 
  
  <span class="separator">&#160;</span>
  <span class="separator">&#160;</span>
   <a  
     onClick="selectionResultPreview('selectionResultPreviewTable');">					
	<span class="icon">
		<img src="../images/icons/more.svg" title="Laden" /> 
	</span>
  </a>
  
</div>

<div id="selectionResultPreview">    
     <div id="selectionResultPreviewTable" style="display:none"></div>
</div>
-->
<!--footer-->
<footer class="card-footer">
	<!--<p class="card-footer-item"><button class="button is-link is-outlined is-small" onclick="selectionResultPreview('selectionResultPreviewTable');">Daten-Vorschau</button></p>--> 
	<!--<p class="card-footer-item"><button class="button is-link is-outlined is-small" type="submit">Speichern</button></p>
	<p class="card-footer-item"><button class="button is-link is-outlined is-small" type="reset">Zurücksetzen</button></p>-->
     </footer>

</xsl:template>

<xsl:template name="grafiklayout">

<!--Formular Allg. Layoutmerkmale-->
<div id="chartProperties"> <!--class="section">-->
<form name="chartPropertiesForm">
<div class="columns">
<div class="column is-two-fifths">
   
    <!--<p><span class="button is-link is-outlined is-small" onClick="updateChartModel();renderChart('chartDiv',myChartModel);">Erzeugen</span></p>-->
  
  <div class="field is-grouped">
	  <div class="label-container">
	     <label class="label is-required is-small"><strong>Grafiktitel</strong></label>
	  </div>
	  
	  <div class="field is-active">
	      <p class="control-new">
	       <div class="chartName">
	       <textarea  class="textarea is-small" id="chartName"  name="chartName" rows="2" cols="20" onChange="updateChartModel();renderChart('chartDiv',myChartModel);"/>
	       <input type="hidden" id="fldMaskennr">
	       <xsl:attribute name="value"><xsl:choose>
<xsl:when test="/ergebnisse/@isMakro='true'">
<xsl:value-of select="/ergebnisse/makro/@id"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="/ergebnisse/ergebnis/maskenname/@id" />
</xsl:otherwise>
</xsl:choose>
</xsl:attribute>
</input>
	       </div>
	      </p>
	  </div>
	  
	 
     </div>
</div>
    <span class="separator">&#160;</span>
  <span class="separator">&#160;</span>
 
  <div class="column">
        <div class="field is-grouped">
	  <div class="label-container">
	     <label class="label is-required is-small"><strong>Grafiktool</strong></label>
	  </div>
	  
	  <div class="field is-active">
	      <p class="control-new">
	       <div class="select is-small is-fullwidth">
	       <select class="maskinputPflicht" id="fldVizRenderer" NAME="fldVizRenderer" tabindex="1" onChange="resetChartPropertiesForm(this.value);" >
	       <xsl:for-each select="/ergebnisse/ergebnis[@ordnr='0']/ergebniselement/vizRenderers/vizRenderer">
	       <option class="maskinput" value="{@uniquename}"><xsl:value-of select="@caption" /></option>
		</xsl:for-each>
		 </select>
	       </div>
	      </p>
	  </div>
	  <xsl:call-template name="Infobutton" />
	 
     </div>
     
  </div>
</div>
<!-- Beginn Grafikelemente+ Vorschau-->
<div class="columns">
<div class="column is-two-fifths">

 

    <!-- Box Grafikelemente -->
   <div class="field is-grouped">
     <div class="label-container">
	     <label class="label is-required is-small"><strong>Grafikelemente</strong></label>
     </div> 
	  
     <span class="separator">&#160;</span>
     <span class="separator">&#160;</span>
     
     <a onClick="showChartPropertiesFormDiv('ChartElementsDiv','ChartElementListDiv',document.getElementById('fldVizRenderer').value);">					
	<span class="icon">
		<img src="../images/icons/more.svg" title="Laden" /> 
	</span>
     </a>	
   </div>
   <xsl:choose>
   <xsl:when test="1=0">
   <xsl:call-template name="chartPropertiesFormPlotD3" />
   </xsl:when>
   <xsl:otherwise>
   <xsl:call-template name="chartPropertiesTreeForm" />
   </xsl:otherwise>
   </xsl:choose>
      <!--Beginn Quellcode-->
    <div class="field is-grouped">
     <div class="label-container">
	     <label class="label is-required is-small"><strong>Quellcode</strong></label>
     </div> 

     <span class="separator">&#160;</span>
     <span class="separator">&#160;</span>

     <a onClick="showChartModelCode();">					
	<span class="icon">
		<img src="../images/icons/more.svg" title="Laden" /> 
	</span>
     </a>
   </div>
   
   <div id="chartModelsrcDiv"> <!--class="section">-->    
     <div id="chartModelsrc"  style="display:none">
	<textarea id="chartModelSrcCode" name="chartModelSrcCode" class="editform" placeholder="Quellcode...">  <!--cols="100" rows="20"--></textarea>
	<div class="field is-grouped">
	  <p class="control">
	    <button class="button is-small is-info  is-outlined" onclick="copySrcCode('chartModelSrcCode');return false;">Kopieren</button>
		
	  </p>
	  <p class="control">
	 <button class="button is-small is-info is-inverted  is-outlined" onclick="loadChartModelCode('chartModelSrcCode','chartDiv');return false;">Einspielen</button>
		
	  </p>
	</div>
	
	
	<!--<a class="button" onClick="copySrcCode('chartModelSrcCode');">Kopieren</a>-->
	
	
     </div>
</div>
  </div>
 
  
   <div class="column">
      <div class="label-container">
     <label class="label is-required is-small"><strong>Grafikvorschau</strong></label>
    </div>
    <span class="separator">&#160;</span>
    <span class="separator">&#160;</span>

    <div id="chartCanvas"> 
	<div id="chartDiv" style="width:800px;height:600px;">
  <svg>
  <rect x="0" y="0" width="650" height="450" fill="#cccccc"></rect>
  </svg></div>
	
</div>
<xsl:call-template name="chartLoadMenu" />

<!--Beginn chartCode-->
<div class="field is-grouped" id="chartCodeDiv" style="display:block">
     <div class="label-container">
     <label class="label is-required is-small"><strong>Chart-Code</strong></label>
    </div>
    <span class="separator">&#160;</span>
    <span class="separator">&#160;</span>
     <a onClick="showChartCode();">					
	<span class="icon">
		<img src="../images/icons/more.svg" title="Laden" /> 
	</span>
     </a>
    <div id="chartCodeTextAreaDiv" style="display:none"> 
	<textarea id="chartCodeTextArea" name="chartCodeTextArea" class="editform" placeholder="Chart-Quellcode..." >  <!--readonly="readonly" disabled="disabled" cols="100" rows="20"-->
	</textarea>
		<div class="field is-grouped">
	  <p class="control">
	    	<button class="button is-small is-info  is-outlined" onclick="copySrcCode('chartCodeTextArea');return false;">Kopieren</button>
		
	  </p>
	  <p class="control">
	  	<button class="button is-small is-info is-inverted  is-outlined" onclick="loadNativeCode('chartCodeTextArea','chartDiv');return false;">Laden</button>
		
	  </p>

	</div>

	</div>

	
</div>
  </div>
  </div><!--Ende Eigenschaften + Vorschau  viewBox="0 0 650 450"-->

  </form>
</div>

<!--
     <div class="label-container">
	     <label class="label is-required is-small"><strong>Basismerkmale</strong></label>
     </div> 
     
     <span class="separator">&#160;</span>
     <span class="separator">&#160;</span>	  

     <div class="field is-grouped">
	  <div class="label-container">
	     <label class="label is-required is-small">Diagramm-Typ</label>
	  </div>
	  
	  <div class="field is-active">
	      <p class="control-new">
	       <div class="select is-small is-fullwidth">
	       <select class="maskinputPflicht" id="viz_chart_type" NAME="viz_chart_type" tabindex="200" onChange="prepareChartProperties(this.value)" >
		    <option class="maskinput" value="" selected="selected">Bitte wählen Sie</option>
		    <xsl:for-each select="/ergebnisse/ergebnis/ergebniselement/vizTypes/vizType">
		    <option class="maskinput" value="{@uniquename}"><xsl:value-of select="@caption" /></option>
		    </xsl:for-each>
		 </select>
	       </div>
	      </p>
	  </div>
	  
	  <span class="separator">&#160;</span>
	  <span class="separator">&#160;</span>
	   
	   <span class="info" onclick="window.open('https://super-ics.de/superx/doku/kern_modul/admin/f_Patcheinspielen.htm','_blank','directories=no,location=no,menubar=no,scrollbars=yes,resizable=yes,toolbar=no,width=800,height=660');">
		   <figure class="image is-24x24">
			<img src="../images/information_grey_liberation.svg" />
		   </figure>
	   </span>
     </div>
<div id="chartPropertiesForm"> </div>

<span class="separator">&#160;</span>
<span class="separator">&#160;</span>
-->
<!--Formular Erweiterte Layoutmerkmale-->
<!--
  <div class="field is-grouped">
     <div class="label-container">
	     <label class="label is-required is-small"><strong>Zusatzmerkmale</strong></label>
     </div> 
	  
     <span class="separator">&#160;</span>
     <span class="separator">&#160;</span>
   
    
     <a  
     onClick="showChartPropertiesForm();">					
	<span class="icon">
		<img src="../images/icons/more.svg" title="Laden" /> 
	</span>
     </a>
	
   </div>
   <div id="chartPropertiesFormDetails" style="display:none"> </div>     
   -->



<span class="separator">&#160;</span>
<span class="separator">&#160;</span>

<!--Aufruf/Anzeige Layout-Vorschau-->
<!--
<div class="field is-grouped">
  <div class="label-container">
     <label class="label is-required is-small"><strong>Layout-Vorschau</strong></label>
  </div> 
  
  <span class="separator">&#160;</span>
  <span class="separator">&#160;</span>
    
  <a  
  onClick="showChartDiv('chartDiv');">					
	<span class="icon">
		<img src="../images/icons/more.svg" title="Laden" /> 
	</span>
  </a>
</div>

<div id="chartCanvas"> 
	<div id="chartDiv"> </div>
	
</div>
-->

<!--footer (BF nach unten verschoben)-->


</xsl:template>
<xsl:template name="grafiknutzung">
<!-- Aufruf/Anzeige Diagramm-Vorschau-->
<div class="field is-grouped">
  <div class="label-container">
     <label class="label is-required is-small"><strong>Grafikvorschau</strong><span class="separator">&#160;</span>
     <span class="separator">&#160;</span>
     <a  
     onClick="showChartDiv('chartDiv2'); renderChart('chartDiv2',myChartModel);">					
	<span class="icon">
		<img src="../images/icons/more.svg" title="Laden" /> 
	</span>
  </a></label>
  </div>     	
    
  <!--<button class="button is-small is-rounded is-white is-outlined"  
  onClick="createChart('chartDiv2');">
	<span class="icon is-small"><i class="../images/more.svg"></i>
		<img src="../images/more.svg" title="Laden" /> 
	</span>
  </button>-->
  
</div>

<div id="chartCanvas"> <!--class="section"-->
     <!--<div id="chartCanvasHeader"> </div>-->
     <div id="chartDiv2" style="width:800px;height:600px;display:none;"> </div> 
     <!--<div id="chartCanvasFooter"></div>-->
</div>

<span class="separator">&#160;</span>
<span class="separator">&#160;</span>

<!-- Aufruf/Anzeige SVG-Quellcode-->
<div class="field is-grouped">
  <div class="label-container">
     <label class="label is-required is-small"><strong>Grafikcode (svg)</strong>
     <span class="separator">&#160;</span>
     <a  
     onClick="showSrcCode(myChartModel.renderer);">					
	<span class="icon">
		<img src="../images/icons/more.svg" title="Laden" /> 
	</span>
  </a>
     </label>
  </div>     	
    
   
</div>

<div id="chartSVGsrcDiv"> <!--class="section">-->    
     <div id="chartSVGsrc"  style="display:none">
	<textarea id="chartSrc" name="chartSrc" class="textarea" placeholder="Quellcode...">  <!--cols="100" rows="20"--></textarea><!--<button class="sx_buttondiv_submit" onClick="copySrcCode('chartSrc');">Kopieren</button>-->
     </div>
</div>

<span class="separator">&#160;</span>
<span class="separator">&#160;</span>

<!-- Aufruf/Anzeige SVG-Quellcode-->
<div class="field is-grouped">
  <div class="label-container">
     <label class="label is-required is-small"><strong>Grafikdefinition speichern</strong>
     <span class="separator">&#160;</span>
     <a  
     onClick="showVizChartSaveDialog('showLoadSaveDialogDiv');">					
	<span class="icon">
		<img src="../images/icons/more.svg" title="Laden" /> 
	</span>
  </a>
     </label>
  </div>     	
    
   
</div>

<div id="showLoadSaveDialog"> <!--class="section">-->    
     <div id="showLoadSaveDialogDiv"  style="display:none">
     <div class="field is-horizontal">
  <div class="field-label is-normal">
    <label class="label has-tooltip-bottom" data-tooltip="Gafikdefinition, die Sie gerade erstellt haben, in der Datenbank speichern. Sie müssen einen Namen und Schlüssel vergeben, und können entscheiden ob die entworfene Grafik eine Normalansicht ist oder eine Miniatur. Das eigentliche Speichern geschieht im Folgedialog.">Grafikdefinition speichern:</label>
  </div>
  <div class="field-body">
    <div class="field is-narrow">
      	<p class="control">
        	<select class="select" name="viz_chart_id" id="viz_chart_id"><option>Keine Auswahl möglich</option></select>
	</p>
    </div>
    <div class="field is-narrow">
      <p class="control">
        <select class="select" name="viz_chart_variant" id="viz_chart_variant">
	<option value="chartmodel">Normalgröße</option>
	<option value="chartmodel_miniature">Miniatur</option></select>
	      </p>
    </div>
    <div class="field is-narrow">
      <p class="control">
        
<a target="nextedit" onclick="openVizChartDBForm(document.getElementById('viz_chart_id').value)">
	<img src="../images/pencil.svg" class="svg_icon" border="0" alt="Bearbeiten" title="Aufruf des Formulars um Metadaten zu bearbeiten und zu speichern" /></a>
	
      </p>
    </div>
  </div>
</div>
<div class="field is-horizontal">
  <div class="field-label is-normal">
    <label class="label"></label>
  </div>
  <div class="field-body">
    <div class="field is-narrow">
      	<p class="control">(Im nachfolgenden Dialog können Sie weitere Metadaten bearbeiten)</p>
</div>
</div>
</div>

	
	<!--<div class="field">
	<div class="label">Oder neue Grafik: </div><div class="input">
	<input name="viz_chart_new_uniquename" id="viz_chart_new_uniquename" type="text" />
	Link...
	</div>
	</div>-->
	
     </div>
</div>



</xsl:template>
<xsl:template name="Infobutton">
<xsl:param name="targetUrl" select="'http://www.superx-projekt.de/doku/viz_modul/nutzung/f_Grafiklayout.htm'" />

<span class="separator">&#160;</span>
<span class="separator">&#160;</span>
	   
	   <span class="info">
	   <xsl:attribute name="onclick">
	   <xsl:text>window.open('</xsl:text>
	   <xsl:value-of select="$targetUrl"/>
	   <xsl:text>','_blank','directories=no,location=no,menubar=no,scrollbars=yes,resizable=yes,toolbar=no,width=800,height=660');</xsl:text>
	   </xsl:attribute>
		   <figure class="image is-24x24">
			<img src="../images/information_grey_liberation.svg" />
		   </figure>
	   </span>
	 </xsl:template>
	 <xsl:template name="legende_viz">
<xsl:param name="ordnr" />
<xsl:variable name="legendeDivId"><xsl:text>legende</xsl:text><xsl:value-of select="$ordnr" /></xsl:variable>
<a>
<xsl:attribute name="onClick"><xsl:text>toggleLegendeDisplay('</xsl:text><xsl:value-of select="$legendeDivId" /><xsl:text>');</xsl:text></xsl:attribute>
<span class="button is-link modal-button">Legende ...</span></a>

<div style="display:none">
<xsl:attribute name="id"><xsl:value-of select="$legendeDivId" /></xsl:attribute>
<p class="legende">
<xsl:for-each select="../felder/feld">
	<xsl:if test="(value !='' or sicht/@isFirstInGroup='false' or @isstandtoday='false')  and @varname != 'sort' and @varname != 'maxoffset' and value_caption != ''">

		<span class="feldname">
		<xsl:choose>
		<xsl:when test="string-length(caption_short) &gt; 0 and caption_short != 'null'" >
		<![CDATA[]]><xsl:value-of select="caption_short" /><![CDATA[]]>
		</xsl:when>
		<xsl:otherwise>
		<xsl:value-of select="@varname" />
		</xsl:otherwise>
		</xsl:choose></span>:&#160;
		<xsl:if test="string-length(value_caption) &lt; 50">
					<span class="feldwert"><xsl:value-of select="value_caption" /><![CDATA[]]></span>
		</xsl:if>
			<xsl:if test="string-length(value_caption) &gt; 49">
			<span class="feldwert"><![CDATA[]]><xsl:value-of select="substring(value_caption,0,50)" /><![CDATA[]]>...</span>
		</xsl:if>
		<xsl:if test="sicht!=''">
			<span><![CDATA[ (]]><xsl:value-of select="sicht" />
			<xsl:if test="@stand!=''"><xsl:text> - Stand:</xsl:text><xsl:value-of select="@stand"/></xsl:if>
			<xsl:text><![CDATA[)]]>	</xsl:text></span>
			
		</xsl:if>
	;
	</xsl:if>

</xsl:for-each>
User: <xsl:value-of select="/ergebnisse/user"/>&#160;
Stand: <xsl:value-of select="../stand" /></p>
<xsl:if test="../hinweis != ''">
<xsl:call-template name="newline_to_br">
	<xsl:with-param name="string" select="../hinweis" />
</xsl:call-template>
</xsl:if>

</div>

</xsl:template>
<xsl:template name="ChartTypeSelection">
   
   <div class="field" id="fldChartTypeSelection"><!-- style="display:none;"-->
	<div class="label-container" lang="de"><span class="labelNormal has-tooltip-bottom" data-tooltip="Nur für Grafiktool Plot: Übersicht Grafikelemente, wählen Sie ein Element zum Bearbeiten, oder erzeugen einen neuen Grafikelementtyp. Sie können auch mehrere erzeugen bzw. entfernen mit dem + bzw - Button">
	Grafikelement</span></div>
	<div class="control">
	<div class="field"><div class="control is-expanded">
	<div class="select  is-small is-fullwidth is-focused">
	<select  id="chartElementID" name="chartElementID" 
	     onchange="loadChartElementConfig(this);">
                                                         <option>Bitte fügen Sie ein Element ein</option>
	</select>
           <input class="is-small" type="hidden" size="1" name="vizElementCounter" id="vizElementCounter" value="0" readonly="readonly" style="background-color:#cccccc;"/>
	</div>
	</div>
	<div class="control">
        <a onClick="createChartElementConfig1Form(document.getElementById('fldVizRenderer').value,null)">
		<img src="../images/plus-circled.svg" width="12" height="12" title="Neues Element anlegen" />
	</a>
   	<span class="separator">&#160;</span>
	  <a onClick="removeChartElementConfig()">
		<img src="../images/minus-circled.svg" width="12" height="12" title="Ausgewähltes Element entfernen" />
	</a>
	</div>
	
	</div>
	</div>
	
   
	</div><!--ende Feld Grafikelemente-->
	
</xsl:template>
<xsl:template name="chartPropertiesFormPlotD3" >
<div id="ChartElementsDiv" style="display:none" class="box">

<xsl:call-template name="ChartTypeSelection" />
    <div id="ChartElementConfig1Div"> </div>
    <div id="ChartElementConfig2Div"> </div>
    </div> <!--Ende Grafikelemente-->

        <!--Beginn Layoutmerkmale-->
    <div class="field is-grouped">
     <div class="label-container">
	     <label class="label is-required is-small"><strong>Allgem. Layoutmerkmale</strong></label>
     </div> 

     <span class="separator">&#160;</span>
     <span class="separator">&#160;</span>

     <a onClick="showChartPropertiesFormDiv('generalChartPropertiesFormDiv','generalChartPropertiesFormElementsDiv',document.getElementById('fldVizRenderer').value);">					
	<span class="icon">
		<img src="../images/icons/more.svg" title="Laden" /> 
	</span>
     </a>
   </div>
   
   <div id="generalChartPropertiesFormDiv" class="box" style="display:none">
   	<div id="generalChartPropertiesFormElementsDiv"> </div>
   </div>
  
</xsl:template>
<xsl:template name="chartPropertiesTreeForm" >
<div id="ChartElementsDiv" style="display:none" class="box">
<xsl:call-template name="ChartTypeSelection" />
  <div id="ChartElementConfig1Div"> </div>
  <div id="ChartElementConfig2Div"><p>Root</p> </div>
  </div> <!--Ende Grafikelemente-->

        <!--Beginn Layoutmerkmale-->
    <!--Beginn Layoutmerkmale-->
    <div class="field">
     <div class="label-container">
	     <label class="label is-required is-small"><strong>Layoutmerkmale</strong></label>
     </div> 

     <span class="separator">&#160;</span>
     <span class="separator">&#160;</span>

     <a onClick="showChartPropertiesFormDiv('chartPropertiesTreeFormDiv','chartPropertiesTreeFormElementsDiv',document.getElementById('fldVizRenderer').value);">					
	<span class="icon">
		<img src="../images/icons/more.svg" title="Laden" /> 
	</span>
     </a>
   </div>
   <div id="chartPropertiesTreeFormDiv" class="box" style="display:none">
   	<div id="chartPropertiesTreeFormElementsDiv"> </div>
   </div>
</xsl:template>
<xsl:template name="chartLoadMenu">
<div class="field is-grouped">
     <div class="label-container">
	     <label class="label has-tooltip-bottom" data-tooltip="Grafikdefinition aus der Datenbank speichern. Es werden die Grafikdefinitionen angezeigt, die zu der jew. Maskennnummer passen.  Sie können entscheiden ob die Miniatur- oder Normalansicht geladen wird. Nach dem Laden sehen Sie direkt eine Vorschau, und wenn Sie oben links auf die Grafikelemente klicken, können Sie die Grafik weiter bearbeiten.">
	     <strong>Grafikdefinition laden</strong></label>
     </div> 

     <span class="separator">&#160;</span>
     <span class="separator">&#160;</span>

     <a onClick="showLoadMenu();">					
	<span class="icon">
		<img src="../images/icons/more.svg" title="Laden" /> 
	</span>
     </a>
   </div>
   <div id="loadMenu" class="field  is-horizontal" style="display:none">
  <div class="field-label is-normal">
      </div>
  <div class="field-body">
    <div class="field is-narrow">
      	<p class="control">
        	<select class="select" name="viz_chart_id_load" id="viz_chart_id_load"><option>Keine Auswahl möglich</option></select>
	</p>
    </div>
    <div class="field is-narrow">
      <p class="control">
        <select class="select" name="viz_chart_variant_load" id="viz_chart_variant_load">
	<option value="chartmodel">Normalgröße</option>
	<option value="chartmodel_miniature">Miniatur</option></select>
	      </p>
    </div>
    <div class="field is-narrow">
      <p class="control">
        
	<button class="button is-info is-inverted has-tooltip-bottom is-outlined" onclick="loadVizChartDef();return false;"
	data-tooltip="Achtung: wenn Sie auf Laden klicken, wird der etwaig vorhandene Grafikentwurf überschrieben!">Laden</button>
	
      </p>
    </div>
    </div>
    </div>
</xsl:template>
</xsl:stylesheet>
