<?xml version="1.0"  encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sx="http://memtext.de">
<xsl:variable name="quote"><xsl:text>"</xsl:text></xsl:variable>

<xsl:template name="head_superx_viz">
		<xsl:param name="css" />
		<xsl:param name="title" />
		<head>
			<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
			</meta><!-- <link rel="stylesheet" type="text/css" href="../xml/his1/css.._menue_html.css" /> -->
	<link rel="stylesheet" type="text/css" href="../style/superx.css"/>
	<link rel="stylesheet" type="text/css" href="../xml/menue_html.css"/>
	<link rel="stylesheet" type="text/css" href="../xml/superxml_html.css"/>
	<link rel="stylesheet" type="text/css" href="../xml/maske_html.css" />
	<link rel="stylesheet" type="text/css" href="../xml/tabelle_html.css" />
	<link rel="stylesheet" type="text/css" href="../xml/superx_standalone.css"/>

	
	<link rel="stylesheet" type="text/css" href="../xml/css/fontello-codes.css" />
	<link rel="stylesheet" type="text/css" href="../xml/css/start_portlet.css" />

      <link rel="stylesheet" type="text/css" href="../style/bulma.css" />
      <link rel="stylesheet" type="text/css" href="../style/bulma-tooltip.min.css" />
      
      <link rel="stylesheet" type="text/css" href="../style/sx_viz_muster.css" />
   
		</head>

	</xsl:template>
	<xsl:template name="head_hisinone_viz">
		<xsl:param name="css" />
		<xsl:param name="title" />
		<head>
			<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
			</meta>
			<link rel="stylesheet" type="text/css"
				href="../xml/his1/css/superx_menue_html.css" />
				<link rel="stylesheet" type="text/css" href="../xml/maske_html.css" />
			<!--<LINK REL="stylesheet" type="text/css" href="../style/superx.css" 
				></LINK> <LINK REL="stylesheet" type="text/css" href="../xml/superxml_html.css" 
				></LINK> -->
			<xsl:choose>
				<xsl:when test="$title != ''">
					<xsl:choose>
						<xsl:when test="starts-with($title,'Mask') ">
							<link rel="stylesheet" type="text/css" href="../xml/maske_html.css" />
						</xsl:when>
						<xsl:otherwise>
							<!-- Styles für HIS1 sind in xml/his1/css/superx_menue_html.css definiert 
								<LINK REL="stylesheet" type="text/css" href="../xml/tabelle_html.css" ></LINK> -->
						</xsl:otherwise>
					</xsl:choose>
					<title>
						<xsl:value-of select="$title" />
					</title>
				</xsl:when>
				<xsl:otherwise>
					<title>
						<xsl:text>HISinOne-BI</xsl:text>
					</title>
				</xsl:otherwise>
			</xsl:choose>
			<link rel="stylesheet" type="text/css" href="../xml/his1/css/HISinOne.css" />

			<!--<script src="../xml/js/jquery/jquery.mobile-1.4.2.min.js"></script>
			<link rel="stylesheet" href="../xml/js/jquery/jquery.mobile.structure-1.4.2.dw.css" />
			<link rel="stylesheet" href="../xml/js/jquery/jqm-demos.dw.css" /> -->
	<link rel="stylesheet" type="text/css" href="../xml/css/fontello-codes.css" />
	<link rel="stylesheet" type="text/css" href="../xml/css/start_portlet.css" />

      <link rel="stylesheet" type="text/css" href="../style/bulma.css" />
      <link rel="stylesheet" type="text/css" href="../style/bulma-tooltip.min.css" />
      
      <link rel="stylesheet" type="text/css" href="../style/sx_viz_muster.css" />
			
			<xsl:if test="$css != ''">
				<link rel="stylesheet" type="text/css" href="$css" />
			</xsl:if>

		</head>

	</xsl:template>
	<xsl:template name="tableJavascript_viz_alt">
<script language="Javascript" type="text/javascript" src="../xml/js/jquery-2.1.1.min.js" />
<script language="JavaScript" type="text/javascript" src="../xml/js/memtext/sx_functions.js"></script>

<xsl:call-template name="importVizJavascriptLibs" />

<script><xsl:text><![CDATA[

//document.body.append(Plot.plot(options));

function commonChartProperty(name,
caption,
isMandatory,
inputType,
staticValues,
range_from,
range_to,
defaultValue,
propUnit,
explanation,
groupCaption,
groupUniquename,
rendererUniquename,
groupVariableName,
variableName,
propValueType,
isGeneric
) 
{
this.name=name;
this.caption=caption;
this.staticValues=staticValues;
this.range_from=range_from;
this.range_to=range_from;
this.isMandatory=isMandatory;
this.inputType=inputType;
this.defaultValue=defaultValue;
this.propUnit=propUnit;
this.explanation=explanation;
this.groupCaption=groupCaption;
this.groupUniquename=groupUniquename;
this.rendererUniquename=rendererUniquename;
this.groupVariableName=groupVariableName;
this.variableName=variableName;
this.propValueType=propValueType;
this.isGeneric=isGeneric;
this.getValueResultset = function () {
var valueOptions=[];
var optionCounter=0;
var staticValueArray = staticValues.split(/\|/);
	for(var j=0;j < staticValueArray.length;j++)
		{
		var isDefault=false;
		if(staticValueArray[j])
			{
				if(staticValueArray[j]==this.defaultValue)
					isDefault=true;
				var o=new selectionPropertyValue(optionCounter,staticValueArray[j],staticValueArray[j],isDefault);
				valueOptions[optionCounter]=o;
				optionCounter++;
			}
		}
	return valueOptions;
}
}
function commonChartPropertyGroup(caption,groupUniquename,groupVariableName) 
{
this.caption=caption;
this.groupUniquename=groupUniquename;
this.groupVariableName=groupVariableName;
}

var commonChartProperties=[];
]]></xsl:text>
<xsl:for-each select="/ergebnisse/ergebnis[@ordnr='0']/ergebniselement/chartProperties/commonChartProperty">
<xsl:text>
var newCommonChartProperty = new commonChartProperty("</xsl:text>
<xsl:value-of select="@prop_uniquename" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@caption" />
<xsl:text>",</xsl:text><xsl:choose>
<xsl:when test="@is_mandatory=1"><xsl:text>true</xsl:text>
</xsl:when>
<xsl:otherwise>false</xsl:otherwise>
</xsl:choose>
<xsl:text>,"</xsl:text>
<xsl:value-of select="@input_type_uniquename" />
<xsl:text>"
,"</xsl:text>
<xsl:value-of select="@static_values" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@prop_range_from" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@prop_range_to" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@prop_default" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@prop_unit" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@explanation" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@group_caption" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@group_uniquename" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@renderer_uniquename" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@group_variable_name" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@variable_name" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@propValueType" />
<xsl:text>",</xsl:text>
<xsl:value-of select="@isGeneric" />
<xsl:text>);
commonChartProperties.push(newCommonChartProperty);
</xsl:text>
</xsl:for-each>
<!--<xsl:text>
var newCommonChartProperty = new commonChartProperty("caption",
"Titel des Diagramms", 
false,
"TEXTAREA",
"",
"",
"",
"</xsl:text>
<xsl:value-of select="/ergebnisse/ergebnis[@ordnr='0']/maskenname" /><xsl:text>",
"wird unter dem Diagramm angezeigt",
"Diagrammkopf",
"",
"plot",
"layout",
"caption",
"string");
commonChartProperties.push(newCommonChartProperty);

</xsl:text>-->
<xsl:text>
function vizRenderer(uniquename,caption) 
{
this.caption=caption;
this.uniquename=uniquename;
}

var vizRenderers=[];
</xsl:text>
<xsl:for-each select="/ergebnisse/ergebnis[@ordnr='0']/ergebniselement/vizRenderers/vizRenderer">
<xsl:text>
var newVizRenderer = new vizRenderer("</xsl:text>
<xsl:value-of select="@uniquename" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@caption" />
<xsl:text>");
vizRenderers.push(newVizRenderer);
</xsl:text>
</xsl:for-each>
<xsl:text>
function vizType(uniquename,caption,rendererUniquename,orientation) 
{
this.caption=caption;
this.uniquename=uniquename;
this.rendererUniquename=rendererUniquename,
this.orientation=orientation;
}

var vizTypes=[];
</xsl:text>
<xsl:for-each select="/ergebnisse/ergebnis[@ordnr='0']/ergebniselement/vizTypes/vizType">
<xsl:text>
var newVizType = new vizType("</xsl:text>
<xsl:value-of select="@uniquename" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@caption" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@renderer_uniquename" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@orientation" />
<xsl:text>");
vizTypes.push(newVizType);
</xsl:text>
</xsl:for-each>
<xsl:text>

function vizTypeProperty(propUniquename,caption,typeUniquename,groupUniquename,isMandatory,propertyType,explanation) 
{
this.propUniquename=propUniquename;
this.caption=caption;
this.groupUniquename=groupUniquename;
this.typeUniquename=typeUniquename;
this.isMandatory=isMandatory;
this.propertyType=propertyType;
this.explanation=explanation;
}

var vizTypeProperties=[];
</xsl:text>
<xsl:for-each select="/ergebnisse/ergebnis[@ordnr='0']/ergebniselement/viz_type_properties/viz_type_property">
<xsl:text>
var newVizTypeProperty = new vizTypeProperty("</xsl:text>
<xsl:value-of select="@uniquename" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@caption" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@viz_type_uniquename" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@viz_property_group_uniquename" />
<xsl:text>",</xsl:text>
<xsl:choose>
<xsl:when test="@is_mandatory='1'">
<xsl:text>true</xsl:text>
</xsl:when>
<xsl:otherwise>
<xsl:text>false</xsl:text>
</xsl:otherwise>
</xsl:choose>
<xsl:text>,"</xsl:text>
<xsl:value-of select="@propValueType" />
<xsl:text>","");
vizTypeProperties.push(newVizTypeProperty);
</xsl:text>
</xsl:for-each>


</script>
<script language="Javascript" type="text/javascript" src="../xml/js/viz/viz_functions.js" />
<style type="text/css">

.node rect {
  cursor: move;
  fill-opacity: .9;
  shape-rendering: crispEdges;
}

.node text {
  pointer-events: none;
  text-shadow: 0 1px 0 #fff;
}

.link {
  fill: none;
  stroke: #000;
  stroke-opacity: .2;
}

.link:hover {
  stroke-opacity: .5;
}
</style>
</xsl:template>
<xsl:template name="importVizViewer">
<script language="Javascript" type="text/javascript" src="../xml/js/jquery-2.1.1.min.js" />
<script language="JavaScript" type="text/javascript" src="../xml/js/memtext/sx_functions.js"></script>
<xsl:call-template name="importRendererLibs" />

<!--<script language="JavaScript" type="text/javascript" src="../xml/js/viz/echarts.min.js"></script>-->
<script language="JavaScript" type="text/javascript" src="../xml/js/viz/viz_viewer.js"></script>
<!--<script language="JavaScript" type="text/javascript" src="../xml/js/viz/viz_functions.js"></script>-->
<!--<xsl:call-template name="tableJavascript_viz" />-->
<script language="Javascript" type="text/javascript">
<xsl:text><![CDATA[
var commonChartProperties=[];
]]></xsl:text>
<xsl:for-each select="/ergebnisse/ergebnis[@ordnr='0']/ergebniselement/chartProperties/commonChartProperty">
<xsl:text>
var newCommonChartProperty = new commonChartProperty("</xsl:text>
<xsl:value-of select="@prop_uniquename" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@caption" />
<xsl:text>",</xsl:text><xsl:choose>
<xsl:when test="@is_mandatory=1"><xsl:text>true</xsl:text>
</xsl:when>
<xsl:otherwise>false</xsl:otherwise>
</xsl:choose>
<xsl:text>,"</xsl:text>
<xsl:value-of select="@input_type_uniquename" />
<xsl:text>"
,"</xsl:text>
<xsl:value-of select="@static_values" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@prop_range_from" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@prop_range_to" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@prop_default" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@prop_unit" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@explanation" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@group_caption" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@group_uniquename" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@renderer_uniquename" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@group_variable_name" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@variable_name" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@propValueType" />
<xsl:text>",</xsl:text>
<xsl:value-of select="@isGeneric" />
<xsl:text>);
commonChartProperties.push(newCommonChartProperty);
</xsl:text>
</xsl:for-each>

<xsl:text>
function vizRenderer(uniquename,caption) 
{
this.caption=caption;
this.uniquename=uniquename;
}

var vizRenderers=[];
</xsl:text>
<xsl:for-each select="/ergebnisse/ergebnis[@ordnr='0']/ergebniselement/vizRenderers/vizRenderer">
<xsl:text>
var newVizRenderer = new vizRenderer("</xsl:text>
<xsl:value-of select="@uniquename" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@caption" />
<xsl:text>");
vizRenderers.push(newVizRenderer);
</xsl:text>
</xsl:for-each>
<xsl:text>
function vizType(uniquename,caption,rendererUniquename,orientation) 
{
this.caption=caption;
this.uniquename=uniquename;
this.rendererUniquename=rendererUniquename,
this.orientation=orientation;
}

var vizTypes=[];
</xsl:text>
<xsl:for-each select="/ergebnisse/ergebnis[@ordnr='0']/ergebniselement/vizTypes/vizType">
<xsl:text>
var newVizType = new vizType("</xsl:text>
<xsl:value-of select="@uniquename" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@caption" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@renderer_uniquename" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@orientation" />
<xsl:text>");
vizTypes.push(newVizType);
</xsl:text>
</xsl:for-each>
<xsl:text>

function vizTypeProperty(propUniquename,caption,typeUniquename,groupUniquename,isMandatory,propertyType,explanation) 
{
this.propUniquename=propUniquename;
this.caption=caption;
this.groupUniquename=groupUniquename;
this.typeUniquename=typeUniquename;
this.isMandatory=isMandatory;
this.propertyType=propertyType;
this.explanation=explanation;
}

var vizTypeProperties=[];
</xsl:text>
<xsl:for-each select="/ergebnisse/ergebnis[@ordnr='0']/ergebniselement/viz_type_properties/viz_type_property">
<xsl:text>
var newVizTypeProperty = new vizTypeProperty("</xsl:text>
<xsl:value-of select="@uniquename" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@caption" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@viz_type_uniquename" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@viz_property_group_uniquename" />
<xsl:text>",</xsl:text>
<xsl:choose>
<xsl:when test="@is_mandatory='1'">
<xsl:text>true</xsl:text>
</xsl:when>
<xsl:otherwise>
<xsl:text>false</xsl:text>
</xsl:otherwise>
</xsl:choose>
<xsl:text>,"</xsl:text>
<xsl:value-of select="@propValueType" />
<xsl:text>","");
vizTypeProperties.push(newVizTypeProperty);
</xsl:text>
</xsl:for-each>

<xsl:text>
function vizPropertyTreeNode(typeUniquename,
typeCaption,
orientation,
propUniquename,
propertyCaption,
parentPropertyUniquename,
sortnr,
isMandatory,
renderer) 
{
this.typeUniquename=typeUniquename;
this.typeCaption=typeCaption;
this.orientation=orientation;
this.propUniquename=propUniquename;
this.propertyCaption=propertyCaption;
this.parentPropertyUniquename=parentPropertyUniquename;
this.sortnr=sortnr;
this.isMandatory=isMandatory;
this.renderer=renderer;
}

var vizPropertyTreeNodes=[];
</xsl:text>
<xsl:for-each select="/ergebnisse/ergebnis[@ordnr='0']/ergebniselement/viz_property_trees/viz_property_tree">
<xsl:text>
var newVizPropertyTreeNode = new vizPropertyTreeNode("</xsl:text>
<xsl:value-of select="@viz_type_uniquename" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@viz_type_caption" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@orientation" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@prop_uniquename" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@property_caption" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@parent_property_uniquename" />
<xsl:text>",</xsl:text>
<xsl:value-of select="@sortnr" />
<xsl:text>,</xsl:text>
<xsl:choose>
<xsl:when test="@is_mandatory='1'">
<xsl:text>true</xsl:text>
</xsl:when>
<xsl:otherwise>
<xsl:text>false</xsl:text>
</xsl:otherwise>
</xsl:choose>
<xsl:text>,"</xsl:text>
<xsl:value-of select="@renderer" />
<xsl:text>");
vizPropertyTreeNodes.push(newVizPropertyTreeNode);
</xsl:text>
</xsl:for-each>

<xsl:text>

var currentMaskeninfoId=</xsl:text><xsl:value-of select="/ergebnisse/ergebnis[@ordnr='0']/maskenname/@id" /><xsl:text>;

function vizColorScheme(tid,
uniquename,
caption,
specifier) 
{
this.tid=tid;
this.uniquename=uniquename;
this.caption=caption;
this.specifier=specifier;
}

var vizColorSchemes=[];


</xsl:text>
<xsl:for-each select="/ergebnisse/ergebnis[@ordnr='0']/ergebniselement/vizColorSchemes/vizColorscheme">
<xsl:text>
var myColorScheme = new vizColorScheme("</xsl:text>
<xsl:value-of select="@tid" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@uniquename" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@caption" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@specifier" />
<xsl:text>");

vizColorSchemes.push(myColorScheme);

</xsl:text>
</xsl:for-each>
<xsl:text>


function vizColorSchemeElement(colorscheme_id,
colorscheme_uniquename,
colorcode,
target_uniquename,
sortnr) 
{
this.colorscheme_id=colorscheme_id;
this.colorscheme_uniquename=colorscheme_uniquename;
this.colorcode=colorcode;
this.target_uniquename=target_uniquename;
this.sortnr=sortnr;
}

var vizColorSchemeElements=[];


</xsl:text>
<xsl:for-each select="/ergebnisse/ergebnis[@ordnr='0']/ergebniselement/vizColorSchemeElements/vizColorschemeElem">
<xsl:text>
var myVizColorSchemeElement = new vizColorSchemeElement("</xsl:text>
<xsl:value-of select="@colorscheme_id" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@colorscheme_uniquename" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@colorcode" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@target_uniquename" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@sortnr" /><xsl:text>"
);

vizColorSchemeElements.push(myVizColorSchemeElement);

</xsl:text>
</xsl:for-each>
<xsl:text>

function vizChart(tid,
uniquename,
caption,
renderer,
renderer_id,
maskeninfo_id,
userinfo_id,
chartmodel,
chartmodel_miniature
) 
{
this.tid=tid;
this.uniquename=uniquename;
this.caption=caption;
this.renderer=renderer;
this.renderer_id=renderer_id;
this.maskeninfo_id=maskeninfo_id;
this.userinfo_id=userinfo_id;
this.chartmodel=chartmodel;
this.chartmodel_miniature=chartmodel_miniature;
}

var vizCharts=[];
</xsl:text>
<xsl:for-each select="/ergebnisse/ergebnis[@ordnr='0']/ergebniselement/viz_charts/viz_chart">
<xsl:text>
var newVizChart = new vizChart(</xsl:text>
<xsl:value-of select="@tid" /><xsl:text>,
"</xsl:text>
<xsl:value-of select="@uniquename" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@caption" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@renderer" />
<xsl:text>",</xsl:text>
<xsl:value-of select="@renderer_id" />
<xsl:text>,"</xsl:text>
<xsl:value-of select="@maskeninfo_id" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@userinfo_id" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@chartmodel" />
<xsl:text>","</xsl:text>
<xsl:value-of select="@chartmodel_miniature" />
<xsl:text>");
vizCharts.push(newVizChart);
</xsl:text>
</xsl:for-each>

<xsl:text><![CDATA[
function initPage()
{
//zuerst Miniatur:
var myChartModelStr="";
var myDiv="";
var rsNr=0;
]]></xsl:text>
<xsl:for-each select="ergebnisse">
<xsl:for-each select="ergebnis/ergebniselement">
<xsl:variable name="chart_uniquename"><xsl:value-of select="../felder/feld[@varname='Grafik']/value" /></xsl:variable>
<xsl:variable name="chart_title"><xsl:value-of select="../felder/feld[@varname='Grafiktitel']/value" /></xsl:variable>
<xsl:variable name="ergebniselement_ordnr"><xsl:value-of select="@ordnr" /></xsl:variable>
<xsl:if test="$chart_uniquename != ''">
<xsl:text>
var myRenderer='</xsl:text>
<xsl:value-of select="viz_charts/viz_chart[@uniquename=$chart_uniquename]/@renderer" />
<xsl:text>';
</xsl:text>
<xsl:text><![CDATA[
var myChartModel=]]></xsl:text>
<xsl:value-of select="translate(viz_charts/viz_chart[@uniquename=$chart_uniquename]/@chartmodel,'§',$quote)" />
<xsl:text><![CDATA[;

myDiv="]]></xsl:text>
<xsl:value-of select="concat('chartDiv',$ergebniselement_ordnr)" />
<xsl:text><![CDATA[";
rsNr=]]></xsl:text>
<xsl:value-of select="$ergebniselement_ordnr" />
<xsl:text><![CDATA[;
chartTitle="]]></xsl:text>
<xsl:value-of select="$chart_title" />
<xsl:text><![CDATA[";

createChartsViewer(myChartModel,myDiv,rsNr,myRenderer,chartTitle);
myDiv="]]></xsl:text>
<!--<xsl:value-of select="concat('modalCardImage',$ergebniselement_ordnr)" />
<xsl:text>";
//Detailseite mit Legende:
myChartModelStr='Platzhalter d';

createEchartsViewer(myChartModel,myDiv,rsNr);
myDiv="</xsl:text>
-->
<xsl:value-of select="concat('modalCardDetailImage',$ergebniselement_ordnr)" />
<xsl:text>";
myChartModelStr='Platzhalter_dl';
createChartsViewer(myChartModel,myDiv,rsNr,myRenderer,chartTitle);
</xsl:text>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
<xsl:text><![CDATA[
}

function createChartsViewer(chartModel,chartDiv,rsNr,myRenderer,chartTitle)
{
if(myRenderer=="echarts")
	{
	renderEChart2(chartModel,chartDiv,rsNr,chartTitle);
	}
else
{
//d3js or plot:
//myChartModel=JSON.parse(myChartModelStr);
renderPlotD3Chart(chartDiv,chartModel,rsNr);
}
}

function toggleLegendeDisplay(legendeDiv)
{
var myDiv=document.getElementById(legendeDiv);
if(myDiv.style.display=="block")
		myDiv.style.display="none";
	else
		myDiv.style.display="block";

}

]]></xsl:text>
</script>

</xsl:template>
<xsl:template name="buildVizMetadata">
<xsl:variable name="vizInitialName">
<xsl:choose>
<xsl:when test="/ergebnisse/@isMakro='true'">
<xsl:value-of select="/ergebnisse/makro/name"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="/ergebnisse/ergebnis/maskenname" />
</xsl:otherwise>
</xsl:choose>
</xsl:variable>
  <!--<xsl:call-template name="navigationsmenue" />-->
<script language="Javascript">

<xsl:text>

var vizInitialName='</xsl:text><xsl:value-of select="$vizInitialName"/><xsl:text>';


function dataRowMetaData(tableId,nr,colname,colcaption,coltype,colfunction)
    {
    this.tableId=tableId;
    this.nr=nr;
this.colname=colname;
this.colcaption=colcaption;
this.coltype=coltype;
this.colfunction=colfunction;
}


function tableMetaData(nr,value,name,isDefault)
{
    this.value=value;
    this.nr=nr;
    this.name=name
    this.isDefault=isDefault;

}

var rsTableMetaData=new Array();
var rsColumnMetaData=new Array();
var rs=new Array();

</xsl:text>



</script>


<xsl:for-each select="/ergebnisse/ergebnis/ergebniselement">
<xsl:call-template name="buildVizData" >
<xsl:with-param name="tableId" select="@ordnr" />
</xsl:call-template>
</xsl:for-each>

</xsl:template>
<xsl:template name="buildVizData">
<xsl:param name="tableId" />

<script language="Javascript">

<xsl:text>

rsTableMetaData.push(new tableMetaData(
</xsl:text>
<xsl:value-of select="position()"/>
<xsl:text>,'</xsl:text>
<xsl:value-of select="$tableId"/>
<xsl:text>','</xsl:text>
<xsl:value-of select="concat('Tab. ',$tableId+1)"/>
<xsl:text>',
</xsl:text>
<xsl:choose>
<xsl:when test="position()=1">
<xsl:text>true</xsl:text>
</xsl:when>
<xsl:otherwise>
<xsl:text>false</xsl:text>
</xsl:otherwise>
</xsl:choose>
<xsl:text>
));
rs[</xsl:text><xsl:value-of select="$tableId"/><xsl:text>]=new Array();

var myChartModel=new chartModel(1,"","",rsTableMetaData);

function dataRow_</xsl:text><xsl:value-of select="$tableId"/><xsl:text>(rownr</xsl:text>
<xsl:for-each select="sqlerg/complete_headers/header">
<xsl:text>,</xsl:text>
<xsl:call-template name="getColumnNameJS">
<xsl:with-param name="columnNameFromDB" select="f_name"/>
</xsl:call-template>
</xsl:for-each>
<xsl:text>
)
    {
    this.rownr=rownr;
    </xsl:text>
<xsl:for-each select="sqlerg/complete_headers/header">
<xsl:text>this.</xsl:text><xsl:call-template name="getColumnNameJS">
<xsl:with-param name="columnNameFromDB" select="f_name"/>
</xsl:call-template><xsl:text>=</xsl:text>
<xsl:call-template name="getColumnNameJS">
<xsl:with-param name="columnNameFromDB" select="f_name"/>
</xsl:call-template><xsl:text>;
</xsl:text>
</xsl:for-each><xsl:text>
}

rsColumnMetaData[</xsl:text><xsl:value-of select="$tableId"/><xsl:text>]=new Array();

rsColumnMetaData[</xsl:text><xsl:value-of select="$tableId"/><xsl:text>].push(new dataRowMetaData('</xsl:text>
<xsl:value-of select="$tableId"/><xsl:text>',</xsl:text>
<xsl:value-of select="0"/>
<xsl:text>,'rownr','Zeilennr.',0,4));
</xsl:text>

<xsl:variable name="headersCount" select="sqlerg/complete_headers/header" />
<xsl:for-each select="sqlerg/complete_headers/header">
<xsl:variable name="rownr">
<xsl:value-of select="position()"/>
</xsl:variable>
<xsl:text>
rsColumnMetaData[</xsl:text><xsl:value-of select="$tableId"/><xsl:text>].push(new dataRowMetaData('</xsl:text>
<xsl:value-of select="$tableId"/><xsl:text>',</xsl:text>
<xsl:value-of select="$rownr"/>
<xsl:text>,'</xsl:text>
<xsl:call-template name="getColumnNameJS">
<xsl:with-param name="columnNameFromDB" select="f_name"/>
</xsl:call-template>
<xsl:text>','</xsl:text>
<xsl:call-template name="remove_linebreaksAndQuot">
<xsl:with-param name="volltext" select="wert" />
</xsl:call-template>
<xsl:text>',0,null));</xsl:text> <!--coltype noch unbekannt, colfunction unnötig-->
</xsl:for-each>


<xsl:for-each select="sqlerg/row">
<xsl:variable name="rownr">
<xsl:value-of select="position()"/>
</xsl:variable>
<xsl:if test="$rownr=1">
<!-- first metadata -->
<xsl:for-each select="col">
<xsl:variable name="colnr">
<xsl:value-of select="position()"/>
</xsl:variable>
<xsl:if test="$colnr &lt;= $headersCount">
<xsl:text>
rsColumnMetaData[</xsl:text><xsl:value-of select="$tableId"/><xsl:text>][</xsl:text><xsl:value-of select="number($colnr)"/><xsl:text>].coltype=</xsl:text><xsl:value-of select="@typ"/>
<xsl:text>;
</xsl:text>
</xsl:if>
</xsl:for-each>

</xsl:if>
<!--now resultset-->
<xsl:text>
//rs[</xsl:text><xsl:value-of select="$tableId"/><xsl:text>]= new Array();
rs[</xsl:text><xsl:value-of select="$tableId"/><xsl:text>].push(new dataRow_</xsl:text><xsl:value-of select="$tableId"/><xsl:text>(</xsl:text><xsl:value-of select="$rownr"/>
<xsl:for-each select="col">
<xsl:text>,</xsl:text>
<xsl:choose>
<xsl:when test="@typ='1'"><xsl:text>'</xsl:text>
<xsl:call-template name="remove_linebreaksAndQuot">
<xsl:with-param name="volltext" select="wert" />
</xsl:call-template>
<xsl:text>'</xsl:text></xsl:when>
<!--todo:Typ Datum --> 
<xsl:when test="string-length(wert)=0"><xsl:text>null</xsl:text>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="wert"/>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
<xsl:text>));
</xsl:text>
</xsl:for-each>


</script>
</xsl:template>
<xsl:template name="getColumnNameJS">
<xsl:param name="columnNameFromDB" />
<xsl:choose>
<xsl:when test="contains($columnNameFromDB,'?')">
<xsl:value-of select="concat('column_',@id+1)"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="$columnNameFromDB"/>
</xsl:otherwise>
</xsl:choose>
</xsl:template>
<xsl:template name="vizAssistentCSS">
<style type="text/css">
textarea.editform {
    height: 4em;
    width: 100%;
    padding: 3px;
    transition: all 0.5s ease;
}

textarea.editform:focus {
    height: 40em;
}
</style>
</xsl:template>

<!-- start Javascript-->
<xsl:template name="importEchartsLibs">
<script language="JavaScript" type="text/javascript" src="../xml/js/viz/echarts.min.js"></script>
<script language="JavaScript" type="text/javascript" src="../xml/js/viz/echarts_langDE.js"></script>
</xsl:template>
<xsl:template name="importd3jsLibs">
<script language="Javascript" type="text/javascript" src="../xml/js/viz/d3.min.js" />
<script language="Javascript" type="text/javascript" src="../xml/js/viz/d3-sankey.js" />
<style type="text/css">

.node rect {
  cursor: move;
  fill-opacity: .9;
  shape-rendering: crispEdges;
}

.node text {
  pointer-events: none;
  text-shadow: 0 1px 0 #fff;
}

.link {
  fill: none;
  stroke: #000;
  stroke-opacity: .2;
}

.link:hover {
  stroke-opacity: .5;
}
</style>
</xsl:template>
<xsl:template name="importPlotLibs">
<script language="Javascript" type="text/javascript" src="../xml/js/viz/d3.min.js" />
<script language="Javascript" type="text/javascript" src="../xml/js/viz/plot.js" />
</xsl:template>

<xsl:template name="importVizJavascriptLibs">
<script language="Javascript" type="text/javascript" src="../xml/js/viz/d3.min.js" />
<script language="Javascript" type="text/javascript" src="../xml/js/viz/plot.js" />
<script language="Javascript" type="module" src="../xml/js/viz/d3-sankey.js" />
<xsl:for-each select="/ergebnisse/ergebnis/ergebniselement/vizTypes/vizType[@srcpath !='/superx/xml/js/viz/d3.min.js' 
and @srcpath != '/superx/xml/js/viz/plot.js'
and @srcpath != '/superx/xml/js/viz/d3-sankey.js'
and @srcpath != ''
and (@renderer_uniquename='plot' or @renderer_uniquename='d3js') ]">
<script language="Javascript" type="text/javascript" src="{@srcpath}" />
</xsl:for-each>
</xsl:template>
<xsl:template name="modalCards" >
<xsl:param name="kachelbreite" select="600"/>
<xsl:param name="kachelhoehe" select="400"/>

<xsl:for-each select="/ergebnisse">
<xsl:for-each select="ergebnis/ergebniselement">
<xsl:variable name="chart_uniquename"><xsl:value-of select="../felder/feld[@varname='Grafik']/value" /></xsl:variable>
<xsl:variable name="ergebniselement_ordnr"><xsl:value-of select="@ordnr" /></xsl:variable>
<xsl:if test="$chart_uniquename != ''">
<div  class="modal modal-fx-3dSlit" id="{concat('modalCard',$ergebniselement_ordnr)}">
  <div class="modal-background"></div>
      <div class="modal-content is-huge is-image">
        <!-- content -->

  <div class="modal-content">
  <div class="box" style="text-align:right">
   <a href="{concat('javascript:closeModalImage(',$ergebniselement_ordnr,');')}">
     <span class="button is-black is-outlined"> X </span>
     </a>
  </div>
    <div class="box">
      <div id="{concat('modalCardImage',$ergebniselement_ordnr)}">
      
      </div>
      </div>
    </div>
  </div>
 
</div>

<div  class="modal modal-fx-3dSlit" id="{concat('modalCardDetail',$ergebniselement_ordnr)}">
  <div class="modal-background"></div>
     <div class="modal-content is-tiny">
     <div class="box" style="text-align:right">
     <h4><xsl:value-of select="viz_charts/viz_chart[@uniquename=$chart_uniquename]/@caption"/></h4>
     <a href="{concat('javascript:closeModalCardDetail(',$ergebniselement_ordnr,');')}">
     <span class="button is-black is-outlined"> X </span>
     </a>
  </div>
        <!-- content -->
        <div class="card">
          <div class="card-image">
      <div id="{concat('modalCardDetailImage',$ergebniselement_ordnr)}">
<xsl:attribute name="style"><xsl:value-of select="concat('width:',$kachelbreite,'px;height:',$kachelhoehe,'px;')" />
</xsl:attribute>
      <!--<div id="{concat('chartDiv',$ergebniselement_ordnr)}">
</div>-->
      
      </div>
      </div>
      
       <div class="card-content">
            <div class="media">
              <div class="media-content">
	      <p style="font-size:1rem"><xsl:value-of select="viz_charts/viz_chart[@uniquename=$chart_uniquename]/@description"/></p>
            <p class="legende" style="font-size:1rem">
<xsl:for-each select="../felder/feld">
	<xsl:if test="(value !='' or sicht/@isFirstInGroup='false' or @isstandtoday='false')  and @varname != 'sort' and @varname != 'maxoffset' and value_caption != ''">

		<span class="feldname">
		<xsl:choose>
		<xsl:when test="string-length(caption_short) &gt; 0 and caption_short != 'null'" >
		<![CDATA[]]><xsl:value-of select="caption_short" /><![CDATA[]]>
		</xsl:when>
		<xsl:otherwise>
		<xsl:value-of select="@varname" />
		</xsl:otherwise>
		</xsl:choose></span>:&#160;
		<xsl:if test="string-length(value_caption) &lt; 50">
					<span class="feldwert"><xsl:value-of select="value_caption" /><![CDATA[]]></span>
		</xsl:if>
			<xsl:if test="string-length(value_caption) &gt; 49">
			<span class="feldwert"><![CDATA[]]><xsl:value-of select="substring(value_caption,0,50)" /><![CDATA[]]>...</span>
		</xsl:if>
		<xsl:if test="sicht!=''">
			<span><![CDATA[ (]]><xsl:value-of select="sicht" />
			<xsl:if test="@stand!=''"><xsl:text> - Stand:</xsl:text><xsl:value-of select="@stand"/></xsl:if>
			<xsl:text><![CDATA[)]]>	</xsl:text></span>
			
		</xsl:if>
	;
	</xsl:if>

</xsl:for-each>
User: <xsl:value-of select="/ergebnisse/user"/>&#160;
Stand: <xsl:value-of select="../stand" /></p>
<xsl:if test="../hinweis != ''">
<xsl:call-template name="newline_to_br">
	<xsl:with-param name="string" select="../hinweis" />
</xsl:call-template>
</xsl:if>
              </div>
	      <p align="right"><a href="{concat('javascript:closeModalCardDetail(',$ergebniselement_ordnr,');')}">
     <span class="button is-black is-outlined"> X </span>
     </a></p>
            </div>
            
          </div>
    </div>
  </div>
 
</div>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:template>



<xsl:template name="viz_viewer_grid">
<xsl:param name="openModalCardDetail" select="'true'" />
<!-- Variableninitialisierung fürs Dashboard:
-->
<xsl:variable name="spalten_anz">
<!--<xsl:value-of select="2"/>-->
<xsl:value-of select="/ergebnisse/ergebnis/completefields/feld[@varname='Spaltenanzahl']/value"/>
</xsl:variable>
<xsl:variable name="kachelbreite">
<xsl:value-of select="/ergebnisse/ergebnis/completefields/feld[@varname='Kachelbreite']/value"/>
</xsl:variable>
<xsl:variable name="kachelhoehe">
<xsl:value-of select="/ergebnisse/ergebnis/completefields/feld[@varname='Kachelhöhe']/value"/>
</xsl:variable>

<xsl:variable name="ergebniselemente_anz">
<xsl:value-of select="count(/ergebnisse/ergebnis[completefields/feld[@varname='Grafik']])"/>
</xsl:variable>
<xsl:variable name="kachelbreite_bulma">
<xsl:value-of select="round($kachelbreite div 24)"/><!-- 1 em=16px, für bulma dann *1,5 -->
</xsl:variable>
<xsl:variable name="kachelbreite_em">
<xsl:value-of select="round($kachelbreite div 24 * 1.5)"/><!-- 1 em=16px, für bulma dann *1,5 -->
</xsl:variable>
<!--<p>plan: <xsl:value-of select="/ergebnisse/ergebnis/felder/feld[@varname='Spaltenanzahl']/value"/>
</p>-->
<!--<span class="separator">&#160;</span>-->
<!--Beginn Selektions-Card-->
<!--Beginn Berichtstitel, Pfad, Knopfleiste-->
<!--<section class="hero-body">
<section class="container">--> <!--Beginn Kartenreihe -->

<div>
<xsl:choose>
<xsl:when test="$spalten_anz='0'">
<xsl:attribute name="class"><xsl:value-of select="concat('grid is-col-min-',$kachelbreite_bulma)" /></xsl:attribute>
<!--wegen eines Bugs in Bulma muss man style noch zusätzlich anfügen, wird in zukünftigen Bulma Versionen nicht mehr nötig sein:-->
<xsl:attribute name="style"><xsl:value-of select="concat('--bulma-grid-column-min:',$kachelbreite_em,'em')" /></xsl:attribute>

<!--<xsl:attribute name="class"><xsl:value-of select="'grid'" /></xsl:attribute>-->
<xsl:call-template name="viz_viewer_grid_cells" >
<xsl:with-param name="kachelbreite" select="$kachelbreite"/>
<xsl:with-param name="kachelhoehe" select="$kachelhoehe"/>
<xsl:with-param name="openModalCardDetail" select="$openModalCardDetail" />
</xsl:call-template>
</xsl:when>
<xsl:otherwise><!--nicht dynamisch-->
<xsl:attribute name="class"><xsl:value-of select="concat('fixed-grid has-',$spalten_anz,'-cols')" /> 
</xsl:attribute>
<div class="grid" style="margin-top: 1rem;">
<xsl:call-template name="viz_viewer_grid_cells" >
<xsl:with-param name="kachelbreite" select="$kachelbreite"/>
<xsl:with-param name="kachelhoehe" select="$kachelhoehe"/>
<xsl:with-param name="openModalCardDetail" select="$openModalCardDetail" />
</xsl:call-template>
</div>
</xsl:otherwise>
</xsl:choose>
<!--Beginn columns Kartenreihe -->


</div><!-- des grid -->

<!-- der section -->
<!--
</section>
</section>--><!-- des Portals -->
</xsl:template>	

<xsl:template name="viz_viewer_grid_cells">
<xsl:param name="kachelbreite" select="800"/>
<xsl:param name="kachelhoehe" select="600"/>
<xsl:param name="openModalCardDetail" select="'true'" />

<xsl:for-each select="ergebnisse/ergebnis[felder/feld[@varname='Grafik']/value!='']/ergebniselement">
<xsl:variable name="ergebniselement_counter" select="position()" />
<xsl:variable name="chart_uniquename"><xsl:value-of select="../felder/feld[@varname='Grafik']/value" /></xsl:variable>
<xsl:variable name="ergebniselement_ordnr"><xsl:value-of select="@ordnr" /></xsl:variable>
<xsl:variable name="maskennummer"><xsl:value-of select="@id" /></xsl:variable>


<!--<p><xsl:value-of select="concat('Zähler: ',$ergebniselement_counter)"/></p>-->
<!--
<div>
<xsl:attribute name="class"><xsl:text>column is-</xsl:text><xsl:value-of select="$colwidth"/></xsl:attribute>-->
<div class="cell">
	<xsl:call-template name="weiterverarbeitungHiddenInputs" >
		<xsl:with-param name="formName" select="concat('frmTab',$ergebniselement_ordnr)" />
		<xsl:with-param name="ergebniselement_ordnr" select="$ergebniselement_ordnr" />
	</xsl:call-template>

<xsl:call-template name="viewer_kachel">
<xsl:with-param name="caption" select="viz_charts/viz_chart[@uniquename=$chart_uniquename]/@caption"/>
<xsl:with-param name="ergebniselement_ordnr" select="$ergebniselement_ordnr" />
<xsl:with-param name="kachelbreite" select="$kachelbreite - 5 "/><!-- wegen abgerundeter Ecken etwas kleiner-->
<xsl:with-param name="kachelhoehe" select="$kachelhoehe - 15"/>
<xsl:with-param name="chart_tid" select="viz_charts/viz_chart[@uniquename=$chart_uniquename]/@tid"/>
<xsl:with-param name="showEdit" select="/ergebnisse/user/@admin" />
<xsl:with-param name="link_maskennummer" select="$maskennummer"/>
<xsl:with-param name="link_chart_uniquename" select="$chart_uniquename" />
<xsl:with-param name="link_tablestylesheet" select="'viz_html_chart_viewer_mask_and_table.xsl'"/>
<xsl:with-param name="openModalCardDetail" select="$openModalCardDetail" />
</xsl:call-template>
<!--<p><xsl:value-of select="concat($spalten_anz,'-',$ergebniselement_counter,':',$ergebniselement_counter mod $spalten_anz)"/></p>-->
</div>
</xsl:for-each>
</xsl:template>

<xsl:template name="viewer_kachel">
<xsl:param name="caption" />
<xsl:param name="ergebniselement_ordnr" />
<xsl:param name="kachelbreite" select="800"/>
<xsl:param name="kachelhoehe" select="600"/>
<xsl:param name="link_maskennummer" />
<xsl:param name="link_chart_uniquename" />
<xsl:param name="chart_tid" />
<xsl:param name="link_tablestylesheet" select="'viz_html_chart_viewer_mask_and_table.xsl'"/>
<xsl:param name="showEdit" select="'false'" /> 
<xsl:param name="openModalCardDetail" select="'true'" />
<div class="card is-shady">

<div class="card-image" id="{concat('cardImage',$ergebniselement_ordnr)}">
<!--zum Debuggen: <a onClick="initPage()">Anzeigen</a><br />-->
<xsl:choose>
<xsl:when test="$openModalCardDetail='true'">
<a onClick="{concat('javascript:openModalCardDetail(',$ergebniselement_ordnr,');')}">

<div id="{concat('chartDiv',$ergebniselement_ordnr)}" style="{concat('width: ',$kachelbreite,'px;height:',$kachelhoehe,'px;')}"></div>
</a> 
<xsl:if test="$link_maskennummer!=''">
<br /> 
<!--<a href="{concat('../servlet/SuperXmlTabelle?tid=',$link_maskennummer,'&amp;Grafik=',$link_chart_uniquename,'&amp;tablestylesheet=',$link_tablestylesheet)}">Details...</a>-->
<a>
<xsl:attribute name="onclick">
<xsl:text>openKachelDetails(</xsl:text><xsl:value-of select="$ergebniselement_ordnr"/>
<xsl:text>,'</xsl:text>
<xsl:value-of select="concat('frmTab',$ergebniselement_ordnr)" />
<xsl:text>',</xsl:text>
<xsl:value-of select="$link_maskennummer" />
<xsl:text>,'</xsl:text>
<xsl:value-of select="$link_chart_uniquename" />
<xsl:text>','</xsl:text>
<xsl:value-of select="$link_tablestylesheet" />
<xsl:text>',false);</xsl:text>
</xsl:attribute>
Details...
</a>
</xsl:if>
</xsl:when>
<xsl:otherwise>
<a>
<xsl:attribute name="onclick">
<xsl:text>openKachelDetails(</xsl:text><xsl:value-of select="$ergebniselement_ordnr"/>
<xsl:text>,'</xsl:text>
<xsl:value-of select="concat('frmTab',$ergebniselement_ordnr)" />
<xsl:text>',</xsl:text>
<xsl:value-of select="$link_maskennummer" />
<xsl:text>,'</xsl:text>
<xsl:value-of select="$link_chart_uniquename" />
<xsl:text>','</xsl:text>
<xsl:value-of select="$link_tablestylesheet" />
<xsl:text>',false);</xsl:text>
</xsl:attribute>
<div id="{concat('chartDiv',$ergebniselement_ordnr)}" style="{concat('width: ',$kachelbreite,'px;height:',$kachelhoehe,'px;')}"></div>
</a> 
</xsl:otherwise>
</xsl:choose>

<xsl:if test="$showEdit='true' and $chart_tid!=''">
<span class="separator">&#160;|&#160; </span>
<a aria-haspopup="true">
<xsl:attribute name="onClick"><xsl:text>javascript:neu=window.open('/superx/edit/viz/viz_chart_edit.jsp?tid=</xsl:text>
<xsl:value-of select="$chart_tid"/><xsl:text>','_blank','directories=no,location=no,menubar=no,scrollbars=yes,resizable=yes,toolbar=no,width=800,height=600'); return false;</xsl:text>
</xsl:attribute>
 				Bearbeiten...
				</a>
			 

</xsl:if>

</div>
</div>

</xsl:template>
<xsl:template name="viewer_kachel_alt">
<xsl:param name="caption" />
<xsl:param name="ergebniselement_ordnr" />
<div class="card is-shady">
<div class="card-image">

<div id="{concat('chartDiv',$ergebniselement_ordnr)}">
Platzhalter
</div>

</div>
<p>
<a onClick="{concat('javascript:openModalImage(',$ergebniselement_ordnr,');')}">
<span class="button is-success is-small modal-button">Vergrößern ...</span></a>
 
<a onClick="{concat('javascript:openModalCardDetail(',$ergebniselement_ordnr,');')}">
<span class="button is-link is-inverted is-small modal-button">Mehr Infos ...</span></a>

</p>

              </div>

</xsl:template>
<!-- Templates für Maskenfelder in Tabellen: -->
<xsl:template name="renderTableDialogs" >
<xsl:param name="ergebniselementOrdnr" select="0" /> 
<xsl:param name="stylesheet" select="'tabelle_html_viz.xsl'" /> 
<xsl:param name="collapsible" select="'false'" />

<xsl:variable name="maskentid">
<xsl:choose>
<xsl:when test="/ergebnisse/@isMakro='true'">
<xsl:value-of select="/ergebnisse/makro/@id" />
</xsl:when>
<xsl:otherwise> 
<xsl:value-of select="/ergebnisse/ergebnis/maskenname/@id" />
</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<div style="float:right">
<form name="Weiterverarbeitung"  method="post" target="_self" charset="UTF-8" action="SuperXmlTabelle">
	<input name="navi" type="hidden" value="{/ergebnisse/@showNavigation}" />

<input type="hidden" name="tid" value="{$maskentid}">
</input>
<input type="hidden" name="UserID"><xsl:attribute name="value"><xsl:value-of select="/ergebnisse/userID" /></xsl:attribute></input>
<input type="hidden" name="reuseresult" value="false"/> <!--  gecachte Ergebnis benutzen-->
<input type="hidden" name="maxoffset" value=""/> <!--im Normalfall wird Servleteinstellung genutzt - nur Druckversion übergibt Wert-->
<input type="hidden" name="offset">
<xsl:attribute name="value"><xsl:value-of select="/ergebnisse/ergebnis/ergebniselement/sqlerg/@offset" /></xsl:attribute> 
</input>
<input type="hidden" name="stylesheet" value="{$stylesheet}" />
<input type="hidden" name="contenttype" value="" />
  <!-- MB 5/2011 fuer Export nur sichtbarer Tabellenzeilen nach Excel/PDF -->
<input type="hidden" name="irowno" value="" />
<!-- Start Schleife alle Maskenfelder-->
<xsl:for-each select="/ergebnisse/ergebnis[@ordnr=$ergebniselementOrdnr]/completefields/feld">
	<xsl:variable name="feldname"><xsl:value-of select="@varname" /></xsl:variable>
	<xsl:variable name="feldcaption"><xsl:value-of select="caption_short" /></xsl:variable>
	<xsl:variable name="feldnameEscaped"><xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="@varname"/></xsl:with-param></xsl:call-template></xsl:variable> 
	<xsl:variable name="feldart">
	<xsl:call-template name="getFeldArt">
<xsl:with-param name="feldname" select="$feldname"/>
</xsl:call-template>
</xsl:variable>
<xsl:variable name="showFieldValueInLegend">
	<xsl:call-template name="showFieldValueInLegend">
<xsl:with-param name="feldname" select="$feldname"/>
</xsl:call-template>
</xsl:variable>
<xsl:variable name="feldZeilenanzahl">
<xsl:variable name="t1">
	<xsl:call-template name="getFeldZeilenanzahl">
<xsl:with-param name="feldname" select="$feldname"/>
</xsl:call-template>
</xsl:variable>
<xsl:choose>
<xsl:when test="$t1=''">
<xsl:text>1</xsl:text>
</xsl:when>
<xsl:otherwise><xsl:value-of select="$t1"/>
</xsl:otherwise>
</xsl:choose>
</xsl:variable>


<xsl:choose>
<xsl:when test="$feldname='##line##' or $feldname='Dashboard'">
<!-- do nothing-->
</xsl:when>
<xsl:when test="$showFieldValueInLegend='false'  or $feldname='tablestylesheet' or $feldname='Grafik'  or $feldname='Spaltenlayout' or $feldart='0' or $feldart='13'">
<!--verstecktesFeld oder Eingabefeld-->
<xsl:text disable-output-escaping="yes"><![CDATA[<input type="hidden" name="]]></xsl:text><xsl:value-of disable-output-escaping="no" select="@varname"/><xsl:text>" value="</xsl:text>
          <xsl:value-of disable-output-escaping="no" select="value"/><xsl:text>"</xsl:text>
            <xsl:text disable-output-escaping="yes"><![CDATA[</input>
	    ]]></xsl:text> 
</xsl:when>
<xsl:when test="$feldart='1' or $feldart='12'">

<xsl:call-template name="tabellenFeldComboOderSicht">
<xsl:with-param name="maskeninfo_id" select="$maskentid"/>
<xsl:with-param name="Feldname" select="$feldname"/>
<xsl:with-param name="Feldcaption" select="$feldcaption"/>
<xsl:with-param name="FeldnameEscaped" select="$feldnameEscaped"/>
<xsl:with-param name="feldZeilenanzahl" select="$feldZeilenanzahl"/>
<xsl:with-param name="feldart" select="$feldart"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise><xsl:value-of select="concat('Feld ',$feldname,' ist nicht geeignet für Tabellenaufrufe')"/>
<br />
</xsl:otherwise>
</xsl:choose>
	</xsl:for-each>
	<div class="field is-grouped">
	<div class="vizLabel-container">
	<label class="label is-small trennung">
	
	<span class="button" style="background: #a6a6a6ff; border: thin solid rgba(0, 76, 147, 240); color: white; font-weight:bold;font-size:1.5em;" onclick="document.forms[0].elements['reuseresult'].value='false';document.getElementById('progressbar').style.display='block';document.forms['Weiterverarbeitung'].submit();return true;">
	Neu laden...
	</span>
	</label>
				<!--<input type="submit" class="sx_buttondiv_submit" value="Neu laden..." onclick="document.forms['Weiterverarbeitung'].elements['reuseresult'].value='false';document.forms['Weiterverarbeitung'].elements['stylesheet'].value='tabelle_html_viz.xsl';return true;" />-->
			</div>
	</div>
</form>
</div>
</xsl:template>

<xsl:template name="tabelleSicht">
<div dojoType="dialog" id="sichtdlg" bgColor="darkgray" bgOpacity="0.7" toggle="fade" toggleDuration="100" 
  closeNode="ok" style="z-index:1012;display:none">
	<form name="treedlgform" onsubmit="return false;">
	<center>
	<table align="center" cellpadding="0">
	<tr><td colspan="2" class="header" id="sichtElementName" align="center">Auswahl</td></tr>
	<tr>
	<td id="sicht" class="sichtstand"  align="center"><b>Sicht:</b> ausgewählte Sicht</td><td id="sichtbutton"  class="sichtstand"><input  class="submit_pencil" id="Sichtauswahl" type="button" value="Sichtauswahl" onclick="sichtauswahl.show()"></input></td>
	</tr>
	<tr><td id="stand" class="sichtstand" align="center"><b>Stand:</b> 1.1.2007</td><td id="standbutton" class="sichtstand"><input  class="submit_pencil" id="Standauswahl" type="button" value="ändern" onclick="dojo.widget.byId('Standeingabedlg').show();"></input></td>
	</tr>
	</table>
	</center>
	<div 
          dojoType="TreeSelectorV3" 
          widgetId="treeSelector" 
	  allowedMulti="false" 
          id="treeSelector" eventNames="select:nodeSelected">
          <xsl:text> </xsl:text>
        </div>
	<div dojoType="TreeEmphasizeOnSelect" selector="treeSelector"></div>
	<div dojoType="memtext:TreeLoadingControllerSx" id="treeLoadingController" widgetId="treeLoadingController">
	<xsl:attribute name="RPCUrl">/superx/servlet/SuperXmlMaske?tid=<xsl:value-of select="/ergebnisse/ergebnis[@ordnr='0']/maskenname/@id"/></xsl:attribute>
	</div>
        <div style="height:325px;overflow:scroll"><!-- IE needs non-dojo div vor scrolling-->
	<div dojoType="memtext:MemTree" widgetId="selTree"    id="selTree"     listeners="treeLoadingController;treeSelector">
	<div dojoType="TreeNodeV3"   title="keine Auswahl möglich" ></div>
	       </div>
	       </div>
	<br/>
	<center>
	<label id="sichthintmulti">Sie können einen oder mehrere Einträge auswählen (<a href="javascript:alert('Halten Sie beim Anklicken Strg gedrückt, um mehrere Einträge auszuwählen.');">Hinweis</a>)</label>
	<p align="center">
	<input type="button"  class="submit" 
	onclick="document.getElementById('suchok').style.display='';document.getElementById('suchselect').style.display='none';document.getElementById('suchuebernehmen').style.display='none';dojo.widget.byId('suchdlg').show();"
	value="Suchen"></input>&#160;
	</p>
	<p align="center">
	<input type="button" id="abbrechen"  class="submit" onclick="sichtdlg.hide();zeigeCombosIE6();" value="Abbrechen"></input>&#160;
		<input type="button" id="ok"  class="submit" onclick="maskeSichtauswahlUebernehmen();" value="OK"></input>&#160;&#160;&#160;&#160;&#160;
		<input type="button" id="leeren"  class="submit" onclick="dojo.widget.byId('treeSelector').deselectAll();maskeSichtauswahlUebernehmen();sichtdlg.hide();" value="Leeren"></input>
		</p>
		</center>
	</form>
</div>
  <div dojoType="dialog" id="sichtauswahl" bgColor="darkgray" bgOpacity="0.7" toggle="fade" toggleDuration="100" closeNode="ok"
  style="z-index:1014;display:none">
  <h3 align="center">Sicht auswählen</h3>
  <form name="sichtauswahlform">
  <p align="center">
   <select name="sichtselect">
   <option value="-999">keine Auswahl möglich</option>
   </select>
   </p>
  <p align="center">
  <input type="button"  class="clsButtonStyle" id="abbrechen2" onclick="sichtauswahl.hide()" value="Abbrechen">&#160;</input>
<input type="button" id="ok2"  class="clsButtonStyle" onclick="maskeSichtAendern()" value="OK"></input>
	</p>
	</form>
  </div>
<!-- end sicht -->
<!-- start suchdlg -->
  <div dojoType="dialog" id="suchdlg" bgColor="darkgray" bgOpacity="0.7" toggle="fade" toggleDuration="100" style="z-index:1015;display:none">
  <h3 align="center">Suche</h3>
 <form name="suchform" onsubmit="return false;"> <!-- theoretisch könnte man form sogar weglassen, weil gar nicht gepostet werden soll -->
  <p align="center">
   <input type="text" id="suchtext" onkeypress="enterClicksButton('suchok',event)"></input>
   </p>
   <p align="center">
    <select id="suchselect" size="10">
   
   </select>
</p>
  <p align="center">
  <input type="button"  class="clsButtonStyle" id="abbrechen" onclick="dojo.widget.byId('suchdlg').hide();" value="Abbrechen">&#160;</input>
  <input type="button" id="suchok"  class="clsButtonStyle" onclick="sichtEintraegeSuchen(document.getElementById('suchtext').value);" value="OK"></input>
<input type="button" id="suchuebernehmen"  class="clsButtonStyle" onclick="dojo.widget.byId('suchdlg').hide();combodlg.hide();sichtdlg.hide();suchauswahlUebernehmen();" value="Übernehmen"></input>
	</p>
	</form>
  </div> 
  
  <!-- end suchdlg -->
</xsl:template>
<xsl:template name="tabellenFeldComboOderSicht">
<xsl:param name="maskeninfo_id" />
<xsl:param name="Feldname" />
<xsl:param name="Feldcaption" />
<xsl:param name="FeldnameEscaped" />
<xsl:param name="feldZeilenanzahl" select="1"/>
<xsl:param name="feldart" select="1"/>
<xsl:variable name="capNotNull">
<xsl:choose>
<xsl:when test="$Feldcaption !='' and $Feldcaption !='null' ">
<xsl:value-of select="$Feldcaption"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="$Feldname"/>
</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="jsCall"><xsl:text>vizTabelleComboOderSichtLaden(</xsl:text>
			   <xsl:value-of select="$maskeninfo_id" />
			   <xsl:text>,'</xsl:text>
			   <xsl:value-of select="$Feldname"/>
			   <xsl:text>','</xsl:text>
			   <xsl:value-of select="$capNotNull"/>
			   <xsl:text>','</xsl:text>
			   <xsl:value-of select="$FeldnameEscaped"/>
			   <xsl:text>',</xsl:text>
			   <xsl:value-of select="$feldZeilenanzahl"/>
			   <xsl:text>,'</xsl:text>
			   <xsl:value-of select="$feldart"/>
			   <xsl:text>','</xsl:text>
			   <xsl:value-of select="'Weiterverarbeitung'"/>
			   <xsl:text>');</xsl:text>
</xsl:variable>			  
<div class="field is-grouped">
		  <div class="vizLabel-container" lang="de">
		   <label class="label is-small trennung">
			   <span class="button is-link is-link is-outlined  is-hovered" style="font-weight:bold;font-size:1.5em">
			   <!--<a class="button is-link is-outlined is-small is-fullwidth">--> 
			   <xsl:attribute name="onClick">
			   	<xsl:value-of select="$jsCall"/>
			   </xsl:attribute>
			   
			   <xsl:value-of select="$capNotNull"/></span>
		   </label>
		  </div>
		  
		  <!--<div class="control-new">-->
		  <div class="vizLabel-container" lang="de">
		  <div class="field has-addons">
			<input class="schluesselfeld" type="text" size="15" style="display:none"  id="{$FeldnameEscaped}" name="{$Feldname}" tabindex="511">
				<xsl:attribute name="value"><xsl:value-of select="/*/*/felder/feld [@varname = $Feldname]/value"/></xsl:attribute>
			</input>
		<div class="control is-expanded">			
			<input class="input  is-small is-link is-fullwidth" style="font-size:1.1rem;font-weight:normal" type="label" readonly="true" name="{concat('label_',$FeldnameEscaped)}" id="{concat('label_',$FeldnameEscaped)}">
<xsl:attribute name="onclick"><xsl:value-of select="$jsCall"/>
			   </xsl:attribute>
			   <xsl:attribute name="value"><xsl:value-of select="/*/*/felder/feld [@varname = $Feldname]/value_caption"/></xsl:attribute>
			   </input>
			<xsl:if test="$feldart='12'">
			<input type="hidden">
       
       
       <xsl:attribute name="value">
       <xsl:choose>
       <xsl:when test="../../felder/feld[@varname=$Feldname]/@stand !=''">
       <xsl:value-of select="../../felder/feld[@varname=$Feldname]/@stand"/>
       </xsl:when>
       <xsl:otherwise>
	<xsl:attribute name="value"><xsl:value-of select="'01.01.2024'"/>
	</xsl:attribute>
	</xsl:otherwise>
	</xsl:choose>
            
          </xsl:attribute>
	
	  <xsl:attribute name="name">
            <xsl:value-of select="concat($Feldname,'-Stand')"/>
          </xsl:attribute>
	 </input>
	 <xsl:if test="../../felder/feld[@varname=$Feldname]/sicht/@name_intern !=''">
	<input type="hidden">
       <xsl:attribute name="name">
            <xsl:value-of select="concat($Feldname,'-Sicht')"/>
          </xsl:attribute>
	  <xsl:attribute name="value">
            <xsl:value-of select="../../felder/feld[@varname=$Feldname]/sicht/@name_intern"/>
          </xsl:attribute>
	  </input>
	  </xsl:if>
	  </xsl:if>
	  </div>
	  <div class="control">
	  <button class="button is-small is-rounded is-link has-tooltip-bottom"  style="font-size:1.1rem;font-weight:normal;" onclick="return false;" tabindex="1353" data-tooltip="Muss noch ergänzt werden.">
	  <span class="icon" aria-hidden="true">
					<img src="../images/information_white_liberation.svg" alt="Info" title="Info" /></span>
				</button>
       	</div><!--Ende control -->
	
			</div>
			
		  </div>
		</div>
</xsl:template>


<xsl:template name="getFeldArt">
<xsl:param name="ergebniselement_ordnr" select="0" />
<xsl:param name="feldname" />
<xsl:value-of select="/ergebnisse/ergebnis[@ordnr=$ergebniselement_ordnr]/completefields/feld[@varname=$feldname]/@art"/>

</xsl:template>
<xsl:template name="getFeldWert">
<xsl:param name="ergebniselement_ordnr" select="0" />
<xsl:param name="feldname" />
<xsl:value-of select="/ergebnisse/ergebnis[@ordnr=$ergebniselement_ordnr]/completefields/feld[@varname=$feldname]/value"/>

</xsl:template>
<xsl:template name="getFeldSichtStand">
<xsl:param name="ergebniselement_ordnr" select="0" />
<xsl:param name="feldname" />
<xsl:choose>
<xsl:when test="/ergebnisse/ergebnis[@ordnr=$ergebniselement_ordnr]/felder/feld[@varname=$feldname]/@stand !=''">
<xsl:value-of select="/ergebnisse/ergebnis/felder/feld[@varname=$feldname]/@stand"/>
</xsl:when>
<xsl:otherwise>
<xsl:text>01.01.2025</xsl:text>
</xsl:otherwise>
</xsl:choose>
</xsl:template>
<xsl:template name="getFeldSichtNameIntern">
<xsl:param name="ergebniselement_ordnr" select="0" />

<xsl:param name="feldname" />
<xsl:value-of select="/ergebnisse/ergebnis[@ordnr=$ergebniselement_ordnr]/felder/feld[@varname=$feldname]/sicht/@name_intern"/>

</xsl:template>

<xsl:template name="getFeldZeilenanzahl">
<xsl:param name="ergebniselement_ordnr" select="0" />
<xsl:param name="feldname" />
<xsl:value-of select="/ergebnisse/ergebnis[@ordnr=$ergebniselement_ordnr]/completefields/feld[@varname=$feldname]/@zeilenanzahl"/>

</xsl:template>
<xsl:template name="tableMaskenfelderJS">
<script language="Javascript"><xsl:text><![CDATA[

      var felder = new Array();
       ]]></xsl:text>
       <xsl:for-each select="/ergebnisse/ergebnis[@ordnr='0']/completefields/feld">
       <xsl:text>felder[</xsl:text><xsl:value-of select="position()" /><xsl:text>]= new Object();
       felder[</xsl:text><xsl:value-of select="position()" /><xsl:text>]["htmlname"]='</xsl:text><xsl:value-of select="@varname"/><xsl:text>';
       felder[</xsl:text><xsl:value-of select="position()" /><xsl:text>]["name"]='</xsl:text><xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="@varname"/></xsl:with-param></xsl:call-template><xsl:text>';
       </xsl:text>
       </xsl:for-each>

</script>
</xsl:template>
<xsl:template name="getChartModel">
<xsl:param name="chart_uniquename" />
<xsl:param name="useMiniatureIfAvailable" select="'true'"/> 
<xsl:variable name="chartModel">
<xsl:choose>
<xsl:when test="$useMiniatureIfAvailable='true' and viz_charts/viz_chart[@uniquename=$chart_uniquename]/@chartmodel_miniature !=''">
<xsl:value-of select="viz_charts/viz_chart[@uniquename=$chart_uniquename]/@chartmodel_miniature"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="viz_charts/viz_chart[@uniquename=$chart_uniquename]/@chartmodel"/>
</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:value-of select="translate($chartModel,'§',$quote)"/>
</xsl:template>

<xsl:template name="viz_navi_top">
<xsl:param name="ergebniselement_ordnr" select="0" />
<nav class="navbar is-fixed-top" >
 
   <div class="navbar-brand">
	<div class="navbar-item" >
	<div class="pagetitle">
			<p style="font-weight:bolder;font-size:2em;">
			<xsl:choose>
<xsl:when test="/ergebnisse/@isMakro='true'"><xsl:value-of select="/ergebnisse/makro/name"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="/ergebnisse/ergebnis[@ordnr=$ergebniselement_ordnr]/maskenname"/>
</xsl:otherwise>
</xsl:choose>
</p>
			<!--<p><xsl:call-template name="nd_legendeHeaderContent" /></p>-->
		    </div>
	    
	    
	</div>    
   </div>
   <div class="navbar-end">
   	<a class="navbar-item" target="_self" href="{/*/generalinfo/REPORT_HEADING_URL }">
		   <img src="{/*/generalinfo/REPORT_LOGO_FILE}" alt="Zur Startseite der Institution" title="Zur Startseite" height="30px" style="height:30px"/>
		</a>
    </div>
    </nav>
</xsl:template>
<xsl:template name="viz_header_dashboard">
<xsl:variable name="tabnr" select="/ergebnisse/ergebnis[@ordnr='0']/felder/feld[@varname='Tabnr.']/value" />
<xsl:variable name="bookletStylesheet" select="/ergebnisse/ergebnis[@ordnr='0']/ergebniselement/sqlerg/row[col[f_name='ord']/wert=$tabnr]/col[f_name='hidden_booklet_stylesheet']/wert" />

<header style="padding-top:2rem;"> 
<div class="hs_header" style="padding-bottom:0px;margin-bottom:0px"> 
               <div style="padding-bottom:0px;margin-bottom:0px;border-bottom:none;">
	       <div class="columns" style="margin-left:15px;  margin-right:15px; margin-bottom:0px;background-color:#ebf1f3;"> 
		     <xsl:for-each select="/ergebnisse/ergebnis[@ordnr='0']/ergebniselement/sqlerg/row [col[f_name='wert']/wert !='']">
		     <div class="column">
		     <span style="font-size:2rem;font-weight:bolder"><xsl:value-of select="col[f_name='wert']/wert"/></span><br />
		     <!--<span style="font-size:1rem;font-weight:bolder;color:red"><xsl:value-of select="col[f_name='kennz']/wert"/></span>-->
		     <span style="font-size:1rem;font-weight:bolder;color:#C00000;"><xsl:value-of select="col[f_name='kennz']/wert"/><xsl:text> (</xsl:text><xsl:value-of select="../../../felder/feld [@varname='Bis Semester']/value_caption"/><xsl:text>)</xsl:text></span>
		     </div>
		     </xsl:for-each>
		     <div class="column"><p align="right">
		     <xsl:if test="$bookletStylesheet!=''">
			    <a onmouseover="window.status='Export starten';return true" onfocus="window.status='Download starten';return true" onmouseout="window.status='Download starten';return true;" >
			    <xsl:attribute name="href"><xsl:text>javascript:exportVizBooklet('application/pdf','</xsl:text><xsl:value-of select="$bookletStylesheet"/><xsl:text>');</xsl:text>
			    </xsl:attribute> 
		 <img title="Ausgabe im PDF-Querformat" alt="Ausgabe im PDF-Querformat" src="../images/icons/into_pdf.svg" style="width:30px;height:40px" border="0" /></a>
		 <span class="separator">&#160;</span>
		 <a onmouseover="window.status='Export starten';return true" onfocus="window.status='Download starten';return true" onmouseout="window.status='Download starten';return true">
		 <xsl:attribute name="href"><xsl:text>javascript:exportVizBooklet('application/vnd.openxmlformats-officedocument.spreadsheetml.sheet','</xsl:text><xsl:value-of select="$bookletStylesheet"/><xsl:text>');</xsl:text>
		 </xsl:attribute> 
	     	<img title="Ausgabe in Excel" alt="Ausgabe in Excel" src="../images/icons/into_excel_normal.svg" style="width:30px;height:40px" border="0" /></a>
		<span class="separator">&#160;</span>
	     <a onmouseover="window.status='Export starten';return true" onfocus="window.status='Download starten';return true" onmouseout="window.status='Download starten';return true">
	     	 <xsl:attribute name="href"><xsl:text>javascript:exportVizBooklet('application/vnd.openxmlformats-officedocument.wordprocessingml.document','</xsl:text><xsl:value-of select="$bookletStylesheet"/><xsl:text>');</xsl:text>
		 </xsl:attribute> 
		     	<img title="Ausgabe in Word" alt="Ausgabe in Word" width="25px" height="25px" src="../images/icons/into_word.svg" style="width:30px;height:40px" border="0" /></a>
		</xsl:if><!-- wenn JR Stylesheet -->
	  </p>

	<xsl:call-template name="weiterverarbeitungHiddenInputs" >
		<xsl:with-param name="formName" select="'Weiterverarbeitung'" />
		<xsl:with-param name="ergebniselement_ordnr" select="0" />
	</xsl:call-template>
	</div>
	</div>
	</div>
	<div class="tabs is-boxed is-centered is-toggle is-toggle-rounded is-fullwidth" id="nav">
	<script language="Javascript">
	<xsl:text>
	var optionalFilters = new Array();
	</xsl:text>
	<xsl:for-each select="/ergebnisse/ergebnis[@ordnr='0']/ergebniselement/sqlerg/row [col[f_name='hidden_optional_filter_name']/wert !='']">
	<xsl:variable name="i" select="position()" />
	<xsl:text>
	optionalFilters[</xsl:text><xsl:value-of select="$i" /><xsl:text>]='</xsl:text>
	<xsl:value-of select="./col[f_name='hidden_optional_filter_name']/wert" />
	<xsl:text>';
	</xsl:text>
	</xsl:for-each>
	</script>        
        <ul  class="dashboard-tabs">
                  
	<xsl:variable name="currentTabNr" select="/ergebnisse/ergebnis[@ordnr='0']/felder/feld[@varname='Tabnr.']/value" />
	
	<xsl:for-each select="/ergebnisse/ergebnis[@ordnr='0']/ergebniselement/sqlerg/row">
	
	<xsl:call-template name="tabBox">
		<xsl:with-param name="tabNr" select="col[f_name='ord']/wert"/>
		<xsl:with-param name="currentTabNr" select="$currentTabNr"/>
		<xsl:with-param name="textcontent" select="col[f_name='kennz']/wert"/>
		<xsl:with-param name="targetMaskennummer" select="col[f_name='hidden_link_maskeninfo_id']/wert" />
		<xsl:with-param name="optional_filter_name" select="col[f_name='hidden_optional_filter_name']/wert" />
		<xsl:with-param name="optional_filter_value" select="col[f_name='hidden_optional_filter_value']/wert" />
	</xsl:call-template>
	
	</xsl:for-each>
	    </ul>
	    
	    </div><!--Ende grauer Hintergrund der tabs-->
	       
                   

	       
       
</div>
  
</header>
</xsl:template>
<xsl:template name="tabBox">
<xsl:param name="tabNr" select="'1'"/>
<xsl:param name="currentTabNr" select="'1'"/>
<xsl:param name="textcontent" />
<xsl:param name="targetMaskennummer" />
<xsl:param name="optional_filter_name" select="''" />
<xsl:param name="optional_filter_value" select="''" />

<xsl:variable name="originalStylesheet">
<xsl:value-of select="/ergebnisse/ergebnis[@ordnr=0]/felder/feld[@varname='tablestylesheet']/value"/>
</xsl:variable>
<xsl:choose>
<xsl:when test="$currentTabNr=$tabNr"> 
<li data-target="{concat('pane-',$tabNr)}" id="{concat('tab-',$tabNr)}" style="" ><!---->

<xsl:call-template name="tabHeaderSpan">
<xsl:with-param name="textcontent" select="$textcontent"/>

</xsl:call-template>
</li>
</xsl:when>
<xsl:otherwise>
<li data-target="{concat('pane-',$tabNr)}" id="{concat('tab-',$tabNr)}" style="" ><!--background-color:#ddefff;-->
<a onclick="{concat('openDashboardTab(',$tabNr,',',$targetMaskennummer,',',$quote,$originalStylesheet,$quote,',',$quote,$optional_filter_name,$quote,',',$quote,$optional_filter_value,$quote,',optionalFilters);')}">

<xsl:call-template name="tabHeaderSpan">
<xsl:with-param name="textcontent" select="$textcontent"/>
</xsl:call-template>
</a>
</li>

</xsl:otherwise>
</xsl:choose>
</xsl:template>
<xsl:template name="tabHeaderSpan">
<xsl:param name="textcontent" />
<xsl:param name="bgColor" select="'#ddefff'" />
<span class="icon is-small"><i class="fa fa-image"></i></span>
                            <span style="font-weight:bold"><xsl:value-of select="$textcontent"/></span>
</xsl:template>
<xsl:template name="importRendererLibs">
<xsl:variable name="importEcharts">
<xsl:call-template name="isRendererNeeded">
<xsl:with-param name="renderer" select="'echarts'" />
</xsl:call-template>
</xsl:variable>
<xsl:if test="contains($importEcharts,'true')">
<xsl:call-template name="importEchartsLibs" />
</xsl:if>
<xsl:variable name="importD3js">
<xsl:call-template name="isRendererNeeded">
<xsl:with-param name="renderer" select="'d3js'" />
</xsl:call-template>
</xsl:variable>
<xsl:if test="contains($importD3js,'true')">
<xsl:call-template name="importd3jsLibs" />
</xsl:if>
<xsl:variable name="importPlot">
<xsl:call-template name="isRendererNeeded">
<xsl:with-param name="renderer" select="'plot'" />
</xsl:call-template>
</xsl:variable>
<xsl:if test="contains($importPlot,'true')">
<xsl:call-template name="importPlotLibs" />
</xsl:if>
</xsl:template>

<xsl:template name="isRendererNeeded">
<xsl:param name="renderer" />
<xsl:for-each select="/ergebnisse/ergebnis/felder/feld[@varname='Grafik']" >
<xsl:variable name="chart_uniquename" select="value" />
<xsl:if test="count(viz_charts/viz_chart[@uniquename=$chart_uniquename]/@renderer =$renderer) !=0">
<xsl:text>true</xsl:text>
</xsl:if>
</xsl:for-each>
</xsl:template>
<xsl:template name="displayTables">
<!-- jetzt Tabelle-->
<div>
<xsl:for-each select="/ergebnisse/ergebnis/ergebniselement">
<p class="teiltabelle_titel" style="font-size:3em;">
<xsl:text>Datentabelle </xsl:text><a onclick="{concat('toggleTableVisibility(',$colon,'toggleBtnTable',@ordnr+1, $colon,',',$colon, 'table',@ordnr+1,$colon,');')}"> <img  id="{concat('toggleBtnTable',@ordnr+1)}" src="../images/minus-circled.svg" height="20px" style="height:20px" border="0" /></a></p>
<style>
table.ergtabelle
{
padding-left:100px;
}
table.ergtabelle th {
  background-color: #b8c3ef;
  color: black;
  border: 1px solid black;
  border-collapse: separate;
  font-size:2em;
  }
td.integer {
  color: black;
  border: 1px solid black;
  border-collapse: separate;
  font-size:1.5em;
  }
  table td.ergfeld {
  empty-cells: show;
  vertical-align: top;
  border: thin solid gray;
  font-size:1.5em;
}
 table td.decimal {
  empty-cells: show;
  vertical-align: top;
  border: thin solid gray;
  font-size:1.5em;
}

  </style>
  
<xsl:call-template name="nd_singleTable">
<xsl:with-param name="ergebniselement_ordnr" select="@ordnr" />
<xsl:with-param name="showPager" select="'none'" />
</xsl:call-template>
</xsl:for-each>
</div>
</xsl:template>
<xsl:template name="weiterverarbeitungHiddenInputs">
<xsl:param name="formName" select="'Weiterverarbeitung'" />
<xsl:param name="ergebniselement_ordnr" select="0" />

<form name="{$formName}"  method="post" target="_self" charset="UTF-8">
<xsl:attribute name="action">
<!-- MB 9/14 encode URL ignoriert jsession id  -->
<xsl:value-of select="'SuperXmlTabelle'" /></xsl:attribute>
<input name="navi" type="hidden" value="{/ergebnisse/@showNavigation}" />
<input type="hidden" name="tid">
<xsl:choose>
<xsl:when test="/ergebnisse/@isMakro='true' and $ergebniselement_ordnr='0'">
	<xsl:attribute name="value"><xsl:value-of select="/ergebnisse/makro/@id" /></xsl:attribute>
</xsl:when>
<xsl:otherwise> 
	<xsl:attribute name="value"><xsl:value-of select="/ergebnisse/ergebnis[@ordn=$ergebniselement_ordnr]/maskenname/@id" /></xsl:attribute>
</xsl:otherwise>
</xsl:choose>
</input>
<input type="hidden" name="UserID"><xsl:attribute name="value"><xsl:value-of select="/ergebnisse/userID" /></xsl:attribute></input>
<input type="hidden" name="reuseresult" value="true"/> <!--  gecachte Ergebnis benutzen-->
<input type="hidden" name="maxoffset" value=""/> <!--im Normalfall wird Servleteinstellung genutzt - nur Druckversion übergibt Wert-->
<input type="hidden" name="stylesheet" value="{/ergebnisse/ergebnis[@ordnr='0']/felder/feld[@varname='tablestylesheet']/value}" />
<input type="hidden" name="contenttype" value="text/xsl" />
  <!-- MB 5/2011 fuer Export nur sichtbarer Tabellenzeilen nach Excel/PDF -->
<input type="hidden" name="irowno" value="" />



<xsl:for-each select="/ergebnisse/ergebnis[@ordnr=$ergebniselement_ordnr]/completefields/feld[@varname != '##line##']">
<!--<xsl:for-each-group select="/*/*/completefields/feld" group-by=".">-->
<xsl:variable name="feldname"><xsl:value-of select="@varname" /></xsl:variable>
	<xsl:variable name="feldnameEscaped"><xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="@varname"/></xsl:with-param></xsl:call-template></xsl:variable> 
	<xsl:variable name="feldart">
	<xsl:call-template name="getFeldArt">
		<xsl:with-param name="ergebniselement_ordnr" select="$ergebniselement_ordnr"/>
			<xsl:with-param name="feldname" select="$feldname"/>
	</xsl:call-template>
</xsl:variable>
<xsl:variable name="feldwert">
	<xsl:call-template name="getFeldWert">
		<xsl:with-param name="ergebniselement_ordnr" select="$ergebniselement_ordnr"/>
		<xsl:with-param name="feldname" select="$feldname"/>
	</xsl:call-template>
</xsl:variable>
<!--<xsl:for-each select="distinct-values(//ergebnisse/ergebnis/felder/feld [@varname !='Lehreinheit' and @varname != 'Fakultät' and @varname != 'Studiengang'])">-->
          <!--  #198418 Problem bei Feldart 1 Typ SQL Beispiel Zeitraum in COB Maske Kosten und Erlöse (Primär und Sekundär) Attribut value aus default/wert key wird nicht richtig escaped 
       vergl.        https://stackoverflow.com/questions/8944513/disable-output-escaping-yes-no-not-working-amp-outputted-twice-in-sharepoint- 
       Versuche mit <option value="{key}"> sind auch fehlgeschlagen, vermutlich weil XSTL bei Attributen keine Änderung des Escapings vorsieht
      https://stackoverflow.com/questions/7887016/disable-output-escaping-not-working-for-attribute-in-xslt
    alter Code:
     <input type="hidden">
   <xsl:attribute name="name"><xsl:value-of select="@varname" /></xsl:attribute>
   <xsl:attribute name="value"><xsl:value-of select="value" /></xsl:attribute>
  </input>
    
    
     neuer Code: -->
            <xsl:text disable-output-escaping="yes"><![CDATA[<input type="hidden" name="]]></xsl:text><xsl:value-of disable-output-escaping="no" select="$feldname"/><xsl:text>" value="</xsl:text>
          <xsl:value-of disable-output-escaping="no" select="$feldwert"/><xsl:text>"</xsl:text>
            <xsl:text disable-output-escaping="yes"><![CDATA[></input>
	    ]]></xsl:text> 
       <xsl:if test="$feldart='12'">
			<input type="hidden">
       
       
       <xsl:attribute name="value">
        <xsl:call-template name="getFeldSichtStand">
       		<xsl:with-param name="ergebniselement_ordnr" select="$ergebniselement_ordnr"/>
		<xsl:with-param name="feldname" select="$feldname"/>
	</xsl:call-template>
       
            
        </xsl:attribute>
	
	  <xsl:attribute name="name">
            <xsl:value-of select="concat($feldname,'-Stand')"/>
          </xsl:attribute>
	 </input>
	 <!-- Übergabe Sicht klappt nicht in H1:
	<input type="hidden">
       <xsl:attribute name="name">
            <xsl:value-of select="concat($feldname,'-Sicht')"/>
          </xsl:attribute>
	  <xsl:attribute name="value">
	  <xsl:call-template name="getFeldSichtNameIntern">
	  	<xsl:with-param name="ergebniselement_ordnr" select="$ergebniselement_ordnr"/>
          	<xsl:with-param name="feldname" select="$feldname"/>
	  </xsl:call-template>  
	  
          </xsl:attribute>
	  </input>-->
	  </xsl:if>
</xsl:for-each>
</form>
</xsl:template>
<xsl:template name="vizSidebar" >
<xsl:param name="stylesheet" select="'viz_html_chart_viewer_grid.xsl'" />
<xsl:param name="collapsible" select="'true'" />
<style>
.card-content {	
  border: thin solid hsl(0, 0%, 71%); 
  border-radius: 0.3rem !important;
  padding-right:20%
  }

.vizLabel-container { 
   display: flex;
   background: inherit;	
   min-width: 13.5rem; 
   }

.label.is-small { width: 100%; } /*einheitliche Labelbreite*/ 
 
.button { font-weight: bold; }	 
   
   
/* Tooltip-Farbe */
[data-tooltip]:not(.is-disabled).has-tooltip-bottom::before, 
[data-tooltip]:not(.is-loading).has-tooltip-bottom::before, 
[data-tooltip]:not([disabled]).has-tooltip-bottom::before {
  background-color: #a6a6a6ff; /*#333;*/
  color: white;
  }
  </style>
<xsl:choose>
<xsl:when test="$collapsible='true'">
<style>

.fixed-right-buttons {
  position: fixed;
  right: 0.1%; 			/* Abstand vom rechten Bildschirmrand */
  top: 50%; 			/* Zentriert den Button-Block vertikal;*/
  transform: translateY(-50%); 	/* Zentrierung anpassen */
  display: flex;
  flex-direction: column; 	/* Buttons vertikal anordnen */
  gap: 10px; 			/* Abstand zwischen den Buttons */
  z-index: 600;
  padding: 0.7% 0% 0.7% 0%;
}

.inside-buttons { 		/*20250530 BF ergänzt: wenn sidebar offen*/
  display: block;
  position: fixed;
  top: 50%;
  z-index: 700;
  left: calc(100vw - 545px - 40px);/* Viewport-Breite minus Sidebar-Breite minus Abstand */
  transform: none;		 /* keine vertikale Zentrierung */
  }

.sidebar {			/*20250523 BF ergänzt*/
  position: fixed;
  top: 120px; 			/*Abstand zur oberen Leiste*/
  padding-top:2em;
  padding-left:0.5em;
  padding-right: 0.7em;
  right: 0em;
  bottom: 0;
  width: 545px; 		/*Breite nach Bedarf */
  background: white;
  box-shadow: -2px 0 5px rgba(0,0,0,0.1);
  overflow-y: auto;
  z-index: 700; 		/*für Anzeige über Content*/
  }


</style>
<script>
		    function toggleSideBarDiv(mySidebarDivId)
{
	
	var myDiv=document.getElementById(mySidebarDivId);
	if(myDiv.style.display=="block")
	{
		myDiv.style.display="none";
		myDiv.classList.remove("sidebar");
		}
	else
	{
		myDiv.style.display="block";
		myDiv.classList.add("sidebar");
		}

}
</script>
<xsl:call-template name="vizSideBarButtons" />

<div class="column">
<div id="mySidebarMaske" class="sidebar" style="display:none;">
<div class="inside-buttons">

  		<a href="javascript:toggleSideBarDiv('mySidebarMaske');" title="Filter">
		<img src="../images/viz_sidebarbuttonMaske.svg" alt="Filter" width="40px" border="0" /></a>
</div>
<xsl:call-template name="renderTableDialogs" >
  <xsl:with-param name="stylesheet" select="$stylesheet" />
  </xsl:call-template>

  </div>
<div id="mySidebarInfo" class="sidebar" style="display:none;">
<div class="inside-buttons">
		<a href="javascript:toggleSideBarDiv('mySidebarInfo');" title="Info">
		<img src="../images/viz_sidebarbuttonInfo.svg" alt="Infos" width="40px" border="0" /></a>
</div>

  <xsl:call-template name="erlaeuterung">
<xsl:with-param name="ergebniselementOrdnr" select="0" />
</xsl:call-template>

</div>
</div>
</xsl:when>
<xsl:otherwise>
<!--<xsl:call-template name="vizSideBarButtons" />-->
<div class="column">
<xsl:call-template name="renderTableDialogs" >
  <xsl:with-param name="stylesheet" select="$stylesheet" />
  <xsl:with-param name="collapsible" select="$collapsible" />
  </xsl:call-template>
</div>
</xsl:otherwise>
</xsl:choose>

</xsl:template>

<xsl:template name="erlaeuterung">
<xsl:param name="ergebniselementOrdnr" select="0" />
		
<div style="float:right" class="media">
            
              <div class="media-content">
<p style="font-size:1rem"><xsl:value-of select="/ergebnisse/ergebnis[@ordnr=$ergebniselementOrdnr]/explanation" /></p>

<xsl:for-each select="/ergebnisse/ergebnis[@ordnr=$ergebniselementOrdnr]/ergebniselement">
<xsl:call-template name="nd_legendeContent"  >
<xsl:with-param name="ergebniselementOrdnr" select="$ergebniselementOrdnr" />
<xsl:with-param name="isDisplayedInModal" select="'true'" />
</xsl:call-template>

</xsl:for-each>
<!--<p>
<xsl:value-of select="/ergebnisse/ergebnis[@ordnr=$ergebniselementOrdnr]/hinweis" />
	</p>-->

	</div>
	</div>
	</xsl:template>
	<xsl:template name="vizTableCSS">
<!-- aus 800000280_datencockpit.xsl -->
		<style type="text/css">
.dojoDialog {background : #eee;	border : 1px solid #999;-moz-border-radius : 5px;padding : 4px;width:650;height:420px;overflow:scroll}
.treebutton {
      border:none;
      margin: 0 4px 0 0;
    }
 @media print{
.dontprint{display:none;}
}
html, body {
  height: auto;
  min-height: 100vh;
  overflow-x: auto;
  overflow-y: auto;
}
/*Cockpit-Header*/
.hs_header {
  position: fixed; 
  top: 0;
  left: 0;
  right: 0;
  z-index: 20;	 /*positioniert sich im flow am nähesten zum Betrachter*/ 
  background-color:white;
  padding-top: 3rem; 
}

.cockpit_title {
   color: white;
   font-size: 2rem;
   font-weight: 800;
   background-color: #004c93;
   padding-left:20px;
}   

.navbar {background-color: white;}  /*20250221 eingefügt*/
.navbar-item img, .navbar-item svg {  /*20250221 eingefügt*/
  max-height: unset !important; /*var(--bulma-navbar-item-img-max-height);*/
}

.hs_header_box1 {	   	/*für Balken-Box über/unter Cockpittitel*/
   background: white;
   height: 1.0rem; 
   color: black;
}

.hs_header_box2 {	   	/*für Logo-/Cockpittitel-Box*/
   display: flex;
   /* height: 4.0rem;*/ 
   padding: 0.3rem 17.0rem 0rem 9.0rem;   /*für Padding: ob re un li*/
   align-items: left;		    /*für vertikale Ausrichtung d Elemente*/
   /*justify-content: space-between;*/  /*für gleichm. Leerraum zw. Elementen*/
   background-color: #004c93;
}
/*--20250917 eingefügt, klappt nicht bei fester Spaltenanzahl:--*/
/*.grid { display: flex;
  flex-wrap: wrap;  erlaubt Umbruch 
  }*/
  
.dashboard-tabs {
  display: flex;
  flex-wrap: wrap; /* erlaubt Umbruch */
  list-style: none;
  margin: 1rem;
  padding: 0;
  /*border-bottom: 1px solid #ccc;*/
}

.dashboard-tabs li {
  flex: 1 1 auto; /* alle Tabs gleich breit, aber flexibel */
  text-align: center;
  /*border: 1px solid #ccc;
  border-bottom: none;
  background: #f9f9f9;*/
}

.dashboard-tabs li a {
  display: block;
  padding: 0.75em 1em;
  text-decoration: none;
  font-weight: bold;
  color: #333;
  height: 2.5rem;
}

.dashboard-tabs li a:hover {
  background: #e0e0e0;
}

.columns {				
    display: flex;
    flex-wrap: wrap; 
    }
    
@media (max-width: 475px)  { 
/* 20250920 eingefügt */ 
   .columns { padding-top: 2.5rem; }    
   .grid { padding-top: 17.5rem; }
}

@media (min-width: 476px) and (max-width: 576px) { 
/* 20250920 eingefügt */
   .grid { padding-top: 15rem; }
}	

@media (min-width: 577px) and (max-width: 621px) { 
/* 20250920 eingefügt */
   .grid { padding-top: 10rem; }
}

@media (min-width: 622px) and (max-width: 639px) { 
/* 20250920 eingefügt */
   .grid { padding-top: 8rem; }
}

@media (min-width: 640px) and (max-width: 768px) { 
   .grid { padding-top: 5rem; }
}

@media (min-width: 769px) and (max-width: 1070px) { 
/* 20250919 eingefügt: bis 769px: mobile; ab 769px: tablet and up; ab 1024px: desctop an up */ 
   .grid { padding-top: 5rem; }
}

@media (min-width: 1071px) and (max-width: 1094px) { 
/* 20250919 eingefügt */ 
   .grid { padding-top: 1.5rem; }
}

@media (min-width: 1095px) { 
/* 20250919 eingefügt*/ 
   .grid { padding-top: 0.5rem; }
}

.buttons-container {		  /* 300425BF eingefügt*/ 
   display: flex;
   justify-content: flex-end;     /* rechts ausrichten */
   align-items: center;           /* vertikal zentrieren */
   flex-wrap: wrap;               /* für kleine Viewports */
   padding-top: 1.0rem;
}

.button.is-link {
    background-color: white;         /*link-Blau:#3273dc; UDE-Blau:#004C93*/
    border-color: transparent;
    color: #004C93; }
.button.is-link:hover, .button.is-link.is-hovered {
      background-color: #276cda;
      border-color: transparent;
      color: #004C93; }
.button.is-link:focus, .button.is-link.is-focused {
      border-color: transparent;
      color: #004C93; }
.button.is-link:focus:not(:active), .button.is-link.is-focused:not(:active) {
        box-shadow: 0 0 0 0.125em rgba(50, 115, 220, 0.25); }
.button.is-link:active, .button.is-link.is-active {
      background-color: white;
      border-color: transparent;
      color: #004C93; }
.button.is-link[disabled],
    fieldset[disabled] .button.is-link {
      background-color: #004C93;
      border-color: transparent;
      box-shadow: none; }
.button.is-link.is-inverted {
      background-color: #fff;
      color: #004C93; }
.button.is-link.is-inverted:hover, .button.is-link.is-inverted.is-hovered {
        background-color: #f2f2f2; }
.button.is-link.is-inverted[disabled],
      fieldset[disabled] .button.is-link.is-inverted {
        background-color: #fff;
        border-color: transparent;
        box-shadow: none;
        color: #004C93; }
.button.is-link.is-loading::after {
      border-color: transparent transparent #fff #fff !important; }
.button.is-link.is-outlined {
      background-color: white;
      border-color: #004C93;
      color: #004C93; }
.button.is-link.is-outlined:hover, .button.is-link.is-outlined.is-hovered, .button.is-link.is-outlined:focus, .button.is-link.is-outlined.is-focused {
        background-color: #004C93;
        border-color: #004C93;
        color: #fff; }
.button.is-link.is-outlined.is-loading::after {
        border-color: transparent transparent #004C93; #004C93; !important; }
.button.is-link.is-outlined.is-loading:hover::after, .button.is-link.is-outlined.is-loading.is-hovered::after, .button.is-link.is-outlined.is-loading:focus::after, .button.is-link.is-outlined.is-loading.is-focused::after {
        border-color: transparent transparent #fff #fff !important; }
.button.is-link.is-outlined[disabled],
      fieldset[disabled] .button.is-link.is-outlined {
        background-color: transparent;
        border-color: #004C93;
        box-shadow: none;
        color: #004C93; }
.button.is-link.is-inverted.is-outlined {
      background-color: transparent;
      border-color: #fff;
      color: #fff; }
.button.is-link.is-inverted.is-outlined:hover, 
.button.is-link.is-inverted.is-outlined.is-hovered, 
.button.is-link.is-inverted.is-outlined:focus, 
.button.is-link.is-inverted.is-outlined.is-focused {
        background-color: #fff;
        color: #004C93; }
.button.is-link.is-inverted.is-outlined.is-loading:hover::after, 
.button.is-link.is-inverted.is-outlined.is-loading.is-hovered::after, 
.button.is-link.is-inverted.is-outlined.is-loading:focus::after, .button.is-link.is-inverted.is-outlined.is-loading.is-focused::after {
        border-color: transparent transparent #004C93; #004C93; !important; }  

.button.is-link.is-inverted.is-outlined {
      background-color: transparent;
      border-color: #fff;
      color: #fff; }
.button.is-link.is-inverted.is-outlined:hover, 
.button.is-link.is-inverted.is-outlined.is-hovered, 
.button.is-link.is-inverted.is-outlined:focus, 
.button.is-link.is-inverted.is-outlined.is-focused {
        background-color: #fff;
        color: #004C93; }

.button.is-small.is-rounded.is-link.has-tooltip-bottom { background-color: #004C93; /*UDE-Blau*/ } /*20250711 eingefügt*/

.exportoptions {
   margin-top: 2.0em; 
}
   
.buttonlist{			     /*für resposive Buttonleiste*/
   display: flex; 
   flex-flow: no wrap;
   justify-content: flex-start;
   padding: 0.3rem 0rem 0.3rem 0rem; /*für Padding: ob re un li*/
   }
   
.buttonlist img { 		/*für Icongröße in Buttonleiste*/
    height: 2.5rem; 
    width: auto; 
    margin-top: 0em; }
    
/*Auswahlfelder*/
.card {				/*für Auswahlfeldercard-Position*/
   display: flex;
   flex-flow: column;
   margin-left: 0em;		
   margin-top: 8em; 		
   min-width: 10.0em;
   width: 100%; 
   } 		

.card.is-shady { border: unset !important; } /*20250709 eingefügt */  

.label-container, .button-label { /*für einh.responsive Feldbezeichner*/
   display: flex;
   justify-content: left;
   background: ;	
   min-width: 10.0em;		/*für kleine Viewports*/
   width: 10%; }		/*für kleine Viewports*/
   
.control-new { 			/*für einheitliche Controls*/
   min-width: 10.0em; 		/*für kleine Viewports*/
   width: 10%; 			/*für große Viewports*/
   }
   
.button {			/*für Button-Bezeichner-Ausrichtung*/
   display: flex;
   justify-content: left; }
 
/*Erläuterungen/Legende*/
.box-new {			/*für Kopfzeile mit Close-Button*/
   display: flex;
   justify-content: space-between;
   font-weight: bold;
}	

.leg_erl {
  background-color: whitesmoke; /*für Abschnitthintergrund, Schrift*/ 
  font-size: 0.8em;
}
 
.dl_title {			/*für Texthervorhebungen*/ 
   display: flex;
   justify-content: center;
   background: inherit;	
   font-size: 1.2em;
   font-weight: 400;   
 }
 /*Datentabellen*/
.table-container {
   z-index: 10; /*positioniert sich im flow hinter dem hs_header*/ 
}
 table.ergtabelle tr.listRowOdd td.leer
 {
 border:thin solid white;
 background-color:white;
 }
  table.ergtabelle tr.listRowEven td.leer
 {
 border:thin solid white;
 background-color:white;
 }
 table.ergtabelle tr td.leer
 {
 border:thin solid white;
 background-color:white;
 }
 table.ergtabelle tr th.leer
 {
 border:thin solid white;
 background-color:white;
 }
  table.ergtabelle tr th.header
 {
 vertical-align:center;
text-align:center;
 
 }
 
  table.ergtabelle
 {
 border:thin solid white;
 font-size:1.5rem;
 }
 
 /* Zahlen rechtsbündig:*/
   table.ergtabelle tbody tr.listRowEven td.integer
 {
 text-align:right;
empty-cells:show
vertical-align:center;
 }
    table.ergtabelle tbody tr.listRowOdd td.integer
 {
 text-align:right;
empty-cells:show
vertical-align:center;
 }
    table.ergtabelle tbody tr.listRowEven td.decimal
 {
 text-align:right;
empty-cells:show
vertical-align:center;
 }
    table.ergtabelle tbody tr.listRowOdd td.decimal
 {
 text-align:right;
empty-cells:show
vertical-align:center;
 }
 .vizTitle
 {
  margin-top: 2em;
  white-space: normal;
  word-wrap: normal;
  overflow-wrap: break-word;
  hyphens: auto;
  font-size:1.2em;
  font-weight:bolder;
 }
 
</style>
</xsl:template>
<xsl:template name="nd_legendeHeaderContent">
<xsl:param name="ergebniselement_ordnr" select="0" />

<xsl:for-each select="/ergebnisse/ergebnis[@ordnr=$ergebniselement_ordnr]/felder/feld">
<xsl:if test="(value !='' or sicht/@isFirstInGroup='false' or @isstandtoday='false') and value_caption != ''">
	<xsl:variable name="showFieldValueInLegend">
	<xsl:call-template name="showFieldValueInLegend">
	<xsl:with-param name="ergebniselementOrdnr" select="$ergebniselement_ordnr" />
	<xsl:with-param name="feldname" select="@varname"/>
	</xsl:call-template>
	</xsl:variable>
	<xsl:if test="$showFieldValueInLegend='true'" >
		<span class="feldname">
		<xsl:choose>
		<xsl:when test="string-length(caption_short) &gt; 0 and caption_short != 'null'" >
		<![CDATA[]]><xsl:value-of select="caption_short" /><![CDATA[]]>
		</xsl:when>
		<xsl:otherwise>
		<xsl:value-of select="@varname" />
		</xsl:otherwise>
		</xsl:choose></span>:&#160;
		<xsl:if test="string-length(value_caption) &lt; 50">
					<span class="feldwert"><xsl:value-of select="value_caption" /><![CDATA[]]></span>
		</xsl:if>
			<xsl:if test="string-length(value_caption) &gt; 49">
			<span class="feldwert"><![CDATA[]]><xsl:value-of select="substring(value_caption,0,50)" /><![CDATA[]]>...</span>
		</xsl:if>
		<xsl:if test="sicht!=''">
			<span><![CDATA[ (]]><xsl:value-of select="sicht" />
			<xsl:if test="@stand!=''"><xsl:text> - Stand:</xsl:text><xsl:value-of select="@stand"/></xsl:if>
			<xsl:text><![CDATA[)]]>	</xsl:text></span>
			
		</xsl:if>
		<xsl:text>; </xsl:text>
			</xsl:if>
	</xsl:if>
	<span class="separator">&#160;</span>
</xsl:for-each>


</xsl:template>
<xsl:template name="vizSideBarButtons" >
<div class="buttons fixed-right-buttons">
<a href="javascript:toggleSideBarDiv('mySidebarInfo');" title="Info">
<img src="../images/viz_sidebarbuttonInfo.svg" alt="Infos" width="40px" border="0" /></a>
<a href="javascript:toggleSideBarDiv('mySidebarMaske');" title="Maske">
<img src="../images/viz_sidebarbuttonMaske.svg" alt="Maske" width="40px" border="0" /></a>
</div>
</xsl:template>
<xsl:template name="showFieldValueInLegend">
<xsl:param name="ergebniselement_ordnr" select="0" />
<xsl:param name="feldname" />
<xsl:variable name="isHidden"><xsl:value-of select="/ergebnisse/ergebnis[@ordnr=$ergebniselement_ordnr]/completefields/feld[@varname=$feldname]/@hidden"/>
</xsl:variable>
<xsl:choose>
<xsl:when test="$isHidden='true' or  $feldname = 'sort' or $feldname = 'maxoffset' or  $feldname ='##line##'">
<xsl:text>false</xsl:text>
</xsl:when>
<xsl:otherwise>
<xsl:text>true</xsl:text>
</xsl:otherwise>
</xsl:choose>

</xsl:template>
<xsl:template name="viz_dashboard_pagetitle" >
<xsl:param name="ergebniselement_ordnr" select="0" />
<p class="title is-1">
<xsl:for-each select="/ergebnisse/ergebnis[@ordnr=$ergebniselement_ordnr]/felder/feld[@varname='Studiengang']">
	<xsl:if test="(value !='' or sicht/@isFirstInGroup='false' or @isstandtoday='false')  and @varname != 'sort' and @varname != 'maxoffset' and value_caption != ''">

		
		<xsl:if test="string-length(value_caption) &lt; 50">
					<xsl:value-of select="value_caption" /><![CDATA[]]>
		</xsl:if>
			<xsl:if test="string-length(value_caption) &gt; 49">
			<![CDATA[]]><xsl:value-of select="substring(value_caption,0,50)" /><![CDATA[]]>...
		</xsl:if>
		
	</xsl:if>
<span class="separator">&#160;</span>
</xsl:for-each>
</p>
</xsl:template>
<xsl:template name="getChartCollapsibleHeading">
<xsl:text>Diagramm</xsl:text>
</xsl:template>
<xsl:template name="vizGridTitle" >
<xsl:param name="icon_classname" />

<xsl:variable name="gridtitle_felderinfo_id">
<xsl:value-of select="/ergebnisse/ergebnis[@ordnr='0']/ergebniselement/sqlerg/row/col[f_name='hiddengridtitle_felderinfo_id']/wert" />
</xsl:variable>
<xsl:variable name="selectedName">
<xsl:value-of select="/ergebnisse/ergebnis[@ordnr=0]/felder/feld[@tid=$gridtitle_felderinfo_id]/value_caption" />
</xsl:variable>
<div id="nd_pagetitle">
	<p class="vizTitle">
	 <!--<xsl:call-template name="renderIconIfExists">
		 <xsl:with-param name="classname" select="$icon_classname" />
		 <xsl:with-param name="context" select="'normal'" />
		 </xsl:call-template>-->
	<xsl:choose>
<xsl:when test="$selectedName='keine Einschränkung' or $selectedName=''">
<xsl:value-of select="/ergebnisse/generalinfo/REPORT_HEADING_INSTITUTION"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="$selectedName" />
</xsl:otherwise>
</xsl:choose>
</p>
	</div>
	</xsl:template>

</xsl:stylesheet>
