/* SuperX-VIZ Modul (c) 2023 Daniel Quathamer */

function chartModel(id,name,renderer,datasources)
{
	this.version="0.2b";
	this.id=id;
	this.name=name;
	this.renderer=renderer;
	this.dataSources=datasources;
	//this.globalProperties=globalproperties;
	this.targetDiv=""; //only for d3
	this.chartElements=new Array();
	this.chartPropertiesUsed=new Array();
	this.dataTransformation=new Array();
	
}


function possibleVizType(elemID,value,name,explanation,isDefault ) 
    {
this.elemID=elemID;
this.value=value;
this.name=name;
this.explanation=explanation;
this.isDefault=isDefault;

}

function usedVizType(elemID,vizTypeUniquename,caption,datasource ) 
    {
this.elemID=elemID;
this.vizTypeUniquename=vizTypeUniquename;
this.caption=caption;
this.datasource=datasource;
this.elementTypeProperties=new Array();
}

function usedVizProperty(name,vizPropertyVariablename,propertyValue,propUnit ) 
    {
this.name=name;
this.vizPropertyVariablename=vizPropertyVariablename;
this.propertyValue=propertyValue;
this.propUnit=propUnit;

}
function usedVizTypeProperty(nr,vizTypePropertyUniquename,caption,propertyValue,propertyType ) 
    {
this.nr=nr;
this.vizTypePropertyUniquename=vizTypePropertyUniquename;
this.caption=caption;
this.propertyValue=propertyValue;
this.propertyType=propertyType;

}
function dataTransformationCol(tableId,colname,colfunction) 
    {
this.tableId=tableId;
this.colname=colname;
this.colfunction=colfunction;

}


function selectionRowMetaData(nr,targetColumn,colname,colcaption,coltype,colfunction)
{
this.nr=nr;
this.targetColumn=targetColumn;
this.colname=colname;
this.colcaption=colcaption;
this.coltype=coltype;
this.colfunction=colfunction;
}

function selectionPropertyValue(nr,name,value,isDefault ) 
    {
this.nr=nr;
this.name=name;
this.value=value;
this.isDefault=isDefault;

}



function dimFunction(nr,name,value,isDefault ) 
    {
this.nr=nr;
this.name=name;
this.value=value;
this.isDefault=isDefault;

}
function dimensionProperty(name,caption,explanation,isMeasure,isMandatory,datasource) 
{
this.name=name;
this.caption=caption;
this.isMeasure=isMeasure;
this.isMandatory=isMandatory;
this.explanation=explanation;
this.datasource=datasource;
this.getValueResultset = function () {
var valueOptions=[];
var optionCounter=0;
//selectionRsMetaData=fillSelectionResultMetaData();
//console.log("felder"+selectionRsMetaData.length);
var isDefault=false;
	for(var j=0;j < rsColumnMetaData[datasource].length;j++)
		{
			if(rsColumnMetaData[datasource][j].colcaption.trim() !="" 
			//&& (
			//	isMeasure==false || rsColumnMetaData[datasource][j].coltype == 4 || rsColumnMetaData[datasource][j].coltype == 3)
			//
			)
			{
					//console.log("feld "+rsColumnMetaData[j].nr+selectionRsMetaData[j].targetColumn);
				var o=new selectionPropertyValue(rsColumnMetaData[datasource][j].nr,rsColumnMetaData[datasource][j].colcaption,rsColumnMetaData[datasource][j].colname,isDefault);
				valueOptions[optionCounter]=o;
				optionCounter++;
				if(isDefault)
					isDefault=false;
			}
		}
	return valueOptions;
}

}


function selectionProperty(name,caption,isDynamic,isMeasure,isMandatory,staticValues,defaultValue,optionalFunction) 
    {
	/*OBSOLETE*/
this.name=name;
this.caption=caption;
this.isDynamic=isDynamic;
this.isMeasure=isMeasure;
this.staticValues=staticValues;
this.isMandatory=isMandatory;
this.defaultValue=defaultValue;
this.optionalFunction=optionalFunction;
this.getValueResultset = function () {
        var valueOptions=[];
	var optionCounter=0;
	if(isDynamic)
	{
		for(var j=0;j < rsMetaData.length;j++)
			{
			var isDefault=false;
			if(rsMetaData[j].colcaption.trim() !="" &&
			(isMeasure==false || rsMetaData[j].coltype == 4 || rsMetaData[j].coltype == 3)
			)
				{
					if(rsMetaData[j].colcaption==defaultValue)
						isDefault=true;
					var o=new selectionPropertyValue(rsMetaData[j].nr,rsMetaData[j].colcaption,rsMetaData[j].colname,isDefault);
					valueOptions[optionCounter]=o;
					optionCounter++;
				}
			}
	}
	else
	{
		var staticValuesArray = staticValues.split(/\|/);
		for(var k=0;k < staticValuesArray.length;k++)
		{
			var isDefault=false;
			if(rsMetaData[j].colcaption==defaultValue)
						isDefault=true;
			var o=new selectionPropertyValue(k,staticValuesArray[k],staticValuesArray[k],isDefault);
			valueOptions[k]=o;
		}
	}
	return valueOptions;
    }
}

/*Transfer form to model: */
function updateChartModel()
{
	
	var myChartPropertiesUsed=new Array();
	//first empty properties:
		/*for(var k=0;k< myChartModel.chartPropertiesUsed.length;k++)
		{
			myChartModel.chartPropertiesUsed[k].pop();
		}*/

	if(document.getElementById("chartName").value=="")
		document.getElementById("chartName").value=vizInitialName;
	var chartName=document.getElementById("chartName").value;
	//myChartModel.options.caption=chartName;
	if(myChartModel.renderer=="")
		myChartModel.renderer=document.getElementById("fldVizRenderer").value;
	var myCaption=new usedVizProperty("caption","caption",chartName);
	myChartPropertiesUsed.push(myCaption);
	//var myForm=document.forms["chartPropertiesForm"];
	for(var k=0;k < commonChartProperties.length;k++)
		{
			if(getCommonChartProperty(commonChartProperties[k].name)!="")
			{
				var myProp=new usedVizProperty(commonChartProperties[k].name,commonChartProperties[k].variableName,getCommonChartProperty(commonChartProperties[k].name),commonChartProperties[k].propUnit);
				myChartPropertiesUsed.push(myProp);
			}
		}

		//first Collect all groups:

	myChartModel.chartPropertiesUsed=myChartPropertiesUsed;
	
	//Update the source Code TEXTAREA:
	updateChartModelCode(myChartModel);
	return myChartModel;
	
}

function renderChart(chartDiv,currentChartModel,datasource,title)
{
	if(!datasource)
		var datasource=0;
	if(!title)
		var title=document.getElementById("chartName").value;
	/*if(document.getElementById("chartName").value=="")
		document.getElementById("chartName").value=vizInitialName;*/
	if(currentChartModel.chartElements.length>0 && currentChartModel.chartElements[0])
	{
		renderChartSVGFromModel(currentChartModel,chartDiv,datasource,title);
	}
	else
		document.getElementById(chartDiv).innerHTML="<svg style=\"width:100%;height: auto;\" viewBox=\"0 0 800 600\" width=\"800\" height=\"600\">"+
		"<rect x=\"0\" y=\"0\" width=\"800\" height=\"450\" fill=\"#cccccc\"></rect></svg>";
		//

}

function prepareSelectionForm()
{
	var selectionProperties=[];
	
	var myProp= new selectionProperty("dimension1","Dimension 1",true,false,true,null,null,true);
	selectionProperties[0]=myProp;
	var myProp= new selectionProperty("dimension2","Dimension 2",true,false,false,null,null,true);
	selectionProperties[1]=myProp;
	var myProp= new selectionProperty("measure1","Maß",true,true,true,null,null,true);
	selectionProperties[2]=myProp;

return selectionProperties;
}


function generateFormFieldHtml(labelText,fieldname,tooltiptext,inputElem)
{
	var zs="<div class='field'>";
	zs+="<div class='label-container' lang='de'><span class='labelNormal has-tooltip-bottom' data-tooltip='"+tooltiptext+"'>"+labelText+"</span></div>";
	
	zs+="<div class='control'><div class='field'><div class='control is-expanded'>";
	zs+="<div class='select  is-small is-fullwidth is-focused'>";
	//zs+="<select id='"+fieldname+"''><option>TEST</option></select>";
	zs+=getOuterHTML(inputElem);
	zs+="</div></div></div></div>"; //Ende field body
	zs+="</div>";//Ende field
	return zs;
	
		
	
}
function getOuterHTML(element) {
    var container = document.createElement("div");
    container.appendChild(element.cloneNode(true));

    return container.innerHTML;
}

function createChartElementConfig1Form(renderer,elemID)
{
	//first empty form:
	var formChartElementConfig1=document.getElementById("ChartElementConfig1Div");
	while (formChartElementConfig1.firstChild) {
		formChartElementConfig1.removeChild(formChartElementConfig1.firstChild);
	}
	var formChartElementConfig2=document.getElementById("ChartElementConfig2Div");
	while (formChartElementConfig2.firstChild) {
		formChartElementConfig2.removeChild(formChartElementConfig2.firstChild);
	}
	//reset ElemID:
	document.getElementById("chartElementID").value=elemID;
	//any previous values?
	var myChartElem=null;
	if(myChartModel.chartElements && elemID !="")
	{
		var filtered=myChartModel.chartElements.filter(obj => obj.elemID == elemID);
		var myChartElem=filtered[0];
	}
		//First Datasource:
	//const elementDatasourceDiv=document.createElement("div");
	
	
	/*
	const fieldDatasourceElem = document.createElement("div");
	fieldDatasourceElem.classList.add("field");
	fieldDatasourceElem.classList.add("is-horizontal");
		//label:
	const labelDatasourceElem = document.createElement("div");
	labelDatasourceElem.classList.add("field-label");
	labelDatasourceElem.classList.add("is-small");
		const labelDatasource = document.createElement("label");
		labelDatasource.classList.add("label");
		labelDatasource.classList.add("is-required");
		labelDatasource.classList.add("is-small");
		labelDatasource.classList.add("has-tooltip-right");
		labelDatasource.setAttribute("data-tooltip","Datenquelle für das Diagrammelement");

		const textnode = document.createTextNode("Datenquelle");
		labelDatasource.appendChild(textnode);
		labelDatasourceElem.appendChild(labelDatasource);
		fieldDatasourceElem.appendChild(labelDatasourceElem);
	const selDatasourceFbodyElem = document.createElement("div");
	selDatasourceFbodyElem.classList.add("field-body");
	const selDatasourceElem = document.createElement("select");
		selDatasourceElem.name="chartElementDatasource";
		selDatasourceElem.id="chartElementDatasource";
		selDatasourceElem.classList.add("select");
		selDatasourceElem.classList.add("is-small");
		selDatasourceElem.style.width="100px";

		selDatasourceElem.onchange= function () {  
				createChartElementsConfig2Form(renderer);
		};
		fillSelectOptions(selDatasourceElem,rsTableMetaData,true,(myChartElem!=null?myChartElem.datasource:null));
		selDatasourceFbodyElem.appendChild(selDatasourceElem);
	fieldDatasourceElem.appendChild(selDatasourceFbodyElem);

	
	formChartElementConfig1.appendChild(fieldDatasourceElem);*/
	
	const selDatasourceElem = document.createElement("select");
		selDatasourceElem.name="chartElementDatasource";
		selDatasourceElem.id="chartElementDatasource";
		selDatasourceElem.classList.add("select");
		selDatasourceElem.classList.add("is-small");
		//selDatasourceElem.style.width="100px";

		fillSelectOptions(selDatasourceElem,rsTableMetaData,true,(myChartElem!=null?myChartElem.datasource:null));
		var datasourceFieldHtml="";
		if(rsTableMetaData.length==1)
		{
			//wenn nur ein Resultset da ist, kann es ausgeblendet bleiben:
			selDatasourceElem.style="display:none;";
			datasourceFieldHtml=getOuterHTML(selDatasourceElem);
		}
		else
		{
			 datasourceFieldHtml=generateFormFieldHtml("Datenquelle","chartElementDatasource","Datenquelle für das Diagrammelement, bei Makroberichten wählen Sie die Tabellennnummer",selDatasourceElem);
		}
	
	const selVizTypeElem = document.createElement("select");
		selVizTypeElem.name="chartElementVizType";
		selVizTypeElem.id="chartElementVizType";
		selVizTypeElem.classList.add("select");
		selVizTypeElem.classList.add("is-small");
		//selVizTypeElem.style.width="100px";
		
		fillSelectOptions(selVizTypeElem,getPossibleVizTypes(renderer),false,(myChartElem!=null?myChartElem.vizTypeUniquename:null));
	
	
	var vizTypeFieldHtml=generateFormFieldHtml("Grafikelement-Typ","chartElementVizType","Art des Grafikelements",selVizTypeElem);
	
	formChartElementConfig1.innerHTML=datasourceFieldHtml+vizTypeFieldHtml;
	//add onchange:
	document.getElementById("chartElementDatasource").addEventListener(
     'change',
     function() { createChartElementsConfig2Form(renderer); },
     false
  );
  document.getElementById("chartElementVizType").addEventListener(
     'change',
     function() { createChartElementsConfig2Form(renderer); },
     false
  );
	
		//Then vizType:
	/*
	const fieldVizTypeElem = document.createElement("div");
	fieldVizTypeElem.classList.add("field");
	fieldVizTypeElem.classList.add("is-horizontal");
		//label:
	const labelVizTypeElem = document.createElement("div");
	labelVizTypeElem.classList.add("field-label");
	labelVizTypeElem.classList.add("is-small");
		const labelVizType = document.createElement("label");
		labelVizType.classList.add("label");
		labelVizType.classList.add("is-required");
		labelVizType.classList.add("is-small");
		labelVizType.classList.add("has-tooltip-right");
		labelVizType.setAttribute("data-tooltip","Art des Grafikelements");

		const textnodeVizType = document.createTextNode("Grafikelement-Typ");
		labelVizType.appendChild(textnodeVizType);
		labelVizTypeElem.appendChild(labelVizType);
		fieldVizTypeElem.appendChild(labelVizTypeElem);

		const selVizTypeFbodyElem = document.createElement("div");
		selVizTypeFbodyElem.classList.add("field-body");
	
		const selVizTypeElem = document.createElement("select");
		selVizTypeElem.name="chartElementVizType";
		selVizTypeElem.id="chartElementVizType";
		selVizTypeElem.classList.add("select");
		selVizTypeElem.classList.add("is-small");
		selVizTypeElem.style.width="100px";
		selVizTypeElem.onchange= function () {  
				createChartElementsConfig2Form(renderer);
		};
		fillSelectOptions(selVizTypeElem,getPossibleVizTypes(renderer),false,(myChartElem!=null?myChartElem.vizTypeUniquename:null));
		
		selVizTypeFbodyElem.appendChild(selVizTypeElem);
	fieldVizTypeElem.appendChild(selVizTypeFbodyElem);
	
	formChartElementConfig1.appendChild(fieldVizTypeElem);
	*/
	//display Element if already saved:
	if(elemID!="")
		createChartElementsConfig2Form(renderer,elemID);
	
	}
function createChartElementsConfig2Form(renderer,elemID)
{	
	var dataSource=document.getElementById("chartElementDatasource").value;
	var vizType=document.getElementById("chartElementVizType").value;
	//now Elements:
	var formChartElementConfig2Div=document.getElementById("ChartElementConfig2Div");
	while (formChartElementConfig2Div.firstChild) {
		formChartElementConfig2Div.removeChild(formChartElementConfig2Div.firstChild);
	}
	//any previous values?
	//reset general properties:
	//renderGeneralChartPropertiesForm("generalChartPropertiesFormDiv",myCommonChartProperties,renderer);	

	const elementDivBox = document.createElement("div");
	//first only Dimensions and measures:
	var elementDivBoxHtml="";
	for(var k=0;k < vizTypeProperties.length;k++)
	{
		if(vizType==vizTypeProperties[k].typeUniquename && 
		(vizTypeProperties[k].groupUniquename=="CATEGORY"
		|| vizTypeProperties[k].groupUniquename=="MEASURE"
		)
		)
		{
			var selectedValue=getChartElementPropertyValue(elemID,vizTypeProperties[k].propUniquename);
			elementDivBoxHtml+=renderDimensionField(vizTypeProperties[k],dataSource,selectedValue);
			//elementDivBox.appendChild(renderDimensionField(vizTypeProperties[k],dataSource,selectedValue));
			}
	}
	elementDivBox.innerHTML=elementDivBoxHtml;
	//chartElement-specific properties:
	//without Dimensions and measures:
	
	/*for(var k=0;k < vizTypeProperties.length;k++)
	{
		if(vizType==vizTypeProperties[k].typeUniquename 
		&& vizTypeProperties[k].groupUniquename!="CATEGORY"
		&& vizTypeProperties[k].groupUniquename!="MEASURE"
		){
			
			var currentCommonChartProperties=commonChartProperties.filter(obj => obj.name == vizTypeProperties[k].propUniquename);
			if(currentCommonChartProperties.length >0)
			{
				
				elementDivBox.appendChild(renderChartPropertyField(elemID,currentCommonChartProperties[0],false));
				}
				else
				{
					const unknownFieldDiv = document.createElement("div");
					const unknownField=document.createTextNode("Unbekanntes Feld "+vizTypeProperties[k].propUniquename);
					unknownFieldDiv.appendChild(unknownField);
					elementDivBox.appendChild(unknownFieldDiv);
				}
				
			}
	}*/
	

	const saveBtnDiv = document.createElement("div");
	const saveBtn = document.createElement("input");
	saveBtn.type="BUTTON";
	saveBtn.value="Übernehmen";
	saveBtn.classList.add("button");
	saveBtn.classList.add("is-small");

	saveBtn.onclick =function() {
            saveChartElementConfig()
        }
	saveBtnDiv.appendChild(saveBtn);
	elementDivBox.appendChild(saveBtnDiv);
	
	formChartElementConfig2Div.appendChild(elementDivBox);
	
	
}
function getChartElementPropertyValue(elemID,propUniquename)
{
	var retVal=null;
	var myChartElem=null;
	if(myChartModel.chartElements && elemID !=null)
	{
		var filtered=myChartModel.chartElements.filter(obj => obj.elemID == elemID);
		var myChartElem=filtered[0];
		if(myChartElem.elementTypeProperties && myChartElem.elementTypeProperties.length)
		{
			for(var k=0;k < myChartElem.elementTypeProperties.length;k++)
			{
			myVizTypeProperty=myChartElem.elementTypeProperties[k];
			if(myVizTypeProperty.vizTypePropertyUniquename==propUniquename)
			{
				retVal=myVizTypeProperty.propertyValue;
			}
			}
		}
	}
	return retVal;
}
function loadChartElementConfig(myElem)
{
	var elemID=myElem.value;
	if(elemID=="")
		alert("Kein Grafikelement gefunden");
	else
	{
	var renderer=document.getElementById("fldVizRenderer").value;
	var myVizType=myChartModel.chartElements.filter(obj => obj.elemID == elemID);
	//var myVizType=myChartModel.chartElements[elemID];
	createChartElementConfig1Form(renderer,elemID);
	//document.getElementById("chartElementVizType").value=myVizType.vizTypeUniquename;
	//document.getElementById("chartElementDatasource").value=myVizType.datasource;
	}
}
function saveChartElementConfig()
{
	var elemID=document.getElementById("chartElementID").value;
	var vizTypeUniquename=document.getElementById("chartElementVizType").value;
	var datasource=document.getElementById("chartElementDatasource").value;
	var title=document.getElementById("chartName").value;
	var nextElemID=parseInt(document.getElementById("vizElementCounter").value) +1;
	var mode="update";
	if(elemID=="")
	{
	//insert mode:	
	mode="insert";
	if(myChartModel.chartElements)
		elemID=myChartModel.chartElements.length +1;
		else
		elemID="0";
	}
	var myVizType=new usedVizType(elemID,vizTypeUniquename,vizTypeUniquename,datasource); //nr,vizTypeUniquename,caption,datasource
	var propertyCounter=0;
	for(var k=0;k < vizTypeProperties.length;k++)
	{
		
		if(vizTypeUniquename==vizTypeProperties[k].typeUniquename
		&& document.getElementById(vizTypeProperties[k].propUniquename)
		&& document.getElementById(vizTypeProperties[k].propUniquename).value !="")
		{
			var myUsedVizTypeProperty=new usedVizTypeProperty(elemID,vizTypeProperties[k].propUniquename, vizTypeProperties[k].caption,document.getElementById(vizTypeProperties[k].propUniquename).value,vizTypeProperties[k].propertyType); //))nr,vizTypePropertyUniquename,caption,propertyValue )
			myVizType.elementTypeProperties.push(myUsedVizTypeProperty); 
		}
	}
	//myVizType.elementTypeProperties=null;
	//TODO: Existenz abfangen, hier wird einfach hinzugefügt:
	if(mode=="update")
	{
		for(var k=0;k<myChartModel.chartElements.length;k++)
		{
		if(myChartModel.chartElements[k].elemID==elemID)
				myChartModel.chartElements[k]=myVizType;
		}
		}
	else
		myChartModel.chartElements.push(myVizType);
	const chartElementListSelect=document.getElementById("chartElementID");
	chartElementListSelect.style="display:inline;";
	fillChartElementListSelect(chartElementListSelect,elemID);

	//document.getElementById("vizElementCounter").value=myChartModel.chartElements.length;
	renderChart('chartDiv',myChartModel,datasource,title);
	updateChartModelCode(myChartModel);
	
	/*var marksArray=new Array();
	marksArray[elemID]=Plot.barX(rs_table0,
	 	{
    		          x: "gesamt", 
    		          y: "eintrag",
			  fill: "blue"
    		        }
			);
	chartOptions["marks"].push(marksArray);*/
	
}
function removeChartElementConfig()
{
	
	var elemID=document.getElementById("chartElementID").value;
	if(elemID!="")
	{
	var renderer=document.getElementById("fldVizRenderer").value;
		var filtered=myChartModel.chartElements.filter(obj => obj.elemID != elemID);
		myChartModel.chartElements=filtered;
		//myChartModel.chartElements.pop();
		//elemID--;
		//if(document.getElementById("chartElementID"))
		//	document.getElementById("chartElementID").value=elemID;
		document.getElementById("vizElementCounter").value=myChartModel.chartElements.length;
		const chartElementListSelect=document.getElementById("chartElementID");
		fillChartElementListSelect(chartElementListSelect);
		createChartElementConfig1Form(renderer,null);
		renderChart('chartDiv',myChartModel);
	}
}

function fillChartElementListSelect(mySelectElem,selectedValue)
{
	var chartElementListSelectOptionArray=new Array();
	if(myChartModel.chartElements.length>0)
	{
		
		for(var k=0;k < myChartModel.chartElements.length;k++)
		{
			var myOptionValue=new possibleVizType(myChartModel.chartElements[k].elemID,
			myChartModel.chartElements[k].elemID,
			myChartModel.chartElements[k].vizTypeUniquename + "-"+myChartModel.chartElements[k].datasource,
			"", //explanation
			(myChartModel.chartElements[k].elemID==selectedValue ? true:false) //isDefault
			);
			chartElementListSelectOptionArray.push(myOptionValue);
		}
	}
	fillSelectOptions(mySelectElem,chartElementListSelectOptionArray,false,selectedValue);

}

function showChartElementsBodyForm(elemID)
{
	//Reset Elements Form
	//elemID++;
	var filtered=myChartModel.chartElements.filter(obj => obj.elemID == elemID);
	
	document.getElementById("chartElementID").value=elemID;
	document.getElementById("chartElementVizType").value=filtered[0].vizTypeUniquename;
	var formChartElementConfig2Div=document.getElementById("ChartElementConfig2Div");
	while (formChartElementConfig2Div.firstChild) {
		formChartElementConfig2Div.removeChild(formChartElementConfig2Div.firstChild);
	}
	
}

function resetChartPropertiesForm(chosenRenderer)
{
	myChartModel=new chartModel(1,"",document.getElementById("fldVizRenderer").value,rsTableMetaData);
	renderChart('chartDiv',myChartModel);
	//Show Plot Code if renderer =plot:
	var myDiv=document.getElementById("chartCodeDiv");
	if(chosenRenderer=="plot" || chosenRenderer=="echarts")
		myDiv.style.display="block";
	else
		myDiv.style.display="none";
	
	if(chosenRenderer=="plot")
		document.getElementById("fldChartTypeSelection").style="display:block;";
	else
		document.getElementById("fldChartTypeSelection").style="display:none;";
	
	createChartElementConfig1Form(chosenRenderer,null);
	return true;
}
function getPossibleVizTypes(renderer)
{
	
	var possibleVizTypes=new Array();
	for(var k=0;k < vizTypes.length;k++)
		{
		if(vizTypes[k].rendererUniquename==renderer)
			{
				var newVizType = new possibleVizType( //nr,value,name,explanation,isDefault 
				k,vizTypes[k].uniquename,vizTypes[k].caption,'',false);
				possibleVizTypes.push(newVizType);
				
				
			}
		}
		
	return possibleVizTypes;
}
function fillDimensionProperty(vizTypeProperty,datasource)
{
	var isMeasure=(vizTypeProperty.groupUniquename=="MEASURE")?true:false;
	var myProp= new dimensionProperty(vizTypeProperty.propUniquename,vizTypeProperty.caption,vizTypeProperty.explanation,isMeasure,vizTypeProperty.isMandatory,datasource);
	
	return myProp;
}
function showChartPropertiesFormDiv(formDiv,formElementsDiv,renderer)
{
	if(myChartModel != null)
	{
	var myDiv=document.getElementById(formDiv);
	switch (formDiv)
	{
		case "chartPropertiesTreeFormDiv":
			renderChartPropertiesTreeForm(formElementsDiv,commonChartProperties,myChartModel);
		break;
		case "generalChartPropertiesFormDiv":
			renderGeneralChartPropertiesForm(formElementsDiv,commonChartProperties,myChartModel);
		break;
		case "ChartElementsDiv":
			createChartElementConfig1Form(myChartModel.renderer,null);
		break;
		default:
		//do nothing
		break;
		}
			

	if(myDiv.style.display=="block")
		myDiv.style.display="none";
	else
		myDiv.style.display="block";
}
}

function showSaveChartFormDiv(formDiv,renderer)
{
	var myDiv=document.getElementById(formDiv);
	
	if(myDiv.style.display=="block")
		myDiv.style.display="none";
	else
		myDiv.style.display="block";

}


function prepareForm(vizTypeUniquename,vizTypeProperties)
{
	var chartProperties=[];
	var propertyCounter=0;
	for(var k=0;k < vizTypeProperties.length;k++)
	{
	if(vizTypeUniquename==vizTypeProperties[k].typeUniquename)
	{
		var isMeasure=(vizTypeProperties[k].groupUniquename=="MEASURE")?true:false;
		var myProp= new dimensionProperty(vizTypeProperties[k].propUniquename,vizTypeProperties[k].caption,vizTypeProperties[k].explanation,isMeasure,vizTypeProperties[k].isMandatory);
		chartProperties.push(myProp);
		propertyCounter++;
	}
	}
	return chartProperties;
}
/*
function prepareBarXForm()
{
	var chartProperties=[];
	var propertyCounter=0;
	var myProp= new dimensionProperty("viz_dimension1","Kategorie-Dimension",false,true);
	chartProperties[0]=myProp;
	var myProp= new dimensionProperty("viz_measure1","Maß",true,true);
	chartProperties[1]=myProp;

return chartProperties;
}

function prepareBarYForm()
{
	var chartProperties=[];
	var propertyCounter=0;
	var myProp= new dimensionProperty("viz_dimension1","Kategorie-Dimension",true,false,true,null,null,true);
	chartProperties[0]=myProp;
	var myProp= new dimensionProperty("viz_dimension2","Serien-Dimension",true,false,false,null,null,true);
	chartProperties[1]=myProp;
	var myProp= new dimensionProperty("viz_measure1","Maß",true,true,true,null,null,true);
	chartProperties[2]=myProp;

return chartProperties;
}

function prepareLineForm()
{
	var chartProperties=[];
	var propertyCounter=0;
	var myProp= new dimensionProperty("viz_dimension1","Kategorie-Dimension",true,false,true,null,null,true);
	chartProperties[0]=myProp;
	var myProp= new dimensionProperty("viz_dimension2","Serien-Dimension",true,false,false,null,null,true);
	chartProperties[1]=myProp;
	var myProp= new dimensionProperty("viz_measure1","Maß",true,true,true,null,null,true);
	chartProperties[2]=myProp;

return chartProperties;
}

function prepareLineForm_alt()
{
	var chartProperties=[];
	var propertyCounter=0;
	var myProp= new dimensionProperty("dimension1","X-Achse",true,false,true,null,null,true);
	chartProperties[0]=myProp;
	var myProp= new dimensionProperty("measure1","Y-Achse",true,true,true,null,null,true);
	chartProperties[1]=myProp;

return chartProperties;
}
*/


function selectionResultPreview(myDiv)
{
	myDivElem=document.getElementById(myDiv);
if(myDivElem.style.display=="none")
{
	var selectionRs=[];
	var selectionRsMetaData=[];
	var rowcount=rs.length;
	var maxLenCategoryDim=0;
	var maxMeasure=0;
	selectionRsMetaData=fillSelectionResultMetaData();
	//alert(selectionRsMetaData[0].colname);
	selectionRs=fillSelectionResult(selectionRsMetaData);

	showSelectionTable("selectionResultPreviewTable",selectionRs,selectionRsMetaData,10);
	myDivElem.style.display="block";
}
else
	myDivElem.style.display="none";
}
function fillSelectionResultMetaData()
{
	var selectionRsMetaData=[];
	var dimension1=document.getElementById("dimension1").value;
	var dimension2=document.getElementById("dimension2").value;
	var measure=document.getElementById("measure1").value;
	
	var functionOfDimension1=document.getElementById("dimension1_fn").value;
	var functionOfDimension2=document.getElementById("dimension2_fn").value;
	var functionOfMeasureDim=document.getElementById("measure1_fn").value;
	
	//first fill metadata:

	var counter=1;
	selectionRsMetaData.push(new selectionRowMetaData(counter,"dimension1",dimension1,getColumnCaption(dimension1),0,functionOfDimension1));
	if(dimension2!="")
		{
		counter++;
		var dim2=new selectionRowMetaData(counter,"dimension2",dimension2,getColumnCaption(dimension2),0,functionOfDimension2);
		selectionRsMetaData.push(dim2 );
		}
	counter++;
	selectionRsMetaData.push(new selectionRowMetaData(counter,"measure",measure,getColumnCaption(measure),0),functionOfMeasureDim);
	
	return selectionRsMetaData;
}



function renderDimensionField(vizTypeProperty,datasource,selectedValue)
{
	const selElem = document.createElement("select");
		selElem.name=vizTypeProperty.propUniquename;
		selElem.id=vizTypeProperty.propUniquename;
		var dimensionProperty=fillDimensionProperty(vizTypeProperty,datasource);
		fillSelectOptions(selElem,dimensionProperty.getValueResultset(),dimensionProperty.isMandatory,selectedValue);

	var zs=generateFormFieldHtml(vizTypeProperty.caption,vizTypeProperty.propUniquename,"Je nach Grafikelement Festlegung der Achsen oder Dimensionen und Maße.",selElem); //TODO tooltip
	return zs;
}
function renderDimensionFieldAlt(vizTypeProperty,datasource,selectedValue)
{
		const fieldElem = document.createElement("div");
		fieldElem.classList.add("field");
		fieldElem.classList.add("is-horizontal");
		//label:
		const labelElem = document.createElement("div");
		labelElem.classList.add("field-label"); // is-normal
		labelElem.classList.add("is-small");
		const label = document.createElement("label");
		label.classList.add("label");
		label.classList.add("is-required");
		label.classList.add("is-small");
		label.classList.add("has-tooltip-right");
		//label.setAttribute("data-tooltip",dimensionProperty.explanation);

		const textnode = document.createTextNode(vizTypeProperty.caption);
		label.appendChild(textnode);
		labelElem.appendChild(label);
		fieldElem.appendChild(labelElem);
		//field body:
		const fbodyElem = document.createElement("div");
		fbodyElem.classList.add("field-body");
		
		//input:
		
		const inputFieldElem = document.createElement("div");
		inputFieldElem.classList.add("field");
		inputFieldElem.classList.add("is-active");
		inputFieldElem.style.width="100px";
		const inputSelectElem = document.createElement("div");
		inputSelectElem.classList.add("select");
		inputSelectElem.classList.add("is-small");
		//inputSelectElem.classList.add("is-fullwidth");
		
		const selElem = document.createElement("select");
		selElem.name=vizTypeProperty.propUniquename;
		selElem.id=vizTypeProperty.propUniquename;
/*	vermutlich unnötig:	selElem.onchange= function () {  
				renderChart('chartDiv'); 
		};*/
		var dimensionProperty=fillDimensionProperty(vizTypeProperty,datasource);
		fillSelectOptions(selElem,dimensionProperty.getValueResultset(),dimensionProperty.isMandatory,selectedValue);
		inputSelectElem.appendChild(selElem);
		inputFieldElem.appendChild(inputSelectElem);
		fbodyElem.appendChild(inputFieldElem);
		
		fieldElem.appendChild(fbodyElem);
		return fieldElem;

}
function renderChartPropertiesTreeForm(formDiv,myCommonChartProperties,currentChartModel)
{
	//first empty form:
	var myForm=document.getElementById(formDiv);
	while (myForm.firstChild) {
		myForm.removeChild(myForm.firstChild);
	}
	const treeDiv = document.createElement("div");
	const treeDivText = document.createTextNode(" Insg. " + vizPropertyTreeNodes.length+ "Eigenschaften:");
	const treeDivTextBold = document.createElement("strong");
		treeDivTextBold.appendChild(treeDivText);
	treeDiv.appendChild(treeDivTextBold);
	var propertyTree = new Array();
	for(var k=0;k < vizPropertyTreeNodes.length;k++)
		{
			if(vizPropertyTreeNodes[k].typeUniquename== document.getElementById("chartElementVizType").value //Abfragen welcher VIZ-Type
			)
			{
				
				var myProp=myCommonChartProperties.find(prop => prop.name === vizPropertyTreeNodes[k].propUniquename);
				if(myProp.groupUniquename!="CATEGORY" && myProp.groupUniquename!="MEASURE" && myProp.propUniquename !="dimensionsNode")
				{
				var myPropValue=getPropertyValueFromModel(currentChartModel,vizPropertyTreeNodes[k].propUniquename,true,vizPropertyTreeNodes[k].typeUniquename )
				let entry=new sxTreeNode;
				entry.id=vizPropertyTreeNodes[k].propUniquename;
				entry.caption=vizPropertyTreeNodes[k].propertyCaption; 
				entry.parent=vizPropertyTreeNodes[k].parentPropertyUniquename;
				if(myProp.inputType!="NODE")
				{
					entry.inputPostCaption=renderTreeInput(myProp,entry.id,myPropValue);
				}
				if(myProp.inputType=="NODE") 
				{					
					entry.hasChildren=true;
				}
				entry.explanation=myProp.explanation;
				propertyTree.push(entry);
				}

				/* alter Code Liste:if(myProp.groupUniquename!="CATEGORY" && myProp.groupUniquename!="MEASURE")
				{
					if(myProp.inputType=="NODE")
					{
						const treeNodeText = document.createTextNode(myProp.caption);
						treeDiv.appendChild(treeNodeText);
					}
					else
					{
						treeDiv.appendChild(renderChartPropertyField(null,myProp,true));
					}
				}*/
			}
		}
		if(propertyTree && propertyTree.length >0)
{
//zs +="<li>content.nodes.length"+content.nodes.length+"</li>";
				var zs="";
				zs +="<ul id='sichtentreeUL'>";

for(var j=0;j < propertyTree.length;j++)
{
var node=propertyTree[j];
if(node.parent==null  || node.parent=="")
	zs +=node.renderSxNode(propertyTree,true);
}
}

zs +="</ul>";
treeDiv.innerHTML=zs;
	myForm.appendChild(treeDiv);
}
function getPropertyValueFromModel(myChartModel,propUniquename,isCommon,chartElemId )
{
	//Wenn im chartModel schon ein Wert vorhanden ist, wird er vorbelegt: if(chartProperty)
		var propValue="";
		if(myChartModel && isCommon && myChartModel.chartPropertiesUsed.length>0)
		{
			propValue=getChartPropertyFromModel(myChartModel.chartPropertiesUsed,propUniquename,isCommon );
		}
		if(myChartModel && !isCommon && myChartModel.chartElements.length >0)
		{
			var filtered=myChartModel.chartElements.filter(obj => obj.elemID == chartElemId);
			var myChartElem=filtered[0];
		if(myChartElem && myChartElem.elementTypeProperties && myChartElem.elementTypeProperties.length)
			{

 			propValue=getChartPropertyFromModel(myChartElem.elementTypeProperties,propUniquename,isCommon );
			}
		}
		return propValue;
}

function renderTreeInput(chartProperty,inputId, previousValue)
{
	var zs="";
	var styleAttr=" style=\"box-shadow: inset 1px 1px 3px #cccccc;border-radius: 5px;\" ";
	switch (chartProperty.inputType) {
			case "TEXT":
				zs="&nbsp;<span class=\"field\"><input type=\"text\"" +styleAttr+"size=\"6\" id=\""+inputId+"\" name=\""+inputId+"\"";
				zs+=" value=\""+previousValue +"\" onChange=\"treeInputOnchange('chartDiv',myChartModel);\" /></span>";
			break;
			case "SELECT":
				zs="&nbsp;<span class=\"field\"><select " +styleAttr+" id=\""+inputId+"\" name=\""+inputId+"\"";
				zs+=" value=\""+previousValue +"\" onChange=\"treeInputOnchange('chartDiv',myChartModel);\" >";
				zs+=getTreeInputSelectOptions(chartProperty.getValueResultset(),previousValue,chartProperty.isMandatory) ;
				
				zs+="</select></span>";
			break;
		case "CHECKBOX":
				zs="&nbsp;<span class=\"field\"><input type=\"checkbox\" id=\""+inputId+"\" name=\""+inputId+"\"";
				zs+=" value=\""+previousValue +"\" onChange=\"treeInputOnchange('chartDiv',myChartModel);\"";
				zs+=(previousValue)?"checked ":"";
				zs+="></input></span>";
			break;
		case "COLOR":
				zs="&nbsp;<span class=\"field\"><input type=\"text\"" +styleAttr+"size=\"6\" id=\""+inputId+"\" name=\""+inputId+"\"";
				zs+=" value=\""+previousValue +"\" onChange=\"treeInputOnchange('chartDiv',myChartModel);\" /></span>";
				zs+="&nbsp;<input type=\"color\" " +styleAttr+" id=\"colorpicker"+inputId+"\" ";
				zs+=" onChange=\"changeColorWithColorPicker(this,'"+inputId+"');treeInputOnchange('chartDiv',myChartModel);\">";
				zs+="</input></span>";
			break;
			default:
				zs="Unbekannter Feldtyp";
			break;
			}
	return zs;
}
function changeColorWithColorPicker(colorpickerInput,targetInputid)
{
	document.getElementById(targetInputid).value=colorpickerInput.value;
}
function getTreeInputSelectOptions(myValues,selectedValue,isMandatory)
{
	var zs="";
	for(var j=0;j < myValues.length;j++)
	{
	var selectedOption=null;
	var defaultSelected=false;
	if(myValues[j].value==selectedValue)
	{
		selectedOption=j+(isMandatory?0:1);
		defaultSelected=true;
		}
	if(selectedOption==null && myValues[j].isDefault)
	{
		selectedOption=j+(isMandatory?0:1);
		defaultSelected=true;
		}
	zs+="<option value=\""+myValues[j].value+"\"";
	if(defaultSelected)
		zs+=" selected=true";
	zs+=">"; 
	zs+=myValues[j].name;
	zs+="</option>";
	
	
	}
	return zs;
}
function treeInputOnchange(targetDiv,myChartModel)
{
	updateChartModel();
	renderChart(targetDiv,myChartModel);
	
	//TODO SRC-Textarea
}
function renderGeneralChartPropertiesForm(formDiv,myCommonChartProperties,currentChartModel)
{
	//first empty form:
	var myForm=document.getElementById(formDiv);
	while (myForm.firstChild) {
		myForm.removeChild(myForm.firstChild);
	}
	//first Collect all groups:
	var commonChartPropertyGroups=[];
	var previousGroup="";
	for(var k=0;k < myCommonChartProperties.length;k++)
	{
		if(myCommonChartProperties[k].rendererUniquename==currentChartModel.renderer || myCommonChartProperties[k].isGeneric==1)
		{
			var groupUniquename=myCommonChartProperties[k].groupUniquename;
			if(groupUniquename!="" 
				&& groupUniquename != previousGroup
				&& myCommonChartProperties[k].groupVariableName !=""
				)
			{
			var newcommonChartPropertyGroup = new commonChartPropertyGroup(myCommonChartProperties[k].groupCaption,groupUniquename,"");
			commonChartPropertyGroups.push(newcommonChartPropertyGroup);
			previousGroup=groupUniquename;
			}
		}
	
	}
	const columnDiv = document.createElement("div");
	for(var i=0;i < commonChartPropertyGroups.length;i++)
	{
	
		const columnGroupDiv = document.createElement("div");
		columnGroupDiv.id=commonChartPropertyGroups[i].groupUniquename;
		columnGroupDiv.classList.add("block");
		
		const columnGroupHeaderDiv = document.createElement("div");
		const colHeader = document.createTextNode(commonChartPropertyGroups[i].caption);
		const colHeaderBold = document.createElement("strong");
		colHeaderBold.appendChild(colHeader);
		const colHeaderParagraph = document.createElement("label");
		colHeaderParagraph.classList.add("label");
		colHeaderParagraph.classList.add("is-small");
		colHeaderParagraph.appendChild(colHeaderBold);
		//Toggle visibility:
		const colHeaderToggleBtn = document.createElement("a");
		colHeaderToggleBtn.id="openBody"+commonChartPropertyGroups[i].groupUniquename;
		//colHeaderToggleBtn.classList.add("is-small");
		colHeaderToggleBtn.onclick =function() {
            toggleGroupBodyDiv(this.id)
        }
		const colHeaderToggleBtnText = document.createTextNode(" ...");
		colHeaderToggleBtn.appendChild(colHeaderToggleBtnText);
		colHeaderParagraph.appendChild(colHeaderToggleBtn);
		columnGroupHeaderDiv.appendChild(colHeaderParagraph);
		//columnGroupHeaderDiv.appendChild(colHeaderToggleBtn);
		
		columnGroupDiv.appendChild(columnGroupHeaderDiv);
		const columnGroupBodyDiv = document.createElement("div");
		columnGroupBodyDiv.id="Body"+commonChartPropertyGroups[i].groupUniquename;
		columnGroupBodyDiv.style.display="none";
		for(var k=0;k < myCommonChartProperties.length;k++)
		{
			if(myCommonChartProperties[k].groupUniquename==commonChartPropertyGroups[i].groupUniquename
			&& myCommonChartProperties[k].variableName!=""
			//&& !isChartPropertyValidForChartelements(myCommonChartProperties[k],currentChartModel)
			&& (myCommonChartProperties[k].rendererUniquename==currentChartModel.renderer
			//|| myCommonChartProperties[k].isGeneric==1
			)
			)
			{
				columnGroupBodyDiv.appendChild(renderChartPropertyField(null,myCommonChartProperties[k],true));
				}
		}
		columnGroupDiv.appendChild(columnGroupBodyDiv);
	columnDiv.appendChild(columnGroupDiv);
	
	}
	myForm.appendChild(columnDiv);
	
}




function toggleGroupBodyDiv(groupBodyDiv)
{
	var bodyDiv=groupBodyDiv.substr(4); //remove "open" Prefix
	var myDiv=document.getElementById(bodyDiv);
	if(myDiv.style.display=="block")
		myDiv.style.display="none";
	else
		myDiv.style.display="block";

}

function renderChartPropertyField(elemID,chartProperty,isCommon)
{
		//Wenn im chartModel schon ein Wert vorhanden ist, wird er vorbelegt: if(chartProperty)
		var propValue="";
		if(myChartModel && isCommon && myChartModel.chartPropertiesUsed.length>0)
		{
			propValue=getChartPropertyFromModel(myChartModel.chartPropertiesUsed,chartProperty.name,isCommon );
		}
		if(myChartModel && !isCommon && myChartModel.chartElements.length >0)
		{
			var filtered=myChartModel.chartElements.filter(obj => obj.elemID == elemID);
			var myChartElem=filtered[0];
		if(myChartElem && myChartElem.elementTypeProperties && myChartElem.elementTypeProperties.length)
			{

 			propValue=getChartPropertyFromModel(myChartElem.elementTypeProperties,chartProperty.name,isCommon );
			}
		}
		const fieldElem = document.createElement("div");
		fieldElem.classList.add("field");
		fieldElem.classList.add("is-grouped");
		//label:
		const labelElem = document.createElement("div");
		labelElem.classList.add("label-container");
		labelElem.setAttribute("style","min-width;5.0rem;width=5.0rem");
		const label = document.createElement("label");
		label.classList.add("label");
		label.classList.add("is-required");
		label.classList.add("is-small");
		label.classList.add("has-tooltip-bottom");
		label.setAttribute("data-tooltip",chartProperty.explanation);
		

		const textnode = document.createTextNode(chartProperty.caption);
		label.appendChild(textnode);
		labelElem.appendChild(label);
		fieldElem.appendChild(labelElem);
		//input:
		const inputControlElem = document.createElement("div");
		inputControlElem.classList.add("control");
		

		const inputFieldElem = document.createElement("div");
		inputFieldElem.classList.add("field");
		const inputElem = document.createElement("div");
		inputElem.classList.add("is-small");
		//inputElem.classList.add("is-fullwidth");
		
		switch (chartProperty.inputType) {
		case "SELECT":
			//select input:
			inputElem.classList.add("select");
			inputElem.classList.add("is-small");
			inputElem.style.width="100px";
			const selElem = document.createElement("select");
			selElem.name=chartProperty.name;
			selElem.id=chartProperty.name;
			//selElem.style="width:50px";
			if(chartProperty.variableName=="")
			{
				selElem.disabled="disabled";
				selElem.readonly="readonly";
			}
	
			selElem.onchange= function () {  
					updateChartModel();
					renderChart('chartDiv',myChartModel);
			};
			fillSelectOptions(selElem,chartProperty.getValueResultset(),chartProperty.isMandatory,propValue);
			selElem.value= (propValue=="")?chartProperty.defaultValue:propValue;
			inputElem.appendChild(selElem);
			inputFieldElem.appendChild(inputElem);

		break;
		case "TEXTAREA":
			//großes Texteingabefeld:
			const textAreaElem = document.createElement("textarea");
			textAreaElem.cols="20";
			textAreaElem.rows=3;
			if(chartProperty.variableName=="")
			{
				textAreaElem.disabled="disabled";
				textAreaElem.readonly="readonly";
			}
			textAreaElem.name=chartProperty.name;
			textAreaElem.id=chartProperty.name;
			textAreaElem.value= (propValue=="")?chartProperty.defaultValue:propValue;
			textAreaElem.onchange= function () {  
					updateChartModel();
					renderChart('chartDiv',myChartModel);
			};
			inputElem.appendChild(textAreaElem);
			inputFieldElem.appendChild(inputElem);
			
		break;
		case "RANGE":
		
			//Schieberegler:
			const rangeElem = document.createElement("input");
			rangeElem.type="NUMBER";
			rangeElem.size=5;
			if(chartProperty.variableName=="")
			{
				rangeElem.disabled="disabled";
				rangeElem.readonly="readonly";
			}
			
			/* klappt noch nicht:
			rangeElem.type="RANGE";
			rangeElem.min=chartProperty.range_from;
			rangeElem.max=chartProperty.range_to;
			rangeElem.step=50;
			*/

			rangeElem.name=chartProperty.name;
			rangeElem.id=chartProperty.name;
			rangeElem.value= (propValue=="")?chartProperty.defaultValue:propValue;
			rangeElem.onchange= function () {  
					updateChartModel();
					renderChart('chartDiv',myChartModel);
			};
			inputElem.appendChild(rangeElem);
			inputFieldElem.appendChild(inputElem);
		break;
		case "CHECKBOX2": //klappt noch nicht
		const checkboxElem = document.createElement("input");
			checkboxElem.type="CHECKBOX";
			//checkboxElem.value="1";
			if(chartProperty.variableName=="")
			{
				checkboxElem.disabled="disabled";
				checkboxElem.readonly="readonly";
			}
			checkboxElem.name=chartProperty.name;
			checkboxElem.id=chartProperty.name;
			checkboxElem.value= (propValue=="")?chartProperty.defaultValue:propValue;
			checkboxElem.onchange= function () {  
					updateChartModel();
					renderChart('chartDiv',myChartModel);
			};
			inputElem.appendChild(checkboxElem);
			inputFieldElem.appendChild(inputElem);
		break;
		default:
			//Einfaches Texteingabefeld:
			const inpElem = document.createElement("input");
			inpElem.type="TEXT";
			if(chartProperty.propValueType=="integer")
					inpElem.type="NUMBER";
			if(chartProperty.inputType=="COLOR")
					inpElem.type="color";
			inpElem.size=5;
			if(chartProperty.variableName=="")
			{
				inpElem.disabled="disabled";
				inpElem.readonly="readonly";
			}
			inpElem.name=chartProperty.name;
			inpElem.id=chartProperty.name;
			inpElem.value= (propValue=="")?chartProperty.defaultValue:propValue;
			inpElem.onchange= function () {  
					updateChartModel();
					renderChart('chartDiv',myChartModel);
			};
			inputElem.appendChild(inpElem);
			inputFieldElem.appendChild(inputElem);
			
		break;
		}
		
		
		inputControlElem.appendChild(inputFieldElem);
		fieldElem.appendChild(inputControlElem);
		return fieldElem;

}



function fillSelectOptions(myCombo,myValues,isMandatory,selectedValue)
{
var optionCounter=0;
var selectedOption=null;
while (myCombo.firstChild) {
    myCombo.removeChild(myCombo.firstChild);
}
var optionCounter=0;
if(!isMandatory)
{
	//add an empty option:
	var o=new Option("","");
	myCombo.options[optionCounter]=o;
	selectedOption=optionCounter;
	optionCounter++;
}
for(var j=0;j < myValues.length;j++)
{
	var defaultSelected=false;
	if(myValues[j].value==selectedValue)
	{
		selectedOption=j+(isMandatory?0:1);
		defaultSelected=true;
		}
	if(selectedOption==null && myValues[j].isDefault)
	{
		selectedOption=j+(isMandatory?0:1);
		defaultSelected=true;
		}
	
	var o=new Option(myValues[j].name,myValues[j].value,defaultSelected,null);
	myCombo.options[optionCounter]=o;
	optionCounter++;
}
if(selectedOption!=null)
	myCombo.selectedIndex=selectedOption;
}





function showDataTable(myTableDiv,tableId,mydata,metadata,maxRows)
{
	
tableDiv=document.getElementById(myTableDiv);
if(tableDiv.innerHTML=="")
{
var rowcount=mydata.length;
if(rowcount > maxRows)
	rowcount=maxRows;
const tabContainer= document.createElement("div");
tabContainer.classList.add("table-container");
const tabElem = document.createElement("table");
tabElem.classList.add("table");
tabElem.classList.add("is-bordered");
tabElem.classList.add("is-narrow");
 
tabElem.border="1";
tabElem.width="70%";
const rowElem = document.createElement("tr");
const thCap = document.createElement("th");
const textnode = document.createTextNode("Zeilennr.");
thCap.appendChild(textnode);
rowElem.appendChild(thCap);

for(var col=0;col < metadata.length;col++)
	{
	if(metadata[col].nr)
		{
		const thCap = document.createElement("th");
		const textnode = document.createTextNode(metadata[col].colcaption);
		thCap.appendChild(textnode);
		rowElem.appendChild(thCap);
		}
	}
tabElem.appendChild(rowElem);

//Variablennamen in Subheader
const rowElemSubHeader = document.createElement("tr");
const tdCap = document.createElement("td");
tdCap.style="font-family:monospace;font-size:smaller";
const textnodeSubHeader = document.createTextNode("(rownr)");
tdCap.appendChild(textnodeSubHeader);
rowElemSubHeader.appendChild(tdCap);

for(var col=0;col < metadata.length;col++)
	{
	if(metadata[col].nr)
		{
		const thCap = document.createElement("td");
		thCap.style="font-family:monospace;font-size:smaller";
		const textnode = document.createTextNode("("+col+".: "+metadata[col].colname+")");
		thCap.appendChild(textnode);
		rowElemSubHeader.appendChild(thCap);
		}
	}
tabElem.appendChild(rowElemSubHeader);

for(row=0;row<rowcount;row++)
{
	if(mydata[row])
	{
		const rowElem = document.createElement("tr");
		const tdCap = document.createElement("td");
		const textnode = document.createTextNode(row+1);
		tdCap.appendChild(textnode);
		rowElem.appendChild(tdCap);
		for(var col=0;col < metadata.length;col++)
			{
			if(metadata[col].nr)
				{
				const tdCap = document.createElement("td");
				const textnode = document.createTextNode(mydata[row][metadata[col].colname]);
				tdCap.appendChild(textnode);
				rowElem.appendChild(tdCap);
				}
			}
		tabElem.appendChild(rowElem);
	}
}

//Start Funktionen:
	var dimFunctions=[];
	var myFunction= new dimFunction(0,"Wort 1 ans Ende","switchWord1and2ff",false);
	dimFunctions[0]=myFunction;
	var myFunction= new dimFunction(1,"Nur Wort 1","justWord1",false);
	dimFunctions[1]=myFunction;
	var myFunction= new dimFunction(2,"Abkürzen (20)","abbreviate",false);
	dimFunctions[2]=myFunction;

		const rowElemFunc = document.createElement("tr");
		const tdCapFunc = document.createElement("td");
		const textnodeFunc = document.createTextNode("Funktion:");
		tdCapFunc.appendChild(textnodeFunc);
		rowElemFunc.appendChild(tdCapFunc);
		for(var col=0;col < metadata.length;col++)
			{
			if(metadata[col].nr)
				{
				const tdCapFunc = document.createElement("td");
				if(metadata[col].colcaption.trim() != "" && metadata[col].coltype==1) //String
				{
				//const textnode = document.createTextNode(data[row][metadata[col].colname]);
				const selElem = document.createElement("select");
				selElem.name=metadata[col].colname;
				selElem.id=metadata[col].colname;

		fillSelectOptions(selElem,dimFunctions,false);
				selElem.onchange= function () {  
				applyColFunction(myTableDiv,tableId,mydata,metadata,maxRows,this.name,this.value);
		};
					tdCapFunc.appendChild(selElem);
				}
				
				rowElemFunc.appendChild(tdCapFunc);
				}
			}
		tabElem.appendChild(rowElemFunc);
tabContainer.appendChild(tabElem);
tableDiv.appendChild(tabContainer);
}
else
	tableDiv.innerHTML=""; //reset table
}

function applyColFunction(myTableDiv,tableId,data,metadata,maxRows,colname,functionName)
{
	//first update chartModel:
	var myFunc=new dataTransformationCol(tableId,colname,functionName);
	myChartModel.dataTransformation.push(myFunc);

		for(var row=0;row < data.length;row++)
		{
			data[row][colname]=applyFunction(data[row][colname],functionName);
		}
		document.getElementById(myTableDiv).innerHTML="";
		showDataTable(myTableDiv,tableId,data,metadata,maxRows)
	
}


function showChartDiv(chartDivElem)
{
var myDiv=document.getElementById(chartDivElem);
	if(myDiv.style.display=="block")
		myDiv.style.display="none";
	else
		myDiv.style.display="block";
}





function makeAreaY(chartDivElem,selectionRs) {
	var categoryDim=document.getElementById("viz_dimension1").value;
	var measureDim=document.getElementById("viz_measure1").value;
	var marksArray=new Array();
	marksArray[0]=Plot.areaY(selectionRs,
    			    	{
    		          y: measureDim, 
    		          x: categoryDim
    		        });
	marksArray[1]=Plot.ruleY([0]);

	var options= getChartOptions(categoryDim,"",measureDim,marksArray,true);
	
	document.getElementById(chartDivElem).appendChild(Plot.plot(options));
	}
function makeDot(chartDivElem,selectionRs) {
	var categoryDim=document.getElementById("viz_dimension1").value;
	var measureDim=document.getElementById("viz_measure1").value;
	var marksArray=new Array();
	marksArray[0]=Plot.dot(selectionRs,
    			    	{
    		          y: measureDim, 
    		          x: categoryDim
    		        });
	marksArray[1]=Plot.ruleY([0]);
	//marksArray[2]=Plot.ruleX([0]);

	var options= getChartOptions(categoryDim,"",measureDim,marksArray,true);
	
	document.getElementById(chartDivElem).appendChild(Plot.plot(options));
	}
function makeLine(chartDivElem,selectionRs) {
	var categoryDim=document.getElementById("viz_dimension1").value;
	var measureDim=document.getElementById("viz_measure1").value;
	var marksArray=new Array();
	marksArray[0]=Plot.line(selectionRs,
    			    	{
    		          y: measureDim, 
    		          x: categoryDim,
    		          curve: "linear"
    		        });
	marksArray[1]=Plot.dot(selectionRs,
	    	{
          y: measureDim, 
          x: categoryDim
        });
	marksArray[2]=Plot.ruleY([0]);

	var options= getChartOptions(categoryDim,"",measureDim,marksArray,true);
	
	document.getElementById(chartDivElem).appendChild(Plot.plot(options));
	}


function showSrcCode(renderer)
{
var myChartDiv= document.getElementById("chartDiv2");
var mySrcDiv=document.getElementById("chartSVGsrc");
	if(mySrcDiv.style.display=="block")
		mySrcDiv.style.display="none";
	else
		mySrcDiv.style.display="block";

var numberOfChildNodes=myChartDiv.childNodes.length;
var svg_xml ="";

if(numberOfChildNodes>0)
{
	switch (renderer) {
		case "plot":
			for (var i=0;i<numberOfChildNodes;i++)
			{
				var myNode=myChartDiv.childNodes[i];
				var mySvg=myNode; 
			// Extract the data as SVG text string
				svg_xml += (new XMLSerializer).serializeToString(mySvg);
				}
		break;
		case "d3js":
		for (var i=0;i<numberOfChildNodes;i++)
			{
			var myNode=myChartDiv.childNodes[i];
			if(myNode.nodeName=="svg")
				{
			var mySvg=myNode; 
			// Extract the data as SVG text string
			svg_xml = (new XMLSerializer).serializeToString(mySvg);
				}
			}
			break;
		case "echarts":
		
		var myParentNode=myChartDiv.childNodes[0];
		var mySvgNode=null;
		if(myParentNode && myParentNode.childNodes.length>0)
		{
			 myNode=myParentNode.childNodes[0];
			if(myNode.nodeName=="svg")
				{
			
			// Extract the data as SVG text string
			svg_xml = (new XMLSerializer).serializeToString(myNode);
				}
			}
			break;
			default:
			document.getElementById("chartSrc").innerHTML="Unbekannter Renderer";
			break;
			}
		document.getElementById("chartSrc").innerHTML=svg_xml;
}
else
{
	document.getElementById("chartSrc").innerHTML="Kein Quellcode gefunden";
}


//document.getElementById("chartSVGsrc").style.visibility="visible";
/*
    const selection = window.getSelection();
    const range = document.createRange();
    range.selectNodeContents(ergtabelle);
    selection.removeAllRanges();
    selection.addRange(range);

      document.execCommand('copy');
      selection.removeAllRanges();

    alert("Angezeigte Tabelle wurde in die Zwischenablage kopiert.");
    */
}



function showChartModelCode()
{
var mySrcDiv=document.getElementById("chartModelsrc");
	if(mySrcDiv.style.display=="block")
		mySrcDiv.style.display="none";
	else
		mySrcDiv.style.display="block";
}

function showLoadMenu()
{
	mySelect=document.getElementById("viz_chart_id_load");
	fillVizChartSelectOptions(mySelect);
	var myLoadDiv=document.getElementById("loadMenu");
	if(myLoadDiv.style.display=="block")
		myLoadDiv.style.display="none";
	else
		myLoadDiv.style.display="block";
	
}

function loadVizChartDef()
{
	try {
		loadVizChartSrcCode(document.getElementById('viz_chart_id_load').value,document.getElementById('viz_chart_variant_load').value);

		loadChartModelCode('chartModelSrcCode','chartDiv');
		}
		catch(err) {
			console.log("Error when loading chart definition: "+err);
			}

}

function loadVizChartSrcCode(vizChartTid,chartVariant)
{
	var zs="Kein quellcode verfügbar";
	var caption=document.getElementById("chartName").value;
	var newRenderer=document.getElementById("fldVizRenderer").value;
	for(var i=0; i < vizCharts.length ; i++){
		if(vizCharts[i].tid==vizChartTid) 
		{
			zs=vizCharts[i].chartmodel.replace(/§/g,"\"");
			if(zs.indexOf("echarts_native")!=-1)
			{
				alert("Dies ist ein natives Diagramm und kann nicht im Assistenten bearbeitet werden.");
				zs="";
			}
			else
			{
				caption=vizCharts[i].caption;
				newRenderer=vizCharts[i].renderer;
				}
		}
	}
	var myCodeDiv= document.getElementById("chartModelSrcCode");
	document.getElementById("chartName").innerHTML=caption;
	document.getElementById("chartName").value=caption;
	document.getElementById("fldVizRenderer").value=newRenderer;
	myCodeDiv.innerHTML=zs;
	myCodeDiv.value=zs;
}
function showChartCode()
{
var mySrcDiv=document.getElementById("chartCodeTextAreaDiv");
	if(mySrcDiv.style.display=="block")
		mySrcDiv.style.display="none";
	else
		mySrcDiv.style.display="block";

}

function updateChartModelCode(myChartModel)
{
var myCodeDiv= document.getElementById("chartModelSrcCode");
var myJson ="";
var myPrettyJason="";
if(myChartModel)
{
	myJson=JSON.stringify(myChartModel);
	myPrettyJson=prettifyJson(myJson);
	myCodeDiv.innerHTML=myPrettyJson;
	myCodeDiv.value=myPrettyJson;
}
else
{
	myCodeDiv.innerHTML="Kein Quellcode gefunden";
}

} 

function loadChartModelCode(chartModelSrcCodeTextarea,chartDiv)
{

var mySrc=document.getElementById(chartModelSrcCodeTextarea);
var myJsonString =mySrc.value;

if(myJsonString!="")
{
	myChartModel=JSON.parse(myJsonString);
	if(myChartModel)
	{
		document.getElementById("vizElementCounter").value=myChartModel.chartElements.length;
		renderChart(chartDiv,myChartModel);
		fillChartElementListSelect(document.getElementById("chartElementID"),null);
	}
}
}

function loadNativeCode(nativeSrcCodeTextarea,chartDiv)
{

var mySrc=document.getElementById(nativeSrcCodeTextarea);
var chartDivElem=document.getElementById(chartDiv);
var myJsonString =mySrc.value;

if(myJsonString!="")
{
	myOption=JSON.parse(myJsonString);
	var myChart = echarts.init(chartDivElem,null, { renderer: 'svg', locale: 'DE'});
	myChart.setOption(myOption);

}
}


function copySrcCode(mydiv)
{
var ergtabelle=document.getElementById(mydiv);
    const selection = window.getSelection();
    const range = document.createRange();
    range.selectNodeContents(ergtabelle);
    selection.removeAllRanges();
    selection.addRange(range);

      document.execCommand('copy');
      selection.removeAllRanges();
}

function showVizChartSaveDialog(myDiv)
{
var myLoadSaveDialog= document.getElementById(myDiv);
	if(myLoadSaveDialog.style.display=="block")
		myLoadSaveDialog.style.display="none";
	else
		myLoadSaveDialog.style.display="block";
	mySelect=document.getElementById("viz_chart_id");
	var currentSelection=document.getElementById("viz_chart_id_load").value;
	fillVizChartSelectOptions(mySelect,currentSelection);
}

function fillVizChartSelectOptions(mySelect,currentSelection)
{
	var zs="";
	for(var i=0; i < vizCharts.length ; i++){
		if(vizCharts[i].maskeninfo_id==currentMaskeninfoId 
		&& document.getElementById("fldVizRenderer").value==vizCharts[i].renderer)
		{
			zs+="<option value=\""+vizCharts[i].tid+"\"";
			if(currentSelection==vizCharts[i].tid)
				{
				zs+=" selected=\"selected\"";
				}
			zs+=">"+vizCharts[i].caption +"</option>";
		}
		}
		zs+="<option value=\"\">Neue Grafik</option>";
	mySelect.innerHTML=zs;
}


function openVizChartDBForm(tid)
{
	if(tid==null || tid=="")
	{
	neu=window.open("../edit/viz/viz_chart_bearbeiten.jsp?renderer="+document.getElementById("fldVizRenderer").value,"_blank","directories=no,location=no,menubar=no,scrollbars=yes,resizable=yes,toolbar=no,width=800,height=600");
		}
	else
	{
	var chartObj=vizCharts.find(ch => ch.tid == tid); 
	var renderer_id= chartObj.renderer_id;
	neu=window.open("../edit/viz/viz_chart_bearbeiten.jsp?tid="+tid +"&renderer_id="+renderer_id,"_blank","directories=no,location=no,menubar=no,scrollbars=yes,resizable=yes,toolbar=no,width=800,height=600");
	}
	return false;
}
function showVizNavTab(nr)
{
	
for (let i = 1; i < 4; i++) {
	var divName="tab-"+i;
	//alert(divName);
	tabDivElem=document.getElementById(divName);
	if(i==nr)
		tabDivElem.style.display="block";
	else
		tabDivElem.style.display="none";

}
}




function makeSunburstD3(myCommonChartProperties,svg,data,metaData,chartElem)
{
	var sorted = d3.sort(data, d => d.dimension1,d => d.dimension2, d => d.measure1);
//var group = d3.group(sorted, d => d.sos_stg_aggr_sem_rueck_beur_ein_str);
//console.log(group);

 
  
 var group = d3.group(sorted, d => d.dimension1,d => d.dimension2, d => d.measure1 );
 var hierarchy = d3.hierarchy(group);
 
 var level1count=hierarchy.children.length;
 console.log("level1count:"+level1count);
 var data_str = "{\"name\":\"root\",\"children\":[";
 
for(var i=0; i < level1count ; i++){
console.log("Zeile "+i+ ":" + hierarchy.children[i].data[0]);
data_str+="{\"name\":\""+hierarchy.children[i].data[0]+"\",\"children\":[";
var level2count=hierarchy.children[i].children.length;
for(var j=0; j < level2count ; j++){
console.log("unterZeile "+j+ ":" + hierarchy.children[i].children[j].data[0]);
data_str+="{\"name\":\""+hierarchy.children[i].children[j].data[0]+"\",\"children\":[";

/*var level3count=hierarchy.children[i].children[j].children.length;
console.log("level3count: "+level3count);

for(var k=0; k < level3count ; k++){
console.log("unterUnterZeile "+k+ ":" + hierarchy.children[i].children[j].children[k].data[0]);
data_str+="{\"name\":\""+hierarchy.children[i].children[j].children[k].data[0]+"\",\"value\":"+hierarchy.children[i].children[j].children[k].children[0].data[0] +"}";
if(k < level3count -1)
	data_str+=",";

}
*/
data_str+="]}";
if(j < level2count -1)
	data_str+=",";
}
data_str+="]}";
if(i < level1count -1)
	data_str+=",";
//console.log("Zeile "+i+ ":" + hierarchy.children[i].children[0].data);
}
data_str+="]}"
console.log(data_str);
var dataHierarchy=JSON.parse(data_str);

return renderSunburst(dataHierarchy,svg);
}
function renderSunburst(data,svg) {
  // Specify the chart’s dimensions.
  const width = 928;
  const height = width;
  const radius = width / 6;

  // Create the color scale.
  const color = d3.scaleOrdinal(d3.quantize(d3.interpolateRainbow, data.children.length + 1));

  // Compute the layout.
  const hierarchy = d3.hierarchy(data)
      .sum(d => d.value)
      .sort((a, b) => b.value - a.value);
  const root = d3.partition()
      .size([2 * Math.PI, hierarchy.height + 1])
    (hierarchy);
  root.each(d => d.current = d);

  // Create the arc generator.
  const arc = d3.arc()
      .startAngle(d => d.x0)
      .endAngle(d => d.x1)
      .padAngle(d => Math.min((d.x1 - d.x0) / 2, 0.005))
      .padRadius(radius * 1.5)
      .innerRadius(d => d.y0 * radius)
      .outerRadius(d => Math.max(d.y0 * radius, d.y1 * radius - 1))

  // Create the SVG container.
   // Append the arcs.
  const path = svg.append("g")
    .selectAll("path")
    .data(root.descendants().slice(1))
    .join("path")
      .attr("fill", d => { while (d.depth > 1) d = d.parent; return color(d.data.name); })
      .attr("fill-opacity", d => arcVisible(d.current) ? (d.children ? 0.6 : 0.4) : 0)
      .attr("pointer-events", d => arcVisible(d.current) ? "auto" : "none")

      .attr("d", d => arc(d.current));

  // Make them clickable if they have children.
  path.filter(d => d.children)
      .style("cursor", "pointer")
      .on("click", clicked);

  const format = d3.format(",d");
  path.append("title")
      .text(d => `${d.ancestors().map(d => d.data.name).reverse().join("/")}\n${format(d.value)}`);

  const label = svg.append("g")
      .attr("pointer-events", "none")
      .attr("text-anchor", "middle")
      .style("user-select", "none")
    .selectAll("text")
    .data(root.descendants().slice(1))
    .join("text")
      .attr("dy", "0.35em")
      .attr("fill-opacity", d => +labelVisible(d.current))
      .attr("transform", d => labelTransform(d.current))
      .text(d => d.data.name);

  const parent = svg.append("circle")
      .datum(root)
      .attr("r", radius)
      .attr("fill", "none")
      .attr("pointer-events", "all")
      .on("click", clicked);

  // Handle zoom on click.
  function clicked(event, p) {
    parent.datum(p.parent || root);

    root.each(d => d.target = {
      x0: Math.max(0, Math.min(1, (d.x0 - p.x0) / (p.x1 - p.x0))) * 2 * Math.PI,
      x1: Math.max(0, Math.min(1, (d.x1 - p.x0) / (p.x1 - p.x0))) * 2 * Math.PI,
      y0: Math.max(0, d.y0 - p.depth),
      y1: Math.max(0, d.y1 - p.depth)
    });

    const t = svg.transition().duration(750);

    // Transition the data on all arcs, even the ones that aren’t visible,
    // so that if this transition is interrupted, entering arcs will start
    // the next transition from the desired position.
    path.transition(t)
        .tween("data", d => {
          const i = d3.interpolate(d.current, d.target);
          return t => d.current = i(t);
        })
      .filter(function(d) {
        return +this.getAttribute("fill-opacity") || arcVisible(d.target);
      })
        .attr("fill-opacity", d => arcVisible(d.target) ? (d.children ? 0.6 : 0.4) : 0)
        .attr("pointer-events", d => arcVisible(d.target) ? "auto" : "none") 

        .attrTween("d", d => () => arc(d.current));

    label.filter(function(d) {
        return +this.getAttribute("fill-opacity") || labelVisible(d.target);
      }).transition(t)
        .attr("fill-opacity", d => +labelVisible(d.target))
        .attrTween("transform", d => () => labelTransform(d.current));
  }
  
  function arcVisible(d) {
    return d.y1 <= 3 && d.y0 >= 1 && d.x1 > d.x0;
  }

  function labelVisible(d) {
    return d.y1 <= 3 && d.y0 >= 1 && (d.y1 - d.y0) * (d.x1 - d.x0) > 0.03;
  }

  function labelTransform(d) {
    const x = (d.x0 + d.x1) / 2 * 180 / Math.PI;
    const y = (d.y0 + d.y1) / 2 * radius;
    return `rotate(${x - 90}) translate(${y},0) rotate(${x < 180 ? 0 : 180})`;
  }

  return svg.node();

}


function openModalImage(ergebniselementOrdnr)
{
	var myModalCard=document.getElementById("modalCard"+ergebniselementOrdnr);
	myModalCard.classList.add('is-active');
}
function closeModalImage(ergebniselementOrdnr)
{
	var myModalCard=document.getElementById("modalCard"+ergebniselementOrdnr);
	myModalCard.classList.remove('is-active');
}

function exportDataTable(rs,rsMetaData)
{
	myRs=fillEchartsDataSetSimpleCopy(rs,rsMetaData);
	console.log(JSON.stringify(myRs));
}


//generic tree
function sxTreeNode(id,
caption,
parent,
hasChildren,
explanation,
inputPreCaption,
inputPreCaptionPreviousValue,
inputPostCaption,
inputPostCaptionPreviousValue,
nodeHrefUrl,
nodeHrefTarget,
css_class,
sortnr,
searchString
)
{
this.id=id ;
this.caption=caption ;
this.parent=parent ;
this.hasChildren=hasChildren;
this.explanation=explanation ;
this.inputPreCaption=inputPreCaption ;
this.inputPreCaptionPreviousValue=inputPreCaptionPreviousValue ;
this.inputPostCaption=inputPostCaption ;
this.inputPostCaptionPreviousValue= inputPostCaptionPreviousValue;
this.nodeHrefUrl=nodeHrefUrl ;
this.nodeHrefTarget=nodeHrefTarget ;
this.css_class= css_class;
this.sortnr= sortnr;
this.searchString=searchString;
this.renderSxNode = function (treeArray) {
var zs="<li class='sichtentreeLI'>";
var nodeContentHtml=this.caption;
if(this.explanation !="")
{
 nodeContentHtml="<span class='labelNormal has-tooltip-bottom' data-tooltip='"+this.explanation+"'>"+this.caption+"</span>";
 }
if(this.inputPostCaption)
	{
		nodeContentHtml+=this.inputPostCaption;
	}
if(this.hasChildren)
		{
		zs+="<span class='sichtentreeCaret' id='sichtentreeCaret_"+this.id+"'";
		zs+="onClick=\"toggleChildNodes('"+this.id.trim()+"',this)\">";
		zs+="</span>&nbsp;";
		zs +="<span style='margin-left:10px'>&nbsp;</span>";
		zs +="<span>"+nodeContentHtml+"</span>\n";

		zs+= loadChildNodes(treeArray,this);
		}
		else
		{
		zs+="<span style='margin-left:15px'></span>";
		zs +="<span>"+nodeContentHtml+"</span>\n";
		
		}
		zs +="</li>";
	return zs;
}
}

function loadChildNodes(tree,myTreeNode)
{
var zs="";
for(var j=0;j < tree.length;j++)
{
	var node=tree[j];
	if(node.parent==myTreeNode.id)
	{
		zs +=node.renderSxNode(tree);
	}
}
if(zs !="")
{
	zs="<ul class='sichtentreeChildUL sichtentreeNested' style='margin-left:10px' id='childOf"+myTreeNode.id+"'>"+zs+"</ul>";
}
return zs;
}

function toggleChildNodes(nodeId,spanElem)
{
//spanElem.parentElement.querySelector(".sichtentreeNested").classList.toggle("sichtentreeActive");
var childUlId="childOf"+nodeId;
spanElem.classList.toggle("sichtentreeCaret-down");

if(document.getElementById(childUlId))
{
	//Kind existiert bereits, wird nur unsichtbar:
	document.getElementById(childUlId).classList.toggle("sichtentreeNested");
}
}

