-- XML-generiertes SQL-Script für psql--


select now(),'Creating tables'
from xdummy;



select now(),'Erzeuge Tabelle viz_type'
from xdummy;

create table viz_type(
	tid SERIAL  not null, 
uniquename VARCHAR(255)  not null, 
caption VARCHAR(255) , 
renderer_id INTEGER , 
srcpath VARCHAR(255) , 
method VARCHAR(255) , 
orientation CHAR(1) , 
explanation TEXT , 
preview TEXT , 
	constraint viz_type_pk primary key (tid)

) 
;



comment on table viz_type is 'Schlüsseltabelle für Arten von Visualisierungen';

comment on column viz_type.tid is 'tid';

comment on column viz_type.uniquename is 'Schlüssel';

comment on column viz_type.caption is 'Bezeichnung';

comment on column viz_type.renderer_id is 'Renderer';

comment on column viz_type.srcpath is 'Pfad zum Quellcode';

comment on column viz_type.method is 'Methode';

comment on column viz_type.orientation is 'Orientierung';

comment on column viz_type.explanation is 'Erläuterung';

comment on column viz_type.preview is 'Muster';


select now(),'Tabelle viz_type erzeugt'
from xdummy;



select now(),'Erzeuge Tabelle viz_property_input_type'
from xdummy;

create table viz_property_input_type(
	tid SERIAL  not null, 
uniquename VARCHAR(255)  not null, 
caption VARCHAR(255) , 
	constraint viz_property_input_type_pk primary key (tid)

) 
;



comment on table viz_property_input_type is 'Schlüsseltabelle für Dialogtypen von Visualisierungseigenschaften';

comment on column viz_property_input_type.tid is 'tid';

comment on column viz_property_input_type.uniquename is 'Unique Name';

comment on column viz_property_input_type.caption is 'Bezeichnung';


select now(),'Tabelle viz_property_input_type erzeugt'
from xdummy;



select now(),'Erzeuge Tabelle viz_property_group'
from xdummy;

create table viz_property_group(
	tid SERIAL  not null, 
uniquename VARCHAR(255)  not null, 
caption VARCHAR(255) , 
sortnr INTEGER , 
	constraint viz_property_group_pk primary key (tid)

) 
;



comment on table viz_property_group is 'Schlüsseltabelle für Gruppen von Visualisierungseigenschaften';

comment on column viz_property_group.tid is 'tid';

comment on column viz_property_group.uniquename is 'Unique Name';

comment on column viz_property_group.caption is 'Bezeichnung';

comment on column viz_property_group.sortnr is 'Sortiernummer';


select now(),'Tabelle viz_property_group erzeugt'
from xdummy;



select now(),'Erzeuge Tabelle viz_renderer'
from xdummy;

create table viz_renderer(
	tid SERIAL  not null, 
uniquename VARCHAR(255)  not null, 
caption VARCHAR(255) , 
	constraint viz_renderer_pk primary key (tid)

) 
;



comment on table viz_renderer is 'Schlüsseltabelle für Renderer von Visualisierungen';

comment on column viz_renderer.tid is 'tid';

comment on column viz_renderer.uniquename is 'Unique Name';

comment on column viz_renderer.caption is 'Bezeichnung';


select now(),'Tabelle viz_renderer erzeugt'
from xdummy;



select now(),'Erzeuge Tabelle viz_chart'
from xdummy;

create table viz_chart(
	tid SERIAL  not null, 
uniquename VARCHAR(255)  not null, 
caption VARCHAR(255) , 
description TEXT , 
chartmodel TEXT , 
preview_svg TEXT , 
userinfo_id INTEGER , 
creation_date DATE  default today(), 
update_date DATE  default today(), 
maskeninfo_id INTEGER , 
mask_params TEXT , 
renderer_id INTEGER  not null, 
chartmodel_miniature TEXT , 
chart_position CHAR(10) , 
chart_active SMALLINT  default 1 , 
chart_width INTEGER  default 600 , 
chart_height INTEGER  default 400 , 
chart_miniature_width INTEGER  default 200 , 
chart_miniature_height INTEGER  default 100 , 
is_custom SMALLINT  default 1 , 
	constraint viz_chart_pk primary key (tid)

) 
;



comment on table viz_chart is 'Diagrammentwürfe';

comment on column viz_chart.tid is 'tid';

comment on column viz_chart.uniquename is 'Unique Name';

comment on column viz_chart.caption is 'Bezeichnung';

comment on column viz_chart.description is 'Beschreibung';

comment on column viz_chart.chartmodel is 'Quellcode des Diagramms';

comment on column viz_chart.preview_svg is 'Vorschau (SVG)';

comment on column viz_chart.userinfo_id is 'Angelegt von';

comment on column viz_chart.creation_date is 'Angelegt (Datum)';

comment on column viz_chart.update_date is 'Letzte Änderung (Datum)';

comment on column viz_chart.maskeninfo_id is 'Maske';

comment on column viz_chart.mask_params is 'Maskenparameter';

comment on column viz_chart.renderer_id is 'Renderer';

comment on column viz_chart.chartmodel_miniature is 'Quellcode des Diagramms (Miniatur)';

comment on column viz_chart.chart_position is 'Position des Diagramms';

comment on column viz_chart.chart_active is 'Grafik aktiv';

comment on column viz_chart.chart_width is 'Breite des Diagramms';

comment on column viz_chart.chart_height is 'Höhe des Diagramms';

comment on column viz_chart.chart_miniature_width is 'Breite der Diagramm-Miniatur';

comment on column viz_chart.chart_miniature_height is 'Höhe der Diagramm-Miniatur';

comment on column viz_chart.is_custom is 'Grafik der Hochschule';


select now(),'Erzeuge Index ix_viz_chart'
from xdummy;

create  unique  index ix_viz_chart on viz_chart (uniquename );


select now(),'Tabelle viz_chart erzeugt'
from xdummy;



select now(),'Erzeuge Tabelle viz_type_property'
from xdummy;

create table viz_type_property(
	tid SERIAL  not null, 
viz_type_id INTEGER , 
viz_property_id INTEGER , 
is_mandatory SMALLINT  default 0 , 
sortnr SMALLINT  default 0 , 
	constraint viz_type_property_pkey primary key (tid)

) 
;




select now(),'Tabelle viz_type_property erzeugt'
from xdummy;



select now(),'Erzeuge Tabelle viz_property'
from xdummy;

create table viz_property(
	tid SERIAL  not null, 
caption VARCHAR(255) , 
prop_uniquename VARCHAR(255) , 
prop_default VARCHAR(255) , 
prop_unit VARCHAR(255) , 
is_generic SMALLINT  default 1 , 
static_values TEXT , 
is_mandatory SMALLINT  default 0 , 
input_type_id INTEGER  default 1 , 
property_group_id INTEGER , 
explanation TEXT , 
sortnr INTEGER , 
range_from INTEGER , 
range_to INTEGER , 
prop_value_type VARCHAR(255)  default 'string' , 
	constraint viz_property_pk primary key (tid)

) 
;



comment on table viz_property is 'Schlüsseltabelle für Eigenschaften von Visualisieren';

comment on column viz_property.tid is 'tid';

comment on column viz_property.caption is 'Bezeichnung';

comment on column viz_property.prop_uniquename is 'Schlüssel';

comment on column viz_property.prop_default is 'Defaultwert';

comment on column viz_property.prop_unit is 'Einheit';

comment on column viz_property.is_generic is 'Generische Eigenschaft';

comment on column viz_property.static_values is 'Wertebereich (statisch)';

comment on column viz_property.is_mandatory is 'Pflichteingabe';

comment on column viz_property.input_type_id is 'Eingabedialog';

comment on column viz_property.property_group_id is 'Art der Eigenschaft';

comment on column viz_property.explanation is 'Erläuterung';

comment on column viz_property.sortnr is 'Sortiernummer';

comment on column viz_property.range_from is 'Minimalwert';

comment on column viz_property.range_to is 'Maximalwert';

comment on column viz_property.prop_value_type is 'Datentyp';


select now(),'Tabelle viz_property erzeugt'
from xdummy;



select now(),'Erzeuge Tabelle viz_property_tree_node'
from xdummy;

create table viz_property_tree_node(
	tid SERIAL  not null, 
renderer_id INTEGER , 
property_id INTEGER , 
parent_property_id INTEGER , 
sortnr SMALLINT  default 0 , 
is_mandatory SMALLINT  default 0 , 
	constraint viz_property_tree_node_pk primary key (tid)

) 
;



comment on table viz_property_tree_node is 'Schlüsseltabelle für Hierarchien von Eigenschaften von Visualisierungstypen';

comment on column viz_property_tree_node.tid is 'tid';

comment on column viz_property_tree_node.renderer_id is 'Renderer';

comment on column viz_property_tree_node.property_id is 'Eigenschaft der Visualisierung';

comment on column viz_property_tree_node.parent_property_id is 'Eigenschafts-Elternelement der Visualisierung';

comment on column viz_property_tree_node.sortnr is 'Sortiernr.';

comment on column viz_property_tree_node.is_mandatory is 'Pflichteingabe';


select now(),'Tabelle viz_property_tree_node erzeugt'
from xdummy;



select now(),'Erzeuge Tabelle viz_property_renderer'
from xdummy;

create table viz_property_renderer(
	tid SERIAL  not null, 
renderer_id INTEGER  not null, 
property_id INTEGER  not null, 
variable_name VARCHAR(255) , 
	constraint viz_property_renderer_pk primary key (tid)

) 
;



comment on table viz_property_renderer is 'Schlüsseltabelle für Renderer von Visualisierungseigenschaften';

comment on column viz_property_renderer.tid is 'tid';

comment on column viz_property_renderer.renderer_id is 'Renderer';

comment on column viz_property_renderer.property_id is 'Eigenschaft der Visualisierung';

comment on column viz_property_renderer.variable_name is 'Variablenname';


select now(),'Tabelle viz_property_renderer erzeugt'
from xdummy;



select now(),'Erzeuge Tabelle viz_property_group_renderer'
from xdummy;

create table viz_property_group_renderer(
	tid SERIAL  not null, 
renderer_id INTEGER  not null, 
property_group_id INTEGER  not null, 
variable_name VARCHAR(255) , 
	constraint viz_property_group_renderer_pk primary key (tid)

) 
;



comment on table viz_property_group_renderer is 'Schlüsseltabelle für Renderer von Gruppen von Visualisierungseigenschaften';

comment on column viz_property_group_renderer.tid is 'tid';

comment on column viz_property_group_renderer.renderer_id is 'Renderer';

comment on column viz_property_group_renderer.property_group_id is 'Gruppe der Visualisierung';

comment on column viz_property_group_renderer.variable_name is 'Variablenname';


select now(),'Tabelle viz_property_group_renderer erzeugt'
from xdummy;



select now(),'Erzeuge Tabelle viz_staat_isocode'
from xdummy;

create table viz_staat_isocode(
	name VARCHAR(4000) , 
iso3 VARCHAR(3) , 
kurzbezeichnung VARCHAR(3) , 
astat INTEGER , 
	constraint viz_staat_isocode_pk primary key (astat)

) 
;




select now(),'Tabelle viz_staat_isocode erzeugt'
from xdummy;



select now(),'Erzeuge Tabelle viz_colorscheme'
from xdummy;

create table viz_colorscheme(
	tid SERIAL  not null, 
uniquename VARCHAR(255)  not null, 
caption VARCHAR(255) , 
is_custom SMALLINT  default 1 , 
specifier VARCHAR(255) , 
sortnr SMALLINT  default 0 , 
colorscheme_active SMALLINT  default 1 , 
	constraint viz_colorscheme_pk primary key (tid)

) 
;



comment on table viz_colorscheme is 'Schlüsseltabelle für Farbpaletten';

comment on column viz_colorscheme.tid is 'tid';

comment on column viz_colorscheme.uniquename is 'Schlüssel';

comment on column viz_colorscheme.caption is 'Bezeichnung';

comment on column viz_colorscheme.is_custom is 'Palette der Hochschule';

comment on column viz_colorscheme.specifier is 'Quelle (komprimiert)';

comment on column viz_colorscheme.sortnr is 'Sortiernr.';

comment on column viz_colorscheme.colorscheme_active is 'Palette aktiv';


select now(),'Erzeuge Index ix_viz_colorscheme'
from xdummy;

create  unique  index ix_viz_colorscheme on viz_colorscheme (uniquename );


select now(),'Tabelle viz_colorscheme erzeugt'
from xdummy;



select now(),'Erzeuge Tabelle viz_colorscheme_element'
from xdummy;

create table viz_colorscheme_element(
	tid SERIAL  not null, 
colorscheme_id INTEGER  not null, 
colorcode VARCHAR(255)  not null, 
target_uniquename VARCHAR(255) , 
sortnr SMALLINT  default 0 , 
	constraint viz_colorscheme_element_pk primary key (tid)

) 
;



comment on table viz_colorscheme_element is 'Zuordnung einzelner Farben zu einer Palette ';

comment on column viz_colorscheme_element.tid is 'tid';

comment on column viz_colorscheme_element.colorscheme_id is 'Farbpalette';

comment on column viz_colorscheme_element.colorcode is 'Farbcode';

comment on column viz_colorscheme_element.target_uniquename is 'Ziel-Schlüssel';

comment on column viz_colorscheme_element.sortnr is 'Sortiernr.';


select now(),'Tabelle viz_colorscheme_element erzeugt'
from xdummy;



select now(),'Erzeuge Tabelle viz_dashboard'
from xdummy;

create table viz_dashboard(
	tid SERIAL  not null, 
uniquename VARCHAR(255)  not null, 
caption VARCHAR(255) , 
maskeninfo_id INTEGER , 
booklet_stylesheet VARCHAR(255) , 
gridtitle_felderinfo_id INTEGER , 
	constraint viz_dashboard_pk primary key (tid)

) 
;



comment on table viz_dashboard is 'Dashboard Metadaten';

comment on column viz_dashboard.tid is 'tid';

comment on column viz_dashboard.uniquename is 'Unique Name';

comment on column viz_dashboard.caption is 'Bezeichnung';

comment on column viz_dashboard.maskeninfo_id is 'Maske';

comment on column viz_dashboard.booklet_stylesheet is 'Stylesheet für Druckversion';

comment on column viz_dashboard.gridtitle_felderinfo_id is 'Maskenfeld für Titelelement';


select now(),'Erzeuge Index ix_viz_dashboard'
from xdummy;

create  unique  index ix_viz_dashboard on viz_dashboard (uniquename );


select now(),'Tabelle viz_dashboard erzeugt'
from xdummy;



select now(),'Erzeuge Tabelle viz_dashboard_tab'
from xdummy;

create table viz_dashboard_tab(
	tid SERIAL  not null, 
dashboard_id INTEGER  not null, 
caption VARCHAR(255) , 
maskeninfo_id INTEGER , 
sortnr SMALLINT  default 0 , 
select_clause VARCHAR(255) , 
fact_table VARCHAR(255) , 
where_clause TEXT , 
optional_filter_name VARCHAR(255) , 
optional_filter_value VARCHAR(255) , 
booklet_stylesheet VARCHAR(255) , 
	constraint viz_dashboard_tab_pk primary key (tid)

) 
;



comment on table viz_dashboard_tab is 'Dashboard-Tab Metadaten';

comment on column viz_dashboard_tab.tid is 'tid';

comment on column viz_dashboard_tab.dashboard_id is 'Dashboard';

comment on column viz_dashboard_tab.caption is 'Bezeichnung';

comment on column viz_dashboard_tab.maskeninfo_id is 'Maske';

comment on column viz_dashboard_tab.sortnr is 'Sortiernr.';

comment on column viz_dashboard_tab.select_clause is 'SQL der Kennzahl';

comment on column viz_dashboard_tab.fact_table is 'Quelltabelle der Kennzahl';

comment on column viz_dashboard_tab.where_clause is 'SQL-Filter der Kennzahl';

comment on column viz_dashboard_tab.optional_filter_name is 'Optionaler Filter der Kennzahl';

comment on column viz_dashboard_tab.optional_filter_value is 'Optionaler Filterwert der Kennzahl';

comment on column viz_dashboard_tab.booklet_stylesheet is 'Stylesheet für Druckversion';


select now(),'Erzeuge Index ix_viz_dashboard'
from xdummy;

create  unique  index ix_viz_dashboard on viz_dashboard_tab (uniquename );


select now(),'Tabelle viz_dashboard_tab erzeugt'
from xdummy;



select now(),'Erzeuge View viz_property_dimension_measure'
from xdummy;

create view viz_property_dimension_measure(
	tid, 
caption, 
prop_uniquename, 
prop_default, 
prop_unit, 
is_generic, 
static_values, 
is_mandatory, 
input_type_id, 
property_group_id, 
explanation, 
sortnr, 
range_from, 
range_to) as
	
	SELECT P.tid,
P.caption,
P.prop_uniquename,
P.prop_default,
P.prop_unit,
P.is_generic,
P.static_values,
P.is_mandatory,
P.input_type_id,
P.property_group_id,
P.explanation,
P.sortnr,
P.range_from,
P.range_to
FROM viz_property P, viz_property_group G
where P.property_group_id=G.tid
and G.uniquename in ('CATEGORY','MEASURE')
 
 ;
	--Install-Schritt:  Füllen der Modul-Tabellen


select now(),'SQL-Ausdruck create table tmp_repository(  tid SERIAL  not null, id CHAR(200)  not null, content TEXT , caption CHAR(200) , comment TEXT , version SMALLINT , art CHAR(200) , art2 CHAR(200) , art3 CHAR(200) , sachgebiete_id INTEGER , sort1 INTEGER , sort2 INTEGER , sort3 INTEGER , geaendert_am DATE , aktiv smallint , gueltig_seit DATE , gueltig_bis DATE ); ausführen'
from xdummy;

create table tmp_repository(  tid SERIAL  not null, id CHAR(200)  not null, content TEXT , caption CHAR(200) , comment TEXT , version SMALLINT , art CHAR(200) , art2 CHAR(200) , art3 CHAR(200) , sachgebiete_id INTEGER , sort1 INTEGER , sort2 INTEGER , sort3 INTEGER , geaendert_am DATE , aktiv smallint , gueltig_seit DATE , gueltig_bis DATE );
		

select now(),'SQL-Ausdruck create table tmp_templates(tid integer,  id char(200)  not null,   content text  not null,   description char(200) ,   comment char(200) ,   version integer  default 1   ) ; ausführen'
from xdummy;

create table tmp_templates(tid integer,  id char(200)  not null,   content text  not null,   description char(200) ,   comment char(200) ,   version integer  default 1   ) ;
		

select now(),'SQL-Ausdruck create table tmp_viz_dashboard(  tid SERIAL  not null,  uniquename VARCHAR(255)  not null,  caption VARCHAR(255) ,  maskeninfo_id INTEGER ,  booklet_stylesheet VARCHAR(255) , gridtitle_felderinfo_id integer )  ; ausführen'
from xdummy;

create table tmp_viz_dashboard(  tid SERIAL  not null,  uniquename VARCHAR(255)  not null,  caption VARCHAR(255) ,  maskeninfo_id INTEGER ,  booklet_stylesheet VARCHAR(255) , gridtitle_felderinfo_id integer )  ;
		

select now(),'SQL-Ausdruck create table tmp_viz_dashboard_tab(  tid SERIAL  not null,  dashboard_id INTEGER  not null,  caption VARCHAR(255) ,  maskeninfo_id INTEGER ,  sortnr SMALLINT  default 0 ,  select_clause VARCHAR(255) ,  fact_table VARCHAR(255) ,  where_clause TEXT ,  optional_filter_name VARCHAR(255) ,  optional_filter_value VARCHAR(255) ,  booklet_stylesheet VARCHAR(255)  )  ; ausführen'
from xdummy;

create table tmp_viz_dashboard_tab(  tid SERIAL  not null,  dashboard_id INTEGER  not null,  caption VARCHAR(255) ,  maskeninfo_id INTEGER ,  sortnr SMALLINT  default 0 ,  select_clause VARCHAR(255) ,  fact_table VARCHAR(255) ,  where_clause TEXT ,  optional_filter_name VARCHAR(255) ,  optional_filter_value VARCHAR(255) ,  booklet_stylesheet VARCHAR(255)  )  ;
		

select now(),'Lade Tabelle tmp_repository'
from xdummy;

\! sx_auto_upload_table.x tmp_repository $VIZ_PFAD/schluesseltabellen/sx_repository.unl


select now(),'Lade Tabelle tmp_repository'
from xdummy;

\! sx_upload_records.x tmp_repository $VIZ_PFAD/schluesseltabellen/sx_repository_customxmladd.unl


select now(),'Lade Tabelle tmp_templates'
from xdummy;

\! sx_auto_upload_table.x tmp_templates $VIZ_PFAD/schluesseltabellen/fm_templates.unl


select now(),'Lade Tabelle tmp_viz_dashboard'
from xdummy;

\! sx_auto_upload_table.x tmp_viz_dashboard $VIZ_PFAD/schluesseltabellen/viz_dashboard.unl


select now(),'Lade Tabelle tmp_viz_dashboard_tab'
from xdummy;

\! sx_auto_upload_table.x tmp_viz_dashboard_tab $VIZ_PFAD/schluesseltabellen/viz_dashboard_tab.unl


select now(),'Lade Tabelle viz_type'
from xdummy;

\! sx_auto_upload_table.x viz_type $VIZ_PFAD/schluesseltabellen/viz_type.unl


select now(),'Lade Tabelle viz_property'
from xdummy;

\! sx_auto_upload_table.x viz_property $VIZ_PFAD/schluesseltabellen/viz_property.unl


select now(),'Lade Tabelle viz_property_input_type'
from xdummy;

\! sx_auto_upload_table.x viz_property_input_type $VIZ_PFAD/schluesseltabellen/viz_property_input_type.unl


select now(),'Lade Tabelle viz_property_group'
from xdummy;

\! sx_auto_upload_table.x viz_property_group $VIZ_PFAD/schluesseltabellen/viz_property_group.unl


select now(),'Lade Tabelle viz_renderer'
from xdummy;

\! sx_auto_upload_table.x viz_renderer $VIZ_PFAD/schluesseltabellen/viz_renderer.unl


select now(),'Lade Tabelle viz_property_renderer'
from xdummy;

\! sx_auto_upload_table.x viz_property_renderer $VIZ_PFAD/schluesseltabellen/viz_property_renderer.unl


select now(),'Lade Tabelle viz_property_group_renderer'
from xdummy;

\! sx_auto_upload_table.x viz_property_group_renderer $VIZ_PFAD/schluesseltabellen/viz_property_group_renderer.unl


select now(),'Lade Tabelle viz_type_property'
from xdummy;

\! sx_auto_upload_table.x viz_type_property $VIZ_PFAD/schluesseltabellen/viz_type_property.unl


select now(),'Lade Tabelle viz_chart'
from xdummy;

\! sx_auto_upload_table.x viz_chart $VIZ_PFAD/schluesseltabellen/viz_chart.unl


select now(),'Lade Tabelle viz_staat_isocode'
from xdummy;

\! sx_auto_upload_table.x viz_staat_isocode $VIZ_PFAD/schluesseltabellen/viz_staat_isocode.unl


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/sx_repository_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/sx_repository_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/fm_templates_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/fm_templates_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/viz_dashboard_tab_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/viz_dashboard_tab_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/sachgebiete_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/sachgebiete_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/viz_colorscheme_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/viz_colorscheme_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/konstanten_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/konstanten_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/sx_stylesheets_einfuegen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/sx_stylesheets_einfuegen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/macro_masken_bez_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/macro_masken_bez_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/viz_properties_plot_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/viz_properties_plot_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/viz_properties_plot_line_bar_boxplot_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/viz_properties_plot_line_bar_boxplot_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/viz_properties_echarts_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/viz_properties_echarts_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/viz_properties_echarts_line_bar_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/viz_properties_echarts_line_bar_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/viz_properties_echarts_line_bar_series_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/viz_properties_echarts_line_bar_series_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/viz_properties_echarts_pie_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/viz_properties_echarts_pie_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/viz_properties_d3js_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/viz_properties_d3js_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/viz_properties_d3js_pie_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/viz_properties_d3js_pie_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/viz_properties_d3js_sankey_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/viz_properties_d3js_sankey_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/viz_properties_d3js_worldmap_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/viz_properties_d3js_worldmap_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/studierende_datenblatt_dashboard.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/studierende_datenblatt_dashboard.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_fak_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_fak_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_geschl_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_geschl_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_hzbstaat_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_hzbstaat_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_staat_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_staat_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_region_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_region_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_nach_Alter_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_nach_Alter_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_bland_hmkfz_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_bland_hmkfz_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_bland_hzbkfz_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_bland_hzbkfz_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_bland_semkfz_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_bland_semkfz_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_lkreis_hmkfz_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_lkreis_hmkfz_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_lkreis_hzbkfz_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_lkreis_hzbkfz_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_lkreis_semkfz_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_lkreis_semkfz_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_zeitreihe_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_zeitreihe_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_abgrp_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_abgrp_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/rpta_column_layout_rpta_sos_lab_aggr_zeitreihe_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/rpta_column_layout_rpta_sos_lab_aggr_zeitreihe_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/rpta_column_layout_rpta_sos_lab_aggr_abgrp_zeitreihe_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/rpta_column_layout_rpta_sos_lab_aggr_abgrp_zeitreihe_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/rpta_column_layout_rpta_sos_lab_aggr_in_rsz_zeitreihe_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/rpta_column_layout_rpta_sos_lab_aggr_in_rsz_zeitreihe_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_geschl_dashboard_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_geschl_dashboard_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_zeitreihe_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_zeitreihe_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_zeitreihe_dashboard_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_zeitreihe_dashboard_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_fak_dashboard_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_fak_dashboard_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_abgrp_dashboard_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_abgrp_dashboard_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_la_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_la_fuellen.sql


select now(),'Scriptfile $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_bildungstyp_fuellen.sql ausführen'
from xdummy;

	
\!  DOSQL $VIZ_PFAD/schluesseltabellen/rpta_column_layout_sos_stud_bildungstyp_fuellen.sql
--Integrieren: 


select now(),'Fülle db_version'
from xdummy;


delete from db_version  where his_system='viz';
insert into db_version (his_system,version,systeminfo_id) values('viz','0.3',320);



select now(),'Fülle db_tabellen'
from xdummy;

delete from db_tabellen where name='viz_type';
insert into db_tabellen (name,protokollierung) values('viz_type',0);
delete from db_tabellen where name='viz_property_input_type';
insert into db_tabellen (name,protokollierung) values('viz_property_input_type',0);
delete from db_tabellen where name='viz_property_group';
insert into db_tabellen (name,protokollierung) values('viz_property_group',0);
delete from db_tabellen where name='viz_renderer';
insert into db_tabellen (name,protokollierung) values('viz_renderer',0);
delete from db_tabellen where name='viz_chart';
insert into db_tabellen (name,protokollierung) values('viz_chart',0);
delete from db_tabellen where name='viz_type_property';
insert into db_tabellen (name,protokollierung) values('viz_type_property',0);
delete from db_tabellen where name='viz_property';
insert into db_tabellen (name,protokollierung) values('viz_property',0);
delete from db_tabellen where name='viz_property_tree_node';
insert into db_tabellen (name,protokollierung) values('viz_property_tree_node',0);
delete from db_tabellen where name='viz_property_renderer';
insert into db_tabellen (name,protokollierung) values('viz_property_renderer',0);
delete from db_tabellen where name='viz_property_group_renderer';
insert into db_tabellen (name,protokollierung) values('viz_property_group_renderer',0);
delete from db_tabellen where name='viz_staat_isocode';
insert into db_tabellen (name,protokollierung) values('viz_staat_isocode',0);
delete from db_tabellen where name='viz_colorscheme';
insert into db_tabellen (name,protokollierung) values('viz_colorscheme',0);
delete from db_tabellen where name='viz_colorscheme_element';
insert into db_tabellen (name,protokollierung) values('viz_colorscheme_element',0);
delete from db_tabellen where name='viz_dashboard';
insert into db_tabellen (name,protokollierung) values('viz_dashboard',0);
delete from db_tabellen where name='viz_dashboard_tab';
insert into db_tabellen (name,protokollierung) values('viz_dashboard_tab',0);


select now(),'Fülle sachgebiete, systeminfo und themenbaum'
from xdummy;



--Das Sachgebiet wird erzeugt, ggf. vorherige Sachgebiete sichern.


insert into sachgebiete(tid,name) select 320,'Visualisierungen'
from xdummy
where 0=(select count(*) from sachgebiete S where S.tid=320);
insert into group_sachgeb_bez 
select G.tid,320 from groupinfo G 
where (G.name='Administratoren' or G.name='superx')
and 0=(select count(*) from group_sachgeb_bez G where G.sachgebiete_id=320);

-- his1 rightname fuer Sachgebiete nachtragen


--freemarker template

<#if TableFieldExists?exists&&TableFieldExists('sachgebiete','rightname')>

update sachgebiete set rightname='CS_BIA_STANDARDREPORTS_ADMIN[VIZ]' where tid=321;
</#if>

 -- wird auch noch mal als template aufgerufen in sx_tables_fuellen.sql  --Das system wird erzeugt, ggf. vorherige systeme sichern.

insert into systeminfo(tid,name,datum) select 320,'Visualisierungen',date('1.1.1900')
from xdummy
where 0=(select count(*) from systeminfo S where S.tid=320);



select now(),'Das Thema und die Masken in den Themenbaum einfügen'
from xdummy;


--Das Thema und die Masken in den Themenbaum einfügen
--zunaechst werden die Eintraege in den themenbaum_bak eingefuegt, default ist parent=themenbaum_root
-- auf Serial setzen, damit fortlaufende Nummern vergeben werden
create temp table tmp_themenbaum
  (
    tid serial,
    name varchar(255) not null ,
    maskeninfo_id integer,
    parent integer,
    parentname char(50),
    gueltig_seit date,
    gueltig_bis date,
    erlaeuterung char(240)
  );
  create temp table tmp_themenbaum2
  (
    tid integer,
    name varchar(255) not null ,
    maskeninfo_id integer,
    parent integer,
    parentname char(50),
    gueltig_seit date,
    gueltig_bis date,
    erlaeuterung char(240)
  );
  
  

select setval('tmp_themenbaum_tid_seq',(select max(tid)+1 from themenbaum));


select now(),'root für das Modul einfügen und in den Themenbaum einhängen:'
from xdummy;


insert into tmp_themenbaum
(  tid,name, gueltig_seit,gueltig_bis )
select max(tid)+1,'Visualisierungen',date_val('01.01.1900'),date_val('01.01.3000') from themenbaum;

update tmp_themenbaum set parent=(select max(tid) from themenbaum where name='Abfragen');
insert into tmp_themenbaum(name, parentname, gueltig_seit,gueltig_bis,erlaeuterung)
 values('Administration Visualisierungen','Visualisierungen',date_val('01.01.1900'),date_val('01.01.3000'),'Abfragen zur Administration von Visualisierungen ');

--gibt es das Thema schon?
delete from tmp_themenbaum where name in (select T.name from themenbaum  T where T.name='Administration Visualisierungen' 
or T.name='Visualisierungen');

--root für das Modul einfügen und in den Themenbaum einhängen
--update themenbaum_bak set parent=(select tid from themenbaum where parent is null)
--where parent is null;
--update themenbaum_bak set tid=(select max(tid) from themenbaum 
--Nun die Einträge einfügen, die tids werden durch das serial-Feld erzeugt:
--insert into tmp_themenbaum(name, maskeninfo_id,parentname, gueltig_seit,gueltig_bis)
--select name, maskeninfo_id,parent, gueltig_seit,gueltig_bis from themenbaum_bak;
--update tmp_themenbaum set parentname=(select name from themenbaum_bak T where T.tid=tmp_themenbaum.parent);

--Nun die einzelnen Masken


select now(),'Nun die einzelnen Masken:'
from xdummy;


insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Visualisierungen suchen','44000','Administration Visualisierungen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Studierende Zeitreihe (VIZ)','44100','Visualisierungen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Studierende nach Alter (VIZ)','44130','Visualisierungen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Übergang Bachelor/Master (Flussdiagramm)','44160','Visualisierungen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Studienanfänger_innen Makro','44190','Visualisierungen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Studierende nach Geschlecht','44220','Visualisierungen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Studierende nach Staaten','44250','Visualisierungen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Studierende nach Fakultät','44280','Visualisierungen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Studierende nach Abschluss','44310','Visualisierungen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Studierende nach Abschluss','44310','Visualisierungen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Studierende nach Bildungstyp','44340','Visualisierungen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Studierende nach Semester','44570','Visualisierungen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Studierende nach Region','44600','Visualisierungen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Campus-Dashboard Übersicht','44660','Visualisierungen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Studierende, Absolvierende Dashboard','44690','Visualisierungen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Absolvierende nach Semester','44720','Visualisierungen',date_val('01.01.1900'),date_val('01.01.3000'));

--gibt es die Maske schon?
delete from tmp_themenbaum where maskeninfo_id in (select T.maskeninfo_id from themenbaum  T);


select now(),'Die einzelnen Masken sind eingefügt.'
from xdummy;



insert into tmp_themenbaum2 select * from tmp_themenbaum;
update tmp_themenbaum set parent=(select max(tid) from tmp_themenbaum2 T where tmp_themenbaum.parentname=T.name)
where parent is null;
--Wenn das Thema im echten Themenbaum schon drin war, wird da als parent genommen
update tmp_themenbaum set parent=(select max(tid) from themenbaum T where tmp_themenbaum.parentname=T.name)
where parent is null;

--Defaultmaessig werden alle parents auf themenbaum_root gesetzt
update tmp_themenbaum set parent=(select max(tid) from themenbaum where parent is null)
where parent is null;
insert into themenbaum(tid,name, maskeninfo_id,parent, gueltig_seit,gueltig_bis,erlaeuterung,sort)
select tid,name, maskeninfo_id,parent, gueltig_seit,gueltig_bis,erlaeuterung,0 from tmp_themenbaum;
drop table tmp_themenbaum2;
drop table tmp_themenbaum;


select setval('themenbaum_tid_seq',(select max(tid)+1 from themenbaum));
update themenbaum set erlaeuterung='Abfragen zur Administration von Visualisierungen ' where name='Administration Visualisierungen';


select now(),'db_forms einfügen'
from xdummy;

 
CREATE temp TABLE tmp_db_forms (
    tid serial NOT NULL,
    name character(100),
    tablename character(100),
    form_path character(255),
    caption character(200),
    description character(255)
);
insert into tmp_db_forms (name, tablename,form_path,caption,description)
values ('viz_chart_list','viz_chart','/edit/viz/viz_chart_list.jsp','Diagrammentwürfe verwalten'::varchar(200),'In diesem Formular können Sie Diagramme verwalten. Im Details-Formular können Sie Eigenschaften zuordnen.'::varchar(255));
insert into tmp_db_forms (name, tablename,form_path,caption,description)
values ('viz_chart_edit','viz_chart','/edit/viz/viz_chart_edit.jsp','Diagrammenwürfe bearbeiten'::varchar(200),'In diesem Formular können Sie Diagramme  verwalten.'::varchar(255));
insert into tmp_db_forms (name, tablename,form_path,caption,description)
values ('viz_type_list','viz_type','/edit/viz/viz_type_list.jsp','Diagrammtypen verwalten'::varchar(200),'In diesem Formular können Sie Diagrammtypen verwalten. Im Details-Formular können Sie Eigenschaften zuordnen.'::varchar(255));
insert into tmp_db_forms (name, tablename,form_path,caption,description)
values ('viz_property_list','viz_property','/edit/viz/viz_property_list.jsp','Diagrammeigenschaften verwalten'::varchar(200),'In diesem Formular können Sie Diagrammeigenschaften verwalten. Im Details-Formular können Sie Eigenschaften zuordnen.'::varchar(255));
insert into tmp_db_forms (name, tablename,form_path,caption,description)
values ('viz_property_group_list','viz_property_group','/edit/viz/viz_property_group_list.jsp','Diagrammgruppen-Eigenschaften verwalten'::varchar(200),'In diesem Formular können Sie Gruppen von Diagrammeigenschaften verwalten. '::varchar(255));
insert into tmp_db_forms (name, tablename,form_path,caption,description)
values ('viz_renderer_list','viz_renderer','/edit/viz/viz_renderer_list.jsp','Diagramm-Renderer verwalten'::varchar(200),'In diesem Formular können Sie Diagramm-Renderer  verwalten. '::varchar(255));
insert into tmp_db_forms (name, tablename,form_path,caption,description)
values ('viz_colorscheme_list','viz_colorscheme','/edit/viz/viz_colorscheme_list.jsp','Farbpaletten verwalten'::varchar(200),'In diesem Formular können Sie Farbpaletten  verwalten. '::varchar(255));

create temp table tmp_hilf(tid integer);
insert into tmp_hilf select max(tid) from db_forms;
update tmp_hilf set tid=0 where tid is null;
insert into db_forms(tid,name, tablename,form_path,caption,description)
select H.tid+D.tid, name, tablename,form_path,caption,description
from tmp_db_forms D, tmp_hilf H;

insert into sachgeb_dbform_bez select  320, H.tid+D.tid 
from tmp_db_forms D, tmp_hilf H;

drop table tmp_hilf;
drop table tmp_db_forms;


select now(),'Fülle sx_tables, sx_fields und unload_params'
from xdummy;


\! DOSQL $VIZ_PFAD/conf/sx_tables_fuellen.sql
\! DOSQL $VIZ_PFAD/conf/unload_params_fuellen.sql

\! DOSQL $VIZ_PFAD/viz_install_custom.sql
