
--SQL Script automatisch generiert von SuperX module_upgrade.xsl
--Freemarker Template
<sqlvars>
<sqlvar name="tables" type="list">

select relname,relname as tabelle from pg_class JOIN pg_namespace ON pg_namespace.oid = pg_class.relnamespace WHERE pg_namespace.nspname = 'public' AND relname::varchar(200) in ('viz_type',
'viz_property_input_type',
'viz_property_group',
'viz_renderer',
'viz_chart',
'viz_type_property',
'viz_property',
'viz_property_tree_node',
'viz_property_renderer',
'viz_property_group_renderer',
'viz_staat_isocode',
'viz_colorscheme',
'viz_colorscheme_element',
'viz_dashboard',
'viz_dashboard_tab') UNION SELECT pg_namespace.nspname||'.'||relname as relname,pg_namespace.nspname||'.'||relname as tabelle from pg_class JOIN pg_namespace ON pg_namespace.oid = pg_class.relnamespace WHERE pg_namespace.nspname||'.'||relname in ('viz_type',
'viz_property_input_type',
'viz_property_group',
'viz_renderer',
'viz_chart',
'viz_type_property',
'viz_property',
'viz_property_tree_node',
'viz_property_renderer',
'viz_property_group_renderer',
'viz_staat_isocode',
'viz_colorscheme',
'viz_colorscheme_element',
'viz_dashboard',
'viz_dashboard_tab'
);</sqlvar>
</sqlvars>

<#assign deleted_tables = []>


select now(),'Checking tables'
from xdummy;


<#if !deleted_tables?seq_contains("viz_type") && tables?is_sequence && tables?seq_contains("viz_type") >


select now(),'table viz_type exists - fine'
from xdummy;


<#else>


select now(),'Erzeuge Tabelle viz_type'
from xdummy;

create table viz_type(
	tid SERIAL  not null, 
uniquename VARCHAR(255)  not null, 
caption VARCHAR(255) , 
renderer_id INTEGER , 
srcpath VARCHAR(255) , 
method VARCHAR(255) , 
orientation CHAR(1) , 
explanation TEXT , 
preview TEXT , 
	constraint viz_type_pk primary key (tid)

) 
;



comment on table viz_type is 'Schlüsseltabelle für Arten von Visualisierungen';

comment on column viz_type.tid is 'tid';

comment on column viz_type.uniquename is 'Schlüssel';

comment on column viz_type.caption is 'Bezeichnung';

comment on column viz_type.renderer_id is 'Renderer';

comment on column viz_type.srcpath is 'Pfad zum Quellcode';

comment on column viz_type.method is 'Methode';

comment on column viz_type.orientation is 'Orientierung';

comment on column viz_type.explanation is 'Erläuterung';

comment on column viz_type.preview is 'Muster';

</#if>
delete from db_tabellen where name='viz_type';
insert into db_tabellen (name,protokollierung) values('viz_type',0);

<#if !deleted_tables?seq_contains("viz_property_input_type") && tables?is_sequence && tables?seq_contains("viz_property_input_type") >


select now(),'table viz_property_input_type exists - fine'
from xdummy;


<#else>


select now(),'Erzeuge Tabelle viz_property_input_type'
from xdummy;

create table viz_property_input_type(
	tid SERIAL  not null, 
uniquename VARCHAR(255)  not null, 
caption VARCHAR(255) , 
	constraint viz_property_input_type_pk primary key (tid)

) 
;



comment on table viz_property_input_type is 'Schlüsseltabelle für Dialogtypen von Visualisierungseigenschaften';

comment on column viz_property_input_type.tid is 'tid';

comment on column viz_property_input_type.uniquename is 'Unique Name';

comment on column viz_property_input_type.caption is 'Bezeichnung';

</#if>
delete from db_tabellen where name='viz_property_input_type';
insert into db_tabellen (name,protokollierung) values('viz_property_input_type',0);

<#if !deleted_tables?seq_contains("viz_property_group") && tables?is_sequence && tables?seq_contains("viz_property_group") >


select now(),'table viz_property_group exists - fine'
from xdummy;


<#else>


select now(),'Erzeuge Tabelle viz_property_group'
from xdummy;

create table viz_property_group(
	tid SERIAL  not null, 
uniquename VARCHAR(255)  not null, 
caption VARCHAR(255) , 
sortnr INTEGER , 
	constraint viz_property_group_pk primary key (tid)

) 
;



comment on table viz_property_group is 'Schlüsseltabelle für Gruppen von Visualisierungseigenschaften';

comment on column viz_property_group.tid is 'tid';

comment on column viz_property_group.uniquename is 'Unique Name';

comment on column viz_property_group.caption is 'Bezeichnung';

comment on column viz_property_group.sortnr is 'Sortiernummer';

</#if>
delete from db_tabellen where name='viz_property_group';
insert into db_tabellen (name,protokollierung) values('viz_property_group',0);

<#if !deleted_tables?seq_contains("viz_renderer") && tables?is_sequence && tables?seq_contains("viz_renderer") >


select now(),'table viz_renderer exists - fine'
from xdummy;


<#else>


select now(),'Erzeuge Tabelle viz_renderer'
from xdummy;

create table viz_renderer(
	tid SERIAL  not null, 
uniquename VARCHAR(255)  not null, 
caption VARCHAR(255) , 
	constraint viz_renderer_pk primary key (tid)

) 
;



comment on table viz_renderer is 'Schlüsseltabelle für Renderer von Visualisierungen';

comment on column viz_renderer.tid is 'tid';

comment on column viz_renderer.uniquename is 'Unique Name';

comment on column viz_renderer.caption is 'Bezeichnung';

</#if>
delete from db_tabellen where name='viz_renderer';
insert into db_tabellen (name,protokollierung) values('viz_renderer',0);

<#if !deleted_tables?seq_contains("viz_chart") && tables?is_sequence && tables?seq_contains("viz_chart") >


select now(),'table viz_chart exists - fine'
from xdummy;


<#else>


select now(),'Erzeuge Tabelle viz_chart'
from xdummy;

create table viz_chart(
	tid SERIAL  not null, 
uniquename VARCHAR(255)  not null, 
caption VARCHAR(255) , 
description TEXT , 
chartmodel TEXT , 
preview_svg TEXT , 
userinfo_id INTEGER , 
creation_date DATE  default today(), 
update_date DATE  default today(), 
maskeninfo_id INTEGER , 
mask_params TEXT , 
renderer_id INTEGER  not null, 
chartmodel_miniature TEXT , 
chart_position CHAR(10) , 
chart_active SMALLINT  default 1 , 
chart_width INTEGER  default 600 , 
chart_height INTEGER  default 400 , 
chart_miniature_width INTEGER  default 200 , 
chart_miniature_height INTEGER  default 100 , 
is_custom SMALLINT  default 1 , 
	constraint viz_chart_pk primary key (tid)

) 
;



comment on table viz_chart is 'Diagrammentwürfe';

comment on column viz_chart.tid is 'tid';

comment on column viz_chart.uniquename is 'Unique Name';

comment on column viz_chart.caption is 'Bezeichnung';

comment on column viz_chart.description is 'Beschreibung';

comment on column viz_chart.chartmodel is 'Quellcode des Diagramms';

comment on column viz_chart.preview_svg is 'Vorschau (SVG)';

comment on column viz_chart.userinfo_id is 'Angelegt von';

comment on column viz_chart.creation_date is 'Angelegt (Datum)';

comment on column viz_chart.update_date is 'Letzte Änderung (Datum)';

comment on column viz_chart.maskeninfo_id is 'Maske';

comment on column viz_chart.mask_params is 'Maskenparameter';

comment on column viz_chart.renderer_id is 'Renderer';

comment on column viz_chart.chartmodel_miniature is 'Quellcode des Diagramms (Miniatur)';

comment on column viz_chart.chart_position is 'Position des Diagramms';

comment on column viz_chart.chart_active is 'Grafik aktiv';

comment on column viz_chart.chart_width is 'Breite des Diagramms';

comment on column viz_chart.chart_height is 'Höhe des Diagramms';

comment on column viz_chart.chart_miniature_width is 'Breite der Diagramm-Miniatur';

comment on column viz_chart.chart_miniature_height is 'Höhe der Diagramm-Miniatur';

comment on column viz_chart.is_custom is 'Grafik der Hochschule';


select now(),'Erzeuge Index ix_viz_chart'
from xdummy;

create  unique  index ix_viz_chart on viz_chart (uniquename );

</#if>
delete from db_tabellen where name='viz_chart';
insert into db_tabellen (name,protokollierung) values('viz_chart',0);

<#if !deleted_tables?seq_contains("viz_type_property") && tables?is_sequence && tables?seq_contains("viz_type_property") >


select now(),'table viz_type_property exists - fine'
from xdummy;


<#else>


select now(),'Erzeuge Tabelle viz_type_property'
from xdummy;

create table viz_type_property(
	tid SERIAL  not null, 
viz_type_id INTEGER , 
viz_property_id INTEGER , 
is_mandatory SMALLINT  default 0 , 
sortnr SMALLINT  default 0 , 
	constraint viz_type_property_pkey primary key (tid)

) 
;



</#if>
delete from db_tabellen where name='viz_type_property';
insert into db_tabellen (name,protokollierung) values('viz_type_property',0);

<#if !deleted_tables?seq_contains("viz_property") && tables?is_sequence && tables?seq_contains("viz_property") >


select now(),'table viz_property exists - fine'
from xdummy;


<#else>


select now(),'Erzeuge Tabelle viz_property'
from xdummy;

create table viz_property(
	tid SERIAL  not null, 
caption VARCHAR(255) , 
prop_uniquename VARCHAR(255) , 
prop_default VARCHAR(255) , 
prop_unit VARCHAR(255) , 
is_generic SMALLINT  default 1 , 
static_values TEXT , 
is_mandatory SMALLINT  default 0 , 
input_type_id INTEGER  default 1 , 
property_group_id INTEGER , 
explanation TEXT , 
sortnr INTEGER , 
range_from INTEGER , 
range_to INTEGER , 
prop_value_type VARCHAR(255)  default 'string' , 
	constraint viz_property_pk primary key (tid)

) 
;



comment on table viz_property is 'Schlüsseltabelle für Eigenschaften von Visualisieren';

comment on column viz_property.tid is 'tid';

comment on column viz_property.caption is 'Bezeichnung';

comment on column viz_property.prop_uniquename is 'Schlüssel';

comment on column viz_property.prop_default is 'Defaultwert';

comment on column viz_property.prop_unit is 'Einheit';

comment on column viz_property.is_generic is 'Generische Eigenschaft';

comment on column viz_property.static_values is 'Wertebereich (statisch)';

comment on column viz_property.is_mandatory is 'Pflichteingabe';

comment on column viz_property.input_type_id is 'Eingabedialog';

comment on column viz_property.property_group_id is 'Art der Eigenschaft';

comment on column viz_property.explanation is 'Erläuterung';

comment on column viz_property.sortnr is 'Sortiernummer';

comment on column viz_property.range_from is 'Minimalwert';

comment on column viz_property.range_to is 'Maximalwert';

comment on column viz_property.prop_value_type is 'Datentyp';

</#if>
delete from db_tabellen where name='viz_property';
insert into db_tabellen (name,protokollierung) values('viz_property',0);

<#if !deleted_tables?seq_contains("viz_property_tree_node") && tables?is_sequence && tables?seq_contains("viz_property_tree_node") >


select now(),'table viz_property_tree_node exists - fine'
from xdummy;


<#else>


select now(),'Erzeuge Tabelle viz_property_tree_node'
from xdummy;

create table viz_property_tree_node(
	tid SERIAL  not null, 
renderer_id INTEGER , 
property_id INTEGER , 
parent_property_id INTEGER , 
sortnr SMALLINT  default 0 , 
is_mandatory SMALLINT  default 0 , 
	constraint viz_property_tree_node_pk primary key (tid)

) 
;



comment on table viz_property_tree_node is 'Schlüsseltabelle für Hierarchien von Eigenschaften von Visualisierungstypen';

comment on column viz_property_tree_node.tid is 'tid';

comment on column viz_property_tree_node.renderer_id is 'Renderer';

comment on column viz_property_tree_node.property_id is 'Eigenschaft der Visualisierung';

comment on column viz_property_tree_node.parent_property_id is 'Eigenschafts-Elternelement der Visualisierung';

comment on column viz_property_tree_node.sortnr is 'Sortiernr.';

comment on column viz_property_tree_node.is_mandatory is 'Pflichteingabe';

</#if>
delete from db_tabellen where name='viz_property_tree_node';
insert into db_tabellen (name,protokollierung) values('viz_property_tree_node',0);

<#if !deleted_tables?seq_contains("viz_property_renderer") && tables?is_sequence && tables?seq_contains("viz_property_renderer") >


select now(),'table viz_property_renderer exists - fine'
from xdummy;


<#else>


select now(),'Erzeuge Tabelle viz_property_renderer'
from xdummy;

create table viz_property_renderer(
	tid SERIAL  not null, 
renderer_id INTEGER  not null, 
property_id INTEGER  not null, 
variable_name VARCHAR(255) , 
	constraint viz_property_renderer_pk primary key (tid)

) 
;



comment on table viz_property_renderer is 'Schlüsseltabelle für Renderer von Visualisierungseigenschaften';

comment on column viz_property_renderer.tid is 'tid';

comment on column viz_property_renderer.renderer_id is 'Renderer';

comment on column viz_property_renderer.property_id is 'Eigenschaft der Visualisierung';

comment on column viz_property_renderer.variable_name is 'Variablenname';

</#if>
delete from db_tabellen where name='viz_property_renderer';
insert into db_tabellen (name,protokollierung) values('viz_property_renderer',0);

<#if !deleted_tables?seq_contains("viz_property_group_renderer") && tables?is_sequence && tables?seq_contains("viz_property_group_renderer") >


select now(),'table viz_property_group_renderer exists - fine'
from xdummy;


<#else>


select now(),'Erzeuge Tabelle viz_property_group_renderer'
from xdummy;

create table viz_property_group_renderer(
	tid SERIAL  not null, 
renderer_id INTEGER  not null, 
property_group_id INTEGER  not null, 
variable_name VARCHAR(255) , 
	constraint viz_property_group_renderer_pk primary key (tid)

) 
;



comment on table viz_property_group_renderer is 'Schlüsseltabelle für Renderer von Gruppen von Visualisierungseigenschaften';

comment on column viz_property_group_renderer.tid is 'tid';

comment on column viz_property_group_renderer.renderer_id is 'Renderer';

comment on column viz_property_group_renderer.property_group_id is 'Gruppe der Visualisierung';

comment on column viz_property_group_renderer.variable_name is 'Variablenname';

</#if>
delete from db_tabellen where name='viz_property_group_renderer';
insert into db_tabellen (name,protokollierung) values('viz_property_group_renderer',0);

<#if !deleted_tables?seq_contains("viz_staat_isocode") && tables?is_sequence && tables?seq_contains("viz_staat_isocode") >


select now(),'table viz_staat_isocode exists - fine'
from xdummy;


<#else>


select now(),'Erzeuge Tabelle viz_staat_isocode'
from xdummy;

create table viz_staat_isocode(
	name VARCHAR(4000) , 
iso3 VARCHAR(3) , 
kurzbezeichnung VARCHAR(3) , 
astat INTEGER , 
	constraint viz_staat_isocode_pk primary key (astat)

) 
;



</#if>
delete from db_tabellen where name='viz_staat_isocode';
insert into db_tabellen (name,protokollierung) values('viz_staat_isocode',0);

<#if !deleted_tables?seq_contains("viz_colorscheme") && tables?is_sequence && tables?seq_contains("viz_colorscheme") >


select now(),'table viz_colorscheme exists - fine'
from xdummy;


<#else>


select now(),'Erzeuge Tabelle viz_colorscheme'
from xdummy;

create table viz_colorscheme(
	tid SERIAL  not null, 
uniquename VARCHAR(255)  not null, 
caption VARCHAR(255) , 
is_custom SMALLINT  default 1 , 
specifier VARCHAR(255) , 
sortnr SMALLINT  default 0 , 
colorscheme_active SMALLINT  default 1 , 
	constraint viz_colorscheme_pk primary key (tid)

) 
;



comment on table viz_colorscheme is 'Schlüsseltabelle für Farbpaletten';

comment on column viz_colorscheme.tid is 'tid';

comment on column viz_colorscheme.uniquename is 'Schlüssel';

comment on column viz_colorscheme.caption is 'Bezeichnung';

comment on column viz_colorscheme.is_custom is 'Palette der Hochschule';

comment on column viz_colorscheme.specifier is 'Quelle (komprimiert)';

comment on column viz_colorscheme.sortnr is 'Sortiernr.';

comment on column viz_colorscheme.colorscheme_active is 'Palette aktiv';


select now(),'Erzeuge Index ix_viz_colorscheme'
from xdummy;

create  unique  index ix_viz_colorscheme on viz_colorscheme (uniquename );

</#if>
delete from db_tabellen where name='viz_colorscheme';
insert into db_tabellen (name,protokollierung) values('viz_colorscheme',0);

<#if !deleted_tables?seq_contains("viz_colorscheme_element") && tables?is_sequence && tables?seq_contains("viz_colorscheme_element") >


select now(),'table viz_colorscheme_element exists - fine'
from xdummy;


<#else>


select now(),'Erzeuge Tabelle viz_colorscheme_element'
from xdummy;

create table viz_colorscheme_element(
	tid SERIAL  not null, 
colorscheme_id INTEGER  not null, 
colorcode VARCHAR(255)  not null, 
target_uniquename VARCHAR(255) , 
sortnr SMALLINT  default 0 , 
	constraint viz_colorscheme_element_pk primary key (tid)

) 
;



comment on table viz_colorscheme_element is 'Zuordnung einzelner Farben zu einer Palette ';

comment on column viz_colorscheme_element.tid is 'tid';

comment on column viz_colorscheme_element.colorscheme_id is 'Farbpalette';

comment on column viz_colorscheme_element.colorcode is 'Farbcode';

comment on column viz_colorscheme_element.target_uniquename is 'Ziel-Schlüssel';

comment on column viz_colorscheme_element.sortnr is 'Sortiernr.';

</#if>
delete from db_tabellen where name='viz_colorscheme_element';
insert into db_tabellen (name,protokollierung) values('viz_colorscheme_element',0);

<#if !deleted_tables?seq_contains("viz_dashboard") && tables?is_sequence && tables?seq_contains("viz_dashboard") >


select now(),'table viz_dashboard exists - fine'
from xdummy;


<#else>


select now(),'Erzeuge Tabelle viz_dashboard'
from xdummy;

create table viz_dashboard(
	tid SERIAL  not null, 
uniquename VARCHAR(255)  not null, 
caption VARCHAR(255) , 
maskeninfo_id INTEGER , 
booklet_stylesheet VARCHAR(255) , 
gridtitle_felderinfo_id INTEGER , 
	constraint viz_dashboard_pk primary key (tid)

) 
;



comment on table viz_dashboard is 'Dashboard Metadaten';

comment on column viz_dashboard.tid is 'tid';

comment on column viz_dashboard.uniquename is 'Unique Name';

comment on column viz_dashboard.caption is 'Bezeichnung';

comment on column viz_dashboard.maskeninfo_id is 'Maske';

comment on column viz_dashboard.booklet_stylesheet is 'Stylesheet für Druckversion';

comment on column viz_dashboard.gridtitle_felderinfo_id is 'Maskenfeld für Titelelement';


select now(),'Erzeuge Index ix_viz_dashboard'
from xdummy;

create  unique  index ix_viz_dashboard on viz_dashboard (uniquename );

</#if>
delete from db_tabellen where name='viz_dashboard';
insert into db_tabellen (name,protokollierung) values('viz_dashboard',0);

<#if !deleted_tables?seq_contains("viz_dashboard_tab") && tables?is_sequence && tables?seq_contains("viz_dashboard_tab") >


select now(),'table viz_dashboard_tab exists - fine'
from xdummy;


<#else>


select now(),'Erzeuge Tabelle viz_dashboard_tab'
from xdummy;

create table viz_dashboard_tab(
	tid SERIAL  not null, 
dashboard_id INTEGER  not null, 
caption VARCHAR(255) , 
maskeninfo_id INTEGER , 
sortnr SMALLINT  default 0 , 
select_clause VARCHAR(255) , 
fact_table VARCHAR(255) , 
where_clause TEXT , 
optional_filter_name VARCHAR(255) , 
optional_filter_value VARCHAR(255) , 
booklet_stylesheet VARCHAR(255) , 
	constraint viz_dashboard_tab_pk primary key (tid)

) 
;



comment on table viz_dashboard_tab is 'Dashboard-Tab Metadaten';

comment on column viz_dashboard_tab.tid is 'tid';

comment on column viz_dashboard_tab.dashboard_id is 'Dashboard';

comment on column viz_dashboard_tab.caption is 'Bezeichnung';

comment on column viz_dashboard_tab.maskeninfo_id is 'Maske';

comment on column viz_dashboard_tab.sortnr is 'Sortiernr.';

comment on column viz_dashboard_tab.select_clause is 'SQL der Kennzahl';

comment on column viz_dashboard_tab.fact_table is 'Quelltabelle der Kennzahl';

comment on column viz_dashboard_tab.where_clause is 'SQL-Filter der Kennzahl';

comment on column viz_dashboard_tab.optional_filter_name is 'Optionaler Filter der Kennzahl';

comment on column viz_dashboard_tab.optional_filter_value is 'Optionaler Filterwert der Kennzahl';

comment on column viz_dashboard_tab.booklet_stylesheet is 'Stylesheet für Druckversion';


select now(),'Erzeuge Index ix_viz_dashboard'
from xdummy;

create  unique  index ix_viz_dashboard on viz_dashboard_tab (uniquename );

</#if>
delete from db_tabellen where name='viz_dashboard_tab';
insert into db_tabellen (name,protokollierung) values('viz_dashboard_tab',0);
 -- update primary keys, see ticket: #296420 
alter table if exists viz_type drop constraint if exists viz_type_pkey;
alter table if exists viz_type drop constraint if exists viz_type_pk;
alter table if exists viz_property_input_type drop constraint if exists viz_property_input_type_pkey;
alter table if exists viz_property_input_type drop constraint if exists viz_property_input_type_pk;
alter table if exists viz_property_group drop constraint if exists viz_property_group_pkey;
alter table if exists viz_property_group drop constraint if exists viz_property_group_pk;
alter table if exists viz_renderer drop constraint if exists viz_renderer_pkey;
alter table if exists viz_renderer drop constraint if exists viz_renderer_pk;
alter table if exists viz_chart drop constraint if exists viz_chart_pkey;
alter table if exists viz_chart drop constraint if exists viz_chart_pk;
alter table if exists viz_type_property drop constraint if exists viz_type_property_pkey;
alter table if exists viz_type_property drop constraint if exists viz_type_property_pkey;
alter table if exists viz_property drop constraint if exists viz_property_pkey;
alter table if exists viz_property drop constraint if exists viz_property_pk;
alter table if exists viz_property_tree_node drop constraint if exists viz_property_tree_node_pkey;
alter table if exists viz_property_tree_node drop constraint if exists viz_property_tree_node_pk;
alter table if exists viz_property_renderer drop constraint if exists viz_property_renderer_pkey;
alter table if exists viz_property_renderer drop constraint if exists viz_property_renderer_pk;
alter table if exists viz_property_group_renderer drop constraint if exists viz_property_group_renderer_pkey;
alter table if exists viz_property_group_renderer drop constraint if exists viz_property_group_renderer_pk;
alter table if exists viz_staat_isocode drop constraint if exists viz_staat_isocode_pkey;
alter table if exists viz_staat_isocode drop constraint if exists viz_staat_isocode_pk;
alter table if exists viz_colorscheme drop constraint if exists viz_colorscheme_pkey;
alter table if exists viz_colorscheme drop constraint if exists viz_colorscheme_pk;
alter table if exists viz_colorscheme_element drop constraint if exists viz_colorscheme_element_pkey;
alter table if exists viz_colorscheme_element drop constraint if exists viz_colorscheme_element_pk;
alter table if exists viz_dashboard drop constraint if exists viz_dashboard_pkey;
alter table if exists viz_dashboard drop constraint if exists viz_dashboard_pk;
alter table if exists viz_dashboard_tab drop constraint if exists viz_dashboard_tab_pkey;
alter table if exists viz_dashboard_tab drop constraint if exists viz_dashboard_tab_pk;
alter table if exists viz_type add constraint viz_type_pkey  primary key (tid);
alter table if exists viz_property_input_type add constraint viz_property_input_type_pkey  primary key (tid);
alter table if exists viz_property_group add constraint viz_property_group_pkey  primary key (tid);
alter table if exists viz_renderer add constraint viz_renderer_pkey  primary key (tid);
alter table if exists viz_chart add constraint viz_chart_pkey  primary key (tid);
alter table if exists viz_type_property add constraint viz_type_property_pkey  primary key (tid);
alter table if exists viz_property add constraint viz_property_pkey  primary key (tid);
alter table if exists viz_property_tree_node add constraint viz_property_tree_node_pkey  primary key (tid);
alter table if exists viz_property_renderer add constraint viz_property_renderer_pkey  primary key (tid);
alter table if exists viz_property_group_renderer add constraint viz_property_group_renderer_pkey  primary key (tid);
alter table if exists viz_staat_isocode add constraint viz_staat_isocode_pkey  primary key (astat);
alter table if exists viz_colorscheme add constraint viz_colorscheme_pkey  primary key (tid);
alter table if exists viz_colorscheme_element add constraint viz_colorscheme_element_pkey  primary key (tid);
alter table if exists viz_dashboard add constraint viz_dashboard_pkey  primary key (tid);
alter table if exists viz_dashboard_tab add constraint viz_dashboard_tab_pkey  primary key (tid);
