--Freemarker Template
<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>

<sqlvars>
    <sqlvar name="renderer">
        select tid from viz_renderer where uniquename='echarts';
    </sqlvar>
</sqlvars>

<#assign viz_types = [
{"uniquename":"echarts_bar_y", "caption":"Säulendiagramm (vertikal)",
"orientation":"V",
"description":"Vertikales Balkendiagramm",
"explanation":""},
{"uniquename":"echarts_bar_x", "caption":"Balkendiagramm (horizontal)",
"orientation":"H",
"description":"Horizontales Balkendiagramm",
"explanation":""},
{"uniquename":"echarts_line_y", "caption":"Liniendiagramm (vertikal)",
"orientation":"V",
"description":"Vertikales Liniendiagramm",
"explanation":""},
{"uniquename":"echarts_line_x", "caption":"Liniendiagramm (horizontal)",
"orientation":"H",
"description":"Horizontales Liniendiagramm",
"explanation":""},
{"uniquename":"echarts_pie", "caption":"Tortendiagramm",
"orientation":"Z",
"description":"Tortendiagramm oder Donut",
"explanation":""},
{"uniquename":"echarts_bar_y_stacked", "caption":"Säulendiagramm gestapelt (vertikal)",
"orientation":"V",
"description":"Vertikales Balkendiagramm (gestapelt)",
"explanation":""},
{"uniquename":"echarts_native", "caption":"Echarts (nativ)",
"orientation":"V",
"description":"Natives Diagramm",
"explanation":""}



]
/>

<#assign viz_properties = [
{ "caption":"X-Achse",
"prop_uniquename":"x",
"explanation":"X-Achse",
"prop_default":"",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"SELECT",
"property_group_uniquename":"CATEGORY",
"sortnr":"608",
"range_from":"",
"range_to":"",
"prop_value_type":"string"
},
{ "caption":"Y-Achse",
"prop_uniquename":"y",
"explanation":"Y-Achse",
"prop_default":"",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"SELECT",
"property_group_uniquename":"CATEGORY",
"sortnr":"610",
"range_from":"",
"range_to":"",
"prop_value_type":"string"
},
{ "caption":"Dimension 1",
"prop_uniquename":"dimension1",
"explanation":"Dimension 1",
"prop_default":"",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"SELECT",
"property_group_uniquename":"CATEGORY",
"sortnr":"610",
"range_from":"",
"range_to":"",
"prop_value_type":"string"
},
{ "caption":"Dimension 2",
"prop_uniquename":"dimension2",
"explanation":"Dimension 2",
"prop_default":"",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"SELECT",
"property_group_uniquename":"CATEGORY",
"sortnr":"609",
"range_from":"",
"range_to":"",
"prop_value_type":"string"
},
{ "caption":"Dimension 3",
"prop_uniquename":"dimension3",
"explanation":"Dimension 3",
"prop_default":"",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"SELECT",
"property_group_uniquename":"CATEGORY",
"sortnr":"609",
"range_from":"",
"range_to":"",
"prop_value_type":"string"
},
{ "caption":"Maß 1",
"prop_uniquename":"measure1",
"explanation":"Maß",
"prop_default":"",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"SELECT",
"property_group_uniquename":"CATEGORY",
"sortnr":"610",
"range_from":"",
"range_to":"",
"prop_value_type":"string"
},
{ "caption":"Quellcode",
"prop_uniquename":"sourcecode",
"explanation":"Quellcode bei nativen Echarts",
"prop_default":"",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"TEXT",
"property_group_uniquename":"SOURCECODE",
"sortnr":"608",
"range_from":"",
"range_to":"",
"prop_value_type":"object"
}
]
/>

<#assign viz_type_properties = [
{ "viz_type_uniquename":"echarts_bar_y",
"viz_property_uniquename":"x",
"is_mandatory":"1",
"sortnr":"1"},
{ "viz_type_uniquename":"echarts_bar_y",
"viz_property_uniquename":"y",
"is_mandatory":"1",
"sortnr":"10"},
{ "viz_type_uniquename":"echarts_bar_y_stacked",
"viz_property_uniquename":"x",
"is_mandatory":"1",
"sortnr":"1"},
{ "viz_type_uniquename":"echarts_bar_y_stacked",
"viz_property_uniquename":"stroke",
"is_mandatory":"1",
"sortnr":"10"},
{ "viz_type_uniquename":"echarts_bar_y_stacked",
"viz_property_uniquename":"y",
"is_mandatory":"1",
"sortnr":"20"},
{ "viz_type_uniquename":"echarts_bar_x",
"viz_property_uniquename":"x",
"is_mandatory":"1",
"sortnr":"1"},
{ "viz_type_uniquename":"echarts_bar_x",
"viz_property_uniquename":"y",
"is_mandatory":"1",
"sortnr":"10"},
{ "viz_type_uniquename":"echarts_line_x",
"viz_property_uniquename":"x",
"is_mandatory":"1",
"sortnr":"1"},
{ "viz_type_uniquename":"echarts_line_x",
"viz_property_uniquename":"y",
"is_mandatory":"1",
"sortnr":"10"},
{ "viz_type_uniquename":"echarts_line_y",
"viz_property_uniquename":"x",
"is_mandatory":"1",
"sortnr":"1"},
{ "viz_type_uniquename":"echarts_line_y",
"viz_property_uniquename":"y",
"is_mandatory":"1",
"sortnr":"10"},
{ "viz_type_uniquename":"echarts_pie",
"viz_property_uniquename":"dimension1",
"is_mandatory":"1",
"sortnr":"10"},
{ "viz_type_uniquename":"echarts_pie",
"viz_property_uniquename":"measure1",
"is_mandatory":"1",
"sortnr":"10"},
{ "viz_type_uniquename":"echarts_native",
"viz_property_uniquename":"sourcecode",
"is_mandatory":"1",
"sortnr":"10"}


]
/>

<#assign viz_type_properties_general = [

{ "caption":"Y: Label",
"prop_uniquename":"label_y",
"explanation":"Label Y-Achse",
"prop_default":"",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"TEXT",
"property_group_uniquename":"TICKS_LABELS_Y",
"sortnr":"",
"range_from":"",
"range_to":"",
"prop_value_type":"string",
"variable_name":"fill"
}
]
/>



<@create_temp_tables />

<@fill_viz_properties />

<#foreach viz_type in viz_types>

<@fill_viz_type_properties_general viz_type_p=viz_type />

<@fill_viz_type_properties viz_type_p=viz_type />

</#foreach>

<@drop_temp_tables />


<#macro fill_viz_type_properties_general viz_type_p>
select 'Befülle Grafikelement ${viz_type_p.caption}' from xdummy;

delete from tmp_viz_type;

insert into tmp_viz_type(tid,
       uniquename,
       caption,
       renderer_id,
--       srcpath,
--       method,
       orientation,
       explanation)
       select T.tid,
'${viz_type_p.uniquename}',
'${viz_type_p.caption}',
${renderer},
'${viz_type_p.orientation}',
'${viz_type_p.explanation}'
       from xdummy left outer join viz_type T on (
       T.uniquename='${viz_type_p.uniquename}'
       and T.renderer_id=${renderer}
       )
;

insert into viz_type(
       uniquename,
       caption,
       renderer_id,
--       srcpath,
--       method,
       orientation)
       select uniquename,
       caption,
       renderer_id,
--       srcpath,
--       method,
       orientation
       from tmp_viz_type T
       where T.tid is null;

       

update viz_type set 
       uniquename=T.uniquename,
       caption=T.caption,
       renderer_id=T.renderer_id,
--       srcpath,
--       method,
       orientation=T.orientation,
       explanation=T.explanation
       from tmp_viz_type T
       where T.tid=viz_type.tid
       and viz_type.tid in (select distinct T.tid from tmp_viz_type);
 



delete from viz_type_property
where (viz_type_id,
       viz_property_id)
in (select Y.tid as viz_type_id,
       P.tid as viz_property_id
from tmp_viz_property T,viz_type Y, viz_property P
where Y.uniquename='${viz_type_p.uniquename}'
and Y.renderer_id=${renderer}
and P.prop_uniquename=T.prop_uniquename
and T.is_general=1)

 ;

insert into viz_type_property(
 viz_type_id,
       viz_property_id,
       is_mandatory,
       sortnr)
select Y.tid as viz_type_id,
       P.tid as viz_property_id,
       P.is_mandatory,
       T.sortnr
from tmp_viz_property T,viz_type Y, viz_property P
where Y.uniquename='${viz_type_p.uniquename}'
and Y.renderer_id=${renderer}
and P.prop_uniquename=T.prop_uniquename
and T.is_general=1;



</#macro>

<#macro  fill_viz_type_properties viz_type_p>

<#foreach viz_prop in viz_type_properties>
<#if viz_prop.viz_type_uniquename==viz_type_p.uniquename >

delete from viz_type_property
where (viz_type_id,
       viz_property_id)
in (select Y.tid as viz_type_id,
       P.tid as viz_property_id
from viz_type Y, viz_property P
where Y.uniquename='${viz_type_p.uniquename}'
and Y.renderer_id=${renderer}
and P.prop_uniquename='${viz_prop.viz_property_uniquename}') ;


insert into viz_type_property(
 viz_type_id,
       viz_property_id,
       is_mandatory,
       sortnr)
select Y.tid as viz_type_id,
       P.tid as viz_property_id,
       ${viz_prop.is_mandatory},
       ${viz_prop.sortnr}
from viz_type Y, viz_property P
where Y.uniquename='${viz_type_p.uniquename}'
and Y.renderer_id=${renderer}
and P.prop_uniquename='${viz_prop.viz_property_uniquename}'
;

</#if>
</#foreach>

</#macro>

<#macro create_temp_tables>
CREATE temp TABLE tmp_viz_type
(
   tid          INTEGER    ,
   uniquename   varchar(255)   NOT NULL,
   caption      varchar(255),
   renderer_id  integer,
   srcpath      varchar(255),
   method       varchar(255),
   orientation  char(1),
   description text,
   explanation text
);

CREATE temp TABLE tmp_viz_type_property
(
   tid              serial     NOT NULL,
   viz_type_id      integer,
   viz_property_id  integer,
   is_mandatory     smallint   DEFAULT 0,
   sortnr           smallint   DEFAULT 0
);


CREATE temp TABLE tmp_viz_property_renderer
(
   tid            serial         NOT NULL,
   renderer_id    integer        NOT NULL,
   property_id    integer        NOT NULL,
   variable_name  varchar(255)
);

create temp table tmp_viz_property_group
(
   tid         serial         NOT NULL,
   uniquename  varchar(255)   NOT NULL,
   caption     varchar(255),
   sortnr      integer
);

CREATE temp TABLE tmp_viz_property_group_renderer
(
   tid                serial         NOT NULL,
   renderer_id        integer        NOT NULL,
   property_group_id  integer        NOT NULL,
   variable_name      varchar(255)
);



CREATE temp TABLE tmp_viz_property
(
   tid                integer,
   caption            varchar(255),
   prop_uniquename    varchar(255),
   prop_default       varchar(255),
   prop_unit          varchar(255),
   is_generic         smallint       DEFAULT 1,
   static_values      text,
   is_mandatory       smallint       DEFAULT 0,
   input_type_id      integer        DEFAULT 1,
   input_type_uniquename varchar(255),
   property_group_id  integer,
   property_group_uniquename varchar(255),
   property_group_variable_name  varchar(255),
   explanation        text,
   sortnr             integer,
   range_from         integer,
   range_to           integer,
   prop_value_type    varchar(255)   DEFAULT 'string'::character varying,
   variable_name varchar(255),
   is_general smallint,
   viz_type_id integer --//TODO
   
);
</#macro>

<#macro drop_temp_tables>

drop table tmp_viz_type;
drop table tmp_viz_property_group;
drop table tmp_viz_property;
drop table tmp_viz_type_property;
drop table tmp_viz_property_renderer;
drop table tmp_viz_property_group_renderer;

</#macro>

<#macro fill_viz_properties>


<#assign sortnr=0 />
<#foreach viz_prop in viz_properties>
<#assign sortnr=sortnr+100 />
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       is_general)
select P.tid,
'${viz_prop.caption}',
'${viz_prop.prop_uniquename}',
'${viz_prop.prop_default}',
'${viz_prop.prop_unit}',
${viz_prop.is_generic},
'${viz_prop.static_values}',
${viz_prop.is_mandatory},
'${viz_prop.input_type_uniquename}',
'${viz_prop.property_group_uniquename}',
'${viz_prop.explanation}',
${sortnr},
val('${viz_prop.range_from}'),
val('${viz_prop.range_to}'),
'${viz_prop.prop_value_type}',
<#if viz_prop.variable_name?exists>
'${viz_prop.variable_name}',
<#else>
'',
</#if>
0 as is_general
from xdummy left outer join viz_property P
on (P.prop_uniquename='${viz_prop.prop_uniquename}')
;
</#foreach>

<#assign sortnr=1000 />
<#foreach viz_prop in viz_type_properties_general>
<#assign sortnr=sortnr+100 />
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       is_general)
select P.tid,
'${viz_prop.caption}',
'${viz_prop.prop_uniquename}',
'${viz_prop.prop_default}',
'${viz_prop.prop_unit}',
${viz_prop.is_generic},
'${viz_prop.static_values}',
${viz_prop.is_mandatory},
'${viz_prop.input_type_uniquename}',
'${viz_prop.property_group_uniquename}',
'${viz_prop.explanation}',
${sortnr},
val('${viz_prop.range_from}'),
val('${viz_prop.range_to}'),
'${viz_prop.prop_value_type}',
<#if viz_prop.variable_name?exists>
'${viz_prop.variable_name}',
<#else>
'',
</#if>
1 as is_general
from xdummy left outer join viz_property P
on (P.prop_uniquename='${viz_prop.prop_uniquename}')
;
</#foreach>

update tmp_viz_property set input_type_id=T.tid
from viz_property_input_type T
where T.uniquename=tmp_viz_property.input_type_uniquename;

select 'Warnung: Property ohne input_type: ' || prop_uniquename
from tmp_viz_property
where input_type_id is null;


update tmp_viz_property set property_group_id=T.tid
from viz_property_group T
where T.uniquename=tmp_viz_property.property_group_uniquename;

update tmp_viz_property T set property_group_variable_name=P.variable_name
from  viz_property_group_renderer P
where P.property_group_id=T.property_group_id
and P.renderer_id=${renderer};

select 'Warnung: Property ohne property_group: ' || prop_uniquename
from tmp_viz_property
where property_group_id is null;




--neue Datensätze:
insert into viz_property(
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_id,
       property_group_id,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type)
       select 
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_id,
       property_group_id,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type
from tmp_viz_property P
where P.tid is null;

update viz_property 
set caption=T.caption,
       --prop_uniquename,
       prop_default=T.prop_default,
       prop_unit=T.prop_unit,
       is_generic=T.is_generic,
       static_values=T.static_values,
       is_mandatory=T.is_mandatory,
       input_type_id=T.input_type_id,
       property_group_id=T.property_group_id,
       explanation=T.explanation,
       sortnr=T.sortnr,
       range_from=T.range_from,
       range_to=T.range_to,
       prop_value_type=T.prop_value_type
       from tmp_viz_property T
       where T.tid=viz_property.tid
       and viz_property.tid in (select T.tid from tmp_viz_property T);

       
       --renderer:       
delete from viz_property_renderer
where (renderer_id, property_id)
in (select ${renderer},P.tid
from tmp_viz_property P);

delete from viz_property_renderer
where (renderer_id, property_id)
in (select ${renderer},P.tid
from tmp_viz_property P);


insert into viz_property_renderer(
renderer_id,
property_id,
       variable_name)
select ${renderer},
P.tid,
case when P.variable_name !='' then P.variable_name else P.prop_uniquename end
from tmp_viz_property P;

delete from viz_property_group_renderer where
(renderer_id,property_group_id) in (select distinct ${renderer},property_group_id
from tmp_viz_property);

delete from viz_type_property_group where
(viz_type_id,viz_property_id,viz_property_group_id) in (select distinct VTP.viz_type_id,
       P.tid,
       P.property_group_id
from tmp_viz_property P,viz_type_property VTP
       where P.tid=VTP.viz_property_id);


insert into viz_property_group_renderer(
  renderer_id,
       property_group_id,
       variable_name)
       select distinct 
       ${renderer},
       P.property_group_id,
       P.property_group_variable_name
       FROM tmp_viz_property P;

       insert into 
       viz_type_property_group(viz_type_id,
       viz_property_id,
       viz_property_group_id,
       sortnr,
       is_mandatory)
       select distinct VTP.viz_type_id,
       P.tid,
       P.property_group_id,
       VTP.sortnr,
       VTP.is_mandatory
       FROM tmp_viz_property P,viz_type_property VTP
       where P.tid=VTP.viz_property_id;
       
</#macro>
