--Freemarker Template
<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>
<#include "VIZ-Makros"/>
<sqlvars>
    <sqlvar name="renderer">
        select tid from viz_renderer where uniquename='plot';
    </sqlvar>
</sqlvars>
<#assign viz_types = [
{"uniquename":"bar_x", "caption":"Balkendiagramm (horizontal)",
"orientation":"H",
"description":"Horizontales Balkendiagramm",
"explanation":""},
{"uniquename":"bar_y", "caption":"Balkendiagramm (vertikal)",
"orientation":"V",
"description":"Vertikales Balkendiagramm",
"explanation":""},
{"uniquename":"line", "caption":"Linien (vertikal)",
"orientation":"V",
"description":"Vertikales Liniendiagramm",
"explanation":""},
{"uniquename":"area_x", "caption":"Flächendiagramm (horizontal)",
"orientation":"H",
"description":"Horizontales Flächendiagramm",
"explanation":""},
{"uniquename":"area_y", "caption":"Flächendiagramm (vertikal)",
"orientation":"V",
"description":"Vertikales Flächendiagramm",
"explanation":""},
{"uniquename":"dot", "caption":"Punkte (vertikal)",
"orientation":"V",
"description":"Vertikales Punktdiagramm",
"explanation":""},
{"uniquename":"box_x", "caption":"Boxplot (horizontal)",
"orientation":"H",
"description":"Horizontales Boxplot",
"explanation":""},
{"uniquename":"box_y", "caption":"Boxplot (vertikal)",
"orientation":"V",
"description":"Vertikales Boxplot",
"explanation":""},
{"uniquename":"text", "caption":"Wertelabel (vertikal)",
"orientation":"V",
"description":"Wertelabel für vertikales Diagramm",
"explanation":""}
]
/>


<#assign viz_type_properties = [
{"viz_property_uniquename":"x",
"is_mandatory":"1"},
{"viz_property_uniquename":"y",
"is_mandatory":"1"},
{"viz_property_uniquename":"stroke",
"is_mandatory":"0"},
{"viz_property_uniquename":"stroke_static",
"is_mandatory":"0"},
{"viz_property_uniquename":"fill_static",
"is_mandatory":"0"}

]
/>


<@create_temp_tables />


<#foreach viz_type in viz_types>

<@fill_viz_types viz_type_p=viz_type />

<@fill_viz_type_properties viz_type_p=viz_type />

</#foreach>



