--automatically created by SuperX/Freemarker for Postgres (23.08.2025 21:32:44)
--Freemarker Template







CREATE temp TABLE tmp_viz_property_renderer
(
   tid            serial         NOT NULL,
   renderer_id    integer        NOT NULL,
   property_id    integer        NOT NULL,
   variable_name  varchar(255)
);


CREATE temp TABLE tmp_viz_property
(
   tid                integer,
   caption            varchar(255),
   prop_uniquename    varchar(255),
   prop_default       varchar(255),
   prop_unit          varchar(255),
   is_generic         smallint       DEFAULT 1,
   static_values      text,
   is_mandatory       smallint       DEFAULT 0,
   input_type_id      integer        DEFAULT 1,
   input_type_uniquename varchar(255),
   property_group_id  integer,
   property_group_uniquename varchar(255),
   property_group_variable_name  varchar(255),
   explanation        text,
   sortnr             integer,
   range_from         integer,
   range_to           integer,
   prop_value_type    varchar(255)   DEFAULT 'STRING'::character varying,
   variable_name varchar(255),
   parent_property_uniquename varchar(255)
   
);

create temp table tmp_viz_property_tree_node(
	tid SERIAL  not null, 
viz_type_id INTEGER , 
property_id INTEGER , 
parent_property_uniquename varchar(255),
parent_property_id INTEGER , 
sortnr SMALLINT  default 0 , 
is_mandatory SMALLINT  default 0 

) 
;

CREATE temp TABLE tmp_viz_type
(
   tid          INTEGER    ,
   uniquename   varchar(255)   NOT NULL,
   caption      varchar(255),
   renderer_id  integer,
   srcpath      varchar(255),
   method       varchar(255),
   orientation  char(1),
   description text,
   explanation text
);

CREATE temp TABLE tmp_viz_type_property
(
   tid              serial     NOT NULL,
   viz_type_id      integer,
   viz_property_id  integer,
   is_mandatory     smallint   DEFAULT 0,
   sortnr           smallint   DEFAULT 0
);




insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Dimensionen',
'dimensionsNode',
'',
'',
0,
'',
0,
'NODE',
'',
'Dimensionen',
100,
val(''),
val(''),
'NODE',
'',
'' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='dimensionsNode')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'X-Achse',
'x',
'',
'',
0,
'',
1,
'SELECT',
 'CATEGORY' ,
'X-Achse',
200,
val(''),
val(''),
'string',
'',
'dimensionsNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='x')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Y-Achse',
'y',
'',
'',
0,
'',
1,
'SELECT',
 'CATEGORY' ,
'Y-Achse',
300,
val(''),
val(''),
'string',
'',
'dimensionsNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='y')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Dimension 1',
'dimension1',
'',
'',
0,
'',
1,
'SELECT',
 'CATEGORY' ,
'Dimension 1',
400,
val(''),
val(''),
'string',
'',
'dimensionsNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='dimension1')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Maß 1',
'measure1',
'',
'',
0,
'',
1,
'SELECT',
 'MEASURE' ,
'Maß 1',
500,
val(''),
val(''),
'string',
'',
'dimensionsNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='measure1')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Serien-Dimension',
'stroke',
'',
'',
0,
'',
1,
'SELECT',
 'CATEGORY' ,
'Serien-Dimension',
600,
val(''),
val(''),
'string',
'',
'dimensionsNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='stroke')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Titel',
'titleNode',
'',
'',
1,
'',
0,
'NODE',
'',
'Titel-Element',
700,
val(''),
val(''),
'NODE',
'',
'' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='titleNode')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Untertitel-Text',
'subtitle',
'',
'',
1,
'',
0,
'TEXT',
 '' ,
'Text',
800,
val(''),
val(''),
'STRING',
'',
'titleNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='subtitle')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Titel-Ausrichtung (horiz.)',
'title.left',
'left',
'',
1,
'left|center|right',
0,
'SELECT',
 '' ,
'',
900,
val(''),
val(''),
'STRING',
'',
'titleNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='title.left')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Titel-Ausrichtung (vertikal)',
'title.top',
'top',
'',
1,
'top|center|bottom',
0,
'SELECT',
 '' ,
'',
1000,
val(''),
val(''),
'STRING',
'',
'titleNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='title.top')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Ränder',
'marginNode',
'',
'',
1,
'',
0,
'NODE',
 '' ,
'',
1100,
val(''),
val(''),
'NODE',
'',
'' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='marginNode')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Rand links in %',
'margin.left',
'20',
'%',
1,
'',
0,
'TEXT',
'',
'Linker Rand in %',
1200,
val(''),
val(''),
'integer',
'',
'marginNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='margin.left')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Rand rechts in %',
'margin.right',
'0',
'%',
1,
'',
0,
'TEXT',
'',
'Rechter Rand in %',
1300,
val(''),
val(''),
'integer',
'',
'marginNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='margin.right')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Rand oben in %',
'margin.top',
'16',
'%',
1,
'',
0,
'TEXT',
'',
'Oberer Rand in %',
1400,
val(''),
val(''),
'integer',
'',
'marginNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='margin.top')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Rand unten in %',
'margin.bottom',
'20',
'%',
1,
'',
0,
'TEXT',
'',
'Unterer Rand in %',
1500,
val(''),
val(''),
'integer',
'',
'marginNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='margin.bottom')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'X-Achse',
'xAxisNode',
'',
'',
0,
'',
0,
'NODE',
'',
'X-Achse-Element',
1600,
val(''),
val(''),
'NODE',
'',
'' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='xAxisNode')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'X-Achse Name',
'xAxisName',
'',
'',
0,
'',
0,
'TEXT',
'',
'X-Achse-Name',
1700,
val(''),
val(''),
'STRING',
'',
'xAxisNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='xAxisName')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'X-Achse Name Position',
'xAxisNameLocation',
'end',
'',
0,
'start|center|end',
0,
'SELECT',
'',
'Position der X-Achsenbezeichnung',
1800,
val(''),
val(''),
'STRING',
'',
'xAxisNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='xAxisNameLocation')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'X-Achse Beschriftung',
'xAxisLabelNode',
'',
'',
0,
'',
0,
'NODE',
'',
'X-Achse-Beschriftung',
1900,
val(''),
val(''),
'NODE',
'',
'xAxisNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='xAxisLabelNode')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'X: Schriftneigung',
'tickRotate_x',
'30',
'',
0,
'',
0,
'TEXT',
'',
'X-Achse-Beschriftung Schriftneigung',
2000,
val('-90'),
val('90'),
'integer',
'',
'xAxisLabelNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='tickRotate_x')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'X: Beschriftung Breite',
'width_x',
'100',
'px',
0,
'',
0,
'TEXT',
'',
'X-Achse Breite Beschriftung',
2100,
val(''),
val(''),
'integer',
'',
'xAxisLabelNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='width_x')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'X: Abstand Beschriftung',
'padding_x',
'5',
'',
0,
'',
0,
'TEXT',
'',
'X-Achse Abstand Beschriftung zur Achsenlinie',
2200,
val(''),
val(''),
'integer',
'',
'xAxisLabelNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='padding_x')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Y-Achse',
'yAxisNode',
'',
'',
0,
'',
0,
'NODE',
'',
'Y-Achse-Element',
2300,
val(''),
val(''),
'NODE',
'',
'' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='yAxisNode')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Y-Achse Name',
'yAxisName',
'',
'',
0,
'',
0,
'TEXT',
'',
'Y-Achse-Name',
2400,
val(''),
val(''),
'STRING',
'',
'yAxisNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='yAxisName')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Y-Achse Beschriftung',
'yAxisLabelNode',
'',
'',
0,
'',
0,
'NODE',
'',
'Y-Achse-Beschriftung',
2500,
val(''),
val(''),
'NODE',
'',
'yAxisNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='yAxisLabelNode')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Y: Schriftneigung',
'tickRotate_y',
'',
'',
0,
'',
0,
'TEXT',
'',
'Y-Achse-Beschriftung Schriftneigung',
2600,
val('-90'),
val('90'),
'integer',
'',
'yAxisLabelNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='tickRotate_y')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Y: Abstand Beschriftung',
'padding_y',
'5',
'',
0,
'',
0,
'TEXT',
'',
'Y-Achse Abstand Beschriftung zur Achsenlinie',
2700,
val(''),
val(''),
'integer',
'',
'yAxisLabelNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='padding_y')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Y: Beschriftung Breite',
'width_y',
'50',
'px',
0,
'',
0,
'TEXT',
'',
'Y-Achse Breite Beschriftung',
2800,
val(''),
val(''),
'integer',
'',
'yAxisLabelNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='width_y')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Y: Distanz Beschriftung',
'distance_y',
'0',
'',
0,
'',
0,
'TEXT',
'',
'Y-Achse Abstand Beschriftung zum Item',
2900,
val(''),
val(''),
'integer',
'',
'yAxisLabelNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='distance_y')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Ausrichtung Y-Label (vertikal)',
'position_y',
'center',
'',
1,
'top|center|bottom',
0,
'SELECT',
 '' ,
'',
3000,
val(''),
val(''),
'STRING',
'',
'yAxisLabelNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='position_y')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Wertelabel',
'valueLabelNode',
'',
'',
1,
'',
0,
'NODE',
'',
'Beschriftung der Diagrammelemente',
3100,
val(''),
val(''),
'NODE',
'',
'' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='valueLabelNode')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Label anzeigen',
'valueLabelShow',
'true',
'',
1,
'true|false',
0,
'SELECT',
 '' ,
'',
3200,
val(''),
val(''),
'STRING',
'',
'valueLabelNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='valueLabelShow')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Wertelabel: Distanz Beschriftung',
'distance_valueLabel',
'10',
'',
1,
'',
0,
'TEXT',
'',
'Wertelabel Abstand Beschriftung zum Item',
3300,
val(''),
val(''),
'integer',
'',
'valueLabelNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='distance_valueLabel')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Ausrichtung Wertelabel (vertikal)',
'position_valueLabel',
'center',
'',
1,
'top|center|bottom',
0,
'SELECT',
 '' ,
'',
3400,
val(''),
val(''),
'STRING',
'',
'valueLabelNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='position_valueLabel')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Diagrammelement',
'seriesNode',
'',
'',
1,
'',
0,
'NODE',
'',
'Layout der Diagrammelemente',
3500,
val(''),
val(''),
'NODE',
'',
'' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='seriesNode')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Einzelfarbe',
'singleColor',
'',
'',
1,
'',
0,
'COLOR',
 'STYLE' ,
'Linien- oder Balkenfarbe (einfach). Wird mit höherer Priorität ausgewertet als die Palette',
3600,
val(''),
val(''),
'string',
'',
'seriesNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='singleColor')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Farbpalette (vordef.)',
'schemeArray',
'',
'',
1,
'abgrp|fak|unique|dichotom|quadroColor|blandLocalized|colorGrades',
0,
'SELECT',
 '' ,
'Farbpalette',
3700,
val(''),
val(''),
'STRING',
'',
'seriesNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='schemeArray')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Innerer Radius in %',
'innerRadius',
'30',
'%',
0,
'',
0,
'TEXT',
 '' ,
'Innerer Radius bei Tortendiagrammen (Faktor in %). Bei 0 wird kein innerer Radius genutzt, ein Wert größer 0 macht das Tortendiagramm zum Donut.',
3800,
val(''),
val(''),
'INTEGER',
'',
'seriesNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='innerRadius')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Äußerer Radius in %',
'outerRadius',
'80',
'%',
0,
'',
0,
'TEXT',
 '' ,
'Äußerer Radius bei Tortendiagrammen (Faktor in %). Parameter definiert den Anteil des Kreises am ganzen Rechteck',
3900,
val(''),
val(''),
'INTEGER',
'',
'seriesNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='outerRadius')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Abgerundete Ecken',
'cornerRadiusRounded',
'true',
'',
0,
'true|false',
0,
'SELECT',
 '' ,
'Abgerundete Ecken der Tortenstücke',
4000,
val(''),
val(''),
'STRING',
'',
'seriesNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='cornerRadiusRounded')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Zeilenselektion bei Serien',
'series_selection_line',
'',
'',
0,
'',
0,
'TEXT',
 '' ,
'Optionale Auswahl der Zeilen einer Tabelle. Sie können mit Operator größer, kleiner, oder komma-getrennten Listen der Zeilennummern arbeiten.',
4100,
val(''),
val(''),
'STRING',
'',
'seriesNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='series_selection_line')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Spaltenselektion bei Serien',
'series_selection_column',
'',
'',
0,
'',
0,
'TEXT',
 '' ,
'Optionale Auswahl der Spalten einer Tabelle. Sie können mit Operator größer, kleiner, oder komma-getrennten Listen der Spaltennummern arbeiten.',
4200,
val(''),
val(''),
'STRING',
'',
'seriesNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='series_selection_column')
;
update tmp_viz_property set input_type_id=T.tid
from viz_property_input_type T
where T.uniquename=tmp_viz_property.input_type_uniquename;

select 'Warnung: Property ohne input_type: ' || prop_uniquename
from tmp_viz_property
where input_type_id is null;

update tmp_viz_property set property_group_id=T.tid
from viz_property_group T
where T.uniquename=tmp_viz_property.property_group_uniquename;


--neue Datensätze:
insert into viz_property(
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_id,
       property_group_id,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type)
       select 
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_id,
       property_group_id,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type
from tmp_viz_property P
where P.tid is null;

update viz_property 
set caption=T.caption,
       --prop_uniquename,
       prop_default=T.prop_default,
       prop_unit=T.prop_unit,
       is_generic=T.is_generic,
       static_values=T.static_values,
       is_mandatory=T.is_mandatory,
       input_type_id=T.input_type_id,
       property_group_id=T.property_group_id,
       explanation=T.explanation,
       sortnr=T.sortnr,
       range_from=T.range_from,
       range_to=T.range_to,
       prop_value_type=T.prop_value_type
       from tmp_viz_property T
       where T.tid=viz_property.tid
       and viz_property.tid in (select T.tid from tmp_viz_property T);

       
       --renderer:       
delete from viz_property_renderer
where (renderer_id, property_id)
in (select 3,P.tid
from viz_property P, tmp_viz_property T
where P.prop_uniquename=T.prop_uniquename);



insert into viz_property_renderer(
renderer_id,
property_id,
       variable_name)
select 3,
P.tid,
case when T.variable_name !='' then T.variable_name else P.prop_uniquename end
from viz_property P, tmp_viz_property T
where P.prop_uniquename=T.prop_uniquename;


--Hierarchie:
 insert into tmp_viz_property_tree_node(
       property_id,
       parent_property_uniquename,
       --parent_property_id,
       sortnr,
       is_mandatory)
select P.tid as property_id,
       T.parent_property_uniquename,
       --parent_property_id,
       T.sortnr,
       T.is_mandatory
       from tmp_viz_property T, viz_property P
       where P.prop_uniquename=T.prop_uniquename
       ;   
update tmp_viz_property_tree_node set parent_property_id=(select P.tid
from viz_property P
where P.prop_uniquename=tmp_viz_property_tree_node.parent_property_uniquename)
;

delete from viz_property_tree_node
where renderer_id=3;

insert into viz_property_tree_node( renderer_id,
       property_id,
       parent_property_id,
       sortnr,
       is_mandatory)
select 3,
       T.property_id,
       T.parent_property_id,
       T.sortnr,
       T.is_mandatory
       from tmp_viz_property_tree_node T;  
       
  



