--Freemarker Template
<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>
<#include "VIZ-Makros"/>

<sqlvars>
    <sqlvar name="renderer">
        select tid from viz_renderer where uniquename='echarts';
    </sqlvar>
</sqlvars>

<#assign viz_properties = [
{ "caption":"Dimensionen",
"prop_uniquename":"dimensionsNode",
"explanation":"Dimensionen",
"prop_default":"",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"NODE",
"sortnr":"1",
"range_from":"",
"range_to":"",
"prop_value_type":"NODE",
"parent_property_uniquename":"",
"variableName":"encode"
},
{ "caption":"X-Achse",
"prop_uniquename":"x",
"explanation":"X-Achse",
"prop_default":"",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"1",
"input_type_uniquename":"SELECT",
"property_group_uniquename":"CATEGORY",
"sortnr":"608",
"range_from":"",
"range_to":"",
"prop_value_type":"string",
"parent_property_uniquename":"dimensionsNode"
},
{ "caption":"Y-Achse",
"prop_uniquename":"y",
"explanation":"Y-Achse",
"prop_default":"",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"1",
"input_type_uniquename":"SELECT",
"property_group_uniquename":"CATEGORY",
"sortnr":"610",
"range_from":"",
"range_to":"",
"prop_value_type":"string",
"parent_property_uniquename":"dimensionsNode"
},
{ "caption":"Dimension 1",
"prop_uniquename":"dimension1",
"explanation":"Dimension 1",
"prop_default":"",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"1",
"input_type_uniquename":"SELECT",
"property_group_uniquename":"CATEGORY",
"sortnr":"608",
"range_from":"",
"range_to":"",
"prop_value_type":"string",
"parent_property_uniquename":"dimensionsNode"
},
{ "caption":"Maß 1",
"prop_uniquename":"measure1",
"explanation":"Maß 1",
"prop_default":"",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"1",
"input_type_uniquename":"SELECT",
"property_group_uniquename":"MEASURE",
"sortnr":"610",
"range_from":"",
"range_to":"",
"prop_value_type":"string",
"parent_property_uniquename":"dimensionsNode"
},
{ "caption":"Serien-Dimension",
"prop_uniquename":"stroke",
"explanation":"Serien-Dimension",
"prop_default":"",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"1",
"input_type_uniquename":"SELECT",
"property_group_uniquename":"CATEGORY",
"sortnr":"608",
"range_from":"",
"range_to":"",
"prop_value_type":"string",
"parent_property_uniquename":"dimensionsNode"
},
{ "caption":"Titel",
"prop_uniquename":"titleNode",
"explanation":"Titel-Element",
"prop_default":"",
"prop_unit":"",
"is_generic":"1",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"NODE",
"sortnr":"1",
"range_from":"",
"range_to":"",
"prop_value_type":"NODE",
"parent_property_uniquename":"",
"variableName":"subtitle"
},
{ "caption":"Untertitel-Text",
"prop_uniquename":"subtitle",
"explanation":"Text",
"prop_default":"",
"prop_unit":"",
"is_generic":"1",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"TEXT",
"property_group_uniquename":"",
"sortnr":"10",
"range_from":"",
"range_to":"",
"prop_value_type":"STRING",
"parent_property_uniquename":"titleNode"
},
{ "caption":"Titel-Ausrichtung (horiz.)",
"prop_uniquename":"title.left",
"explanation":"",
"prop_default":"left",
"prop_unit":"",
"is_generic":"1",
"static_values":"left|center|right",
"is_mandatory":"0",
"input_type_uniquename":"SELECT",
"property_group_uniquename":"",
"sortnr":"10",
"range_from":"",
"range_to":"",
"prop_value_type":"STRING",
"parent_property_uniquename":"titleNode",
"variableName":"title.left"
},
{ "caption":"Titel-Ausrichtung (vertikal)",
"prop_uniquename":"title.top",
"explanation":"",
"prop_default":"top",
"prop_unit":"",
"is_generic":"1",
"static_values":"top|center|bottom",
"is_mandatory":"0",
"input_type_uniquename":"SELECT",
"property_group_uniquename":"",
"sortnr":"10",
"range_from":"",
"range_to":"",
"prop_value_type":"STRING",
"parent_property_uniquename":"titleNode",
"variableName":"title.top"
},
{ "caption":"Legende",
"prop_uniquename":"legendNode",
"explanation":"Legenden-Element",
"prop_default":"",
"prop_unit":"",
"is_generic":"1",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"NODE",
"sortnr":"5",
"range_from":"",
"range_to":"",
"prop_value_type":"NODE",
"parent_property_uniquename":"",
"variableName":"legendNode"
},
{ "caption":"Legende anzeigen",
"prop_uniquename":"legendShow",
"explanation":"",
"prop_default":"true",
"prop_unit":"",
"is_generic":"1",
"static_values":"true|false",
"is_mandatory":"0",
"input_type_uniquename":"SELECT",
"property_group_uniquename":"",
"sortnr":"410",
"range_from":"",
"range_to":"",
"prop_value_type":"STRING",
"parent_property_uniquename":"legendNode",
"variableName":"legendShow"
},
{ "caption":"Legenden-Ausrichtung (vertikal)",
"prop_uniquename":"legend.top",
"explanation":"",
"prop_default":"bottom",
"prop_unit":"",
"is_generic":"1",
"static_values":"top|middle|bottom",
"is_mandatory":"0",
"input_type_uniquename":"SELECT",
"property_group_uniquename":"",
"sortnr":"10",
"range_from":"",
"range_to":"",
"prop_value_type":"STRING",
"parent_property_uniquename":"legendNode",
"variableName":"legend.top"
},
{ "caption":"Legenden-Ausrichtung (horizontal)",
"prop_uniquename":"legend.left",
"explanation":"",
"prop_default":"left",
"prop_unit":"",
"is_generic":"1",
"static_values":"left|center|right",
"is_mandatory":"0",
"input_type_uniquename":"SELECT",
"property_group_uniquename":"",
"sortnr":"10",
"range_from":"",
"range_to":"",
"prop_value_type":"STRING",
"parent_property_uniquename":"legendNode",
"variableName":"legend.left"
},
{ "caption":"Legende scrollbar",
"prop_uniquename":"legend.scroll",
"explanation":"",
"prop_default":"false",
"prop_unit":"",
"is_generic":"1",
"static_values":"true|false",
"is_mandatory":"0",
"input_type_uniquename":"SELECT",
"property_group_uniquename":"",
"sortnr":"10",
"range_from":"",
"range_to":"",
"prop_value_type":"STRING",
"parent_property_uniquename":"legendNode",
"variableName":"legend.scroll"
},
{ "caption":"Ränder",
"prop_uniquename":"marginNode",
"explanation":"",
"prop_default":"",
"prop_unit":"",
"is_generic":"1",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"NODE",
"property_group_uniquename":"",
"sortnr":"10",
"range_from":"",
"range_to":"",
"prop_value_type":"NODE",
"parent_property_uniquename":"",
"variableName":"marginNode"
},
{ "caption":"Rand links in %",
"prop_uniquename":"margin.left",
"explanation":"Linker Rand in %",
"prop_default":"20",
"prop_unit":"%",
"is_generic":"1",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"TEXT",
"sortnr":"20",
"range_from":"",
"range_to":"",
"prop_value_type":"integer",
"parent_property_uniquename":"marginNode",
"variableName":"margin.left"
},
{ "caption":"Rand rechts in %",
"prop_uniquename":"margin.right",
"explanation":"Rechter Rand in %",
"prop_default":"0",
"prop_unit":"%",
"is_generic":"1",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"TEXT",
"sortnr":"30",
"range_from":"",
"range_to":"",
"prop_value_type":"integer",
"parent_property_uniquename":"marginNode",
"variableName":"margin.right"
},
{ "caption":"Rand oben in %",
"prop_uniquename":"margin.top",
"explanation":"Oberer Rand in %",
"prop_default":"16",
"prop_unit":"%",
"is_generic":"1",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"TEXT",
"sortnr":"40",
"range_from":"",
"range_to":"",
"prop_value_type":"integer",
"parent_property_uniquename":"marginNode",
"variableName":"margin.top"
},
{ "caption":"Rand unten in %",
"prop_uniquename":"margin.bottom",
"explanation":"Unterer Rand in %",
"prop_default":"20",
"prop_unit":"%",
"is_generic":"1",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"TEXT",
"sortnr":"50",
"range_from":"",
"range_to":"",
"prop_value_type":"integer",
"parent_property_uniquename":"marginNode",
"variableName":"margin.bottom"
},
{ "caption":"X-Achse",
"prop_uniquename":"xAxisNode",
"explanation":"X-Achse-Element",
"prop_default":"",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"NODE",
"sortnr":"10",
"range_from":"",
"range_to":"",
"prop_value_type":"NODE",
"parent_property_uniquename":"",
"variableName":"xAxis"
},
{ "caption":"X-Achse Name",
"prop_uniquename":"xAxisName",
"explanation":"X-Achse-Name",
"prop_default":"",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"TEXT",
"sortnr":"20",
"range_from":"",
"range_to":"",
"prop_value_type":"STRING",
"parent_property_uniquename":"xAxisNode",
"variableName":"xAxisName"
},
{ "caption":"X-Achse Name Position",
"prop_uniquename":"xAxisNameLocation",
"explanation":"Position der X-Achsenbezeichnung",
"prop_default":"end",
"prop_unit":"",
"is_generic":"0",
"static_values":"start|center|end",
"is_mandatory":"0",
"input_type_uniquename":"SELECT",
"sortnr":"25",
"range_from":"",
"range_to":"",
"prop_value_type":"STRING",
"parent_property_uniquename":"xAxisNode",
"variableName":"xAxisNameLocation"
},
{ "caption":"X-Achse Beschriftung",
"prop_uniquename":"xAxisLabelNode",
"explanation":"X-Achse-Beschriftung",
"prop_default":"",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"NODE",
"sortnr":"30",
"range_from":"",
"range_to":"",
"prop_value_type":"NODE",
"parent_property_uniquename":"xAxisNode",
"variableName":"xAxisLabelNode"
},
{ "caption":"X: Schriftneigung",
"prop_uniquename":"tickRotate_x",
"explanation":"X-Achse-Beschriftung Schriftneigung",
"prop_default":"30",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"TEXT",
"sortnr":"40",
"range_from":"-90",
"range_to":"90",
"prop_value_type":"integer",
"parent_property_uniquename":"xAxisLabelNode",
"variableName":"tickRotate_x"
},
{ "caption":"X: Beschriftung Breite",
"prop_uniquename":"width_x",
"explanation":"X-Achse Breite Beschriftung",
"prop_default":"100",
"prop_unit":"px",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"TEXT",
"sortnr":"50",
"range_from":"",
"range_to":"",
"prop_value_type":"integer",
"parent_property_uniquename":"xAxisLabelNode",
"variableName":"width_x"
},
{ "caption":"X: Abstand Beschriftung",
"prop_uniquename":"padding_x",
"explanation":"X-Achse Abstand Beschriftung zur Achsenlinie",
"prop_default":"5",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"TEXT",
"sortnr":"60",
"range_from":"",
"range_to":"",
"prop_value_type":"integer",
"parent_property_uniquename":"xAxisLabelNode",
"variableName":"padding_x"
},
{ "caption":"Y-Achse",
"prop_uniquename":"yAxisNode",
"explanation":"Y-Achse-Element",
"prop_default":"",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"NODE",
"sortnr":"100",
"range_from":"",
"range_to":"",
"prop_value_type":"NODE",
"parent_property_uniquename":"",
"variableName":"yAxis"
},
{ "caption":"Y-Achse Name",
"prop_uniquename":"yAxisName",
"explanation":"Y-Achse-Name",
"prop_default":"",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"TEXT",
"sortnr":"110",
"range_from":"",
"range_to":"",
"prop_value_type":"STRING",
"parent_property_uniquename":"yAxisNode",
"variableName":"yAxisName"
},
{ "caption":"Y-Achse Beschriftung",
"prop_uniquename":"yAxisLabelNode",
"explanation":"Y-Achse-Beschriftung",
"prop_default":"",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"NODE",
"sortnr":"120",
"range_from":"",
"range_to":"",
"prop_value_type":"NODE",
"parent_property_uniquename":"yAxisNode",
"variableName":"yAxisLabelNode"
},
{ "caption":"Y: Schriftneigung",
"prop_uniquename":"tickRotate_y",
"explanation":"Y-Achse-Beschriftung Schriftneigung",
"prop_default":"",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"TEXT",
"sortnr":"130",
"range_from":"-90",
"range_to":"90",
"prop_value_type":"integer",
"parent_property_uniquename":"yAxisLabelNode",
"variableName":"tickRotate_y"
},
{ "caption":"Y: Abstand Beschriftung",
"prop_uniquename":"padding_y",
"explanation":"Y-Achse Abstand Beschriftung zur Achsenlinie",
"prop_default":"5",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"TEXT",
"sortnr":"140",
"range_from":"",
"range_to":"",
"prop_value_type":"integer",
"parent_property_uniquename":"yAxisLabelNode",
"variableName":"padding_y"
},
{ "caption":"Y: Beschriftung Breite",
"prop_uniquename":"width_y",
"explanation":"Y-Achse Breite Beschriftung",
"prop_default":"50",
"prop_unit":"px",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"TEXT",
"sortnr":"150",
"range_from":"",
"range_to":"",
"prop_value_type":"integer",
"parent_property_uniquename":"yAxisLabelNode",
"variableName":"width_y"
},
{ "caption":"Y: Distanz Beschriftung",
"prop_uniquename":"distance_y",
"explanation":"Y-Achse Abstand Beschriftung zum Item",
"prop_default":"0",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"TEXT",
"sortnr":"160",
"range_from":"",
"range_to":"",
"prop_value_type":"integer",
"parent_property_uniquename":"yAxisLabelNode",
"variableName":"distance_y"
},
{ "caption":"Ausrichtung Y-Label (vertikal)",
"prop_uniquename":"position_y",
"explanation":"",
"prop_default":"center",
"prop_unit":"",
"is_generic":"1",
"static_values":"top|center|bottom",
"is_mandatory":"0",
"input_type_uniquename":"SELECT",
"property_group_uniquename":"",
"sortnr":"170",
"range_from":"",
"range_to":"",
"prop_value_type":"STRING",
"parent_property_uniquename":"yAxisLabelNode",
"variableName":"position_y"
},
{ "caption":"Wertelabel",
"prop_uniquename":"valueLabelNode",
"explanation":"Beschriftung der Diagrammelemente",
"prop_default":"",
"prop_unit":"",
"is_generic":"1",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"NODE",
"sortnr":"400",
"range_from":"",
"range_to":"",
"prop_value_type":"NODE",
"parent_property_uniquename":"",
"variableName":"valueLabelNode"
},
{ "caption":"Label anzeigen",
"prop_uniquename":"valueLabelShow",
"explanation":"",
"prop_default":"true",
"prop_unit":"",
"is_generic":"1",
"static_values":"true|false",
"is_mandatory":"0",
"input_type_uniquename":"SELECT",
"property_group_uniquename":"",
"sortnr":"410",
"range_from":"",
"range_to":"",
"prop_value_type":"STRING",
"parent_property_uniquename":"valueLabelNode",
"variableName":"valueLabelShow"
},
{ "caption":"Wertelabel: Distanz Beschriftung",
"prop_uniquename":"distance_valueLabel",
"explanation":"Wertelabel Abstand Beschriftung zum Item. Wird nur ausgewertet wenn Ausrichtung Wertelabel (vertikal)=top gesetzt wird.",
"prop_default":"10",
"prop_unit":"",
"is_generic":"1",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"TEXT",
"sortnr":"420",
"range_from":"",
"range_to":"",
"prop_value_type":"integer",
"parent_property_uniquename":"valueLabelNode",
"variableName":"distance_y"
},
{ "caption":"Ausrichtung Wertelabel (vertikal)",
"prop_uniquename":"position_valueLabel",
"explanation":"",
"prop_default":"top",
"prop_unit":"",
"is_generic":"1",
"static_values":"top|center|bottom",
"is_mandatory":"0",
"input_type_uniquename":"SELECT",
"property_group_uniquename":"",
"sortnr":"430",
"range_from":"",
"range_to":"",
"prop_value_type":"STRING",
"parent_property_uniquename":"valueLabelNode",
"variableName":"position_valueLabel"
},
{ "caption":"Wertelabel offset (horizontal)",
"prop_uniquename":"offset_x_valueLabel",
"explanation":"Wertelabel wird horizontal leicht verschoben, z.B. 30 bedeutet 30 Pixel nach rechts",
"prop_default":"",
"prop_unit":"",
"is_generic":"1",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"TEXT",
"property_group_uniquename":"",
"sortnr":"440",
"range_from":"",
"range_to":"",
"prop_value_type":"STRING",
"parent_property_uniquename":"valueLabelNode",
"variableName":"offset_x_valueLabel"
},
{ "caption":"Wertelabel offset (vertikal)",
"prop_uniquename":"offset_y_valueLabel",
"explanation":"Wertelabel wird vertikal leicht verschoben, z.B. 40 bedeutet 40 Pixel nach unten",
"prop_default":"",
"prop_unit":"",
"is_generic":"1",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"TEXT",
"property_group_uniquename":"",
"sortnr":"450",
"range_from":"",
"range_to":"",
"prop_value_type":"STRING",
"parent_property_uniquename":"valueLabelNode",
"variableName":"offset_y_valueLabel"
},
{ "caption":"Diagrammelement",
"prop_uniquename":"seriesNode",
"explanation":"Layout der Diagrammelemente",
"prop_default":"",
"prop_unit":"",
"is_generic":"1",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"NODE",
"sortnr":"400",
"range_from":"",
"range_to":"",
"prop_value_type":"NODE",
"parent_property_uniquename":"",
"variableName":"seriesNode"
},
{ "caption":"Einzelfarbe",
"prop_uniquename":"singleColor",
"explanation":"Linien- oder Balkenfarbe (einfach). Wird mit höherer Priorität ausgewertet als die Palette",
"prop_default":"",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"COLOR",
"property_group_uniquename":"STYLE",
"sortnr":"405",
"range_from":"",
"range_to":"",
"prop_value_type":"string",
"parent_property_uniquename":"seriesNode",
"variableName":"singleColor"
},
{ "caption":"Farbpalette (vordef.)",
"prop_uniquename":"schemeArray",
"explanation":"Farbpalette",
"prop_default":"",
"prop_unit":"",
"is_generic":"1",
"static_values":"D3_Tableau10|D3_category10|D3_Accent|D3_Dark2|D3_observable10|D3_Paired|D3_Pastel1|D3_Pastel2|D3_Set1|D3_Set2|D3_Set3|unique|dichotom|abgrp|fak|quadroColor|blandLocalized|colorGrades",
"is_mandatory":"0",
"input_type_uniquename":"SELECT",
"property_group_uniquename":"",
"sortnr":"410",
"range_from":"",
"range_to":"",
"prop_value_type":"STRING",
"parent_property_uniquename":"seriesNode",
"variableName":"schemeArray"
},
{ "caption":"Farbpalette Ziel",
"prop_uniquename":"seriesColorBy",
"explanation":"Farbpalette gilt für die Serie oder zur Untrscheidung der Daten",
"prop_default":"series",
"prop_unit":"",
"is_generic":"0",
"static_values":"series|data",
"is_mandatory":"0",
"input_type_uniquename":"SELECT",
"property_group_uniquename":"",
"sortnr":"415",
"range_from":"",
"range_to":"",
"prop_value_type":"STRING",
"parent_property_uniquename":"seriesNode",
"variableName":"seriesColorBy"
},
{ "caption":"Innerer Radius in %",
"prop_uniquename":"innerRadius",
"explanation":"Innerer Radius bei Tortendiagrammen (Faktor in %). Bei 0 wird kein innerer Radius genutzt, ein Wert größer 0 macht das Tortendiagramm zum Donut.",
"prop_default":"30",
"prop_unit":"%",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"TEXT",
"property_group_uniquename":"",
"sortnr":"420",
"range_from":"",
"range_to":"",
"prop_value_type":"INTEGER",
"parent_property_uniquename":"seriesNode",
"variableName":"innerRadius"
},
{ "caption":"Äußerer Radius in %",
"prop_uniquename":"outerRadius",
"explanation":"Äußerer Radius bei Tortendiagrammen (Faktor in %). Parameter definiert den Anteil des Kreises am ganzen Rechteck",
"prop_default":"80",
"prop_unit":"%",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"TEXT",
"property_group_uniquename":"",
"sortnr":"440",
"range_from":"",
"range_to":"",
"prop_value_type":"INTEGER",
"parent_property_uniquename":"seriesNode",
"variableName":"outerRadius"
},
{ "caption":"Abgerundete Ecken",
"prop_uniquename":"cornerRadiusRounded",
"explanation":"Abgerundete Ecken der Tortenstücke",
"prop_default":"true",
"prop_unit":"",
"is_generic":"0",
"static_values":"true|false",
"is_mandatory":"0",
"input_type_uniquename":"SELECT",
"property_group_uniquename":"",
"sortnr":"460",
"range_from":"",
"range_to":"",
"prop_value_type":"STRING",
"parent_property_uniquename":"seriesNode",
"variableName":"cornerRadiusRounded"
},
{ "caption":"Zeilenselektion bei Serien",
"prop_uniquename":"series_selection_line",
"explanation":"Optionale Auswahl der Zeilen einer Tabelle. Sie können mit Operator größer, kleiner, oder komma-getrennten Listen der Zeilennummern arbeiten.",
"prop_default":"",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"TEXT",
"property_group_uniquename":"",
"sortnr":"430",
"range_from":"",
"range_to":"",
"prop_value_type":"STRING",
"parent_property_uniquename":"seriesNode",
"variableName":"series_selection_line"
},
{ "caption":"Spaltenselektion bei Serien",
"prop_uniquename":"series_selection_column",
"explanation":"Optionale Auswahl der Spalten einer Tabelle. Sie können mit Operator größer, kleiner, oder komma-getrennten Listen der Spaltennummern arbeiten.",
"prop_default":"",
"prop_unit":"",
"is_generic":"0",
"static_values":"",
"is_mandatory":"0",
"input_type_uniquename":"TEXT",
"property_group_uniquename":"",
"sortnr":"440",
"range_from":"",
"range_to":"",
"prop_value_type":"STRING",
"parent_property_uniquename":"seriesNode",
"variableName":"series_selection_column"
},
{ "caption":"Gestapelte Balken",
"prop_uniquename":"barStacked",
"explanation":"",
"prop_default":"false",
"prop_unit":"",
"is_generic":"0",
"static_values":"true|false",
"is_mandatory":"0",
"input_type_uniquename":"SELECT",
"property_group_uniquename":"",
"sortnr":"100",
"range_from":"",
"range_to":"",
"prop_value_type":"STRING",
"parent_property_uniquename":"seriesNode",
"variableName":"barStacked"
}
]
/>



<@create_temp_tables />


<@fill_viz_properties />



