--automatically created by SuperX/Freemarker for Postgres (23.08.2025 21:28:14)
--Freemarker Template







CREATE temp TABLE tmp_viz_property_renderer
(
   tid            serial         NOT NULL,
   renderer_id    integer        NOT NULL,
   property_id    integer        NOT NULL,
   variable_name  varchar(255)
);


CREATE temp TABLE tmp_viz_property
(
   tid                integer,
   caption            varchar(255),
   prop_uniquename    varchar(255),
   prop_default       varchar(255),
   prop_unit          varchar(255),
   is_generic         smallint       DEFAULT 1,
   static_values      text,
   is_mandatory       smallint       DEFAULT 0,
   input_type_id      integer        DEFAULT 1,
   input_type_uniquename varchar(255),
   property_group_id  integer,
   property_group_uniquename varchar(255),
   property_group_variable_name  varchar(255),
   explanation        text,
   sortnr             integer,
   range_from         integer,
   range_to           integer,
   prop_value_type    varchar(255)   DEFAULT 'STRING'::character varying,
   variable_name varchar(255),
   parent_property_uniquename varchar(255)
   
);

create temp table tmp_viz_property_tree_node(
	tid SERIAL  not null, 
viz_type_id INTEGER , 
property_id INTEGER , 
parent_property_uniquename varchar(255),
parent_property_id INTEGER , 
sortnr SMALLINT  default 0 , 
is_mandatory SMALLINT  default 0 

) 
;

CREATE temp TABLE tmp_viz_type
(
   tid          INTEGER    ,
   uniquename   varchar(255)   NOT NULL,
   caption      varchar(255),
   renderer_id  integer,
   srcpath      varchar(255),
   method       varchar(255),
   orientation  char(1),
   description text,
   explanation text
);

CREATE temp TABLE tmp_viz_type_property
(
   tid              serial     NOT NULL,
   viz_type_id      integer,
   viz_property_id  integer,
   is_mandatory     smallint   DEFAULT 0,
   sortnr           smallint   DEFAULT 0
);




insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Dimensionen',
'dimensionsNode',
'',
'',
0,
'',
0,
'NODE',
'',
'Dimensionen',
100,
val(''),
val(''),
'NODE',
'',
'' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='dimensionsNode')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Dimension 1',
'dimension1',
'',
'',
0,
'',
1,
'SELECT',
 'CATEGORY' ,
'Dimension 1',
200,
val(''),
val(''),
'string',
'',
'dimensionsNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='dimension1')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Maß 1',
'measure1',
'',
'',
0,
'',
1,
'SELECT',
 'MEASURE' ,
'Maß 1',
300,
val(''),
val(''),
'string',
'',
'dimensionsNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='measure1')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Dimension 2',
'dimension2',
'',
'',
0,
'',
0,
'SELECT',
 'CATEGORY' ,
'Dimension 2',
400,
val(''),
val(''),
'string',
'',
'dimensionsNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='dimension2')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Dimension 3',
'dimension3',
'',
'',
0,
'',
0,
'SELECT',
 'CATEGORY' ,
'Dimension 3',
500,
val(''),
val(''),
'string',
'',
'dimensionsNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='dimension3')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Diagrammelement',
'seriesNode',
'',
'',
1,
'',
0,
'NODE',
'',
'Layout der Diagrammelemente',
600,
val(''),
val(''),
'NODE',
'',
'' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='seriesNode')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Innerer Radius',
'innerRadius',
'0',
'',
0,
'',
0,
'TEXT',
 'LAYOUT' ,
'Innerer Radius bei Tortendiagrammen (Faktor in %). Bei 0 wird kein innerer Radius genutzt, ein Wert größer 0 macht das Tortendiagramm zum Donut.',
700,
val('0'),
val('100'),
'string',
'',
'seriesNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='innerRadius')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Beschriftung Radius',
'labelRadiusFactor',
'80',
'',
0,
'',
0,
'TEXT',
 'LAYOUT' ,
'Beschriftungs-Radius Faktor bei Tortendiagrammen (Faktor in %). Bei 0 wird kein innerer Radius genutzt, ein Wert größer 0 macht das Tortendiagramm zum Donut.',
800,
val('0'),
val('100'),
'string',
'',
'seriesNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='labelRadiusFactor')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Kanten-Radius',
'cornerRadius',
'10',
'px',
0,
'',
0,
'TEXT',
 'LAYOUT' ,
'Ecken-Radius bei Tortendiagrammen (in Pixel). Bei 0 wird keine gerundete Kante genutzt, ein Wert größer 0 macht das Tortendiagramm zum Donut.',
900,
val('0'),
val('50'),
'string',
'',
'seriesNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='cornerRadius')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Label-Deckungsgrad',
'labelOpacity',
'70',
'',
0,
'',
0,
'TEXT',
 'LAYOUT' ,
'Deckungsgrad Faktor bei Beschriftungen (Faktor in %). Bei 100 ist maximale Deckung erreicht',
1000,
val('0'),
val('100'),
'string',
'',
'seriesNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='labelOpacity')
;
insert into tmp_viz_property(tid,
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_uniquename,
       property_group_uniquename,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type,
       variable_name,
       parent_property_uniquename)
select P.tid,
'Leerzeilen-Maskierung',
'null_value_mask',
'',
'',
0,
'',
0,
'TEXT',
 'LAYOUT' ,
'Text, der ersetzt wird, wenn eine Dimension leer ist, z.B. *Andere Hochschule* bei BA-MA-Übergang',
1100,
val(''),
val(''),
'string',
'',
'seriesNode' as parent_prop_uniquename
from xdummy left outer join viz_property P
on (P.prop_uniquename='null_value_mask')
;
update tmp_viz_property set input_type_id=T.tid
from viz_property_input_type T
where T.uniquename=tmp_viz_property.input_type_uniquename;

select 'Warnung: Property ohne input_type: ' || prop_uniquename
from tmp_viz_property
where input_type_id is null;

update tmp_viz_property set property_group_id=T.tid
from viz_property_group T
where T.uniquename=tmp_viz_property.property_group_uniquename;


--neue Datensätze:
insert into viz_property(
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_id,
       property_group_id,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type)
       select 
caption,
       prop_uniquename,
       prop_default,
       prop_unit,
       is_generic,
       static_values,
       is_mandatory,
       input_type_id,
       property_group_id,
       explanation,
       sortnr,
       range_from,
       range_to,
       prop_value_type
from tmp_viz_property P
where P.tid is null;

update viz_property 
set caption=T.caption,
       --prop_uniquename,
       prop_default=T.prop_default,
       prop_unit=T.prop_unit,
       is_generic=T.is_generic,
       static_values=T.static_values,
       is_mandatory=T.is_mandatory,
       input_type_id=T.input_type_id,
       property_group_id=T.property_group_id,
       explanation=T.explanation,
       sortnr=T.sortnr,
       range_from=T.range_from,
       range_to=T.range_to,
       prop_value_type=T.prop_value_type
       from tmp_viz_property T
       where T.tid=viz_property.tid
       and viz_property.tid in (select T.tid from tmp_viz_property T);

       
       --renderer:       
delete from viz_property_renderer
where (renderer_id, property_id)
in (select 1,P.tid
from viz_property P, tmp_viz_property T
where P.prop_uniquename=T.prop_uniquename);



insert into viz_property_renderer(
renderer_id,
property_id,
       variable_name)
select 1,
P.tid,
case when T.variable_name !='' then T.variable_name else P.prop_uniquename end
from viz_property P, tmp_viz_property T
where P.prop_uniquename=T.prop_uniquename;


--Hierarchie:
 insert into tmp_viz_property_tree_node(
       property_id,
       parent_property_uniquename,
       --parent_property_id,
       sortnr,
       is_mandatory)
select P.tid as property_id,
       T.parent_property_uniquename,
       --parent_property_id,
       T.sortnr,
       T.is_mandatory
       from tmp_viz_property T, viz_property P
       where P.prop_uniquename=T.prop_uniquename
       ;   
update tmp_viz_property_tree_node set parent_property_id=(select P.tid
from viz_property P
where P.prop_uniquename=tmp_viz_property_tree_node.parent_property_uniquename)
;

delete from viz_property_tree_node
where renderer_id=1;

insert into viz_property_tree_node( renderer_id,
       property_id,
       parent_property_id,
       sortnr,
       is_mandatory)
select 1,
       T.property_id,
       T.parent_property_id,
       T.sortnr,
       T.is_mandatory
       from tmp_viz_property_tree_node T;  
       
  



