--Freemarker Template
<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>
<#include "VIZ-Makros"/>

<#assign viz_colorschemes = [
{"uniquename":"D3_Tableau10","specifier":"4e79a7f28e2ce1575976b7b259a14fedc949af7aa1ff9da79c755fbab0ab"},
{"uniquename":"D3_category10","specifier":"1f77b4ff7f0e2ca02cd627289467bd8c564be377c27f7f7fbcbd2217becf"},
{"uniquename":"D3_Accent","specifier":"7fc97fbeaed4fdc086ffff99386cb0f0027fbf5b17666666"},
{"uniquename":"D3_Dark2","specifier":"1b9e77d95f027570b3e7298a66a61ee6ab02a6761d666666"},
{"uniquename":"D3_observable10","specifier":"4269d0efb118ff725c6cc5b03ca951ff8ab7a463f297bbf59c6b4e9498a0"},
{"uniquename":"D3_Paired","specifier":"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d66a3d9affff99b15928"},
{"uniquename":"D3_Pastel1","specifier":"fbb4aeb3cde3ccebc5decbe4fed9a6ffffcce5d8bdfddaecf2f2f2"},
{"uniquename":"D3_Pastel2","specifier":"b3e2cdfdcdaccbd5e8f4cae4e6f5c9fff2aef1e2cccccccc"},
{"uniquename":"D3_Set1","specifier":"e41a1c377eb84daf4a984ea3ff7f00ffff33a65628f781bf999999"},
{"uniquename":"D3_Set2","specifier":"66c2a5fc8d628da0cbe78ac3a6d854ffd92fe5c494b3b3b3"},
{"uniquename":"D3_Set3","specifier":"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9bc80bdccebc5ffed6f"},
{"uniquename":"unique", "caption":"Eine einzige Farbe"},
{"uniquename":"dichotom", "caption":"Dichotom"},
{"uniquename":"abgrp", "caption":"Abschlussgruppen"},
{"uniquename":"fak", "caption":"Fakultäten"},
{"uniquename":"quadroColor", "caption":"Vier Farben"},
{"uniquename":"blandLocalized", "caption":"Bundesland (eigenes)"},
{"uniquename":"colorGrades", "caption":"Blautöne"}
]
/>


<#assign viz_colorscheme_elements = [
{"colorscheme":"unique",
"colorcode":"#004c93"},

{"colorscheme":"dichotom",
"colorcode":"rgb(97,162,124)"},
{"colorscheme":"dichotom",
"colorcode":"#c3df35"},
{"colorscheme":"dichotom",
"colorcode":"#9d96f5"},
{"colorscheme":"dichotom",
"colorcode":"#e7bcf3"},

{"colorscheme":"abgrp",
"colorcode":"#374ca"},
{"colorscheme":"abgrp",
"colorcode":"#5e70ba"},
{"colorscheme":"abgrp",
"colorcode":"#64a6d9"},
{"colorscheme":"abgrp",
"colorcode":"#8cb7e1"},
{"colorscheme":"abgrp",
"colorcode":"#7aa2ba"},
{"colorscheme":"abgrp",
"colorcode":"#98b4c9"},
{"colorscheme":"abgrp",
"colorcode":"#ff933e"},

{"colorscheme":"fak",
"colorcode":"#488a7c"},
{"colorscheme":"fak",
"colorcode":"#374ca9"},
{"colorscheme":"fak",
"colorcode":"#ffd705"},
{"colorscheme":"fak",
"colorcode":"#a68eca"},
{"colorscheme":"fak",
"colorcode":"#e84035"},
{"colorscheme":"fak",
"colorcode":"#64a6d9"},
{"colorscheme":"fak",
"colorcode":"#ff933e"},
{"colorscheme":"fak",
"colorcode":"#ee79ad"},
{"colorscheme":"fak",
"colorcode":"#7aa2ba"},
{"colorscheme":"fak",
"colorcode":"#c3df35"},
{"colorscheme":"fak",
"colorcode":"#9bceab"},
{"colorscheme":"fak",
"colorcode":"#782f88"},
{"colorscheme":"fak",
"colorcode":"#96BFFF"},

{"colorscheme":"quadroColor",
"colorcode":"#374ca9"},
{"colorscheme":"quadroColor",
"colorcode":"#5e70ba"},
{"colorscheme":"quadroColor",
"colorcode":"#8794cb"},
{"colorscheme":"quadroColor",
"colorcode":"#afb7dc"},
{"colorscheme":"blandLocalized",
"colorcode":"#004c93",
"target_uniquename":"8"},
{"colorscheme":"blandLocalized",
"colorcode":"#666666"},

{"colorscheme":"colorGrades",
"colorcode":"#374ca9"},
{"colorscheme":"colorGrades",
"colorcode":"#3c53b8"},
{"colorscheme":"colorGrades",
"colorcode":"#455cc3"},
{"colorscheme":"colorGrades",
"colorcode":"#556ac8"},
{"colorscheme":"colorGrades",
"colorcode":"#6477cc"},
{"colorscheme":"colorGrades",
"colorcode":"#7384d1"},
{"colorscheme":"colorGrades",
"colorcode":"#8291d6"},
{"colorscheme":"colorGrades",
"colorcode":"#919fdb"},
{"colorscheme":"colorGrades",
"colorcode":"#a0ace0"},
{"colorscheme":"colorGrades",
"colorcode":"#afb9e5"},
{"colorscheme":"colorGrades",
"colorcode":"#bec6ea"},
{"colorscheme":"colorGrades",
"colorcode":"#cdd4ef"},
{"colorscheme":"colorGrades",
"colorcode":"#dce1f4"},
{"colorscheme":"colorGrades",
"colorcode":"#eceef9"},
{"colorscheme":"colorGrades",
"colorcode":"#f4f6fb"},
{"colorscheme":"colorGrades",
"colorcode":"#f6f7fc"}



]
/>

create temp table tmp_viz_colorscheme(
	tid integer, 
uniquename VARCHAR(255)  not null, 
caption VARCHAR(255) , 
is_custom SMALLINT  default 1 ,
specifier varchar(255),
sortnr smallint
) 
;

<#assign sortnr=0 />


<#foreach scheme in viz_colorschemes>
<#assign sortnr=sortnr + 1 />

insert into tmp_viz_colorscheme(uniquename , 
caption  , 
is_custom,
specifier,
sortnr)
values ('${scheme.uniquename}',
<#if scheme.caption?exists>
'${scheme.caption}',
<#else>
'${scheme.uniquename}',
</#if>
0,
<#if scheme.specifier?exists>
'${scheme.specifier}',
<#else>
null::varchar,
</#if>
${sortnr}*10
);

update tmp_viz_colorscheme set tid=(select C.tid
from viz_colorscheme C
where C.uniquename='${scheme.uniquename}')
where tmp_viz_colorscheme.uniquename='${scheme.uniquename}';

update viz_colorscheme set caption=(select T.caption
from tmp_viz_colorscheme T
where T.tid=viz_colorscheme.tid)
where tid in (select T.tid
from tmp_viz_colorscheme T
where T.tid is not null);

delete from tmp_viz_colorscheme
where tid is null
and uniquename in (select uniquename from viz_colorscheme);


insert into viz_colorscheme(uniquename , 
caption  , 
is_custom,
specifier,
sortnr)
select uniquename , 
caption  , 
is_custom,
specifier,
sortnr
from tmp_viz_colorscheme T
where T.tid is null;

update tmp_viz_colorscheme set tid=(select C.tid
from viz_colorscheme C
where C.uniquename='${scheme.uniquename}')
where tid is null;

delete from viz_colorscheme_element
where colorscheme_id in (select C.tid
from viz_colorscheme C
where C.uniquename='${scheme.uniquename}');

<#assign counter=0 />
<#foreach color in viz_colorscheme_elements>
<#if color.colorscheme==scheme.uniquename>
<#assign counter=counter+1 />
insert into viz_colorscheme_element(colorscheme_id  , 
colorcode, 
target_uniquename , 
sortnr )
select C.tid as colorscheme_id,
'${color.colorcode}',
<#if color.target_uniquename?exists > '${color.target_uniquename}',
<#else>
null::varchar,
</#if>
${counter}
from tmp_viz_colorscheme C
where C.uniquename='${scheme.uniquename}'
;

</#if>
</#foreach>

</#foreach>

