--Freemarker Template
--Achtung: Macro fügt Inhalte ein
--Bitte nur Freemarker Variablen füllen
<sqlvars>
    <sqlvar name="viz_installed">
        select count(*) from db_version where his_system ='viz';
    </sqlvar>
</sqlvars>


<#assign masken = [
{"mask":"30190", "filename":"30190_html_chart_sankey.xsl", "ord":"130"}
] />

<#assign stylesheet = [
{"filename":"30190_html_chart_sankey.xsl",
"caption":"BA-MA Übergang Diagramm erzeugen",
"description":"Sankey-Diagramm",
"relation":"table",
"contenttype":"text/html",
"is_generic":"0"
}
] />
<#assign stylesheet_field = [
{"filename":"30190_html_chart_sankey.xsl", "tablename":"erfolg_ba_ma_uebergang", "fieldname":"abschluss_vorher_abschluss"},
{"filename":"30190_html_chart_sankey.xsl", "tablename":"erfolg_ba_ma_uebergang", "fieldname":"einschr_nachher_abschluss"},
{"filename":"30190_html_chart_sankey.xsl", "tablename":"erfolg_ba_ma_uebergang", "fieldname":"summe"}

] />

 <#if viz_installed==1>
--Hier eventuell notwendige delete's auf die Tabellen sx_mask_style, sx_stylesheets oder stylesheet_field einfügen.

--Achtung: ab hier nicht ändern, Mutterdatei ist $SUPERX_DIR/db/module/sos/schluesseltabellen/sx_stylesheets_fuellen.sql
 <@sx_stylesheets_insert
m_masken=masken
m_stylesheet=stylesheet
m_stylesheet_field=stylesheet_field
/>

</#if>

<#macro sx_stylesheets_insert m_masken m_stylesheet m_stylesheet_field>

--Sicherstellen, dass keine Duplikate vorkommen:
--####################################################################################################
<#foreach column in m_masken>
delete from sx_mask_style where maskeninfo_id=${column.mask} and stylesheet_id in (select tid from sx_stylesheets where filename ='${column.filename}') and ord=${column.ord};
</#foreach>

<#foreach column in m_stylesheet_field>
delete from stylesheet_field where  stylesheet_id in (select tid from sx_stylesheets where filename ='${column.filename}');
</#foreach>




-- Stylesheets füllen
--####################################################################################################
create temp table tmp_stylesheets (
tid         serial  not null, 
filename    CHAR(255) , 
caption     CHAR(255) , 
description CHAR(255) , 
relation    CHAR(10) , 
useragent   CHAR(255) , 
contenttype CHAR(200)  ,
is_generic smallint
);

create temp table tmp_hilf (tid integer);
insert into tmp_hilf select max(tid) from sx_stylesheets;
update tmp_hilf set tid=1 where tid is null;

<#assign counter_tid = 1 />
<#foreach column in m_stylesheet>
insert into tmp_stylesheets (tid,filename,caption,description,relation,contenttype,is_generic)
select max(tid)+${counter_tid},'${column.filename}',
'${column.caption}',
 '${column.description}',
 '${column.relation}',
'${column.contenttype}',
${column.is_generic}
from tmp_hilf;
<#assign counter_tid = counter_tid + 1 />
</#foreach>

<#if TableFieldExists?exists && TableFieldExists('sx_stylesheets','is_generic')>
update sx_stylesheets set is_generic=1
where filename in (select T.filename from tmp_stylesheets T where T.is_generic=1);
</#if>


--delete für tml_stylesheets hinzugefügt #ak 06.03.2013
delete from tmp_stylesheets where filename in (select filename from sx_stylesheets);


insert into sx_stylesheets (tid,
filename, caption, description, relation, useragent, contenttype
<#if TableFieldExists?exists && TableFieldExists('sx_stylesheets','is_generic')>
,is_generic
</#if>
)
SELECT tid, filename, caption, description, relation, useragent, contenttype
<#if TableFieldExists?exists && TableFieldExists('sx_stylesheets','is_generic')>
,is_generic
</#if>
FROM tmp_stylesheets;

drop table tmp_stylesheets;


-- Mask Style füllen
--####################################################################################################
create temp table tmp_mask_style (
tid serial    not null, 
maskeninfo_id INTEGER , 
stylesheet_id INTEGER , 
ord           SMALLINT,
filename      char(255)
);

delete from tmp_hilf;
insert into tmp_hilf select max(tid) from sx_mask_style;
update tmp_hilf set tid=1 where tid is null;

<#assign counter_tid = 1 />
<#foreach column in m_masken>
insert into tmp_mask_style (tid,maskeninfo_id,ord,filename)
select max(tid)+${counter_tid},${column.mask},${column.ord},'${column.filename}' from tmp_hilf;

update tmp_mask_style set stylesheet_id=(select max(tid) from sx_stylesheets where filename='${column.filename}')
where filename='${column.filename}';
<#assign counter_tid = counter_tid + 1 />
</#foreach>

insert into sx_mask_style ( tid, maskeninfo_id, stylesheet_id, ord)
SELECT tid, maskeninfo_id, stylesheet_id, ord
FROM tmp_mask_style;

drop table tmp_mask_style;


--Field zu Stylesheet Zuordnungen:
--####################################################################################################
CREATE temp TABLE tmp_stylesheet_field
(
tid           serial        NOT NULL,
stylesheet_id INTEGER,
tablename     char(255),
fieldname     char(255),
filename      char(255)
);

delete from tmp_hilf;
insert into tmp_hilf select max(tid) from stylesheet_field;
update tmp_hilf set tid=1 where tid is null;

<#assign counter_tid = 1 />
<#foreach column in m_stylesheet_field>
INSERT INTO tmp_stylesheet_field (tid, filename, tablename, fieldname)
select max(tid)+${counter_tid}, '${column.filename}', '${column.tablename}', '${column.fieldname}' from tmp_hilf;

update tmp_stylesheet_field set stylesheet_id=(select max(tid) from sx_stylesheets where filename='${column.filename}')
where filename='${column.filename}';
<#assign counter_tid = counter_tid + 1 />
</#foreach>

insert into stylesheet_field ( tid, stylesheet_id, tablename, fieldname)
SELECT tid, stylesheet_id, tablename, fieldname
FROM tmp_stylesheet_field;

drop table tmp_stylesheet_field;
drop table tmp_hilf;

<#if SQLdialect='Postgres'>
select sp_update_sequence('sx_stylesheets');
select sp_update_sequence('sx_mask_style');
select sp_update_sequence('stylesheet_field');
</#if>

</#macro>
