--Freemarker Template
--Achtung: Macro fügt Inhalte ein
--Bitte nur Freemarker Variablen füllen

<#assign masken = [
{"mask":"44070", "filename":"tabelle_html_datenblatt.xsl", "ord":"20"},
{"mask":"44070", "filename":"viz_html_chart_viewer_grid.xsl", "ord":"1"},
{"mask":"44100", "filename":"viz_html_chart_viewer.xsl", "ord":"1"},
{"mask":"44100", "filename":"viz_html_chart_viewer_mask.xsl", "ord":"10"},
{"mask":"44100", "filename":"tabelle_html_datenblatt.xsl", "ord":"20"},
{"mask":"44130", "filename":"viz_html_chart_viewer.xsl", "ord":"1"},
{"mask":"44130", "filename":"tabelle_html_datenblatt.xsl", "ord":"20"},
{"mask":"44160", "filename":"viz_html_chart_viewer.xsl", "ord":"1"},
{"mask":"44160", "filename":"tabelle_html_datenblatt.xsl", "ord":"20"},
{"mask":"44160", "filename":"viz_html_chart_viewer_mask.xsl", "ord":"30"},
{"mask":"44160", "filename":"viz_html_chart_viewer_mask_and_table.xsl", "ord":"40"},

{"mask":"44190", "filename":"tabelle_html_datenblatt.xsl", "ord":"20"},
{"mask":"44190", "filename":"viz_html_chart_viewer_grid.xsl", "ord":"1"},
{"mask":"44190", "filename":"viz_html_chart_viewer.xsl", "ord":"40"},
{"mask":"44190", "filename":"viz_report_44190_xmlsource.jrxml", "ord":"50"},
{"mask":"44220", "filename":"tabelle_html_datenblatt.xsl", "ord":"20"},
{"mask":"44220", "filename":"viz_html_chart_viewer.xsl", "ord":"1"},
{"mask":"44220", "filename":"viz_html_chart_viewer_mask.xsl", "ord":"30"},
{"mask":"44220", "filename":"viz_html_chart_viewer_mask_and_table.xsl", "ord":"40"},

{"mask":"44280", "filename":"tabelle_html_datenblatt.xsl", "ord":"20"},
{"mask":"44280", "filename":"viz_html_chart_viewer.xsl", "ord":"1"},
{"mask":"44280", "filename":"viz_html_chart_viewer_mask.xsl", "ord":"30"},
{"mask":"44280", "filename":"viz_html_chart_viewer_mask_and_table.xsl", "ord":"40"},
{"mask":"44510", "filename":"tabelle_html_datenblatt.xsl", "ord":"20"},
{"mask":"44510", "filename":"viz_html_chart_viewer.xsl", "ord":"1"},
{"mask":"44510", "filename":"viz_html_chart_viewer_mask.xsl", "ord":"30"},
{"mask":"44510", "filename":"viz_html_chart_viewer_mask_and_table.xsl", "ord":"40"},


{"mask":"44250", "filename":"tabelle_html_datenblatt.xsl", "ord":"20"},
{"mask":"44250", "filename":"viz_html_chart_viewer.xsl", "ord":"1"},
{"mask":"44250", "filename":"viz_html_chart_viewer_mask.xsl", "ord":"30"},
{"mask":"44250", "filename":"viz_html_chart_viewer_mask_and_table.xsl", "ord":"40"},

{"mask":"44570", "filename":"tabelle_html_datenblatt.xsl", "ord":"20"},
{"mask":"44570", "filename":"viz_html_chart_viewer.xsl", "ord":"1"},
{"mask":"44570", "filename":"viz_html_chart_viewer_mask.xsl", "ord":"30"},
{"mask":"44570", "filename":"viz_html_chart_viewer_mask_and_table.xsl", "ord":"40"},

{"mask":"44600", "filename":"tabelle_html_datenblatt.xsl", "ord":"10"},
{"mask":"44600", "filename":"viz_html_chart_viewer.xsl", "ord":"1"},
{"mask":"44600", "filename":"viz_html_chart_viewer_mask.xsl", "ord":"30"},
{"mask":"44600", "filename":"viz_html_chart_viewer_mask_and_table.xsl", "ord":"40"},

{"mask":"44310", "filename":"tabelle_html_datenblatt.xsl", "ord":"10"},
{"mask":"44310", "filename":"viz_html_chart_viewer.xsl", "ord":"1"},
{"mask":"44310", "filename":"viz_html_chart_viewer_mask.xsl", "ord":"30"},
{"mask":"44310", "filename":"viz_html_chart_viewer_mask_and_table.xsl", "ord":"40"},

{"mask":"44340", "filename":"tabelle_html_datenblatt.xsl", "ord":"10"},
{"mask":"44340", "filename":"viz_html_chart_viewer.xsl", "ord":"1"},
{"mask":"44340", "filename":"viz_html_chart_viewer_mask.xsl", "ord":"30"},
{"mask":"44340", "filename":"viz_html_chart_viewer_mask_and_table.xsl", "ord":"40"},

{"mask":"44660", "filename":"tabelle_html_datenblatt.xsl", "ord":"20"},
{"mask":"44660", "filename":"viz_html_chart_viewer_grid.xsl", "ord":"1"},
{"mask":"44660", "filename":"viz_html_chart_viewer.xsl", "ord":"40"},
{"mask":"44660", "filename":"viz_report_44660_xmlsource.jrxml", "ord":"50"},

{"mask":"44690", "filename":"tabelle_html_datenblatt.xsl", "ord":"20"},
{"mask":"44690", "filename":"viz_html_chart_viewer_grid.xsl", "ord":"1"},
{"mask":"44690", "filename":"viz_html_chart_viewer.xsl", "ord":"40"},
{"mask":"44690", "filename":"viz_report_44690_xmlsource.jrxml", "ord":"50"},

{"mask":"44720", "filename":"tabelle_html_datenblatt.xsl", "ord":"20"},
{"mask":"44720", "filename":"viz_html_chart_viewer.xsl", "ord":"1"},
{"mask":"44720", "filename":"viz_html_chart_viewer_mask.xsl", "ord":"30"},
{"mask":"44720", "filename":"viz_html_chart_viewer_mask_and_table.xsl", "ord":"40"},

{"mask":"48460", "filename":"tabelle_html_datenblatt.xsl", "ord":"20"},
{"mask":"48460", "filename":"viz_html_chart_viewer.xsl", "ord":"1"},
{"mask":"48460", "filename":"viz_html_chart_viewer_mask.xsl", "ord":"30"},
{"mask":"48460", "filename":"viz_html_chart_viewer_mask_and_table.xsl", "ord":"40"}


] />

<#assign stylesheet = [
{"filename":"viz_html_chart.xsl",
"caption":"Diagramm erzeugen", 
"description":"Diagramm-Assistent", 
"relation":"table", 
"contenttype":"text/html", 
"is_generic":"1",
"toolbar_icon_filepath":"images/icons/chart-bar.svg",
"usage_resultset_data":"T",
"stylesheet_type":"XSL",
"jr_datasource":""
},
{"filename":"viz_html_chart_viewer_grid.xsl",
"caption":"Dashboard", 
"description":"Viewer-Stylesheet für VIZ Charts in einer Kachelansicht", 
"relation":"table", 
"contenttype":"text/html", 
"is_generic":"0",
"toolbar_icon_filepath":"",
"usage_resultset_data":"T",
"stylesheet_type":"XSL",
"jr_datasource":""
},
{"filename":"viz_html_chart_viewer_mask.xsl",
"caption":"Diagramm + Maskenfelder", 
"description":"Viewer-Stylesheet für VIZ Charts mit Maskenfelder", 
"relation":"table", 
"contenttype":"text/html", 
"is_generic":"0",
"toolbar_icon_filepath":"",
"usage_resultset_data":"T",
"stylesheet_type":"XSL",
"jr_datasource":""
},
{"filename":"viz_html_chart_viewer.xsl",
"caption":"Diagramm-Viewer (einfach)", 
"description":"Viewer-Stylesheet für VIZ Charts in einer Einzelansicht", 
"relation":"table", 
"contenttype":"text/html", 
"is_generic":"0",
"toolbar_icon_filepath":"",
"usage_resultset_data":"T",
"stylesheet_type":"XSL",
"jr_datasource":""
},
{"filename":"viz_html_chart_viewer_mask_and_table.xsl",
"caption":"Diagramm, Tabelle + Maskenfelder", 
"description":"Viewer-Stylesheet für VIZ Charts mit Tabelle und Maskenfeldern", 
"relation":"table", 
"contenttype":"text/html", 
"is_generic":"0",
"toolbar_icon_filepath":"",
"usage_resultset_data":"T",
"stylesheet_type":"XSL",
"jr_datasource":""
},
{"filename":"viz_report_44660_xmlsource.jrxml",
"caption":"Campus Dashboard Druckversion",
"description":"Ausgabe pro Reiter",
"relation":"table",
"contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
"is_generic":"0",
"toolbar_icon_filepath":"",
"usage_resultset_data":"T",
"stylesheet_type":"JRXML",
"jr_datasource":"XML"
},
{"filename":"viz_report_44190_xmlsource.jrxml",
"caption":"Campus Dashboard Studierende Druckversion",
"description":"Ausgabe pro Reiter",
"relation":"table",
"contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
"is_generic":"0",
"toolbar_icon_filepath":"",
"usage_resultset_data":"T",
"stylesheet_type":"JRXML",
"jr_datasource":"XML"
},
{"filename":"viz_report_44690_xmlsource.jrxml",
"caption":"Campus und Personal Dashboard Druckversion",
"description":"Ausgabe pro Reiter",
"relation":"table",
"contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
"is_generic":"0",
"toolbar_icon_filepath":"",
"usage_resultset_data":"T",
"stylesheet_type":"JRXML",
"jr_datasource":"XML"
}



] />
<#assign stylesheet_field = [
] />

--Hier eventuell notwendige delete's auf die Tabellen sx_mask_style, sx_stylesheets oder stylesheet_field einfügen.

delete from sx_mask_style where maskeninfo_id=44070;

--Achtung: ab hier nicht ändern, Mutterdatei ist $SUPERX_DIR/db/module/sos/schluesseltabellen/sx_stylesheets_fuellen.sql
 <@sx_stylesheets_insert
m_masken=masken
m_stylesheet=stylesheet
m_stylesheet_field=stylesheet_field
/>


<#macro sx_stylesheets_insert m_masken m_stylesheet m_stylesheet_field>

--Sicherstellen, dass keine Duplikate vorkommen:
--####################################################################################################
<#foreach column in m_masken>
delete from sx_mask_style where maskeninfo_id=${column.mask} and stylesheet_id in (select tid from sx_stylesheets where filename ='${column.filename}') and ord=${column.ord};
</#foreach>

<#foreach column in m_stylesheet_field>
delete from stylesheet_field where  stylesheet_id in (select tid from sx_stylesheets where filename ='${column.filename}');
</#foreach>




-- Stylesheets füllen
--####################################################################################################
create temp table tmp_stylesheets (
tid         serial  not null, 
filename    CHAR(255) , 
caption     CHAR(255) , 
description CHAR(255) , 
relation    CHAR(10) , 
useragent   CHAR(255) , 
contenttype CHAR(200)  ,
is_generic smallint,
toolbar_icon_filepath VARCHAR(255) , 
usage_resultset_data CHAR(10)  default 'T' , 
stylesheet_type CHAR(10)  default 'XSL' , 
jr_datasource CHAR(10)  

);

create temp table tmp_hilf (tid integer);
insert into tmp_hilf select max(tid) from sx_stylesheets;
update tmp_hilf set tid=1 where tid is null;

<#assign counter_tid = 1 />
<#foreach column in m_stylesheet>
insert into tmp_stylesheets (tid,
filename,
caption,
description,
relation,
contenttype,
is_generic,
toolbar_icon_filepath  , 
usage_resultset_data  , 
stylesheet_type , 
jr_datasource)
select max(tid)+${counter_tid},'${column.filename}',
'${column.caption}',
 '${column.description}',
 '${column.relation}',
'${column.contenttype}',
${column.is_generic},
'${column.toolbar_icon_filepath}'  , 
'${column.usage_resultset_data}'  , 
'${column.stylesheet_type}' , 
'${column.jr_datasource}'
from tmp_hilf;
<#assign counter_tid = counter_tid + 1 />
</#foreach>

<#if TableFieldExists?exists && TableFieldExists('sx_stylesheets','is_generic')>
update sx_stylesheets set is_generic=1
where filename in (select T.filename from tmp_stylesheets T where T.is_generic=1);
</#if>

<#if TableFieldExists?exists && TableFieldExists('sx_stylesheets','stylesheet_type')>
update sx_stylesheets set stylesheet_type=T.stylesheet_type,
contenttype=T.contenttype,
usage_resultset_data=T.usage_resultset_data,
jr_datasource=T.jr_datasource
from tmp_stylesheets T
where T.filename=sx_stylesheets.filename
and sx_stylesheets.filename in (select T2.filename from tmp_stylesheets T2);
</#if>

--delete für tml_stylesheets hinzugefügt #ak 06.03.2013
delete from tmp_stylesheets where filename in (select filename from sx_stylesheets);


insert into sx_stylesheets (tid,
filename, caption, description, relation, useragent, contenttype
<#if TableFieldExists?exists && TableFieldExists('sx_stylesheets','is_generic')>
,is_generic
</#if>
<#if TableFieldExists?exists && TableFieldExists('sx_stylesheets','toolbar_icon_filepath')>
,toolbar_icon_filepath  , 
usage_resultset_data  , 
stylesheet_type , 
jr_datasource
</#if>
)
SELECT tid, filename, caption, description, relation, useragent, contenttype
<#if TableFieldExists?exists && TableFieldExists('sx_stylesheets','is_generic')>
,is_generic
</#if>
<#if TableFieldExists?exists && TableFieldExists('sx_stylesheets','toolbar_icon_filepath')>
,toolbar_icon_filepath  , 
usage_resultset_data  , 
stylesheet_type , 
jr_datasource
</#if>
FROM tmp_stylesheets;

drop table tmp_stylesheets;


-- Mask Style füllen
--####################################################################################################
create temp table tmp_mask_style (
tid serial    not null, 
maskeninfo_id INTEGER , 
stylesheet_id INTEGER , 
ord           SMALLINT,
filename      char(255)
);

delete from tmp_hilf;
insert into tmp_hilf select max(tid) from sx_mask_style;
update tmp_hilf set tid=1 where tid is null;

<#assign counter_tid = 1 />
<#foreach column in m_masken>
insert into tmp_mask_style (tid,maskeninfo_id,ord,filename)
select max(tid)+${counter_tid},${column.mask},${column.ord},'${column.filename}' from tmp_hilf;

update tmp_mask_style set stylesheet_id=(select max(tid) from sx_stylesheets where filename='${column.filename}')
where filename='${column.filename}';
<#assign counter_tid = counter_tid + 1 />
</#foreach>

insert into sx_mask_style ( tid, maskeninfo_id, stylesheet_id, ord)
SELECT tid, maskeninfo_id, stylesheet_id, ord
FROM tmp_mask_style;

drop table tmp_mask_style;


--Field zu Stylesheet Zuordnungen:
--####################################################################################################
CREATE temp TABLE tmp_stylesheet_field
(
tid           serial        NOT NULL,
stylesheet_id INTEGER,
tablename     char(255),
fieldname     char(255),
filename      char(255)
);

delete from tmp_hilf;
insert into tmp_hilf select max(tid) from stylesheet_field;
update tmp_hilf set tid=1 where tid is null;

<#assign counter_tid = 1 />
<#foreach column in m_stylesheet_field>
INSERT INTO tmp_stylesheet_field (tid, filename, tablename, fieldname)
select max(tid)+${counter_tid}, '${column.filename}', '${column.tablename}', '${column.fieldname}' from tmp_hilf;

update tmp_stylesheet_field set stylesheet_id=(select max(tid) from sx_stylesheets where filename='${column.filename}')
where filename='${column.filename}';
<#assign counter_tid = counter_tid + 1 />
</#foreach>

insert into stylesheet_field ( tid, stylesheet_id, tablename, fieldname)
SELECT tid, stylesheet_id, tablename, fieldname
FROM tmp_stylesheet_field;

drop table tmp_stylesheet_field;
drop table tmp_hilf;


<#if SQLdialect='Postgres'>
select sp_update_sequence('sx_stylesheets');
select sp_update_sequence('sx_mask_style');
select sp_update_sequence('stylesheet_field');
</#if>

</#macro>
