--automatically created by SuperX/Freemarker for Postgres (27.09.2025 10:35:12)
--freemarker template
--alle berechneten Spalten








CREATE temp table tmp_tables(
name CHAR(255) , 
caption CHAR(255) , 
description CHAR(255) , 
table_type CHAR(255) , 
systeminfo_id INTEGER  , 
systeminfo_orig INTEGER  , 
thema CHAR(255) , 
sachgebiete_id CHAR(255) 
);
CREATE temp TABLE tmp_fields(
tid serial NOT NULL,
table_name VARCHAR(255)  not null, 
name VARCHAR(255)  not null, 
caption VARCHAR(255) , 
description VARCHAR(255) , 
field_type VARCHAR(255)  not null, 
field_size VARCHAR(255)  , 
field_not_null smallint,
currentlyused SMALLINT , 
is_primarykey SMALLINT  default 0 , 
foreignkey_tab VARCHAR(255) , 
foreignkey_col VARCHAR(255) , 
foreignkey_int VARCHAR(255) , 
foreignkey_cap VARCHAR(255) , 
foreignkey_cond VARCHAR(255) , 
foreignkey_func VARCHAR(255) , 
check_integrity SMALLINT, 
is_sum SMALLINT  default 1,
foreignkey_uniquename VARCHAR(255)

);


--Vorbereitung:
UPDATE sx_tables
   SET caption = 'Standorte'
WHERE name='sos_k_stort';
UPDATE sx_tables
   SET caption = 'Studienart'
WHERE name = 'sos_k_stuart';
UPDATE sx_tables
   SET caption = 'Studiumstyp'
WHERE name = 'sos_k_stutyp';
UPDATE sx_tables
   SET caption = 'Studienform'
WHERE name = 'sos_k_stufrm';
UPDATE sx_tables
   SET caption = 'Hörerstatus'
WHERE name = 'sos_k_hrst';



--drop view if exists sos_stud_astat;


drop VIEW sos_k_stutyp;

CREATE VIEW sos_k_stutyp
(
  apnr,
  druck,
  astat
)
AS 
 SELECT cifx.apnr,
    cifx.druck,
    astat
   FROM cifx
  WHERE cifx.key = 40;
  

update sx_fields set 
       is_sum=0
       where table_name='sos_stg_aggr'
       and name!='summe';
update sx_fields set 
       is_sum=1
       where table_name='sos_stg_aggr'
       and name='summe';
       
  
insert into tmp_tables (
name,
caption,
description,
table_type,
systeminfo_id,
thema,
sachgebiete_id
) 
select 
'sos_stud_astat_dashboard',
'Studierende (Fachsem., HS-Sem., Studiengang) Dashboard',
description,
table_type,
systeminfo_id,
thema,
sachgebiete_id
from sx_tables where name='sos_stg_aggr'
;


insert into tmp_fields (table_name,
       name,
       caption,
       description,
       field_type,
       field_size,
       field_not_null,
       currentlyused,
       is_primarykey,
       foreignkey_tab,
       foreignkey_col,
       foreignkey_int,
       foreignkey_cap,
       foreignkey_cond,
       foreignkey_func,
       check_integrity,
       is_sum,
       foreignkey_uniquename) 
select  'sos_stud_astat_dashboard' as table_name,
       name,
       caption,
       description,
       field_type,
       field_size,
       field_not_null,
       currentlyused,
       is_primarykey,
       foreignkey_tab,
       foreignkey_col,
       foreignkey_int,
       foreignkey_cap,
       foreignkey_cond,
       foreignkey_func,
       check_integrity,
       is_sum,
       foreignkey_uniquename
       from sx_fields where table_name ='sos_stg_aggr'
       and name in ('tid_stg','sem_rueck_beur_ein','stichtag','geschlecht', 'hzbart','hzbart_int', 'hzbkfz', 'hzbkfzkz','hrst', 'ca12_staat', 'fach_sem_zahl','hssem','studiengang_nr', 'fach_nr','summe')
       and currentlyused=1;
insert into tmp_fields (table_name,
       name,
       caption,
       description,
       field_type,
       field_size,
       field_not_null,
       currentlyused,
       is_primarykey,
       foreignkey_tab,
       foreignkey_col,
       foreignkey_int,
       foreignkey_cap,
       foreignkey_cond,
       foreignkey_func,
       check_integrity,
       is_sum,
       foreignkey_uniquename) 
select  'sos_stud_astat_dashboard' as table_name,
       'dim_studiengang_' || name,
       'Studiengänge: ' || caption,
       description,
       field_type,
       field_size,
       field_not_null,
       currentlyused,
       is_primarykey,
       foreignkey_tab,
       foreignkey_col,
       foreignkey_int,
       foreignkey_cap,
       foreignkey_cond,
       foreignkey_func,
       check_integrity,
       is_sum,
       foreignkey_uniquename
       from sx_fields where table_name ='dim_studiengang'
       and name in ('fb', 'abschluss_grp', 'abschluss_grp_str', 'fb_str','abschluss_astat_bund')
       and currentlyused=1;
--und berechnete Spalten einfügen
insert into tmp_fields (table_name,name,caption,description,field_type,field_size,field_not_null,currentlyUsed,is_sum)
select 
'sos_stud_astat_dashboard', 'hzbstaat_iso3','Staat der HZB', 'Staat der HZB', 'CHAR',30, 1, 1,0 from xdummy;
insert into tmp_fields (table_name,name,caption,description,field_type,field_size,field_not_null,currentlyUsed,is_sum)
select 
'sos_stud_astat_dashboard', 'geschlecht_str','Geschlecht', 'Geschlecht', 'CHAR',30, 1, 1,0 from xdummy;
insert into tmp_fields (table_name,name,caption,description,field_type,field_size,field_not_null,currentlyUsed,is_sum)
select 
'sos_stud_astat_dashboard', 'hzb_bland','Bundesland (HZB)', 'Bundesland (HZB)', 'CHAR',30, 1, 1,0 from xdummy;
insert into tmp_fields (table_name,name,caption,description,field_type,field_size,field_not_null,currentlyUsed,is_sum)
select 
'sos_stud_astat_dashboard', 'dim_studiengang_fak_str','Fakultät', 'Fakultät (Name)', 'CHAR',30, 1, 1,0 from xdummy;
insert into tmp_fields (table_name,name,caption,description,field_type,field_size,field_not_null,currentlyUsed,is_sum)
select 
'sos_stud_astat_dashboard', 'sos_stud_bildungstyp','Bildungsinländer / -ausländer', 'Bildungsinländer / -ausländer', 'CHAR',30, 1, 1,0 from xdummy;
insert into tmp_fields (table_name,name,caption,description,field_type,field_size,field_not_null,currentlyUsed,is_sum)
select 
'sos_stud_astat_dashboard', 'semester_str','Semester Name', 'Semester Name', 'CHAR',30, 1, 1,0 from xdummy;

CREATE temp TABLE tmp_rpta_resultset
(
    caption        varchar(255),
   uniquename     varchar(255),
   fieldclause    text,
   joinclause     text,
   whereclause    text,
   systeminfo_id  integer,
   is_virtual smallint default 1
);

insert into tmp_rpta_resultset(caption,
       uniquename,
       systeminfo_id,
       is_virtual)
       select 'Studierende (Fachsem., HS-Sem., Studiengang) Dashboard',
       'sos_stud_astat_dashboard',
       7,
       0
;


update tmp_rpta_resultset set fieldclause='
viz_staat_isocode.iso3 as hzbstaat_iso3,
sos_k_geschl.druck as geschlecht_str,
rpta_sos_hzb_bland.bland_druck as hzb_bland,
cifx.kurz as dim_studiengang_fak_str,
(case when ca12_staat != 0 and (hzbkfzkz = 1 or (hzbart_int in (''31'',''51'',''76'') and hzbkfzkz = 0) or hzbart_int is null) then ''Bildungsausländer'' else ''Bildungsinländer'' end) as sos_stud_bildungstyp,
(case when substring(sem_rueck_beur_ein::varchar from 5 for 1)=''2'' then ''WS '' || substring(sem_rueck_beur_ein::varchar from 3 for 2) || ''/'' || lpad('''' || val(substring(sem_rueck_beur_ein::varchar from 3 for 2))+1,2,''0'') when substring(sem_rueck_beur_ein::varchar from 5 for 1)=''1'' then ''SS '' || substring(sem_rueck_beur_ein::varchar from 3 for 2) else '''' end) as semester_str,

dim_studiengang.abschluss_grp as dim_studiengang_abschluss_grp,
dim_studiengang.abschluss_grp_str as dim_studiengang_abschluss_grp_str,
dim_studiengang.fb as dim_studiengang_fb,
dim_studiengang.fb_str as dim_studiengang_fb_str,
dim_studiengang.abschluss_astat_bund as dim_studiengang_abschluss_astat_bund,
sos_stg_aggr.tid_stg as tid_stg,
sos_stg_aggr.ca12_staat as ca12_staat,
sos_stg_aggr.geschlecht as geschlecht,
sos_stg_aggr.hzbart as hzbart,
sos_stg_aggr.hzbkfzkz as hzbkfzkz,
sos_stg_aggr.hzbkfz as hzbkfz,
sos_stg_aggr.hrst as hrst,
sos_stg_aggr.studiengang_nr as studiengang_nr,
sos_stg_aggr.fach_nr as fach_nr,
sos_stg_aggr.fach_sem_zahl as fach_sem_zahl,
sos_stg_aggr.sem_rueck_beur_ein as sem_rueck_beur_ein,
sos_stg_aggr.hssem as hssem,
sos_stg_aggr.stichtag as stichtag,
sos_stg_aggr.summe as summe,
sos_stg_aggr.hzbart_int as hzbart_int,
null::varchar as dummy',
joinclause='sos_stg_aggr
left outer join dim_studiengang on (dim_studiengang.tid=sos_stg_aggr.tid_stg)
left outer join viz_staat_isocode on ((viz_staat_isocode.astat=sos_stg_aggr.hzbkfz and sos_stg_aggr.hzbkfzkz=1) or (viz_staat_isocode.astat=0 and sos_stg_aggr.hzbkfzkz=0))
left outer join sos_k_geschl on (sos_k_geschl.apnr=sos_stg_aggr.geschlecht)
left outer join rpta_sos_hzb_bland on (rpta_sos_hzb_bland.wohnsitz_astat=sos_stg_aggr.hzbkfz)
left outer join cifx on (cifx.key=90 and cifx.apnr=fb)
';

--whereclause erstmal primitiv
update tmp_rpta_resultset set whereclause = 'and stichtag in (select tid  from sos_stichtag where appl_key=''0'') and hrst in (select apnr from sos_k_hrst HRST where HRST.astat in (''1'',''2'')) and kz_rueck_beur_ein in (1,2,3)';
select * into temp tmp_rs1 
from rpta_resultset
;

update rpta_resultset set caption=T.caption,
       fieldclause=T.fieldclause,
       joinclause=T.joinclause,
       whereclause=T.whereclause,
       is_virtual=T.is_virtual
       from tmp_rpta_resultset T
       where T.systeminfo_id=rpta_resultset.systeminfo_id
       and T.uniquename=rpta_resultset.uniquename
       ;

insert into rpta_resultset(caption,
       uniquename,
       fieldclause,
       joinclause,
       whereclause,
       systeminfo_id,
       is_virtual)
select caption,
       uniquename,
       fieldclause,
       joinclause,
       whereclause,
       systeminfo_id,
       is_virtual
       from tmp_rpta_resultset
       where 0=(select count(*) 
       from tmp_rs1 T
       where T.systeminfo_id=tmp_rpta_resultset.systeminfo_id
       and T.uniquename=tmp_rpta_resultset.uniquename)
       ;
drop table tmp_rpta_resultset;
drop table tmp_rs1;

delete from sx_tables where name
in (select T.name from tmp_tables  T);

insert into sx_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id)
select name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id
from tmp_tables;


delete from sx_fields where table_name
in (select T.table_name from tmp_fields T);

insert into sx_fields (table_name,name,caption,description,field_type,
field_size,
field_not_null,
currentlyUsed,
foreignkey_tab,
foreignkey_col,
foreignkey_cap,
foreignkey_int,
foreignkey_cond,
foreignkey_func,
check_integrity,
is_sum,
foreignkey_uniquename
)
select 
F.table_name,F.name,F.caption,F.description,F.field_type,
F.field_size,
F.field_not_null,
F.currentlyUsed,
F.foreignkey_tab,
F.foreignkey_col,
F.foreignkey_cap,
F.foreignkey_int,
F.foreignkey_cond,
F.foreignkey_func,
F.check_integrity,
F.is_sum,
F.foreignkey_uniquename

from tmp_fields F;


drop table tmp_fields;
drop table tmp_tables;


--rpta_column füllen:
select * into temp tmp_rc1
from rpta_column;


create temp table tmp_rpta_column(
 uniquename       varchar(255)   NOT NULL,
   caption          varchar(255),
   srcfieldname     varchar(255),
   column_type      integer,
   col_function     text,
   is_aggregate     smallint,
   resultset_id     integer,
   description      text,
   custom integer default 0
   );

insert into tmp_rpta_column(   uniquename,
       caption,
       srcfieldname,
       column_type,
       col_function,
       is_aggregate,
       resultset_id,
       description)
       select  F.name as  uniquename,
       coalesce(T.caption,T.name) || ' - ' || F.caption,
       F.name as srcfieldname,
       1 as column_type,
       (case when F.is_sum=1 then 'sum' else null::varchar end)  as col_function,
       (case when F.is_sum=1 then 1 else 0 end) as is_aggregate,
       R.tid as resultset_id,
       F.description
from rpta_resultset R, sx_fields F left outer join sx_tables T on (T.name=F.table_name) 
where F.table_name='sos_stud_astat_dashboard'
and R.uniquename='sos_stud_astat_dashboard'
and F.currentlyused=1
;

update rpta_column set 
       caption=T.caption,
       srcfieldname=T.srcfieldname,
       column_type=T.column_type,
       col_function=T.col_function,
       is_aggregate=T.is_aggregate,
       resultset_id=R.tid,
       description=T.description,
       custom=T.custom
       from tmp_rpta_column T, rpta_resultset R
where T.uniquename=rpta_column.uniquename
and rpta_column.resultset_id=R.tid
and R.uniquename='sos_stud_astat_dashboard'
;
insert into rpta_column(   uniquename,
       caption,
       srcfieldname,
       column_type,
       col_function,
       is_aggregate,
       resultset_id,
       description,
       custom)
select T.uniquename,
T.caption,
T.srcfieldname,
T.column_type,
T.col_function,
T.is_aggregate,
R.tid as resultset_id,
T.description,
T.custom
       from tmp_rpta_column T, rpta_resultset R
       where R.uniquename='sos_stud_astat_dashboard'
       and 0=(select count(*) from tmp_rc1 C
       where C.uniquename=T.uniquename
       and C.resultset_id=R.tid)
       ;

drop table tmp_rpta_column;
drop table tmp_rc1;

 --wenn sos_stg_aggr_exists=1
