--freemarker template
--alle berechneten Spalten


<sqlvars>
<sqlvar name="sos_stg_aggr_exists">
select sp_table_exists('sos_stg_aggr') from xdummy;
</sqlvar>
<sqlvar name="fact_table_source">
select name
       from sx_tables where name ='sos_stg_aggr';
       
</sqlvar>
<sqlvar name="logical_fields" type="hashsequence">

drop table if exists rpta_sos_hzb_bland;
create table rpta_sos_hzb_bland as 
select W.astat as wohnsitz_astat, W.bland as wohnsitz_bland, B.druck as bland_druck, B.astat as bland_astat 
from sos_hzb_wohnsitz W, sos_k_bland B where W.bland=B.apnr;
create index ix_wohnsitz_bland on rpta_sos_hzb_bland(wohnsitz_astat);

select 'sos_stud_astat_dashboard' as tablename,
'geschlecht_str' as uniquename ,
'Geschlecht' as caption,
'Geschlecht' as description, 
'sos_k_geschl.druck'::text as log_field,
'sos_k_geschl on (sos_k_geschl.apnr=sos_stg_aggr.geschlecht)' as join_field
from xdummy
union
select 'sos_stud_astat_dashboard' as tablename,
'semester_str' as uniquename ,
'Semester Name' as caption,
'Semester Name' as description, 
'(case when substring(sem_rueck_beur_ein::varchar from 5 for 1)=''''2'''' then ''''WS '''' || substring(sem_rueck_beur_ein::varchar from 3 for 2) || ''''/'''' || lpad('''''''' || val(substring(sem_rueck_beur_ein::varchar from 3 for 2))+1,2,''''0'''') when substring(sem_rueck_beur_ein::varchar from 5 for 1)=''''1'''' then ''''SS '''' || substring(sem_rueck_beur_ein::varchar from 3 for 2) else '''''''' end)'::text as log_field,
'' as join_field
from xdummy
union
select 'sos_stud_astat_dashboard' as tablename,
'hzbstaat_iso3' as uniquename,
'Staat der HZB' as caption,
'Staat der HZB' as description,
'viz_staat_isocode.iso3'::text as log_field,
'viz_staat_isocode on ((viz_staat_isocode.astat=sos_stg_aggr.hzbkfz and sos_stg_aggr.hzbkfzkz=1) or (viz_staat_isocode.astat=0 and sos_stg_aggr.hzbkfzkz=0))' as join_field
from xdummy
union 
select 'sos_stud_astat_dashboard' as tablename,
'dim_studiengang_fak_str' as uniquename ,
'Fakultät' as caption,
'Fakultät (Name)' as description, 
'cifx.kurz'::text as log_field,
'cifx on (cifx.key=90 and cifx.apnr=fb)' as join_field
from xdummy
union
select 'sos_stud_astat_dashboard' as tablename,
'sos_stud_bildungstyp' as uniquename ,
'Bildungsinländer / -ausländer' as caption,
'Bildungsinländer / -ausländer' as description, 
'(case when ca12_staat != 0 and (hzbkfzkz = 1 or (hzbart_int in (''''31'''',''''51'''',''''76'''') and hzbkfzkz = 0) or hzbart_int is null) then ''''Bildungsausländer'''' else ''''Bildungsinländer'''' end)'::text as log_field,
'' as join_field
from xdummy
union 
select 'sos_stud_astat_dashboard' as tablename,
'hzb_bland' as uniquename ,
'Bundesland (HZB)' as caption,
'Bundesland (HZB)' as description, 
'rpta_sos_hzb_bland.bland_druck'::text as log_field,
'rpta_sos_hzb_bland on (rpta_sos_hzb_bland.wohnsitz_astat=sos_stg_aggr.hzbkfz) ' as join_field
from xdummy

;
;

 

</sqlvar>

<sqlvar name="added_tables" type="hashsequence"><![CDATA[
select 1::smallint as sortnr,
name, trim(name) ||'_'   as prefix,
caption,
'dim_studiengang.tid=sos_stg_aggr.tid_stg' as joinclause
       from sx_tables where name  in ('dim_studiengang')
/*union
select 10::smallint as sortnr,
name, trim(name) ||'_'   as prefix,
caption,
'dim_studiengang.stort=sos_k_stort.apnr' as joinclause
       from sx_tables where name  in ('sos_k_stort')
union
select 20::smallint as sortnr,
name, trim(name) ||'_'   as prefix,
caption,
'sos_stg_aggr.stutyp=sos_k_stutyp.apnr' as joinclause
       from sx_tables where name  in ('sos_k_stutyp')
union
select 30::smallint as sortnr,
name, trim(name) ||'_'   as prefix,
caption,
'sos_stg_aggr.stuart=sos_k_stuart.apnr' as joinclause
       from sx_tables where name  in ('sos_k_stuart')
union
select 40::smallint as sortnr,
name, trim(name) ||'_'   as prefix,
caption,
'sos_stg_aggr.stufrm=sos_k_stufrm.apnr' as joinclause
       from sx_tables where name  in ('sos_k_stufrm')
union
select 50::smallint as sortnr,
name, trim(name) ||'_'   as prefix,
caption,
'sos_stg_aggr.hrst=sos_k_hrst.apnr' as joinclause
       from sx_tables where name  in ('sos_k_hrst')*/
order by 1
]]>
</sqlvar>
<sqlvar name="fact_table_fields">
select '(''tid_stg'',''sem_rueck_beur_ein'',''stichtag'',''geschlecht'', ''hzbart'',''hzbart_int'', ''hzbkfz'', ''hzbkfzkz'',''hrst'', ''ca12_staat'', ''fach_sem_zahl'',''hssem'',''studiengang_nr'', ''fach_nr'',''summe'')'
from xdummy;
</sqlvar>
<sqlvar name="added_table_fields">
select '(''fb'', ''abschluss_grp'', ''abschluss_grp_str'', ''fb_str'',''abschluss_astat_bund'')'
from xdummy;
</sqlvar>

<sqlvar name="fields_target" type="hashsequence"><![CDATA[
<#if fact_table_source?exists>
select tid, table_name,
       name,
       name as targetname
       from sx_fields where table_name ='${fact_table_source}'
       and currentlyused=1
       and name in ${fact_table_fields}
       <#foreach added_table in added_tables>
       union
       select tid,table_name,
       name,
       '${added_table.prefix}' || name as targetname
       from sx_fields where table_name ='${added_table.name}'
       and currentlyused=1
       and name in  ${added_table_fields}      
       </#foreach>
       order by 1
</#if>
]]>
</sqlvar>
</sqlvars>


<#if sos_stg_aggr_exists==1 && fact_table_source?exists >

<#assign  fact_table_target = {"name":"sos_stud_astat_dashboard", "caption":"Studierende (Fachsem., HS-Sem., Studiengang) Dashboard"}
   />


CREATE temp table tmp_tables(
name CHAR(255) , 
caption CHAR(255) , 
description CHAR(255) , 
table_type CHAR(255) , 
systeminfo_id INTEGER  , 
systeminfo_orig INTEGER  , 
thema CHAR(255) , 
sachgebiete_id CHAR(255) 
);
CREATE temp TABLE tmp_fields(
tid serial NOT NULL,
table_name VARCHAR(255)  not null, 
name VARCHAR(255)  not null, 
caption VARCHAR(255) , 
description VARCHAR(255) , 
field_type VARCHAR(255)  not null, 
field_size VARCHAR(255)  , 
field_not_null smallint,
currentlyused SMALLINT , 
is_primarykey SMALLINT  default 0 , 
foreignkey_tab VARCHAR(255) , 
foreignkey_col VARCHAR(255) , 
foreignkey_int VARCHAR(255) , 
foreignkey_cap VARCHAR(255) , 
foreignkey_cond VARCHAR(255) , 
foreignkey_func VARCHAR(255) , 
check_integrity SMALLINT, 
is_sum SMALLINT  default 1,
foreignkey_uniquename VARCHAR(255)

);


--Vorbereitung:
UPDATE sx_tables
   SET caption = 'Standorte'
WHERE name='sos_k_stort';
UPDATE sx_tables
   SET caption = 'Studienart'
WHERE name = 'sos_k_stuart';
UPDATE sx_tables
   SET caption = 'Studiumstyp'
WHERE name = 'sos_k_stutyp';
UPDATE sx_tables
   SET caption = 'Studienform'
WHERE name = 'sos_k_stufrm';
UPDATE sx_tables
   SET caption = 'Hörerstatus'
WHERE name = 'sos_k_hrst';



--drop view if exists sos_stud_astat;


drop VIEW sos_k_stutyp;

CREATE VIEW sos_k_stutyp
(
  apnr,
  druck,
  astat
)
AS 
 SELECT cifx.apnr,
    cifx.druck,
    astat
   FROM cifx
  WHERE cifx.key = 40;
  

update sx_fields set 
       is_sum=0
       where table_name='sos_stg_aggr'
       and name!='summe';
update sx_fields set 
       is_sum=1
       where table_name='sos_stg_aggr'
       and name='summe';
       
  
insert into tmp_tables (
name,
caption,
description,
table_type,
systeminfo_id,
thema,
sachgebiete_id
) 
select 
'${fact_table_target.name}',
'${fact_table_target.caption}',
description,
table_type,
systeminfo_id,
thema,
sachgebiete_id
from sx_tables where name='${fact_table_source}'
;


insert into tmp_fields (table_name,
       name,
       caption,
       description,
       field_type,
       field_size,
       field_not_null,
       currentlyused,
       is_primarykey,
       foreignkey_tab,
       foreignkey_col,
       foreignkey_int,
       foreignkey_cap,
       foreignkey_cond,
       foreignkey_func,
       check_integrity,
       is_sum,
       foreignkey_uniquename) 
select  '${fact_table_target.name}' as table_name,
       name,
       caption,
       description,
       field_type,
       field_size,
       field_not_null,
       currentlyused,
       is_primarykey,
       foreignkey_tab,
       foreignkey_col,
       foreignkey_int,
       foreignkey_cap,
       foreignkey_cond,
       foreignkey_func,
       check_integrity,
       is_sum,
       foreignkey_uniquename
       from sx_fields where table_name ='${fact_table_source}'
       and name in ${fact_table_fields}
       and currentlyused=1;
<#foreach added_table in added_tables>
insert into tmp_fields (table_name,
       name,
       caption,
       description,
       field_type,
       field_size,
       field_not_null,
       currentlyused,
       is_primarykey,
       foreignkey_tab,
       foreignkey_col,
       foreignkey_int,
       foreignkey_cap,
       foreignkey_cond,
       foreignkey_func,
       check_integrity,
       is_sum,
       foreignkey_uniquename) 
select  '${fact_table_target.name}' as table_name,
       '${added_table.prefix}' || name,
       '${added_table.caption}: ' || caption,
       description,
       field_type,
       field_size,
       field_not_null,
       currentlyused,
       is_primarykey,
       foreignkey_tab,
       foreignkey_col,
       foreignkey_int,
       foreignkey_cap,
       foreignkey_cond,
       foreignkey_func,
       check_integrity,
       is_sum,
       foreignkey_uniquename
       from sx_fields where table_name ='${added_table.name}'
       and name in ${added_table_fields}
       and currentlyused=1;
</#foreach>
--und berechnete Spalten einfügen
<#foreach logical_field in logical_fields>
insert into tmp_fields (table_name,name,caption,description,field_type,field_size,field_not_null,currentlyUsed,is_sum)
select 
'${logical_field.tablename}', '${logical_field.uniquename}','${logical_field.caption}', '${logical_field.description}', 'CHAR',30, 1, 1,0 from xdummy;
</#foreach>

CREATE temp TABLE tmp_rpta_resultset
(
    caption        varchar(255),
   uniquename     varchar(255),
   fieldclause    text,
   joinclause     text,
   whereclause    text,
   systeminfo_id  integer,
   is_virtual smallint default 1
);

insert into tmp_rpta_resultset(caption,
       uniquename,
       systeminfo_id,
       is_virtual)
       select '${fact_table_target.caption}',
       '${fact_table_target.name}',
       7,
       0
;


update tmp_rpta_resultset set fieldclause='
<#foreach logical_field in logical_fields>
${logical_field.log_field} as ${logical_field.uniquename},
</#foreach>

<#foreach field_target in fields_target>
${field_target.table_name}.${field_target.name} as ${field_target.targetname},
</#foreach>
null::varchar as dummy',
joinclause='${fact_table_source}
<#foreach added_table in added_tables>
left outer join ${added_table.name} on (${added_table.joinclause})
</#foreach>
<#foreach logical_field in logical_fields>
<#if logical_field.join_field?exists && logical_field.join_field !=''>
left outer join ${logical_field.join_field}
</#if>
</#foreach>
';

--whereclause erstmal primitiv
update tmp_rpta_resultset set whereclause = 'and stichtag in (select tid  from sos_stichtag where appl_key=''0'') and hrst in (select apnr from sos_k_hrst HRST where HRST.astat in (''1'',''2'')) and kz_rueck_beur_ein in (1,2,3)';
select * into temp tmp_rs1 
from rpta_resultset
;

update rpta_resultset set caption=T.caption,
       fieldclause=T.fieldclause,
       joinclause=T.joinclause,
       whereclause=T.whereclause,
       is_virtual=T.is_virtual
       from tmp_rpta_resultset T
       where T.systeminfo_id=rpta_resultset.systeminfo_id
       and T.uniquename=rpta_resultset.uniquename
       ;

insert into rpta_resultset(caption,
       uniquename,
       fieldclause,
       joinclause,
       whereclause,
       systeminfo_id,
       is_virtual)
select caption,
       uniquename,
       fieldclause,
       joinclause,
       whereclause,
       systeminfo_id,
       is_virtual
       from tmp_rpta_resultset
       where 0=(select count(*) 
       from tmp_rs1 T
       where T.systeminfo_id=tmp_rpta_resultset.systeminfo_id
       and T.uniquename=tmp_rpta_resultset.uniquename)
       ;
drop table tmp_rpta_resultset;
drop table tmp_rs1;

delete from sx_tables where name
in (select T.name from tmp_tables  T);

insert into sx_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id)
select name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id
from tmp_tables;


delete from sx_fields where table_name
in (select T.table_name from tmp_fields T);

insert into sx_fields (table_name,name,caption,description,field_type,
field_size,
field_not_null,
currentlyUsed,
foreignkey_tab,
foreignkey_col,
foreignkey_cap,
foreignkey_int,
foreignkey_cond,
foreignkey_func,
check_integrity,
is_sum,
foreignkey_uniquename
)
select 
F.table_name,F.name,F.caption,F.description,F.field_type,
F.field_size,
F.field_not_null,
F.currentlyUsed,
F.foreignkey_tab,
F.foreignkey_col,
F.foreignkey_cap,
F.foreignkey_int,
F.foreignkey_cond,
F.foreignkey_func,
F.check_integrity,
F.is_sum,
F.foreignkey_uniquename

from tmp_fields F;


drop table tmp_fields;
drop table tmp_tables;


--rpta_column füllen:
select * into temp tmp_rc1
from rpta_column;


create temp table tmp_rpta_column(
 uniquename       varchar(255)   NOT NULL,
   caption          varchar(255),
   srcfieldname     varchar(255),
   column_type      integer,
   col_function     text,
   is_aggregate     smallint,
   resultset_id     integer,
   description      text,
   custom integer default 0
   );

insert into tmp_rpta_column(   uniquename,
       caption,
       srcfieldname,
       column_type,
       col_function,
       is_aggregate,
       resultset_id,
       description)
       select  F.name as  uniquename,
       coalesce(T.caption,T.name) || ' - ' || F.caption,
       F.name as srcfieldname,
       1 as column_type,
       (case when F.is_sum=1 then 'sum' else null::varchar end)  as col_function,
       (case when F.is_sum=1 then 1 else 0 end) as is_aggregate,
       R.tid as resultset_id,
       F.description
from rpta_resultset R, sx_fields F left outer join sx_tables T on (T.name=F.table_name) 
where F.table_name='${fact_table_target.name}'
and R.uniquename='${fact_table_target.name}'
and F.currentlyused=1
;

update rpta_column set 
       caption=T.caption,
       srcfieldname=T.srcfieldname,
       column_type=T.column_type,
       col_function=T.col_function,
       is_aggregate=T.is_aggregate,
       resultset_id=R.tid,
       description=T.description,
       custom=T.custom
       from tmp_rpta_column T, rpta_resultset R
where T.uniquename=rpta_column.uniquename
and rpta_column.resultset_id=R.tid
and R.uniquename='${fact_table_target.name}'
;
insert into rpta_column(   uniquename,
       caption,
       srcfieldname,
       column_type,
       col_function,
       is_aggregate,
       resultset_id,
       description,
       custom)
select T.uniquename,
T.caption,
T.srcfieldname,
T.column_type,
T.col_function,
T.is_aggregate,
R.tid as resultset_id,
T.description,
T.custom
       from tmp_rpta_column T, rpta_resultset R
       where R.uniquename='${fact_table_target.name}'
       and 0=(select count(*) from tmp_rc1 C
       where C.uniquename=T.uniquename
       and C.resultset_id=R.tid)
       ;

drop table tmp_rpta_column;
drop table tmp_rc1;

</#if> --wenn sos_stg_aggr_exists=1
