--freemarker template
<#include "RPTA-Makros"/>
<sqlvars>
<sqlvar name="rpta_installed">
select count(*) from systeminfo where tid=330;
</sqlvar>
</sqlvars>
<#assign rpta_column_layout = 
{"uniquename":"sos_stud_sem_jahr",
"caption":"Studierende nach Studienjahr",
"rpta_resultset":"sos_stud_astat",
"whereclause":"",
"description":"Studierende nach Studienjahr"
}
   />

<#assign rpta_columns = [
{"uniquename":"jahr",
"caption":"Jahr",
"srcfieldname":"sem_rueck_beur_ein",
"targetfieldname":"jahr",
"column_type":"logicalColumn",
"col_function":"get_akad_jahr(sem_rueck_beur_ein,''A'')",
"is_visible":"1",
"format_code":"",
"visible_size":"5",
"is_aggregate":"0",
"description":"(WS + darauffolgendes SS)"
},
{"uniquename":"semestertyp",
"caption":"Semestertyp",
"srcfieldname":"sem_rueck_beur_ein",
"targetfieldname":"semestertyp",
"column_type":"logicalColumn",
"col_function":"(case when substring('''' || sem_rueck_beur_ein from 5 for 1)=''2'' then ''WiSe'' else ''SoSe'' end)::varchar(255) ",
"is_visible":"1",
"format_code":"",
"visible_size":"5",
"is_aggregate":"0",
"description":"Winter oder Sommersemester"
},
{"uniquename":"summe",
"caption":"Anzahl der Studierenden",
"srcfieldname":"summe",
"column_type":"physicalColumn",
"col_function":"sum",
"is_visible":"1",
"visible_size":"5",
"is_aggregate":"1",
"description":"Summe der Studierenden"
}
]
   />
 
<#if rpta_installed==1>
<@rpta_column_layout_fuellen />
</#if>
