--freemarker template
<#include "RPTA-Makros"/>
<sqlvars>
<sqlvar name="rpta_installed">
select count(*) from systeminfo where tid=330;
</sqlvar>
</sqlvars>
<#assign rpta_column_layout = 
{"uniquename":"sos_stud_ca12_staat",
"caption":"Studierende nach Staatsangehörigkeit",
"rpta_resultset":"sos_stud_astat",
"whereclause":"",
"description":"Studierende nach Staatsangehörigkeit"
}
   />

<#assign rpta_columns = [
{"uniquename":"staat_iso3",
"caption_der_spalte":"Staatsangehörigkeit (ISO Code)",
"caption_in_ergebnistabelle":"Staatsangehörigkeit",
"srcfieldname":"ca12_staat",
"targetfieldname":"staat_iso3",
"column_type":"lookupColumn",
"col_function":"select I.iso3 from viz_staat_isocode I where I.astat=ca12_staat",
"is_visible":"1",
"format_code":"",
"visible_size":"5",
"is_aggregate":"0",
"description":"Staat (ISO Code)"
},
{"uniquename":"ca12staat",
"caption_der_spalte":"Staatsangehörigkeit (Schlüssel)",
"caption_in_ergebnistabelle":"Staatsangehörigkeit (Schlüssel)",
"srcfieldname":"ca12_staat",
"targetfieldname":"ca12_staat",
"column_type":"physicalColumn",
"col_function":"",
"is_visible":"0",
"format_code":"",
"visible_size":"5",
"is_aggregate":"0",
"description":"Staat (ASTAT Code)"
},
{"uniquename":"ca12staat_str",
"caption_der_spalte":"Staatsangehörigkeit (Name des Staates)",
"caption_in_ergebnistabelle":"Staatsangehörigkeit (Name des Staates)",
"srcfieldname":"ca12_staat",
"targetfieldname":"ca12staat_str",
"column_type":"lookupColumn",
"col_function":"select C2.druck from cif C2 where C2.key=12 and C2.apnr=ca12_staat",
"is_visible":"1",
"format_code":"",
"visible_size":"15",
"is_aggregate":"0",
"description":"Staat (Name)"
},
{"uniquename":"summe",
"caption":"Anzahl der Studierenden",
"srcfieldname":"summe",
"column_type":"physicalColumn",
"col_function":"sum",
"is_visible":"1",
"visible_size":"5",
"is_aggregate":"1",
"description":"Summe der Studierenden"
}
]
   />
 
<#if rpta_installed==1>
<@rpta_column_layout_fuellen />
</#if>
