--freemarker template
<sqlvars>
<sqlvar name="rpta_installed">
select count(*) from systeminfo where tid=330;
</sqlvar>
</sqlvars>
<#assign rpta_column_layout = 
{"uniquename":"sos_stud_hzb_bland_dashboard",
"caption":"Studierende nach HZB-Bundesland DB",
"rpta_resultset":"sos_stud_astat_dashboard",
"whereclause":"",
"description":"Studierende nach HZB-Bundesland für Dashboard"
}
   />

<#assign rpta_columns = [
{"uniquename":"hzb_bland",
"caption":"Bundesland (HZB)",
"srcfieldname":"hzb_bland",
"targetfieldname":"hzb_bland",
"column_type":"physicalColumn",
"col_function":"",
"is_visible":"1",
"format_code":"",
"visible_size":"5",
"is_aggregate":"0",
"description":"Bundesland (HZB)"
},
{"uniquename":"summe",
"caption":"Anzahl der Studierenden",
"srcfieldname":"summe",
"column_type":"physicalColumn",
"col_function":"sum",
"is_visible":"1",
"visible_size":"5",
"is_aggregate":"1",
"description":"Summe der Studierenden"
}
]
   />
 
<#if rpta_installed==1>
    ---ab hier nicht mehr ändern:
   
CREATE temp TABLE tmp_rpta_column
(
   uniquename       varchar(255)   NOT NULL,
   caption          varchar(255),
   srcfieldname     varchar(255),
   targetfieldname  varchar(255),
   column_type      integer,
   col_function     text,
   is_visible       smallint,
   visible_size     smallint,
   is_aggregate     smallint,
   resultset_id     integer,
   sortnr integer,
   description TEXT
);

CREATE temp TABLE tmp_rpta_column_layout
(
    uniquename    varchar(255)   NOT NULL,
   caption       varchar(255),
   resultset_id  integer,
   whereclause text,
   description text
);

insert into tmp_rpta_column_layout(
resultset_id,
uniquename,
caption,
whereclause,
  description
)
select tid,
'${rpta_column_layout.uniquename}',
'${rpta_column_layout.caption}',
'${rpta_column_layout.whereclause}',
'${rpta_column_layout.description}'
FROM rpta_resultset
where uniquename='${rpta_column_layout.rpta_resultset}';

<#assign sortnr=0 />
<#foreach column in rpta_columns>
<#assign sortnr=sortnr +1 />

INSERT INTO tmp_rpta_column
(resultset_id,
  uniquename,
  caption,
  srcfieldname,
  targetfieldname,
  column_type,
  col_function,
  is_visible,
  visible_size,
  is_aggregate,
  sortnr,
  description
  )
select R.tid,
'${column.uniquename}',
'${column.caption}',
'${column.srcfieldname}',
<#if !column.targetfieldname?exists || column.targetfieldname=="">null::varchar <#else>'${column.targetfieldname}' </#if>,
T.tid as column_type,
'${column.col_function}',
${column.is_visible},
${column.visible_size},
${column.is_aggregate},
${sortnr*10},
'${column.description}'
FROM rpta_resultset R, rpta_column_type T
where R.uniquename='${rpta_column_layout.rpta_resultset}'
and T.uniquename='${column.column_type}';

</#foreach>


select * into temp tmp_rpta_column2layout
from rpta_column2layout
where layout_id in (select L.tid
from rpta_column_layout L,rpta_resultset R
where R.tid=L.resultset_id 
and R.uniquename='${rpta_column_layout.rpta_resultset}'
and L.uniquename='${rpta_column_layout.uniquename}'
)
; 
  
select * into temp tmp_rpta_column_layout_target
from rpta_column_layout
where resultset_id in (select tid
FROM rpta_resultset
where uniquename='${rpta_column_layout.rpta_resultset}')
and uniquename in (select uniquename from tmp_rpta_column_layout)
;

insert into rpta_column_layout
(uniquename,
       caption,
       resultset_id,
       whereclause,
  description)
 select uniquename,
       caption,
       resultset_id,
       whereclause,
  description
FROM tmp_rpta_column_layout T
where 0=(select count(*) from tmp_rpta_column_layout_target T2
where T.uniquename=T2.uniquename);

drop table tmp_rpta_column_layout_target;

delete from rpta_column2layout
where layout_id in (select L.tid
from rpta_column_layout L,rpta_resultset R
where R.tid=L.resultset_id 
and R.uniquename='${rpta_column_layout.rpta_resultset}'
and L.uniquename='${rpta_column_layout.uniquename}'
)
; 

select * into temp tmp_rpta_column2 
from tmp_rpta_column T 
where (resultset_id,uniquename) not in
(select resultset_id,uniquename from rpta_column);

INSERT INTO rpta_column
(resultset_id,
  uniquename,
  caption,
  srcfieldname,
  targetfieldname,
  column_type,
  col_function,
  is_aggregate,
  description,
  custom
  )
  select 
resultset_id,
  uniquename,
  caption,
  srcfieldname,
  targetfieldname,
  column_type,
  col_function,
  is_aggregate,
  description,
  0 as custom
from tmp_rpta_column2; 

--evtl. neuen Satz einfügen, dann alle updaten

update rpta_column set (  caption,
  srcfieldname,
  targetfieldname,
  column_type,
  col_function,
  is_aggregate,
  description)
  = (select   caption,
  srcfieldname,
  targetfieldname,
  column_type,
  col_function,
  is_aggregate,
  description
  from tmp_rpta_column T
  where T.resultset_id=rpta_column.resultset_id
  and T.uniquename=rpta_column.uniquename)
  where custom=0
  and  (resultset_id,uniquename) in
(select T.resultset_id,T.uniquename
from tmp_rpta_column T)
;

drop table tmp_rpta_column2;

insert into rpta_column2layout(column_id,
       layout_id,
       sortnr,
       is_visible,
       visible_size,
       caption,
  description)
select C.tid as column_id,
       L.tid as layout_id,
       T.sortnr,
       T.is_visible,
       T.visible_size,
       T.caption,
  T.description
FROM rpta_column C,  rpta_column_layout L, tmp_rpta_column T
where C.uniquename=T.uniquename
and C.resultset_id=T.resultset_id
and L.uniquename='${rpta_column_layout.uniquename}'
and L.resultset_id=T.resultset_id
 ;
drop table tmp_rpta_column;
drop TABLE tmp_rpta_column_layout;
drop TABLE tmp_rpta_column2layout;
</#if>
