--freemarker template
<#include "RPTA-Makros"/>
<sqlvars>
<sqlvar name="sos_stud_astat_exists">
select count(*) from rpta_resultset where uniquename='sos_stud_astat';
</sqlvar>
</sqlvars>
<#assign rpta_column_layout = {"uniquename":"sos_stud_nach_alter",
"caption":"Studierende nach Alter",
"rpta_resultset":"sos_stud_astat",
"whereclause":"",
"description":"Studierende nach Alter"
}
   />

<#assign rpta_columns = [
{"uniquename":"alter",
"caption":"Alter",
"srcfieldname":"alter",
"targetfieldname":"",
"column_type":"physicalColumn",
"col_function":"",
"is_visible":"1",
"format_code":"INTEGER",
"visible_size":"5",
"is_aggregate":"0",
"description":"Alter in Jahren"
},
{"uniquename":"geschlecht",
"caption":"Geschlecht",
"srcfieldname":"geschlecht",
"targetfieldname":"",
"column_type":"logicalColumn",
"col_function":"(select druck from cif where key=9003 and apnr=geschlecht)",
"is_visible":"1",
"format_code":"",
"visible_size":"5",
"is_aggregate":"0",
"description":"Geschlecht"
},
{"uniquename":"geschlecht_schl",
"caption":"Geschlecht (Schlüssel)",
"srcfieldname":"geschlecht",
"targetfieldname":"geschlecht_schl",
"column_type":"logicalColumn",
"col_function":"geschlecht",
"is_visible":"1",
"format_code":"",
"visible_size":"5",
"is_aggregate":"0",
"description":"Geschlecht (Schlüssel)"
},
{"uniquename":"matrikel_nr",
"caption":"Matrikelnummer",
"srcfieldname":"matrikel_nr",
"column_type":"physicalColumn",
"col_function":"",
"is_visible":"1",
"format_code":"INT_NO_SEP",
"visible_size":"5",
"is_aggregate":"0",
"description":"Matrikelnr."
},
{"uniquename":"summe",
"caption":"Anzahl der Studierenden",
"srcfieldname":"summe",
"column_type":"physicalColumn",
"col_function":"sum",
"is_visible":"1",
"visible_size":"5",
"is_aggregate":"1",
"description":"Summe der Studierenden"
}
]
   />
  
<@rpta_column_layout_fuellen />
