--freemarker template
<#include "RPTA-Makros"/>
<sqlvars>
<sqlvar name="rpta_installed">
select count(*) from systeminfo where tid=330;
</sqlvar>
</sqlvars>
<#assign rpta_column_layout = 
{"uniquename":"sos_stud_hmkfz_lkreis",
"caption":"Studierende nach Landkreis (Heimatanschrift)",
"rpta_resultset":"sos_stud_astat",
"whereclause":"",
"description":"Studierende nach Landkreis (Heimatanschrift)"
}
   />

<#assign rpta_columns = [
{"uniquename":"hmkfz_lkreis",
"caption":"Landkreis (Heimatanschrift)",
"srcfieldname":"",
"targetfieldname":"hmkfz_lkreis",
"column_type":"logicalColumn",
"col_function":"case when (hmkfzkz=0 and hmkfz is not null and hmkfz<>-9999) then (select text from sos_k_kfz where ikfz::integer=hmkfz)  else ''unbekannt/ außerhalb BRD'' end",
"is_visible":"1",
"format_code":"",
"visible_size":"5",
"is_aggregate":"0",
"description":"Landkreis (Heimatanschrift)"
},
{"uniquename":"summe",
"caption":"Anzahl der Studierenden",
"srcfieldname":"summe",
"column_type":"physicalColumn",
"col_function":"sum",
"is_visible":"1",
"visible_size":"5",
"is_aggregate":"1",
"description":"Summe der Studierenden"
}
]
   />
 
<#if rpta_installed==1>
<@rpta_column_layout_fuellen />
</#if>
