--freemarker template
<#include "RPTA-Makros"/>
<sqlvars>
<sqlvar name="rpta_installed">
select count(*) from systeminfo where tid=330;
</sqlvar>
</sqlvars>
<#assign rpta_column_layout = 
{"uniquename":"sos_stud_hzb_staat",
"caption":"Studierende nach Staat der HZB",
"rpta_resultset":"sos_stud_astat",
"whereclause":"",
"description":"Studierende nach Staat der HZB"
}
   />

<#assign rpta_columns = [
{"uniquename":"hzbstaat_iso3",
"caption":"Staat der HZB",
"srcfieldname":"hzbkfz",
"targetfieldname":"staat_iso3",
"column_type":"lookupColumn",
"col_function":"select I.iso3 from viz_staat_isocode I where I.astat=hzbkfz and hzbkfzkz=1 union select I.iso3 from viz_staat_isocode I where I.astat=0 and hzbkfzkz=0",
"is_visible":"1",
"format_code":"",
"visible_size":"5",
"is_aggregate":"0",
"description":"Staat (ISO Code)"
},
{"uniquename":"summe",
"caption":"Anzahl der Studierenden",
"srcfieldname":"summe",
"column_type":"physicalColumn",
"col_function":"sum",
"is_visible":"1",
"visible_size":"5",
"is_aggregate":"1",
"description":"Summe der Studierenden"
}
]
   />
 
<#if rpta_installed==1>
<@rpta_column_layout_fuellen />
</#if>
