--freemarker template
<#include "RPTA-Makros"/>
<sqlvars>
<sqlvar name="rpta_installed">
select count(*) from systeminfo where tid=330;
</sqlvar>
</sqlvars>
<#assign rpta_column_layout = 
{"uniquename":"sos_stud_geschl_dashboard",
"caption":"Studierende nach Geschlecht DB",
"rpta_resultset":"sos_stud_astat_dashboard",
"whereclause":"",
"description":"Studierende nach Geschlecht für Dashboard",
"is_virtual":1
}
   />


<#assign rpta_columns = [
{"uniquename":"geschlecht",
"caption":"Geschlecht (Schlüssel)",
"srcfieldname":"geschlecht",
"targetfieldname":"geschlecht",
"column_type":"physicalColumn",
"col_function":"",
"is_visible":"0",
"format_code":"",
"visible_size":"5",
"is_aggregate":"0",
"description":"Geschlecht"
},
{"uniquename":"geschlecht_str",
"caption":"Geschlecht",
"srcfieldname":"geschlecht_str",
"targetfieldname":"geschlecht_str",
"column_type":"physicalColumn",
"col_function":"",
"is_visible":"1",
"format_code":"",
"visible_size":"5",
"is_aggregate":"0",
"description":"Geschlecht"
},
{"uniquename":"sem_rueck_beur_ein",
"caption":"Semester",
"srcfieldname":"sem_rueck_beur_ein",
"targetfieldname":"",
"column_type":"physicalColumn",
"col_function":"",
"is_visible":"1",
"format_code":"",
"visible_size":"5",
"is_aggregate":"0",
"description":"Semester"
},
{"uniquename":"summe",
"caption":"Anzahl der Studierenden",
"srcfieldname":"summe",
"targetfieldname":"summe",
"column_type":"physicalColumn",
"col_function":"sum",
"is_visible":"1",
"visible_size":"5",
"is_aggregate":"1",
"description":"Summe der Studierenden"
},
{"uniquename":"anteil",
"caption":"Anteil der Studierenden (in %)",
"srcfieldname":"",
"targetfieldname":"anteil",
"column_type":"computedColumn",
"col_function":"(select (summe::float/(select G.summe from tmp_gesamt G)*100)::integer)",
"is_visible":"1",
"visible_size":"5",
"is_aggregate":"0",
"description":"Anteil in % der Studierenden"
}
]
   />
 
<#if rpta_installed==1>
<@rpta_column_layout_fuellen />
</#if>
