--freemarker template
<#include "RPTA-Makros"/>
<sqlvars>
<sqlvar name="rpta_installed">
select count(*) from systeminfo where tid=330;
</sqlvar>
</sqlvars>
<#assign rpta_column_layout = {"uniquename":"sos_stud_fak_abschl_fach",
"caption":"Studierende nach Fakultät, Abschlussgruppe und Fach",
"rpta_resultset":"sos_stud_astat",
"whereclause":"",
"description":"Studierende nach Fakultät, Abschlussgruppe und Fach"
}
   />

<#assign rpta_columns = [
{"uniquename":"dim_studiengang_fak",
"caption":"Fakultät (Schlüssel)",
"srcfieldname":"dim_studiengang_fb",
"column_type":"physicalColumn",
"col_function":"",
"is_visible":"1",
"visible_size":"10",
"is_aggregate":"0",
"description":"Fakultät (Schlüssel)"
},
{"uniquename":"dim_studiengang_fak_str",
"caption":"Fakultät",
"srcfieldname":"dim_studiengang_fb_str",
"column_type":"lookupColumn",
"col_function":"select C.kurz from cifx C where C.key=90 and C.apnr=dim_studiengang_fb",
"is_visible":"1",
"visible_size":"10",
"is_aggregate":"0",
"description":"Fakultät (Name)"
},
{"uniquename":"dim_studiengang_abschluss_grp_str",
"caption":"Abschlussgruppe",
"srcfieldname":"dim_studiengang_abschluss_grp_str",
"column_type":"physicalColumn",
"col_function":"",
"is_visible":"1",
"visible_size":"10",
"is_aggregate":"0",
"description":"Abschlussgruppe"
},
{"uniquename":"dim_studiengang_stg_str",
"caption":"Fach",
"srcfieldname":"dim_studiengang_stg_str",
"column_type":"physicalColumn",
"col_function":"",
"is_visible":"1",
"visible_size":"10",
"is_aggregate":"0",
"description":"Fach (Name)"
},
{"uniquename":"summe",
"caption":"Anzahl der Studierenden",
"srcfieldname":"summe",
"column_type":"physicalColumn",
"col_function":"sum",
"is_visible":"1",
"visible_size":"5",
"is_aggregate":"1",
"description":"Summe der Studierenden"
},
{"uniquename":"anteil",
"caption":"Anteil der Studierenden (in %)",
"srcfieldname":"",
"targetfieldname":"anteil",
"column_type":"computedColumn",
"col_function":"(select (summe::float/(select G.summe from tmp_gesamt G)*100)::integer)",
"is_visible":"1",
"visible_size":"5",
"is_aggregate":"0",
"description":"Anteil in % der Studierenden"
}
]
   />
 
<#if rpta_installed==1>
<@rpta_column_layout_fuellen />
</#if>
