--freemarker template
<#include "RPTA-Makros"/>
<sqlvars>
<sqlvar name="rpta_installed">
select count(*) from systeminfo where tid=330;
</sqlvar>
</sqlvars>
<#assign rpta_column_layout = 
{"uniquename":"sos_stud_hzb_bland_dashboard",
"caption":"Studierende nach Bundesland (HZB)",
"rpta_resultset":"sos_stud_astat_dashboard",
"whereclause":"",
"description":"Studierende nach Bundesland (HZB) für Dashboard"
}
   />

<#assign rpta_columns = [
{"uniquename":"hzb_bland",
"caption":"Bundesland (HZB)",
"srcfieldname":"",
"targetfieldname":"hzb_bland",
"column_type":"logicalColumn",
"col_function":"case when (hzbkfzkz=0 and hzbkfz is not null and hzbkfz<>-9999 ) then (select coalesce(B.druck,''Unbekannt'') from sos_hzb_wohnsitz W, sos_k_bland B where W.bland=B.apnr and W.astat=hzbkfz)  else ''Unbekannt/ Ausland'' end",
"is_visible":"1",
"format_code":"",
"visible_size":"5",
"is_aggregate":"0",
"description":"Bundesland (HZB)"
},
{"uniquename":"summe",
"caption":"Anzahl der Studierenden",
"srcfieldname":"summe",
"column_type":"physicalColumn",
"col_function":"sum",
"is_visible":"1",
"visible_size":"5",
"is_aggregate":"1",
"description":"Summe der Studierenden"
}
]
   />
 
<#if rpta_installed==1>
<@rpta_column_layout_fuellen />
</#if>
