--freemarker template
<#include "RPTA-Makros"/>
<sqlvars>
<sqlvar name="rpta_installed">
select count(*) from systeminfo where tid=330;
</sqlvar>
</sqlvars>
<#assign rpta_column_layout = {"uniquename":"sos_stud_bildungstyp_dashboard",
"caption":"Studierende Bildungstyp",
"rpta_resultset":"sos_stud_astat_dashboard",
"whereclause":"",
"description":"Studierende Bildungsinländer / -ausländer "
}
   />

<#assign rpta_columns = [
{"uniquename":"sos_stud_bildungstyp",
"caption":"Bildungsinländer / -ausländer",
"srcfieldname":"",
"targetfieldname":"sos_stud_bildungstyp",
"column_type":"logicalColumn",
"col_function":"case when ca12_staat != 0 and (hzbkfzkz = 1 or (hzbart_int in (''31'',''51'',''76'') and hzbkfzkz = 0) or hzbart_int is null) then ''Bildungsausländer'' else ''Bildungsinländer'' end",
"is_visible":"1",
"visible_size":"10",
"is_aggregate":"0",
"description":"Bildungsinländer / -ausländer"
},
{"uniquename":"summe",
"caption":"Anzahl der Studierenden",
"srcfieldname":"summe",
"column_type":"physicalColumn",
"col_function":"sum",
"is_visible":"1",
"visible_size":"5",
"is_aggregate":"1",
"description":"Summe der Studierenden"
},
{"uniquename":"anteil",
"caption":"Anteil der Studierenden (in %)",
"srcfieldname":"",
"targetfieldname":"anteil",
"column_type":"computedColumn",
"col_function":"(select (summe::float/(select G.summe from tmp_gesamt G)*100)::integer)",
"is_visible":"1",
"visible_size":"5",
"is_aggregate":"0",
"description":"Anteil in % der Studierenden"
}
]
   />
 
<#if rpta_installed==1>
<@rpta_column_layout_fuellen />
</#if>
