--freemarker template
<#include "RPTA-Makros"/>
<sqlvars>
<sqlvar name="rpta_installed">
select count(*) from systeminfo where tid=330;
</sqlvar>
</sqlvars>
<#assign rpta_column_layout = {"uniquename":"sos_stud_bildungstyp_dashboard",
"caption":"Studierende Bildungstyp DB",
"rpta_resultset":"sos_stud_astat_dashboard",
"whereclause":"",
"description":"Studierende Bildungsinländer / -ausländer für Dashboard"
}
   />

<#assign rpta_columns = [
{"uniquename":"sos_stud_bildungstyp",
"caption":"Bildungsinländer / -ausländer",
"srcfieldname":"sos_stud_bildungstyp",
"targetfieldname":"sos_stud_bildungstyp",
"column_type":"physicalColumn",
"col_function":"",
"is_visible":"1",
"visible_size":"10",
"is_aggregate":"0",
"description":"Bildungsinländer / -ausländer"
},
{"uniquename":"summe",
"caption":"Anzahl der Studierenden",
"srcfieldname":"summe",
"column_type":"physicalColumn",
"col_function":"sum",
"is_visible":"1",
"visible_size":"5",
"is_aggregate":"1",
"description":"Summe der Studierenden"
},
{"uniquename":"anteil",
"caption":"Anteil der Studierenden (in %)",
"srcfieldname":"",
"targetfieldname":"anteil",
"column_type":"computedColumn",
"col_function":"(select (summe::float/(select G.summe from tmp_gesamt G)*100)::integer)",
"is_visible":"1",
"visible_size":"5",
"is_aggregate":"0",
"description":"Anteil in % der Studierenden"
}
]
   />
 
<#if rpta_installed==1>
<@rpta_column_layout_fuellen />
</#if>
