--freemarker template
<#include "RPTA-Makros"/>
<sqlvars>
<sqlvar name="rpta_installed">
select count(*) from systeminfo where tid=330;
</sqlvar>
</sqlvars>
<#assign rpta_column_layout = 
{"uniquename":"rpta_sos_lab_aggr_sem",
"caption":"Absolvierende nach Semester",
"rpta_resultset":"rpta_sos_lab_aggr",
"whereclause":"",
"description":"Absolvierende nach Semester",
"is_virtual":1
}
   />

<#assign rpta_columns = [
{"uniquename":"sem_der_pruefung",
"caption":"Semester (Schlüssel)",
"srcfieldname":"sem_der_pruefung",
"targetfieldname":"sem_der_pruefung",
"column_type":"physicalColumn",
"col_function":"",
"is_visible":"0",
"format_code":"TEXT",
"visible_size":"5",
"is_aggregate":"0",
"description":""
},
{"uniquename":"semester_str",
"caption":"Semester Name",
"srcfieldname":"sem_der_pruefung",
"targetfieldname":"semester_str",
"column_type":"logicalColumn",
"col_function":"(case when substring(sem_der_pruefung::varchar from 5 for 1)=''2'' then ''WS '' || substring(sem_der_pruefung::varchar from 3 for 2) || ''/'' || lpad('''' || val(substring(sem_der_pruefung::varchar from 3 for 2))+1,2,''0'')
when substring(sem_der_pruefung::varchar from 5 for 1)=''1'' then ''SS '' || substring(sem_der_pruefung::varchar from 3 for 2)
else '''' end)",
"is_visible":"1",
"format_code":"",
"visible_size":"5",
"is_aggregate":"0",
"description":""
},
{"uniquename":"summe",
"caption":"Anzahl der Absolvierenden",
"srcfieldname":"summe",
"column_type":"physicalColumn",
"col_function":"sum",
"is_visible":"1",
"visible_size":"5",
"is_aggregate":"1",
"description":"Summe der Absolvierenden"
}
]
   />
 
<#if rpta_installed==1>
<@rpta_column_layout_fuellen />
</#if>
