--freemarker template
<#include "RPTA-Makros"/>
<sqlvars>
<sqlvar name="rpta_installed">
select count(*) from systeminfo where tid=330;
</sqlvar>
</sqlvars>
<#assign rpta_column_layout = 
{"uniquename":"rpta_sos_lab_aggr_abgrp_sem",
"caption":"Absolvierende nach Abschlussgruppe und Semester",
"rpta_resultset":"rpta_sos_lab_aggr",
"whereclause":"",
"description":"Absolvierende nach Abschlussgruppe und Semester",
"is_virtual":1
}
   />

   
<#assign rpta_columns = [
{"uniquename":"sem_der_pruefung",
"caption":"Semester (Schlüssel)",
"srcfieldname":"sem_der_pruefung",
"targetfieldname":"sem_der_pruefung",
"column_type":"physicalColumn",
"col_function":"",
"is_visible":"0",
"format_code":"TEXT",
"visible_size":"5",
"is_aggregate":"0",
"description":""
},
{"uniquename":"semester_str",
"caption":"Semester",
"srcfieldname":"sem_der_pruefung",
"targetfieldname":"semester_str",
"column_type":"logicalColumn",
"col_function":"(case when substring(sem_der_pruefung::varchar from 5 for 1)=''2'' then ''WS '' || substring(sem_der_pruefung::varchar from 3 for 2) || ''/'' || lpad('''' || val(substring(sem_der_pruefung::varchar from 3 for 2))+1,2,''0'')
when substring(sem_der_pruefung::varchar from 5 for 1)=''1'' then ''SS '' || substring(sem_der_pruefung::varchar from 3 for 2)
else '''' end)",
"is_visible":"1",
"format_code":"",
"visible_size":"5",
"is_aggregate":"0",
"description":""
},

{"uniquename":"absolv_ba",
"caption_der_spalte":"BA",
"caption_in_ergebnistabelle":"Bachelor",
"srcfieldname":"",
"targetfieldname":"absolv_ba",
"column_type":"logicalColumn",
"col_function":"(case when dim_studiengang_abschlussart=''A24'' and dim_studiengang_abschluss_astat_bund in (select K.abschluss_astat_bund from k_astat_abschl_grp K where ist_lehramt=0) then summe
 else 0 end)",
"is_visible":"1",
"visible_size":"10",
"is_aggregate":"1",
"description":"Absolv. Bachelor ohne Lehramt"
},
{"uniquename":"absolv_ba_la",
"caption_der_spalte":"LA BA",
"caption_in_ergebnistabelle":"Bachelor Lehramt",
"srcfieldname":"",
"targetfieldname":"absolv_ba_la",
"column_type":"logicalColumn",
"col_function":"(case when dim_studiengang_abschlussart=''A24'' and dim_studiengang_abschluss_astat_bund in (select K.abschluss_astat_bund from k_astat_abschl_grp K where ist_lehramt=1) then summe
 else 0 end)",
"is_visible":"1",
"visible_size":"10",
"is_aggregate":"1",
"description":"Absolv. Bachelor Lehramt"
},
{"uniquename":"absolv_ma",
"caption_der_spalte":"MA",
"caption_in_ergebnistabelle":"Master",
"srcfieldname":"",
"targetfieldname":"absolv_ma",
"column_type":"logicalColumn",
"col_function":"(case when dim_studiengang_abschlussart=''A37'' and dim_studiengang_abschluss_astat_bund in (select K.abschluss_astat_bund from k_astat_abschl_grp K where ist_lehramt=0) then summe
 else 0 end)",
"is_visible":"1",
"visible_size":"10",
"is_aggregate":"1",
"description":"Absolv. Master"
},
{"uniquename":"absolv_ma_la",
"caption_der_spalte":"MA LA",
"caption_in_ergebnistabelle":"Master Lehramt",
"srcfieldname":"",
"targetfieldname":"absolv_ma_la",
"column_type":"logicalColumn",
"col_function":"(case when dim_studiengang_abschlussart=''A37'' and dim_studiengang_abschluss_astat_bund in (select K.abschluss_astat_bund from k_astat_abschl_grp K where ist_lehramt=1) then summe
 else 0 end)",
"is_visible":"1",
"visible_size":"10",
"is_aggregate":"1",
"description":"Absolv. Master Lehramt"
},
{"uniquename":"absolv_prom",
"caption_der_spalte":"Promotion",
"caption_in_ergebnistabelle":"Promotion",
"srcfieldname":"",
"targetfieldname":"absolv_prom",
"column_type":"logicalColumn",
"col_function":"(case when dim_studiengang_abschlussart=''G_Prom''  then summe else 0 end)",
"is_visible":"1",
"visible_size":"10",
"is_aggregate":"1",
"description":"Absolv. Promotion"
}

]
   />
 
<#if rpta_installed==1>

<@rpta_column_layout_fuellen />
</#if>
