--freemarker template
<#if SQLdialect='Postgres'>
<#assign texttype="text" />
<#else>
EXECUTE PROCEDURE IFX_ALLOW_NEWLINE('T');
<#assign texttype="lvarchar" />
</#if>
<#assign newline="'
'" />


create table tmp_konstanten
  (
    tid serial,
    apnr integer,
    beschreibung char(255),
	defaultvalue integer,
	description   ${texttype},
	systeminfo_id integer,
	doku_link varchar(255),
	read_only integer,
	wertebereich varchar(250),
	ab_version varchar(10),
	gruppe varchar(255),
	sachgebiete_id integer
  );
insert into tmp_konstanten(apnr,
beschreibung,
 defaultvalue,
 description,
 systeminfo_id,
 doku_link,
 read_only,
 wertebereich,
 ab_version,
 gruppe,
 sachgebiete_id)
 values (20,
'VIZ_ZEITR_SEM_ANZ',
 20,
'Anzahl Semester rückwirkend in Zeitreihen',
320,
 'https://www.superx-projekt.de/doku/viz_modul/admin/f_Konstanten.htm',--doku link
0,
'',
 '>0.3',
 'Datenquelle, Entladestartzeitpunkt, -umfang',
 320);

--vorhandene Schlüssel Metadaten updaten:

<#if SQLdialect='Postgres'>
--Postgres Dialekt:
update konstanten set defaultvalue=T.defaultvalue,
description=T.description,
systeminfo_id=T.systeminfo_id ,
doku_link=T.doku_link,
read_only=T.read_only ,
wertebereich=T.wertebereich,
ab_version=T.ab_version,
gruppe=T.gruppe ,
sachgebiete_id=T.sachgebiete_id
from tmp_konstanten T
where T.beschreibung=konstanten.beschreibung;

<#else>

--Informix Dialekt:
update konstanten set (defaultvalue,
 description,
 systeminfo_id,
 doku_link,
 read_only,
 wertebereich,
  ab_version,
 gruppe,
 sachgebiete_id)
       = ((select
       defaultvalue,
 description,
 systeminfo_id,
 doku_link,
 read_only,
 wertebereich,
  ab_version,
 gruppe,
 sachgebiete_id
from tmp_konstanten T
where T.beschreibung=konstanten.beschreibung));


</#if>

delete from tmp_konstanten where beschreibung in (select beschreibung from konstanten);

create temp table tmp_hilf (tid integer);
insert into tmp_hilf select max(tid) from konstanten;
update tmp_hilf set tid=0 where tid is null;


insert into konstanten(tid , 
apnr ,beschreibung,
 defaultvalue,
 description,
 systeminfo_id,
 doku_link,
 read_only,
 wertebereich,
 ab_version,
 gruppe,
 sachgebiete_id )
select H.tid+K.tid ,
K.apnr ,
K.beschreibung,
 K.defaultvalue,
 K.description,
 K.systeminfo_id,
 K.doku_link,
 K.read_only,
 K.wertebereich,
 K.ab_version,
 K.gruppe,
 K.sachgebiete_id
from tmp_konstanten  K, tmp_hilf H;

drop table tmp_hilf;
drop table tmp_konstanten;

