-- XML-generiertes SQL-Script fuer -- von dimension_fuellen.xsl
--freemarker template
--(c) 2008 Daniel Quathamer
<sqlvars>
<sqlvar name="dimension_exists">
select sp_table_exists('dimension') from xdummy;

</sqlvar>

</sqlvars>
<#if dimension_exists=1>

 

create temp table tmp_dimension(
tid integer,
dimension_bp_id INTEGER  not null, 
fact_table VARCHAR(255) , 
d_akt_von DATE , 
d_akt_bis DATE , 
name VARCHAR(255) , 
druck VARCHAR(255) , 
lang_1 VARCHAR(255) , 
lang_2 VARCHAR(255) , 
lang_3 VARCHAR(255) , 
sourcefilter VARCHAR(255),
system_key VARCHAR(255) 

);



--Vorhandene Schlüssel werden ersetzt, nicht vorhandene Schlüssel bleiben:

--vorhandene Schlüssel ermitteln:
update tmp_dimension set tid=(select tid from 
dimension D where D.fact_table=tmp_dimension.fact_table
and D.system_key=tmp_dimension.system_key);

--vorhandene Schlüssel updaten:

<#if SQLdialect='Postgres'>
--Postgres Dialekt:
update dimension set dimension_bp_id=D.dimension_bp_id, 
d_akt_von=D.d_akt_von, 
d_akt_bis=D.d_akt_bis , 
name=D.name , 
druck=D.druck , 
lang_1=D.lang_1 , 
lang_2=D.lang_2 , 
lang_3=D.lang_3 , 
sourcefilter=D.sourcefilter
from tmp_dimension D
where D.tid is not null
and D.tid=dimension.tid;

<#else>

--Informix Dialekt:
update dimension set (dimension_bp_id,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter) 
       = ((select 
       dimension_bp_id,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter
from tmp_dimension D
where D.tid=dimension.tid))
where tid in (select D.tid from tmp_dimension D);


</#if>

--neue Schlüssel:
insert into dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select dimension_bp_id,
       fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key
       from tmp_dimension
       where tid is null;
       
       
--gelöschte Dimensionen:
delete from dimension 
where fact_table in (select fact_table from tmp_dimension)
and 0 = (select count(*) from tmp_dimension D
where D.system_key=dimension.system_key);

drop table tmp_dimension;



</#if>

