<sqlvars> 
<sqlvar name="man_catalogue_exists">
select sp_table_exists('man_catalogue') from xdummy;
</sqlvar>
<sqlvar name="entries" type="hash"><![CDATA[
<#if man_catalogue_exists==10 >
select R.catalogue_id,
K.shortname,
timeunit,
sqlchunk,
calcratio,
decimalplaces,
linksub,
linktimeline,
R.report_id,
R.sortnr,
 R.sortnr2,
R.grouping1,
G.caption as group_caption from man_catalogue K,
man_catalogue_rpt R left outer join man_grouping G on (G.id=R.grouping1)  
where  K.id=R.catalogue_id and R.active=1 
and K.id not in ('Bewerber') 
order by R.sortnr, R.sortnr2 

</#if> ]]>
</sqlvar>
<sqlvar name="commonChartProperties" type="hashsequence">
SELECT 
P.tid,
P.caption,
P.prop_uniquename,
P.prop_default,
P.prop_unit,
P.is_generic,
P.static_values,
P.is_mandatory,
P.explanation,
P.sortnr,
P.range_from,
P.range_to,
I.caption as input_type_caption,
I.uniquename as input_type_uniquename,
G.caption as group_caption,
G.sortnr as group_sortnr,
G.uniquename as group_uniquename,
R.uniquename as renderer_uniquename,
GR.variable_name as group_variable_name,
coalesce((select PR.variable_name from viz_property_renderer PR
where PR.property_id=P.tid
and PR.renderer_id=R.tid),P.prop_uniquename) as variable_name,
P.prop_value_type,
P.is_generic 

FROM viz_property_input_type I, viz_property P left outer join viz_property_group G
on (P.property_group_id=G.tid)
left outer join viz_property_group_renderer GR on (GR.property_group_id=G.tid)
left outer join viz_renderer R on (R.tid=GR.renderer_id)
left outer join viz_property_renderer PR on (P.tid=PR.property_id)
where I.tid=P.input_type_id 
order by G.sortnr,G.uniquename,P.sortnr,P.caption
 ;
 </sqlvar>
 <sqlvar name="vizRenderer" type="hash">
SELECT 
R.uniquename,
R.caption
FROM viz_renderer R
order by 2 asc
 ;
 </sqlvar>
<sqlvar name="vizTypes" type="hash">
SELECT T.tid,
T.uniquename,
T.caption,
R.uniquename as renderer_uniquename,
R.caption as renderer_caption,
T.srcpath,
T.method,
T.orientation
FROM viz_type T, viz_renderer R
where R.tid=T.renderer_id
order by 3
 ;
 </sqlvar>
<sqlvar name="viz_type_properties" type="hash">
SELECT T.tid,
T.uniquename as viz_type_uniquename,
P.caption,
P.prop_uniquename,
P.prop_default,
P.prop_unit,
P.is_generic,
P.static_values,
--P.is_mandatory,
P.explanation,
P.sortnr,
P.range_from,
P.range_to,
I.caption as input_type_caption,
I.uniquename as input_type_uniquename,
G.uniquename as viz_property_group_uniquename,
TP.is_mandatory,
TP.sortnr,
P.prop_value_type,
P.is_generic
FROM viz_type T, viz_type_property TP, viz_property_input_type I, viz_property P
left outer join viz_property_group G on (G.tid=P.property_group_id)
where T.tid=TP.viz_type_id
and P.tid=TP.viz_property_id
and I.tid=P.input_type_id
order by 2,TP.sortnr,P.caption
 ;
 </sqlvar>
 <sqlvar name="viz_chart" type="hashsequence">
SELECT V.tid,
V.uniquename,
V.caption,
V.userinfo_id,
replace(V.chartmodel,'"','§') as chartmodel_escaped,
replace(V.chartmodel_miniature,'"','§') as chartmodel_miniature_escaped,
V.description,
V.chart_position,
--replace(V.chartcode,'"','§') as chartcode_escaped,
--replace(V.datasource_def,'"','§') as datasource_def_escaped
R.uniquename as renderer_uniquename,
R.tid as renderer_id,
V.chart_width,
V.chart_height,
V.chart_miniature_width,
V.chart_miniature_height,
V.maskeninfo_id
FROM viz_chart V, viz_renderer R
where R.tid=V.renderer_id
and chart_active=1
order by 3
 ;
 </sqlvar>
 <sqlvar name="viz_property_tree" type="hashsequence">
 with recursive tree_rec (renderer_uniquename,
renderer_id,
prop_tid,
prop_uniquename,
parent_prop_uniquename,
sortnr,
is_mandatory)

as (select R.uniquename as renderer_uniquename,
R.tid as renderer_id,
P.tid as prop_tid,
P.prop_uniquename,
null::varchar as parent_prop_uniquename,
N.sortnr,
N.is_mandatory
from viz_property_tree_node N, viz_renderer R, viz_property P
where N.renderer_id=R.tid
and N.property_id=P.tid
and N.parent_property_id is null
union all (select 
R.uniquename as renderer_uniquename,
R.tid as renderer_id,
P.tid as prop_tid,
P.prop_uniquename,
(select P2.prop_uniquename from viz_property P2
where P2.tid=N.parent_property_id) as parent_property_uniquename,
N.sortnr,
N.is_mandatory
from viz_property_tree_node N, viz_renderer R, viz_property P,tree_rec T
where N.renderer_id=R.tid
and N.property_id=P.tid
and T.prop_tid=N.parent_property_id
)
)
--search depth first by name set sort1
select distinct R.renderer_uniquename,
T.uniquename as viz_type_uniquename,
R.prop_tid,
R.prop_uniquename,
R.parent_prop_uniquename,
P.caption as property_caption,
P.is_generic,
R.sortnr,
(case when P.is_generic =0 then TP.is_mandatory else R.is_mandatory end) as is_mandatory,
T.orientation
from  tree_rec R,viz_property P,viz_type_property TP, viz_type T
where P.tid=R.prop_tid
and TP.viz_type_id=T.tid
and T.renderer_id=R.renderer_id
and (P.is_generic=1 or TP.viz_property_id=P.tid)
--and T.uniquename='echarts_bar_y_series'
order by 1,2,R.sortnr;

 </sqlvar>
 <sqlvar name="viz_colorscheme" type="hashsequence">
SELECT tid,
uniquename , 
caption  , 
is_custom,
specifier,
sortnr
from viz_colorscheme
where colorscheme_active=1
order by sortnr,caption
 ;
 </sqlvar>
 <sqlvar name="viz_colorscheme_element" type="hashsequence">
SELECT E.colorscheme_id  ,
C.uniquename as colorscheme_uniquename,
E.colorcode, 
E.target_uniquename , 
E.sortnr
from viz_colorscheme_element E, viz_colorscheme C
where C.tid=E.colorscheme_id
order by 2,5,3
 ;
 </sqlvar>
 </sqlvars>
<#if !Semester?exists><#assign Semester=""></#if> <#if !Bezugssemester?exists><#assign Bezugssemester=""/></#if> <#if !Jahr?exists><#assign Jahr=""></#if> <#if !faecherkeys?exists><#assign faecherkeys=""></#if>  <#if !Fächer?exists><#assign Fächer={"selectedKey":""}></#if>  <#if !Kostenstelle?exists><#assign Kostenstelle={"selectedKey":""}></#if>  <#if !(.vars["Datum (Personal)"]?exists)><#assign "Datum (Personal)"=""></#if>    <#if !(.vars["Beschäftigungsstelle (Person)"]?exists)><#assign "Beschäftigungsstelle (Person)"=""></#if>
<navigation><item><href><![CDATA[888880190&maxoffset=100000&Jahr=${Jahr}&Semester=${Semester}&Datum%20(Personal)=${.vars["Datum (Personal)"]}]]></href><caption>Start</caption></item>
<#if entries?is_sequence><#foreach e in entries>
<#assign linktimeline=e.linktimeline?interpret/>
<#assign linkt><@linktimeline/></#assign> <#assign linksub=e.linksub?interpret/>
<#assign links><@linksub/></#assign>  <doubleitem id="${e.catalogue_id}" timeunit="${e.timeunit}" report_id="${e.report_id}" group_id="${e.grouping1}" group_caption="${e.group_caption}">
<aktuell><![CDATA[${links?replace('Fakultäten|','')}]]></aktuell>
<zeitreihe><![CDATA[${linkt?replace('Zeitreihe|','')}]]></zeitreihe>
<caption><![CDATA[${e.shortname}]]></caption> </doubleitem> </#foreach>
</#if></navigation>
<chartProperties>
<#if commonChartProperties?has_content && commonChartProperties?is_sequence><#foreach cp in commonChartProperties>
<commonChartProperty tid="${cp.tid}" 
 caption="${cp.caption}" 
 prop_uniquename="${cp.prop_uniquename}" 
 prop_default="${cp.prop_default}" 
 static_values="${cp.static_values}" 
 input_type_uniquename="${cp.input_type_uniquename}" 
 group_caption="${cp.group_caption}" 
 group_uniquename="${cp.group_uniquename}" 
 prop_unit="${cp.prop_unit}" 
 prop_range_from="${cp.range_from}" 
 prop_range_to="${cp.range_to}" 
 renderer_uniquename="${cp.renderer_uniquename}" 
 group_variable_name="${cp.group_variable_name}" 
 variable_name="${cp.variable_name}" 
 propValueType="${cp.prop_value_type}"
 explanation="${cp.explanation}"
 isGeneric="${cp.is_generic}"
  />
</#foreach>
</#if>
</chartProperties>
<vizRenderers>
<#if vizRenderer?has_content && vizRenderer?is_sequence>
<#foreach vr in vizRenderer>
<vizRenderer  
 caption="${vr.caption}" 
 uniquename="${vr.uniquename}" 
   />
</#foreach>
</#if>
</vizRenderers>
<vizTypes>
<#if vizTypes?has_content && vizTypes?is_sequence>
<#foreach vt in vizTypes>
<vizType tid="${vt.tid}" 
 caption="${vt.caption}" 
 uniquename="${vt.uniquename}" 
 srcpath="${vt.srcpath}" 
 method="${vt.method}" 
 orientation="${vt.orientation}"
 renderer_uniquename="${vt.renderer_uniquename}" 
 renderer_caption="${vt.renderer_caption}" 
  />
</#foreach>
</#if>
</vizTypes>
<viz_type_properties>
<#if viz_type_properties?has_content && viz_type_properties?is_sequence>
<#foreach tp in viz_type_properties>
<viz_type_property tid="${tp.tid}" 
 caption="${tp.caption}" 
 uniquename="${tp.prop_uniquename}" 
 viz_type_uniquename="${tp.viz_type_uniquename}" 
 viz_property_group_uniquename="${tp.viz_property_group_uniquename}" 
 is_mandatory="${tp.is_mandatory}"
  prop_default="${tp.prop_default}" 
 static_values="${tp.static_values}" 
 input_type_uniquename="${tp.input_type_uniquename}" 
 prop_unit="${tp.prop_unit}" 
 prop_range_from="${tp.range_from}" 
 prop_range_to="${tp.range_to}" 
 propValueType="${tp.prop_value_type}"
 explanation="${tp.explanation}"
 isGeneric="${tp.is_generic}"
  />
</#foreach>
</#if>
</viz_type_properties>
<viz_charts>
<#if viz_chart?has_content &&  viz_chart?is_sequence>
<#foreach ch in viz_chart>
<viz_chart tid="${ch.tid}" 
 caption="${ch.caption}" 
 uniquename="${ch.uniquename}" 
 userinfo_id="${ch.userinfo_id}"
 description="${ch.description}"
 chartmodel="${ch.chartmodel_escaped}" 
 chartmodel_miniature="${ch.chartmodel_miniature_escaped}" 
 chart_position="${ch.chart_position}" 
 renderer="${ch.renderer_uniquename}"
 renderer_id="${ch.renderer_id}"
 chart_width="${ch.chart_width}"
 chart_height="${ch.chart_height}"
 chart_miniature_width="${ch.chart_width}"
 chart_miniature_height="${ch.chart_height}"
 maskeninfo_id="${ch.maskeninfo_id}"
   />
</#foreach>
</#if>
</viz_charts>
<viz_property_trees>
<#if viz_property_tree?has_content && viz_property_tree?is_sequence>
<#foreach tree in viz_property_tree>
<viz_property_tree renderer="${tree.renderer_uniquename}" 
 viz_type_uniquename="${tree.viz_type_uniquename}" 
 orientation="${tree.orientation}" 
 prop_uniquename="${tree.prop_uniquename}"
 property_caption="${tree.property_caption}"
 parent_property_uniquename="${tree.parent_prop_uniquename}" 
 sortnr="${tree.sortnr}" 
 is_mandatory="${tree.is_mandatory}" 
    />
</#foreach>
</#if>
</viz_property_trees>
<vizColorSchemes>
<#if viz_colorscheme?has_content && viz_colorscheme?is_sequence>
<#foreach sc in viz_colorscheme>
<vizColorscheme tid="${sc.tid}" 
 caption="${sc.caption}" 
 uniquename="${sc.uniquename}" 
 is_custom="${sc.is_custom}"
 specifier="${sc.specifier}" 
 
  />
</#foreach>
</#if>
</vizColorSchemes>
<vizColorSchemeElements>
<#if viz_colorscheme_element?has_content && viz_colorscheme_element?is_sequence>
<#foreach el in viz_colorscheme_element>
<vizColorschemeElem colorscheme_id="${el.colorscheme_id}" 
 colorscheme_uniquename="${el.colorscheme_uniquename}" 
 colorcode="${el.colorcode}" 
 target_uniquename="${el.target_uniquename}" 
 sortnr="${el.sortnr}" 
 
  />
</#foreach>
</#if>
</vizColorSchemeElements>
