
--SQL Script automatisch generiert von SuperX sx_fields_fuellen.xsl


--freemarker template

<sqlvars>
<sqlvar name="sx_fields_exists">
select sp_table_exists('sx_fields') from xdummy;

</sqlvar>

</sqlvars>
<#if sx_fields_exists=1>


CREATE temp TABLE tmp_fields(
tid serial NOT NULL,
table_name VARCHAR(255)  not null, 
name VARCHAR(255)  not null, 
caption VARCHAR(255) , 
description VARCHAR(255) , 
field_type VARCHAR(255)  not null, 
field_size VARCHAR(255)  , 
field_not_null smallint,
currentlyused SMALLINT , 
is_primarykey SMALLINT  default 0 , 
foreignkey_tab VARCHAR(255) , 
foreignkey_col VARCHAR(255) , 
foreignkey_int VARCHAR(255) , 
foreignkey_cap VARCHAR(255) , 
foreignkey_cond VARCHAR(255) , 
foreignkey_func VARCHAR(255) , 
check_integrity SMALLINT, 
is_sum SMALLINT  default 1,
foreignkey_uniquename VARCHAR(255)

);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_chart',
'tid',
'tid',
'',
'SERIAL',
'',
1,
1,
0,
1);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='viz_chart_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_chart',
'uniquename',
'Unique Name',
'',
'VARCHAR',
'255',
1,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_chart',
'caption',
'Bezeichnung',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_chart',
'description',
'Beschreibung',
'',
'TEXT',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_chart',
'chartmodel',
'Quellcode des Diagramms',
'',
'TEXT',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_chart',
'preview_svg',
'Vorschau (SVG)',
'',
'TEXT',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_chart',
'userinfo_id',
'Angelegt von',
'',
'INTEGER',
'255',
0,
1,
0,
1);

update tmp_fields set foreignkey_tab='userinfo',
foreignkey_col='tid',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='viz_chart_userinfo_id';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_chart',
'creation_date',
'Angelegt (Datum)',
'',
'DATE',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_chart',
'update_date',
'Letzte Änderung (Datum)',
'',
'DATE',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_chart',
'maskeninfo_id',
'Maske',
'',
'INTEGER',
'255',
0,
1,
0,
1);

update tmp_fields set foreignkey_tab='maskeninfo',
foreignkey_col='tid',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='viz_chart_maskeninfo_id';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_chart',
'mask_params',
'Maskenparameter',
'',
'TEXT',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_chart',
'renderer_id',
'Renderer',
'',
'INTEGER',
'',
1,
1,
0,
1);

update tmp_fields set foreignkey_tab='viz_renderer',
foreignkey_col='tid',
foreignkey_cap='caption',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='viz_chart_renderer_id';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_chart',
'chartmodel_miniature',
'Quellcode des Diagramms (Miniatur)',
'',
'TEXT',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_chart',
'chart_position',
'Position des Diagramms',
'CENTER,TOP,BOTTOM,LEFT,RIGHT,INLINE',
'CHAR',
'10',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_chart',
'chart_active',
'Grafik aktiv',
'',
'SMALLINT',
'2',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_chart',
'chart_width',
'Breite des Diagramms',
'in px',
'INTEGER',
'10',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_chart',
'chart_height',
'Höhe des Diagramms',
'in px',
'INTEGER',
'10',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_chart',
'chart_miniature_width',
'Breite der Diagramm-Miniatur',
'in px',
'INTEGER',
'10',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_chart',
'chart_miniature_height',
'Höhe der Diagramm-Miniatur',
'in px',
'INTEGER',
'10',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_chart',
'is_custom',
'Grafik der Hochschule',
'1=ja, d.h. von der Hochschule angepaßt, 0=nein, d.h. 				Auslieferung der Software',
'SMALLINT',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_colorscheme',
'tid',
'tid',
'',
'SERIAL',
'',
1,
1,
0,
1);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='viz_colorscheme_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_colorscheme',
'uniquename',
'Schlüssel',
'',
'VARCHAR',
'255',
1,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_colorscheme',
'caption',
'Bezeichnung',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_colorscheme',
'is_custom',
'Palette der Hochschule',
'1=ja, d.h. von der Hochschule angepaßt, 0=nein, d.h. 				Auslieferung der Software',
'SMALLINT',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_colorscheme',
'specifier',
'Quelle (komprimiert)',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_colorscheme',
'sortnr',
'Sortiernr.',
'',
'SMALLINT',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_colorscheme',
'colorscheme_active',
'Palette aktiv',
'',
'SMALLINT',
'2',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_colorscheme_element',
'tid',
'tid',
'',
'SERIAL',
'',
1,
1,
0,
1);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='viz_colorscheme_element_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_colorscheme_element',
'colorscheme_id',
'Farbpalette',
'',
'INTEGER',
'255',
1,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_colorscheme_element',
'colorcode',
'Farbcode',
'',
'VARCHAR',
'255',
1,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_colorscheme_element',
'target_uniquename',
'Ziel-Schlüssel',
'Optional: Wenn eine Farbe zu einem definierten Schlüssel zugeordnet werden soll (z.B. eine Farbe zu einer Fakultät)',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_colorscheme_element',
'sortnr',
'Sortiernr.',
'',
'SMALLINT',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_dashboard',
'tid',
'tid',
'',
'SERIAL',
'',
1,
1,
0,
1);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='viz_dashboard_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_dashboard',
'uniquename',
'Unique Name',
'',
'VARCHAR',
'255',
1,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_dashboard',
'caption',
'Bezeichnung',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_dashboard',
'maskeninfo_id',
'Maske',
'',
'INTEGER',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_dashboard',
'booklet_stylesheet',
'Stylesheet für Druckversion',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_dashboard',
'gridtitle_felderinfo_id',
'Maskenfeld für Titelelement',
'',
'INTEGER',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_dashboard_tab',
'tid',
'tid',
'',
'SERIAL',
'',
1,
1,
0,
1);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='viz_dashboard_tab_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_dashboard_tab',
'dashboard_id',
'Dashboard',
'',
'INTEGER',
'255',
1,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_dashboard_tab',
'caption',
'Bezeichnung',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_dashboard_tab',
'maskeninfo_id',
'Maske',
'',
'INTEGER',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_dashboard_tab',
'sortnr',
'Sortiernr.',
'',
'SMALLINT',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_dashboard_tab',
'select_clause',
'SQL der Kennzahl',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_dashboard_tab',
'fact_table',
'Quelltabelle der Kennzahl',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_dashboard_tab',
'where_clause',
'SQL-Filter der Kennzahl',
'',
'TEXT',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_dashboard_tab',
'optional_filter_name',
'Optionaler Filter der Kennzahl',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_dashboard_tab',
'optional_filter_value',
'Optionaler Filterwert der Kennzahl',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_dashboard_tab',
'booklet_stylesheet',
'Stylesheet für Druckversion',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property',
'tid',
'tid',
'',
'SERIAL',
'',
1,
1,
0,
1);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='viz_property_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property',
'caption',
'Bezeichnung',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property',
'prop_uniquename',
'Schlüssel',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property',
'prop_default',
'Defaultwert',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property',
'prop_unit',
'Einheit',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property',
'is_generic',
'Generische Eigenschaft',
'1=ja, 0=nein',
'SMALLINT',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property',
'static_values',
'Wertebereich (statisch)',
'wird nur bei SELECT-Feldern genutzt, mit "|" getrennt',
'TEXT',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property',
'is_mandatory',
'Pflichteingabe',
'1=ja, 0=nein',
'SMALLINT',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property',
'input_type_id',
'Eingabedialog',
'',
'INTEGER',
'255',
0,
1,
0,
1);

update tmp_fields set foreignkey_tab='viz_property_input_type',
foreignkey_col='tid',
foreignkey_cap='caption',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='viz_property_input_type_id';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property',
'property_group_id',
'Art der Eigenschaft',
'',
'INTEGER',
'255',
0,
1,
0,
1);

update tmp_fields set foreignkey_tab='viz_property_group',
foreignkey_col='tid',
foreignkey_cap='caption',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='viz_property_property_group_id';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property',
'explanation',
'Erläuterung',
'Wird als Tooltip angezeigt',
'TEXT',
'32255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property',
'sortnr',
'Sortiernummer',
'',
'INTEGER',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property',
'range_from',
'Minimalwert',
'Wir nur bei Schiebereglern genutzt',
'INTEGER',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property',
'range_to',
'Maximalwert',
'Wir nur bei Schiebereglern genutzt',
'INTEGER',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property',
'prop_value_type',
'Datentyp',
'string,integer,float,boolean',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_group',
'tid',
'tid',
'',
'SERIAL',
'',
1,
1,
0,
1);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='viz_property_group_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_group',
'uniquename',
'Unique Name',
'',
'VARCHAR',
'255',
1,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_group',
'caption',
'Bezeichnung',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_group',
'sortnr',
'Sortiernummer',
'',
'INTEGER',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_group_renderer',
'tid',
'tid',
'',
'SERIAL',
'',
1,
1,
0,
1);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='viz_property_group_renderer_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_group_renderer',
'renderer_id',
'Renderer',
'',
'INTEGER',
'',
1,
1,
0,
1);

update tmp_fields set foreignkey_tab='viz_renderer',
foreignkey_col='tid',
foreignkey_cap='caption',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='viz_property_group_renderer_renderer_id';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_group_renderer',
'property_group_id',
'Gruppe der Visualisierung',
'',
'INTEGER',
'255',
1,
1,
0,
1);

update tmp_fields set foreignkey_tab='viz_property_group',
foreignkey_col='tid',
foreignkey_cap='variable_name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='viz_property_group_renderer_property_group_id';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_group_renderer',
'variable_name',
'Variablenname',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_input_type',
'tid',
'tid',
'',
'SERIAL',
'',
1,
1,
0,
1);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='viz_property_input_type_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_input_type',
'uniquename',
'Unique Name',
'',
'VARCHAR',
'255',
1,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_input_type',
'caption',
'Bezeichnung',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_renderer',
'tid',
'tid',
'',
'SERIAL',
'',
1,
1,
0,
1);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='viz_property_renderer_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_renderer',
'renderer_id',
'Renderer',
'',
'INTEGER',
'',
1,
1,
0,
1);

update tmp_fields set foreignkey_tab='viz_renderer',
foreignkey_col='tid',
foreignkey_cap='caption',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='viz_property_renderer_renderer_id';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_renderer',
'property_id',
'Eigenschaft der Visualisierung',
'',
'INTEGER',
'255',
1,
1,
0,
1);

update tmp_fields set foreignkey_tab='viz_property',
foreignkey_col='tid',
foreignkey_cap='variable_name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='viz_property_renderer_property_id';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_renderer',
'variable_name',
'Variablenname',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_tree_node',
'tid',
'tid',
'',
'SERIAL',
'',
1,
1,
0,
1);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='viz_property_tree_node_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_tree_node',
'renderer_id',
'Renderer',
'',
'INTEGER',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_tree_node',
'property_id',
'Eigenschaft der Visualisierung',
'',
'INTEGER',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_tree_node',
'parent_property_id',
'Eigenschafts-Elternelement der Visualisierung',
'',
'INTEGER',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_tree_node',
'sortnr',
'Sortiernr.',
'',
'SMALLINT',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_tree_node',
'is_mandatory',
'Pflichteingabe',
'1=ja, 0=nein',
'SMALLINT',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_renderer',
'tid',
'tid',
'',
'SERIAL',
'',
1,
1,
0,
1);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='viz_renderer_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_renderer',
'uniquename',
'Unique Name',
'',
'VARCHAR',
'255',
1,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_renderer',
'caption',
'Bezeichnung',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_staat_isocode',
'name',
'name',
'',
'VARCHAR',
'4000',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_staat_isocode',
'iso3',
'iso3',
'',
'VARCHAR',
'3',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_staat_isocode',
'kurzbezeichnung',
'kurzbezeichnung',
'',
'VARCHAR',
'3',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_staat_isocode',
'astat',
'astat',
'',
'INTEGER',
'10',
0,
1,
0,
1);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='viz_staat_isocode_astat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_type',
'tid',
'tid',
'',
'SERIAL',
'',
1,
1,
0,
1);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='viz_type_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_type',
'uniquename',
'Schlüssel',
'',
'VARCHAR',
'255',
1,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_type',
'caption',
'Bezeichnung',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_type',
'renderer_id',
'Renderer',
'',
'INTEGER',
'4',
0,
1,
0,
1);

update tmp_fields set foreignkey_tab='viz_renderer',
foreignkey_col='tid',
foreignkey_cap='caption',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='viz_type_renderer_id';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_type',
'srcpath',
'Pfad zum Quellcode',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_type',
'method',
'Methode',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_type',
'orientation',
'Orientierung',
'Grafik horizontal (H) oder vertikal (V)',
'CHAR',
'1',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_type',
'explanation',
'Erläuterung',
'',
'TEXT',
'32255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_type',
'preview',
'Muster',
'SVG-Beispiel',
'TEXT',
'32255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_type_property',
'tid',
'tid',
'tid',
'SERIAL',
'10',
1,
1,
0,
1);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='viz_type_property_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_type_property',
'viz_type_id',
'viz_type_id',
'Diagrammtyp',
'INTEGER',
'10',
0,
1,
0,
1);

update tmp_fields set foreignkey_tab='viz_type',
foreignkey_col='tid',
foreignkey_cap='caption',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='viz_type_property_viz_type_id';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_type_property',
'viz_property_id',
'viz_property_id',
'Eigenschaft der Visualisierung',
'INTEGER',
'10',
0,
1,
0,
1);

update tmp_fields set foreignkey_tab='viz_property',
foreignkey_col='tid',
foreignkey_cap='caption',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='viz_type_property_viz_property_id';

update tmp_fields set foreignkey_tab='viz_property_dimension_measure',
foreignkey_col='tid',
foreignkey_cap='caption',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='viz_type_property_viz_property_id';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_type_property',
'is_mandatory',
'is_mandatory',
'Pflichteingabe',
'SMALLINT',
'5',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_type_property',
'sortnr',
'sortnr',
'Sortiernr.',
'SMALLINT',
'5',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_dimension_measure',
'tid',
'tid',
'',
'INTEGER',
'',
1,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_dimension_measure',
'caption',
'Bezeichnung',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_dimension_measure',
'prop_uniquename',
'Schlüssel',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_dimension_measure',
'prop_default',
'Defaultwert',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_dimension_measure',
'prop_unit',
'Einheit',
'',
'VARCHAR',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_dimension_measure',
'is_generic',
'Generische Eigenschaft',
'1=ja, 0=nein',
'SMALLINT',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_dimension_measure',
'static_values',
'Wertebereich (statisch)',
'wird nur bei SELECT-Feldern genutzt, mit "|" getrennt',
'TEXT',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_dimension_measure',
'is_mandatory',
'Pflichteingabe',
'1=ja, 0=nein',
'SMALLINT',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_dimension_measure',
'input_type_id',
'Eingabedialog',
'',
'INTEGER',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_dimension_measure',
'property_group_id',
'Art der Eigenschaft',
'',
'INTEGER',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_dimension_measure',
'explanation',
'Erläuterung',
'Wird als Tooltip angezeigt',
'TEXT',
'32255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_dimension_measure',
'sortnr',
'Sortiernummer',
'',
'INTEGER',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_dimension_measure',
'range_from',
'Minimalwert',
'Wir nur bei Schiebereglern genutzt',
'INTEGER',
'255',
0,
1,
0,
1);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('viz_property_dimension_measure',
'range_to',
'Maximalwert',
'Wir nur bei Schiebereglern genutzt',
'INTEGER',
'255',
0,
1,
0,
1);


delete from sx_fields where trim(table_name) in (select trim(T.table_name) from tmp_fields T);

create temp table tmp_hilf(tid integer);
insert into tmp_hilf select max(tid) from sx_fields;
update tmp_hilf set tid=0 where tid is null;

insert into sx_fields (tid,table_name,name,caption,description,field_type,
field_size,
field_not_null,
currentlyUsed,
foreignkey_tab,
foreignkey_col,
foreignkey_cap,
foreignkey_int,
foreignkey_cond,
foreignkey_func,
check_integrity,
is_sum

<#if TableFieldExists?exists && TableFieldExists('sx_fields','foreignkey_uniquename')>
,foreignkey_uniquename
</#if>


)
select F.tid + H.tid,
F.table_name,F.name,F.caption,F.description,F.field_type,
F.field_size,
F.field_not_null,
F.currentlyUsed,
F.foreignkey_tab,
F.foreignkey_col,
F.foreignkey_cap,
F.foreignkey_int,
F.foreignkey_cond,
F.foreignkey_func,
F.check_integrity,
F.is_sum

<#if TableFieldExists?exists && TableFieldExists('sx_fields','foreignkey_uniquename')>
,F.foreignkey_uniquename
</#if>

from tmp_fields F, tmp_hilf H;

<#if SQLdialect='Postgres'>
select sp_update_sequence('sx_fields');
</#if>

drop table tmp_hilf;
drop table tmp_fields;


</#if>

