#!/bin/bash

#Upgrade 
NEWVERSION=`cat ../VERSION`
# XML-generiertes Shell-Script fuer Modul lm

echo "Die aktuell installierte Version des Moduls ist"
if [ "$DATABASE" == "INFORMIX"  ]
	then
DOQUERY "select version from db_version where his_system='lm';" 2>/dev/null
else
DOQUERY "select version from db_version where his_system='lm';"
fi

echo "Die zu installierende Version ist $NEWVERSION"

if [ "$1" != "J" ]
then
echo "Fortfahren? (J/N) ? "
	read WEITER
else
WEITER=$1
fi

if [ "$WEITER" != "J" ] 
then 
if [ "$WEITER" != "j" ]
then	echo "Upgrade-Script abgebrochen"
	exit 0
fi
fi

UPDATELOG=$LM_PFAD/upgrade/upgrade"$MANDANTID".log
echo "Datenbank $DBNAME wird geupdated. Logdatei: $UPDATELOG"
echo "Datenbank $DBNAME wird geupdated." >$UPDATELOG

if [ -f "$LM_PFAD/upgrade/lm_pre_upgrade_$DATABASE_ABBR.sql" ] 
then

DOSQL $LM_PFAD/upgrade/lm_pre_upgrade_"$DATABASE_ABBR".sql >>$UPDATELOG 2>&1

fi

echo "Tabellen prüfen" >>$UPDATELOG

DOSQL $LM_PFAD/upgrade/lm_upgrade_tables_"$DATABASE_ABBR".sql >>$UPDATELOG 2>&1
DOSQL $LM_PFAD/upgrade/lm_upgrade_fields_"$DATABASE_ABBR".sql >>$UPDATELOG 2>&1

DOSQL $LM_PFAD/upgrade/lm_upgrade_views_"$DATABASE_ABBR".sql >>$UPDATELOG 2>&1


if [ "$DATABASE" == "INFORMIX"  ]
	then
	echo "speziell für IDS" >>$UPDATELOG
	
	fi


DOSQL $LM_PFAD/upgrade/lm_upgrade_functions_"$DATABASE_ABBR".sql >>$UPDATELOG 2>&1
DOSQL $LM_PFAD/upgrade/lm_upgrade_indexes_"$DATABASE_ABBR".sql >>$UPDATELOG 2>&1
DOSQL $LM_PFAD/upgrade/lm_upgrade_themenbaum.sql >>$UPDATELOG 2>&1
$LM_PFAD/lm_masken_einspielen_"$DATABASE_ABBR".x >>$UPDATELOG 2>&1

DOSQL $LM_PFAD/upgrade/lm_upgrade_"$DATABASE_ABBR".sql >>$UPDATELOG 2>&1


if [ -f "$LM_PFAD/conf/customize$MANDANTID.sql"  ] 
then

CMD="DOSQL $LM_PFAD/conf/customize$MANDANTID.sql"
runAndCheck.x $LM_PFAD "$CMD" CONT_ON_ERROR NO_ERRORMAIL NO_LOGMAIL "lm Customize$MANDANTID"

fi

if [ -f "$LM_PFAD/lm_install_custom.sql"  ] 
then

CMD="DOSQL $LM_PFAD/lm_install_custom.sql"
runAndCheck.x $LM_PFAD "$CMD" CONT_ON_ERROR NO_ERRORMAIL NO_LOGMAIL "lm Customize_aus_repository$MANDANTID"

fi

if [ "$WEBAPP" == ""  ]
	then
	#in SuperX 3.5 ist webapp immer hier:
WEBAPP=$SUPERX_DIR/webserver/tomcat/webapps/superx

fi

DBFORMS_CONFIG=$WEBAPP/WEB-INF/lm_dbforms-config_"$DATABASE_ABBR".xml

if [ -f "$DBFORMS_CONFIG"  ]
then

CMD="dbforms-config_upgrade.x $DBFORMS_CONFIG"
runAndCheck.x $SUPERX_DIR/db/bin "$CMD" CONT_ON_ERROR NO_ERRORMAIL NO_LOGMAIL "lm dbforms-config Upgrade$MANDANTID"

fi 

EDUSTORE_XML=$WEBAPP/WEB-INF/classes/edustore/edustore_lm.xml

if [ "$EDUSTORE_XML_GENERATE" = "true" -a -f "$EDUSTORE_XML" -a -f "$SUPERX_DIR/db/bin/edustore_xml_upgrade.x" ]
then 
CMD="edustore_xml_upgrade.x $EDUSTORE_XML"
runAndCheck.x $SUPERX_DIR/db/bin "$CMD" CONT_ON_ERROR NO_ERRORMAIL NO_LOGMAIL "sos edustore_xml Upgrade$MANDANTID"
echo "$EDUSTORE_XML wurde aktualisiert."
else
echo "$EDUSTORE_XML wurde nicht aktualisiert."
fi 

fgrep -i -s "fehler" $UPDATELOG
FLAG1=$?
fgrep -i -s "error" $UPDATELOG
FLAG2=$?
fgrep -i -s "could not connect to server" $UPDATELOG
FLAG3=$?

if [ $FLAG1 -eq 0 -o $FLAG2 -eq 0 -o $FLAG3 -eq 0 ]
then
	echo "Fehler beim Upgrade der Datenbank" 
	echo "---------------------------------------" 
	echo "Bitte prüfen Sie das Fehlerprotokoll in $UPDATELOG" 
	echo "---------------------------------------" 
	
else

	echo "----------------------------------------" 
	echo "Datenbank $DBNAME erfolgreich geupdated "
	echo "(Keine Fehler aufgefallen in $UPDATELOG)." 
	echo "Bitte starten Sie nun Tomcat neu."
	echo "----------------------------------------" 
fi

