-- XML-generiertes SQL-Script fuer -- von dimension_bp_fuellen.xsl

--freemarker template
<sqlvars>
<sqlvar name="dimension_bp_exists">
select sp_table_exists('dimension_bp') from xdummy;

</sqlvar>
</sqlvars>
<#if dimension_bp_exists=1>

 

create temp table tmp_dimension_bp(
	tid SERIAL  not null, 
d_akt_von DATE , 
d_akt_bis DATE , 
apnr VARCHAR(255) , 
kurz VARCHAR(255) , 
druck VARCHAR(255) , 
lang_1 VARCHAR(255) , 
lang_2 VARCHAR(255) , 
lang_3 VARCHAR(255) , 
keyfield VARCHAR(255) , 
keyfieldtype VARCHAR(255) , 
datatype VARCHAR(255) , 
captionfield VARCHAR(255) ,
sortfield VARCHAR(255) , 
source VARCHAR(255) , 
sourcefilter VARCHAR(255) , 
system_key VARCHAR(255) 
);



--updates auf vorh. Schlüssel

<#if SQLdialect='Postgres'>
--Postgres Dialekt:
update dimension_bp set apnr=D.apnr, 
d_akt_von=D.d_akt_von, 
d_akt_bis=D.d_akt_bis , 
kurz=D.kurz , 
druck=D.druck , 
lang_1=D.lang_1 , 
lang_2=D.lang_2 , 
lang_3=D.lang_3 , 
keyfieldtype=D.keyfieldtype,
datatype=D.datatype,
keyfield=D.keyfield,
captionfield=D.captionfield,
source=D.source,
sourcefilter=D.sourcefilter
<#if TableFieldExists?exists && TableFieldExists('dimension_bp','sortfield')>
,sortfield=D.sortfield
</#if>
from tmp_dimension_bp D
where D.system_key=dimension_bp.system_key;

<#else>

--Informix Dialekt:
update dimension_bp set ( apnr,
       d_akt_von,
       d_akt_bis,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
       keyfield,
       keyfieldtype,
       datatype,
       captionfield,
       <#if TableFieldExists?exists && TableFieldExists('dimension_bp','sortfield')>
sortfield,
</#if>
       source,
       sourcefilter) 
       = ((select 
        apnr,
       d_akt_von,
       d_akt_bis,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
       keyfield,
       keyfieldtype,
       datatype,
       captionfield,
<#if TableFieldExists?exists && TableFieldExists('dimension_bp','sortfield')>
sortfield,
</#if>
       source,
       sourcefilter
from tmp_dimension_bp D
where D.system_key=dimension_bp.system_key))
where system_key in (select D.system_key from tmp_dimension_bp D);


</#if>

--neue werden eingefügt:
delete from tmp_dimension_bp where system_key in 
(select system_key from dimension_bp);

insert into dimension_bp(d_akt_von,
       d_akt_bis,
       apnr,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
             keyfield  ,
	     keyfieldtype,
       datatype, 
captionfield  ,
<#if TableFieldExists?exists && TableFieldExists('dimension_bp','sortfield')>
sortfield,
</#if>
source , 
sourcefilter, 
       system_key
 )
select d_akt_von,
       d_akt_bis,
       apnr,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
             keyfield  , 
	     keyfieldtype,
       datatype,
captionfield  ,
<#if TableFieldExists?exists && TableFieldExists('dimension_bp','sortfield')>
sortfield,
</#if>
source , 
sourcefilter, 
       system_key
 from tmp_dimension_bp
;


 drop table tmp_dimension_bp;


</#if>

