#!/bin/bash
#Extraction Script for SuperX.
#Bitte nicht ändern, diese Datei ist automatisch generiert. 

SRC_PFAD=$LM_LOAD_PFAD
. ./LM_ENV
if [ "$SRC_PFAD" = "" ]
then 
SRC_PFAD=.
fi

if [ "$outFormat" = "" ]
then 
outFormat=txt
fi

DATUM=`cat $SRC_PFAD/superx.datum`
ERR=lm_unload.err
cp $SRC_PFAD/superx.datum $SRC_PFAD/superx.datum.alt

##Löschen der alten Dateien
rm $SRC_PFAD/unl/*unl >/dev/null 2>&1

date +'%d.%m.%Y' > $SRC_PFAD/superx.datum  ##neues Entladedatum

HEUTE=`date +'%d.%m.%Y'`

echo "Letztes Update-Datum: " $DATUM >$ERR
echo "DATABASE: $DATABASE" >>$ERR
echo "VERSION:  $VERSION" >>$ERR
echo "SX_CLIENT: $SX_CLIENT" >>$ERR 
echo "0.5b^"$HEUTE"^" >$SRC_PFAD/unl/superx_unload_version.unl  

cd $SRC_PFAD >>$ERR 2>&1

CP=".:$JDBC_CLASSPATH:$XML_CLASSPATH"

case "`uname`" in
CYGWIN*) 
CP=".;$JDBC_CLASSPATH;$XML_CLASSPATH"
;;
esac

cat /dev/null >unload_params.txt

 
if [ "$VERSION" = "" ]
then
VERSION="13"
export VERSION
fi
echo "Parameter VERSION: $VERSION" >>$ERR
echo "\$VERSION=$VERSION" >>unload_params.txt

 
if [ "$LM_ADRESSTAG_MAIL" = "" ]
then
LM_ADRESSTAG_MAIL="1=0"
export LM_ADRESSTAG_MAIL
fi
echo "Parameter LM_ADRESSTAG_MAIL: $LM_ADRESSTAG_MAIL" >>$ERR
echo "\$LM_ADRESSTAG_MAIL=$LM_ADRESSTAG_MAIL" >>unload_params.txt

 
if [ "$PERSONATTRIBUTE_LM_EMAIL" = "" ]
then
PERSONATTRIBUTE_LM_EMAIL="0"
export PERSONATTRIBUTE_LM_EMAIL
fi
echo "Parameter PERSONATTRIBUTE_LM_EMAIL: $PERSONATTRIBUTE_LM_EMAIL" >>$ERR
echo "\$PERSONATTRIBUTE_LM_EMAIL=$PERSONATTRIBUTE_LM_EMAIL" >>unload_params.txt

 
if [ "$LM_PRUEFER_NAME" = "" ]
then
LM_PRUEFER_NAME="false"
export LM_PRUEFER_NAME
fi
echo "Parameter LM_PRUEFER_NAME: $LM_PRUEFER_NAME" >>$ERR
echo "\$LM_PRUEFER_NAME=$LM_PRUEFER_NAME" >>unload_params.txt

 
if [ "$LM_PRUEFUNG_ZUSATZTEXT" = "" ]
then
LM_PRUEFUNG_ZUSATZTEXT="false"
export LM_PRUEFUNG_ZUSATZTEXT
fi
echo "Parameter LM_PRUEFUNG_ZUSATZTEXT: $LM_PRUEFUNG_ZUSATZTEXT" >>$ERR
echo "\$LM_PRUEFUNG_ZUSATZTEXT=$LM_PRUEFUNG_ZUSATZTEXT" >>unload_params.txt

 
if [ "$LM_EXAM_WRITTEN" = "" ]
then
LM_EXAM_WRITTEN="false"
export LM_EXAM_WRITTEN
fi
echo "Parameter LM_EXAM_WRITTEN: $LM_EXAM_WRITTEN" >>$ERR
echo "\$LM_EXAM_WRITTEN=$LM_EXAM_WRITTEN" >>unload_params.txt

 
if [ "$SOURCESYSTEM" = "" ]
then
SOURCESYSTEM="hisinone"
export SOURCESYSTEM

fi
echo "Parameter SOURCESYSTEM: $SOURCESYSTEM"  >>$ERR
echo "\$SOURCESYSTEM=$SOURCESYSTEM" >>unload_params.txt 

#jdbc zum Entladen 
if [ "$SX_CLIENT" = "jdbc" ]
then
java $JAVA_OPTS -cp $CP de.superx.bin.SxExtractor -logger:$LOGGER_PROPERTIES -dbproperties:$DB_PROPERTIES -xml:lm_unload.xml -outFormat:$outFormat -delim:$DBDELIMITER -header:$header -database:$DATABASE -version:$VERSION -unload_params:unload_params.txt >>$ERR 2>&1

exit 0

fi


#
#Unload-Job preparation1
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: preparation1" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "hisinone" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM




DROP TABLE IF EXISTS tmp_lm_course_of_study;
CREATE TABLE tmp_lm_course_of_study (
    id integer NOT NULL,
    lid integer NOT NULL,
    degree_lid integer,
    degree_id integer,
    subject_lid integer,
    subject_id integer,
    major_field_of_study_lid integer,
    major_field_of_study_id integer,
    course_specialization_lid integer,
    course_specialization_id integer,
    k_subject_indicator_id integer,
    k_examinationversion_id integer,
    k_place_of_studies_id integer,
    k_enrollment_id integer,
    k_type_of_study_id integer,
    k_form_of_studies_id integer,
    part_of_studies integer NOT NULL,
    valid_from date,
    valid_to date,
    k_language_id integer NOT NULL,
    shorttext character varying,
    defaulttext character varying NOT NULL,
    longtext character varying,
    orgunit_lid integer,
    orgunit_id integer,
    regular_number_of_semesters integer,
    uniquename character varying,
    from_term_year integer,
    from_term_type_id integer,
    to_term_year integer,
    to_term_type_id integer,
    admission_to_study_id integer,
    is_admission_to_study integer,
    is_course_of_study_start integer,
    k_course_of_study_type_id integer NOT NULL,
    termcategory integer NOT NULL,
    teachingunit_orgunit_lid integer,
    teachingunit_orgunit_id integer,
    k_field_of_study_id integer,
    examination_office_no character varying,
    is_historized smallint
);

" "txt" "$DBDELIMITER" "false" "" >>$ERR 2>&1

fi

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "hisinone" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_preparation1 >>$ERR  2>&1   



DROP TABLE IF EXISTS tmp_lm_course_of_study;
CREATE TABLE tmp_lm_course_of_study (
    id integer NOT NULL,
    lid integer NOT NULL,
    degree_lid integer,
    degree_id integer,
    subject_lid integer,
    subject_id integer,
    major_field_of_study_lid integer,
    major_field_of_study_id integer,
    course_specialization_lid integer,
    course_specialization_id integer,
    k_subject_indicator_id integer,
    k_examinationversion_id integer,
    k_place_of_studies_id integer,
    k_enrollment_id integer,
    k_type_of_study_id integer,
    k_form_of_studies_id integer,
    part_of_studies integer NOT NULL,
    valid_from date,
    valid_to date,
    k_language_id integer NOT NULL,
    shorttext character varying,
    defaulttext character varying NOT NULL,
    longtext character varying,
    orgunit_lid integer,
    orgunit_id integer,
    regular_number_of_semesters integer,
    uniquename character varying,
    from_term_year integer,
    from_term_type_id integer,
    to_term_year integer,
    to_term_type_id integer,
    admission_to_study_id integer,
    is_admission_to_study integer,
    is_course_of_study_start integer,
    k_course_of_study_type_id integer NOT NULL,
    termcategory integer NOT NULL,
    teachingunit_orgunit_lid integer,
    teachingunit_orgunit_id integer,
    k_field_of_study_id integer,
    examination_office_no character varying,
    is_historized smallint
);

--Ende
END_preparation1
fi

fi

#
#Unload-Job preparation2
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: preparation2" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "hisinone" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM





insert into tmp_lm_course_of_study( id,
       lid,
       degree_lid,
       subject_lid,
       major_field_of_study_lid,
       course_specialization_lid,
       k_subject_indicator_id,
       k_examinationversion_id,
       k_place_of_studies_id,
       k_enrollment_id,
       k_type_of_study_id,
       k_form_of_studies_id,
       part_of_studies,
       valid_from,
       valid_to,
       k_language_id,
       shorttext,
       defaulttext,
       longtext,
       orgunit_lid,
       regular_number_of_semesters,
       uniquename,
       from_term_year,
       from_term_type_id,
       to_term_year,
       to_term_type_id,
       admission_to_study_id,
       is_admission_to_study,
       is_course_of_study_start,
       k_course_of_study_type_id,
       termcategory,
       teachingunit_orgunit_lid,
       k_field_of_study_id,
       examination_office_no,
       is_historized)
SELECT id,
       lid,
       degree_lid,
       subject_lid,
       major_field_of_study_lid,
       course_specialization_lid,
       k_subject_indicator_id,
       k_examinationversion_id,
       k_place_of_studies_id,
       k_enrollment_id,
       k_type_of_study_id,
       k_form_of_studies_id,
       part_of_studies,
       valid_from,
       valid_to,
       k_language_id,
       shorttext,
       defaulttext,
       longtext,
       orgunit_lid,
       regular_number_of_semesters,
       uniquename,
       from_term_year,
       from_term_type_id,
       to_term_year,
       to_term_type_id,
       admission_to_study_id,
       is_admission_to_study,
       is_course_of_study_start,
       k_course_of_study_type_id,
       termcategory,
       teachingunit_orgunit_lid,
       k_field_of_study_id,
       examination_office_no,
       0 --is_historized
FROM course_of_study;
--ermitteln der historisierten IDs
--degree
update tmp_lm_course_of_study set degree_id=(select D.id from degree D
where D.lid=tmp_lm_course_of_study.degree_lid
and (D.valid_from <= tmp_lm_course_of_study.valid_from
or D.valid_from is null
or ( D.valid_from is null and tmp_lm_course_of_study.valid_from is null)
)
and (D.valid_to >= tmp_lm_course_of_study.valid_to
or D.valid_to is null
or ( D.valid_from is null and tmp_lm_course_of_study.valid_from is null)
)
);
--wenn degree nicht ermittelt werden kann, dann ohne Historisierung
update tmp_lm_course_of_study set degree_id=(select min(D.id) from degree D
where D.lid=tmp_lm_course_of_study.degree_lid
)
where degree_id is null
;
--subject
update tmp_lm_course_of_study set subject_id=(select D.id from subject D
where D.lid=tmp_lm_course_of_study.subject_lid
and (D.valid_from <= tmp_lm_course_of_study.valid_from
or D.valid_from is null
or ( D.valid_from is null and tmp_lm_course_of_study.valid_from is null)
)
and (D.valid_to >= tmp_lm_course_of_study.valid_to
or D.valid_to is null
or ( D.valid_from is null and tmp_lm_course_of_study.valid_from is null)
)
);
--wenn subject nicht ermittelt werden kann, dann ohne Historisierung
update tmp_lm_course_of_study set subject_id=(select min(D.id) from subject D
where D.lid=tmp_lm_course_of_study.subject_lid
)
where subject_id is null
;
--major_field_of_study
update tmp_lm_course_of_study set major_field_of_study_id=(select D.id from major_field_of_study D
where D.lid=tmp_lm_course_of_study.major_field_of_study_lid
and (D.valid_from <= tmp_lm_course_of_study.valid_from
or D.valid_from is null
or ( D.valid_from is null and tmp_lm_course_of_study.valid_from is null)
)
and (D.valid_to >= tmp_lm_course_of_study.valid_to
or D.valid_to is null
or ( D.valid_from is null and tmp_lm_course_of_study.valid_from is null)
)
);
--course_specialization_lid
update tmp_lm_course_of_study set course_specialization_id=(select D.id from course_specialization D
where D.lid=tmp_lm_course_of_study.course_specialization_lid
and (D.valid_from <= tmp_lm_course_of_study.valid_from
or D.valid_from is null
or ( D.valid_from is null and tmp_lm_course_of_study.valid_from is null)
)
and (D.valid_to >= tmp_lm_course_of_study.valid_to
or D.valid_to is null
or ( D.valid_from is null and tmp_lm_course_of_study.valid_from is null)
)
);
--orgunit
update tmp_lm_course_of_study set orgunit_id=(select D.id from orgunit D
where D.lid=tmp_lm_course_of_study.orgunit_lid
and (D.valid_from <= tmp_lm_course_of_study.valid_from
or D.valid_from is null
or ( D.valid_from is null and tmp_lm_course_of_study.valid_from is null)
)
and (D.valid_to >= tmp_lm_course_of_study.valid_to
or D.valid_to is null
or ( D.valid_from is null and tmp_lm_course_of_study.valid_from is null)
)
);
--wenn Studiengang heute gültig ist und orgunit historisiert, nimmt er den aktuellen FB
update tmp_lm_course_of_study set orgunit_id=(select D.id from orgunit D
where D.lid=tmp_lm_course_of_study.orgunit_lid
and current_date between D.valid_from and D.valid_to)
where current_date between valid_from and valid_to
and orgunit_id is null;


--teachingunit_orgunit_lid

update tmp_lm_course_of_study set teachingunit_orgunit_id=(select D.id from orgunit D
where D.lid=tmp_lm_course_of_study.teachingunit_orgunit_lid
and (D.valid_from <= tmp_lm_course_of_study.valid_from
or D.valid_from is null
or ( D.valid_from is null and tmp_lm_course_of_study.valid_from is null)
)
and (D.valid_to >= tmp_lm_course_of_study.valid_to
or D.valid_to is null
or ( D.valid_from is null and tmp_lm_course_of_study.valid_from is null)
)
)
where teachingunit_orgunit_lid is not null;

--wenn Studiengang heute gültig ist und orgunit historisiert, nimmt er aktuelle LE
update tmp_lm_course_of_study set teachingunit_orgunit_id=(select D.id from orgunit D
where D.lid=tmp_lm_course_of_study.teachingunit_orgunit_lid
and current_date between D.valid_from and D.valid_to)
where current_date between valid_from and valid_to
and teachingunit_orgunit_id is null;


--k_field_of_study
update tmp_lm_course_of_study set k_field_of_study_id=(select S.k_field_of_study_id
from subject S
where S.id=tmp_lm_course_of_study.subject_id)
where k_field_of_study_id is null;
--hochprojizieren auf Fächergruppe
update tmp_lm_course_of_study set k_field_of_study_id=(select K.parent_id
from k_field_of_study K
where K.id=tmp_lm_course_of_study.k_field_of_study_id);

--is_historized=1 wenn es mehrere Studiengänge pro LID gibt
update tmp_lm_course_of_study set is_historized=1
where 1 < (select count(*) from course_of_study C
where C.lid=tmp_lm_course_of_study.lid);

create index tmp_lm_i_tc1 on tmp_lm_course_of_study(lid);


" "txt" "$DBDELIMITER" "false" "" >>$ERR 2>&1

fi

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "hisinone" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_preparation2 >>$ERR  2>&1   




insert into tmp_lm_course_of_study( id,
       lid,
       degree_lid,
       subject_lid,
       major_field_of_study_lid,
       course_specialization_lid,
       k_subject_indicator_id,
       k_examinationversion_id,
       k_place_of_studies_id,
       k_enrollment_id,
       k_type_of_study_id,
       k_form_of_studies_id,
       part_of_studies,
       valid_from,
       valid_to,
       k_language_id,
       shorttext,
       defaulttext,
       longtext,
       orgunit_lid,
       regular_number_of_semesters,
       uniquename,
       from_term_year,
       from_term_type_id,
       to_term_year,
       to_term_type_id,
       admission_to_study_id,
       is_admission_to_study,
       is_course_of_study_start,
       k_course_of_study_type_id,
       termcategory,
       teachingunit_orgunit_lid,
       k_field_of_study_id,
       examination_office_no,
       is_historized)
SELECT id,
       lid,
       degree_lid,
       subject_lid,
       major_field_of_study_lid,
       course_specialization_lid,
       k_subject_indicator_id,
       k_examinationversion_id,
       k_place_of_studies_id,
       k_enrollment_id,
       k_type_of_study_id,
       k_form_of_studies_id,
       part_of_studies,
       valid_from,
       valid_to,
       k_language_id,
       shorttext,
       defaulttext,
       longtext,
       orgunit_lid,
       regular_number_of_semesters,
       uniquename,
       from_term_year,
       from_term_type_id,
       to_term_year,
       to_term_type_id,
       admission_to_study_id,
       is_admission_to_study,
       is_course_of_study_start,
       k_course_of_study_type_id,
       termcategory,
       teachingunit_orgunit_lid,
       k_field_of_study_id,
       examination_office_no,
       0 --is_historized
FROM course_of_study;
--ermitteln der historisierten IDs
--degree
update tmp_lm_course_of_study set degree_id=(select D.id from degree D
where D.lid=tmp_lm_course_of_study.degree_lid
and (D.valid_from <= tmp_lm_course_of_study.valid_from
or D.valid_from is null
or ( D.valid_from is null and tmp_lm_course_of_study.valid_from is null)
)
and (D.valid_to >= tmp_lm_course_of_study.valid_to
or D.valid_to is null
or ( D.valid_from is null and tmp_lm_course_of_study.valid_from is null)
)
);
--wenn degree nicht ermittelt werden kann, dann ohne Historisierung
update tmp_lm_course_of_study set degree_id=(select min(D.id) from degree D
where D.lid=tmp_lm_course_of_study.degree_lid
)
where degree_id is null
;
--subject
update tmp_lm_course_of_study set subject_id=(select D.id from subject D
where D.lid=tmp_lm_course_of_study.subject_lid
and (D.valid_from <= tmp_lm_course_of_study.valid_from
or D.valid_from is null
or ( D.valid_from is null and tmp_lm_course_of_study.valid_from is null)
)
and (D.valid_to >= tmp_lm_course_of_study.valid_to
or D.valid_to is null
or ( D.valid_from is null and tmp_lm_course_of_study.valid_from is null)
)
);
--wenn subject nicht ermittelt werden kann, dann ohne Historisierung
update tmp_lm_course_of_study set subject_id=(select min(D.id) from subject D
where D.lid=tmp_lm_course_of_study.subject_lid
)
where subject_id is null
;
--major_field_of_study
update tmp_lm_course_of_study set major_field_of_study_id=(select D.id from major_field_of_study D
where D.lid=tmp_lm_course_of_study.major_field_of_study_lid
and (D.valid_from <= tmp_lm_course_of_study.valid_from
or D.valid_from is null
or ( D.valid_from is null and tmp_lm_course_of_study.valid_from is null)
)
and (D.valid_to >= tmp_lm_course_of_study.valid_to
or D.valid_to is null
or ( D.valid_from is null and tmp_lm_course_of_study.valid_from is null)
)
);
--course_specialization_lid
update tmp_lm_course_of_study set course_specialization_id=(select D.id from course_specialization D
where D.lid=tmp_lm_course_of_study.course_specialization_lid
and (D.valid_from <= tmp_lm_course_of_study.valid_from
or D.valid_from is null
or ( D.valid_from is null and tmp_lm_course_of_study.valid_from is null)
)
and (D.valid_to >= tmp_lm_course_of_study.valid_to
or D.valid_to is null
or ( D.valid_from is null and tmp_lm_course_of_study.valid_from is null)
)
);
--orgunit
update tmp_lm_course_of_study set orgunit_id=(select D.id from orgunit D
where D.lid=tmp_lm_course_of_study.orgunit_lid
and (D.valid_from <= tmp_lm_course_of_study.valid_from
or D.valid_from is null
or ( D.valid_from is null and tmp_lm_course_of_study.valid_from is null)
)
and (D.valid_to >= tmp_lm_course_of_study.valid_to
or D.valid_to is null
or ( D.valid_from is null and tmp_lm_course_of_study.valid_from is null)
)
);
--wenn Studiengang heute gültig ist und orgunit historisiert, nimmt er den aktuellen FB
update tmp_lm_course_of_study set orgunit_id=(select D.id from orgunit D
where D.lid=tmp_lm_course_of_study.orgunit_lid
and current_date between D.valid_from and D.valid_to)
where current_date between valid_from and valid_to
and orgunit_id is null;


--teachingunit_orgunit_lid

update tmp_lm_course_of_study set teachingunit_orgunit_id=(select D.id from orgunit D
where D.lid=tmp_lm_course_of_study.teachingunit_orgunit_lid
and (D.valid_from <= tmp_lm_course_of_study.valid_from
or D.valid_from is null
or ( D.valid_from is null and tmp_lm_course_of_study.valid_from is null)
)
and (D.valid_to >= tmp_lm_course_of_study.valid_to
or D.valid_to is null
or ( D.valid_from is null and tmp_lm_course_of_study.valid_from is null)
)
)
where teachingunit_orgunit_lid is not null;

--wenn Studiengang heute gültig ist und orgunit historisiert, nimmt er aktuelle LE
update tmp_lm_course_of_study set teachingunit_orgunit_id=(select D.id from orgunit D
where D.lid=tmp_lm_course_of_study.teachingunit_orgunit_lid
and current_date between D.valid_from and D.valid_to)
where current_date between valid_from and valid_to
and teachingunit_orgunit_id is null;


--k_field_of_study
update tmp_lm_course_of_study set k_field_of_study_id=(select S.k_field_of_study_id
from subject S
where S.id=tmp_lm_course_of_study.subject_id)
where k_field_of_study_id is null;
--hochprojizieren auf Fächergruppe
update tmp_lm_course_of_study set k_field_of_study_id=(select K.parent_id
from k_field_of_study K
where K.id=tmp_lm_course_of_study.k_field_of_study_id);

--is_historized=1 wenn es mehrere Studiengänge pro LID gibt
update tmp_lm_course_of_study set is_historized=1
where 1 < (select count(*) from course_of_study C
where C.lid=tmp_lm_course_of_study.lid);

create index tmp_lm_i_tc1 on tmp_lm_course_of_study(lid);


--Ende
END_preparation2
fi

fi

#
#Unload-Job konstanten
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: konstanten" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "hisinone" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM




select 1,6,'LM_Quellsystem' 
;

" "txt" "$DBDELIMITER" "false" "unl/konstanten.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "hisinone" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_konstanten >>$ERR  2>&1   

unload to "unl/konstanten.unl" 



select 1,6,'LM_Quellsystem' 
;

--Ende
END_konstanten
fi

fi

#
#Unload-Job lm_unit
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: lm_unit" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "hisinone" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM



SELECT id,
   6 as sourcesystem,
substring(U.shorttext from 1 for 255),
substring(U.defaulttext from 1 for 255),
substring(U.longtext from 1 for 255),
U.elementnr,
U.calculate_ects_sum,
U.official_statistics,  
U.k_elementtype_id,
U.default_unitrelation_id,
null::char(1) as pdum,
substring(U.uniquename from 1 for 255),
U.hours_per_week,
U.editing_k_status_id,
U.transfer_allowed,
U.freetrial_check,
U.k_unit_purpose_id,
U.valid_from,
U.valid_to,
U.shortcomment
 FROM
 unit U 
    ;


" "txt" "$DBDELIMITER" "false" "unl/lm_unit.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "hisinone" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_lm_unit >>$ERR  2>&1   

unload to "unl/lm_unit.unl" 


SELECT id,
   6 as sourcesystem,
substring(U.shorttext from 1 for 255),
substring(U.defaulttext from 1 for 255),
substring(U.longtext from 1 for 255),
U.elementnr,
U.calculate_ects_sum,
U.official_statistics,  
U.k_elementtype_id,
U.default_unitrelation_id,
null::char(1) as pdum,
substring(U.uniquename from 1 for 255),
U.hours_per_week,
U.editing_k_status_id,
U.transfer_allowed,
U.freetrial_check,
U.k_unit_purpose_id,
U.valid_from,
U.valid_to,
U.shortcomment
 FROM
 unit U 
    ;


--Ende
END_lm_unit
fi

fi

#
#Unload-Job lm_unit_studies
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: lm_unit_studies" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "hisinone" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM



SELECT US.id,
   6 as sourcesystem,
US.unit_id,
US.course_of_study_lid,
US.root_elementtype_hiskey
from unit_studies US
where US.root_elementtype_hiskey=4 --nur Prüfungen #189067


" "txt" "$DBDELIMITER" "false" "unl/lm_unit_studies.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "hisinone" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_lm_unit_studies >>$ERR  2>&1   

unload to "unl/lm_unit_studies.unl" 


SELECT US.id,
   6 as sourcesystem,
US.unit_id,
US.course_of_study_lid,
US.root_elementtype_hiskey
from unit_studies US
where US.root_elementtype_hiskey=4 --nur Prüfungen #189067


--Ende
END_lm_unit_studies
fi

fi

#
#Unload-Job lm_course_of_study
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: lm_course_of_study" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "hisinone" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM



SELECT C.id,
C.lid,
   6 as sourcesystem,
substring(C.uniquename from 1 for 255),
substring(C.shorttext from 1 for 255),
substring(C.defaulttext from 1 for 255),
substring(C.longtext from 1 for 255),
C.k_examinationversion_id,--    pversion,
C.orgunit_id,--       fb,
C.k_enrollment_id,--   stutyp,
C.k_subject_indicator_id,--   kzfa,
C.k_place_of_studies_id,--   stort,
C.teachingunit_orgunit_id,--  lehreinh,
C.degree_id,--   abschl,
C.subject_id,--  stg,
C.major_field_of_study_id,--  vert,
C.course_specialization_id,--  schwp,
C.k_type_of_study_id,--    stuart,
C.k_form_of_studies_id,--  stufrm,
C.regular_number_of_semesters,--  regelstz,
'' || C.to_term_year || T.termnumber, --  sem_gueltigbis
C.part_of_studies,
C.valid_from,
C.valid_to
       FROM tmp_lm_course_of_study C
       left outer join term_type  T on (C.to_term_type_id=T.id);

" "txt" "$DBDELIMITER" "false" "unl/lm_course_of_study.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "hisinone" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_lm_course_of_study >>$ERR  2>&1   

unload to "unl/lm_course_of_study.unl" 


SELECT C.id,
C.lid,
   6 as sourcesystem,
substring(C.uniquename from 1 for 255),
substring(C.shorttext from 1 for 255),
substring(C.defaulttext from 1 for 255),
substring(C.longtext from 1 for 255),
C.k_examinationversion_id,--    pversion,
C.orgunit_id,--       fb,
C.k_enrollment_id,--   stutyp,
C.k_subject_indicator_id,--   kzfa,
C.k_place_of_studies_id,--   stort,
C.teachingunit_orgunit_id,--  lehreinh,
C.degree_id,--   abschl,
C.subject_id,--  stg,
C.major_field_of_study_id,--  vert,
C.course_specialization_id,--  schwp,
C.k_type_of_study_id,--    stuart,
C.k_form_of_studies_id,--  stufrm,
C.regular_number_of_semesters,--  regelstz,
'' || C.to_term_year || T.termnumber, --  sem_gueltigbis
C.part_of_studies,
C.valid_from,
C.valid_to
       FROM tmp_lm_course_of_study C
       left outer join term_type  T on (C.to_term_type_id=T.id);

--Ende
END_lm_course_of_study
fi

fi

#
#Unload-Job lm_unitrelation
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: lm_unitrelation" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "hisinone" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM



SELECT R.id,
6 as sourcesystem,
R.parent_unit_id,
R.child_unit_id,
R.k_unitrelationtype_id,
R.recommended_semester,
R.bonus,
R.malus,
R.generation_weight,
--neu
G.type_of_grading,
R.sortorder,
R.k_compulsory_id,
R.alternative_recommended_semester
 FROM
 unitrelation R left outer join grading_type G
 on (R.grading_type_id = G.id)
 ;


" "txt" "$DBDELIMITER" "false" "unl/lm_unitrelation.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "hisinone" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_lm_unitrelation >>$ERR  2>&1   

unload to "unl/lm_unitrelation.unl" 


SELECT R.id,
6 as sourcesystem,
R.parent_unit_id,
R.child_unit_id,
R.k_unitrelationtype_id,
R.recommended_semester,
R.bonus,
R.malus,
R.generation_weight,
--neu
G.type_of_grading,
R.sortorder,
R.k_compulsory_id,
R.alternative_recommended_semester
 FROM
 unitrelation R left outer join grading_type G
 on (R.grading_type_id = G.id)
 ;


--Ende
END_lm_unitrelation
fi

fi

#
#Unload-Job lm_examrelation
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: lm_examrelation" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "hisinone" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM



SELECT R.id,
6 as sourcesystem,
R.parent_examplan_id,
R.child_examplan_id,
R.k_unitrelationtype_id,
null::integer as unit_id,
R.bonus,
R.malus,
R.k_workstatus_id,
R.credits_used_for_weighting,
(case when A.hiskey_id=1001 then 1::integer else 0::integer end) as is_approved,
R.k_internal_accreditationtype_id,
R.date_of_work,
'' || R.term_year || T.termnumber as sem_der_pruefung
 FROM
 examrelation R left outer join k_internal_accreditationtype A
 on (A.id=R.k_internal_accreditationtype_id)
 left outer join term_type T
 on (T.id = R.term_type_id)
  
    ;


" "txt" "$DBDELIMITER" "false" "unl/lm_examrelation.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "hisinone" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_lm_examrelation >>$ERR  2>&1   

unload to "unl/lm_examrelation.unl" 


SELECT R.id,
6 as sourcesystem,
R.parent_examplan_id,
R.child_examplan_id,
R.k_unitrelationtype_id,
null::integer as unit_id,
R.bonus,
R.malus,
R.k_workstatus_id,
R.credits_used_for_weighting,
(case when A.hiskey_id=1001 then 1::integer else 0::integer end) as is_approved,
R.k_internal_accreditationtype_id,
R.date_of_work,
'' || R.term_year || T.termnumber as sem_der_pruefung
 FROM
 examrelation R left outer join k_internal_accreditationtype A
 on (A.id=R.k_internal_accreditationtype_id)
 left outer join term_type T
 on (T.id = R.term_type_id)
  
    ;


--Ende
END_lm_examrelation
fi

fi

#
#Unload-Job lm_examination
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: lm_examination" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "hisinone" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM



SELECT E.id,
6 as sourcesystem,
E.unit_id,
E.source_event_unit_id,
E.k_examform_id,
E.k_examination_type_id,
E.exam_written
 FROM
 examination E  
    ;


" "txt" "$DBDELIMITER" "false" "unl/lm_examination.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "hisinone" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_lm_examination >>$ERR  2>&1   

unload to "unl/lm_examination.unl" 


SELECT E.id,
6 as sourcesystem,
E.unit_id,
E.source_event_unit_id,
E.k_examform_id,
E.k_examination_type_id,
E.exam_written
 FROM
 examination E  
    ;


--Ende
END_lm_examination
fi

fi

#
#Unload-Job lm_examplan
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: lm_examplan" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "hisinone" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM



SELECT S.registrationnumber,--TODO: Pseudonym
E.id,
6 as sourcesystem,
E.unit_id,
E.person_id,
E.planelement_id,
E.cancelation, --prueck
E.date_of_work, --pdatum
E.semesterhours,
E.k_examform_id, --pform
'' || E.term_year || T.termnumber,--psem,
E.term_segment, --ptermin
E.k_grade_assessment_status_id,
E.k_remark_on_exam_id, --pvermerk
E.default_examrelation_id,
E.cancelation_impossible,
E.additional_work,
G.grade, --pnote TODO: umrechung bei Staatsexamen Jura in Note
G.score,
null::integer as panerk,
G.attempt,
G.free_trial
FROM student S,   term_type T , unit U, k_elementtype K ,examplan E , examrelation R left outer join examresult G
on (G.examrelation_id=R.id)
where E.default_examrelation_id=R.id
and U.id=E.unit_id
and U.k_elementtype_id=K.id
and T.id = E.term_type_id
and S.person_id = E.person_id
  AND (
    U.uniquename != 'AP-EXT'
    OR U.uniquename IS NULL
  ) --ext.Pruefungnen ausschliessen
  AND (K.hiskey_id is null or K.hiskey_id not in (7,10)) --keine HZB-Leistungen, Einzureichende Unterlagen für STU #189067
  ;



" "txt" "$DBDELIMITER" "false" "unl/lm_examplan.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "hisinone" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_lm_examplan >>$ERR  2>&1   

unload to "unl/lm_examplan.unl" 


SELECT S.registrationnumber,--TODO: Pseudonym
E.id,
6 as sourcesystem,
E.unit_id,
E.person_id,
E.planelement_id,
E.cancelation, --prueck
E.date_of_work, --pdatum
E.semesterhours,
E.k_examform_id, --pform
'' || E.term_year || T.termnumber,--psem,
E.term_segment, --ptermin
E.k_grade_assessment_status_id,
E.k_remark_on_exam_id, --pvermerk
E.default_examrelation_id,
E.cancelation_impossible,
E.additional_work,
G.grade, --pnote TODO: umrechung bei Staatsexamen Jura in Note
G.score,
null::integer as panerk,
G.attempt,
G.free_trial
FROM student S,   term_type T , unit U, k_elementtype K ,examplan E , examrelation R left outer join examresult G
on (G.examrelation_id=R.id)
where E.default_examrelation_id=R.id
and U.id=E.unit_id
and U.k_elementtype_id=K.id
and T.id = E.term_type_id
and S.person_id = E.person_id
  AND (
    U.uniquename != 'AP-EXT'
    OR U.uniquename IS NULL
  ) --ext.Pruefungnen ausschliessen
  AND (K.hiskey_id is null or K.hiskey_id not in (7,10)) --keine HZB-Leistungen, Einzureichende Unterlagen für STU #189067
  ;



--Ende
END_lm_examplan
fi

fi

#
#Unload-Job lm_exam_instructor
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: lm_exam_instructor" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "hisinone" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM




select E.id,
6 as sourcesystem,
null as ordnr,
PE.surname,
PE.firstname,
PA.sortorder as ordnr2
from hisinone.examplan E, hisinone.planelement P, hisinone.planned_dates PD, hisinone.planable A, hisinone.person_planable PA, hisinone.person PE
where E.planelement_id=P.id
and A.id=P.id
and PD.planable_id=A.id
and A.id=PA.planable_id
and PA.abstract_person_id=PE.id
and '$LM_PRUEFER_NAME'='true'
union
select E.id,
6 as sourcesystem,
1 as ordnr,
PE.surname,
PE.firstname,
I.sortorder as ordnr2
from hisinone.examplan E, hisinone.planelement P, hisinone.planned_dates PD, hisinone.planable A, hisinone.instructor I, hisinone.k_instructortask IT, hisinone.person PE
where E.planelement_id=P.id
and A.id=P.id
and PD.planable_id=A.id
and PD.id=I.planned_dates_id
and I.k_instructortask_id=IT.id
and IT.hiskey_id =1 
and I.abstract_person_id=PE.id
and '$LM_PRUEFER_NAME'='true'
union
select E.id,
6 as sourcesystem,
2 as ordnr,
PE.surname,
PE.firstname,
I.sortorder as ordnr2
from hisinone.examplan E, hisinone.planelement P, hisinone.planned_dates PD, hisinone.planable A, hisinone.instructor I, hisinone.k_instructortask IT, hisinone.person PE
where E.planelement_id=P.id
and A.id=P.id
and PD.planable_id=A.id
and PD.id=I.planned_dates_id
and I.k_instructortask_id=IT.id
and IT.hiskey_id =2
and I.abstract_person_id=PE.id
and '$LM_PRUEFER_NAME'='true'
--Prüfungen ohne Veranstaltung, z.B. Abschlussarbeiten:
union
select E.id,
6 as sourcesystem,
IT.hiskey_id as ordnr,
P.surname,
P.firstname,
null as ordnr2
from hisinone.examplan E, hisinone.examrelation R, hisinone.examresult ER,hisinone.examvaluation V, hisinone.k_instructortask IT, hisinone.person P
where (E.default_examrelation_id=R.id or R.child_examplan_id=E.id)
and V.examresult_id=ER.id
and ER.examrelation_id=R.id
and IT.id=V.k_instructortask_id
and P.id=V.person_id
and '$LM_PRUEFER_NAME'='true'




" "txt" "$DBDELIMITER" "false" "unl/lm_exam_instructor.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "hisinone" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_lm_exam_instructor >>$ERR  2>&1   

unload to "unl/lm_exam_instructor.unl" 



select E.id,
6 as sourcesystem,
null as ordnr,
PE.surname,
PE.firstname,
PA.sortorder as ordnr2
from hisinone.examplan E, hisinone.planelement P, hisinone.planned_dates PD, hisinone.planable A, hisinone.person_planable PA, hisinone.person PE
where E.planelement_id=P.id
and A.id=P.id
and PD.planable_id=A.id
and A.id=PA.planable_id
and PA.abstract_person_id=PE.id
and '$LM_PRUEFER_NAME'='true'
union
select E.id,
6 as sourcesystem,
1 as ordnr,
PE.surname,
PE.firstname,
I.sortorder as ordnr2
from hisinone.examplan E, hisinone.planelement P, hisinone.planned_dates PD, hisinone.planable A, hisinone.instructor I, hisinone.k_instructortask IT, hisinone.person PE
where E.planelement_id=P.id
and A.id=P.id
and PD.planable_id=A.id
and PD.id=I.planned_dates_id
and I.k_instructortask_id=IT.id
and IT.hiskey_id =1 
and I.abstract_person_id=PE.id
and '$LM_PRUEFER_NAME'='true'
union
select E.id,
6 as sourcesystem,
2 as ordnr,
PE.surname,
PE.firstname,
I.sortorder as ordnr2
from hisinone.examplan E, hisinone.planelement P, hisinone.planned_dates PD, hisinone.planable A, hisinone.instructor I, hisinone.k_instructortask IT, hisinone.person PE
where E.planelement_id=P.id
and A.id=P.id
and PD.planable_id=A.id
and PD.id=I.planned_dates_id
and I.k_instructortask_id=IT.id
and IT.hiskey_id =2
and I.abstract_person_id=PE.id
and '$LM_PRUEFER_NAME'='true'
--Prüfungen ohne Veranstaltung, z.B. Abschlussarbeiten:
union
select E.id,
6 as sourcesystem,
IT.hiskey_id as ordnr,
P.surname,
P.firstname,
null as ordnr2
from hisinone.examplan E, hisinone.examrelation R, hisinone.examresult ER,hisinone.examvaluation V, hisinone.k_instructortask IT, hisinone.person P
where (E.default_examrelation_id=R.id or R.child_examplan_id=E.id)
and V.examresult_id=ER.id
and ER.examrelation_id=R.id
and IT.id=V.k_instructortask_id
and P.id=V.person_id
and '$LM_PRUEFER_NAME'='true'




--Ende
END_lm_exam_instructor
fi

fi

#
#Unload-Job lm_accreditation
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: lm_accreditation" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "hisinone" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM



SELECT A.id,
       A.examplan_id,
       null::char(1) as accreditation_person,
       A.accreditation_date,
       A.k_accreditationtype_id,
       6 as sourcesystem,
       null::integer as origin_examplan_id
FROM accreditation A
 ;


" "txt" "$DBDELIMITER" "false" "unl/lm_accreditation.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "hisinone" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_lm_accreditation >>$ERR  2>&1   

unload to "unl/lm_accreditation.unl" 


SELECT A.id,
       A.examplan_id,
       null::char(1) as accreditation_person,
       A.accreditation_date,
       A.k_accreditationtype_id,
       6 as sourcesystem,
       null::integer as origin_examplan_id
FROM accreditation A
 ;


--Ende
END_lm_accreditation
fi

fi

#
#Unload-Job lm_accreditation_relation
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: lm_accreditation_relation" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "hisinone" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM



SELECT origin_examplan_id,
       accreditation_examplan_id
FROM accreditation_relation
 ;


" "txt" "$DBDELIMITER" "false" "unl/lm_accreditation_relation.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "hisinone" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_lm_accreditation_relation >>$ERR  2>&1   

unload to "unl/lm_accreditation_relation.unl" 


SELECT origin_examplan_id,
       accreditation_examplan_id
FROM accreditation_relation
 ;


--Ende
END_lm_accreditation_relation
fi

fi

#
#Unload-Job cifx
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: cifx" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "hisinone" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM




   SELECT
   9015,
-1,
   ('' || id)::varchar(255) as id,
   substring(shorttext from 1 for 10),
   substring(defaulttext from 1 for 100),
   substring(longtext from 1 for 150),
null::char(1),--astat,
null::char(1),--parent
uniquename,
null::char(1), --bund_apnr
substring('' || k_language_id from 1 for 3), --sprache,
null::char(1), --gueltig von
null::char(1), --gueltig bis
id , --sourcesystem_id
'' || hiskey_id,
null::char(1),  --struktur_c
null::char(1) as lid,
null::char(255) as parent_lid,
sortorder
   FROM k_unitrelationtype
   union
     SELECT
   9016,
-1,
   ('' || id)::varchar(255) as id,
   substring(shorttext from 1 for 10),
   substring(defaulttext from 1 for 100),
   substring(longtext from 1 for 150),
null::char(1),--astat,
null::char(1),--parent
uniquename,
null::char(1), --bund_apnr
substring('' || k_language_id from 1 for 3), --sprache,
null::char(1), --gueltig von
null::char(1), --gueltig bis
id , --sourcesystem_id
'' || hiskey_id,
null::char(1),  --struktur_c
null::char(1) as lid,
null::char(255) as parent_lid,
sortorder
   FROM k_accreditationtype
   union
     SELECT
   9017,
-1,
   ('' || id)::varchar(255) as id,
   substring(shorttext from 1 for 10),
   substring(defaulttext from 1 for 100),
   substring(longtext from 1 for 150),
null::char(1),--astat,
null::char(1),--parent
uniquename,
null::char(1), --bund_apnr
substring('' || k_language_id from 1 for 3), --sprache,
null::char(1), --gueltig von
null::char(1), --gueltig bis
id , --sourcesystem_id
'' || hiskey_id,
null::char(1),  --struktur_c
null::char(1) as lid,
null::char(255) as parent_lid,
sortorder
   FROM k_additional_examtext_type
     union
     SELECT
   9018,
-1,
   ('' || id)::varchar(255) as id,
   substring(shorttext from 1 for 10),
   substring(defaulttext from 1 for 100),
   substring(longtext from 1 for 150),
null::char(1),--astat,
null::char(1),--parent
uniquename,
null::char(1), --bund_apnr
substring('' || k_language_id from 1 for 3), --sprache,
null::char(1), --gueltig von
null::char(1), --gueltig bis
id , --sourcesystem_id
'' || hiskey_id,
null::char(1),  --struktur_c
null::char(1) as lid,
null::char(255) as parent_lid,
sortorder
   FROM k_compulsory
   union
     SELECT
   9019,
-1,
   ('' || id)::varchar(255) as id,
   substring(shorttext from 1 for 10),
   substring(defaulttext from 1 for 100),
   substring(longtext from 1 for 150),
null::char(1),--astat,
null::char(1),--parent
uniquename,
null::char(1), --bund_apnr
substring('' || k_language_id from 1 for 3), --sprache,
null::char(1), --gueltig von
null::char(1), --gueltig bis
id , --sourcesystem_id
'' || hiskey_id,
null::char(1),  --struktur_c
null::char(1) as lid,
null::char(255) as parent_lid,
sortorder
   FROM k_internal_accreditationtype
   
  ;

" "txt" "$DBDELIMITER" "false" "unl/cifx.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "hisinone" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_cifx >>$ERR  2>&1   

unload to "unl/cifx.unl" 



   SELECT
   9015,
-1,
   ('' || id)::varchar(255) as id,
   substring(shorttext from 1 for 10),
   substring(defaulttext from 1 for 100),
   substring(longtext from 1 for 150),
null::char(1),--astat,
null::char(1),--parent
uniquename,
null::char(1), --bund_apnr
substring('' || k_language_id from 1 for 3), --sprache,
null::char(1), --gueltig von
null::char(1), --gueltig bis
id , --sourcesystem_id
'' || hiskey_id,
null::char(1),  --struktur_c
null::char(1) as lid,
null::char(255) as parent_lid,
sortorder
   FROM k_unitrelationtype
   union
     SELECT
   9016,
-1,
   ('' || id)::varchar(255) as id,
   substring(shorttext from 1 for 10),
   substring(defaulttext from 1 for 100),
   substring(longtext from 1 for 150),
null::char(1),--astat,
null::char(1),--parent
uniquename,
null::char(1), --bund_apnr
substring('' || k_language_id from 1 for 3), --sprache,
null::char(1), --gueltig von
null::char(1), --gueltig bis
id , --sourcesystem_id
'' || hiskey_id,
null::char(1),  --struktur_c
null::char(1) as lid,
null::char(255) as parent_lid,
sortorder
   FROM k_accreditationtype
   union
     SELECT
   9017,
-1,
   ('' || id)::varchar(255) as id,
   substring(shorttext from 1 for 10),
   substring(defaulttext from 1 for 100),
   substring(longtext from 1 for 150),
null::char(1),--astat,
null::char(1),--parent
uniquename,
null::char(1), --bund_apnr
substring('' || k_language_id from 1 for 3), --sprache,
null::char(1), --gueltig von
null::char(1), --gueltig bis
id , --sourcesystem_id
'' || hiskey_id,
null::char(1),  --struktur_c
null::char(1) as lid,
null::char(255) as parent_lid,
sortorder
   FROM k_additional_examtext_type
     union
     SELECT
   9018,
-1,
   ('' || id)::varchar(255) as id,
   substring(shorttext from 1 for 10),
   substring(defaulttext from 1 for 100),
   substring(longtext from 1 for 150),
null::char(1),--astat,
null::char(1),--parent
uniquename,
null::char(1), --bund_apnr
substring('' || k_language_id from 1 for 3), --sprache,
null::char(1), --gueltig von
null::char(1), --gueltig bis
id , --sourcesystem_id
'' || hiskey_id,
null::char(1),  --struktur_c
null::char(1) as lid,
null::char(255) as parent_lid,
sortorder
   FROM k_compulsory
   union
     SELECT
   9019,
-1,
   ('' || id)::varchar(255) as id,
   substring(shorttext from 1 for 10),
   substring(defaulttext from 1 for 100),
   substring(longtext from 1 for 150),
null::char(1),--astat,
null::char(1),--parent
uniquename,
null::char(1), --bund_apnr
substring('' || k_language_id from 1 for 3), --sprache,
null::char(1), --gueltig von
null::char(1), --gueltig bis
id , --sourcesystem_id
'' || hiskey_id,
null::char(1),  --struktur_c
null::char(1) as lid,
null::char(255) as parent_lid,
sortorder
   FROM k_internal_accreditationtype
   
  ;

--Ende
END_cifx
fi

fi

#
#Unload-Job lm_stud_d
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: lm_stud_d" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "hisinone" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


    
select S.registrationnumber,
P.nameprefix,
P.surname,
P.namesuffix,
P.firstname,
A.eaddress ,
PA.attributevalue
from
k_notificationcategory N, address_k_notificationcategory AN, address A, student S, eaddresstype EAT, k_addresstag AT, person P 
left outer join personattribute PA on (P.id=PA.person_id
and current_date between PA.valid_from and PA.valid_to
and PA.personattributetype_id = ($PERSONATTRIBUTE_LM_EMAIL)
) 
where N.id=AN.k_notificationcategory_id
and A.id=AN.address_id
and P.id=A.person_id
and P.id=S.person_id
and EAT.id=A.eaddresstype_id
and EAT.hiskey_id=10 --Email
and A.k_addresstag_id=AT.id
and $LM_ADRESSTAG_MAIL 
and N.hiskey_id=2 --Studium - Korrespondenz 


" "txt" "$DBDELIMITER" "false" "unl/lm_stud_d.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "hisinone" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_lm_stud_d >>$ERR  2>&1   

unload to "unl/lm_stud_d.unl" 

    
select S.registrationnumber,
P.nameprefix,
P.surname,
P.namesuffix,
P.firstname,
A.eaddress ,
PA.attributevalue
from
k_notificationcategory N, address_k_notificationcategory AN, address A, student S, eaddresstype EAT, k_addresstag AT, person P 
left outer join personattribute PA on (P.id=PA.person_id
and current_date between PA.valid_from and PA.valid_to
and PA.personattributetype_id = ($PERSONATTRIBUTE_LM_EMAIL)
) 
where N.id=AN.k_notificationcategory_id
and A.id=AN.address_id
and P.id=A.person_id
and P.id=S.person_id
and EAT.id=A.eaddresstype_id
and EAT.hiskey_id=10 --Email
and A.k_addresstag_id=AT.id
and $LM_ADRESSTAG_MAIL 
and N.hiskey_id=2 --Studium - Korrespondenz 


--Ende
END_lm_stud_d
fi

fi

#
#Unload-Job lm_unit_top
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: lm_unit_top" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "hisinone" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


    

SELECT id,
       unit_id,
       top_unit_id,
       6
FROM unit_top;

" "txt" "$DBDELIMITER" "false" "unl/lm_unit_top.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "hisinone" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_lm_unit_top >>$ERR  2>&1   

unload to "unl/lm_unit_top.unl" 

    

SELECT id,
       unit_id,
       top_unit_id,
       6
FROM unit_top;

--Ende
END_lm_unit_top
fi

fi

#
#Unload-Job lm_exam_written
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: lm_exam_written" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "hisinone" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


    

SELECT id,
       examplan_id,
       date_of_application,
       startdate,
       planned_end,
       real_end,
       SUBSTRING (title, 1, 255),
       commentary,
       6
FROM exam_written
where 
	'$LM_EXAM_WRITTEN'='true'
;

" "txt" "$DBDELIMITER" "false" "unl/lm_exam_written.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "hisinone" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_lm_exam_written >>$ERR  2>&1   

unload to "unl/lm_exam_written.unl" 

    

SELECT id,
       examplan_id,
       date_of_application,
       startdate,
       planned_end,
       real_end,
       SUBSTRING (title, 1, 255),
       commentary,
       6
FROM exam_written
where 
	'$LM_EXAM_WRITTEN'='true'
;

--Ende
END_lm_exam_written
fi

fi

#
#Unload-Job lm_additional_examtext
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: lm_additional_examtext" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "hisinone" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


    

SELECT id,
       examplan_id,
       k_additional_examtext_type_id,
       additional_text,
       k_language_id,
       6
FROM additional_examtext
where 
	'$LM_PRUEFUNG_ZUSATZTEXT'='true'
;

" "txt" "$DBDELIMITER" "false" "unl/lm_additional_examtext.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "hisinone" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_lm_additional_examtext >>$ERR  2>&1   

unload to "unl/lm_additional_examtext.unl" 

    

SELECT id,
       examplan_id,
       k_additional_examtext_type_id,
       additional_text,
       k_language_id,
       6
FROM additional_examtext
where 
	'$LM_PRUEFUNG_ZUSATZTEXT'='true'
;

--Ende
END_lm_additional_examtext
fi

fi

#
#Unload-Job finalize
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: finalize" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "hisinone" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM





drop table tmp_lm_course_of_study;

" "txt" "$DBDELIMITER" "false" "" >>$ERR 2>&1

fi

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "hisinone" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_finalize >>$ERR  2>&1   




drop table tmp_lm_course_of_study;

--Ende
END_finalize
fi

fi

#Nachbearbeitung der unl-Dateien:
#Zumächst maskierte "\ " entfernen, Postgres kommt damit nicht klar
sed '/\\ /s///g' unl/konstanten.unl >tmp.unl   
mv tmp.unl unl/konstanten.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/lm_unit.unl >tmp.unl   
mv tmp.unl unl/lm_unit.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/lm_unit_studies.unl >tmp.unl   
mv tmp.unl unl/lm_unit_studies.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/lm_course_of_study.unl >tmp.unl   
mv tmp.unl unl/lm_course_of_study.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/lm_unitrelation.unl >tmp.unl   
mv tmp.unl unl/lm_unitrelation.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/lm_examrelation.unl >tmp.unl   
mv tmp.unl unl/lm_examrelation.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/lm_examination.unl >tmp.unl   
mv tmp.unl unl/lm_examination.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/lm_examplan.unl >tmp.unl   
mv tmp.unl unl/lm_examplan.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/lm_exam_instructor.unl >tmp.unl   
mv tmp.unl unl/lm_exam_instructor.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/lm_accreditation.unl >tmp.unl   
mv tmp.unl unl/lm_accreditation.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/lm_accreditation_relation.unl >tmp.unl   
mv tmp.unl unl/lm_accreditation_relation.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/cifx.unl >tmp.unl   
mv tmp.unl unl/cifx.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/lm_stud_d.unl >tmp.unl   
mv tmp.unl unl/lm_stud_d.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/lm_unit_top.unl >tmp.unl   
mv tmp.unl unl/lm_unit_top.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/lm_exam_written.unl >tmp.unl   
mv tmp.unl unl/lm_exam_written.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/lm_additional_examtext.unl >tmp.unl   
mv tmp.unl unl/lm_additional_examtext.unl >>$ERR 2>&1 


chmod go+r $ERR
chmod go+r $SRC_PFAD/superx.datum
chmod go+r $SRC_PFAD/superx.datum.alt
chmod go+w $SRC_PFAD/superx.datum
chmod go+w $SRC_PFAD/superx.datum.alt

chmod go+r $SRC_PFAD/unl/*

##Herstellen altes Entladedatum bei Fehler
fgrep -s "not found" $ERR >/dev/null
FLAG1=$?
fgrep -i -s "nicht gefunden" $ERR >/dev/null
FLAG2=$?
fgrep -i -s "error" $ERR >/dev/null
FLAG3=$? >/dev/null
fgrep -i -s "exception" $ERR >/dev/null 
FLAG4=$? >/dev/null

if [ $FLAG1 -eq 0 -o $FLAG2 -eq 0 -o $FLAG3 -eq 0 -o $FLAG4 -eq 0 ]
then
	echo "Fehler beim Entladen. Das Datum wird zurückgesetzt." 
	echo "---------------------------------------" 
	echo "Prüfen Sie Fehlerprotokoll: $ERR" 
	echo "---------------------------------------" 
	cp $SRC_PFAD/superx.datum.alt $SRC_PFAD/superx.datum 
fi
