
--freemarker template
<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>

-- drop table if exists lm_unittree;
-- 
-- 
-- create table lm_unittree(
-- ebene integer,
-- sortnr varchar(255),
-- unit_id INTEGER , 
-- parent_unit_id integer,
-- top_unit_id integer,
-- sourcesystem INTEGER , 
-- stg CHAR(10) , 
-- abschluss char(10),
-- kz_fach CHAR(10) , 
-- stort CHAR(10) , 
-- vertfg CHAR(10) , 
-- schwerpunkt CHAR(10) , 
-- pversion INTEGER , 
-- pversion_uniquename VARCHAR(255) ,
-- stutyp CHAR(10) , 
-- stufrm CHAR(10) , 
-- unitrelationtype  char(10),
-- calculate_ects_sum integer default 0,
-- course_of_study_lid INTEGER
-- ) 
-- ;

create temp table tmp_unittree(
ebene integer,
sortnr varchar(255),
unit_id INTEGER , 
unit_uniquename varchar(255),
unit_elementnr  varchar(255),
parent_unit_id integer,
parent_unit_uniquename varchar(255),
parent_unit_elementnr varchar(255),
top_unit_id integer,
sourcesystem INTEGER , 
stg CHAR(10) , 
abschluss char(10),
kz_fach CHAR(10) , 
stort CHAR(10) , 
vertfg CHAR(10) , 
schwerpunkt CHAR(10) , 
pversion INTEGER , 
pversion_uniquename VARCHAR(255) ,
stutyp CHAR(10) , 
stufrm CHAR(10) , 
unitrelationtype  char(10),
calculate_ects_sum   integer default 0,
calculate_ects_aktiv integer default 0,
course_of_study_lid INTEGER,
tid_stg integer
) 
;
create temp table tmp_unit_u(
unit_id INTEGER , 
unit_uniquename varchar(255),
unit_elementnr  varchar(255),
parent_unit_id integer,
parent_unit_uniquename varchar(255),
parent_unit_elementnr varchar(255),
top_unit_id integer,
sourcesystem INTEGER ,
sortnr varchar(255),
unitrelationtype  char(10),
calculate_ects_sum integer,
course_of_study_lid INTEGER
);

create temp table tmp_unit_o(
unit_id INTEGER , 
unit_uniquename varchar(255),
unit_elementnr  varchar(255),
parent_unit_id integer,
parent_unit_uniquename varchar(255),
parent_unit_elementnr varchar(255),
top_unit_id integer,
sourcesystem INTEGER,
sortnr varchar(255),
unitrelationtype  char(10),
calculate_ects_sum  integer,
course_of_study_lid INTEGER
);



--zuerst PO als root:
insert into tmp_unittree(
ebene ,
sortnr,
unit_id  ,
unit_uniquename,
unit_elementnr,
parent_unit_id ,
top_unit_id ,
calculate_ects_sum,
sourcesystem , 
course_of_study_lid )
select 1 as ebene,
'0' as sortnr,
U.id,
U.uniquename,
U.elementnr,
null::integer,
U.id as top_unit_id,
nvl(U.calculate_ects_sum,0),
U.sourcesystem,
US.course_of_study_lid
from lm_unit U, lm_unit_studies US
 where
U.id=US.unit_id
and U.sourcesystem=US.sourcesystem
and U.elementtyp='PO'
--TEST:
--and U.id in (26571,26685,20992,20983,6054,7261)
  ;
  
insert into tmp_unit_u
( unit_id,
unit_uniquename,
unit_elementnr,
parent_unit_id,
top_unit_id,
calculate_ects_sum,
sourcesystem,
sortnr,
course_of_study_lid )
select T.unit_id,
T.unit_uniquename,
T.unit_elementnr,
T.parent_unit_id,
top_unit_id,
calculate_ects_sum,
T.sourcesystem,
T.sortnr,
T.course_of_study_lid
from tmp_unittree T;


<#list 2..15 as ebene>

--hier beginnt Schleife:
insert into tmp_unit_o
( unit_id,
parent_unit_uniquename,
parent_unit_elementnr,
parent_unit_id,
top_unit_id,
calculate_ects_sum,
sourcesystem,
sortnr,
unitrelationtype,
course_of_study_lid)
select R.child_unit_id,
T.unit_uniquename,
T.unit_elementnr,
R.parent_unit_id,
T.top_unit_id,
(case when T.calculate_ects_sum=1 then T.calculate_ects_sum else nvl(U.calculate_ects_sum,0) end) as calculate_ects_sum, --sobald ein Knoten 1 hat, wird es an die Kinder vererbt
R.sourcesystem,
T.sortnr || '_' || T.unit_id || '_' || string_not_null(R.sortorder),
R.unitrelationtype,
US.course_of_study_lid
from lm_unit U,lm_unitrelation R ,tmp_unit_u T left outer join lm_unit_studies US
on (US.unit_id=T.unit_id
and T.course_of_study_lid=US.course_of_study_lid
and US.sourcesystem=T.sourcesystem
)
where R.parent_unit_id=T.unit_id
and U.sourcesystem=R.sourcesystem
and U.id=T.unit_id
and U.sourcesystem=T.sourcesystem
;
delete from tmp_unit_u;
insert into tmp_unit_u select * from tmp_unit_o;
delete from tmp_unit_o;

insert into tmp_unittree(
ebene ,
sortnr,
unit_id  , 
unit_uniquename,
unit_elementnr,
parent_unit_id ,
parent_unit_uniquename,
parent_unit_elementnr,
top_unit_id,
calculate_ects_sum,
sourcesystem ,
unitrelationtype,
course_of_study_lid )
select ${ebene} as ebene,
T.sortnr,
T.unit_id,
U.uniquename,
U.elementnr,
T.parent_unit_id,
T.parent_unit_uniquename,
T.parent_unit_elementnr,
T.top_unit_id,
(case when T.calculate_ects_sum=1 then T.calculate_ects_sum else nvl(U.calculate_ects_sum,0) end) as calculate_ects_sum, --sobald ein Knoten 1 hat, wird es an die Kinder vererbt
T.sourcesystem,
T.unitrelationtype,
US.course_of_study_lid
from lm_unit U, tmp_unit_u T left outer join lm_unit_studies US
on (T.unit_id=US.unit_id
and T.course_of_study_lid=US.course_of_study_lid
and T.sourcesystem=US.sourcesystem
)
where U.id=T.unit_id
and U.sourcesystem=T.sourcesystem
  ;
</#list>

update tmp_unittree set abschluss=C.abschluss,
stg=C.stg , 
pversion=C.pversion , 
stutyp=C.stutyp,
kz_fach=C.kzfa , 
stort=C.stort , 
vertfg=C.vert , 
schwerpunkt=C.schwp ,
stufrm=C.stufrm ,
tid_stg=C.tid_stg
from lm_course_of_study C
where C.lid=tmp_unittree.course_of_study_lid;

update tmp_unittree set pversion_uniquename=(select lang_3 
from cif where key=632 and apnr=tmp_unittree.pversion);

update tmp_unittree set calculate_ects_aktiv=calculate_ects_sum;


--Prüfungen unterhalb von Modulen zählen nicht ins ECTS,
--damit sie nicht doppelt reinkommen https://hiszilla.his.de/hiszilla/show_bug.cgi?id=231492#c105
update tmp_unittree set calculate_ects_sum=0
from lm_unit U 
where U.id=tmp_unittree.parent_unit_id
and U.sourcesystem=tmp_unittree.sourcesystem and U.${LM_UNIT_MODUL}
and tmp_unittree.calculate_ects_sum=1
and tmp_unittree.unit_id not in (select U2.id from lm_unit U2 where U2.sourcesystem=tmp_unittree.sourcesystem and U2.${LM_UNIT_MODUL})
;

update tmp_unittree set parent_unit_uniquename=U.uniquename,
parent_unit_elementnr=U.elementnr
from lm_unit U
where U.id=tmp_unittree.parent_unit_id
and U.sourcesystem=tmp_unittree.sourcesystem
and tmp_unittree.parent_unit_uniquename is null;


truncate table lm_unittree;


insert into lm_unittree(
ebene ,
sortnr,
unit_id  , 
unit_uniquename,
parent_unit_id ,
parent_unit_uniquename,
parent_unit_elementnr,
top_unit_id,
calculate_ects_sum,
calculate_ects_aktiv,
sourcesystem ,
unitrelationtype,
abschluss,
stg , 
pversion , 
pversion_uniquename,
stutyp,
kz_fach , 
stort , 
vertfg , 
schwerpunkt,
stufrm,
course_of_study_lid ,
tid_stg)
select ebene ,
sortnr,
unit_id  , 
unit_uniquename,
parent_unit_id ,
parent_unit_uniquename,
parent_unit_elementnr,
top_unit_id,
calculate_ects_sum,
calculate_ects_aktiv,
sourcesystem , 
unitrelationtype,
abschluss,
stg , 
pversion , 
pversion_uniquename,
stutyp,
kz_fach , 
stort , 
vertfg , 
schwerpunkt,
stufrm,
course_of_study_lid,
tid_stg
from tmp_unittree
where 1=1
<#if LM_UNIT_FILTER !="" >
and ${LM_UNIT_FILTER}
</#if>
;

update lm_unittree set abschluss='' where abschluss is null;
update lm_unittree set  stg='' where stg is null; 
update lm_unittree set  stutyp='' where stutyp is null;
update lm_unittree set  kz_fach='' where kz_fach is null; 
update lm_unittree set  stort='' where stort is null; 
update lm_unittree set  vertfg='' where vertfg is null; 
update lm_unittree set  schwerpunkt='' where schwerpunkt is null;
update lm_unittree set  stufrm='' where stufrm is null;


drop table tmp_unit_u;
drop table  tmp_unit_o;
drop table  tmp_unittree;


