--Freemarker Template
--ECTS Soll ermitteln:
<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>

<#assign fields = [
{"field_src":"stg","key":30},
{"field_src":"abschluss","key":35},
{"field_src":"vertiefung","field_target":"L.vertfg","key":39},
{"field_src":"schwerpunkt","key":41},
{"field_src":"kz_fach","key":614},
{"field_src":"pversion","field_target":"pversion_uniquename","key":632},
{"field_src":"stort","key":9012},
{"field_src":"stutyp","key":40},
{"field_src":"stufrm","field_target":"S.stufrm","key":612}
]>

<#assign runs = [
{"suffix":"","aggrfunction":"max","fs_operator":"="},
{"suffix":"_kum","aggrfunction":"sum","fs_operator":"<="}

]>

delete from lm_pruefrout where  problem='Studiengang ohne Soll';
    

select 'Konstante LM_ECTS_SOLL_SRC=${K_LM_ECTS_SOLL_SRC}'
from xdummy;
<#foreach run in runs>

select '${run.aggrfunction}' from xdummy;


<#if K_LM_ECTS_SOLL_SRC == 1>
--GANG:

update lm_konto_pro_fs S set ects_soll${run.suffix}=(select sum(E.ects) as ects_soll_gang
  from  gang_zu_soll_ects E, gang_lehr_stg_ab L
where E.gang_tid=L.gang_tid
and L.lehr_stg_ab_tid=S.tid_stg
and (E.stutyp=S.stutyp or E.stutyp is null or trim(E.stutyp)='')
and E.fach_sem_zahl ${run.fs_operator} S.fach_sem_zahl)
where 1=1
<#if run.suffix=="">
and fach_sem_zahl <=regel
</#if>
and ${LM_STUDENT_FILTER}
;



</#if>

--Soll aus Excel Upload:
<#if K_LM_ECTS_SOLL_SRC == 2 >

--zuest NULLS abfangen:
<#foreach field in fields>
update lm_ects_soll set ${field.field_src}='' where ${field.field_src} is null;
</#foreach>

select S.tid,${run.aggrfunction}(O.ects_soll)::float as ects_soll${run.suffix}
into temp tmp_lm_ects_soll
from lm_konto_pro_fs S ,lm_ects_soll O, lehr_stg_ab L
  where L.tid=S.tid_stg
  <#foreach field in fields>
  	<#assign field_target="L."+ field.field_src />
	<#if field.field_target?exists>
  		<#if field.field_target=="pversion_uniquename">
			and (O.${field.field_src} = '' or O.${field.field_src}= S.${field.field_target})
		<#else>
			<#assign field_target=field.field_target />
			and (O.${field.field_src} = '' or ${field_target} in (select C.apnr from cifx C
			where C.key=${field.key} and C.uniquename=O.${field.field_src}))
		</#if>
	<#else>
		and (O.${field.field_src} = '' or L.${field.field_src} in (select C.apnr from cifx C
		where C.key=${field.key} and C.uniquename=O.${field.field_src}))
	</#if>
  </#foreach>
  and O.semester_von <= S.sem_rueck_beur_ein
  and O.semester_bis >= S.sem_rueck_beur_ein 
  and O.fach_sem_zahl ${run.fs_operator} S.fach_sem_zahl
  and ${LM_STUDENT_FILTER}
  group by 1
  ;

  update lm_konto_pro_fs set ects_soll${run.suffix}=T.ects_soll${run.suffix} 
  from tmp_lm_ects_soll T
  where T.tid=lm_konto_pro_fs.tid;

  drop table tmp_lm_ects_soll;



</#if>

<#if K_LM_ECTS_SOLL_SRC == 3 >
--EXA TOP Knoten der PO:

update lm_konto_pro_fs S set ects_soll${run.suffix}=
(case when S.fach_sem_zahl <=regel
<#if run.suffix=="">
then UR.bonus/regel
else null::float 
<#else>
then UR.bonus/regel*fach_sem_zahl
else UR.bonus
</#if>
end )
  from  lm_unit_top UT, 
	lm_unit_studies US, 
	lm_course_of_study CS,
	lm_unit U,
	lm_unitrelation UR
	where
	U.default_unitrelation_id=UR.id
	and UT.unit_id=U.id
	and UT.top_unit_id=U.id
	and UT.top_unit_id=US.unit_id 
	and US.course_of_study_lid=CS.lid
	and S.tid_stg=CS.tid_stg
	and ${LM_STUDENT_FILTER}

;

</#if>

</#foreach> --run

select 'Soll fertig: ' || now() from xdummy;

--Prüfung Soll:
select 'Prüfroutine Soll: ' || now() from xdummy;

insert into lm_pruefrout (datum,
       semester,
       tabelle,
       matrikel_nr,
       tid_stg,
       problem,
       aktion)
       select today(),
       K.sem_rueck_beur_ein,
       'lm_ects_soll',
       K.matrikel_nr,
       K.tid_stg,
       'Studiengang ohne Soll',
       'Warnung'
       from sos_stg_aggr S, lm_konto_pro_fs K , lehr_stg_ab L
       where  L.tid=K.tid_stg
       and L.tid=S.tid_stg
       and K.matrikel_nr=S.matrikel_nr
       and S.sem_rueck_beur_ein=K.sem_rueck_beur_ein
       
and S.stichtag=(select I.tid from sos_stichtag I where I.appl_key='0')
and ects_soll_kum is null
       and  K.aktiv=1
and K.hrst in (select apnr from sos_k_hrst where astat='1')
and K.sem_rueck_beur_ein between ${K_LM_ECTS_SOLL_IST_STARTSEM} and ${K_LM_ECTS_SOLL_IST_ENDSEM}
--and K.tid_stg=31921
and K.fach_sem_zahl <=(L.regel*2+1)
--and S.kz_rueck_beur_ein !=4
 ;
 
<#if K_LM_ECTS_SOLL_IST_CEIL?exists && K_LM_ECTS_SOLL_IST_CEIL &gt; 0>
--Alle Absolventen deckeln wir im IST bei Soll + x%
--wer ist absolv?
select distinct L.matrikel_nr,L.ch30_fach,L.ch35_ang_abschluss
into temp tmp_absolv
from sos_lab_stg L, sos_stichtag I
where L.stichtag=I.tid
and I.appl_key='2'
and L.abschnitt=2
and L.pstatus='BE'
and L.matrikel_nr in (select S.matrikel_nr
from sos_sos S
where ${LM_STUDENT_FILTER}
);


insert into lm_pruefrout (datum,
       semester,
       tabelle,
       matrikel_nr,
       tid_stg,
       problem,
       aktion)
       select today(),
       K.sem_rueck_beur_ein,
       'lm_examplan',
       K.matrikel_nr,
       K.tid_stg,
       'ECTS-IST eines Absolv. ist mehr als ${K_LM_ECTS_SOLL_IST_CEIL}% höher als das Soll, wird also gedeckelt',
       'Warnung'
       from lm_konto_pro_fs K,tmp_absolv T
       where T.matrikel_nr=K.matrikel_nr
       and K.stg=T.ch30_fach
       and K.abschluss=T.ch35_ang_abschluss
       and K.ects_ist_kum > ects_soll_kum + (ects_soll_kum*${K_LM_ECTS_SOLL_IST_CEIL}/100)
       and K.matrikel_nr in (select S.matrikel_nr
		from sos_sos S
		where ${LM_STUDENT_FILTER}
		)
       ;
update lm_konto_pro_fs set ects_ist_kum=ects_soll_kum + (ects_soll_kum*${K_LM_ECTS_SOLL_IST_CEIL}/100)
where ects_ist_kum >ects_soll_kum + (ects_soll_kum*${K_LM_ECTS_SOLL_IST_CEIL}/100)
and (matrikel_nr,stg,abschluss) in (select T.matrikel_nr,
T.ch30_fach,
T.ch35_ang_abschluss
from tmp_absolv T)
and matrikel_nr in (select S.matrikel_nr
from sos_sos S
where ${LM_STUDENT_FILTER}
)
;

drop table tmp_absolv;

</#if>
