--Freemarker Template
--Quellcode: $LM_PFAD/hilfstabellen/lm_konto_pro_fs_fuellen.sql
--Achtung: Diese Script ist auch das select_stmt der Maske 41040
<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>

<sqlvars>
<sqlvar name="SOS_MTKNR_EXT">
select 1 from xdummy where 0 != (select 
count(*) from konstanten where beschreibung='SOS_MTKNR_EXT'
and apnr=1)
union select 0 from xdummy where 0 = (select 
count(*) from konstanten where beschreibung='SOS_MTKNR_EXT'
and apnr=1)
;
</sqlvar>
<sqlvar name="bonus_weight" type="hashsequence">
select filter_type,
       caption as name,
       student_filter,
       unit_filter,
       exam_filter as lab_filter,
       aggregation_formula as formel,
       split_degree_programmes,
       uniquename,
       sortnr
FROM lm_filter 
where filter_type in ('BONUS_WEIGHT','BONUS_CP_WEIGHT')
and aktiv=1
order by sortnr,uniquename,caption
 ;

</sqlvar>

<sqlvar name="stud_stichtag_tagesaktuell">
select I.tid from sos_stichtag I where I.appl_key='0'
;
</sqlvar>
</sqlvars>


<#assign inEtl=true />
<#if Maskennummer?exists && Maskennummer=41040>
<#assign inEtl=false />
</#if>

<#assign filter="1=1" />
<#if inEtl>
<#assign filter=LM_STUDENT_FILTER />

<#else>

/* <#assign filter=filter+" and SA.matrikel_nr::varchar(255)=<<Matrikel-Nr.>>" />*/
/* <#assign filter=filter+" and L.stg=<<Fach>>" />*/
/* <#assign filter=filter+" and L.abschluss=<<Abschluss>>" />*/
/* <#assign filter=filter+" and SA.sem_rueck_beur_ein <= <<Semester>>" />*/
/* <#assign filter=filter+" and SA.fach_sem_zahl <= <<Fachsemester>>" />*/
</#if>



create temp table tmp_unit_exam(
tid serial,
ebene integer,
sortnr varchar(255),
lm_konto_pro_fs_tid INTEGER , 
labnr INTEGER , 
labnr_parent integer,
labnr_parent_term integer,
labnr_parent_pstatus char(10),
sourcesystem INTEGER , 
bonus_exam FLOAT , 
bonus_anteil_formel varchar(255),
bonus FLOAT ,
bonus_ist_weighted FLOAT ,
bonus_exam_weighted FLOAT ,
bonus_pord_weighted FLOAT ,
bonus_weight_type varchar(255),
matrikel_nr INTEGER , 
tid_stg INTEGER , 
tid_stg_str varchar(255),
fach_sem_zahl_stud integer,
sem_der_pruefung SMALLINT  , 
sem_der_pruefung_str varchar(255)  ,
d_abg_pruefung DATE , 
note float , 
abschnitt SMALLINT , 
fach_sem_zahl decimal(10,2) , 
pstatus CHAR(10) , 
prueck SMALLINT , 
pvermerk CHAR(10) , 
pnr INTEGER , 
zeitabschnitt CHAR(10) , 
pform CHAR(10) , 
pordnr INTEGER , 
parent_examplan_unit_id INTEGER ,
parent_unit_id_examrelation INTEGER , 
parent_unit_id_unittree INTEGER ,
top_examplan_id integer,
top_unit_id_examrelation integer,
part CHAR(10) , 
part_str  varchar(255),
schriftlich SMALLINT , 
ppflicht CHAR(2) , 
modulart CHAR(10) , 
modulart_str varchar(255),
panerk char(10),
bonus_pord double precision , 
pktxt CHAR(255) , 
pdtxt CHAR(255) , 
pversuch INTEGER , 
pseudonym VARCHAR(255) , 
studiengang_nr SMALLINT , 
fach_nr SMALLINT , 
abschluss char(10),
abschluss_str VARCHAR(255) , 
abschluss_astat CHAR(10) , 
stg CHAR(10) , 
stg_str VARCHAR(255) , 
vertfg CHAR(10) , 
schwerpunkt CHAR(10) , 
kz_fach CHAR(10) , 
pversion INTEGER , 
stort char(10),
pdum CHAR(10) , 
is_top_node INTEGER , 
stutyp CHAR(10) , 
stufrm CHAR(10) , 
unit_uniquename VARCHAR(255) ,
parent_unit_elementnr VARCHAR(255) ,
elementnr VARCHAR(255) ,
parent_unit_uniquename VARCHAR(255) ,
parent_unit_ismodule smallint,
calculate_ects_sum integer,
sem_rueck_beur_ein_max_student integer,
sem_rueck_beur_ein_min_student integer,
ch62_grund_exmatr char(10),
freiversuch smallint,
top_unit_uniquename VARCHAR(255) , 
top_unit_elementnr VARCHAR(255) , 
subtop_labnr INTEGER , 
subtop_unit_uniquename VARCHAR(255) , 
subtop_unit_elementnr VARCHAR(255)  ,
signalpr_vert VARCHAR(255)

) 
;


--zuerst Ebene Einzeldaten

<@selectintotmp 
select="SA.matrikel_nr,
null::varchar(255) as pseudonym,--SA.pseudonym,
null::smallint as studiengang_nr,
null::smallint as fach_nr,
null::char(10) as ch62_grund_exmatr,
SA.tid_stg, 
L.regel,
L.stg,
L.stg_str,
L.stg_astat,
L.abschluss,
L.abschluss_str,
L.abschluss_astat,
L.abschlussart,
L.vertfg,
L.schwerpunkt,
L.kz_fach,
L.stort,
L.pversion,
L.text as tid_stg_str,
SA.stutyp,
max(SA.stufrm) as stufrm,
max(fach_sem_zahl) as max_fach_sem_zahl,
max(SA.sem_rueck_beur_ein) as sem_rueck_beur_ein_max_student,
max(SA.sem_rueck_beur_ein)+10 as sem_rueck_beur_ein_max_student_plus_10, 
min(SA.sem_rueck_beur_ein) as sem_rueck_beur_ein_min_student"
source="sos_stg_aggr SA, dim_studiengang L, sos_sos S"
target="tmp_student">
where SA.tid_stg=L.tid
and SA.matrikel_nr=S.matrikel_nr
and SA.stichtag=${stud_stichtag_tagesaktuell}
--and studiengang_nr=1 
--and fach_nr=1
and ${filter}
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21
</@selectintotmp>
 <@informixnolog/>;

 
 --Exmagrund nachladen, falls Prüfung nach Exma #231492#c130
update tmp_student set ch62_grund_exmatr=S.ch62_grund_exmatr,
studiengang_nr=S.studiengang_nr
from sos_stg_aggr S
where S.sem_rueck_beur_ein= tmp_student.sem_rueck_beur_ein_max_student
and S.tid_stg=tmp_student.tid_stg
and S.matrikel_nr=tmp_student.matrikel_nr
and S.stichtag=${stud_stichtag_tagesaktuell}
;

create  index ix_tmp_student1 on tmp_student (tid_stg, matrikel_nr);
-- create  index ix_tmp_student2 on tmp_student (sem_rueck_beur_ein_max_student_plus_10);
-- create  index ix_tmp_student3 on tmp_student (matrikel_nr);


select 'Studierende gesammelt fertig: ' || now() from xdummy;


<@selectintotmp 
select="distinct S.matrikel_nr,
T.tid_stg,
S.studiengang_nr as studiengang_nr_w,
S.fach_nr as fach_nr_w,
S.tid_stg as tid_stg_w, 
L.stg as stg_w,
L.vertfg as vertfg_w ,
L.schwerpunkt as schwerpunkt_w,
L.kz_fach as kz_fach_w,
L.stort as stort_w,
L.pversion as pversion_w,
S.stufrm as stufrm_w,
S.stutyp as stutyp_w,
L.abschluss,
S.sem_rueck_beur_ein,
T.sem_rueck_beur_ein_max_student,
T.sem_rueck_beur_ein_min_student,
T.sem_rueck_beur_ein_max_student_plus_10,
T.ch62_grund_exmatr
"
source="tmp_student T,sos_stg_aggr S, dim_studiengang L"
target="tmp_student_weitere_faecher">
where T.matrikel_nr=S.matrikel_nr
and T.sem_rueck_beur_ein_min_student <= S.sem_rueck_beur_ein
and T.sem_rueck_beur_ein_max_student >= S.sem_rueck_beur_ein
and S.tid_stg=L.tid
and S.tid_stg !=T.tid_stg
and S.stichtag=${stud_stichtag_tagesaktuell}
and L.stg != T.stg 
and L.abschluss=T.abschluss
and S.studiengang_nr=T.studiengang_nr
</@selectintotmp>
 <@informixnolog/>;

 
select 'Fächerkombinationen fertig: ' || now() from xdummy;



update tmp_student set vertfg=''
where vertfg='DEFAULT';
update tmp_student set schwerpunkt=''
where schwerpunkt='DEFAULT';



update tmp_student_weitere_faecher set vertfg_w=''
where vertfg_w='DEFAULT';
update tmp_student_weitere_faecher set schwerpunkt_w=''
where schwerpunkt_w='DEFAULT';

create  index ix_tmp_studentw2 on tmp_student_weitere_faecher (tid_stg_w);



-- der ganze Baum:
--TODO: langsam:
insert into tmp_unit_exam(
matrikel_nr,
ebene,
sortnr,
stg,
abschluss,
abschluss_astat, 
tid_stg,
tid_stg_str,
labnr,
labnr_parent,
labnr_parent_pstatus,
labnr_parent_term,
sourcesystem,
pordnr,
parent_unit_id_unittree,
--parent_unit_id_examrelation,
top_examplan_id ,
--top_unit_id_examrelation,
pdtxt,
pktxt,
modulart, 
elementnr,
parent_unit_elementnr,
parent_unit_uniquename,
parent_unit_ismodule,
unit_uniquename,
sem_der_pruefung,--_str,
fach_sem_zahl,
d_abg_pruefung,
part,--_str,
panerk,
pversuch,
pstatus,
prueck,
pvermerk,
note,
calculate_ects_sum,
bonus_pord,
bonus_exam  , 
bonus_anteil_formel  , 
bonus ,
sem_rueck_beur_ein_max_student,
sem_rueck_beur_ein_min_student,
ch62_grund_exmatr
       )
select S.matrikel_nr,
T.ebene+1,
'0_'|| S.tid_stg || '_' || T.sortnr as sortnr,
S.stg,
S.abschluss,
S.abschluss_astat, 
S.tid_stg,
S.tid_stg_str,
E.labnr,
T.labnr_parent,
T.labnr_parent_pstatus,
T.labnr_parent_term,
T.sourcesystem,
U.id,
T.pordnr_parent,
--R.parent_unit_id,
T.top_labnr ,
--R.top_unit_id,--top_unit_id_examrelation 
U.defaulttext,
U.shorttext,
U.elementtyp as modulart, --_str,
U.elementnr,
T.parent_unit_elementnr,
T.parent_unit_uniquename,
T.parent_unit_ismodule,
U.uniquename,
E.sem_der_pruefung,--_str,
E.fach_sem_zahl::integer,
E.d_abg_pruefung,
E.part,--_str,
E.panerk,
E.pversuch,
E.pstatus,
E.prueck,
E.pvermerk,
E.note,
T.calculate_ects_sum,
E.bonus_pord,
E.bonus as bonus_exam , 
'' as bonus_anteil_formel  , 
E.bonus ,
S.sem_rueck_beur_ein_max_student,
S.sem_rueck_beur_ein_min_student,
S.ch62_grund_exmatr
from tmp_student S,lm_unit U, lm_exam_unit_studies T, lm_exam_unit E
where E.labnr=T.labnr
and E.sourcesystem=T.sourcesystem
and E.pordnr=U.id
and E.sourcesystem=U.sourcesystem
and E.matrikel_nr=S.matrikel_nr 
and E.matrikel_nr=T.matrikel_nr
and S.tid_stg=T.tid_stg
--and S.stufrm=T.stufrm
-- and S.stort=T.stort
-- and U.id=T.unit_id
-- and U.sourcesystem=T.sourcesystem
<#if inEtl>
and E.sem_der_pruefung <= S.sem_rueck_beur_ein_max_student 
</#if>
;

-- delete from tmp_unit_exam where parent_unit_id_examrelation is not null
-- and parent_unit_id_examrelation!= parent_unit_id_unittree
-- ;

--Bisher hatte ich die PO Bäume wg. der polyvalenten Prüfungen auf Kinder durchsucht, so hat er das Modul 2x gefunden. Daher das zu große IST.

--Ich habe die Logik jetzt angepaßt: wenn es leistungsseitig eine eindeutige Zuordnung eines Moduls zum jew. PO Baum gibt, wird diese mit höherer Priorität gelesen, und die andere gelöscht.


-- delete from tmp_unit_exam where top_unit_id_examrelation is not null
-- and position('_' || top_unit_id_examrelation || '_' in sortnr)=0
-- ;

--güK raus:

select 'Entferne Kinder vom gÜK: ' || now() from xdummy;


delete from tmp_unit_exam where exists (select E.labnr
from cifx C, lm_exam_unit E
where C.key=9103
and E.labnr=tmp_unit_exam.labnr_parent
and E.sourcesystem=tmp_unit_exam.sourcesystem
and C.apnr=E.modulart
and C.hiskey_id='11' --globales Überlaufkonto
);

select 'Entferne gÜK abgeschlossen: ' || now() from xdummy;



<#if !inEtl>

--Ebene 2 muss folgen:
-- select min(ebene) as min_ebene into temp tmp_1 from tmp_unit_exam;
-- update  tmp_unit_exam set ebene=ebene -(select min_ebene from tmp_1)+2;
-- drop table tmp_1;

</#if>


<#if bonus_weight?has_content>
<#foreach regel in bonus_weight>
<#if regel.formel?exists && regel.formel !="">
update tmp_unit_exam set bonus_anteil_formel='${regel.formel}',
bonus_ist_weighted=${regel.formel},
bonus_exam_weighted=${regel.formel?replace("bonus","bonus_exam")},
bonus_pord_weighted=${regel.formel?replace("bonus","bonus_pord")},
bonus_weight_type='${regel.filter_type}'
where bonus_anteil_formel='' --keine Regel 2x ausführen
<#if regel.student_filter !="">
and ${regel.student_filter}
</#if>
<#if regel.unit_filter !="">
and ${regel.unit_filter}
</#if>
<#if regel.lab_filter !="">
and ${regel.lab_filter}
</#if>
;

select 'ECTS- und CP-Eigenanteil ${regel.name} berechnet: ' || now() from xdummy;
</#if>
</#foreach>

</#if>

--Wenn Prüfungen /Soll nicht gewichtet wird, wird Faktor 1 genommen: 
update tmp_unit_exam set 
bonus_exam_weighted=bonus_exam where bonus_exam_weighted is null;
update tmp_unit_exam set 
bonus_pord_weighted=bonus_pord where bonus_pord_weighted is null;


select 'Alle Eigenanteile berechnet: ' || now() from xdummy;

--Signalprüfungen:
<#if LM_ELEMENTTYP_SIGNAL?has_content>

create temp table tmp_signalpr(labnr integer,
sourcesystem integer,
pdtxt varchar(255)
);

insert into tmp_signalpr (labnr ,
sourcesystem ,
pdtxt)
select E.labnr,
E.sourcesystem,
E.pdtxt
from lm_exam_unit E
where ${LM_ELEMENTTYP_SIGNAL}
;

update tmp_unit_exam set signalpr_vert=S.pdtxt
from tmp_signalpr S
where position('_' || S.labnr || '_' in tmp_unit_exam.sortnr)>0;

drop table tmp_signalpr;

</#if>

--Fremdanteil:
<#if bonus_weight?has_content>
<#foreach regel in bonus_weight>
<#if regel.split_degree_programmes ==1>
insert into tmp_unit_exam(
matrikel_nr,
ebene,
sortnr,
stg,
abschluss,
abschluss_astat, 
tid_stg,
tid_stg_str,
ch62_grund_exmatr,
labnr,
sourcesystem,
pdtxt,
pktxt,
modulart, 
elementnr,
unit_uniquename,
sem_der_pruefung,--_str,
sem_rueck_beur_ein_max_student,
sem_rueck_beur_ein_min_student,
fach_sem_zahl,
d_abg_pruefung,
part,--_str,
panerk,
pversuch,
pstatus,
prueck,
pvermerk,
note,
bonus_pord,
bonus_exam, 
bonus_weight_type,
bonus_anteil_formel  , 
bonus_ist_weighted  ,
bonus_exam_weighted  ,
bonus_pord_weighted,
calculate_ects_sum)
select S.matrikel_nr,
2 as ebene,
'0_'|| S.tid_stg || '_' || T.sortnr  as sortnr,
S.stg,
S.abschluss,
S.abschluss_astat, 
S.tid_stg,
S.tid_stg_str,
S.ch62_grund_exmatr,
E.labnr,
E.sourcesystem,
E.pdtxt,
E.pktxt,
E.modulart,
E.elementnr,
E.unit_uniquename,
E.sem_der_pruefung ,
S.sem_rueck_beur_ein_max_student,
S.sem_rueck_beur_ein_min_student,
E.fach_sem_zahl::integer,
E.d_abg_pruefung,
E.part,
E.panerk,
E.pversuch,
E.pstatus,
E.prueck,
E.pvermerk,
E.note,
E.bonus_pord,
E.bonus as bonus_exam , 
'${regel.filter_type}',
'${regel.formel}' as bonus_anteil_formel,
${regel.formel?replace("bonus","E.bonus")} as bonus_ist_weighted,
${regel.formel?replace("bonus","E.bonus")} as bonus_exam_weighted,
${regel.formel?replace("bonus","E.bonus_pord")} as bonus_pord_weighted,
max(T.calculate_ects_sum)
from tmp_student S, tmp_student_weitere_faecher F, lm_exam_unit_studies T, lm_exam_unit E
where S.matrikel_nr=F.matrikel_nr
and S.tid_stg=F.tid_stg
and E.matrikel_nr=S.matrikel_nr
and E.labnr=T.labnr
and E.sourcesystem=T.sourcesystem
-- and F.stg_w=T.stg
-- and S.abschluss=F.abschluss
and S.abschluss=T.abschluss
-- and F.vertfg_w=T.vertfg 
-- and F.kz_fach_w=T.kz_fach
-- and F.schwerpunkt_w=T.schwerpunkt
-- and F.pversion_w=T.pversion
-- and F.stutyp_w=T.stutyp
-- and F.stufrm_w=T.stufrm
-- and F.stort_w=T.stort
and F.tid_stg_w=T.tid_stg
and E.sem_der_pruefung <= S.sem_rueck_beur_ein_max_student
--and E.sem_der_pruefung=F.sem_rueck_beur_ein
and E.sem_der_pruefung<=F.sem_rueck_beur_ein
--and S.sem_rueck_beur_ein_max_student=F.sem_rueck_beur_ein
and S.sem_rueck_beur_ein_max_student>=F.sem_rueck_beur_ein
and E.matrikel_nr=T.matrikel_nr
<#if regel.student_filter !="">
and S.${regel.student_filter}
</#if>
<#if regel.unit_filter !="">
and T.${regel.unit_filter}
</#if>
<#if regel.lab_filter !="">
and ${regel.lab_filter}
</#if>
<#if !inEtl>
/* and E.sem_der_pruefung <= <<Semester>>+10 */
</#if>
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,28,29,30,E.bonus,E.bonus_pord
;

select 'Fremdanteil ${regel.name} berechnet: ' || now() from xdummy;
</#if>
</#foreach>
</#if>

create index tmp_unit_exam_ix1 on tmp_unit_exam(tid_stg,labnr,sourcesystem);

--Duplikate raus:
create temp table tmp_doppelt
(
tid integer,
tid_stg integer,
labnr integer,
sourcesystem integer
);

insert into tmp_doppelt(tid_stg ,
labnr ,
sourcesystem)
select
tid_stg ,
labnr ,
sourcesystem
from tmp_unit_exam
where labnr is not null
group by 1,2,3
having count(*)>1;

create index tmp_ix2 on tmp_doppelt(tid_stg,labnr,sourcesystem);

--zuerst wenn bonus gefüllt ist:
update tmp_doppelt set tid=T.tid
from tmp_unit_exam T
where T.tid_stg =tmp_doppelt.tid_stg
and T.labnr  =tmp_doppelt.labnr
and T.sourcesystem =tmp_doppelt.sourcesystem
and T.bonus_anteil_formel !=''
;

select 'Duplikate entfernen 1: ' || now() from xdummy;


--dann wenn bonus immer leer ist:
--TODO: langsam:
update tmp_doppelt set tid=T.tid
from tmp_unit_exam T
where T.tid_stg =tmp_doppelt.tid_stg
and T.labnr  =tmp_doppelt.labnr
and T.sourcesystem =tmp_doppelt.sourcesystem
and tmp_doppelt.tid is null
;

select 'Duplikate entfernen: 2 ' || now() from xdummy;


update tmp_unit_exam set bonus_ist_weighted=null,
bonus_exam_weighted =null,
bonus_pord_weighted=null,
bonus_exam=null
where exists (select  D.labnr
from tmp_doppelt D
where D.tid_stg =tmp_unit_exam.tid_stg
and D.labnr  =tmp_unit_exam.labnr
and D.sourcesystem =tmp_unit_exam.sourcesystem)
and not exists (select D2.labnr
from tmp_doppelt D2
where D2.tid_stg =tmp_unit_exam.tid_stg
and D2.labnr  =tmp_unit_exam.labnr
and D2.sourcesystem =tmp_unit_exam.sourcesystem
and D2.tid =tmp_unit_exam.tid)
;

select 'Duplikate entfernt: ' || now() from xdummy;


drop table tmp_doppelt;




<#if K_LM_BERECHNE_HAWMODELL==1>
--Freiversuch zur Notenverbesserung:
--Freiversuch= Gleicher unit.uniquename, gleicher Studiengang/PO-Baum, gleiche Versuchsanzahl, unterschiedliche Examplan ID
--erster Versuch hat Vermerk RQ

create temp table tmp_erstversuch
(
matrikel_nr integer,
tid_stg integer,
unit_uniquename varchar(255),
labnr_erstversuch integer,
sourcesystem integer,
pversuch integer
);

create temp table tmp_freiversuch
(
matrikel_nr integer,
tid_stg integer,
unit_uniquename varchar(255),
labnr_erstversuch integer,
tid_stg_erstversuch integer,
labnr_zweitversuch integer,
sourcesystem integer,
pversuch integer,
pstatus_erstversuch char(10),
pstatus_zweitversuch char(10)
);

insert into tmp_erstversuch(matrikel_nr,
tid_stg ,
unit_uniquename,
labnr_erstversuch,
sourcesystem,
pversuch)
select
matrikel_nr,
tid_stg ,
unit_uniquename,
labnr,
sourcesystem,
pversuch
from tmp_unit_exam
where ${LM_PVERMERK_FV}
;

--normale Freiversuche:
insert into tmp_freiversuch(matrikel_nr,
 tid_stg ,
 tid_stg_erstversuch,
 unit_uniquename,
 sourcesystem,
 pversuch)
 select
 matrikel_nr,
 tid_stg ,
 tid_stg ,
 unit_uniquename,
 sourcesystem,
 pversuch
 from tmp_unit_exam
 where pstatus in ('EN','NB','BE')
group by 1,2,3,4,5,6
having count(*)>1;



drop index tmp_unit_exam_ix1;
create index tmp_unit_exam_ix1 on tmp_unit_exam(tid_stg,matrikel_nr,sourcesystem,unit_uniquename,pversuch);
create index tmp_freiversuch_ix1 on tmp_freiversuch(tid_stg,matrikel_nr,sourcesystem,unit_uniquename,pversuch);

--erster Versuch ist kein Freiversuch, sondern alle danach.
--ersten und zweiten Versuch ermitteln:

<@selectintotmp 
select="F.matrikel_nr,
F.tid_stg ,
F.tid_stg_erstversuch,
F.unit_uniquename,
F.sourcesystem,
F.pversuch,
null::char(10) as pstatus_erstversuch,
null::char(10) as pstatus_zweitversuch,
 min(T.labnr) as labnr_erstversuch,
 max(T.labnr) as labnr_zweitversuch
 "
source="tmp_unit_exam T, tmp_freiversuch F"
target="tmp_freiversuch2">
where T.tid_stg =F.tid_stg
and T.matrikel_nr  =F.matrikel_nr
and T.sourcesystem =F.sourcesystem
and T.unit_uniquename=F.unit_uniquename
and T.pversuch=F.pversuch
and T.pstatus in ('EN','NB','BE')
group by 1,2,3,4,5,6
</@selectintotmp>
 <@informixnolog/>;

delete from tmp_freiversuch2 where labnr_erstversuch=labnr_zweitversuch;


select 'Freiversuch normal fertig ' || now() from xdummy;

--nun UDE Sonderregel

insert into tmp_freiversuch2(matrikel_nr,
tid_stg ,
unit_uniquename,
labnr_erstversuch,
tid_stg_erstversuch,
labnr_zweitversuch,
sourcesystem,
pversuch)
select
T.matrikel_nr,
T.tid_stg ,
T.unit_uniquename,
E.labnr_erstversuch,
E.tid_stg as tid_stg_erstversuch,
T.labnr as labnr_zweitversuch,
T.sourcesystem,
T.pversuch
from tmp_unit_exam T, tmp_erstversuch E
where T.matrikel_nr=E.matrikel_nr
and T.tid_stg=E.tid_stg
and T.unit_uniquename=E.unit_uniquename
and T.sourcesystem=E.sourcesystem
and T.pversuch=E.pversuch
and T.labnr > E.labnr_erstversuch
;

update tmp_freiversuch2 set pstatus_erstversuch=T.pstatus
from tmp_unit_exam T
where T.labnr=tmp_freiversuch2.labnr_erstversuch
and T.sourcesystem=tmp_freiversuch2.sourcesystem;

update tmp_freiversuch2 set pstatus_zweitversuch=T.pstatus
from tmp_unit_exam T
where T.labnr=tmp_freiversuch2.labnr_zweitversuch
and T.sourcesystem=tmp_freiversuch2.sourcesystem;

delete from tmp_freiversuch2 where pstatus_erstversuch in ('EN','NB')
and pstatus_zweitversuch='BE';

update tmp_unit_exam set freiversuch=1
where (labnr,
sourcesystem,
tid_stg,
tid_stg
) in (
select
labnr_zweitversuch,
sourcesystem,
tid_stg_erstversuch,
tid_stg from tmp_freiversuch2
)
;



drop table tmp_freiversuch;
drop table tmp_freiversuch2;
drop table tmp_erstversuch;

--Ende Freiversuch
</#if>

update tmp_unit_exam set bonus_ist_weighted=null where bonus_anteil_formel='';


--Prüfungen nach Studienende werden bei erfolgreichem Ende "rückdatiert" #231492#c130
update tmp_unit_exam set sem_der_pruefung=sem_rueck_beur_ein_max_student
where sem_der_pruefung > sem_rueck_beur_ein_max_student
and ch62_grund_exmatr in (select E.apnr from sos_k_gdex E where E.astat='1') 
;
--Prüfungen nach Studienende werden "vordatiert" erstmal auskommentiert: 234518#c30
-- 
-- update tmp_unit_exam set sem_der_pruefung=sem_rueck_beur_ein_min_student
-- where sem_der_pruefung < sem_rueck_beur_ein_min_student
-- ;



<#if inEtl>




create temp table tmp_student_pro_fs(
matrikel_nr INTEGER ,
pseudonym VARCHAR(255) , 
ca12_staat SMALLINT, 
geschlecht SMALLINT , 
alter decimal(14,2) , 
hzbart SMALLINT , 
hzbart_int CHAR(10) , 
hzbnote decimal(5,2) , 
hrst CHAR(10) , 
sem_rueck_beur_ein integer,
sem_rueck_beur_ein_beginn INTEGER ,
tid_stg integer,
studiengang_nr integer,
fach_nr integer,
stg char(10),
abschluss char(10),
stg_astat  char(10),
abschluss_astat  char(10),
abschlussart  char(10),
vertfg CHAR(10) , 
schwerpunkt CHAR(10) , 
pversion INTEGER , 
pversion_uniquename varchar(255),
kz_fach CHAR(10) , 
stort CHAR(10),
stuart char(10),
stufrm char(10),
stutyp char(10),
ch62_grund_exmatr CHAR(10) , 
fach_sem_zahl integer,
regel float,
ects_soll float,
anz_pruef_in_rsz2 smallint,
kz_rueck_beur_ein smallint,
summe integer);

create temp table tmp_konto_pro_fs(
	tid SERIAL  not null, 
matrikel_nr INTEGER , 
pseudonym VARCHAR(255) , 
ca12_staat SMALLINT  not null, 
geschlecht SMALLINT  not null, 
alter decimal(14,2) , 
hzbart SMALLINT , 
hzbart_int CHAR(10) , 
hzbnote decimal(5,2) , 
hrst CHAR(10) , 
sem_rueck_beur_ein INTEGER , 
sem_rueck_beur_ein_beginn INTEGER ,
tid_stg INTEGER , 
studiengang_nr INTEGER , 
fach_nr INTEGER , 
stg CHAR(10) , 
abschluss CHAR(10) ,
stg_astat  char(10),
abschluss_astat  char(10),
abschlussart  char(10),
vertfg CHAR(10) , 
schwerpunkt CHAR(10) , 
pversion INTEGER , 
pversion_uniquename varchar(255),
kz_fach CHAR(10) , 
stort CHAR(10),
stuart char(10),
stufrm CHAR(10) , 
stutyp CHAR(10) , 
ch62_grund_exmatr CHAR(10) , 
fach_sem_zahl INTEGER , 
min_fach_sem_zahl INTEGER , 
max_fach_sem_zahl INTEGER , 
regel FLOAT , 
aktiv smallint,
signalpr_vert VARCHAR(255),
ects_soll FLOAT , 
ects_soll_kum FLOAT , 
ects_ist FLOAT , 
ects_ist_eigen FLOAT , 
ects_ist_fremd FLOAT , 
ects_ist_kum FLOAT , 
cp_ist FLOAT , 
cp_ist_eigen FLOAT , 
cp_ist_fremd FLOAT , 
cp_ist_kum FLOAT , 
ects_ancp FLOAT , 
ects_ancp_kum FLOAT , 
ects_nbcp FLOAT , 
ects_nbcp_kum FLOAT , 
ects_rtcp FLOAT , 
ects_rtcp_kum FLOAT , 
ects_befvcp FLOAT , 
ects_befvcp_kum FLOAT , 
ects_nbfvcp FLOAT , 
ects_nbfvcp_kum FLOAT ,
kz_rueck_beur_ein smallint,
summe INTEGER 

) 
;

create temp table tmp_konto_pro_fs_2(
	tid INTEGER, 
ects_soll FLOAT , 
ects_soll_kum FLOAT , 
ects_ist FLOAT , 
ects_ist_eigen FLOAT , 
ects_ist_fremd FLOAT , 
ects_ist_kum FLOAT , 
cp_ist FLOAT , 
cp_ist_eigen FLOAT , 
cp_ist_fremd FLOAT , 
cp_ist_kum FLOAT , 
ects_ancp FLOAT , 
ects_ancp_kum FLOAT , 
ects_nbcp FLOAT , 
ects_nbcp_kum FLOAT , 
ects_rtcp FLOAT , 
ects_rtcp_kum FLOAT , 
ects_befvcp FLOAT , 
ects_befvcp_kum FLOAT , 
ects_nbfvcp FLOAT , 
ects_nbfvcp_kum FLOAT , 
summe INTEGER 

) 
;

create temp table tmp_cp_pro_fs(
	tid INTEGER, 
labnr_parent_term integer,
labnr_parent_pstatus CHAR(10) , 
cp_ist FLOAT , 
cp_ist_eigen FLOAT , 
cp_ist_fremd FLOAT , 
cp_ist_kum FLOAT ,
summe INTEGER 

) 
;

insert into tmp_student_pro_fs(matrikel_nr,
pseudonym , 
ca12_staat , 
geschlecht  , 
alter , 
hzbart , 
hzbart_int , 
hzbnote  , 
hrst , 
sem_rueck_beur_ein,
tid_stg,
studiengang_nr,
fach_nr,
stg,
stg_astat,
abschluss,
abschluss_astat,
abschlussart,
vertfg , 
schwerpunkt , 
pversion  , 
kz_fach , 
stort,
stuart,
stutyp ,
stufrm,
ch62_grund_exmatr,
fach_sem_zahl,
kz_rueck_beur_ein,
regel,
summe)
select SA.matrikel_nr,
SA.pseudonym,
SA.ca12_staat , 
SA.geschlecht  , 
SA.alter , 
SA.hzbart , 
SA.hzbart_int , 
SA.hzbnote  , 
SA.hrst , 
SA.sem_rueck_beur_ein,
SA.tid_stg,
SA.studiengang_nr,
SA.fach_nr,
L.stg,
L.stg_astat,
L.abschluss,
L.abschluss_astat,
L.abschlussart,
L.vertfg , 
L.schwerpunkt , 
L.pversion  , 
L.kz_fach , 
L.stort,
SA.stuart,
SA.stutyp ,
SA.stufrm,
SA.ch62_grund_exmatr,
SA.fach_sem_zahl,
SA.kz_rueck_beur_ein,
L.regel ,
sum(SA.summe) as summe
from 
 sos_stg_aggr SA, dim_studiengang L, sos_sos S
where SA.tid_stg=L.tid
and SA.matrikel_nr=S.matrikel_nr
and SA.stichtag=${stud_stichtag_tagesaktuell}
--and kz_rueck_beur_ein !=4 --keine Beurl.
--and studiengang_nr=1 
--and fach_nr=1
--and SA.fach_sem_zahl <=(L.regel*2+1)
--and matrikel_nr=3020618
--and matrikel_nr in (select distinct F2.matrikel_nr from sos_stg F2 where F2.ch30_fach='032' and F2.ch35_ang_abschluss='B7') 
and ${filter}
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30
;

update tmp_student_pro_fs set pversion_uniquename=(select lang_3 from cif C
where C.key=632 and C.apnr=tmp_student_pro_fs.pversion);
--sospos-pversion:
update tmp_student_pro_fs set pversion_uniquename=pversion
where pversion_uniquename is null;

insert into tmp_konto_pro_fs(
 matrikel_nr,
 pseudonym,
ca12_staat , 
geschlecht  , 
alter , 
hzbart , 
hzbart_int , 
hzbnote  , 
hrst , 
sem_rueck_beur_ein,
sem_rueck_beur_ein_beginn,
tid_stg,
studiengang_nr,
fach_nr,
stg,
abschluss,
abschluss_astat,
abschlussart,
vertfg , 
schwerpunkt , 
pversion,
pversion_uniquename,
kz_fach , 
stort,
stufrm,
stutyp,
ch62_grund_exmatr,
fach_sem_zahl,
regel,
aktiv,
ects_soll,
kz_rueck_beur_ein,
summe
)
select 
 matrikel_nr,
 pseudonym,
ca12_staat , 
geschlecht  , 
alter , 
hzbart , 
hzbart_int , 
hzbnote  , 
hrst , 
sem_rueck_beur_ein,
sem_rueck_beur_ein_beginn,
tid_stg,
studiengang_nr,
fach_nr,
stg,
abschluss,
abschluss_astat,
abschlussart,
vertfg , 
schwerpunkt , 
pversion,
pversion_uniquename,
kz_fach , 
stort,
stufrm,
stutyp,
ch62_grund_exmatr,
fach_sem_zahl,
regel,
0 as aktiv,
ects_soll,
kz_rueck_beur_ein,
summe
from tmp_student_pro_fs;

select 'Studierendenmatrix pro FS fertig: ' || now() from xdummy;

create  index ix_tmp_konto_pro_fs on tmp_konto_pro_fs (tid );

create  index ix_tmp_konto_pro_fs1 on tmp_unit_exam (matrikel_nr );
create  index ix_tmp_konto_pro_fs_2 on tmp_unit_exam (tid_stg);
create  index ix_tmp_konto_pro_fs3 on tmp_unit_exam (sem_der_pruefung);
create  index ix_tmp_konto_pro_fs4 on tmp_unit_exam (panerk);
create  index ix_tmp_konto_pro_fs5 on tmp_unit_exam (pstatus);
create  index ix_tmp_konto_pro_fs6 on tmp_unit_exam (prueck);
create  index ix_tmp_konto_pro_fs7 on tmp_unit_exam (pvermerk);

--Aktivkennz. ermitteln:
update tmp_student_pro_fs set anz_pruef_in_rsz2= Sub.anz
from (
	select count(*) anz, L.matrikel_nr,L.stg,L.abschluss, L.sem_der_pruefung
	from tmp_unit_exam L
where 1=1
<#if LM_LAB_BEWERTET?exists>
and ${LM_LAB_BEWERTET}
</#if>
	group by L.matrikel_nr,L.stg,L.abschluss, L.sem_der_pruefung
) Sub
where 
 Sub.matrikel_nr=tmp_student_pro_fs.matrikel_nr
and Sub.stg=tmp_student_pro_fs.stg
and Sub.abschluss=tmp_student_pro_fs.abschluss
and Sub.sem_der_pruefung <= tmp_student_pro_fs.sem_rueck_beur_ein
--and Sub.sem_der_pruefung >= tmp_student_pro_fs.sem_rueck_beur_ein_start
;


update tmp_konto_pro_fs set aktiv=1
where exists (select 1 from tmp_student_pro_fs T
where T.matrikel_nr=tmp_konto_pro_fs.matrikel_nr
and T.sem_rueck_beur_ein=tmp_konto_pro_fs.sem_rueck_beur_ein
--and T.tid_stg=sos_stg_aggr.tid_stg
and T.studiengang_nr=tmp_konto_pro_fs.studiengang_nr
and T.anz_pruef_in_rsz2>0
);


<#if LM_ECTS_IST_POS?exists>

select 'Nachladen Aktivkennz. aus POS:',now() from xdummy;

update tmp_konto_pro_fs K
set aktiv=1
where 
 K.aktiv=0
and exists (select matrikel_nr from sos_lab L,  lehr_stg_ab S 
where L.matrikel_nr=K.matrikel_nr
and L.ch30_fach=S.stg 
and L.ch35_ang_abschluss=S.abschluss
and L.sourcesystem=5
and L.sem_der_pruefung <=K.sem_rueck_beur_ein
<#if SOS_LAB_BEWERTET?exists>
and ${SOS_LAB_BEWERTET}
</#if>
and S.tid=K.tid_stg
);

</#if>
select 'Start IST Aggregation ' || now() from xdummy;

<#assign konto_exam_join="T.matrikel_nr=U.matrikel_nr" />
<#assign konto_exam_join=konto_exam_join+" and T.abschluss=U.abschluss
and T.stg=U.stg" />

--pro Studiengang (fach-abschluss-Kombi) darf eine Leistung nur 1x ins IST zählen


select distinct T.tid as tmp_konto_pro_fs_tid, 
U.labnr,U.bonus_ist_weighted ,
U.sem_der_pruefung
into temp tmp_unit_exam2
from tmp_konto_pro_fs T inner join tmp_unit_exam U
on ( ${konto_exam_join}
--and T.sem_rueck_beur_ein=U.sem_der_pruefung
and U.bonus_weight_type='BONUS_WEIGHT'
and ${LM_PSTATUS_KZ_BE}
and U.bonus_ist_weighted is not null
);


insert into tmp_konto_pro_fs_2(
 tid,
       ects_ist
        )
select T.tid,
sum(U.bonus_ist_weighted) as ects_ist
from tmp_konto_pro_fs T left outer join tmp_unit_exam2 U
on ( U.tmp_konto_pro_fs_tid=T.tid
and T.sem_rueck_beur_ein=U.sem_der_pruefung
)
group by 1
;


select 'IST fertig: ' || now() from xdummy;


insert into tmp_konto_pro_fs_2(
 tid,
       ects_ist_kum
        )
select T.tid,
sum(U.bonus_ist_weighted) as ects_ist
from tmp_konto_pro_fs T left outer join tmp_unit_exam2 U
on ( U.tmp_konto_pro_fs_tid=T.tid
and T.sem_rueck_beur_ein>=U.sem_der_pruefung 
)
group by 1
;

drop table tmp_unit_exam2;

select 'IST (kum.) fertig: ' || now() from xdummy;

<#if K_LM_BERECHNE_HAWMODELL==1>


select 'Start CP IST Aggregation ' || now() from xdummy;


insert into tmp_cp_pro_fs(
 tid,
 labnr_parent_term,
 labnr_parent_pstatus,
       cp_ist
        )
select T.tid,
U.labnr_parent_term,
U.labnr_parent_pstatus,
sum(U.bonus_ist_weighted) as cp_ist
from tmp_konto_pro_fs T inner join tmp_unit_exam U
on ( ${konto_exam_join}
and T.sem_rueck_beur_ein=U.sem_der_pruefung 
and U.bonus_weight_type in ('BONUS_CP_WEIGHT')
--entweder das übergeordnete Modul ist in der Zukunft, oder
--die übergeordnete Prüfung steht auf "PV":
and (
U.labnr_parent_term >  T.sem_rueck_beur_ein
or (1=1
--U.labnr_parent_term= T.sem_rueck_beur_ein
and U.labnr_parent_pstatus !='BE')
)
)
group by 1,2,3
;


select 'CP IST fertig: ' || now() from xdummy;




--ects_ancp
insert into tmp_konto_pro_fs_2(
 tid,
 ects_ancp )
select T.tid,
sum(U.bonus_exam_weighted) 
from tmp_konto_pro_fs T, tmp_unit_exam U
where ${konto_exam_join}
and T.sem_rueck_beur_ein=U.sem_der_pruefung 
and ${LM_ANCP}
group by 1
;

select 'ects_ancp fertig: ' || now() from xdummy;

--ects_ancp_kum
insert into tmp_konto_pro_fs_2(
 tid,
 ects_ancp_kum )
select T.tid,
sum(U.bonus_exam_weighted) 
from tmp_konto_pro_fs T, tmp_unit_exam U
where ${konto_exam_join}
and T.sem_rueck_beur_ein>=U.sem_der_pruefung 
and ${LM_ANCP}
group by 1
;

select 'ects_ancp (kum.) fertig: ' || now() from xdummy;


--ects_nbcp
insert into tmp_konto_pro_fs_2(
 tid,
 ects_nbcp )
select T.tid,
sum(U.bonus_pord_weighted) 
from tmp_konto_pro_fs T, tmp_unit_exam U
where ${konto_exam_join}
and T.sem_rueck_beur_ein=U.sem_der_pruefung 
and ${LM_NBCP}
group by 1
;

select 'ects_nbcp fertig: ' || now() from xdummy;

--ects_nbcp_kum
insert into tmp_konto_pro_fs_2(
 tid,
 ects_nbcp_kum )
select T.tid,
sum(U.bonus_pord_weighted) 
from tmp_konto_pro_fs T, tmp_unit_exam U
where ${konto_exam_join}
and T.sem_rueck_beur_ein>=U.sem_der_pruefung 
and ${LM_NBCP}
group by 1
;

select 'ects_nbcp (kum.) fertig: ' || now() from xdummy;

--ects_rtcp
insert into tmp_konto_pro_fs_2(
 tid,
 ects_rtcp )
select T.tid,
sum(U.bonus_pord_weighted) 
from tmp_konto_pro_fs T, tmp_unit_exam U
where ${konto_exam_join}
and T.sem_rueck_beur_ein=U.sem_der_pruefung 
and ${LM_RTCP}
group by 1
;

select 'ects_rtcp  fertig: ' || now() from xdummy;

--ects_rtcp_kum
insert into tmp_konto_pro_fs_2(
 tid,
 ects_rtcp_kum )
select T.tid,
sum(U.bonus_pord_weighted) 
from tmp_konto_pro_fs T, tmp_unit_exam U
where ${konto_exam_join}
and T.sem_rueck_beur_ein>=U.sem_der_pruefung 
and ${LM_RTCP}
group by 1
;

select 'ects_rtcp (kum.) fertig: ' || now() from xdummy;


--ects_befvcp
insert into tmp_konto_pro_fs_2(
 tid,
 ects_befvcp )
select T.tid,
sum(U.bonus_exam_weighted) 
from tmp_konto_pro_fs T, tmp_unit_exam U
where ${konto_exam_join}
and T.sem_rueck_beur_ein=U.sem_der_pruefung 
and U.freiversuch=1
and U.pstatus='BE'
group by 1
;

select 'ects_befvcp  fertig: ' || now() from xdummy;

--ects_befvcp_kum
insert into tmp_konto_pro_fs_2(
 tid,
 ects_befvcp_kum )
select T.tid,
sum(U.bonus_exam_weighted) 
from tmp_konto_pro_fs T, tmp_unit_exam U
where ${konto_exam_join}
and T.sem_rueck_beur_ein>=U.sem_der_pruefung 
and U.freiversuch=1
and U.pstatus='BE'
group by 1
;

select 'ects_befvcp (kum.) fertig: ' || now() from xdummy;


--ects_nbfvcp
insert into tmp_konto_pro_fs_2(
 tid,
 ects_nbfvcp )
select T.tid,
sum(U.bonus_pord_weighted) 
from tmp_konto_pro_fs T, tmp_unit_exam U
where ${konto_exam_join}
and T.sem_rueck_beur_ein=U.sem_der_pruefung 
and U.freiversuch=1
and U.pstatus in ('NB','EN')
group by 1
;

select 'ects_nbfvcp  fertig: ' || now() from xdummy;

--ects_nbfvcp_kum
insert into tmp_konto_pro_fs_2(
 tid,
 ects_nbfvcp_kum )
select T.tid,
sum(U.bonus_pord_weighted) 
from tmp_konto_pro_fs T, tmp_unit_exam U
where ${konto_exam_join}
and T.sem_rueck_beur_ein>=U.sem_der_pruefung 
and U.freiversuch=1
and U.pstatus in ('NB','EN')
group by 1
;

select 'ects_nbfvcp (kum.) fertig: ' || now() from xdummy;

</#if> --Ende K_LM_BERECHNE_HAWMODELL==1

<@selectintotmp 
select="T.tid,
sum(T.ects_ist) as ects_ist, 
sum(T.ects_ist_kum) as ects_ist_kum,
sum(T.ects_ancp) as ects_ancp, 
sum(T.ects_ancp_kum) as ects_ancp_kum,
sum(T.ects_nbcp) as ects_nbcp, 
sum(T.ects_nbcp_kum) as ects_nbcp_kum,
sum(T.ects_rtcp) as ects_rtcp, 
sum(T.ects_rtcp_kum) as ects_rtcp_kum,
sum(T.ects_befvcp) as ects_befvcp, 
sum(T.ects_befvcp_kum) as ects_befvcp_kum,
sum(T.ects_nbfvcp) as ects_nbfvcp, 
sum(T.ects_nbfvcp_kum) as ects_nbfvcp_kum
"
source="tmp_konto_pro_fs_2 T"
target="tmp_konto_pro_fs_3">
group by 1
</@selectintotmp>
 <@informixnolog/>;

create  index ix_tmp_konto_pro_fs233 on tmp_konto_pro_fs_3(tid );


<@selectintotmp 
select="T.tid,
T.labnr_parent_term,
T.labnr_parent_pstatus,
sum(T.cp_ist) as cp_ist, 
sum(T.cp_ist_kum) as cp_ist_kum
"
source="tmp_cp_pro_fs T"
target="tmp_cp_pro_fs2">
group by 1,2,3
</@selectintotmp>
 <@informixnolog/>;
 
 
update tmp_cp_pro_fs2 set cp_ist_kum=0 where cp_ist_kum is null;
update tmp_konto_pro_fs_3 set ects_ist_kum=0 where ects_ist_kum is null;
update tmp_konto_pro_fs_3 set ects_ist=0 where ects_ist is null;
update tmp_konto_pro_fs_3 set ects_befvcp_kum=0 where ects_befvcp_kum is null;
update tmp_konto_pro_fs_3 set ects_ancp_kum=0 where ects_ancp_kum is null;
update tmp_konto_pro_fs_3 set ects_rtcp_kum=0 where ects_rtcp_kum is null;
update tmp_konto_pro_fs_3 set ects_nbcp_kum=0 where ects_nbcp_kum is null;
update tmp_konto_pro_fs_3 set ects_nbfvcp_kum=0 where ects_nbfvcp_kum is null;

<#if LM_ECTS_IST_POS?exists>

<#if LM_ECTS_IST_PRUNE_DUPLICATES?exists && LM_ECTS_IST_PRUNE_DUPLICATES !="">
<#assign inlineTemplate=LM_ECTS_IST_PRUNE_DUPLICATES?interpret />
<@inlineTemplate/>

--Duplikatssuche:
<#if PRUNE_DUPLICATES?exists >
<#foreach rule in PRUNE_DUPLICATES>

select 'Start Duplikatsentfernung ${rule.DETECTOR}: ' || now() from xdummy;


--zuerst alle Prüfungen:
select P.*, 
${rule.DETECTOR} as duplikatsdetektor
into temp tmp_lab from sos_pord O, sos_lab P
where O.pordnr=P.pordnr
and O.sourcesystem=P.sourcesystem
and ${LM_ECTS_IST_POS} 
and P.sourcesystem=5
and (matrikel_nr,ch30_fach_stg,ch35_ang_abschluss_stg)
in (select distinct T.matrikel_nr,T.stg,T.abschluss
from tmp_konto_pro_fs T)
;

create index tmp_ix1 on tmp_lab(matrikel_nr);
create index tmp_ix2 on tmp_lab(duplikatsdetektor);
create index tmp_ix3 on tmp_lab(ch30_fach_stg);
create index tmp_ix4 on tmp_lab(ch35_ang_abschluss_stg);

drop table if exists tmp_lab_doppelt;

select 'Duplikatsentfernung ${rule.DETECTOR} Duplikate finden: ' || now() from xdummy;

--dann Duplikate finden:
select P.matrikel_Nr,
P.ch30_fach_stg,
P.ch35_ang_abschluss_stg,
duplikatsdetektor, --,P.labnr,*, 
--${rule.DETECTOR} as duplikatsdetektor,
null::smallint as min_semester
into temp tmp_lab_doppelt 
from tmp_lab P
group by 1,2,3,4
having count(*)>1
;
--min. Semester rausfinden:

select 'Duplikatsentfernung ${rule.DETECTOR} Duplikate min. Semester rausfinden: ' || now() from xdummy;


update tmp_lab_doppelt D set min_semester=(select min(sem_der_pruefung)
from tmp_lab P
where P.matrikel_nr=D.matrikel_nr
and P.duplikatsdetektor=D.duplikatsdetektor
and D.ch30_fach_stg=D.ch30_fach_stg
and P.ch35_ang_abschluss_stg=D.ch35_ang_abschluss_stg);

select 'Duplikatsentfernung ${rule.DETECTOR} Duplikate für join vorbereiten: ' || now() from xdummy;

--duplikate für neue Tabelle aufbauen, die dann per labnr gejoined werden kann:
drop table if exists tmp_lab_with_duplicates_marked;
select T.*,
(case when panerk ='${rule.panerk}' 
and T.sem_der_pruefung >= D.min_semester
then 1::smallint else 0::smallint end)  as is_duplicate,
1::smallint as has_duplicates
into temp tmp_lab_with_duplicates_marked
from tmp_lab T inner join tmp_lab_doppelt D on (
T.matrikel_nr=D.matrikel_nr
and T.duplikatsdetektor=D.duplikatsdetektor
and T.ch30_fach_stg=D.ch30_fach_stg
and T.ch35_ang_abschluss_stg=D.ch35_ang_abschluss_stg
)
;

select 'Duplikatsentfernung ${rule.DETECTOR} Duplikate raus: ' || now() from xdummy;


select D.is_duplicate,T.*
into temp tmp_lab_pruned
from tmp_lab T left outer join tmp_lab_with_duplicates_marked D on (
T.labnr=D.labnr
and T.sourcesystem=D.sourcesystem
)
where (D.is_duplicate=0 or D.is_duplicate is null)
;


create index tmp_ixp1 on tmp_lab_pruned(matrikel_nr);
create index tmp_ixp2 on tmp_lab_pruned(sem_der_pruefung);
create index tmp_ixp3 on tmp_lab_pruned(ch30_fach_stg);
create index tmp_ixp4 on tmp_lab_pruned(ch35_ang_abschluss_stg);
create index tmp_ixp5 on tmp_lab_pruned(fach_sem_zahl);

select 'Duplikatsentfernung ${rule.DETECTOR} Kontentabelle berechnen: ' || now() from xdummy;


update tmp_konto_pro_fs_3 set ects_ist_kum=(select sum(P.bonus)
from tmp_lab_pruned P,tmp_konto_pro_fs T
where T.tid=tmp_konto_pro_fs_3.tid
and P.matrikel_nr=T.matrikel_nr
and P.ch30_fach_stg=T.stg
and P.ch35_ang_abschluss_stg=T.abschluss
and P.sem_der_pruefung <=T.sem_rueck_beur_ein
and P.fach_sem_zahl<=T.fach_sem_zahl
)
where ects_ist_kum=0
;
select 'Ende Duplikatsentfernung ${rule.DETECTOR} ' || now() from xdummy;

drop table tmp_lab;
drop table tmp_lab_pruned;
drop table tmp_lab_doppelt;
drop table tmp_lab_with_duplicates_marked;
</#foreach>
</#if>
<#else>
--keine Duplikatssuche:
--Nachladen IST aus POS:

select 'Nachladen IST aus POS: ' || now() from xdummy;

update tmp_konto_pro_fs_3 set ects_ist_kum=ects_ist_kum +(select sum(P.bonus)
from sos_lab_pord P,tmp_konto_pro_fs T
where T.tid=tmp_konto_pro_fs_3.tid
and P.matrikel_nr=T.matrikel_nr
and P.ch30_fach_stg=T.stg
and P.ch35_ang_abschluss_stg=T.abschluss
and ${LM_ECTS_IST_POS} 
and P.sourcesystem=5
and P.sem_der_pruefung <=T.sem_rueck_beur_ein
and P.fach_sem_zahl<=T.fach_sem_zahl
)
where ects_ist_kum=0
;
</#if>--wenn LM_ECTS_IST_PRUNE_DUPLICATES aktiv ist
</#if> --wenn LM_ECTS_IST_POS existiert


select 'IST,ancp,rtcp,nbcp,befvcp,nbfvcp fertig: ' || now() from xdummy;



--update tmp_konto_pro_fs set ects_soll_kum=0 where ects_soll_kum is null;
--update tmp_konto_pro_fs set ects_soll=0 where ects_soll is null;


<#if LM_ELEMENTTYP_SIGNAL?has_content>
--Signalprüfungen?
update tmp_konto_pro_fs set signalpr_vert=U.signalpr_vert
from tmp_unit_exam U
where tmp_konto_pro_fs.matrikel_nr=U.matrikel_nr
and tmp_konto_pro_fs.tid_stg=U.tid_stg
and tmp_konto_pro_fs.sem_rueck_beur_ein>=U.sem_der_pruefung 
and U.signalpr_vert is not null
<#if LM_PSTATUS_SIGNAL?has_content>
and U.${LM_PSTATUS_SIGNAL}
</#if>
;
</#if>

--Studienbeginn:
update tmp_konto_pro_fs set sem_rueck_beur_ein_beginn=S.sem_rueck_beur_ein_min_student
from tmp_student S
where tmp_konto_pro_fs.matrikel_nr=S.matrikel_nr
and tmp_konto_pro_fs.tid_stg=S.tid_stg
and tmp_konto_pro_fs.sem_rueck_beur_ein>=S.sem_rueck_beur_ein_min_student 
;

delete from lm_konto_pro_fs
where exists (select 1 from tmp_konto_pro_fs T
where T.matrikel_nr=lm_konto_pro_fs.matrikel_nr)
;


insert into lm_konto_pro_fs(
 matrikel_nr,
       pseudonym,
       ca12_staat,
       geschlecht,
       alter,
       hzbart,
       hzbart_int,
       hzbnote,
       hrst,
       sem_rueck_beur_ein,
       sem_rueck_beur_ein_beginn,
       kz_rueck_beur_ein  ,
       tid_stg,
       pversion,
       pversion_uniquename,
       studiengang_nr,
       fach_nr,
       stg,
       abschluss,
       stufrm,
       stutyp,
       ch62_grund_exmatr,
       fach_sem_zahl,
       min_fach_sem_zahl,
       max_fach_sem_zahl,
       regel,
       aktiv,
       signalpr_vert,
       ects_soll,
       ects_soll_kum,
       ects_ist,
       ects_ist_kum,
 --      cp_ist,
--       cp_ist_kum,
       ects_ancp,
       ects_ancp_kum,
       ects_nbcp,
       ects_nbcp_kum,
       ects_rtcp,
       ects_rtcp_kum,
       ects_befvcp,
       ects_befvcp_kum,
       ects_nbfvcp,
       ects_nbfvcp_kum,
        summe)
       select  T.matrikel_nr,
T.pseudonym,
T.ca12_staat,
T.geschlecht,
T.alter,
T.hzbart,
T.hzbart_int,
T.hzbnote,
T.hrst,
T.sem_rueck_beur_ein,
T.sem_rueck_beur_ein_beginn,
T.kz_rueck_beur_ein,
T.tid_stg,
T.pversion,
T.pversion_uniquename,
T.studiengang_nr,
T.fach_nr,
T.stg,
T.abschluss,
T.stufrm,
T.stutyp,
T.ch62_grund_exmatr,
T.fach_sem_zahl,
T.min_fach_sem_zahl,
T.max_fach_sem_zahl,
T.regel,
T.aktiv,
T.signalpr_vert,
T.ects_soll,
T.ects_soll_kum,
T2.ects_ist,
T2.ects_ist_kum,
--T2.cp_ist,
--T2.cp_ist_kum,
T2.ects_ancp,
T2.ects_ancp_kum,
T2.ects_nbcp,
T2.ects_nbcp_kum,
T2.ects_rtcp,
T2.ects_rtcp_kum,
T2.ects_befvcp,
T2.ects_befvcp_kum,
T2.ects_nbfvcp,
T2.ects_nbfvcp_kum,
T.summe
from tmp_konto_pro_fs T, tmp_konto_pro_fs_3 T2
where T.tid=T2.tid;



delete from lm_cp_pro_fs
where exists (select 1 from tmp_konto_pro_fs T
where T.matrikel_nr=lm_cp_pro_fs.matrikel_nr)
;


insert into lm_cp_pro_fs(
 matrikel_nr,
       sem_rueck_beur_ein,
       sem_rueck_beur_ein_beginn,
       tid_stg,
       pversion,
       pversion_uniquename,
       studiengang_nr,
       fach_nr,
       stg,
       abschluss,
       stufrm,
       stutyp,
       fach_sem_zahl,
       labnr_parent_term,
       labnr_parent_pstatus,
       cp_ist,
       cp_ist_kum,
        summe)
       select  T.matrikel_nr,
T.sem_rueck_beur_ein,
T.sem_rueck_beur_ein_beginn,
T.tid_stg,
T.pversion,
T.pversion_uniquename,
T.studiengang_nr,
T.fach_nr,
T.stg,
T.abschluss,
T.stufrm,
T.stutyp,
T.fach_sem_zahl,
T2.labnr_parent_term,
T2.labnr_parent_pstatus,
T2.cp_ist,
T2.cp_ist_kum,
T.summe
from tmp_konto_pro_fs T, tmp_cp_pro_fs2 T2
where T.tid=T2.tid;




 
 --LVM:
<#if K_SOS_ECTS_CA_SRC==1>

select 'Prüfroutine LVM GANG: ' || now() from xdummy;


insert into lm_pruefrout (datum,
       semester,
       tabelle,
       matrikel_nr,
       tid_stg,
       problem,
       aktion)
       select today(),
       K.sem_rueck_beur_ein,
       'gang_zu_cnw',
       K.matrikel_nr,
       K.tid_stg,
       'Studiengang ohne LVM',
       'Warnung'
       from lm_konto_pro_fs K, gang_lehr_stg_ab G left outer join gang_zu_cnw Z
       on (Z.gang_tid=G.gang_tid)
       where G.lehr_stg_ab_tid=K.tid_Stg
       and Z.gang_cnw_tid is null
       and K.aktiv=1
and hrst in (select apnr from sos_k_hrst where astat='1')
--ohne Franchise:
<#if SOS_FRANCHISE?exists >
and not(${SOS_FRANCHISE})
</#if>
--ohne auslaufende Studiengänge:
<#if SOS_STG_AUSLAUF?exists >
and not(${SOS_STG_AUSLAUF})
</#if>
--ohne incoming
<#if SOS_INCOMING?exists >
and not(${SOS_INCOMING})
</#if>
--ohne Weiterbildung:
<#if SOS_ECTS_WEITERB?exists >
and not(${SOS_ECTS_WEITERB})
</#if>
--ende filter NRW
 ;

</#if>


drop table tmp_unit_exam;
drop table tmp_student_pro_fs;
drop table tmp_konto_pro_fs;
drop table tmp_konto_pro_fs_2;
drop table tmp_konto_pro_fs_3;
drop table tmp_cp_pro_fs;
drop table tmp_cp_pro_fs2;
drop table tmp_student;
drop table tmp_student_weitere_faecher;

<#else>

--Ergebnisaufbereitung in Maske:

--CP zählen nur wenn übergeordnete Prüfung Modul außerhalb des Berichtszeitraums ist:
update tmp_unit_exam set bonus_ist_weighted=null,
bonus_weight_type=''
where bonus_weight_type='BONUS_CP_WEIGHT'
and parent_unit_ismodule=1
and labnr_parent_term <= <<Semester>> ;


<@selectintotmp 
select="tid_stg,
tid_stg_str,
max(sem_der_pruefung) as sem_der_pruefung,
max(fach_sem_zahl) as fach_sem_zahl,
sum(bonus_ist_weighted) as bonus_ist_weighted,
min(ebene)::integer as ebene
"
source="tmp_unit_exam"
target="tmp_unit_exam_summe">
where 1=1
and sem_der_pruefung <= <<Semester>> 
group by 1,2
</@selectintotmp>
 <@informixnolog/>;

insert into tmp_unit_exam(ebene,
pdtxt,
sortnr,
sem_der_pruefung,
fach_sem_zahl,
bonus_ist_weighted)
select ebene-1,
tid_stg_str,
'0_' || tid_stg,
sem_der_pruefung,
fach_sem_zahl,
bonus_ist_weighted
from tmp_unit_exam_summe;

update tmp_unit_exam set part_str=trim(part) || '-' || string_not_null((select K.druck
from sos_k_part K
where K.apnr=tmp_unit_exam.part))
where part is not null
;
update tmp_unit_exam set modulart_str=trim(modulart) || '-' || string_not_null((select K.druck
from sos_k_modulart K
where K.apnr=tmp_unit_exam.modulart))
where modulart is not null
;
update tmp_unit_exam set sem_der_pruefung_str=nvl((select S.eintrag
from semester S
where S.tid=tmp_unit_exam.sem_der_pruefung),sem_der_pruefung::varchar(255))
where sem_der_pruefung is not null
;

<@selectintotmp 
select="distinct ebene,
pdtxt,
sortnr,
modulart_str, 
elementnr,
unit_uniquename,
sem_der_pruefung_str,
fach_sem_zahl,
d_abg_pruefung,
part_str,
panerk,
pversuch,
pstatus,
prueck,
pvermerk,
note,
freiversuch,
signalpr_vert,
bonus_pord,
bonus_exam  , 
(case when bonus_weight_type='BONUS_WEIGHT' then 'ECTS' 
when bonus_weight_type='BONUS_CP_WEIGHT' then 'CP'
else '' end) as bonus_weight_type,
bonus_anteil_formel  , 
bonus_ist_weighted  ,
bonus_pord_weighted
"
source="tmp_unit_exam"
target="tmp_unit_exam2">
where 1=1
order by sortnr, 1,2,3,4,5,6,7
</@selectintotmp>
 <@informixnolog/>;

drop table tmp_student;
drop table tmp_student_weitere_faecher;

drop table tmp_unit_exam;
drop table tmp_unit_exam_summe;



select ebene,
pdtxt,
--sortnr,
modulart_str, 
elementnr,
unit_uniquename,
sem_der_pruefung_str,
fach_sem_zahl,
d_abg_pruefung,
part_str,
panerk,
pversuch,
pstatus,
prueck,
pvermerk,
note,
freiversuch,
signalpr_vert,
bonus_pord,
bonus_exam  , 
bonus_anteil_formel  , 
bonus_weight_type,
bonus_ist_weighted  ,
bonus_pord_weighted
from tmp_unit_exam2 ;

</#if>
