
--SQL Script automatisch generiert von SuperX module_upgrade.xsl
--Freemarker Template
<sqlvars>
<sqlvar name="tables" type="list">

select relname,relname as tabelle from pg_class JOIN pg_namespace ON pg_namespace.oid = pg_class.relnamespace WHERE pg_namespace.nspname = 'public' AND relname::varchar(200) in ('lm_konto_pro_fs',
'lm_cp_pro_fs',
'lm_exam_unit',
'lm_exam_unit_studies',
'lm_unit',
'lm_unit_neu',
'lm_unit_studies_neu',
'lm_unit_studies',
'lm_unitrelation',
'lm_unitrelation_neu',
'lm_examination',
'lm_examination_neu',
'lm_examrelation',
'lm_examrelation_neu',
'lm_cifx_neu',
'lm_pruefrout',
'lm_ects_soll_neu',
'lm_ects_soll',
'lm_examplan_neu',
'lm_examplan',
'lm_course_of_study_neu',
'lm_course_of_study',
'lm_stud_d_neu',
'lm_stud_d',
'lm_accreditation_neu',
'lm_accreditation',
'lm_filter',
'lm_unit_top',
'lm_unit_top_neu',
'lm_exam_instructor_neu',
'lm_exam_instructor',
'lm_exam_written',
'lm_additional_examtext',
'lm_ects_soll_ist',
'lm_unit_fg') UNION SELECT pg_namespace.nspname||'.'||relname as relname,pg_namespace.nspname||'.'||relname as tabelle from pg_class JOIN pg_namespace ON pg_namespace.oid = pg_class.relnamespace WHERE pg_namespace.nspname||'.'||relname in ('lm_konto_pro_fs',
'lm_cp_pro_fs',
'lm_exam_unit',
'lm_exam_unit_studies',
'lm_unit',
'lm_unit_neu',
'lm_unit_studies_neu',
'lm_unit_studies',
'lm_unitrelation',
'lm_unitrelation_neu',
'lm_examination',
'lm_examination_neu',
'lm_examrelation',
'lm_examrelation_neu',
'lm_cifx_neu',
'lm_pruefrout',
'lm_ects_soll_neu',
'lm_ects_soll',
'lm_examplan_neu',
'lm_examplan',
'lm_course_of_study_neu',
'lm_course_of_study',
'lm_stud_d_neu',
'lm_stud_d',
'lm_accreditation_neu',
'lm_accreditation',
'lm_filter',
'lm_unit_top',
'lm_unit_top_neu',
'lm_exam_instructor_neu',
'lm_exam_instructor',
'lm_exam_written',
'lm_additional_examtext',
'lm_ects_soll_ist',
'lm_unit_fg'
);</sqlvar>
</sqlvars>

<#assign deleted_tables = []>

<#if tables?is_sequence && tables?seq_contains("lm_unit_neu") >
drop table lm_unit_neu;
<#assign deleted_tables = deleted_tables + ["lm_unit_neu"]>
</#if>

<#if tables?is_sequence && tables?seq_contains("lm_unit_studies_neu") >
drop table lm_unit_studies_neu;
<#assign deleted_tables = deleted_tables + ["lm_unit_studies_neu"]>
</#if>

<#if tables?is_sequence && tables?seq_contains("lm_unitrelation_neu") >
drop table lm_unitrelation_neu;
<#assign deleted_tables = deleted_tables + ["lm_unitrelation_neu"]>
</#if>

<#if tables?is_sequence && tables?seq_contains("lm_examination_neu") >
drop table lm_examination_neu;
<#assign deleted_tables = deleted_tables + ["lm_examination_neu"]>
</#if>

<#if tables?is_sequence && tables?seq_contains("lm_examrelation_neu") >
drop table lm_examrelation_neu;
<#assign deleted_tables = deleted_tables + ["lm_examrelation_neu"]>
</#if>

<#if tables?is_sequence && tables?seq_contains("lm_cifx_neu") >
drop table lm_cifx_neu;
<#assign deleted_tables = deleted_tables + ["lm_cifx_neu"]>
</#if>

<#if tables?is_sequence && tables?seq_contains("lm_ects_soll_neu") >
drop table lm_ects_soll_neu;
<#assign deleted_tables = deleted_tables + ["lm_ects_soll_neu"]>
</#if>

<#if tables?is_sequence && tables?seq_contains("lm_examplan_neu") >
drop table lm_examplan_neu;
<#assign deleted_tables = deleted_tables + ["lm_examplan_neu"]>
</#if>

<#if tables?is_sequence && tables?seq_contains("lm_course_of_study_neu") >
drop table lm_course_of_study_neu;
<#assign deleted_tables = deleted_tables + ["lm_course_of_study_neu"]>
</#if>

<#if tables?is_sequence && tables?seq_contains("lm_stud_d_neu") >
drop table lm_stud_d_neu;
<#assign deleted_tables = deleted_tables + ["lm_stud_d_neu"]>
</#if>

<#if tables?is_sequence && tables?seq_contains("lm_accreditation_neu") >
drop table lm_accreditation_neu;
<#assign deleted_tables = deleted_tables + ["lm_accreditation_neu"]>
</#if>

<#if tables?is_sequence && tables?seq_contains("lm_unit_top_neu") >
drop table lm_unit_top_neu;
<#assign deleted_tables = deleted_tables + ["lm_unit_top_neu"]>
</#if>

<#if tables?is_sequence && tables?seq_contains("lm_exam_instructor_neu") >
drop table lm_exam_instructor_neu;
<#assign deleted_tables = deleted_tables + ["lm_exam_instructor_neu"]>
</#if>


select now(), 'Checking tables';


<#if !deleted_tables?seq_contains("lm_konto_pro_fs") && tables?is_sequence && tables?seq_contains("lm_konto_pro_fs") >


select now(), 'table lm_konto_pro_fs exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_konto_pro_fs';

create table lm_konto_pro_fs(
	tid SERIAL  not null, 
matrikel_nr INTEGER , 
pseudonym VARCHAR(255) , 
ca12_staat SMALLINT  not null, 
geschlecht SMALLINT  not null, 
alter decimal(14,2) , 
hzbart SMALLINT , 
hzbart_int CHAR(10) , 
hzbnote decimal(5,2) , 
hrst CHAR(10) , 
sem_rueck_beur_ein INTEGER , 
tid_stg INTEGER , 
pversion SMALLINT , 
pversion_uniquename VARCHAR(255) , 
studiengang_nr INTEGER , 
fach_nr INTEGER , 
stg CHAR(10) , 
abschluss CHAR(10) , 
stufrm CHAR(10) , 
stutyp CHAR(10) , 
ch62_grund_exmatr CHAR(10) , 
fach_sem_zahl INTEGER , 
min_fach_sem_zahl INTEGER , 
max_fach_sem_zahl INTEGER , 
regel FLOAT , 
aktiv SMALLINT , 
ects_soll FLOAT , 
ects_soll_kum FLOAT , 
ects_ist FLOAT , 
ects_ist_kum FLOAT , 
ects_ancp FLOAT , 
ects_ancp_kum FLOAT , 
ects_nbcp FLOAT , 
ects_nbcp_kum FLOAT , 
ects_rtcp FLOAT , 
ects_rtcp_kum FLOAT , 
ects_befvcp FLOAT , 
ects_befvcp_kum FLOAT , 
ects_nbfvcp FLOAT , 
ects_nbfvcp_kum FLOAT , 
signalpr_vert VARCHAR(255) , 
summe INTEGER , 
cp_ist FLOAT , 
cp_ist_kum FLOAT , 
sem_rueck_beur_ein_beginn INTEGER , 
kz_rueck_beur_ein SMALLINT , 
	constraint lm_konto_pro_fs_tid primary key (tid)

) 
;



comment on table lm_konto_pro_fs is 'Kontostand der Leistungen des Studierenden im jew. Studiengang pro Fachsemester. Datengrundlage für ECTS Soll-Ist Vergleich und HAW Modell';

comment on column lm_konto_pro_fs.tid is 'Laufnummer';

comment on column lm_konto_pro_fs.matrikel_nr is 'Matrikel-Nr.';

comment on column lm_konto_pro_fs.pseudonym is 'Pseudonym';

comment on column lm_konto_pro_fs.ca12_staat is 'Nationalität';

comment on column lm_konto_pro_fs.geschlecht is 'Geschlecht';

comment on column lm_konto_pro_fs.alter is 'Alter in Jahren';

comment on column lm_konto_pro_fs.hzbart is 'Art der HZB (gruppiert)';

comment on column lm_konto_pro_fs.hzbart_int is 'Art der Hochschulzugangsber. (intern)';

comment on column lm_konto_pro_fs.hzbnote is 'Note bei der HZB';

comment on column lm_konto_pro_fs.hrst is 'Hörerstatus';

comment on column lm_konto_pro_fs.sem_rueck_beur_ein is 'Semester';

comment on column lm_konto_pro_fs.tid_stg is 'Studiengang';

comment on column lm_konto_pro_fs.pversion is 'PO-Version';

comment on column lm_konto_pro_fs.pversion_uniquename is 'Prüfungsordnungsversion (Schlüssel)';

comment on column lm_konto_pro_fs.studiengang_nr is 'Studienang-Nr.';

comment on column lm_konto_pro_fs.fach_nr is 'Fach-Nr.';

comment on column lm_konto_pro_fs.stg is 'Fach (Konto)';

comment on column lm_konto_pro_fs.abschluss is 'Abschluss (Konto)';

comment on column lm_konto_pro_fs.stufrm is 'Studienform';

comment on column lm_konto_pro_fs.stutyp is 'Studientyp (Konto)';

comment on column lm_konto_pro_fs.ch62_grund_exmatr is 'Exmatrikulationsgrund';

comment on column lm_konto_pro_fs.fach_sem_zahl is 'Fachsemester';

comment on column lm_konto_pro_fs.min_fach_sem_zahl is 'Min. Fachsemester';

comment on column lm_konto_pro_fs.max_fach_sem_zahl is 'Max. Fachsemester';

comment on column lm_konto_pro_fs.regel is 'Regelstudienzeit';

comment on column lm_konto_pro_fs.aktiv is 'Aktiv';

comment on column lm_konto_pro_fs.ects_soll is 'ECTS Soll';

comment on column lm_konto_pro_fs.ects_soll_kum is 'ECTS Soll kumuliert';

comment on column lm_konto_pro_fs.ects_ist is 'ECTS Ist';

comment on column lm_konto_pro_fs.ects_ist_kum is 'ECTS Ist kumuliert';

comment on column lm_konto_pro_fs.ects_ancp is 'CP Anerkannt';

comment on column lm_konto_pro_fs.ects_ancp_kum is 'CP Anerkannt kumuliert';

comment on column lm_konto_pro_fs.ects_nbcp is 'CP Nicht Bestanden';

comment on column lm_konto_pro_fs.ects_nbcp_kum is 'CP Nicht Bestanden kumuliert';

comment on column lm_konto_pro_fs.ects_rtcp is 'CP Rücktritt';

comment on column lm_konto_pro_fs.ects_rtcp_kum is 'CP Rücktritt kumuliert';

comment on column lm_konto_pro_fs.ects_befvcp is 'CP aus bestandenen Freiversuchen';

comment on column lm_konto_pro_fs.ects_befvcp_kum is 'CP aus bestandenen Freiversuchen';

comment on column lm_konto_pro_fs.ects_nbfvcp is 'CP aus nicht bestandenen Freiversuchen';

comment on column lm_konto_pro_fs.ects_nbfvcp_kum is 'CP aus nicht bestandenen Freiversuchen';

comment on column lm_konto_pro_fs.signalpr_vert is 'Vertiefung gem. Signalprüfung';

comment on column lm_konto_pro_fs.summe is 'Summe';

comment on column lm_konto_pro_fs.cp_ist is 'CP Ist';

comment on column lm_konto_pro_fs.cp_ist_kum is 'CP Ist kumuliert';

comment on column lm_konto_pro_fs.sem_rueck_beur_ein_beginn is 'Semester bei Studienbeginn';

comment on column lm_konto_pro_fs.kz_rueck_beur_ein is 'Rückmeldestatus';


select now(), 'Erzeuge Index lm_konto_pro_fs1';

create  index lm_konto_pro_fs1 on lm_konto_pro_fs (matrikel_nr );


select now(), 'Erzeuge Index lm_konto_pro_fs2';

create  index lm_konto_pro_fs2 on lm_konto_pro_fs (tid_stg );


select now(), 'Erzeuge Index lm_konto_pro_fs3';

create  index lm_konto_pro_fs3 on lm_konto_pro_fs (stg );


select now(), 'Erzeuge Index lm_konto_pro_fs4';

create  index lm_konto_pro_fs4 on lm_konto_pro_fs (abschluss );


select now(), 'Erzeuge Index lm_konto_pro_fs5';

create  index lm_konto_pro_fs5 on lm_konto_pro_fs (sem_rueck_beur_ein );

</#if>
delete from db_tabellen where name='lm_konto_pro_fs';
insert into db_tabellen (name,protokollierung) values('lm_konto_pro_fs',0);

<#if !deleted_tables?seq_contains("lm_cp_pro_fs") && tables?is_sequence && tables?seq_contains("lm_cp_pro_fs") >


select now(), 'table lm_cp_pro_fs exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_cp_pro_fs';

create table lm_cp_pro_fs(
	tid SERIAL  not null, 
matrikel_nr INTEGER , 
sem_rueck_beur_ein INTEGER , 
tid_stg INTEGER , 
pversion SMALLINT , 
pversion_uniquename VARCHAR(255) , 
studiengang_nr INTEGER , 
fach_nr INTEGER , 
stg CHAR(10) , 
abschluss CHAR(10) , 
stufrm CHAR(10) , 
stutyp CHAR(10) , 
fach_sem_zahl INTEGER , 
labnr_parent_term INTEGER , 
labnr_parent_pstatus CHAR(10) , 
cp_ist FLOAT , 
cp_ist_kum FLOAT , 
summe INTEGER , 
sem_rueck_beur_ein_beginn INTEGER , 
	constraint lm_cp_pro_fs_tid primary key (tid)

) 
;



comment on column lm_cp_pro_fs.tid is 'Laufnummer';

comment on column lm_cp_pro_fs.matrikel_nr is 'Matrikel-Nr.';

comment on column lm_cp_pro_fs.sem_rueck_beur_ein is 'Semester';

comment on column lm_cp_pro_fs.tid_stg is 'Studiengang';

comment on column lm_cp_pro_fs.pversion is 'PO-Version';

comment on column lm_cp_pro_fs.pversion_uniquename is 'Prüfungsordnungsversion (Schlüssel)';

comment on column lm_cp_pro_fs.studiengang_nr is 'Studienang-Nr.';

comment on column lm_cp_pro_fs.fach_nr is 'Fach-Nr.';

comment on column lm_cp_pro_fs.stg is 'Fach (Konto)';

comment on column lm_cp_pro_fs.abschluss is 'Abschluss (Konto)';

comment on column lm_cp_pro_fs.stufrm is 'Studienform';

comment on column lm_cp_pro_fs.stutyp is 'Studientyp (Konto)';

comment on column lm_cp_pro_fs.fach_sem_zahl is 'Fachsemester';

comment on column lm_cp_pro_fs.labnr_parent_term is 'Semester der übergeordneten Prüfung';

comment on column lm_cp_pro_fs.labnr_parent_pstatus is 'Status der übergeordneten Prüfung';

comment on column lm_cp_pro_fs.cp_ist is 'ECTS Ist';

comment on column lm_cp_pro_fs.cp_ist_kum is 'ECTS Ist kumuliert';

comment on column lm_cp_pro_fs.summe is 'Summe';

comment on column lm_cp_pro_fs.sem_rueck_beur_ein_beginn is 'Semester bei Studienbeginn';


select now(), 'Erzeuge Index lm_cp_pro_fs1';

create  index lm_cp_pro_fs1 on lm_cp_pro_fs (matrikel_nr );


select now(), 'Erzeuge Index lm_cp_pro_fs2';

create  index lm_cp_pro_fs2 on lm_cp_pro_fs (tid_stg );


select now(), 'Erzeuge Index lm_cp_pro_fs3';

create  index lm_cp_pro_fs3 on lm_cp_pro_fs (stg );


select now(), 'Erzeuge Index lm_cp_pro_fs4';

create  index lm_cp_pro_fs4 on lm_cp_pro_fs (abschluss );


select now(), 'Erzeuge Index lm_cp_pro_fs5';

create  index lm_cp_pro_fs5 on lm_cp_pro_fs (sem_rueck_beur_ein );

</#if>
delete from db_tabellen where name='lm_cp_pro_fs';
insert into db_tabellen (name,protokollierung) values('lm_cp_pro_fs',0);

<#if !deleted_tables?seq_contains("lm_exam_unit") && tables?is_sequence && tables?seq_contains("lm_exam_unit") >


select now(), 'table lm_exam_unit exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_exam_unit';

create table lm_exam_unit(
	matrikel_nr INTEGER , 
labnr INTEGER , 
sourcesystem INTEGER , 
studiengang_nr SMALLINT , 
fach_nr SMALLINT , 
ch30_fach CHAR(10) , 
ch39_vertief CHAR(10) , 
ch35_ang_abschluss CHAR(10) , 
pversion SMALLINT , 
schwerpunkt CHAR(10) , 
kz_fach CHAR(10) , 
stort CHAR(10) , 
stutyp CHAR(10) , 
stufrm CHAR(10) , 
course_of_study_lid INTEGER , 
tid_stg INTEGER , 
sem_der_pruefung SMALLINT  not null, 
d_abg_pruefung DATE , 
sem_d_abg_pruefung SMALLINT , 
note FLOAT , 
fach_sem_zahl decimal(10,2) , 
recommended_semester FLOAT , 
pstatus CHAR(10) , 
prueck SMALLINT , 
pvermerk CHAR(10) , 
zeitabschnitt CHAR(10) , 
pform CHAR(10) , 
panerk CHAR(10) , 
panerk_art CHAR(10) , 
malus FLOAT , 
bonus FLOAT , 
pordnr INTEGER , 
part CHAR(10) , 
schriftlich SMALLINT , 
ppflicht CHAR(10) , 
modulart CHAR(10) , 
bonus_pord double precision , 
pktxt CHAR(255) , 
pdtxt CHAR(255) , 
pversuch INTEGER , 
pdum CHAR(10) , 
unit_uniquename VARCHAR(255) , 
official_statistics INTEGER , 
calculate_ects_sum INTEGER , 
elementnr VARCHAR(255) , 
zusatztext TEXT , 
summe INTEGER , 
unit_valid_from DATE , 
unit_valid_to DATE , 
shortcomment VARCHAR 
) 
;



comment on table lm_exam_unit is 'Hilfstabelle Einzelprüfungen: Zuordnung von Leistungen zu Prüfungslementen';

comment on column lm_exam_unit.matrikel_nr is 'Matrikel-Nr.';

comment on column lm_exam_unit.labnr is 'ID der Prüfung';

comment on column lm_exam_unit.sourcesystem is 'Quellsystem der Prüfung';

comment on column lm_exam_unit.studiengang_nr is 'Studiengang-Nr. der Prüfung';

comment on column lm_exam_unit.fach_nr is 'Fach-Nr. der Prüfung';

comment on column lm_exam_unit.ch30_fach is 'Fach der Leistung';

comment on column lm_exam_unit.ch39_vertief is 'Vertiefung';

comment on column lm_exam_unit.ch35_ang_abschluss is 'Abschluss';

comment on column lm_exam_unit.pversion is 'PO-Version der Leistung';

comment on column lm_exam_unit.schwerpunkt is 'Schwerpunkt';

comment on column lm_exam_unit.kz_fach is 'Fachkennzeichen';

comment on column lm_exam_unit.stort is 'Standort';

comment on column lm_exam_unit.stutyp is 'Studientyp (Konto)';

comment on column lm_exam_unit.stufrm is 'Studienform';

comment on column lm_exam_unit.course_of_study_lid is 'Studiengang (HIS)';

comment on column lm_exam_unit.tid_stg is 'Studiengang';

comment on column lm_exam_unit.sem_der_pruefung is 'Prüfungssemester';

comment on column lm_exam_unit.d_abg_pruefung is 'Prüfungsdatum';

comment on column lm_exam_unit.sem_d_abg_pruefung is 'Semester des Prüfungsdatums';

comment on column lm_exam_unit.note is 'Note';

comment on column lm_exam_unit.fach_sem_zahl is 'Fachsemesterzahl';

comment on column lm_exam_unit.recommended_semester is 'Empfohlenes Fachsemester nach PO';

comment on column lm_exam_unit.pstatus is 'Prüfungsstatus';

comment on column lm_exam_unit.prueck is 'Rücktrittskennzeichen (1/0)';

comment on column lm_exam_unit.pvermerk is 'Vermerk zur Prüfung';

comment on column lm_exam_unit.zeitabschnitt is 'Zeitabschnitt';

comment on column lm_exam_unit.pform is 'Form der Prüfung';

comment on column lm_exam_unit.panerk is 'Anerkannte Prüfung';

comment on column lm_exam_unit.panerk_art is 'Anerkannte Prüfung Art';

comment on column lm_exam_unit.malus is 'Maluspunkte dieser Prüfung';

comment on column lm_exam_unit.bonus is 'Bonus dieser Prüfung (Ist)';

comment on column lm_exam_unit.pordnr is 'Nummer des Prüfungselements';

comment on column lm_exam_unit.part is 'Art der Prüfung';

comment on column lm_exam_unit.schriftlich is 'Schriftliche Leistung (1/0)';

comment on column lm_exam_unit.ppflicht is 'Pflicht';

comment on column lm_exam_unit.modulart is 'Elementtyp';

comment on column lm_exam_unit.bonus_pord is 'ECTS Bonus lt. PO (Soll)';

comment on column lm_exam_unit.pktxt is 'Prüfungselement Kurztext';

comment on column lm_exam_unit.pdtxt is 'Prüfungselement Drucktext';

comment on column lm_exam_unit.pversuch is 'Versuchsanzahl';

comment on column lm_exam_unit.pdum is 'Kennzeichen Dummy-Pruefung';

comment on column lm_exam_unit.unit_uniquename is 'Unit (Schlüssel)';

comment on column lm_exam_unit.official_statistics is 'Statistikkennzeichen';

comment on column lm_exam_unit.calculate_ects_sum is 'Ermittlung Bonuspunkte Gesamtsumme';

comment on column lm_exam_unit.elementnr is 'Elementnr.';

comment on column lm_exam_unit.zusatztext is 'Zusatztext für Prüfungen';

comment on column lm_exam_unit.summe is 'Summe';

comment on column lm_exam_unit.unit_valid_from is 'Unit Gültig von';

comment on column lm_exam_unit.unit_valid_to is 'Unit Gültig bis';

comment on column lm_exam_unit.shortcomment is 'Unit Gültig bis';


select now(), 'Erzeuge Index lm_exam_unit1';

create  index lm_exam_unit1 on lm_exam_unit (labnr, 
sourcesystem, 
pordnr, 
matrikel_nr );


select now(), 'Erzeuge Index lm_exam_unit2';

create  index lm_exam_unit2 on lm_exam_unit (ch35_ang_abschluss, 
matrikel_nr, 
ch30_fach );


select now(), 'Erzeuge Index lm_exam_unit9';

create  index lm_exam_unit9 on lm_exam_unit (modulart );

</#if>
delete from db_tabellen where name='lm_exam_unit';
insert into db_tabellen (name,protokollierung) values('lm_exam_unit',0);

<#if !deleted_tables?seq_contains("lm_exam_unit_studies") && tables?is_sequence && tables?seq_contains("lm_exam_unit_studies") >


select now(), 'table lm_exam_unit_studies exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_exam_unit_studies';

create table lm_exam_unit_studies(
	matrikel_nr INTEGER , 
labnr INTEGER , 
sourcesystem INTEGER , 
labnr_parent INTEGER , 
top_labnr INTEGER , 
ebene INTEGER , 
pordnr INTEGER , 
pordnr_parent INTEGER , 
parent_unit_uniquename VARCHAR(255) , 
parent_unit_elementnr VARCHAR(255) , 
abschluss CHAR(10) , 
stg CHAR(10) , 
vertiefung CHAR(10) , 
schwerpunkt CHAR(10) , 
kz_fach CHAR(10) , 
pversion INTEGER , 
pversion_uniquename VARCHAR(255) , 
stutyp CHAR(10) , 
stort CHAR(10) , 
stufrm CHAR(10) , 
tid_stg INTEGER , 
calculate_ects_sum INTEGER , 
sortnr VARCHAR(255) , 
parent_unit_ismodule SMALLINT , 
labnr_parent_term INTEGER , 
labnr_parent_pstatus CHAR(10) , 
sem_der_pruefung SMALLINT , 
d_abg_pruefung DATE , 
note FLOAT , 
fach_sem_zahl decimal(10,2) , 
pstatus CHAR(10) , 
prueck SMALLINT , 
pvermerk CHAR(10) , 
pnr INTEGER , 
zeitabschnitt CHAR(10) , 
pform CHAR(10) , 
panerk CHAR(10) , 
panerk_art CHAR(10) , 
bonus_pord double precision , 
bonus_exam double precision , 
bonus_anteil_formel VARCHAR(255) , 
malus FLOAT , 
bonus FLOAT , 
pversuch INTEGER 
) 
;



comment on table lm_exam_unit_studies is 'Hilfstabelle Einzelprüfungen: Zuordnung von Leistungen zu Studiengängen';

comment on column lm_exam_unit_studies.matrikel_nr is 'Matrikel-Nr.';

comment on column lm_exam_unit_studies.labnr is 'ID der Prüfung';

comment on column lm_exam_unit_studies.sourcesystem is 'Quellsystem der Prüfung';

comment on column lm_exam_unit_studies.labnr_parent is 'Übergeordn. Knoten';

comment on column lm_exam_unit_studies.top_labnr is 'Top-Knoten';

comment on column lm_exam_unit_studies.ebene is 'Ebene im Baum';

comment on column lm_exam_unit_studies.pordnr is 'Nummer des Prüfungselements';

comment on column lm_exam_unit_studies.pordnr_parent is 'Nummer des übergeordn. Prüfungselements';

comment on column lm_exam_unit_studies.abschluss is 'Abschluss der Belegung';

comment on column lm_exam_unit_studies.stg is 'Studienfach der Belegung';

comment on column lm_exam_unit_studies.vertiefung is 'Vertiefung der Belegung';

comment on column lm_exam_unit_studies.schwerpunkt is 'Schwerpunkt der Belegung';

comment on column lm_exam_unit_studies.kz_fach is 'Haupt/Nebenfach der Belegung';

comment on column lm_exam_unit_studies.pversion is 'Prüfungsordnungsversion der Belegung';

comment on column lm_exam_unit_studies.pversion_uniquename is 'Prüfungsordnungsversion (Schlüssel)';

comment on column lm_exam_unit_studies.stutyp is 'Studiumstyp (Schlüssel)';

comment on column lm_exam_unit_studies.stort is 'Standort';

comment on column lm_exam_unit_studies.stufrm is 'Studienform';

comment on column lm_exam_unit_studies.tid_stg is 'Studiengang';

comment on column lm_exam_unit_studies.calculate_ects_sum is 'Ermittlung Bonuspunkte Gesamtsumme';

comment on column lm_exam_unit_studies.parent_unit_ismodule is 'Eltern-Unit ist Modul';

comment on column lm_exam_unit_studies.labnr_parent_term is 'Eltern-Prüfung Semester';

comment on column lm_exam_unit_studies.labnr_parent_pstatus is 'Eltern-Prüfung Status';

comment on column lm_exam_unit_studies.sem_der_pruefung is 'Prüfungssemester';

comment on column lm_exam_unit_studies.d_abg_pruefung is 'Prüfungsdatum';

comment on column lm_exam_unit_studies.note is 'Note';

comment on column lm_exam_unit_studies.fach_sem_zahl is 'Fachsemesterzahl aus SOS';

comment on column lm_exam_unit_studies.pstatus is 'Prüfungsstatus';

comment on column lm_exam_unit_studies.prueck is 'Rücktrittskennzeichen (1/0)';

comment on column lm_exam_unit_studies.pvermerk is 'Vermerk zur Prüfung';

comment on column lm_exam_unit_studies.pnr is 'Prüfungsnummer';

comment on column lm_exam_unit_studies.zeitabschnitt is 'Zeitabschnitt';

comment on column lm_exam_unit_studies.pform is 'Form der Prüfung';

comment on column lm_exam_unit_studies.panerk is 'Anerkannte Prüfung';

comment on column lm_exam_unit_studies.panerk_art is 'Anerkannte Prüfung (Art)';

comment on column lm_exam_unit_studies.bonus_pord is 'ECTS Bonus lt. PO';

comment on column lm_exam_unit_studies.bonus_exam is 'ECTS Bonus der Prüfung';

comment on column lm_exam_unit_studies.bonus_anteil_formel is 'Studiengangsspez. Anteil des IST (Formel)';

comment on column lm_exam_unit_studies.malus is 'Maluspunkte dieser Prüfung';

comment on column lm_exam_unit_studies.bonus is 'Guthaben-/Bonuspunkte dieser Prüfung im Studiengang';

comment on column lm_exam_unit_studies.pversuch is 'Versuchsanzahl';


select now(), 'Erzeuge Index ix_lm_exam_unit_studies1';

create  index ix_lm_exam_unit_studies1 on lm_exam_unit_studies (tid_stg, 
sourcesystem, 
matrikel_nr );

</#if>
delete from db_tabellen where name='lm_exam_unit_studies';
insert into db_tabellen (name,protokollierung) values('lm_exam_unit_studies',0);

<#if !deleted_tables?seq_contains("lm_unit") && tables?is_sequence && tables?seq_contains("lm_unit") >


select now(), 'table lm_unit exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_unit';

create table lm_unit(
	id INTEGER , 
sourcesystem INTEGER , 
shorttext VARCHAR(255) , 
defaulttext VARCHAR(255) , 
longtext VARCHAR(255) , 
elementnr VARCHAR(255) , 
calculate_ects_sum INTEGER , 
official_statistics INTEGER , 
elementtyp CHAR(10) , 
default_unitrelation_id INTEGER , 
pdum CHAR(10) , 
uniquename VARCHAR(255) , 
valid_from DATE , 
valid_to DATE , 
shortcomment VARCHAR 
) 
;



comment on column lm_unit.calculate_ects_sum is 'Ermittlung Bonuspunkte Gesamtsumme';

comment on column lm_unit.official_statistics is 'Kennzeichnung von Leistungen für offizielle Berichte (amtl.Statistik, Rente, Zeugnis)';

comment on column lm_unit.pdum is 'Kennzeichen Dummy-Prüfung';

comment on column lm_unit.uniquename is 'Schlüssel des Elements';

comment on column lm_unit.valid_from is 'Gültig von';

comment on column lm_unit.valid_to is 'Gültig bis';

comment on column lm_unit.shortcomment is 'Gültig bis';


select now(), 'Erzeuge Index ix_lm_unit1';

create  index ix_lm_unit1 on lm_unit (id, 
sourcesystem );


select now(), 'Erzeuge Index ix_lm_unit2';

create  index ix_lm_unit2 on lm_unit (default_unitrelation_id );

</#if>
delete from db_tabellen where name='lm_unit';
insert into db_tabellen (name,protokollierung) values('lm_unit',0);

<#if !deleted_tables?seq_contains("lm_unit_neu") && tables?is_sequence && tables?seq_contains("lm_unit_neu") >


select now(), 'table lm_unit_neu exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_unit_neu';

create table lm_unit_neu(
	id INTEGER , 
sourcesystem INTEGER , 
shorttext VARCHAR(255) , 
defaulttext VARCHAR(255) , 
longtext VARCHAR(255) , 
elementnr VARCHAR(255) , 
calculate_ects_sum INTEGER , 
official_statistics INTEGER , 
elementtyp VARCHAR(255) , 
default_unitrelation_id INTEGER , 
pdum CHAR(10) , 
uniquename VARCHAR(255) , 
hours_per_week FLOAT , 
editing_k_status_id VARCHAR(255) , 
transfer_allowed INTEGER , 
freetrial_check INTEGER , 
k_unit_purpose_id VARCHAR(255) , 
valid_from DATE , 
valid_to DATE , 
shortcomment VARCHAR 
) 
;



comment on column lm_unit_neu.calculate_ects_sum is 'Ermittlung Bonuspunkte Gesamtsumme';

comment on column lm_unit_neu.official_statistics is 'Kennzeichnung von Leistungen für offizielle Berichte (amtl.Statistik, Rente, Zeugnis)';

comment on column lm_unit_neu.pdum is 'Kennzeichen Dummy-Prüfung';

comment on column lm_unit_neu.uniquename is 'Schlüssel des Elements';

comment on column lm_unit_neu.valid_from is 'Gültig von';

comment on column lm_unit_neu.valid_to is 'Gültig bis';

comment on column lm_unit_neu.shortcomment is 'Gültig bis';

</#if>
delete from db_tabellen where name='lm_unit_neu';
insert into db_tabellen (name,protokollierung) values('lm_unit_neu',0);

<#if !deleted_tables?seq_contains("lm_unit_studies_neu") && tables?is_sequence && tables?seq_contains("lm_unit_studies_neu") >


select now(), 'table lm_unit_studies_neu exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_unit_studies_neu';

create table lm_unit_studies_neu(
	id INTEGER , 
sourcesystem INTEGER , 
unit_id INTEGER , 
course_of_study_lid INTEGER , 
root_elementtype_hiskey INTEGER 
) 
;



comment on column lm_unit_studies_neu.unit_id is 'Prüfungselement';

comment on column lm_unit_studies_neu.course_of_study_lid is 'Prüfungselement';

comment on column lm_unit_studies_neu.root_elementtype_hiskey is 'hiskey des Wurzelelementes, zu der die Unit gehört';

</#if>
delete from db_tabellen where name='lm_unit_studies_neu';
insert into db_tabellen (name,protokollierung) values('lm_unit_studies_neu',0);

<#if !deleted_tables?seq_contains("lm_unit_studies") && tables?is_sequence && tables?seq_contains("lm_unit_studies") >


select now(), 'table lm_unit_studies exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_unit_studies';

create table lm_unit_studies(
	id INTEGER , 
sourcesystem INTEGER , 
unit_id INTEGER , 
unit_studies_anz INTEGER , 
course_of_study_lid INTEGER , 
root_elementtype_hiskey INTEGER 
) 
;



comment on column lm_unit_studies.unit_id is 'Prüfungselement';

comment on column lm_unit_studies.unit_studies_anz is 'Anzahl Zuordnungen von Prüfungselement zu Studiengang';

comment on column lm_unit_studies.course_of_study_lid is 'Studiengang';

comment on column lm_unit_studies.root_elementtype_hiskey is 'hiskey des Wurzelelementes, zu der die Unit gehört';


select now(), 'Erzeuge Index lm_unit_studies1';

create  index lm_unit_studies1 on lm_unit_studies (course_of_study_lid );


select now(), 'Erzeuge Index lm_unit_studies2';

create  index lm_unit_studies2 on lm_unit_studies (sourcesystem );


select now(), 'Erzeuge Index lm_unit_studies3';

create  index lm_unit_studies3 on lm_unit_studies (unit_id );

</#if>
delete from db_tabellen where name='lm_unit_studies';
insert into db_tabellen (name,protokollierung) values('lm_unit_studies',0);

<#if !deleted_tables?seq_contains("lm_unitrelation") && tables?is_sequence && tables?seq_contains("lm_unitrelation") >


select now(), 'table lm_unitrelation exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_unitrelation';

create table lm_unitrelation(
	id INTEGER , 
sourcesystem INTEGER , 
parent_unit_id INTEGER , 
child_unit_id INTEGER , 
unitrelationtype CHAR(255) , 
recommended_semester FLOAT , 
bonus FLOAT , 
malus FLOAT , 
generation_weight FLOAT , 
type_of_grading INTEGER , 
sortorder INTEGER , 
compulsory CHAR(255) , 
alternative_recommended_semester VARCHAR(255) 
) 
;




select now(), 'Erzeuge Index lm_unitrelation1';

create  index lm_unitrelation1 on lm_unitrelation (id );

</#if>
delete from db_tabellen where name='lm_unitrelation';
insert into db_tabellen (name,protokollierung) values('lm_unitrelation',0);

<#if !deleted_tables?seq_contains("lm_unitrelation_neu") && tables?is_sequence && tables?seq_contains("lm_unitrelation_neu") >


select now(), 'table lm_unitrelation_neu exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_unitrelation_neu';

create table lm_unitrelation_neu(
	id INTEGER , 
sourcesystem INTEGER , 
parent_unit_id INTEGER , 
child_unit_id INTEGER , 
unitrelationtype CHAR(255) , 
recommended_semester FLOAT , 
bonus FLOAT , 
malus FLOAT , 
generation_weight FLOAT , 
type_of_grading INTEGER , 
sortorder INTEGER , 
compulsory CHAR(255) , 
alternative_recommended_semester VARCHAR(255) 
) 
;



</#if>
delete from db_tabellen where name='lm_unitrelation_neu';
insert into db_tabellen (name,protokollierung) values('lm_unitrelation_neu',0);

<#if !deleted_tables?seq_contains("lm_examination") && tables?is_sequence && tables?seq_contains("lm_examination") >


select now(), 'table lm_examination exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_examination';

create table lm_examination(
	id INTEGER , 
sourcesystem INTEGER , 
unit_id INTEGER , 
source_event_unit_id INTEGER , 
pform CHAR(10) , 
part CHAR(10) , 
exam_written INTEGER 
) 
;



comment on column lm_examination.unit_id is 'Prüfungselement';

comment on column lm_examination.source_event_unit_id is 'Zuordnung auf die gekoppelte Veranstaltungs-Unit';

comment on column lm_examination.exam_written is 'Empfohlenes Fachsemester';

</#if>
delete from db_tabellen where name='lm_examination';
insert into db_tabellen (name,protokollierung) values('lm_examination',0);

<#if !deleted_tables?seq_contains("lm_examination_neu") && tables?is_sequence && tables?seq_contains("lm_examination_neu") >


select now(), 'table lm_examination_neu exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_examination_neu';

create table lm_examination_neu(
	id INTEGER , 
sourcesystem INTEGER , 
unit_id INTEGER , 
source_event_unit_id INTEGER , 
pform VARCHAR(255) , 
part VARCHAR(255) , 
exam_written INTEGER 
) 
;



comment on column lm_examination_neu.source_event_unit_id is 'Zuordnung auf die gekoppelte Veranstaltungs-Unit';

comment on column lm_examination_neu.exam_written is 'Empfohlenes Fachsemester';

</#if>
delete from db_tabellen where name='lm_examination_neu';
insert into db_tabellen (name,protokollierung) values('lm_examination_neu',0);

<#if !deleted_tables?seq_contains("lm_examrelation") && tables?is_sequence && tables?seq_contains("lm_examrelation") >


select now(), 'table lm_examrelation exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_examrelation';

create table lm_examrelation(
	id INTEGER , 
sourcesystem INTEGER , 
parent_examplan_id INTEGER , 
child_examplan_id INTEGER , 
unitrelationtype CHAR(10) , 
unit_id INTEGER , 
parent_unit_id INTEGER , 
parent_unit_uniquename VARCHAR(255) , 
parent_unit_elementnr VARCHAR(255) , 
bonus FLOAT , 
malus FLOAT , 
pstatus CHAR(10) , 
credits_used_for_weighting FLOAT , 
is_approved INTEGER , 
top_examplan_id INTEGER , 
top_unit_id INTEGER , 
internal_accreditationtype CHAR(10) , 
date_of_work DATE , 
sem_der_pruefung SMALLINT 
) 
;



comment on column lm_examrelation.pstatus is 'Prüfungsstatus';

comment on column lm_examrelation.internal_accreditationtype is 'Art der Anerkennung';

comment on column lm_examrelation.date_of_work is 'Datum, für das die Leistung angerechnet wird';

comment on column lm_examrelation.sem_der_pruefung is 'Semester der Prüfung';


select now(), 'Erzeuge Index lm_examrelation1';

create  index lm_examrelation1 on lm_examrelation (parent_examplan_id );


select now(), 'Erzeuge Index lm_examrelation2';

create  index lm_examrelation2 on lm_examrelation (child_examplan_id, 
sourcesystem );


select now(), 'Erzeuge Index lm_examrelation3';

create  index lm_examrelation3 on lm_examrelation (id );

</#if>
delete from db_tabellen where name='lm_examrelation';
insert into db_tabellen (name,protokollierung) values('lm_examrelation',0);

<#if !deleted_tables?seq_contains("lm_examrelation_neu") && tables?is_sequence && tables?seq_contains("lm_examrelation_neu") >


select now(), 'table lm_examrelation_neu exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_examrelation_neu';

create table lm_examrelation_neu(
	id INTEGER , 
sourcesystem INTEGER , 
parent_examplan_id INTEGER , 
child_examplan_id INTEGER , 
unitrelationtype VARCHAR(255) , 
unit_id INTEGER , 
bonus FLOAT , 
malus FLOAT , 
pstatus VARCHAR(255) , 
credits_used_for_weighting FLOAT , 
is_approved INTEGER , 
internal_accreditationtype VARCHAR(255) , 
date_of_work DATE , 
sem_der_pruefung SMALLINT 
) 
;



comment on column lm_examrelation_neu.pstatus is 'Prüfungsstatus';

comment on column lm_examrelation_neu.internal_accreditationtype is 'Art der Anerkennung';

comment on column lm_examrelation_neu.date_of_work is 'Datum, für das die Leistung angerechnet wird';

comment on column lm_examrelation_neu.sem_der_pruefung is 'Semester der Prüfung';


select now(), 'Erzeuge Index lm_examrelation_n_1';

create  index lm_examrelation_n_1 on lm_examrelation_neu (bonus );


select now(), 'Erzeuge Index lm_examrelation_n_2';

create  index lm_examrelation_n_2 on lm_examrelation_neu (child_examplan_id );


select now(), 'Erzeuge Index lm_examrelation_n_3';

create  index lm_examrelation_n_3 on lm_examrelation_neu (parent_examplan_id );

</#if>
delete from db_tabellen where name='lm_examrelation_neu';
insert into db_tabellen (name,protokollierung) values('lm_examrelation_neu',0);

<#if !deleted_tables?seq_contains("lm_cifx_neu") && tables?is_sequence && tables?seq_contains("lm_cifx_neu") >


select now(), 'table lm_cifx_neu exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_cifx_neu';

create table lm_cifx_neu(
	key SMALLINT , 
hs INTEGER , 
apnr VARCHAR(255) , 
kurz CHAR(10) , 
druck VARCHAR(200) , 
lang_1 CHAR(255) , 
astat CHAR(10) , 
parent CHAR(10) , 
uniquename CHAR(255) , 
bund_apnr CHAR(10) , 
sprache CHAR(3) , 
d_akt_von DATE , 
d_akt_bis DATE , 
sourcesystem_id VARCHAR(255) , 
hiskey_id VARCHAR(255) , 
struktur_c CHAR(50) , 
lid VARCHAR(255) , 
parent_lid VARCHAR(255) , 
sortorder INTEGER 
) 
;



comment on table lm_cifx_neu is 'Ladetabelle für neue Schlüssel';

comment on column lm_cifx_neu.lid is 'Langlebige ID';

comment on column lm_cifx_neu.parent_lid is 'Übergeordnete langlebige ID';

</#if>
delete from db_tabellen where name='lm_cifx_neu';
insert into db_tabellen (name,protokollierung) values('lm_cifx_neu',0);

<#if !deleted_tables?seq_contains("lm_pruefrout") && tables?is_sequence && tables?seq_contains("lm_pruefrout") >


select now(), 'table lm_pruefrout exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_pruefrout';

create table lm_pruefrout(
	tid SERIAL , 
datum DATE , 
semester INTEGER , 
tabelle CHAR(255) , 
tabelle_quelle CHAR(255) , 
matrikel_nr INTEGER , 
tid_stg INTEGER , 
problem CHAR(255) , 
aktion CHAR(255) 
) 
;



comment on table lm_pruefrout is 'Log-Tabelle für Prüfroutinen';

</#if>
delete from db_tabellen where name='lm_pruefrout';
insert into db_tabellen (name,protokollierung) values('lm_pruefrout',0);

<#if !deleted_tables?seq_contains("lm_ects_soll_neu") && tables?is_sequence && tables?seq_contains("lm_ects_soll_neu") >


select now(), 'table lm_ects_soll_neu exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_ects_soll_neu';

create table lm_ects_soll_neu(
	po_uniquename VARCHAR(255) , 
studiengang_name VARCHAR(255) , 
abschluss CHAR(10) , 
stg CHAR(10) , 
vertiefung CHAR(10) , 
schwerpunkt CHAR(10) , 
kz_fach CHAR(10) , 
pversion VARCHAR(255) , 
stort CHAR(10) , 
stuart CHAR(10) , 
stutyp CHAR(10) , 
stufrm CHAR(10) , 
fach_sem_zahl INTEGER , 
ects_soll double precision , 
semester_von INTEGER , 
semester_bis INTEGER 
) 
;



</#if>
delete from db_tabellen where name='lm_ects_soll_neu';
insert into db_tabellen (name,protokollierung) values('lm_ects_soll_neu',0);

<#if !deleted_tables?seq_contains("lm_ects_soll") && tables?is_sequence && tables?seq_contains("lm_ects_soll") >


select now(), 'table lm_ects_soll exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_ects_soll';

create table lm_ects_soll(
	po_uniquename VARCHAR(255) , 
studiengang_name VARCHAR(255) , 
abschluss CHAR(10) , 
stg CHAR(10) , 
vertiefung CHAR(10) , 
schwerpunkt CHAR(10) , 
kz_fach CHAR(10) , 
pversion VARCHAR(255) , 
stort CHAR(10) , 
stuart CHAR(10) , 
stutyp CHAR(10) , 
stufrm CHAR(10) , 
fach_sem_zahl INTEGER , 
ects_soll double precision , 
semester_von INTEGER , 
semester_bis INTEGER 
) 
;



</#if>
delete from db_tabellen where name='lm_ects_soll';
insert into db_tabellen (name,protokollierung) values('lm_ects_soll',0);

<#if !deleted_tables?seq_contains("lm_examplan_neu") && tables?is_sequence && tables?seq_contains("lm_examplan_neu") >


select now(), 'table lm_examplan_neu exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_examplan_neu';

create table lm_examplan_neu(
	matrikel_nr INTEGER , 
id INTEGER  not null, 
sourcesystem INTEGER , 
unit_id INTEGER , 
person_id INTEGER , 
planelement_id INTEGER , 
prueck SMALLINT , 
d_abg_pruefung DATE , 
psws FLOAT , 
pform VARCHAR(255) , 
sem_der_pruefung SMALLINT  not null, 
zeitabschnitt CHAR(10) , 
k_grade_assessment_status VARCHAR(255) , 
pvermerk VARCHAR(255) , 
default_examrelation_id INTEGER , 
cancelation_impossible INTEGER , 
additional_work INTEGER , 
pnote FLOAT , 
score FLOAT , 
panerk CHAR(10) , 
pversuch INTEGER , 
free_trial INTEGER 
) 
;



comment on table lm_examplan_neu is 'Leistungen';

comment on column lm_examplan_neu.matrikel_nr is 'Matrikel-Nr.';

comment on column lm_examplan_neu.id is 'ID';

comment on column lm_examplan_neu.sourcesystem is 'Quellsystem';

comment on column lm_examplan_neu.unit_id is 'Prüfungselement';

comment on column lm_examplan_neu.person_id is 'Person';

comment on column lm_examplan_neu.planelement_id is 'Planelement';

comment on column lm_examplan_neu.prueck is 'Zurückgetreten';

comment on column lm_examplan_neu.d_abg_pruefung is 'Datum der Prüfung';

comment on column lm_examplan_neu.psws is 'Semesterwochenstunden';

comment on column lm_examplan_neu.pform is 'Form der Prüfung';

comment on column lm_examplan_neu.sem_der_pruefung is 'Semester der Prüfung';

comment on column lm_examplan_neu.zeitabschnitt is 'Zeitabschnitt';

comment on column lm_examplan_neu.k_grade_assessment_status is 'Notenstatus';

comment on column lm_examplan_neu.pvermerk is 'Vermerk zur Prüfung';

comment on column lm_examplan_neu.default_examrelation_id is 'Leistungsnr. im Baum';

comment on column lm_examplan_neu.cancelation_impossible is 'Abmeldung durch Studenten möglich';

comment on column lm_examplan_neu.additional_work is 'freiwillige Zusatzleistung';

comment on column lm_examplan_neu.pnote is 'Prüfungsnote';

comment on column lm_examplan_neu.score is 'Erreichte Punkte der Leistung';

comment on column lm_examplan_neu.panerk is 'Anerkannte Prüfung';

comment on column lm_examplan_neu.pversuch is 'Versuchszahl';

comment on column lm_examplan_neu.free_trial is 'Freiversuch';

</#if>
delete from db_tabellen where name='lm_examplan_neu';
insert into db_tabellen (name,protokollierung) values('lm_examplan_neu',0);

<#if !deleted_tables?seq_contains("lm_examplan") && tables?is_sequence && tables?seq_contains("lm_examplan") >


select now(), 'table lm_examplan exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_examplan';

create table lm_examplan(
	matrikel_nr INTEGER  not null, 
id INTEGER , 
sourcesystem INTEGER , 
unit_id INTEGER , 
person_id INTEGER , 
planelement_id INTEGER , 
prueck SMALLINT , 
d_abg_pruefung DATE , 
psws FLOAT , 
pform CHAR(10) , 
sem_der_pruefung SMALLINT  not null, 
zeitabschnitt CHAR(10) , 
k_grade_assessment_status VARCHAR(255) , 
pvermerk CHAR(10) , 
default_examrelation_id INTEGER , 
cancelation_impossible INTEGER , 
additional_work INTEGER , 
pnote FLOAT , 
score FLOAT , 
panerk CHAR(10) , 
malus FLOAT , 
bonus FLOAT , 
pstatus CHAR(10) , 
pversuch INTEGER , 
free_trial INTEGER 
) 
;



comment on table lm_examplan is 'Leistungen';

comment on column lm_examplan.matrikel_nr is 'Matrikel-Nr.';

comment on column lm_examplan.id is 'ID';

comment on column lm_examplan.sourcesystem is 'Quellsystem';

comment on column lm_examplan.unit_id is 'Prüfungselement';

comment on column lm_examplan.person_id is 'Person';

comment on column lm_examplan.planelement_id is 'Planelement';

comment on column lm_examplan.prueck is 'Zurückgetreten';

comment on column lm_examplan.d_abg_pruefung is 'Datum der Prüfung';

comment on column lm_examplan.psws is 'Semesterwochenstunden';

comment on column lm_examplan.pform is 'Form der Prüfung';

comment on column lm_examplan.sem_der_pruefung is 'Semester der Prüfung';

comment on column lm_examplan.zeitabschnitt is 'Zeitabschnitt';

comment on column lm_examplan.k_grade_assessment_status is 'Notenstatus';

comment on column lm_examplan.pvermerk is 'Vermerk zur Prüfung';

comment on column lm_examplan.default_examrelation_id is 'Leistungsnr. im Baum';

comment on column lm_examplan.cancelation_impossible is 'Abmeldung durch Studenten möglich';

comment on column lm_examplan.additional_work is 'freiwillige Zusatzleistung';

comment on column lm_examplan.pnote is 'Prüfungsnote';

comment on column lm_examplan.score is 'Erreichte Punkte der Leistung';

comment on column lm_examplan.panerk is 'Anerkannte Prüfung';

comment on column lm_examplan.malus is 'Maluspunkte dieser Prüfung';

comment on column lm_examplan.bonus is 'Guthaben-/Bonuspunkte dieser Prüfung';

comment on column lm_examplan.pstatus is 'Prüfungsstatus';

comment on column lm_examplan.pversuch is 'Versuchszahl';

comment on column lm_examplan.free_trial is 'Freiversuch';


select now(), 'Erzeuge Index ix_lm_examplan1';

create  index ix_lm_examplan1 on lm_examplan (id, 
sourcesystem );


select now(), 'Erzeuge Index ix_lm_examplan2';

create  index ix_lm_examplan2 on lm_examplan (matrikel_nr );


select now(), 'Erzeuge Index ix_lm_examplan3';

create  index ix_lm_examplan3 on lm_examplan (default_examrelation_id );


select now(), 'Erzeuge Index ix_lm_examplan4';

create  index ix_lm_examplan4 on lm_examplan (unit_id );

</#if>
delete from db_tabellen where name='lm_examplan';
insert into db_tabellen (name,protokollierung) values('lm_examplan',0);

<#if !deleted_tables?seq_contains("lm_course_of_study_neu") && tables?is_sequence && tables?seq_contains("lm_course_of_study_neu") >


select now(), 'table lm_course_of_study_neu exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_course_of_study_neu';

create table lm_course_of_study_neu(
	id INTEGER  not null, 
lid INTEGER  not null, 
sourcesystem INTEGER , 
uniquename VARCHAR(255) , 
ktxt VARCHAR(255) , 
dtxt VARCHAR(255) , 
ltxt VARCHAR(255) , 
pversion INTEGER , 
fb VARCHAR(255) , 
stutyp VARCHAR(255) , 
kzfa VARCHAR(255) , 
stort VARCHAR(255) , 
lehreinh VARCHAR(255) , 
abschluss VARCHAR(255) , 
stg VARCHAR(255) , 
vert VARCHAR(255) , 
schwp VARCHAR(255) , 
stuart VARCHAR(255) , 
stufrm VARCHAR(255) , 
regelstz decimal(4,2) , 
sem_gueltigbis SMALLINT , 
part_of_studies INTEGER , 
valid_from DATE , 
valid_to DATE 
) 
;



comment on table lm_course_of_study_neu is 'Studiengangkombinationen aus SOS (Ladetabelle)';

comment on column lm_course_of_study_neu.part_of_studies is 'ECTS-Gewicht des Fachs';

comment on column lm_course_of_study_neu.valid_from is 'Gültig von';

comment on column lm_course_of_study_neu.valid_to is 'Gültig bis';

</#if>
delete from db_tabellen where name='lm_course_of_study_neu';
insert into db_tabellen (name,protokollierung) values('lm_course_of_study_neu',0);

<#if !deleted_tables?seq_contains("lm_course_of_study") && tables?is_sequence && tables?seq_contains("lm_course_of_study") >


select now(), 'table lm_course_of_study exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_course_of_study';

create table lm_course_of_study(
	id INTEGER  not null, 
lid INTEGER  not null, 
sourcesystem INTEGER , 
uniquename VARCHAR(255) , 
ktxt VARCHAR(255) , 
dtxt VARCHAR(255) , 
ltxt VARCHAR(255) , 
pversion INTEGER , 
fb CHAR(10) , 
stutyp CHAR(10) , 
kzfa CHAR(10) , 
stort CHAR(10) , 
lehreinh CHAR(10) , 
abschluss CHAR(10) , 
stg CHAR(10) , 
vert CHAR(10) , 
schwp CHAR(10) , 
stuart CHAR(10) , 
stufrm CHAR(10) , 
regelstz decimal(4,2) , 
sem_gueltigbis SMALLINT , 
part_of_studies INTEGER , 
tid_stg INTEGER , 
valid_from DATE , 
valid_to DATE 
) 
;



comment on table lm_course_of_study is 'Studiengangkombinationen aus SOS (Ladetabelle)';

comment on column lm_course_of_study.part_of_studies is 'ECTS-Gewicht des Fachs';

comment on column lm_course_of_study.valid_from is 'Gültig von';

comment on column lm_course_of_study.valid_to is 'Gültig bis';


select now(), 'Erzeuge Index lm_course_of_study1';

create  index lm_course_of_study1 on lm_course_of_study (lid );


select now(), 'Erzeuge Index lm_course_of_study2';

create  index lm_course_of_study2 on lm_course_of_study (sem_gueltigbis );


select now(), 'Erzeuge Index lm_course_of_study3';

create  index lm_course_of_study3 on lm_course_of_study (stg, 
abschluss, 
pversion, 
kzfa, 
schwp, 
vert, 
stort, 
stutyp );


select now(), 'Erzeuge Index lm_course_of_study6';

create  index lm_course_of_study6 on lm_course_of_study (stufrm );

</#if>
delete from db_tabellen where name='lm_course_of_study';
insert into db_tabellen (name,protokollierung) values('lm_course_of_study',0);

<#if !deleted_tables?seq_contains("lm_stud_d_neu") && tables?is_sequence && tables?seq_contains("lm_stud_d_neu") >


select now(), 'table lm_stud_d_neu exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_stud_d_neu';

create table lm_stud_d_neu(
	matrikel_nr INTEGER , 
namenszusatz VARCHAR(255) , 
nachname VARCHAR(255) , 
namenssuffix VARCHAR(255) , 
vorname VARCHAR(255) , 
email VARCHAR(255) , 
personattribute_lm_email VARCHAR(255) 
) 
;



comment on table lm_stud_d_neu is 'Email Adressen';

comment on column lm_stud_d_neu.matrikel_nr is 'Matrikel-Nr.';

</#if>
delete from db_tabellen where name='lm_stud_d_neu';
insert into db_tabellen (name,protokollierung) values('lm_stud_d_neu',0);

<#if !deleted_tables?seq_contains("lm_stud_d") && tables?is_sequence && tables?seq_contains("lm_stud_d") >


select now(), 'table lm_stud_d exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_stud_d';

create table lm_stud_d(
	matrikel_nr INTEGER , 
namenszusatz VARCHAR(255) , 
nachname VARCHAR(255) , 
namenssuffix VARCHAR(255) , 
vorname VARCHAR(255) , 
email VARCHAR(255) , 
anschreib_datum DATE , 
personattribute_lm_email VARCHAR(255) 
) 
;



comment on table lm_stud_d is 'Email Adressen';

comment on column lm_stud_d.matrikel_nr is 'Matrikel-Nr.';


select now(), 'Erzeuge Index ix_lm_stud_d';

create  index ix_lm_stud_d on lm_stud_d (matrikel_nr );

</#if>
delete from db_tabellen where name='lm_stud_d';
insert into db_tabellen (name,protokollierung) values('lm_stud_d',0);

<#if !deleted_tables?seq_contains("lm_accreditation_neu") && tables?is_sequence && tables?seq_contains("lm_accreditation_neu") >


select now(), 'table lm_accreditation_neu exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_accreditation_neu';

create table lm_accreditation_neu(
	id INTEGER  not null, 
examplan_id INTEGER , 
accreditation_person VARCHAR(255) , 
accreditation_date DATE , 
k_accreditationtype_id VARCHAR(255) , 
sourcesystem INTEGER , 
origin_examplan_id INTEGER 
) 
;



comment on table lm_accreditation_neu is 'Anerk. Leistungen';

comment on column lm_accreditation_neu.id is 'ID';

comment on column lm_accreditation_neu.examplan_id is 'ID der anerkannten Leistung';

comment on column lm_accreditation_neu.accreditation_person is 'Person der Anerkennung';

comment on column lm_accreditation_neu.accreditation_date is 'Datum der Anerkennung';

comment on column lm_accreditation_neu.k_accreditationtype_id is 'ID der Anerkennungsart';

comment on column lm_accreditation_neu.sourcesystem is 'Quellsystem';

comment on column lm_accreditation_neu.origin_examplan_id is 'ID der ursprünglichen Leistung';

</#if>
delete from db_tabellen where name='lm_accreditation_neu';
insert into db_tabellen (name,protokollierung) values('lm_accreditation_neu',0);

<#if !deleted_tables?seq_contains("lm_accreditation") && tables?is_sequence && tables?seq_contains("lm_accreditation") >


select now(), 'table lm_accreditation exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_accreditation';

create table lm_accreditation(
	id INTEGER  not null, 
examplan_id INTEGER , 
accreditation_person VARCHAR(255) , 
accreditation_date DATE , 
accreditationtype CHAR(10) , 
sourcesystem INTEGER , 
origin_examplan_id INTEGER 
) 
;



comment on table lm_accreditation is 'Anerk. Leistungen';

comment on column lm_accreditation.id is 'ID';

comment on column lm_accreditation.examplan_id is 'ID der anerkannten Leistung';

comment on column lm_accreditation.accreditation_person is 'Person der Anerkennung';

comment on column lm_accreditation.accreditation_date is 'Datum der Anerkennung';

comment on column lm_accreditation.accreditationtype is 'Anerkennungsart';

comment on column lm_accreditation.sourcesystem is 'Quellsystem';

comment on column lm_accreditation.origin_examplan_id is 'ID der ursprünglichen Leistung';

</#if>
delete from db_tabellen where name='lm_accreditation';
insert into db_tabellen (name,protokollierung) values('lm_accreditation',0);

<#if !deleted_tables?seq_contains("lm_filter") && tables?is_sequence && tables?seq_contains("lm_filter") >


select now(), 'table lm_filter exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_filter';

create table lm_filter(
	tid SERIAL  not null, 
caption CHAR(200) , 
student_filter TEXT , 
unit_filter TEXT , 
exam_filter TEXT , 
aggregation_formula VARCHAR(255) , 
split_degree_programmes SMALLINT , 
comment TEXT , 
uniquename VARCHAR(255) , 
filter_type CHAR(200) , 
sortnr INTEGER , 
geaendert_am DATE , 
aktiv SMALLINT , 
	constraint pk_lm_filter primary key (tid)

) 
;



comment on table lm_filter is 'Eine Sammlung hochschulspezifischer Filter für LM';

comment on column lm_filter.caption is 'Beschriftung (kurz)';

comment on column lm_filter.student_filter is 'Filter Studiengangs-Satz';

comment on column lm_filter.unit_filter is 'Filter Unit-Satz';

comment on column lm_filter.exam_filter is 'Filter Leistungs-Satz';

comment on column lm_filter.aggregation_formula is 'Formel des Filters für Gewichtungen';

comment on column lm_filter.split_degree_programmes is 'Anteil auf jew. Teilstudiengänge umlegen?';

comment on column lm_filter.comment is 'Kommentar/Anleitung';

comment on column lm_filter.uniquename is 'Kürzel des Filters';

comment on column lm_filter.filter_type is 'Art des Filters';

comment on column lm_filter.sortnr is 'Sortierschlüssel';

comment on column lm_filter.geaendert_am is 'Datum letzte Änderung';

comment on column lm_filter.aktiv is 'Aktiv';

</#if>
delete from db_tabellen where name='lm_filter';
insert into db_tabellen (name,protokollierung) values('lm_filter',0);

<#if !deleted_tables?seq_contains("lm_unit_top") && tables?is_sequence && tables?seq_contains("lm_unit_top") >


select now(), 'table lm_unit_top exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_unit_top';

create table lm_unit_top(
	tid INTEGER  not null, 
unit_id INTEGER , 
top_unit_id INTEGER , 
sourcesystem INTEGER 
) 
;



comment on table lm_unit_top is 'Top-Knoten der POen für LM und deren Zuordnung zu Units';

comment on column lm_unit_top.tid is 'ID';

comment on column lm_unit_top.unit_id is 'Untergeordnete Unit';

comment on column lm_unit_top.top_unit_id is 'Übergeordnete Unit';

comment on column lm_unit_top.sourcesystem is 'Quellsystem';


select now(), 'Erzeuge Index lm_unit_top1';

create  index lm_unit_top1 on lm_unit_top (unit_id );


select now(), 'Erzeuge Index lm_unit_top2';

create  index lm_unit_top2 on lm_unit_top (top_unit_id );

</#if>
delete from db_tabellen where name='lm_unit_top';
insert into db_tabellen (name,protokollierung) values('lm_unit_top',0);

<#if !deleted_tables?seq_contains("lm_unit_top_neu") && tables?is_sequence && tables?seq_contains("lm_unit_top_neu") >


select now(), 'table lm_unit_top_neu exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_unit_top_neu';

create table lm_unit_top_neu(
	tid INTEGER  not null, 
unit_id INTEGER , 
top_unit_id INTEGER , 
sourcesystem INTEGER 
) 
;



comment on table lm_unit_top_neu is 'Top-Knoten der POen für LM und deren Zuordnung zu Units';

comment on column lm_unit_top_neu.tid is 'ID';

comment on column lm_unit_top_neu.unit_id is 'Untergeordnete Unit';

comment on column lm_unit_top_neu.top_unit_id is 'Übergeordnete Unit';

comment on column lm_unit_top_neu.sourcesystem is 'Quellsystem';

</#if>
delete from db_tabellen where name='lm_unit_top_neu';
insert into db_tabellen (name,protokollierung) values('lm_unit_top_neu',0);

<#if !deleted_tables?seq_contains("lm_exam_instructor_neu") && tables?is_sequence && tables?seq_contains("lm_exam_instructor_neu") >


select now(), 'table lm_exam_instructor_neu exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_exam_instructor_neu';

create table lm_exam_instructor_neu(
	examplan_id INTEGER , 
sourcesystem INTEGER , 
ordnr INTEGER , 
lastname VARCHAR(255) , 
firstname VARCHAR(255) , 
ordnr2 INTEGER 
) 
;



comment on table lm_exam_instructor_neu is 'Prüfernamen';

comment on column lm_exam_instructor_neu.examplan_id is 'ID der Leistung';

comment on column lm_exam_instructor_neu.sourcesystem is 'Quellsystem';

comment on column lm_exam_instructor_neu.ordnr is 'Ordnungsnummer';

comment on column lm_exam_instructor_neu.lastname is 'Nachname';

comment on column lm_exam_instructor_neu.firstname is 'Vorname';

comment on column lm_exam_instructor_neu.ordnr2 is 'Ordnungsnummer';

</#if>
delete from db_tabellen where name='lm_exam_instructor_neu';
insert into db_tabellen (name,protokollierung) values('lm_exam_instructor_neu',0);

<#if !deleted_tables?seq_contains("lm_exam_instructor") && tables?is_sequence && tables?seq_contains("lm_exam_instructor") >


select now(), 'table lm_exam_instructor exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_exam_instructor';

create table lm_exam_instructor(
	examplan_id INTEGER , 
sourcesystem INTEGER , 
ordnr INTEGER , 
lastname VARCHAR(255) , 
firstname VARCHAR(255) , 
ordnr2 INTEGER 
) 
;



comment on table lm_exam_instructor is 'Prüfernamen';

comment on column lm_exam_instructor.examplan_id is 'ID der Leistung';

comment on column lm_exam_instructor.sourcesystem is 'Quellsystem';

comment on column lm_exam_instructor.ordnr is 'Ordnungsnummer';

comment on column lm_exam_instructor.lastname is 'Nachname';

comment on column lm_exam_instructor.firstname is 'Vorname';

comment on column lm_exam_instructor.ordnr2 is 'Ordnungsnummer';

</#if>
delete from db_tabellen where name='lm_exam_instructor';
insert into db_tabellen (name,protokollierung) values('lm_exam_instructor',0);

<#if !deleted_tables?seq_contains("lm_exam_written") && tables?is_sequence && tables?seq_contains("lm_exam_written") >


select now(), 'table lm_exam_written exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_exam_written';

create table lm_exam_written(
	id INTEGER , 
examplan_id INTEGER , 
date_of_application DATE , 
startdate DATE , 
planned_end DATE , 
real_end DATE , 
title VARCHAR(255) , 
commentary VARCHAR(255) , 
sourcesystem INTEGER 
) 
;



comment on table lm_exam_written is 'Schriftliche_Arbeiten';

comment on column lm_exam_written.id is 'ID';

comment on column lm_exam_written.examplan_id is 'ID der Leistung';

comment on column lm_exam_written.date_of_application is 'Antragsdatum';

comment on column lm_exam_written.startdate is 'Startdatum';

comment on column lm_exam_written.planned_end is 'Geplante Abgabe';

comment on column lm_exam_written.real_end is 'Abgabe';

comment on column lm_exam_written.title is 'Titel';

comment on column lm_exam_written.commentary is 'Kommentar';

comment on column lm_exam_written.sourcesystem is 'Quellsystem';

</#if>
delete from db_tabellen where name='lm_exam_written';
insert into db_tabellen (name,protokollierung) values('lm_exam_written',0);

<#if !deleted_tables?seq_contains("lm_additional_examtext") && tables?is_sequence && tables?seq_contains("lm_additional_examtext") >


select now(), 'table lm_additional_examtext exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_additional_examtext';

create table lm_additional_examtext(
	id INTEGER , 
examplan_id INTEGER , 
k_additional_examtext_type_id INTEGER , 
additional_text TEXT , 
k_language_id INTEGER , 
sourcesystem INTEGER 
) 
;



comment on table lm_additional_examtext is 'Zusatztext_von_Prüfungen';

comment on column lm_additional_examtext.id is 'ID';

comment on column lm_additional_examtext.examplan_id is 'ID der Leistung';

comment on column lm_additional_examtext.k_additional_examtext_type_id is 'ID des Typs des Zusatztextes';

comment on column lm_additional_examtext.additional_text is 'Zusatztext';

comment on column lm_additional_examtext.k_language_id is 'ID Sprache';

comment on column lm_additional_examtext.sourcesystem is 'Quellsystem';

</#if>
delete from db_tabellen where name='lm_additional_examtext';
insert into db_tabellen (name,protokollierung) values('lm_additional_examtext',0);

<#if !deleted_tables?seq_contains("lm_ects_soll_ist") && tables?is_sequence && tables?seq_contains("lm_ects_soll_ist") >


select now(), 'table lm_ects_soll_ist exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_ects_soll_ist';

create table lm_ects_soll_ist(
	endsemester INTEGER , 
matrikel_nr INTEGER , 
pseudonym VARCHAR(255) , 
ca12_staat INTEGER , 
geschlecht INTEGER , 
hzbart INTEGER , 
hrst CHAR(10) , 
aktiv INTEGER , 
tid_stg INTEGER , 
stufrm CHAR(10) , 
lehr_eigen CHAR(10) , 
lehr_dienst CHAR(10) , 
cnw_summe double precision , 
ca_wert double precision , 
fach_sem_zahl_max_student INTEGER , 
sem_rueck_beur_ein_max_student INTEGER , 
ects_soll double precision , 
ects_ist double precision , 
ects_soll_gew double precision , 
ects_ist_gew double precision 
) 
;




select now(), 'Erzeuge Index ix_lm_ects_soll_ist1';

create  index ix_lm_ects_soll_ist1 on lm_ects_soll_ist (matrikel_nr );


select now(), 'Erzeuge Index ix_lm_ects_soll_ist2';

create  index ix_lm_ects_soll_ist2 on lm_ects_soll_ist (tid_stg );


select now(), 'Erzeuge Index ix_lm_ects_soll_ist3';

create  index ix_lm_ects_soll_ist3 on lm_ects_soll_ist (endsemester );


select now(), 'Erzeuge Index ix_lm_ects_soll_ist4';

create  index ix_lm_ects_soll_ist4 on lm_ects_soll_ist (lehr_eigen );


select now(), 'Erzeuge Index ix_lm_ects_soll_ist5';

create  index ix_lm_ects_soll_ist5 on lm_ects_soll_ist (lehr_dienst );

</#if>
delete from db_tabellen where name='lm_ects_soll_ist';
insert into db_tabellen (name,protokollierung) values('lm_ects_soll_ist',0);

<#if !deleted_tables?seq_contains("lm_unit_fg") && tables?is_sequence && tables?seq_contains("lm_unit_fg") >


select now(), 'table lm_unit_fg exists - fine';


<#else>


select now(), 'Erzeuge Tabelle lm_unit_fg';

create table lm_unit_fg(
	unit_uniquename VARCHAR(255) , 
bund_fachgebiet CHAR(10) , 
stg INTEGER  default 255 , 
pktxt VARCHAR(255) , 
pversion SMALLINT 
) 
;



comment on table lm_unit_fg is 'Zuordnung Fachgebietsschlüssel';

comment on column lm_unit_fg.unit_uniquename is 'Uniquename der Unit';

comment on column lm_unit_fg.bund_fachgebiet is 'Schlüssel des Fachgebietes';

comment on column lm_unit_fg.stg is 'Fach';

comment on column lm_unit_fg.pktxt is 'Prüfungskurztext';

comment on column lm_unit_fg.pversion is 'Prüfungsordnungsversion';

</#if>
delete from db_tabellen where name='lm_unit_fg';
insert into db_tabellen (name,protokollierung) values('lm_unit_fg',0);
 -- update primary keys, see ticket: #296420 
alter table if exists lm_konto_pro_fs drop constraint if exists lm_konto_pro_fs_pkey;
alter table if exists lm_konto_pro_fs drop constraint if exists lm_konto_pro_fs_tid;
alter table if exists lm_cp_pro_fs drop constraint if exists lm_cp_pro_fs_pkey;
alter table if exists lm_cp_pro_fs drop constraint if exists lm_cp_pro_fs_tid;
alter table if exists lm_filter drop constraint if exists lm_filter_pkey;
alter table if exists lm_filter drop constraint if exists pk_lm_filter;
alter table if exists lm_konto_pro_fs add constraint lm_konto_pro_fs_pkey  primary key (tid);
alter table if exists lm_cp_pro_fs add constraint lm_cp_pro_fs_pkey  primary key (tid);
alter table if exists lm_filter add constraint lm_filter_pkey  primary key (tid);
