--(c) 2011 Andre Knieschewski
--Freemarker Template


-- !!!!!!!!!!!!
-- !!Hinweise!!
-- !!!!!!!!!!!!
-- - Achtung: Macro fügt Inhalte ein
-- - Bitte nur Freemarker Variablen füllen
-- - uniquename nicht ändern
-- - bei Änderungen/Aktualisierungen in den Variablen werden die Stylesheets geupdatet 
-- 		 das gilt nicht für den uniquename, dieser ist Primärschlüssel, nicht ändern

<#assign masken = [
{"mask":"39000", "uniquename":"tabelle_html_datenblatt.xsl-text/html", "ord":"1"},
{"mask":"41000", "uniquename":"tabelle_html_datenblatt.xsl-text/html", "ord":"1"},
{"mask":"41060", "uniquename":"tabelle_html.xsl-text/html", "ord":"1"},
{"mask":"41060", "uniquename":"tabelle_41060_ects_erfolgsquote_le.jrxml-application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "ord":"10"},
{"mask":"41100", "uniquename":"tabelle_html_datenblatt.xsl-text/html", "ord":"10"},
{"mask":"41100", "uniquename":"tabelle_41100_stud_fs.jrxml-application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "ord":"20"},
{"mask":"41100", "uniquename":"tabelle_41100_stud_sem_xmlsource.jrxml-application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "ord":"30"},
{"mask":"41130", "uniquename":"tabelle_html_datenblatt.xsl-text/html", "ord":"10"},
{"mask":"41130", "uniquename":"tabelle_41130_pruefungsteilnahme.jrxml-application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "ord":"20"},
{"mask":"41130", "uniquename":"tabelle_41130_pruefungserfolg.jrxml-application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "ord":"30"},
{"mask":"41130", "uniquename":"tabelle_41130_pruefungsteilnahme_einzel.jrxml-application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "ord":"40"},
{"mask":"41130", "uniquename":"tabelle_41130_pruefungserfolg_einzel.jrxml-application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "ord":"50"},
{"mask":"41160", "uniquename":"tabelle_html.xsl-text/html", "ord":"0"},
{"mask":"41230", "uniquename":"tabelle_html_datenblatt.xsl-text/html", "ord":"0"}
] />

<#assign stylesheet = [
{"filename":"tabelle_41060_ects_erfolgsquote_le.jrxml", "caption":"ECTS Erfolgsquote (Lehreinheit)", "description":"ECTS Erfolgsquote (Lehreinheit)", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "uniquename":"tabelle_41060_ects_erfolgsquote_le.jrxml-application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"tabelle_41100_stud_fs.jrxml", "caption":"Studierende nach Schwerpunkt (Signalprüfungen) pro Fachsemester", "description":"Studierende nach Schwerpunkt (Signalprüfungen) pro Fachsemester", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "uniquename":"tabelle_41100_stud_fs.jrxml-application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"tabelle_41100_stud_sem_xmlsource.jrxml", "caption":"Studierende nach Schwerpunkt (Signalprüfungen) Zeitreihe", "description":"Studierende nach Schwerpunkt (Signalprüfungen) Zeitreihe", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "uniquename":"tabelle_41100_stud_sem_xmlsource.jrxml-application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"tabelle_41130_pruefungsteilnahme.jrxml", "caption":"Prüfungsteilnahme (Prüfungsvergleich)", "description":"Teilnahme oder Rücktritt/mit Attest Zeitreihe", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "uniquename":"tabelle_41130_pruefungsteilnahme.jrxml-application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"tabelle_41130_pruefungserfolg.jrxml", "caption":"Prüfungserfolg (Prüfungsvergleich)", "description":"Prüfungserfolg Zeitreihe", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "uniquename":"tabelle_41130_pruefungserfolg.jrxml-application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"tabelle_41130_pruefungsteilnahme_einzel.jrxml", "caption":"Prüfungsteilnahme (Einzelansicht)", "description":"Teilnahme oder Rücktritt/mit Attest Zeitreihe  (Einzelansicht pro Prüfung)", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "uniquename":"tabelle_41130_pruefungsteilnahme_einzel.jrxml-application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"tabelle_41130_pruefungserfolg_einzel.jrxml", "caption":"Prüfungserfolg (Einzelansicht)", "description":"Prüfungserfolg Zeitreihe  (Einzelansicht pro Prüfung)", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "uniquename":"tabelle_41130_pruefungserfolg_einzel.jrxml-application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"}
] />

<#assign stylesheet_field = [

] />

--Hier eventuell notwendige updates/delete's auf die Tabellen sx_mask_style, sx_stylesheets oder stylesheet_field einfügen.

--obsolet mit 2021.12:
delete from sx_mask_style where stylesheet_id in (select S.tid from sx_stylesheets S where S.filename='tabelle_41100_stud_sem.jrxml');
delete from sx_stylesheets where filename='tabelle_41100_stud_sem.jrxml';


--Achtung: ab hier nicht ändern, Mutterdatei ist $SUPERX_DIR/db/module/sos/schluesseltabellen/sx_stylesheets_fuellen.sql

update sx_stylesheets set uniquename=filename||'-'||contenttype where uniquename is null; 

-- Zombies eliminieren
delete from sx_mask_style where stylesheet_id not in (select tid from sx_stylesheets) or stylesheet_id is null;

 <@sx_stylesheets_insert
m_masken=masken
m_stylesheet=stylesheet
m_stylesheet_field=stylesheet_field
/>


<#macro sx_stylesheets_insert m_masken m_stylesheet m_stylesheet_field>

-- hinzugefügt durch ij 17.04.2024, damit updates über Variable erfolgen
<#foreach column in m_stylesheet>
	update sx_stylesheets set caption='${column.caption}' where uniquename='${column.uniquename}';
	update sx_stylesheets set description='${column.description}' where uniquename='${column.uniquename}';
	update sx_stylesheets set relation='${column.relation}' where uniquename='${column.uniquename}';
	update sx_stylesheets set contenttype='${column.contenttype}' where uniquename='${column.uniquename}';
</#foreach>

--Sicherstellen, dass keine Duplikate vorkommen:
--####################################################################################################
<#foreach column in m_masken>
delete from sx_mask_style where maskeninfo_id=${column.mask} and stylesheet_id=(select tid from sx_stylesheets where uniquename ='${column.uniquename}') and ord=${column.ord};
</#foreach>

<#foreach column in m_stylesheet_field>
delete from stylesheet_field where tablename='${column.tablename}' and stylesheet_id=(select tid from sx_stylesheets where uniquename ='${column.uniquename}') and fieldname='${column.fieldname}';
</#foreach>

--delete sx_stylesheets raus genommen #ak 06.03.2013



-- Stylesheets füllen
--####################################################################################################
create temp table tmp_stylesheets (
tid         serial  not null, 
filename    CHAR(255) , 
caption     CHAR(255) , 
description CHAR(255) , 
relation    CHAR(10) , 
useragent   CHAR(255) , 
contenttype CHAR(200) ,
uniquename 	VARCHAR(255)
);

create temp table tmp_hilf (tid integer);
insert into tmp_hilf select max(tid) from sx_stylesheets;
update tmp_hilf set tid=1 where tid is null;

<#assign couter_tid = 1 />
<#foreach column in m_stylesheet>
insert into tmp_stylesheets (tid,filename,caption,description,relation,contenttype,uniquename)
select max(tid)+${couter_tid},'${column.filename}','${column.caption}', '${column.description}', '${column.relation}','${column.contenttype}','${column.uniquename}' from tmp_hilf;
<#assign couter_tid = couter_tid + 1 />
</#foreach>

--delete für tml_stylesheets hinzugefügt #ak 06.03.2013
delete from tmp_stylesheets where uniquename in (select uniquename from sx_stylesheets);


insert into sx_stylesheets (tid,filename, caption, description, relation, useragent, contenttype,uniquename)
SELECT tid, filename, caption, description, relation, useragent, contenttype,uniquename
FROM tmp_stylesheets;

drop table tmp_stylesheets;


-- Mask Style füllen
--####################################################################################################
create temp table tmp_mask_style (
tid serial    not null, 
maskeninfo_id INTEGER , 
stylesheet_id INTEGER , 
ord           SMALLINT,
uniquename      char(255)
);

delete from tmp_hilf;
insert into tmp_hilf select max(tid) from sx_mask_style;
update tmp_hilf set tid=1 where tid is null;

<#assign couter_tid = 1 />
<#foreach column in m_masken>
insert into tmp_mask_style (tid,maskeninfo_id,ord,uniquename)
select max(tid)+${couter_tid},${column.mask},${column.ord},'${column.uniquename}' from tmp_hilf;

update tmp_mask_style set stylesheet_id=(select max(tid) from sx_stylesheets where uniquename='${column.uniquename}')
where uniquename='${column.uniquename}';
<#assign couter_tid = couter_tid + 1 />
</#foreach>

insert into sx_mask_style ( tid, maskeninfo_id, stylesheet_id, ord)
SELECT tid, maskeninfo_id, stylesheet_id, ord
FROM tmp_mask_style;

drop table tmp_mask_style;


--Field zu Stylesheet Zuordnungen:
--####################################################################################################
CREATE temp TABLE tmp_stylesheet_field
(
tid           serial        NOT NULL,
stylesheet_id INTEGER,
tablename     char(255),
fieldname     char(255),
uniquename      char(255)
);

delete from tmp_hilf;
insert into tmp_hilf select max(tid) from stylesheet_field;
update tmp_hilf set tid=1 where tid is null;

<#assign couter_tid = 1 />
<#foreach column in m_stylesheet_field>
INSERT INTO tmp_stylesheet_field (tid, uniquename, tablename, fieldname)
select max(tid)+${couter_tid}, '${column.uniquename}', '${column.tablename}', '${column.fieldname}' from tmp_hilf;

update tmp_stylesheet_field set stylesheet_id=(select max(tid) from sx_stylesheets where uniquename='${column.uniquename}')
where uniquename='${column.uniquename}';
<#assign couter_tid = couter_tid + 1 />
</#foreach>

insert into stylesheet_field ( tid, stylesheet_id, tablename, fieldname)
SELECT tid, stylesheet_id, tablename, fieldname
FROM tmp_stylesheet_field;

drop table tmp_stylesheet_field;
drop table tmp_hilf;

<#if SQLdialect='Postgres'>
select sp_update_sequence('sx_stylesheets');
select sp_update_sequence('sx_mask_style');
select sp_update_sequence('stylesheet_field');
</#if>

</#macro>
