--freemarker template
<#if SQLdialect='Postgres'>
<#assign texttype="text" />
<#else>
EXECUTE PROCEDURE IFX_ALLOW_NEWLINE('T');
<#assign texttype="lvarchar" />
</#if>
<#assign newline="'
'" />

create temp table tmp_konstanten
  (
    tid serial,
    apnr integer,
    beschreibung char(255),
	defaultvalue integer,
	description  ${texttype},
	systeminfo_id integer,
	doku_link varchar(255),
	read_only integer,
	wertebereich varchar(250),
	ab_version varchar(10),
	gruppe varchar(255),
	sachgebiete_id integer
  );


insert into tmp_konstanten(apnr, beschreibung, defaultvalue, description, systeminfo_id, doku_link, read_only,  wertebereich, ab_version, gruppe, sachgebiete_id)
values (6,'LM_Quellsystem', 6,'Anzeige der Datenquelle für die BI-Komponente',
300, 'Modul_Leistungsmonitoring_Admin-HISinOne.xhtml#Konstanten',
1,'6 = HISinOne,  5 = SOSPOS', '8.0', 'Datenquelle, Entladestartzeitpunkt, -umfang', 300);

insert into tmp_konstanten(apnr, beschreibung, defaultvalue, description, systeminfo_id, doku_link, read_only, wertebereich, ab_version, gruppe, sachgebiete_id)
values (3,'LM_ECTS_SOLL_SRC',3, 'Datenquelle für die Soll-ECTS',
300, 'Modul_Leistungsmonitoring_Admin-HISinOne.xhtml#Konstanten',
0,'0, Unbekannt ' || ${newline} || '1, Soll-ECTS über GANG' || ${newline} || '2, Soll-ECTS über xlsx-Upload'|| ${newline} || '3, Soll-ECTS über Prüfungsordnung', '2020.12', 'Spezielle Auswertungsfilter', 300);

insert into tmp_konstanten(apnr, beschreibung, defaultvalue, description, systeminfo_id, doku_link, read_only, wertebereich, ab_version, gruppe, sachgebiete_id)
values (0,'LM_BERECHNE_HAWMODELL',0, 'Berechne Konto HAW Modell',
300, 'Modul_Leistungsmonitoring_Admin-HISinOne.xhtml#Konstanten',
0,'0, nein ' || ${newline} || '1, ja' , '2020.12', 'Spezielle Auswertungsfilter', 300);

insert into tmp_konstanten(apnr, beschreibung, defaultvalue, description, systeminfo_id, doku_link, read_only, wertebereich, ab_version, gruppe, sachgebiete_id)
values (20222,'LM_ECTS_SOLL_IST_STARTSEM',20222, 'Startsemester für den archivierten ECTS Soll-Ist-Vergleich',
300, 'Modul_Leistungsmonitoring_Admin-HISinOne.xhtml#Konstanten',
0,'<<SQL>> select tid,tid || '' ('' || trim(eintrag) ||'')'' from semester union select 19001,''19001 (Unbegrenzt)'' from xdummy order by 1 desc', '2024.06', 'Konnektorenperformance, Historisieren (Einfrieren) von Daten',
 300);

insert into tmp_konstanten(apnr, beschreibung, defaultvalue, description, systeminfo_id, doku_link, read_only, wertebereich, ab_version, gruppe, sachgebiete_id)
values (20231,'LM_ECTS_SOLL_IST_ENDSEM',20231, 'Endsemester für den archivierten ECTS Soll-Ist-Vergleich',
300, 'Modul_Leistungsmonitoring_Admin-HISinOne.xhtml#Konstanten',
0,'<<SQL>> select tid,tid || '' ('' || trim(eintrag) ||'')'' from semester union select 19001,''19001 (Unbegrenzt)'' from xdummy order by 1 desc', '2024.06', 'Konnektorenperformance, Historisieren (Einfrieren) von Daten',
 300);

--vorhandene Schlüssel Metadaten updaten:

<#if SQLdialect='Postgres'>
--Postgres Dialekt:
update konstanten set defaultvalue=T.defaultvalue,
description=T.description,
systeminfo_id=T.systeminfo_id ,
doku_link=T.doku_link,
read_only=T.read_only ,
wertebereich=T.wertebereich,
ab_version=T.ab_version,
gruppe=T.gruppe ,
sachgebiete_id=T.sachgebiete_id
from tmp_konstanten T
where T.beschreibung=konstanten.beschreibung;

<#else>

--Informix Dialekt:
update konstanten set (defaultvalue,
 description,
 systeminfo_id,
 doku_link,
 read_only,
 wertebereich,
  ab_version,
 gruppe,
 sachgebiete_id)
       = ((select
       defaultvalue,
 description,
 systeminfo_id,
 doku_link,
 read_only,
 wertebereich,
  ab_version,
 gruppe,
 sachgebiete_id
from tmp_konstanten T
where T.beschreibung=konstanten.beschreibung))
where beschreibung in (
select T.beschreibung
from tmp_konstanten T)
;


</#if>

select 'vorh. Konstanten apnrs bleiben erhalten' from xdummy;

delete from tmp_konstanten where beschreibung in (select beschreibung from konstanten);


create temp table tmp_hilf (tid integer);
insert into tmp_hilf select max(tid) from konstanten;
update tmp_hilf set tid=0 where tid is null;

insert into konstanten(tid , apnr ,beschreibung, defaultvalue, description, systeminfo_id, doku_link, read_only, wertebereich, ab_version, gruppe, sachgebiete_id )
select H.tid+K.tid , K.apnr ,K.beschreibung, K.defaultvalue, K.description, K.systeminfo_id, K.doku_link, K.read_only, K.wertebereich, K.ab_version, K.gruppe, K.sachgebiete_id  from tmp_konstanten K, tmp_hilf H;


drop table tmp_konstanten;

drop table tmp_hilf;

--Konstante LM_ECTS_SOLL_SRC auf Wert von SOS setzen, wenn noch nicht gesetzt:
update konstanten set apnr=1
where beschreibung='LM_ECTS_SOLL_SRC'
and apnr=2
and 0< (select count(*) from konstanten K2 where K2.beschreibung='SOS_ECTS_SOLL_SRC' and K2.apnr=1);

