#!/bin/bash
#Copy Script for SuperX.
. ./LM_ENV
if [ "$SRC_PFAD" = "" ]
then 
SRC_PFAD=.
fi

ERR=lm_copy.err


#
#Unload-Job 
#
echo "--------------------------------------------------------------" >$ERR
echo "Kopiere Dateien via $COPY_METHOD von $SRC_PFAD:" >>$ERR
if [ $COPY_METHOD = "scp" ] 
then
scp $SCP_OPTS $SRC_PFAD/lm_unload.err $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/lm_unload.err >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/konstanten.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/lm_unit.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/lm_unit_studies.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/lm_course_of_study.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/lm_unitrelation.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/lm_examrelation.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/lm_examination.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/lm_examplan.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/lm_exam_instructor.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/lm_accreditation.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/cifx.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/lm_stud_d.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/lm_unit_top.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/lm_exam_written.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/lm_additional_examtext.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1


if [ -f $SRC_PFAD/unl/superx_unload_version.unl  ]
then
 scp $SCP_OPTS $SRC_PFAD/unl/superx_unload_version.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR >>$ERR 2>&1
fi

fi #Ende scp
if [ $COPY_METHOD = "rsync" ] 
then
scp $SCP_OPTS  $SRC_PFAD/lm_unload.err $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/lm_unload.err >>$ERR 2>&1
rsync -rauvz -e ssh --delete $SRC_PFAD/unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR  >>$ERR 2>&1

fi
#Wenn Dateien existieren, auch Datum kopieren (z.B. im SOS-Modul)

if [ $COPY_METHOD = "rsync" -o $COPY_METHOD = "scp" ] 
then
if [ -f $SRC_PFAD/superx.datum  ]
then
 scp $SCP_OPTS $SRC_PFAD/superx.datum $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR >>$ERR 2>&1
fi
if [ -f $SRC_PFAD/superx.datum.alt  ]
then
 scp $SCP_OPTS $SRC_PFAD/superx.datum.alt $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR >>$ERR 2>&1
fi
fi

#sftp:
if [ $COPY_METHOD = "sftp" ] 
then
cd $SRC_PFAD
echo "using sftp to $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR" >>$ERR 2>&1
#zuerst Metadateien:
echo "put lm_unload.err" >lm_sftp_logs.txt 2>>$ERR
if [ -f $SRC_PFAD/superx.datum  ]
then
echo "put superx.datum" >>lm_sftp_logs.txt 2>>$ERR
fi
if [ -f $SRC_PFAD/superx.datum.alt  ]
then
echo "put superx.datum.alt" >>lm_sftp_logs.txt 2>>$ERR
fi
#sftp-Kopieren start:
#cat lm_sftp_logs.txt >>$ERR 2>&1
sftp $SFTP_OPTS -b lm_sftp_logs.txt $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR >>$ERR 2>&1
if [ -f $SRC_PFAD/unl/superx_unload_version.unl  ]
then
echo "put unl/superx_unload_version.unl" >lm_sftp_version.txt 2>>$ERR
#sftp-Kopieren start:
#cat lm_sftp_version.txt >>$ERR 2>&1
sftp $SFTP_OPTS  -b lm_sftp_version.txt $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1

fi

#UNL-Dateien selber:
#cat lm_sftp.txt >>$ERR 2>&1
sftp $SFTP_OPTS  -b lm_sftp.txt $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1

fi


#Fehlerbehandlung
fgrep -s "not found" $ERR >/dev/null
FLAG1=$?
fgrep -i -s "nicht gefunden" $ERR >/dev/null
FLAG2=$?
fgrep -i -s "error" $ERR >/dev/null
FLAG3=$? >/dev/null
if [ $FLAG1 -eq 0 -o $FLAG2 -eq 0 -o $FLAG3 -eq 0 ]
then
	echo "Fehler beim Kopieren. " 
	echo "---------------------------------------" 
	echo "Prüfen Sie Fehlerprotokoll: $ERR" 
	echo "---------------------------------------" 
	 
fi

