--freemarker template
<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>

<sqlvars>
<sqlvar name="LM_ECTS_IST_FILTER_N">
select content from sx_repository where id='LM_ECTS_IST_FILTER' and aktiv=1;
</sqlvar>
<sqlvar name="stud_stichtag_tagesaktuell">
select I.tid from sos_stichtag I where I.appl_key='0'
;
</sqlvar>
</sqlvars>


select distinct 
	U.id as top_unit_id, 
	U.defaulttext,
	CS.lid as course_of_study_lid,
	U.sourcesystem
into temp tmp_unit_studies_knoten
from 
	lm_unit U,
	lm_unit_top UT, 
	lm_unit_studies US, 
	lm_course_of_study CS
where 
	U.id=UT.top_unit_id
	and U.id=UT.unit_id
	and UT.top_unit_id=US.unit_id 
	and US.course_of_study_lid=CS.lid
	;
	
	
	--aĺle units darunter mit unitrelation_type="ABS":
select 
	T.top_unit_id,
	U.id as unit_id,
	U.defaulttext,
	U.elementnr,
	T.course_of_study_lid,
	T.sourcesystem

into temp tmp_top_unit_knoten
from 
	lm_unitrelation UR,
	cifx C,
	lm_unit U,
	tmp_unit_studies_knoten T
where 
UR.unitrelationtype=C.apnr
and C.key=9015
and C.hiskey_id='9'
and 	U.id=UR.child_unit_id
	and UR.parent_unit_id=T.top_unit_id
;
	
with recursive unit_rec (
	ebene,
	unit_defaulttext,
	elementnr,
	unit_id,
	parent_unit_id,
	top_unit_id,
	course_of_study_lid,
	sort_tree,
	sourcesystem)
as (
	select 
		1 as ebene,
		T.defaulttext as unit_defaulttext, 
		T.elementnr,
		T.unit_id,
		null::integer as parent_unit_id ,
		T.top_unit_id,
T.course_of_study_lid,
		T.unit_id::varchar(255) as sort_tree,
	T.sourcesystem
	from 
		tmp_top_unit_knoten T
	where 1=1 
	
	union all (
	select 
		R.ebene+1 as ebene,
		U.defaulttext as unit_defaulttext,
		U.elementnr,
		U.id as unit_id,
		UR.parent_unit_id,
		R.top_unit_id,
		R.course_of_study_lid,
		(R.sort_tree || '_' || U.id)::varchar(255),
	R.sourcesystem
	from 
		unit_rec R,
		lm_unit U,
		lm_unit_top UT, 
		lm_unitrelation UR,
	cifx C
	where 
	 UR.unitrelationtype=C.apnr
and C.key=9015
and C.hiskey_id='9'
		and U.id=UR.child_unit_id
		and UT.unit_id=UR.child_unit_id
		and UT.top_unit_id=R.top_unit_id
		and UR.parent_unit_id=R.unit_id
	)
)
--search depth first by name set sort_tree
select 
	ebene,
	unit_defaulttext as name,
	elementnr,
	unit_id,
	parent_unit_id,
	top_unit_id,
	course_of_study_lid,
	sort_tree,
	sourcesystem
into temp tmp_abs_unit_knoten
from  
	unit_rec
;






create temp table tmp_lm_exam_unit_studies_top(
	matrikel_nr INTEGER , 
labnr INTEGER , 
sourcesystem INTEGER , 
top_labnr INTEGER , 
ebene INTEGER,
sem_der_pruefung SMALLINT , 
abschluss CHAR(10) , 
abschluss_astat CHAR(10) , 
stg CHAR(10) , 
vertiefung CHAR(10) , 
schwerpunkt CHAR(10) , 
kz_fach CHAR(10) , 
pversion INTEGER , 
pversion_uniquename varchar(255),
stutyp CHAR(10) , 
stort CHAR(10) , 
stufrm CHAR(10) , 
tid_stg INTEGER , 
bonus_pord double precision , 
malus FLOAT , 
bonus FLOAT ,
bonus_exam float,
bonus_anteil_formel varchar(255),
--ist_faktor FLOAT ,
pordnr integer,
part char(10),
pdtxt  varchar(255),
calculate_ects_sum integer default 0,
sem_rueck_beur_ein_min_student integer,
sem_rueck_beur_ein_max_student integer
) 
;

create temp table tmp_lm_exam_unit_studies(
	matrikel_nr INTEGER , 
labnr INTEGER , 
sourcesystem INTEGER , 
top_labnr INTEGER , 
top_unit_uniquename VARCHAR(255) , 
top_unit_elementnr VARCHAR(255) , 
subtop_labnr INTEGER , 
subtop_unit_uniquename VARCHAR(255) , 
subtop_unit_elementnr VARCHAR(255) , 
labnr_parent INTEGER , 
labnr_parent_pstatus CHAR(10) , 
labnr_parent_term integer,
ebene INTEGER,
sem_der_pruefung SMALLINT , 
d_abg_pruefung DATE , 
note FLOAT , 
fach_sem_zahl decimal(10,2) , 
pstatus CHAR(10) , 
prueck SMALLINT , 
pvermerk CHAR(10) ,
pnr integer, 
zeitabschnitt CHAR(10) , 
pform CHAR(10) , 
panerk CHAR(10) ,
panerk_art CHAR(10), 
pversuch integer,
abschluss CHAR(10) , 
abschluss_astat CHAR(10) ,
stg CHAR(10) , 
vertiefung CHAR(10) , 
schwerpunkt CHAR(10) , 
kz_fach CHAR(10) , 
pversion INTEGER , 
pversion_uniquename varchar(255),
stutyp CHAR(10) , 
stort CHAR(10) , 
stufrm CHAR(10) , 
tid_stg INTEGER , 
bonus_pord double precision , 
malus FLOAT , 
bonus FLOAT , 
bonus_exam float,
bonus_anteil_formel varchar(255),
--ist_faktor FLOAT ,
pordnr integer,
pordnr_parent integer,
parent_unit_uniquename VARCHAR(255) , 
parent_unit_elementnr VARCHAR(255) , 
parent_unit_elementtyp CHAR(10) , 
parent_unit_ismodule SMALLINT default 0, 
unit_elementtyp CHAR(10) , 
part char(10),
pdtxt  varchar(255),
calculate_ects_sum integer default 0,
sortnr VARCHAR(255)

) 
;

create temp table tmp_lab_u(
labnr INTEGER , 
labnr_parent integer,
pordnr integer,
pordnr_parent integer,
parent_unit_uniquename VARCHAR(255) , 
parent_unit_elementnr VARCHAR(255) , 
sourcesystem INTEGER ,
top_labnr integer,
subtop_labnr INTEGER ,
abschluss CHAR(10) , 
abschluss_astat CHAR(10) , 
stg CHAR(10) , 
vertiefung CHAR(10) , 
schwerpunkt CHAR(10) , 
kz_fach CHAR(10) , 
pversion INTEGER , 
stutyp CHAR(10) , 
stort CHAR(10) , 
stufrm CHAR(10) , 
tid_stg INTEGER ,
pdtxt  varchar(255),
calculate_ects_sum integer default 0,
sortnr VARCHAR(255),
panerk CHAR(10) ,
panerk_art CHAR(10),
sem_der_pruefung integer
);

create temp table tmp_lab_o(
labnr INTEGER , 
labnr_parent integer,
pordnr integer,
pordnr_parent integer,
parent_unit_uniquename VARCHAR(255) , 
parent_unit_elementnr VARCHAR(255) , 
sourcesystem INTEGER,
top_labnr integer,
subtop_labnr INTEGER ,
abschluss CHAR(10) , 
abschluss_astat CHAR(10) , 
stg CHAR(10) , 
vertiefung CHAR(10) , 
schwerpunkt CHAR(10) , 
kz_fach CHAR(10) , 
pversion INTEGER , 
stutyp CHAR(10) , 
stort CHAR(10) , 
stufrm CHAR(10) , 
tid_stg INTEGER ,
pdtxt  varchar(255),
calculate_ects_sum integer default 0,
sortnr VARCHAR(255) ,
panerk CHAR(10) ,
panerk_art CHAR(10),
sem_der_pruefung integer
);


----zuerst Ebene Einzeldaten

<@selectintotmp 
select="SA.matrikel_nr,
null::varchar(255) as pseudonym,--SA.pseudonym,
null::smallint as studiengang_nr,
null::smallint as fach_nr,
null::char(10) as ch62_grund_exmatr,
SA.tid_stg, 
L.regel,
L.stg,
L.stg_str,
L.stg_astat,
L.abschluss,
L.abschluss_str,
L.abschluss_astat,
L.abschlussart,
L.vertfg,
L.schwerpunkt,
L.kz_fach,
L.stort,
L.pversion,
L.text as tid_stg_str,
SA.stutyp,
max(SA.stufrm) as stufrm,
max(fach_sem_zahl) as fach_sem_zahl_max_student,
max(SA.sem_rueck_beur_ein) as sem_rueck_beur_ein_max_student,
max(SA.sem_rueck_beur_ein)+10 as sem_rueck_beur_ein_max_student_plus_10, 
min(SA.sem_rueck_beur_ein) as sem_rueck_beur_ein_min_student"
source="sos_stg_aggr SA, dim_studiengang L, sos_sos S"
target="tmp_student">
where SA.tid_stg=L.tid
and SA.matrikel_nr=S.matrikel_nr
and SA.stichtag=${stud_stichtag_tagesaktuell}
--and studiengang_nr=1 
--and fach_nr=1
and ${LM_STUDENT_FILTER}
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21
</@selectintotmp>
 <@informixnolog/>;
 
 
--zuerst top knoten PO:
insert into tmp_lm_exam_unit_studies_top(matrikel_nr,
--       labnr,
--       sourcesystem,
--       top_labnr,
ebene,
--sem_der_pruefung,
       abschluss,
       abschluss_astat,
       stg,
       vertiefung,
       schwerpunkt,
       kz_fach,
       pversion,
       stutyp,
       stort,
       stufrm,
       tid_stg,
       sem_rueck_beur_ein_min_student,
	   sem_rueck_beur_ein_max_student,
       -- bonus_pord,
       -- malus,
       -- bonus_exam ,
       -- bonus_anteil_formel,
       -- bonus,
       pordnr,
       sourcesystem,
pdtxt ,
calculate_ects_sum 
)
       select distinct --ein lehr_Stg_ab-Studiengang kann mehrere course_of_study-Einträge haben, daher distinct
       S.matrikel_nr,
1::smallint as ebene,
       S.abschluss,
       S.abschluss_astat,
       S.stg,
       S.vertfg,
       S.schwerpunkt,
       S.kz_fach,
       S.pversion,
       S.stutyp,
       S.stort,
       S.stufrm,
       S.tid_stg,
       S.sem_rueck_beur_ein_min_student,
       S.sem_rueck_beur_ein_max_student,
       U.id as pordnr,
       U.sourcesystem,
U.defaulttext ,
U.calculate_ects_sum
       from tmp_student S, lm_course_of_study C, tmp_abs_unit_knoten T ,lm_unit U
       where 
         U.id=T.unit_id
       and U.sourcesystem=T.sourcesystem
--       and E.pordnr=U.unit_id
--       and E.sourcesystem=U.sourcesystem
       and C.tid_stg=S.tid_stg
       and T.course_of_study_lid=C.lid
       ;


       
  
--select * from tmp_lm_exam_unit_studies_top;

select now(),'Top-Knoten' from xdummy;

--jetzt der  Leistungsbaum:
insert into tmp_lm_exam_unit_studies(matrikel_nr,
       labnr,
       sourcesystem,
       top_labnr,
--       labnr_parent, 
ebene,
sem_der_pruefung,
       abschluss,
       abschluss_astat,
       stg,
       vertiefung,
       schwerpunkt,
       kz_fach,
       pversion,
       stutyp,
       stort,
       stufrm,
       tid_stg,
       bonus_pord,
       malus,
       bonus_exam,
       bonus_anteil_formel,
       bonus,
       pordnr,
       part,
pdtxt ,
calculate_ects_sum,
sortnr)
       select --R.*,
L.matrikel_nr,
E.labnr,
L.sourcesystem,
E.labnr as top_labnr,
L.ebene,
E.sem_der_pruefung,
L.abschluss,
L.abschluss_astat,
L.stg,
L.vertiefung,
L.schwerpunkt,
L.kz_fach,
L.pversion,
L.stutyp,
L.stort,
L.stufrm,
L.tid_stg,
E.bonus_pord,
E.malus,
E.bonus,
'*0' as bonus_anteil_formel,
E.bonus,
E.pordnr,
E.part,
L.pdtxt ,
L.calculate_ects_sum,
E.labnr || '_' 
       from tmp_lm_exam_unit_studies_top L, tmp_lm_exam_unit E
	   where L.pordnr= E.pordnr
	   and E.matrikel_nr=L.matrikel_nr
	   --and E.sem_der_pruefung >= sem_rueck_beur_ein_min_student --wenn ein Studi den Studiengang wechselt aber Leistungen im alten Studiengang hat, die auch in den neuen Leistungsbaum passen, werden diese auch eingerechnet.
	   --and E.sem_der_pruefung <= sem_rueck_beur_ein_max_student
	   
       ;

--select * from tmp_lm_exam_unit_studies_top;

--nun Kinder:
insert into tmp_lab_u(labnr,
labnr_parent,
--pordnr,
pordnr_parent,
sourcesystem, 
top_labnr,
subtop_labnr ,
      abschluss,
      abschluss_astat,
       stg,
       vertiefung,
       schwerpunkt,
       kz_fach,
       pversion,
       stutyp,
       stort,
       stufrm,
       tid_stg,
pdtxt ,
calculate_ects_sum,
sortnr,
panerk,
panerk_art,
sem_der_pruefung
)
select R.child_examplan_id,
T.labnr,
T.pordnr,
T.sourcesystem,
T.top_labnr,
R.child_examplan_id as subtop_labnr ,
       abschluss,
       abschluss_astat,
       stg,
       vertiefung,
       schwerpunkt,
       kz_fach,
       pversion,
       stutyp,
       stort,
       stufrm,
 tid_stg,
T.pdtxt ,
T.calculate_ects_sum,
T.labnr || '_'  || R.child_examplan_id ,
case when R.is_approved=1 then 'J' else null end as panerk,
case when R.internal_accreditationtype ='Ja' then 'H' else null end as panerk_art,
R.sem_der_pruefung

from tmp_lm_exam_unit_studies T, lm_examrelation R
where R.parent_examplan_id=T.labnr
and R.sourcesystem=T.sourcesystem
;

<#list 2..15 as ebene>

select now(),'Durchlaufe Ebene ${ebene}' from xdummy;

insert into tmp_lm_exam_unit_studies(matrikel_nr,
       labnr,
       sourcesystem,
       top_labnr,
subtop_labnr ,
labnr_parent,
ebene,
sem_der_pruefung,
d_abg_pruefung,
note,
fach_sem_zahl,
pstatus,
prueck,
pvermerk,
zeitabschnitt,
pform,
panerk,
panerk_art,
pversuch,
       abschluss,
       abschluss_astat,
       stg,
       vertiefung,
       schwerpunkt,
       kz_fach,
       pversion,
       stutyp,
       stort,
       stufrm,
       tid_stg,
       bonus_pord,
       malus,
       bonus_exam,
       pordnr,
part,
pdtxt ,
calculate_ects_sum,
sortnr )
select 
L.matrikel_nr,
L.labnr,
L.sourcesystem,
U.top_labnr,
U.subtop_labnr ,
U.labnr_parent,
${ebene} as ebene,
case when U.panerk='J' then U.sem_der_pruefung else L.sem_der_pruefung end,
L.d_abg_pruefung,
L.note,
L.fach_sem_zahl,
L.pstatus,
L.prueck,
L.pvermerk,
L.zeitabschnitt,
L.pform,
U.panerk,
U.panerk_art,
L.pversuch,
U.abschluss,
U.abschluss_astat,
U.stg,
U.vertiefung,
U.schwerpunkt,
U.kz_fach,
U.pversion,
U.stutyp,
U.stort,
U.stufrm,
U.tid_stg,
L.bonus_pord,
L.malus,
L.bonus,
L.pordnr,
L.part,
L.pdtxt  ,
U.calculate_ects_sum, --Vererbung nach unten
U.sortnr
       from tmp_lm_exam_unit L, tmp_lab_u U
       where U.labnr=L.labnr
       and U.sourcesystem=L.sourcesystem
       ;
       
       

insert into tmp_lab_o
( labnr,
labnr_parent,
pordnr,
sourcesystem,
top_labnr,
subtop_labnr ,
       abschluss,
       abschluss_astat,
       stg,
       vertiefung,
       schwerpunkt,
       kz_fach,
       pversion,
       stutyp,
       stort,
       stufrm,
 tid_stg,
pdtxt ,
calculate_ects_sum,
sortnr ,
panerk,
panerk_art,
sem_der_pruefung)
select R.child_examplan_id,
R.parent_examplan_id,
U.pordnr,
R.sourcesystem,
U.top_labnr,
U.subtop_labnr ,
U.abschluss,
U.abschluss_astat,
U.stg,
U.vertiefung,
U.schwerpunkt,
U.kz_fach,
U.pversion,
U.stutyp,
U.stort,
U.stufrm,
U.tid_stg,
U.pdtxt  ,
U.calculate_ects_sum,
U.sortnr || '_' || R.child_examplan_id as sortnr,
case when R.is_approved=1 then 'J' else null end as panerk,
case when R.internal_accreditationtype ='Ja' then 'H' else null end as panerk_art,
R.sem_der_pruefung
from tmp_lab_u U, lm_examrelation R
where R.parent_examplan_id=U.labnr
and U.sourcesystem=R.sourcesystem
;



delete from tmp_lab_u;
insert into tmp_lab_u
 select *
 from tmp_lab_o;
delete from tmp_lab_o;


</#list>




select now(),'Löschen und einfügen' from xdummy;


--STU pversion:
update tmp_lm_exam_unit_studies set pversion_uniquename=(select lang_3 from cif C
where C.key=632 and C.apnr=tmp_lm_exam_unit_studies.pversion);
--sospos-pversion:
update tmp_lm_exam_unit_studies set pversion_uniquename=pversion
where pversion_uniquename is null;

update tmp_lm_exam_unit_studies
set pordnr= L.pordnr
from tmp_lm_exam_unit L
where L.labnr=tmp_lm_exam_unit_studies.labnr
and L.sourcesystem=tmp_lm_exam_unit_studies.sourcesystem
;

update tmp_lm_exam_unit_studies
set labnr_parent_term= L.sem_der_pruefung,
labnr_parent_pstatus=L.pstatus
from tmp_lm_exam_unit L
where L.labnr=tmp_lm_exam_unit_studies.labnr_parent
and L.sourcesystem=tmp_lm_exam_unit_studies.sourcesystem
;

update tmp_lm_exam_unit_studies
set unit_elementtyp= U.elementtyp
from lm_unit U
where U.id=tmp_lm_exam_unit_studies.pordnr
and U.sourcesystem=tmp_lm_exam_unit_studies.sourcesystem;

update tmp_lm_exam_unit_studies
set pordnr_parent=L.pordnr
from tmp_lm_exam_unit L
where L.labnr=tmp_lm_exam_unit_studies.labnr_parent
and L.sourcesystem=tmp_lm_exam_unit_studies.sourcesystem;

update tmp_lm_exam_unit_studies
set parent_unit_uniquename=U.uniquename,
parent_unit_elementnr=U.elementnr,
parent_unit_elementtyp=U.elementtyp
from lm_unit U
where U.id=tmp_lm_exam_unit_studies.pordnr_parent
and U.sourcesystem=tmp_lm_exam_unit_studies.sourcesystem;

-- --Unit Details zur top-Labnr
-- update tmp_lm_exam_unit_studies
-- set top_unit_uniquename=E.unit_uniquename,
-- top_unit_elementnr=E.elementnr
-- from tmp_lm_exam_unit E
-- where E.labnr=tmp_lm_exam_unit_studies.top_labnr
-- and E.sourcesystem=tmp_lm_exam_unit_studies.sourcesystem;
-- 
-- --Unit Details zur subtop-Labnr
-- update tmp_lm_exam_unit_studies
-- set subtop_unit_uniquename=E.unit_uniquename,
-- subtop_unit_elementnr=E.elementnr
-- from tmp_lm_exam_unit E
-- where E.labnr=tmp_lm_exam_unit_studies.subtop_labnr
-- and E.sourcesystem=tmp_lm_exam_unit_studies.sourcesystem;

--Prüfungen unterhalb von Modulen zählen nicht ins ECTS,
--damit sie nicht doppelt reinkommen https://hiszilla.his.de/hiszilla/show_bug.cgi?id=231492#c105
--todo: langsam
update tmp_lm_exam_unit_studies set parent_unit_ismodule=1 --calculate_ects_sum=0
where calculate_ects_sum=1
and unit_elementtyp not in (${LM_ELEMENTTYP_MODUL})
and parent_unit_elementtyp in (${LM_ELEMENTTYP_MODUL})
;



delete from lm_exam_unit_studies
where exists (select 1 from tmp_lm_exam_unit_studies T
where T.matrikel_nr=lm_exam_unit_studies.matrikel_nr)
;

insert into lm_exam_unit_studies(matrikel_nr,
       labnr,
       sourcesystem,
       top_labnr,
       labnr_parent,
       labnr_parent_term,
       labnr_parent_pstatus,
       ebene,
       abschluss,
       stg,
       vertiefung,
       schwerpunkt,
       kz_fach,
       pversion,
       pversion_uniquename,
       stutyp,
       stort,
       stufrm,
       tid_stg,
pordnr,
pordnr_parent,
parent_unit_uniquename  , 
parent_unit_elementnr , 
parent_unit_ismodule,
-- part, 
calculate_ects_sum,
sortnr,
panerk,
panerk_art,
sem_der_pruefung

)
select distinct matrikel_nr,
       labnr,
       sourcesystem,
       top_labnr,
       labnr_parent,
       labnr_parent_term,
       labnr_parent_pstatus,
       ebene,
       abschluss,
       stg,
       vertiefung,
       schwerpunkt,
       kz_fach,
       pversion,
       pversion_uniquename,
       stutyp,
       stort,
       stufrm,
       tid_stg,
 pordnr,
pordnr_parent,
parent_unit_uniquename  , 
parent_unit_elementnr , 
parent_unit_ismodule,
-- part,
calculate_ects_sum,
sortnr,
panerk,
panerk_art,
sem_der_pruefung

FROM tmp_lm_exam_unit_studies 
 ;

drop table tmp_lab_u;
drop table tmp_lab_o;
drop table tmp_lm_exam_unit_studies_top;
drop table tmp_lm_exam_unit_studies;
drop table tmp_student;
drop table tmp_abs_unit_knoten;
drop table tmp_unit_studies_knoten;
drop table tmp_top_unit_knoten;
