--freemarker template
<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>

delete from lm_exam_unit 
where exists (select 1 from tmp_lm_exam_unit T
where T.matrikel_nr=lm_exam_unit.matrikel_nr)
;

insert into lm_exam_unit (
    matrikel_nr,
    labnr,
    ch30_fach,
    ch39_vertief,
    ch35_ang_abschluss,
    pversion,
    schwerpunkt,
    kz_fach,
    stort,
    stutyp,
    stufrm,
    sem_der_pruefung,
    d_abg_pruefung,
    sem_d_abg_pruefung,
    note,
    fach_sem_zahl,
    recommended_semester,
    pstatus,
    prueck,
    pvermerk,
    zeitabschnitt,
    pform,
    panerk,
    panerk_art,
    pordnr,
    part,
    schriftlich,
    ppflicht,
    modulart,
    bonus_pord,
    pktxt,
    pdtxt,
    unit_uniquename,
    pversuch,
    studiengang_nr,
    fach_nr,
    pdum,
    sourcesystem,
    malus,
    bonus,
    official_statistics,
    calculate_ects_sum,
    elementnr,
    zusatztext,
    tid_stg,
    --course_of_study_lid,
    summe,
    unit_valid_from,
    unit_valid_to,
    shortcomment)
with student_matrikelnrs as (
	 select distinct S.matrikel_nr from sos_sos S
	 where ${LM_STUDENT_FILTER})
select
    U.matrikel_nr,
    U.labnr,
    ST.stg,
    ST.vertiefung,
    ST.abschluss,
    ST.pversion,
    ST.schwerpunkt,
    ST.kz_fach,
    ST.stort,
    ST.stutyp,
    ST.stufrm,
	case when ST.panerk='J' and ST.sem_der_pruefung is not null then ST.sem_der_pruefung else U.sem_der_pruefung end,
    U.d_abg_pruefung,
    U.sem_d_abg_pruefung,
    U.note,
    U.fach_sem_zahl,
    U.recommended_semester,
    U.pstatus,
    U.prueck,
    U.pvermerk,
    U.zeitabschnitt,
    U.pform,
    ST.panerk,
	ST.panerk_art,
    U.pordnr,
    U.part,
    U.schriftlich,
    U.ppflicht,
    U.modulart,
    U.bonus_pord,
    U.pktxt,
    U.pdtxt,
    U.unit_uniquename,
    U.pversuch,
    U.studiengang_nr,
    U.fach_nr,
    U.pdum,
    U.sourcesystem,
    U.malus,
    U.bonus,
    U.official_statistics,
    U.calculate_ects_sum,
    U.elementnr,
    U.zusatztext,
    ST.tid_stg,
    --course_of_study_lid,
    U.summe,
    U.unit_valid_from,
    U.unit_valid_to,
    U.shortcomment
from tmp_lm_exam_unit U
     join student_matrikelnrs smnr 
		on smnr.matrikel_nr = U.matrikel_nr
     left outer join lm_exam_unit_studies ST
         on U.labnr = ST.labnr
         and U.sourcesystem = ST.sourcesystem
;

drop table tmp_lm_exam_unit;

select now(),'Anzahl Sätze in lm_exam_unit:'::char(30),count(*) from lm_exam_unit
group by 1,2;


 update lm_exam_unit set course_of_study_lid=C.lid
from lm_course_of_study C
where lm_exam_unit.tid_stg=C.tid_stg
;

 SELECT now(),'fach_sem_zahl und stgnr ermitteln:' FROM xdummy;

WITH student_matrikelnrs AS (
	 SELECT DISTINCT S.matrikel_nr FROM sos_sos S
	 WHERE ${LM_STUDENT_FILTER}
)
UPDATE lm_exam_unit
SET fach_sem_zahl =F.fach_sem_zahl,
studiengang_nr=F.studiengang_nr,
fach_nr=F.fach_nr
  FROM sos_stg F
  WHERE
lm_exam_unit.matrikel_nr = F.matrikel_nr
AND lm_exam_unit.ch30_fach = F.ch30_fach
AND lm_exam_unit.ch35_ang_abschluss = F.ch35_ang_abschluss
AND lm_exam_unit.sem_der_pruefung = F.sem_rueck_beur_ein
AND lm_exam_unit.sourcesystem != 15 --nicht CO
AND lm_exam_unit.matrikel_nr IN (SELECT * FROM student_matrikelnrs)
 ;


-- jetzt kommt der SQL der FHDO für alle Fälle, wo tid_stg noch null ist
	
	create temp table tmp_lm_exam_unit_studies(
	matrikel_nr INTEGER , 
	labnr INTEGER , 
	sourcesystem INTEGER , 
	top_labnr INTEGER , 
	top_unit_uniquename VARCHAR(255) , 
	top_unit_elementnr VARCHAR(255) , 
	subtop_labnr INTEGER , 
	subtop_unit_uniquename VARCHAR(255) , 
	subtop_unit_elementnr VARCHAR(255) , 
	labnr_parent INTEGER , 
	labnr_parent_pstatus CHAR(10) , 
	labnr_parent_term integer,
	ebene INTEGER,
	sem_der_pruefung SMALLINT , 
	d_abg_pruefung DATE , 
	note FLOAT , 
	fach_sem_zahl decimal(10,2) , 
	pstatus CHAR(10) , 
	prueck SMALLINT , 
	pvermerk CHAR(10) , 
	zeitabschnitt CHAR(10) , 
	pform CHAR(10) , 
	panerk CHAR(10) , 
	pversuch integer,
	course_of_study_lid integer,
	abschluss CHAR(10) , 
	abschluss_astat CHAR(10) ,
	stg CHAR(10) , 
	vertiefung CHAR(10) , 
	schwerpunkt CHAR(10) , 
	kz_fach CHAR(10) , 
	pversion INTEGER , 
	pversion_uniquename varchar(255),
	stutyp CHAR(10) , 
	stufrm CHAR(10) , 
	stort CHAR(10) , 
	tid_stg INTEGER , 
	bonus_pord double precision , 
	malus FLOAT , 
	bonus FLOAT , 
	bonus_exam float,
	bonus_anteil_formel varchar(255),
	--ist_faktor FLOAT ,
	pordnr integer,
	pordnr_parent integer,
	parent_unit_uniquename VARCHAR(255) , 
	parent_unit_elementnr VARCHAR(255) , 
	parent_unit_elementtyp CHAR(10) , 
	parent_unit_ismodule SMALLINT default 0, 
	unit_elementtyp CHAR(10) , 
	part char(10),
	pdtxt  varchar(255),
	calculate_ects_sum integer default 0,
	sortnr VARCHAR(255)
	
	) 
	;
	
	
	select SA.matrikel_nr,
	null::varchar(255) as pseudonym,--SA.pseudonym,
	null::smallint as studiengang_nr,
	null::smallint as fach_nr,
	null::char(10) as ch62_grund_exmatr,
	SA.tid_stg, 
	L.regel,
	L.stg,
	L.stg_str,
	L.stg_astat,
	L.abschluss,
	L.abschluss_str,
	L.abschluss_astat,
	L.abschlussart,
	L.vertfg,
	L.schwerpunkt,
	L.kz_fach,
	L.stort,
	L.pversion,
	L.text as tid_stg_str,
	SA.stutyp,
	SA.sem_rueck_beur_ein,
	SA.stufrm
	into temp tmp_student
	from sos_stg_aggr SA, dim_studiengang L, sos_sos S
	where SA.tid_stg=L.tid
	and SA.matrikel_nr=S.matrikel_nr
	and SA.stichtag=(select I.tid from sos_stichtag I where I.appl_key='0')
	and ${LM_STUDENT_FILTER}
	;
	
	create index tmp_student1
	on tmp_student (
	matrikel_nr, sem_rueck_beur_ein, stg, abschluss, pversion, kz_fach, schwerpunkt, vertfg, stort, stutyp);
	
	insert into tmp_lm_exam_unit_studies(
	matrikel_nr,
	abschluss,
	stg,
	vertiefung,
	schwerpunkt,
	kz_fach,
	pversion,
	stutyp,
	stufrm,
	stort,
	tid_stg,
	course_of_study_lid,
	labnr,
	sem_der_pruefung,
	malus,
	bonus,
	pordnr,
	unit_elementtyp,
	sourcesystem,
	pdtxt,
	calculate_ects_sum 
	)
	select distinct
	E.matrikel_nr,
	COS.abschluss,
	COS.stg,
	COS.vert,
	COS.schwp,
	COS.kzfa,
	COS.pversion,
	COS.stutyp,
	COS.stufrm,
	COS.stort,
	COS.tid_stg,
	COS.lid,
	E.id as labnr,
	E.sem_der_pruefung,
	E.malus,
	E.bonus,
	U.id as pordnr,
	U.elementtyp,
	U.sourcesystem,
	U.defaulttext,
	U.calculate_ects_sum
	from
	lm_examplan E
	join lm_unit U on U.id=E.unit_id
	join lm_unitrelation UR on UR.id=U.default_unitrelation_id
	join lm_unit_top UT on UT.unit_id=U.id
	join lm_unit_studies US on US.unit_id=UT.top_unit_id
	join lm_course_of_study COS on COS.lid=US.course_of_study_lid
	join lm_examrelation ER on ER.id=E.default_examrelation_id
	join tmp_student S on (
	E.matrikel_nr=S.matrikel_nr
	and E.sem_der_pruefung =S.sem_rueck_beur_ein
	and COS.stg=S.stg
	and COS.abschluss=S.abschluss
	)
	where 1=1
	;

	update lm_exam_unit set tid_stg=T.tid_stg 
	from tmp_lm_exam_unit_studies T
	where T.labnr=lm_exam_unit.labnr
	and lm_exam_unit.tid_stg is null;
	
	-- jetzt noch Leistungen die absolviert werden, nachdem Studierende bereits exmatrikuliert ist (sem_rueck_beur_ein+10)
	delete from tmp_lm_exam_unit_studies;
	
	insert into tmp_lm_exam_unit_studies(
	matrikel_nr,
	abschluss,
	stg,
	vertiefung,
	schwerpunkt,
	kz_fach,
	pversion,
	stutyp,
	stufrm,
	stort,
	tid_stg,
	course_of_study_lid,
	labnr,
	sem_der_pruefung,
	malus,
	bonus,
	pordnr,
	unit_elementtyp,
	sourcesystem,
	pdtxt,
	calculate_ects_sum 
	)
	select distinct 
	E.matrikel_nr,
	COS.abschluss,
	COS.stg,
	COS.vert,
	COS.schwp,
	COS.kzfa,
	COS.pversion,
	COS.stutyp,
	COS.stufrm,
	COS.stort,
	COS.tid_stg,
	COS.lid,
	E.id as labnr,
	E.sem_der_pruefung,
	E.malus,
	E.bonus,
	U.id as pordnr,
	U.elementtyp,
	U.sourcesystem,
	U.defaulttext,
	U.calculate_ects_sum
	from
	lm_examplan E
	join lm_unit U on U.id=E.unit_id
	join lm_unitrelation UR on UR.id=U.default_unitrelation_id
	join lm_unit_top UT on UT.unit_id=U.id
	join lm_unit_studies US on US.unit_id=UT.top_unit_id
	join lm_course_of_study COS on COS.lid=US.course_of_study_lid
	join lm_examrelation ER on ER.id=E.default_examrelation_id
	join tmp_student S on (
	E.matrikel_nr=S.matrikel_nr
	and (E.sem_der_pruefung =S.sem_rueck_beur_ein+1
		or E.sem_der_pruefung =S.sem_rueck_beur_ein+9
		or E.sem_der_pruefung =S.sem_rueck_beur_ein+10)
	and COS.stg=S.stg
	and COS.abschluss=S.abschluss
	and COS.pversion=S.pversion
	and COS.kzfa=S.kz_fach
	and COS.schwp=S.schwerpunkt
	and COS.vert=S.vertfg
	and COS.stort=S.stort
	and COS.stutyp=S.stutyp
	)
	where 1=1
	;
	
	update lm_exam_unit set tid_stg=T.tid_stg 
	from tmp_lm_exam_unit_studies T
	where T.labnr=lm_exam_unit.labnr
	and lm_exam_unit.tid_stg is null;
	
	drop table tmp_lm_exam_unit_studies;
	drop table tmp_student;

-- SQL FHDO Ende


 update lm_exam_unit set course_of_study_lid=C.lid
from lm_course_of_study C
where lm_exam_unit.tid_stg=C.tid_stg
and lm_exam_unit.stufrm=C.stufrm
; 


--bei EXA panerk aus lm_accreditation nachladen über examplan_id:
UPDATE  lm_exam_unit SET panerk = 'J'
WHERE sourcesystem=6
and labnr IN (
    SELECT
      A.examplan_id
    FROM
      lm_accreditation A
    )
;
update lm_exam_unit set panerk_art = A.accreditationtype
from lm_accreditation A
where lm_exam_unit.labnr = A.examplan_id
	and lm_exam_unit.sourcesystem=6;


-- folgende Repo-Variable enthält HS-spezifische Konfigurationen für anerkannte Prüfungen
${LM_ANERK_UPDATE}