--freemarker template
<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>




select now(),'Anzahl Sätze in lm_exam_unit:'::char(30),count(*) from lm_exam_unit
group by 1,2;



drop table if exists tmp_lm_exam_unit;

create table tmp_lm_exam_unit(
	matrikel_nr INTEGER , 
labnr INTEGER , 
ch30_fach CHAR(10) , 
ch39_vertief CHAR(10) , 
ch35_ang_abschluss CHAR(10) , 
pversion SMALLINT , 
schwerpunkt CHAR(10) , 
kz_fach CHAR(10) , 
stort CHAR(10) , 
stutyp CHAR(10) , 
stufrm CHAR(10) , 
tid_stg INTEGER , 
sem_der_pruefung SMALLINT  not null, 
d_abg_pruefung DATE , 
sem_d_abg_pruefung SMALLINT,
note float , 
abschnitt SMALLINT , 
fach_sem_zahl decimal(10,2) , 
recommended_semester  float,
pstatus CHAR(10) , 
prueck SMALLINT , 
pvermerk CHAR(10) , 
pnr INTEGER , 
zeitabschnitt CHAR(10) , 
pform CHAR(10) , 
panerk char(10),
panerk_art char(10),
pordnr integer, 
parent_unit_id integer,
default_unitrelation_id  integer,
part CHAR(10) , 
schriftlich SMALLINT , 
ppflicht CHAR(10) , 
modulart CHAR(10) , 
bonus_pord float , 
pktxt CHAR(255) , 
pdtxt CHAR(255) ,
pversuch INTEGER , 
studiengang_nr SMALLINT , 
fach_nr SMALLINT , 
pdum char(10),
sourcesystem INTEGER  ,
malus FLOAT , 
bonus FLOAT ,
unit_uniquename varchar(255),
official_statistics INTEGER, 
calculate_ects_sum INTEGER ,
course_of_study_lid INTEGER,
elementnr varchar(255),
zusatztext text,
summe INTEGER,
unit_valid_from DATE,
unit_valid_to DATE,
shortcomment varchar
) 
;


insert into tmp_lm_exam_unit( matrikel_nr,
       labnr,
       -- ch30_fach,
       -- ch39_vertief,
       -- ch35_ang_abschluss,
       -- pversion,
       -- schwerpunkt,
       -- kz_fach,
       -- stort,
       -- stutyp,
       -- studiengang_nr,
       -- fach_nr,
       sem_der_pruefung,
       d_abg_pruefung,
       note,
--       fach_sem_zahl,
       pstatus,
       pordnr,
       default_unitrelation_id,
       elementnr,
       pvermerk,
       -- part,
       pform,
       --panerk,
--       schriftlich,
-- ppflicht,
modulart,
prueck,
       zeitabschnitt,
       pversuch,
       pktxt,
       pdtxt,
       pdum,
       official_statistics , 
calculate_ects_sum,
unit_uniquename,
sourcesystem , 
malus  , 
bonus,
summe,
unit_valid_from,
unit_valid_to,
shortcomment
)
SELECT L.matrikel_nr,
L.id as labnr,
-- L.ch30_fach,
-- L.ch39_vertief,
-- L.ch35_ang_abschluss,
-- L.pversion,
-- L.schwerpunkt,
-- L.kz_fach,
-- L.stort,
-- L.stutyp,
--L.studiengang_nr,
--L.fach_nr,
L.sem_der_pruefung,
L.d_abg_pruefung,
L.pnote,
--L.fach_sem_zahl,
L.pstatus,
L.unit_id,
U.default_unitrelation_id,
U.elementnr,
L.pvermerk,
--L.part, TODO nachladen aus (select X.k_examination_type_id from examination X where X.unit_id=L.unit_id)
L.pform,
--L.panerk,
-- P.schriftlich,
-- P.ppflicht,
U.elementtyp,
L.prueck,
L.zeitabschnitt,
L.pversuch,
U.shorttext,
U.defaulttext,
U.pdum,
U.official_statistics , 
U.calculate_ects_sum,
U.uniquename,
L.sourcesystem,
L.malus, 
L.bonus ,
1,
U.valid_from,
U.valid_to,
U.shortcomment
FROM sos_sos S, lm_examplan L left outer join lm_unit U
 on (L.unit_id=U.id
 and L.sourcesystem=U.sourcesystem)
where S.matrikel_nr=L.matrikel_nr
and ${LM_STUDENT_FILTER}
;





update tmp_lm_exam_unit set part=E.part,
 schriftlich=E.exam_written
from lm_examination E
where tmp_lm_exam_unit.pordnr=E.unit_id
;

--parent_unit_id ermitteln:

update tmp_lm_exam_unit set parent_unit_id=R.parent_unit_id
from lm_examrelation R
where R.child_examplan_id=tmp_lm_exam_unit.labnr
and R.sourcesystem=tmp_lm_exam_unit.sourcesystem
;


--Übersteuerung:
update tmp_lm_exam_unit set bonus_pord=R.bonus
 from lm_unitrelation R
where tmp_lm_exam_unit.pordnr=R.child_unit_id
and (tmp_lm_exam_unit.parent_unit_id is null or tmp_lm_exam_unit.parent_unit_id=R.parent_unit_id)
;

--Wenn es keine Übersteuerung gibt:

update tmp_lm_exam_unit set bonus_pord=R.bonus
 from lm_unitrelation R
where tmp_lm_exam_unit.bonus_pord is null
and tmp_lm_exam_unit.default_unitrelation_id=R.id
;


--Array über Zusatztexte
select examplan_id, array_agg(additional_text) as zusatztext
into temp tmp_zusatztext
from lm_additional_examtext
group by 1;

update tmp_lm_exam_unit
set zusatztext=array_to_string(AT.zusatztext,' | ')
from tmp_zusatztext AT
where AT.examplan_id=tmp_lm_exam_unit.labnr;

drop table tmp_zusatztext;
-- Zusatztexte Ende

update tmp_lm_exam_unit set ppflicht=R.compulsory
 from lm_unitrelation R
where tmp_lm_exam_unit.default_unitrelation_id=R.id
;

update tmp_lm_exam_unit set recommended_semester=R.recommended_semester
 from lm_unitrelation R
where tmp_lm_exam_unit.default_unitrelation_id=R.id
;
-- Ermittlung recommended_semester auf diesem Weg scheint ausreichen, da folgender SQL 0 ergibt
-- select count(*) from lm_unitrelation where recommended_semester is not null and child_unit_id in (select id from lm_unit where uniquename in (select unit_uniquename from lm_exam_unit where recommended_semester is null and labnr in (select id from lm_examplan)));


UPDATE tmp_lm_exam_unit
SET sem_d_abg_pruefung = (
  SELECT min(tid) FROM semester S
  WHERE d_abg_pruefung BETWEEN S.sem_beginn AND S.sem_ende
)
WHERE d_abg_pruefung IS NOT NULL;

-- Wenn Datum nicht gefüllt ist, dann wird Originalsemester (psem) genommen:
UPDATE tmp_lm_exam_unit
SET sem_d_abg_pruefung = sem_der_pruefung
WHERE sem_d_abg_pruefung IS NULL;



