--Freemarker Template
<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>

--Ebene EINZPRÜF:
--Spalten für ECTS soll GANG, POS, EXA, sowie summe soll
--Spalten für ECTS ist GANG, POS, EXA sowie summe ist



<sqlvars>
<sqlvar name="SOS_ECTS_LVM_R">
select content from sx_repository where id='SOS_ECTS_LVM' and aktiv=1;
</sqlvar>
<sqlvar name="LM_ECTS_SOLL_IST_SEM" type="hashsequence">
select tid from semester where tid between 
(select apnr from konstanten where beschreibung='LM_ECTS_SOLL_IST_STARTSEM')
and
(select apnr from konstanten where beschreibung='LM_ECTS_SOLL_IST_ENDSEM')
 order by 1;
</sqlvar>

</sqlvars>
<#assign lvm="1" />
<#assign texttype="lvarchar" />
<#if SQLdialect='Postgres'>
<#assign texttype="text" />
</#if>

<#if LM_ECTS_SOLL_IST_SEM?has_content>
<#assign i=1 />
<#foreach semester in LM_ECTS_SOLL_IST_SEM>
<#if i==1>
<#assign startsem=semester.tid />
</#if>
<#if semester?has_next == false>
<#assign endsem=semester.tid />
</#if>
<#assign i=i+1 />
</#foreach>


--zuerst Ebene Einzeldaten

<@selectintotmp 
select="S.matrikel_nr,
S.pseudonym,
S.ca12_staat,
S.geschlecht,
S.hzbart,
S.hrst,
S.tid_stg,
L.regel,
L.stg,
L.abschluss,
L.abschluss_astat,
L.pversion,
L.lehr as lehr_eigen,
S.stufrm,
S.stutyp,
L.regel*2 as max_fach_sem_zahl,
1::integer as berechnen,
max(fach_sem_zahl) as fach_sem_zahl_max_student,
max(sem_rueck_beur_ein) as sem_rueck_beur_ein_max_student"
source="sos_stg_aggr S, dim_studiengang L"
target="tmp_student">
where S.tid_stg=L.tid
and S.stichtag=(select I.tid from sos_stichtag I where I.appl_key='0')
and S.fach_sem_zahl <=(L.regel*2+1)
and sem_rueck_beur_ein >= ${startsem}
and sem_rueck_beur_ein <= ${endsem}
--ohne Franchise:
<#if SOS_FRANCHISE?exists >
and not(${SOS_FRANCHISE})
</#if>
--ohne auslaufende Studiengänge:
<#if SOS_STG_AUSLAUF?exists >
and not(${SOS_STG_AUSLAUF})
</#if>
--ohne incoming
<#if SOS_INCOMING?exists >
and not(${SOS_INCOMING})
</#if>
--ohne Weiterbildung:
<#if SOS_ECTS_WEITERB?exists >
and not(${SOS_ECTS_WEITERB})
</#if>

group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16
</@selectintotmp>
 <@informixnolog/>;

<#if K_SOS_ECTS_POW_COPY?exists && K_SOS_ECTS_POW_COPY==1>
--bei PO Wechsel im Berichtszeitraum nur letztes Semester auswerten:
<@selectintotmp 
select="matrikel_nr,
stg,
abschluss,
max(sem_rueck_beur_ein_max_student) as sem_rueck_beur_ein_max_student"
source="tmp_student"
target="tmp_letztes_semester">
group by 1,2,3
</@selectintotmp>
 <@informixnolog/>;

delete from tmp_student where 0=(
   select count(*) from tmp_letztes_semester T
   where T.matrikel_nr=tmp_student.matrikel_nr
--   and T.studiengang_nr =tmp_student.studiengang_nr
--   and T.fach_nr =tmp_student.fach_nr
   and T.stg =tmp_student.stg
   and T.abschluss =tmp_student.abschluss
   and T.sem_rueck_beur_ein_max_student=tmp_student.sem_rueck_beur_ein_max_student);

drop table tmp_letztes_semester;
</#if>

--SoSe max_fach_sem_zahl+1
update tmp_student set max_fach_sem_zahl=max_fach_sem_zahl+1
where substring('' ||sem_rueck_beur_ein_max_student from 5 for 1)='1';
--Studis über maxfach_sem_zahl raus
update  tmp_student set berechnen=0
--status=status || 'Fachsemester ' || fach_sem_zahl_max_student || ' über max. Fachsem.-Zahl ' || max_fach_sem_zahl || ', '
where fach_sem_zahl_max_student >max_fach_sem_zahl;





create temp table tmp_lvm(tid_stg integer,
stg char(10),
abschluss char(10),
cnw_summe float,
ca_wert float,
lehr char(10)
);

<#if K_SOS_ECTS_CA_SRC==1>
--GANG
insert into tmp_lvm(
tid_stg,
stg,
abschluss,
cnw_summe ,
ca_wert,
lehr)
select distinct L.lehr_stg_ab_tid,
S.stg,
S.abschluss,
C.cnw_summe,
A.ca_wert,
A.lehr
from lehr_stg_ab S, gang_lehr_stg_ab L, gang_cnw C, gang_zu_cnw Z, gang_ca_werte A
where C.tid=Z.gang_cnw_tid
and S.tid=L.lehr_stg_ab_tid
and C.tid=A.gang_cnw_tid
and Z.gang_tid=L.gang_tid
and C.cnw_summe>0
and ${endsem} between C.semester_von and C.semester_bis
;

</#if>
<#if K_SOS_ECTS_CA_SRC==2>
--LVM aus COA:
insert into tmp_lvm(
tid_stg,
stg,
abschluss,
cnw_summe ,
ca_wert,
lehr)
select distinct L.tid,
L.stg,
L.abschluss,
V.cnw,
V.lvm_ca,
V.lvm_lekey

 from lehr_stg_ab L, k_abstgv A, cob_stug C, cob_lvm V, cob_stupl P
 where A.abstgvnr=C.course_of_study_id
 and V.lvm_stugkey=C.stug_key
 and P.stupl_id=V.stupl_id
 and L.stg=A.stg
 and L.abschluss=A.abschl
 and P.sem=${endsem}
 ;
 
</#if>

<#if SOS_ECTS_LVM_R?exists && SOS_ECTS_LVM_R !="">

<#assign inlineTemplate=SOS_ECTS_LVM_R?interpret />
<@inlineTemplate/>

</#if>

create temp table tmp_erg(
matrikel_nr INTEGER ,
pseudonym varchar(255),
ca12_staat integer,
geschlecht integer,
hzbart integer,
aktiv integer,
tid_stg integer,
regel integer,
stg char(10),
abschluss char(10),
abschluss_astat char(10),
abschlussart char(10),
lehr_eigen char(10),
lehr_dienst char(10),
stufrm char(10),
stutyp char(10),
hrst char(10),
ects_soll_gang float,
ects_soll_exa float,
ects_soll_pos float,
ects_soll float,
ects_soll_gruppiert float,
ects_soll_gew float,
max_fach_sem_zahl integer,
berechnen integer,
fach_sem_zahl_max_student integer,
sem_rueck_beur_ein_max_student integer,
ects_ist_pos float,
ects_ist_exa float,
ects_ist float,
ects_ist_gew float,
fach_sem_zahl integer,
cnw_summe float,
ca_wert float,
lm_konto_pro_fs_tid integer
)
;

insert into tmp_erg(
matrikel_nr,
pseudonym,
ca12_staat ,
geschlecht ,
hzbart,
hrst,
stg,
abschluss,
tid_stg,
stufrm,
regel,
lehr_eigen,
lm_konto_pro_fs_tid,
fach_sem_zahl,
fach_sem_zahl_max_student,
sem_rueck_beur_ein_max_student,
aktiv,
ects_soll ,
ects_ist)
select 
S.matrikel_nr,
S.pseudonym,
S.ca12_staat ,
S.geschlecht ,
S.hzbart,
S.hrst,
S.stg,
S.abschluss,
S.tid_stg,
S.stufrm,
S.regel,
S.lehr_eigen,
L.tid,
L.fach_sem_zahl,
S.fach_sem_zahl_max_student,
S.sem_rueck_beur_ein_max_student,
L.aktiv,
max(L.ects_soll_kum),
max(L.ects_ist_kum) as ects_ist
from tmp_student S, lm_konto_pro_fs L
where S.matrikel_nr=L.matrikel_nr
and L.pversion=S.pversion
--and S.tid_stg=L.tid_stg
and L.stg=S.stg
and L.abschluss=S.abschluss
and L.sem_rueck_beur_ein <=S.sem_rueck_beur_ein_max_student
--and L.kz_rueck_beur_ein !=4 --ohne Beurlaubte
and S.berechnen=1
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17
;

create index if not exists ix_tmp_erg1 on tmp_erg (tid_stg, matrikel_nr);


drop table tmp_student;

--zuerst aggregieren:
create temp table tmp_lehr(
matrikel_nr integer,
pseudonym varchar(255),
ca12_staat integer,
geschlecht integer,
hzbart integer,
hrst char(10),
aktiv integer,
tid_stg integer,
stufrm char(10),
lehr_eigen char(10),
lehr_eigen_str varchar(255),
lehr_dienst char(10),
lehr_dienst_str varchar(255),
cnw_summe float,
ca_wert float,
fach_sem_zahl_max_student integer,
sem_rueck_beur_ein_max_student integer,
ects_soll float,
ects_ist float,
ects_soll_gew float,
ects_ist_gew float)
;
insert into tmp_lehr(
matrikel_nr,
pseudonym,
ca12_staat ,
geschlecht ,
hzbart ,
hrst,
aktiv ,
tid_stg,
stufrm,
lehr_eigen,
lehr_dienst ,
cnw_summe ,
ca_wert ,
fach_sem_zahl_max_student,
sem_rueck_beur_ein_max_student,
ects_soll ,
ects_ist ,
ects_soll_gew ,
ects_ist_gew
)
select 
L.matrikel_nr,
L.pseudonym,
L.ca12_staat ,
L.geschlecht ,
L.hzbart ,
L.hrst,
L.aktiv ,
L.tid_stg,
L.stufrm,
L.lehr_eigen,
T.lehr as lehr_dienst,
coalesce(T.cnw_summe,1) as cnw,
coalesce(T.ca_wert,1) as ca,
max(fach_sem_zahl_max_student),
max(sem_rueck_beur_ein_max_student),
max(ects_soll) as ects_soll ,
max(ects_ist) as ects_ist,
max(ects_soll*T.ca_wert/T.cnw_summe) as ects_soll_gew ,
max(ects_ist*T.ca_wert/T.cnw_summe) as ects_ist_gew

from tmp_erg L left outer join tmp_lvm T
on (L.tid_stg =T.tid_stg 
)
group by 1,2,3,4,5,6,7,8,9,10,11,12,13
;
--
update tmp_lehr set ects_soll_gew=ects_soll
where ects_soll_gew is null;
update tmp_lehr set ects_ist_gew=ects_ist
where ects_ist_gew is null;


drop table tmp_lvm;
drop table tmp_erg;

delete from lm_ects_soll_ist
where endsemester=${endsem};

--drop table if exists lm_ects_soll_ist;

--create table lm_ects_soll_ist as 
insert into lm_ects_soll_ist(endsemester,
       matrikel_nr,
       pseudonym,
       ca12_staat,
       geschlecht,
       hzbart,
       hrst,
       aktiv,
       tid_stg,
       stufrm,
       lehr_eigen,
       lehr_dienst,
       cnw_summe,
       ca_wert,
       fach_sem_zahl_max_student,
       sem_rueck_beur_ein_max_student,
       ects_soll,
       ects_ist,
       ects_soll_gew,
       ects_ist_gew

)
select ${endsem}::integer as endsemester,
matrikel_nr,
pseudonym,
ca12_staat ,
geschlecht ,
hzbart ,
hrst,
aktiv ,
tid_stg,
stufrm,
lehr_eigen,
lehr_dienst ,
cnw_summe ,
ca_wert ,
fach_sem_zahl_max_student,
sem_rueck_beur_ein_max_student,
sum(ects_soll) as ects_soll ,
sum(ects_ist) as ects_ist ,
sum(ects_soll*ca_wert/cnw_summe) as ects_soll_gew ,
sum(ects_ist*ca_wert/cnw_summe) as ects_ist_gew
from tmp_lehr L
where 1=1
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16
;
drop table tmp_lehr;

</#if> --wenn überhaupt semester existieren
