--freemarker template

<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>

<sqlvars>
<sqlvar name="Quellsystem_var">
select apnr from konstanten where beschreibung='LM_Quellsystem'
</sqlvar>
</sqlvars>



create temp table tmp_root(
sourcesystem INTEGER , 
labnr integer);

create temp table tmp_children(
labnr integer,
labnr_parent integer,
labnr_root integer,
sourcesystem integer,
ebene integer);

--zuerst die top-Knoten ermitteln:
--diese haben in sos_labzuord keinen Eintrag mehr:

select distinct R.parent_examplan_id as labnr_parent,
${Quellsystem_var}::integer as sourcesystem
into temp tmp_alle_parents
from lm_examrelation_neu R ;

insert into tmp_root(sourcesystem  , 
labnr)
select T.sourcesystem, 
T.labnr_parent as labnr
from tmp_alle_parents T left outer join lm_examrelation_neu R
on (T.labnr_parent=R.child_examplan_id)
where R.id is null
;

--nun die Kinder:
insert into tmp_children(labnr,
labnr_parent,
labnr_root,
sourcesystem,
ebene)
select L.child_examplan_id,
T.labnr,
T.labnr,
T.sourcesystem,
0
from tmp_root T, lm_examrelation_neu L
where L.parent_examplan_id=T.labnr
and T.sourcesystem=L.sourcesystem;

<#list 1..15 as i>

select 'Durchwandere Hierarchie: Ebene ${i}: ' || now() from xdummy;
 --umkopieren für Unterselect:
<@selectintotmp source="tmp_children" target="tmp_children2" select="*">
where ebene=${i}-1
</@selectintotmp> 
<@informixnolog/>;

insert into tmp_children(labnr,
labnr_parent,
labnr_root,
sourcesystem,
ebene)
select L.child_examplan_id,
T.labnr,
T.labnr_root,
T.sourcesystem,
${i}
from tmp_children2 T, lm_examrelation_neu L
where L.parent_examplan_id=T.labnr
and L.sourcesystem=T.sourcesystem;

drop table tmp_children2;

</#list>  
--nun enthält tmp_childen alle Kinder eines Top-Knoten.

delete from lm_examrelation where (sourcesystem=${Quellsystem_var}
or sourcesystem is null)
;

insert into lm_examrelation(id,
       sourcesystem,
       parent_examplan_id,
       child_examplan_id,
       unitrelationtype,
--       parent_unit_id,
--       unit_id,
       bonus,
       malus,
       pstatus,
       credits_used_for_weighting,
       is_approved,
        internal_accreditationtype,
       date_of_work,
       sem_der_pruefung
      ) select R.id,
R.sourcesystem,
R.parent_examplan_id,
R.child_examplan_id,
R.unitrelationtype,
--R.unit_id,
--S.unit_id,
R.bonus,
R.malus,
R.pstatus,
R.credits_used_for_weighting,
R.is_approved,
R.internal_accreditationtype,
R.date_of_work,
R.sem_der_pruefung
       from lm_examrelation_neu R ;
       

update lm_examrelation set top_examplan_id=T.labnr_root
from tmp_children T
where T.labnr_parent=lm_examrelation.parent_examplan_id
and lm_examrelation.sourcesystem=${Quellsystem_var};


update lm_examrelation set parent_unit_id=S.unit_id
from lm_examplan S
where S.id=lm_examrelation.parent_examplan_id
and S.sourcesystem=lm_examrelation.sourcesystem
and lm_examrelation.parent_unit_id is null
and lm_examrelation.sourcesystem=${Quellsystem_var};

update lm_examrelation set top_unit_id=S.unit_id
from lm_examplan S
where S.id=lm_examrelation.top_examplan_id
and S.sourcesystem=lm_examrelation.sourcesystem
and lm_examrelation.top_unit_id is null
and lm_examrelation.sourcesystem=${Quellsystem_var};

drop table tmp_root;
drop table tmp_children;
drop table tmp_alle_parents;


